/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import fi.tkk.ics.hadoop.bam.AnySAMInputFormat;
import fi.tkk.ics.hadoop.bam.SAMRecordWritable;
import fi.tkk.ics.hadoop.bam.util.SAMHeaderReader;
import java.util.Collection;
import java.util.regex.Pattern;
import net.sf.samtools.SAMFileHeader;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.converters.FastaConverter$;
import org.bdgenomics.adam.converters.SAMRecordConverter;
import org.bdgenomics.adam.instrumentation.ADAMMetricsListener;
import org.bdgenomics.adam.models.RecordGroupDictionary;
import org.bdgenomics.adam.models.RecordGroupDictionary$;
import org.bdgenomics.adam.models.Rod;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceDictionary$;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.predicates.ADAMPredicate;
import org.bdgenomics.adam.projections.AlignmentRecordField$;
import org.bdgenomics.adam.projections.FieldValue;
import org.bdgenomics.adam.projections.NucleotideContigFragmentField$;
import org.bdgenomics.adam.projections.Projection$;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMRDDFunctions;
import org.bdgenomics.adam.rdd.AlignmentRecordRDDFunctions;
import org.bdgenomics.adam.rdd.NucleotideContigFragmentRDDFunctions;
import org.bdgenomics.adam.rdd.PileupRDDFunctions;
import org.bdgenomics.adam.rdd.RodRDDFunctions;
import org.bdgenomics.adam.rich.RichAlignmentRecord;
import org.bdgenomics.adam.util.HadoopUtil$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.formats.avro.NucleotideContigFragment;
import org.bdgenomics.formats.avro.Pileup;
import org.slf4j.Logger;
import parquet.avro.AvroParquetInputFormat;
import parquet.avro.AvroReadSupport;
import parquet.filter.UnboundRecordFilter;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.util.ContextUtil;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011-t!B\u0001\u0003\u0011\u0003Y\u0011aC!E\u00036\u001buN\u001c;fqRT!a\u0001\u0003\u0002\u0007I$GM\u0003\u0002\u0006\r\u0005!\u0011\rZ1n\u0015\t9\u0001\"\u0001\u0006cI\u001e,gn\\7jGNT\u0011!C\u0001\u0004_J<7\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\f\u0003\u0012\u000bUjQ8oi\u0016DHoE\u0002\u000e!Y\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\t\u0018\u0013\tA\"C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u001b\u001b\u0011\u00051$\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017!)Q$\u0004C\u0002=\u0005I2\u000f]1sW\u000e{g\u000e^3yiR{\u0017\tR!N\u0007>tG/\u001a=u)\ry\"\u0011\f\t\u0003\u0019\u00012AA\u0004\u0002\u0001CM!\u0001\u0005\u0005\f#!\t\u0019\u0003&D\u0001%\u0015\t)c%A\u0003ta\u0006\u00148N\u0003\u0002(\u0011\u00051\u0011\r]1dQ\u0016L!!\u000b\u0013\u0003\u000f1{wmZ5oO\"A1\u0006\tBC\u0002\u0013\u0005A&\u0001\u0002tGV\tQ\u0006\u0005\u0002$]%\u0011q\u0006\n\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\tc\u0001\u0012\t\u0011)A\u0005[\u0005\u00191o\u0019\u0011\t\u000bi\u0001C\u0011A\u001a\u0015\u0005}!\u0004\"B\u00163\u0001\u0004i\u0003\"\u0002\u001c!\t\u00139\u0014!F1eC6\u0014\u0015-\u001c#jGRLwN\\1ss2{\u0017\r\u001a\u000b\u0003qy\u0002\"!\u000f\u001f\u000e\u0003iR!a\u000f\u0003\u0002\r5|G-\u001a7t\u0013\ti$H\u0001\nTKF,XM\\2f\t&\u001cG/[8oCJL\b\"B 6\u0001\u0004\u0001\u0015\u0001\u00034jY\u0016\u0004\u0016\r\u001e5\u0011\u0005\u0005#eBA\tC\u0013\t\u0019%#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u000b\u001a\u0013aa\u0015;sS:<'BA\"\u0013\u0011\u00151\u0004\u0005\"\u0003I)\tA\u0014\nC\u0003K\u000f\u0002\u00071*A\u0005tC6DU-\u00193feB\u0011AjU\u0007\u0002\u001b*\u0011ajT\u0001\tg\u0006lGo\\8mg*\u0011\u0001+U\u0001\u0003g\u001aT\u0011AU\u0001\u0004]\u0016$\u0018B\u0001+N\u00055\u0019\u0016)\u0014$jY\u0016DU-\u00193fe\")a\u000b\tC\u0005/\u0006)\u0012\rZ1n\u0005\u0006lGj\\1e%\u0016\fGm\u0012:pkB\u001cHC\u0001-\\!\tI\u0014,\u0003\u0002[u\t)\"+Z2pe\u0012<%o\\;q\t&\u001cG/[8oCJL\b\"\u0002&V\u0001\u0004Y\u0005BB/!\t#\u0011a,A\u0006bI\u0006l')Y7M_\u0006$GCA0m!\r\u0001'\rZ\u0007\u0002C*\u00111\u0001J\u0005\u0003G\u0006\u00141A\u0015#E!\t)'.D\u0001g\u0015\t9\u0007.\u0001\u0003bmJ|'BA5\u0007\u0003\u001d1wN]7biNL!a\u001b4\u0003\u001f\u0005c\u0017n\u001a8nK:$(+Z2pe\u0012DQa\u0010/A\u0002\u0001CQA\u001c\u0011\u0005\n=\fq\"\u00193b[B\u000b'/];fi2{\u0017\rZ\u000b\u0005aV\f\u0019\u0004F\u0004r\u0003?\t\t#!\u0013\u0015\tIt\u0018Q\u0003\t\u0004A\n\u001c\bC\u0001;v\u0019\u0001!QA^7C\u0002]\u0014\u0011\u0001V\t\u0003qn\u0004\"!E=\n\u0005i\u0014\"a\u0002(pi\"Lgn\u001a\t\u0003#qL!! \n\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0000[\u0006\u0005\t9AA\u0001\u0003))g/\u001b3f]\u000e,Ge\r\t\u0007#\u0005\r1/a\u0002\n\u0007\u0005\u0015!CA\u0005Gk:\u001cG/[8ocA!\u0011\u0011BA\t\u001b\t\tYA\u0003\u0003\u0002\u000e\u0005=\u0011\u0001C:qK\u000eLg-[2\u000b\u0005\u001d4\u0013\u0002BA\n\u0003\u0017\u0011ab\u00159fG&4\u0017n\u0019*fG>\u0014H\rC\u0005\u0002\u00185\f\t\u0011q\u0001\u0002\u001a\u0005QQM^5eK:\u001cW\r\n\u001b\u0011\t\u0005\u000bYb]\u0005\u0004\u0003;1%\u0001C'b]&4Wm\u001d;\t\u000b}j\u0007\u0019\u0001!\t\u0013\u0005\rR\u000e%AA\u0002\u0005\u0015\u0012!\u00039sK\u0012L7-\u0019;f!\u0015\t\u0012qEA\u0016\u0013\r\tIC\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000b\u0005\u000bi#!\r\n\u0007\u0005=bIA\u0003DY\u0006\u001c8\u000fE\u0002u\u0003g!q!!\u000en\u0005\u0004\t9DA\u0001V#\rA\u0018\u0011\b\t\u0005\u0003w\t)%\u0004\u0002\u0002>)!\u0011qHA!\u0003\u00191\u0017\u000e\u001c;fe*\u0011\u00111I\u0001\ba\u0006\u0014\u0018/^3u\u0013\u0011\t9%!\u0010\u0003'Us'm\\;oIJ+7m\u001c:e\r&dG/\u001a:\t\u0013\u0005-S\u000e%AA\u0002\u00055\u0013A\u00039s_*,7\r^5p]B)\u0011#a\n\u0002PA!\u0011\u0011KA*\u001b\t\ty!\u0003\u0003\u0002V\u0005=!AB*dQ\u0016l\u0017\rC\u0004\u0002Z\u0001\"\t!a\u0017\u0002%\u0005$\u0017-\u001c#jGRLwN\\1ss2{\u0017\rZ\u000b\u0005\u0003;\nI\u0007\u0006\u0003\u0002`\u0005ED#\u0002\u001d\u0002b\u0005-\u0004BCA2\u0003/\n\t\u0011q\u0001\u0002f\u0005QQM^5eK:\u001cW\rJ\u001b\u0011\u000fE\t\u0019!a\u001a\u0002\bA\u0019A/!\u001b\u0005\rY\f9F1\u0001x\u0011)\ti'a\u0016\u0002\u0002\u0003\u000f\u0011qN\u0001\u000bKZLG-\u001a8dK\u00122\u0004#B!\u0002\u001c\u0005\u001d\u0004BB \u0002X\u0001\u0007\u0001\tC\u0004\u0002v\u0001\"\t!a\u001e\u0002\u0011\u0005$\u0017-\u001c'pC\u0012,b!!\u001f\u0002\u0002\u0006eE\u0003CA>\u0003\u001f\u000b\t*!+\u0015\r\u0005u\u00141QAE!\u0011\u0001'-a \u0011\u0007Q\f\t\t\u0002\u0004w\u0003g\u0012\ra\u001e\u0005\u000b\u0003\u000b\u000b\u0019(!AA\u0004\u0005\u001d\u0015AC3wS\u0012,gnY3%oA9\u0011#a\u0001\u0002\u0000\u0005\u001d\u0001BCAF\u0003g\n\t\u0011q\u0001\u0002\u000e\u0006QQM^5eK:\u001cW\r\n\u001d\u0011\u000b\u0005\u000bY\"a \t\r}\n\u0019\b1\u0001A\u0011)\t\u0019#a\u001d\u0011\u0002\u0003\u0007\u00111\u0013\t\u0006#\u0005\u001d\u0012Q\u0013\t\u0006\u0003\u00065\u0012q\u0013\t\u0004i\u0006eE\u0001CA\u001b\u0003g\u0012\r!a'\u0012\u0007a\fi\n\u0005\u0004\u0002 \u0006\u0015\u0016qP\u0007\u0003\u0003CS1!a)\u0005\u0003)\u0001(/\u001a3jG\u0006$Xm]\u0005\u0005\u0003O\u000b\tKA\u0007B\t\u0006k\u0005K]3eS\u000e\fG/\u001a\u0005\u000b\u0003\u0017\n\u0019\b%AA\u0002\u00055\u0003bBAWA\u0011\u0005\u0011qV\u0001\u0011C\u0012\fWnU3rk\u0016t7-\u001a'pC\u0012$b!!-\u0002:\u0006m\u0006\u0003\u00021c\u0003g\u00032!ZA[\u0013\r\t9L\u001a\u0002\u0019\u001dV\u001cG.Z8uS\u0012,7i\u001c8uS\u001e4%/Y4nK:$\bBB \u0002,\u0002\u0007\u0001\t\u0003\u0005\u0002>\u0006-\u0006\u0019AA`\u000391'/Y4nK:$H*\u001a8hi\"\u00042!EAa\u0013\r\t\u0019M\u0005\u0002\u0005\u0019>tw\rC\u0004\u0002H\u0002\"\t!!3\u0002\u0013\u0019Lg\u000e\u001a$jY\u0016\u001cHCBAf\u0003g\f9\u0010\u0005\u0004\u0002N\u0006u\u00171\u001d\b\u0005\u0003\u001f\fIN\u0004\u0003\u0002R\u0006]WBAAj\u0015\r\t)NC\u0001\u0007yI|w\u000e\u001e \n\u0003MI1!a7\u0013\u0003\u001d\u0001\u0018mY6bO\u0016LA!a8\u0002b\n\u00191+Z9\u000b\u0007\u0005m'\u0003\u0005\u0003\u0002f\u0006=XBAAt\u0015\u0011\tI/a;\u0002\u0005\u0019\u001c(bAAwM\u00051\u0001.\u00193p_BLA!!=\u0002h\n!\u0001+\u0019;i\u0011!\t)0!2A\u0002\u0005\r\u0018\u0001\u00029bi\"Dq!!?\u0002F\u0002\u0007\u0001)A\u0003sK\u001e,\u0007\u0010C\u0004\u0002~\u0002\"\t!a@\u0002#1|\u0017\rZ!E\u000363%o\\7QCRD7\u000fF\u0002`\u0005\u0003A\u0001Ba\u0001\u0002|\u0002\u0007\u00111Z\u0001\u0006a\u0006$\bn\u001d\u0005\n\u0005\u000f\u0001\u0013\u0013!C\u0005\u0005\u0013\t\u0011$\u00193b[B\u000b'/];fi2{\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%eU1!1\u0002B\u0014\u0005S)\"A!\u0004+\t\t=!Q\u0003\b\u0004#\tE\u0011b\u0001B\n%\u0005!aj\u001c8fW\t\u00119\u0002\u0005\u0003\u0003\u001a\t\rRB\u0001B\u000e\u0015\u0011\u0011iBa\b\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0011%\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015\"1\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GA\u0002<\u0003\u0006\t\u0007q\u000f\u0002\u0005\u00026\t\u0015!\u0019AA\u001c\u0011%\u0011i\u0003II\u0001\n\u0013\u0011y#A\rbI\u0006l\u0007+\u0019:rk\u0016$Hj\\1eI\u0011,g-Y;mi\u0012\u001aTC\u0002B\u0019\u0005k\u00119$\u0006\u0002\u00034)\"\u0011Q\nB\u000b\t\u00191(1\u0006b\u0001o\u0012A\u0011Q\u0007B\u0016\u0005\u0004\t9\u0004C\u0005\u0003<\u0001\n\n\u0011\"\u0001\u0003>\u0005\u0011\u0012\rZ1n\u0019>\fG\r\n3fM\u0006,H\u000e\u001e\u00133+\u0019\u0011YAa\u0010\u0003B\u00111aO!\u000fC\u0002]$\u0001\"!\u000e\u0003:\t\u0007!1I\t\u0004q\n\u0015\u0003CBAP\u0003K\u00139\u0005E\u0002u\u0005\u007fA\u0011Ba\u0013!#\u0003%\tA!\u0014\u0002%\u0005$\u0017-\u001c'pC\u0012$C-\u001a4bk2$HeM\u000b\u0007\u0005c\u0011yE!\u0015\u0005\rY\u0014IE1\u0001x\t!\t)D!\u0013C\u0002\tM\u0013c\u0001=\u0003VA1\u0011qTAS\u0005/\u00022\u0001\u001eB(\u0011\u0015YC\u00041\u0001.\u0011\u001d\u0011i&\u0004C\u0002\u0005?\n!C\u001d3e)>\fE)Q'SK\u000e|'\u000f\u001a*E\tR!!\u0011\rB4!\ra!1M\u0005\u0004\u0005K\u0012!aG!mS\u001etW.\u001a8u%\u0016\u001cwN\u001d3S\t\u00123UO\\2uS>t7\u000f\u0003\u0004\u0004\u00057\u0002\ra\u0018\u0005\b\u0005WjA1\u0001B7\u0003I\u0011H\r\u001a+p\u0003\u0012\u000bU\nU5mKV\u0004(\u000b\u0012#\u0015\t\t=$Q\u000f\t\u0004\u0019\tE\u0014b\u0001B:\u0005\t\u0011\u0002+\u001b7fkB\u0014F\t\u0012$v]\u000e$\u0018n\u001c8t\u0011\u001d\u0019!\u0011\u000ea\u0001\u0005o\u0002B\u0001\u00192\u0003zA\u0019QMa\u001f\n\u0007\tudM\u0001\u0004QS2,W\u000f\u001d\u0005\b\u0005\u0003kA1\u0001BB\u0003-\u0011H\r\u001a+p%>$'\u000b\u0012#\u0015\t\t\u0015%1\u0012\t\u0004\u0019\t\u001d\u0015b\u0001BE\u0005\ty!k\u001c3S\t\u00123UO\\2uS>t7\u000fC\u0004\u0004\u0005\u007f\u0002\rA!$\u0011\t\u0001\u0014'q\u0012\t\u0004s\tE\u0015b\u0001BJu\t\u0019!k\u001c3\t\u000f\t]U\u0002b\u0001\u0003\u001a\u0006a!\u000f\u001a3U_\u0006#\u0015)\u0014*E\tV!!1\u0014BT)\u0011\u0011iJ!.\u0015\r\t}%\u0011\u0016BX!\u0015a!\u0011\u0015BS\u0013\r\u0011\u0019K\u0001\u0002\u0011\u0003\u0012\u000bUJ\u0015#E\rVt7\r^5p]N\u00042\u0001\u001eBT\t\u00191(Q\u0013b\u0001o\"Q!1\u0016BK\u0003\u0003\u0005\u001dA!,\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0004\u0012\u0003\u0007\u0011)+a\u0002\t\u0015\tE&QSA\u0001\u0002\b\u0011\u0019,\u0001\u0006fm&$WM\\2fII\u0002R!QA\u000e\u0005KCqa\u0001BK\u0001\u0004\u00119\f\u0005\u0003aE\n\u0015\u0006b\u0002BL\u001b\u0011\r!1\u0018\u000b\u0005\u0005{\u0013\u0019\rE\u0002\r\u0005\u007fK1A!1\u0003\u0005\u0011rUo\u00197f_RLG-Z\"p]RLwM\u0012:bO6,g\u000e\u001e*E\t\u001a+hn\u0019;j_:\u001c\bbB\u0002\u0003:\u0002\u0007\u0011\u0011\u0017\u0005\b\u0005\u000flA1\u0001Be\u0003I\u0011XmY8sIR{'+[2i%\u0016\u001cwN\u001d3\u0015\t\t-'q\u001b\t\u0005\u0005\u001b\u0014\u0019.\u0004\u0002\u0003P*\u0019!\u0011\u001b\u0003\u0002\tIL7\r[\u0005\u0005\u0005+\u0014yMA\nSS\u000eD\u0017\t\\5h]6,g\u000e\u001e*fG>\u0014H\rC\u0004\u0003Z\n\u0015\u0007\u0019\u00013\u0002\rI,7m\u001c:e\u0011\u001d\u0011i.\u0004C\u0002\u0005?\fa\u0002\\5tiR{'*\u0019<b\u0019&\u001cH/\u0006\u0003\u0003b\nUH\u0003\u0002Br\u0005s\u0004bA!:\u0003p\nMXB\u0001Bt\u0015\u0011\u0011IOa;\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0005[\fAA[1wC&!!\u0011\u001fBt\u0005\u0011a\u0015n\u001d;\u0011\u0007Q\u0014)\u0010B\u0004\u0003x\nm'\u0019A<\u0003\u0003\u0005C\u0001Ba?\u0003\\\u0002\u0007!Q`\u0001\u0005Y&\u001cH\u000f\u0005\u0004\u0002N\n}(1_\u0005\u0005\u0005c\f\t\u000fC\u0004\u0004\u00045!\u0019a!\u0002\u0002\u001d)\fg/\u0019'jgR$v\u000eT5tiV!1qAB\u0007)\u0011\u0019Iaa\u0004\u0011\r\u00055'q`B\u0006!\r!8Q\u0002\u0003\b\u0005o\u001c\tA1\u0001x\u0011!\u0011Yp!\u0001A\u0002\rE\u0001C\u0002Bs\u0005_\u001cY\u0001C\u0004\u0004\u00165!\u0019aa\u0006\u0002\u0019)\fg/Y*fiR{7+\u001a;\u0016\t\re11\u0005\u000b\u0005\u00077\u0019)\u0003E\u0003B\u0007;\u0019\t#C\u0002\u0004 \u0019\u00131aU3u!\r!81\u0005\u0003\b\u0005o\u001c\u0019B1\u0001x\u0011!\u00199ca\u0005A\u0002\r%\u0012aA:fiB1!Q]B\u0016\u0007CIAaa\b\u0003h\"91qF\u0007\u0005\u0004\rE\u0012\u0001G5oi2K7\u000f\u001e+p\u0015\u00064\u0018-\u00138uK\u001e,'\u000fT5tiR!11GB!!\u0019\u0011)Oa<\u00046A!1qGB\u001f\u001b\t\u0019ID\u0003\u0003\u0004<\t-\u0018\u0001\u00027b]\u001eLAaa\u0010\u0004:\t9\u0011J\u001c;fO\u0016\u0014\b\u0002\u0003B~\u0007[\u0001\raa\u0011\u0011\r\u00055'q`B#!\r\t2qI\u0005\u0004\u0007\u0013\u0012\"aA%oi\"91QJ\u0007\u0005\u0004\r=\u0013\u0001F2iCJ\u001cV-];f]\u000e,Gk\\*ue&tw\rF\u0002A\u0007#B\u0001ba\u0015\u0004L\u0001\u00071QK\u0001\u0003GN\u0004Baa\u000e\u0004X%!1\u0011LB\u001d\u00051\u0019\u0005.\u0019:TKF,XM\\2f\u0011\u001d\u0019i&\u0004C\u0002\u0007?\n!c\u00195beN+\u0017/^3oG\u0016$v\u000eT5tiR!1\u0011MB5!\u0019\tiMa@\u0004dA\u0019\u0011c!\u001a\n\u0007\r\u001d$C\u0001\u0003DQ\u0006\u0014\b\u0002CB*\u00077\u0002\ra!\u0016\t\u000f\r5T\u0002b\u0001\u0004p\u0005aQ.\u00199U_*\u000bg/Y'baV11\u0011OB>\u0007\u007f\"Baa\u001d\u0004\u0004BA!Q]B;\u0007s\u001ai(\u0003\u0003\u0004x\t\u001d(aA'baB\u0019Aoa\u001f\u0005\u000f\t]81\u000eb\u0001oB\u0019Aoa \u0005\u000f\r\u000551\u000eb\u0001o\n\t!\t\u0003\u0005\u0004\u0006\u000e-\u0004\u0019ABD\u0003\ri\u0017\r\u001d\t\t\u0007\u0013\u001byi!\u001f\u0004~5\u001111\u0012\u0006\u0004\u0007\u001b\u0013\u0012AC2pY2,7\r^5p]&!1qOBF\u0011\u001d\u0019\u0019*\u0004C\u0002\u0007+\u000bAB[1wC6\u000b\u0007\u000fV8NCB,baa&\u0004\u001e\u000e\u0005F\u0003BBM\u0007G\u0003\u0002b!#\u0004\u0010\u000em5q\u0014\t\u0004i\u000euEa\u0002B|\u0007#\u0013\ra\u001e\t\u0004i\u000e\u0005FaBBA\u0007#\u0013\ra\u001e\u0005\t\u0007\u000b\u001b\t\n1\u0001\u0004&BA!Q]B;\u00077\u001by\nC\u0004\u0004*6!\u0019aa+\u00021%$XM]1cY\u0016$vNS1wC\u000e{G\u000e\\3di&|g.\u0006\u0003\u0004.\u000e]F\u0003BBX\u0007s\u0003bA!:\u00042\u000eU\u0016\u0002BBZ\u0005O\u0014!bQ8mY\u0016\u001cG/[8o!\r!8q\u0017\u0003\b\u0005o\u001c9K1\u0001x\u0011!\u0019Yla*A\u0002\ru\u0016!A5\u0011\r\u000557qXB[\u0013\u0011\u0019\t-!9\u0003\u0011%#XM]1cY\u0016Dqa!2\u000e\t\u0007\u00199-\u0001\u0007tKR$vNS1wCN+G/\u0006\u0003\u0004J\u000e=G\u0003BBf\u0007#\u0004bA!:\u0004,\r5\u0007c\u0001;\u0004P\u00129!q_Bb\u0005\u00049\b\u0002CB\u0014\u0007\u0007\u0004\raa5\u0011\u000b\u0005\u001bib!4\t\u000f\r]W\u0002\"\u0001\u0004Z\u0006\u00112M]3bi\u0016\u001c\u0006/\u0019:l\u0007>tG/\u001a=u)Ui31\\Bp\u0007G\u001c9o!<\u0004z\u0012\rAq\u0001C\r\t;Aqa!8\u0004V\u0002\u0007\u0001)\u0001\u0003oC6,\u0007bBBq\u0007+\u0004\r\u0001Q\u0001\u0007[\u0006\u001cH/\u001a:\t\u0013\r\u00158Q\u001bI\u0001\u0002\u0004\u0001\u0015!C:qCJ\\\u0007j\\7f\u0011)\u0019Io!6\u0011\u0002\u0003\u000711^\u0001\ngB\f'o\u001b&beN\u0004R!!4\u0002^\u0002C!ba<\u0004VB\u0005\t\u0019ABy\u00031\u0019\b/\u0019:l\u000b:4h+\u0019:t!\u0019\ti-!8\u0004tB)\u0011c!>A\u0001&\u00191q\u001f\n\u0003\rQ+\b\u000f\\33\u0011)\u0019Yp!6\u0011\u0002\u0003\u00071Q`\u0001\u0016gB\f'o[!eIN#\u0018\r^:MSN$XM\\3s!\r\t2q`\u0005\u0004\t\u0003\u0011\"a\u0002\"p_2,\u0017M\u001c\u0005\u000b\t\u000b\u0019)\u000e%AA\u0002\r\u0015\u0013aE:qCJ\\7J]=p\u0005V4g-\u001a:TSj,\u0007B\u0003C\u0005\u0007+\u0004\n\u00111\u0001\u0005\f\u0005!2\u000f]1sW6+GO]5dg2K7\u000f^3oKJ\u0004R!EA\u0014\t\u001b\u0001B\u0001b\u0004\u0005\u00165\u0011A\u0011\u0003\u0006\u0004\t'!\u0011aD5ogR\u0014X/\\3oi\u0006$\u0018n\u001c8\n\t\u0011]A\u0011\u0003\u0002\u0014\u0003\u0012\u000bU*T3ue&\u001c7\u000fT5ti\u0016tWM\u001d\u0005\u000b\t7\u0019)\u000e%AA\u0002\ru\u0018\u0001\u00057pC\u0012\u001c\u0016p\u001d;f[Z\u000bG.^3t\u0011)!yb!6\u0011\u0002\u0003\u0007A\u0011E\u0001\u0010gB\f'o\u001b#sSZ,'\u000fU8siB)\u0011#a\n\u0004F!IAQE\u0007\u0012\u0002\u0013\u0005AqE\u0001\u001dGJ,\u0017\r^3Ta\u0006\u00148nQ8oi\u0016DH\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t!ICK\u0002A\u0005+A\u0011\u0002\"\f\u000e#\u0003%\t\u0001b\f\u00029\r\u0014X-\u0019;f'B\f'o[\"p]R,\u0007\u0010\u001e\u0013eK\u001a\fW\u000f\u001c;%iU\u0011A\u0011\u0007\u0016\u0005\u0007W\u0014)\u0002C\u0005\u000565\t\n\u0011\"\u0001\u00058\u0005a2M]3bi\u0016\u001c\u0006/\u0019:l\u0007>tG/\u001a=uI\u0011,g-Y;mi\u0012*TC\u0001C\u001dU\u0011\u0019\tP!\u0006\t\u0013\u0011uR\"%A\u0005\u0002\u0011}\u0012\u0001H2sK\u0006$Xm\u00159be.\u001cuN\u001c;fqR$C-\u001a4bk2$HEN\u000b\u0003\t\u0003RCa!@\u0003\u0016!IAQI\u0007\u0012\u0002\u0013\u0005AqI\u0001\u001dGJ,\u0017\r^3Ta\u0006\u00148nQ8oi\u0016DH\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t!IE\u000b\u0003\u0004F\tU\u0001\"\u0003C'\u001bE\u0005I\u0011\u0001C(\u0003q\u0019'/Z1uKN\u0003\u0018M]6D_:$X\r\u001f;%I\u00164\u0017-\u001e7uIa*\"\u0001\"\u0015+\t\u0011-!Q\u0003\u0005\n\t+j\u0011\u0013!C\u0001\t\u007f\tAd\u0019:fCR,7\u000b]1sW\u000e{g\u000e^3yi\u0012\"WMZ1vYR$\u0013\bC\u0005\u0005Z5\t\n\u0011\"\u0001\u0005\\\u0005i2M]3bi\u0016\u001c\u0006/\u0019:l\u0007>tG/\u001a=uI\u0011,g-Y;mi\u0012\n\u0004'\u0006\u0002\u0005^)\"A\u0011\u0005B\u000b\u0011%!\t'DA\u0001\n\u0013!\u0019'A\u0006sK\u0006$'+Z:pYZ,GC\u0001C3!\u0011\u00199\u0004b\u001a\n\t\u0011%4\u0011\b\u0002\u0007\u001f\nTWm\u0019;")
public class ADAMContext
implements Serializable,
Logging {
    private final SparkContext sc;
    private transient Logger org$apache$spark$Logging$$log_;

    public static Option<Object> createSparkContext$default$10() {
        return ADAMContext$.MODULE$.createSparkContext$default$10();
    }

    public static boolean createSparkContext$default$9() {
        return ADAMContext$.MODULE$.createSparkContext$default$9();
    }

    public static Option<ADAMMetricsListener> createSparkContext$default$8() {
        return ADAMContext$.MODULE$.createSparkContext$default$8();
    }

    public static int createSparkContext$default$7() {
        return ADAMContext$.MODULE$.createSparkContext$default$7();
    }

    public static boolean createSparkContext$default$6() {
        return ADAMContext$.MODULE$.createSparkContext$default$6();
    }

    public static Seq<Tuple2<String, String>> createSparkContext$default$5() {
        return ADAMContext$.MODULE$.createSparkContext$default$5();
    }

    public static Seq<String> createSparkContext$default$4() {
        return ADAMContext$.MODULE$.createSparkContext$default$4();
    }

    public static String createSparkContext$default$3() {
        return ADAMContext$.MODULE$.createSparkContext$default$3();
    }

    public static SparkContext createSparkContext(String string, String string2, String string3, Seq<String> seq, Seq<Tuple2<String, String>> seq2, boolean bl, int n, Option<ADAMMetricsListener> option, boolean bl2, Option<Object> option2) {
        return ADAMContext$.MODULE$.createSparkContext(string, string2, string3, seq, seq2, bl, n, option, bl2, option2);
    }

    public static <A> java.util.Set<A> setToJavaSet(scala.collection.immutable.Set<A> set) {
        return ADAMContext$.MODULE$.setToJavaSet(set);
    }

    public static <A> Collection<A> iterableToJavaCollection(Iterable<A> iterable) {
        return ADAMContext$.MODULE$.iterableToJavaCollection(iterable);
    }

    public static <A, B> Map<A, B> javaMapToMap(java.util.Map<A, B> map) {
        return ADAMContext$.MODULE$.javaMapToMap(map);
    }

    public static <A, B> java.util.Map<A, B> mapToJavaMap(Map<A, B> map) {
        return ADAMContext$.MODULE$.mapToJavaMap(map);
    }

    public static List<Object> charSequenceToList(CharSequence charSequence) {
        return ADAMContext$.MODULE$.charSequenceToList(charSequence);
    }

    public static String charSequenceToString(CharSequence charSequence) {
        return ADAMContext$.MODULE$.charSequenceToString(charSequence);
    }

    public static java.util.List<Integer> intListToJavaIntegerList(List<Object> list) {
        return ADAMContext$.MODULE$.intListToJavaIntegerList(list);
    }

    public static <A> scala.collection.immutable.Set<A> javaSetToSet(java.util.Set<A> set) {
        return ADAMContext$.MODULE$.javaSetToSet(set);
    }

    public static <A> List<A> javaListToList(java.util.List<A> list) {
        return ADAMContext$.MODULE$.javaListToList(list);
    }

    public static <A> java.util.List<A> listToJavaList(List<A> list) {
        return ADAMContext$.MODULE$.listToJavaList(list);
    }

    public static RichAlignmentRecord recordToRichRecord(AlignmentRecord alignmentRecord) {
        return ADAMContext$.MODULE$.recordToRichRecord(alignmentRecord);
    }

    public static NucleotideContigFragmentRDDFunctions rddToADAMRDD(RDD<NucleotideContigFragment> rDD) {
        return ADAMContext$.MODULE$.rddToADAMRDD(rDD);
    }

    public static <T> ADAMRDDFunctions<T> rddToADAMRDD(RDD<T> rDD, Function1<T, SpecificRecord> function1, Manifest<T> manifest) {
        return ADAMContext$.MODULE$.rddToADAMRDD(rDD, function1, manifest);
    }

    public static RodRDDFunctions rddToRodRDD(RDD<Rod> rDD) {
        return ADAMContext$.MODULE$.rddToRodRDD(rDD);
    }

    public static PileupRDDFunctions rddToADAMPileupRDD(RDD<Pileup> rDD) {
        return ADAMContext$.MODULE$.rddToADAMPileupRDD(rDD);
    }

    public static AlignmentRecordRDDFunctions rddToADAMRecordRDD(RDD<AlignmentRecord> rDD) {
        return ADAMContext$.MODULE$.rddToADAMRecordRDD(rDD);
    }

    public static ADAMContext sparkContextToADAMContext(SparkContext sparkContext) {
        return ADAMContext$.MODULE$.sparkContextToADAMContext(sparkContext);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public SparkContext sc() {
        return this.sc;
    }

    private SequenceDictionary adamBamDictionaryLoad(String filePath) {
        SAMFileHeader samHeader = SAMHeaderReader.readSAMHeaderFrom((Path)new Path(filePath), (Configuration)this.sc().hadoopConfiguration());
        return this.adamBamDictionaryLoad(samHeader);
    }

    private SequenceDictionary adamBamDictionaryLoad(SAMFileHeader samHeader) {
        return SequenceDictionary$.MODULE$.apply(samHeader);
    }

    private RecordGroupDictionary adamBamLoadReadGroups(SAMFileHeader samHeader) {
        return RecordGroupDictionary$.MODULE$.fromSAMHeader(samHeader);
    }

    public RDD<AlignmentRecord> adamBamLoad(String filePath) {
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Reading legacy BAM file format %s to create RDD")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        SAMFileHeader samHeader = SAMHeaderReader.readSAMHeaderFrom((Path)new Path(filePath), (Configuration)this.sc().hadoopConfiguration());
        SequenceDictionary seqDict = this.adamBamDictionaryLoad(samHeader);
        RecordGroupDictionary readGroups = this.adamBamLoadReadGroups(samHeader);
        Job job = HadoopUtil$.MODULE$.newJob(this.sc());
        RDD records = this.sc().newAPIHadoopFile(filePath, AnySAMInputFormat.class, LongWritable.class, SAMRecordWritable.class, ContextUtil.getConfiguration((JobContext)job));
        SAMRecordConverter samRecordConverter = new SAMRecordConverter();
        return records.map((Function1)new Serializable(this, seqDict, readGroups, samRecordConverter){
            public static final long serialVersionUID = 0L;
            private final SequenceDictionary seqDict$1;
            private final RecordGroupDictionary readGroups$1;
            private final SAMRecordConverter samRecordConverter$1;

            public final AlignmentRecord apply(Tuple2<LongWritable, SAMRecordWritable> p) {
                return this.samRecordConverter$1.convert(((SAMRecordWritable)p._2()).get(), this.seqDict$1, this.readGroups$1);
            }
            {
                this.seqDict$1 = seqDict$1;
                this.readGroups$1 = readGroups$1;
                this.samRecordConverter$1 = samRecordConverter$1;
            }
        }, ClassTag$.MODULE$.apply(AlignmentRecord.class));
    }

    private <T, U extends UnboundRecordFilter> RDD<T> adamParquetLoad(String filePath, Option<Class<U>> predicate, Option<Schema> projection, Function1<T, SpecificRecord> evidence$3, Manifest<T> evidence$4) {
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Reading the ADAM file at %s to create RDD")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        Job job = HadoopUtil$.MODULE$.newJob(this.sc());
        ParquetInputFormat.setReadSupportClass((Job)job, AvroReadSupport.class);
        if (predicate.isDefined()) {
            this.log().info("Using the specified push-down predicate");
            ParquetInputFormat.setUnboundRecordFilter((Job)job, (Class)((Class)predicate.get()));
        }
        if (projection.isDefined()) {
            this.log().info("Using the specified projection schema");
            AvroParquetInputFormat.setRequestedProjection((Job)job, (Schema)((Schema)projection.get()));
        }
        RDD records = this.sc().newAPIHadoopFile(filePath, ParquetInputFormat.class, Void.class, Predef$.MODULE$.manifest(evidence$4).runtimeClass(), ContextUtil.getConfiguration((JobContext)job)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final T apply(Tuple2<Void, T> p) {
                return (T)p._2();
            }
        }, evidence$4);
        return predicate.isDefined() ? records.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(T p) {
                return p != null;
            }
        }) : records;
    }

    private <T, U extends UnboundRecordFilter> None$ adamParquetLoad$default$2() {
        return None$.MODULE$;
    }

    private <T, U extends UnboundRecordFilter> Option<Schema> adamParquetLoad$default$3() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> SequenceDictionary adamDictionaryLoad(String filePath, Function1<T, SpecificRecord> evidence$5, Manifest<T> evidence$6) {
        SequenceDictionary sequenceDictionary;
        Schema projection;
        boolean isADAMRecord = AlignmentRecord.class.isAssignableFrom(Predef$.MODULE$.manifest(evidence$6).runtimeClass());
        boolean isADAMContig = NucleotideContigFragment.class.isAssignableFrom(Predef$.MODULE$.manifest(evidence$6).runtimeClass());
        Schema schema = isADAMRecord ? Projection$.MODULE$.apply((Seq<FieldValue>)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{AlignmentRecordField$.MODULE$.contig(), AlignmentRecordField$.MODULE$.mateContig(), AlignmentRecordField$.MODULE$.readPaired(), AlignmentRecordField$.MODULE$.firstOfPair(), AlignmentRecordField$.MODULE$.readMapped(), AlignmentRecordField$.MODULE$.mateMapped()})) : (projection = isADAMContig ? Projection$.MODULE$.apply((Seq<FieldValue>)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{NucleotideContigFragmentField$.MODULE$.contig()})) : Projection$.MODULE$.apply((Seq<FieldValue>)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{AlignmentRecordField$.MODULE$.contig()})));
        if (filePath.endsWith(".bam") || filePath.endsWith(".sam")) {
            if (!isADAMRecord) throw new IllegalArgumentException("If you're reading a BAM/SAM file, the record type must be Read");
            sequenceDictionary = this.adamBamDictionaryLoad(filePath);
            return sequenceDictionary;
        } else {
            SequenceDictionary dict;
            RDD<T> projected = this.adamParquetLoad(filePath, (Option)None$.MODULE$, (Option<Schema>)new Some((Object)projection), evidence$5, evidence$6);
            RDD recs = isADAMRecord ? projected.distinct().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Set<SequenceRecord> apply(AlignmentRecord rec) {
                    return SequenceRecord$.MODULE$.fromADAMRecord(rec);
                }
            }, ClassTag$.MODULE$.apply(SequenceRecord.class)) : (isADAMContig ? projected.distinct().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceRecord apply(NucleotideContigFragment ctg) {
                    return SequenceRecord$.MODULE$.fromADAMContigFragment(ctg);
                }
            }, ClassTag$.MODULE$.apply(SequenceRecord.class)) : projected.distinct().map((Function1)new Serializable(this, evidence$5){
                public static final long serialVersionUID = 0L;
                private final Function1 evidence$5$1;

                public final SequenceRecord apply(T x$2) {
                    return SequenceRecord$.MODULE$.fromSpecificRecord((SpecificRecord)this.evidence$5$1.apply(x$2));
                }
                {
                    this.evidence$5$1 = evidence$5$1;
                }
            }, ClassTag$.MODULE$.apply(SequenceRecord.class)));
            sequenceDictionary = dict = (SequenceDictionary)recs.aggregate((Object)SequenceDictionary$.MODULE$.apply(), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceDictionary apply(SequenceDictionary dict, SequenceRecord rec) {
                    return dict.$plus(rec);
                }
            }, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceDictionary apply(SequenceDictionary dict1, SequenceDictionary dict2) {
                    return dict1.$plus$plus(dict2);
                }
            }, ClassTag$.MODULE$.apply(SequenceDictionary.class));
        }
        return sequenceDictionary;
    }

    public <T, U extends ADAMPredicate<T>> RDD<T> adamLoad(String filePath, Option<Class<U>> predicate, Option<Schema> projection, Function1<T, SpecificRecord> evidence$7, Manifest<T> evidence$8) {
        Object object;
        if (filePath.endsWith(".bam") || filePath.endsWith(".sam") && AlignmentRecord.class.isAssignableFrom(Predef$.MODULE$.manifest(evidence$8).runtimeClass())) {
            if (projection.isDefined()) {
                this.log().warn("Projection is ignored when loading a BAM file");
            }
            RDD<AlignmentRecord> reads = this.adamBamLoad(filePath);
            if (predicate.isDefined()) {
                Class predicateClass = (Class)predicate.get();
                ADAMPredicate filter = (ADAMPredicate)predicateClass.newInstance();
                object = filter.apply(reads);
            } else {
                object = reads;
            }
        } else {
            object = this.adamParquetLoad(filePath, predicate, projection, evidence$7, evidence$8);
        }
        return object;
    }

    public <T, U extends ADAMPredicate<T>> None$ adamLoad$default$2() {
        return None$.MODULE$;
    }

    public <T, U extends ADAMPredicate<T>> Option<Schema> adamLoad$default$3() {
        return None$.MODULE$;
    }

    public RDD<NucleotideContigFragment> adamSequenceLoad(String filePath, long fragmentLength) {
        Object object;
        if (filePath.endsWith(".fasta") || filePath.endsWith(".fa")) {
            RDD fastaData = this.sc().newAPIHadoopFile(filePath, TextInputFormat.class, LongWritable.class, Text.class, this.sc().newAPIHadoopFile$default$5());
            RDD remapData = fastaData.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, String> apply(Tuple2<LongWritable, Text> kv) {
                    return new Tuple2((Object)BoxesRunTime.boxToLong((long)((LongWritable)kv._1()).get()), (Object)((Text)kv._2()).toString());
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            this.log().info("Converting FASTA to ADAM.");
            object = FastaConverter$.MODULE$.apply((RDD<Tuple2<Object, String>>)remapData, fragmentLength);
        } else {
            object = this.adamParquetLoad(filePath, (Option)this.adamParquetLoad$default$2(), this.adamParquetLoad$default$3(), (Function1)Predef$.MODULE$.conforms(), (Manifest)ManifestFactory$.MODULE$.classType(NucleotideContigFragment.class));
        }
        return object;
    }

    public Seq<Path> findFiles(Path path, String regex) {
        Tuple2 tuple2;
        block4: {
            Seq seq;
            block3: {
                Tuple2 tuple22;
                block2: {
                    if (regex != null) break block2;
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{path}));
                    break block3;
                }
                FileStatus[] statuses = FileSystem.get((Configuration)this.sc().hadoopConfiguration()).listStatus(path);
                Pattern r = Pattern.compile(regex);
                tuple2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])statuses).filter((Function1)new $anonfun$8(this))).map((Function1)new $anonfun$9(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))).partition((Function1)new $anonfun$10(this, r));
                if (tuple2 == null) break block4;
                Path[] matches = (Path[])tuple2._1();
                Path[] recurse = (Path[])tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)matches, (Object)recurse);
                Path[] matches2 = (Path[])tuple23._1();
                Path[] recurse2 = (Path[])tuple23._2();
                seq = (Seq)Predef$.MODULE$.refArrayOps((Object[])matches2).toSeq().$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])recurse2).flatMap((Function1)new Serializable(this, regex){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ADAMContext $outer;
                    private final String regex$1;

                    public final Seq<Path> apply(Path p) {
                        return this.$outer.findFiles(p, this.regex$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.regex$1 = regex$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))), Seq$.MODULE$.canBuildFrom());
            }
            return seq;
        }
        throw new MatchError((Object)tuple2);
    }

    public RDD<AlignmentRecord> loadADAMFromPaths(Seq<Path> paths2) {
        return this.sc().union((Seq)((TraversableLike)paths2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMContext $outer;

            public final Tuple2<SequenceDictionary, RDD<AlignmentRecord>> apply(Path path) {
                return this.$outer.org$bdgenomics$adam$rdd$ADAMContext$$loadADAMs$1(path);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RDD<AlignmentRecord> apply(Tuple2<SequenceDictionary, RDD<AlignmentRecord>> v) {
                return (RDD)v._2();
            }
        }, Seq$.MODULE$.canBuildFrom()), ClassTag$.MODULE$.apply(AlignmentRecord.class));
    }

    public final Tuple2 org$bdgenomics$adam$rdd$ADAMContext$$loadADAMs$1(Path path) {
        SequenceDictionary dict = this.adamDictionaryLoad(path.toString(), (Function1)Predef$.MODULE$.conforms(), (Manifest)ManifestFactory$.MODULE$.classType(AlignmentRecord.class));
        RDD rdd = this.adamLoad(path.toString(), (Option)this.adamLoad$default$2(), this.adamLoad$default$3(), (Function1)Predef$.MODULE$.conforms(), (Manifest)ManifestFactory$.MODULE$.classType(AlignmentRecord.class));
        return new Tuple2((Object)dict, rdd);
    }

    public ADAMContext(SparkContext sc) {
        this.sc = sc;
        Logging.class.$init$((Logging)this);
    }
}

