/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import org.apache.spark.Logging;
import org.apache.spark.Partitioner;
import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferencePosition$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.rdd.GenomicRegionPartitioner$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\u0001\u0003\u0001-\u0011\u0001dR3o_6L7MU3hS>t\u0007+\u0019:uSRLwN\\3s\u0015\t\u0019A!A\u0002sI\u0012T!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u00011c\u0001\u0001\r)A\u0011QBE\u0007\u0002\u001d)\u0011q\u0002E\u0001\u0006gB\f'o\u001b\u0006\u0003#!\ta!\u00199bG\",\u0017BA\n\u000f\u0005-\u0001\u0016M\u001d;ji&|g.\u001a:\u0011\u00055)\u0012B\u0001\f\u000f\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0007\u0001\u0003\u0006\u0004%\t!G\u0001\t]Vl\u0007+\u0019:ugV\t!\u0004\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBDA\u0002J]RD\u0001\"\t\u0001\u0003\u0002\u0003\u0006IAG\u0001\n]Vl\u0007+\u0019:ug\u0002B\u0001b\t\u0001\u0003\u0006\u0004%\t\u0001J\u0001\u000bg\u0016\fH*\u001a8hi\"\u001cX#A\u0013\u0011\t\u0019JCf\f\b\u00037\u001dJ!\u0001\u000b\u000f\u0002\rA\u0013X\rZ3g\u0013\tQ3FA\u0002NCBT!\u0001\u000b\u000f\u0011\u0005\u0019j\u0013B\u0001\u0018,\u0005\u0019\u0019FO]5oOB\u00111\u0004M\u0005\u0003cq\u0011A\u0001T8oO\"A1\u0007\u0001B\u0001B\u0003%Q%A\u0006tKFdUM\\4uQN\u0004\u0003\"B\u001b\u0001\t\u00031\u0014A\u0002\u001fj]&$h\bF\u00028si\u0002\"\u0001\u000f\u0001\u000e\u0003\tAQ\u0001\u0007\u001bA\u0002iAQa\t\u001bA\u0002\u0015BQ!\u000e\u0001\u0005\u0002q\"2aN\u001f?\u0011\u0015A2\b1\u0001\u001b\u0011\u0015y4\b1\u0001A\u0003\u001d\u0019X-\u001d#jGR\u0004\"!\u0011#\u000e\u0003\tS!a\u0011\u0003\u0002\r5|G-\u001a7t\u0013\t)%I\u0001\nTKF,XM\\2f\t&\u001cG/[8oCJL\bbB$\u0001\u0005\u0004%\t\u0001S\u0001\u0006]\u0006lWm]\u000b\u0002\u0013B\u0019!J\u0015\u0017\u000f\u0005-\u0003fB\u0001'P\u001b\u0005i%B\u0001(\u000b\u0003\u0019a$o\\8u}%\tQ$\u0003\u0002R9\u00059\u0001/Y2lC\u001e,\u0017BA*U\u0005\r\u0019V-\u001d\u0006\u0003#rAaA\u0016\u0001!\u0002\u0013I\u0015A\u00028b[\u0016\u001c\b\u0005C\u0004Y\u0001\t\u0007I\u0011A-\u0002\u000f1,gn\u001a;igV\t!\fE\u0002K%>Ba\u0001\u0018\u0001!\u0002\u0013Q\u0016\u0001\u00037f]\u001e$\bn\u001d\u0011\t\u000fy\u0003!\u0019!C\u00053\u000611-^7vYNDa\u0001\u0019\u0001!\u0002\u0013Q\u0016aB2v[Vd7\u000f\t\u0005\bE\u0002\u0011\r\u0011\"\u0001d\u0003-!x\u000e^1m\u0019\u0016tw\r\u001e5\u0016\u0003=Ba!\u001a\u0001!\u0002\u0013y\u0013\u0001\u0004;pi\u0006dG*\u001a8hi\"\u0004\u0003bB4\u0001\u0005\u0004%\t\u0001J\u0001\u0012GVlW\u000f\\1uSZ,G*\u001a8hi\"\u001c\bBB5\u0001A\u0003%Q%\u0001\ndk6,H.\u0019;jm\u0016dUM\\4uQN\u0004\u0003bB6\u0001\u0005\u0004%I!G\u0001\u0006a\u0006\u0014Ho\u001d\u0005\u0007[\u0002\u0001\u000b\u0011\u0002\u000e\u0002\rA\f'\u000f^:!\u0011\u0015y\u0007\u0001\"\u0011\u001a\u00035qW/\u001c)beRLG/[8og\")\u0011\u000f\u0001C!e\u0006aq-\u001a;QCJ$\u0018\u000e^5p]R\u0011!d\u001d\u0005\u0006iB\u0004\r!^\u0001\u0004W\u0016L\bCA\u000ew\u0013\t9HDA\u0002B]fDQ!\u001f\u0001\u0005Bi\fa!Z9vC2\u001cHCA>\u007f!\tYB0\u0003\u0002~9\t9!i\\8mK\u0006t\u0007\"B@y\u0001\u0004)\u0018!\u0001=\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006\u0005AAo\\*ue&tw\rF\u0001-\u0011\u001d\tI\u0001\u0001C!\u0003\u0017\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u00025\u001d9\u0011q\u0002\u0002\t\u0002\u0005E\u0011\u0001G$f]>l\u0017n\u0019*fO&|g\u000eU1si&$\u0018n\u001c8feB\u0019\u0001(a\u0005\u0007\r\u0005\u0011\u0001\u0012AA\u000b'\u0019\t\u0019\"a\u0006\u0002\u001eA\u00191$!\u0007\n\u0007\u0005mAD\u0001\u0004B]f\u0014VM\u001a\t\u00047\u0005}\u0011bAA\u00119\ta1+\u001a:jC2L'0\u00192mK\"9Q'a\u0005\u0005\u0002\u0005\u0015BCAA\t\u0011!\tI#a\u0005\u0005\u0002\u0005-\u0012!B1qa2LH#B\u001c\u0002.\u0005E\u0002bBA\u0018\u0003O\u0001\rAG\u0001\u0002\u001d\"1\u0001,a\nA\u0002\u0015B\u0001\"!\u000e\u0002\u0014\u0011\u0005\u0011qG\u0001\u0011Kb$(/Y2u\u0019\u0016tw\r\u001e5NCB$2!JA\u001d\u0011\u0019y\u00141\u0007a\u0001\u0001\"Q\u0011QHA\n\u0003\u0003%I!a\u0010\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002N5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%\u0001\u0003mC:<'BAA&\u0003\u0011Q\u0017M^1\n\t\u0005=\u0013Q\t\u0002\u0007\u001f\nTWm\u0019;")
public class GenomicRegionPartitioner
extends Partitioner
implements Logging {
    private final int numParts;
    private final Map<String, Object> seqLengths;
    private final Seq<String> names;
    private final Seq<Object> lengths;
    private final Seq<Object> cumuls;
    private final long totalLength;
    private final Map<String, Object> cumulativeLengths;
    private final int parts;
    private transient Logger org$apache$spark$Logging$$log_;

    public static Map<String, Object> extractLengthMap(SequenceDictionary sequenceDictionary) {
        return GenomicRegionPartitioner$.MODULE$.extractLengthMap(sequenceDictionary);
    }

    public static GenomicRegionPartitioner apply(int n, Map<String, Object> map) {
        return GenomicRegionPartitioner$.MODULE$.apply(n, map);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public int numParts() {
        return this.numParts;
    }

    public Map<String, Object> seqLengths() {
        return this.seqLengths;
    }

    public Seq<String> names() {
        return this.names;
    }

    public Seq<Object> lengths() {
        return this.lengths;
    }

    private Seq<Object> cumuls() {
        return this.cumuls;
    }

    public long totalLength() {
        return this.totalLength;
    }

    public Map<String, Object> cumulativeLengths() {
        return this.cumulativeLengths;
    }

    private int parts() {
        return this.parts;
    }

    public int numPartitions() {
        return this.parts() + 1;
    }

    public int getPartition(Object key) {
        block4: {
            int n;
            block3: {
                Object object;
                block2: {
                    object = key;
                    ReferencePosition referencePosition2 = ReferencePosition$.MODULE$.UNMAPPED();
                    Object object2 = object;
                    if (referencePosition2 != null ? !((Object)referencePosition2).equals(object2) : object2 != null) break block2;
                    n = this.parts();
                    break block3;
                }
                if (!(object instanceof ReferencePosition)) break block4;
                ReferencePosition referencePosition3 = (ReferencePosition)object;
                n = this.getPart$1(referencePosition3.referenceName(), referencePosition3.pos());
            }
            return n;
        }
        throw new IllegalArgumentException("Only ReferencePosition values can be partitioned by GenomicRegionPartitioner");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x) {
        Object object = x;
        if (!(object instanceof GenomicRegionPartitioner)) return false;
        GenomicRegionPartitioner genomicRegionPartitioner = (GenomicRegionPartitioner)((Object)object);
        if (genomicRegionPartitioner.numPartitions() != this.numPartitions()) return false;
        Seq<String> seq = this.names();
        Seq<String> seq2 = genomicRegionPartitioner.names();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Seq<Object> seq3 = this.lengths();
        Seq<Object> seq4 = genomicRegionPartitioner.lengths();
        if (seq3 == null) {
            if (seq4 == null) return true;
            return false;
        } else {
            if (!seq3.equals(seq4)) return false;
            return true;
        }
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString("%d parts, %d partitions, %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.parts()), BoxesRunTime.boxToInteger((int)this.numPartitions()), this.cumulativeLengths().toString()}));
    }

    public int hashCode() {
        return 37 * (37 * this.parts() + this.names().hashCode()) + this.lengths().hashCode();
    }

    private final int getPart$1(String referenceName, long pos) {
        long totalOffset = BoxesRunTime.unboxToLong((Object)this.cumulativeLengths().apply((Object)referenceName)) + pos;
        double totalFraction = (double)totalOffset / (double)this.totalLength();
        return package$.MODULE$.min((int)package$.MODULE$.floor(totalFraction * (double)this.parts()), this.numPartitions());
    }

    public GenomicRegionPartitioner(int numParts, Map<String, Object> seqLengths) {
        this.numParts = numParts;
        this.seqLengths = seqLengths;
        Logging.class.$init$((Logging)this);
        this.log().info(new StringBuilder().append((Object)"Have genomic region partitioner with ").append((Object)BoxesRunTime.boxToInteger((int)numParts)).append((Object)" partitions, and sequences:").toString());
        seqLengths.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenomicRegionPartitioner $outer;

            public final void apply(Tuple2<String, Object> kv) {
                this.$outer.log().info(new StringBuilder().append((Object)"Contig ").append(kv._1()).append((Object)" with length ").append((Object)BoxesRunTime.boxToLong((long)kv._2$mcJ$sp())).toString());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.names = (Seq)seqLengths.keys().toSeq().sortWith((Function2)new $anonfun$4(this));
        this.lengths = (Seq)this.names().map((Function1)new $anonfun$5(this), Seq$.MODULE$.canBuildFrom());
        this.cumuls = (Seq)this.lengths().scan((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new $anonfun$1(this), Seq$.MODULE$.canBuildFrom());
        this.totalLength = BoxesRunTime.unboxToLong((Object)this.lengths().reduce((Function2)new $anonfun$2(this)));
        this.cumulativeLengths = (Map)Predef$.MODULE$.Map().apply((Seq)this.names().zip(this.cumuls(), Seq$.MODULE$.canBuildFrom()));
        this.parts = (int)package$.MODULE$.min((long)numParts, this.totalLength());
    }

    public GenomicRegionPartitioner(int numParts, SequenceDictionary seqDict) {
        this(numParts, GenomicRegionPartitioner$.MODULE$.extractLengthMap(seqDict));
    }
}

