/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext$;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator;
import org.bdgenomics.adam.algorithms.realignmenttarget.IndelRealignmentTarget;
import org.bdgenomics.adam.algorithms.realignmenttarget.RealignmentTargetFinder$;
import org.bdgenomics.adam.algorithms.realignmenttarget.ZippedTargetSet;
import org.bdgenomics.adam.models.Consensus;
import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferencePosition$;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.rdd.RealignIndels$;
import org.bdgenomics.adam.rich.RichAlignmentRecord;
import org.bdgenomics.adam.rich.RichAlignmentRecord$;
import org.bdgenomics.adam.util.ImplicitJavaConversions$;
import org.bdgenomics.adam.util.MdTag;
import org.bdgenomics.adam.util.MdTag$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.TreeSet;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\t-sAB\u0001\u0003\u0011\u0003\u0011!\"A\u0007SK\u0006d\u0017n\u001a8J]\u0012,Gn\u001d\u0006\u0003\u0007\u0011\t1A\u001d3e\u0015\t)a!\u0001\u0003bI\u0006l'BA\u0004\t\u0003)\u0011GmZ3o_6L7m\u001d\u0006\u0002\u0013\u0005\u0019qN]4\u0011\u0005-aQ\"\u0001\u0002\u0007\r5\u0011\u0001\u0012\u0001\u0002\u000f\u00055\u0011V-\u00197jO:Le\u000eZ3mgN\u0019AbD\u000b\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g!\t\u0001b#\u0003\u0002\u0018#\ta1+\u001a:jC2L'0\u00192mK\")\u0011\u0004\u0004C\u00017\u00051A(\u001b8jiz\u001a\u0001\u0001F\u0001\u000b\u0011\u0015iB\u0002\"\u0001\u001f\u0003\u0015\t\u0007\u000f\u001d7z)!y\u0002'M\u001eA\u000b\u001ec\u0005c\u0001\u0011'Q5\t\u0011E\u0003\u0002\u0004E)\u00111\u0005J\u0001\u0006gB\f'o\u001b\u0006\u0003K!\ta!\u00199bG\",\u0017BA\u0014\"\u0005\r\u0011F\t\u0012\t\u0003S9j\u0011A\u000b\u0006\u0003W1\nA!\u0019<s_*\u0011QFB\u0001\bM>\u0014X.\u0019;t\u0013\ty#FA\bBY&<g.\\3oiJ+7m\u001c:e\u0011\u0015\u0019A\u00041\u0001 \u0011\u001d\u0011D\u0004%AA\u0002M\nabY8og\u0016t7/^:N_\u0012,G\u000e\u0005\u00025s5\tQG\u0003\u00027o\u0005I1m\u001c8tK:\u001cXo\u001d\u0006\u0003q\u0011\t!\"\u00197h_JLG\u000f[7t\u0013\tQTG\u0001\nD_:\u001cXM\\:vg\u001e+g.\u001a:bi>\u0014\bb\u0002\u001f\u001d!\u0003\u0005\r!P\u0001\rI\u0006$\u0018-S:T_J$X\r\u001a\t\u0003!yJ!aP\t\u0003\u000f\t{w\u000e\\3b]\"9\u0011\t\bI\u0001\u0002\u0004\u0011\u0015\u0001D7bq&sG-\u001a7TSj,\u0007C\u0001\tD\u0013\t!\u0015CA\u0002J]RDqA\u0012\u000f\u0011\u0002\u0003\u0007!)\u0001\nnCb\u001cuN\\:f]N,8OT;nE\u0016\u0014\bb\u0002%\u001d!\u0003\u0005\r!S\u0001\rY>$G\u000b\u001b:fg\"|G\u000e\u001a\t\u0003!)K!aS\t\u0003\r\u0011{WO\u00197f\u0011\u001diE\u0004%AA\u0002\t\u000bQ\"\\1y)\u0006\u0014x-\u001a;TSj,\u0007\"B(\r\t\u000b\u0001\u0016aC7baR{G+\u0019:hKR$2AQ)Z\u0011\u0015\u0011f\n1\u0001T\u0003\u0011\u0011X-\u00193\u0011\u0005Q;V\"A+\u000b\u0005Y#\u0011\u0001\u0002:jG\"L!\u0001W+\u0003'IK7\r[!mS\u001etW.\u001a8u%\u0016\u001cwN\u001d3\t\u000bis\u0005\u0019A.\u0002\u000fQ\f'oZ3ugB\u0019A,Y2\u000e\u0003uS!AX0\u0002\u0013%lW.\u001e;bE2,'B\u00011\u0012\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Ev\u0013q\u0001\u0016:fKN+G\u000f\u0005\u0003\u0011I\u001a\u0014\u0015BA3\u0012\u0005\u0019!V\u000f\u001d7feA\u0011qM[\u0007\u0002Q*\u0011\u0011nN\u0001\u0012e\u0016\fG.[4o[\u0016tG\u000f^1sO\u0016$\u0018BA6i\u0005YIe\u000eZ3m%\u0016\fG.[4o[\u0016tG\u000fV1sO\u0016$\bF\u0001(n!\tq\u0017/D\u0001p\u0015\t\u0001\u0018#\u0001\u0006b]:|G/\u0019;j_:L!A]8\u0003\u000fQ\f\u0017\u000e\u001c:fG\")q\n\u0004C\u0001iR\u0019!)\u001e<\t\u000bI\u001b\b\u0019A*\t\u000bi\u001b\b\u0019A<\u0011\u0005\u001dD\u0018BA=i\u0005=Q\u0016\u000e\u001d9fIR\u000b'oZ3u'\u0016$\b\"B>\r\t\u0003a\u0018aE7baR{G+\u0019:hKR,f\u000e]1dW\u0016$G#B?\u0002\u0002\u0005\u0015\u0001c\u0001\t\u007fM&\u0011q0\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\r\u0005\r!\u00101\u0001C\u0003-!\u0018M]4fi&sG-\u001a=\t\u000biS\b\u0019A.\t\r=cA\u0011AA\u0005)\u0015i\u00181BA\u0007\u0011\u001d\t\u0019!a\u0002A\u0002\tCaAWA\u0004\u0001\u00049\bbBA\t\u0019\u0011\u0005\u00111C\u0001\u000b[\u0006\u0004H+\u0019:hKR\u001cHCBA\u000b\u0003c\t9\u0004\u0005\u0003!M\u0005]\u0001#\u0002\te{\u0006e\u0001#BA\u000e\u0003W\u0019f\u0002BA\u000f\u0003OqA!a\b\u0002&5\u0011\u0011\u0011\u0005\u0006\u0004\u0003GQ\u0012A\u0002\u001fs_>$h(C\u0001\u0013\u0013\r\tI#E\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti#a\f\u0003\u0011%#XM]1cY\u0016T1!!\u000b\u0012\u0011!\t\u0019$a\u0004A\u0002\u0005U\u0012\u0001\u0003:jG\"|&\u000f\u001a3\u0011\u0007\u000123\u000bC\u0004[\u0003\u001f\u0001\r!!\u000f\u0011\u0007q\u000bg\rC\u0004\u0002>1!\t!a\u0010\u0002+\u001d,GOU3gKJ,gnY3Ge>l'+Z1egR!\u0011\u0011IA.!%\u0001\u00121IA$\u0003+\n)&C\u0002\u0002FE\u0011a\u0001V;qY\u0016\u001c\u0004\u0003BA%\u0003\u001fr1\u0001EA&\u0013\r\ti%E\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00131\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055\u0013\u0003E\u0002\u0011\u0003/J1!!\u0017\u0012\u0005\u0011auN\\4\t\u0011\u0005u\u00131\ba\u0001\u00033\tQA]3bIND\u0011\"!\u0019\r#\u0003%\t!a\u0019\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII*\"!!\u001a+\u0007M\n9g\u000b\u0002\u0002jA!\u00111NA9\u001b\t\tiGC\u0002\u0002p=\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\n\t\u0005M\u0014Q\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA<\u0019E\u0005I\u0011AA=\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001aTCAA>U\ri\u0014q\r\u0005\n\u0003\u007fb\u0011\u0013!C\u0001\u0003\u0003\u000bq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u0007S3AQA4\u0011%\t9\tDI\u0001\n\u0003\t\t)A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00136\u0011%\tY\tDI\u0001\n\u0003\ti)A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00137+\t\tyIK\u0002J\u0003OB\u0011\"a%\r#\u0003%\t!!!\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uI]B\u0011\"a&\r#\u0003%\t!a\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0011%\tY\nDI\u0001\n\u0003\tI(A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HE\r\u0005\n\u0003?c\u0011\u0013!C\u0001\u0003\u0003\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0004\"CAR\u0019E\u0005I\u0011AAA\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i!I\u0011q\u0015\u0007\u0012\u0002\u0013\u0005\u0011QR\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\t\u0013\u0005-F\"%A\u0005\u0002\u0005\u0005\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c\u0007C\u0005\u000202\t\t\u0011\"\u0003\u00022\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\u0019\f\u0005\u0003\u00026\u0006}VBAA\\\u0015\u0011\tI,a/\u0002\t1\fgn\u001a\u0006\u0003\u0003{\u000bAA[1wC&!\u0011\u0011YA\\\u0005\u0019y%M[3di\u001a1QB\u0001\u0001\u0003\u0003\u000b\u001cb!a1\u0010+\u0005\u001d\u0007\u0003BAe\u0003\u0017l\u0011AI\u0005\u0004\u0003\u001b\u0014#a\u0002'pO\u001eLgn\u001a\u0005\u000be\u0005\r'Q1A\u0005\u0002\u0005EW#A\u001a\t\u0015\u0005U\u00171\u0019B\u0001B\u0003%1'A\bd_:\u001cXM\\:vg6{G-\u001a7!\u0011)a\u00141\u0019BC\u0002\u0013\u0005\u0011\u0011\\\u000b\u0002{!Q\u0011Q\\Ab\u0005\u0003\u0005\u000b\u0011B\u001f\u0002\u001b\u0011\fG/Y%t'>\u0014H/\u001a3!\u0011)\t\u00151\u0019BC\u0002\u0013\u0005\u0011\u0011]\u000b\u0002\u0005\"Q\u0011Q]Ab\u0005\u0003\u0005\u000b\u0011\u0002\"\u0002\u001b5\f\u00070\u00138eK2\u001c\u0016N_3!\u0011)1\u00151\u0019BC\u0002\u0013\u0005\u0011\u0011\u001d\u0005\u000b\u0003W\f\u0019M!A!\u0002\u0013\u0011\u0015aE7bq\u000e{gn]3ogV\u001ch*^7cKJ\u0004\u0003B\u0003%\u0002D\n\u0015\r\u0011\"\u0001\u0002pV\t\u0011\n\u0003\u0006\u0002t\u0006\r'\u0011!Q\u0001\n%\u000bQ\u0002\\8e)\"\u0014Xm\u001d5pY\u0012\u0004\u0003BC'\u0002D\n\u0015\r\u0011\"\u0001\u0002b\"Q\u0011\u0011`Ab\u0005\u0003\u0005\u000b\u0011\u0002\"\u0002\u001d5\f\u0007\u0010V1sO\u0016$8+\u001b>fA!9\u0011$a1\u0005\u0002\u0005uHCDA\u0000\u0005\u0003\u0011\u0019A!\u0002\u0003\b\t%!1\u0002\t\u0004\u0017\u0005\r\u0007\u0002\u0003\u001a\u0002|B\u0005\t\u0019A\u001a\t\u0011q\nY\u0010%AA\u0002uB\u0001\"QA~!\u0003\u0005\rA\u0011\u0005\t\r\u0006m\b\u0013!a\u0001\u0005\"A\u0001*a?\u0011\u0002\u0003\u0007\u0011\n\u0003\u0005N\u0003w\u0004\n\u00111\u0001C\u0011!\u0011y!a1\u0005\u0002\tE\u0011A\u0005:fC2LwM\u001c+be\u001e,Go\u0012:pkB$B!!\u0007\u0003\u0014!A!Q\u0003B\u0007\u0001\u0004\t9\"A\u0006uCJ<W\r^$s_V\u0004\b\u0002\u0003B\r\u0003\u0007$\tAa\u0007\u0002AM<X-\u001a9SK\u0006$wJ^3s%\u00164WM]3oG\u00164uN])vC2LG/\u001f\u000b\t\u0005;\u0011yB!\t\u0003&A!\u0001\u0003\u001a\"C\u0011\u001d\u0011&q\u0003a\u0001\u0003\u000fB\u0001Ba\t\u0003\u0018\u0001\u0007\u0011qI\u0001\ne\u00164WM]3oG\u0016D\u0001Ba\n\u0003\u0018\u0001\u0007!\u0011F\u0001\ncV\fG.\u001b;jKN\u0004R!a\u0007\u0003,\tKAA!\f\u00020\t\u00191+Z9\t\u0011\tE\u00121\u0019C\u0001\u0005g\tQd];n\u001b&\u001cX.\u0019;dQF+\u0018\r\\5us&;gn\u001c:f\u0007&<\u0017M\u001d\u000b\b\u0005\nU\"q\u0007B\u001d\u0011\u001d\u0011&q\u0006a\u0001\u0003\u000fB\u0001Ba\t\u00030\u0001\u0007\u0011q\t\u0005\t\u0005O\u0011y\u00031\u0001\u0003*!A!QHAb\t\u0003\u0011y$\u0001\ntk6l\u0015n]7bi\u000eD\u0017+^1mSRLHc\u0001\"\u0003B!1!Ka\u000fA\u0002!B\u0001B!\u0012\u0002D\u0012\u0005!qI\u0001\u000ee\u0016\fG.[4o\u0013:$W\r\\:\u0015\u0007}\u0011I\u0005\u0003\u0004\u0004\u0005\u0007\u0002\ra\b")
public class RealignIndels
implements Serializable,
Logging {
    private final ConsensusGenerator consensusModel;
    private final boolean dataIsSorted;
    private final int maxIndelSize;
    private final int maxConsensusNumber;
    private final double lodThreshold;
    private final int maxTargetSize;
    private transient Logger org$apache$spark$Logging$$log_;

    public static int $lessinit$greater$default$6() {
        return RealignIndels$.MODULE$.$lessinit$greater$default$6();
    }

    public static double $lessinit$greater$default$5() {
        return RealignIndels$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return RealignIndels$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return RealignIndels$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$2() {
        return RealignIndels$.MODULE$.$lessinit$greater$default$2();
    }

    public static ConsensusGenerator $lessinit$greater$default$1() {
        return RealignIndels$.MODULE$.$lessinit$greater$default$1();
    }

    public static int apply$default$7() {
        return RealignIndels$.MODULE$.apply$default$7();
    }

    public static double apply$default$6() {
        return RealignIndels$.MODULE$.apply$default$6();
    }

    public static int apply$default$5() {
        return RealignIndels$.MODULE$.apply$default$5();
    }

    public static int apply$default$4() {
        return RealignIndels$.MODULE$.apply$default$4();
    }

    public static boolean apply$default$3() {
        return RealignIndels$.MODULE$.apply$default$3();
    }

    public static ConsensusGenerator apply$default$2() {
        return RealignIndels$.MODULE$.apply$default$2();
    }

    public static Tuple3<String, Object, Object> getReferenceFromReads(Iterable<RichAlignmentRecord> iterable) {
        return RealignIndels$.MODULE$.getReferenceFromReads(iterable);
    }

    public static RDD<Tuple2<Option<IndelRealignmentTarget>, Iterable<RichAlignmentRecord>>> mapTargets(RDD<RichAlignmentRecord> rDD, TreeSet<IndelRealignmentTarget> treeSet) {
        return RealignIndels$.MODULE$.mapTargets(rDD, treeSet);
    }

    public static Option<IndelRealignmentTarget> mapToTarget(int n, ZippedTargetSet zippedTargetSet) {
        return RealignIndels$.MODULE$.mapToTarget(n, zippedTargetSet);
    }

    public static Option<IndelRealignmentTarget> mapToTargetUnpacked(int n, TreeSet<Tuple2<IndelRealignmentTarget, Object>> treeSet) {
        return RealignIndels$.MODULE$.mapToTargetUnpacked(n, treeSet);
    }

    public static int mapToTarget(RichAlignmentRecord richAlignmentRecord, ZippedTargetSet zippedTargetSet) {
        return RealignIndels$.MODULE$.mapToTarget(richAlignmentRecord, zippedTargetSet);
    }

    public static int mapToTarget(RichAlignmentRecord richAlignmentRecord, TreeSet<Tuple2<IndelRealignmentTarget, Object>> treeSet) {
        return RealignIndels$.MODULE$.mapToTarget(richAlignmentRecord, treeSet);
    }

    public static RDD<AlignmentRecord> apply(RDD<AlignmentRecord> rDD, ConsensusGenerator consensusGenerator, boolean bl, int n, int n2, double d, int n3) {
        return RealignIndels$.MODULE$.apply(rDD, consensusGenerator, bl, n, n2, d, n3);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public ConsensusGenerator consensusModel() {
        return this.consensusModel;
    }

    public boolean dataIsSorted() {
        return this.dataIsSorted;
    }

    public int maxIndelSize() {
        return this.maxIndelSize;
    }

    public int maxConsensusNumber() {
        return this.maxConsensusNumber;
    }

    public double lodThreshold() {
        return this.lodThreshold;
    }

    public int maxTargetSize() {
        return this.maxTargetSize;
    }

    public Iterable<RichAlignmentRecord> realignTargetGroup(Tuple2<Option<IndelRealignmentTarget>, Iterable<RichAlignmentRecord>> targetGroup) {
        Tuple2<Option<IndelRealignmentTarget>, Iterable<RichAlignmentRecord>> tuple2 = targetGroup;
        if (tuple2 != null) {
            Tuple2 tuple22;
            Option target = (Option)tuple2._1();
            Iterable reads = (Iterable)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)target, (Object)reads);
            Option target2 = (Option)tuple23._1();
            Iterable reads2 = (Iterable)tuple23._2();
            Iterable realignedReads = (Iterable)reads2.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(RichAlignmentRecord r) {
                    return r.mdTag().isDefined() && !((MdTag)r.mdTag().get()).hasMismatches();
                }
            });
            Tuple3<String, Object, Object> tuple3 = RealignIndels$.MODULE$.getReferenceFromReads((Iterable<RichAlignmentRecord>)((Iterable)reads2.map((Function1)new $anonfun$10(this), Iterable$.MODULE$.canBuildFrom())));
            if (tuple3 != null) {
                Iterable iterable;
                Tuple3 tuple32;
                String reference = (String)tuple3._1();
                long refStart = BoxesRunTime.unboxToLong((Object)tuple3._2());
                long refEnd = BoxesRunTime.unboxToLong((Object)tuple3._3());
                Tuple3 tuple33 = tuple32 = new Tuple3((Object)reference, (Object)BoxesRunTime.boxToLong((long)refStart), (Object)BoxesRunTime.boxToLong((long)refEnd));
                String reference2 = (String)tuple33._1();
                long refStart2 = BoxesRunTime.unboxToLong((Object)tuple33._2());
                long refEnd2 = BoxesRunTime.unboxToLong((Object)tuple33._3());
                ReferenceRegion refRegion = new ReferenceRegion(ImplicitJavaConversions$.MODULE$.charSequenceToString(((RichAlignmentRecord)reads2.head()).record().getContig().getContigName()), refStart2, refEnd2);
                Iterable<RichAlignmentRecord> readsToClean = this.consensusModel().preprocessReadsForRealignment((Iterable<RichAlignmentRecord>)((Iterable)reads2.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(RichAlignmentRecord r) {
                        return !r.mdTag().isDefined() || ((MdTag)r.mdTag().get()).hasMismatches();
                    }
                })), reference2, refRegion);
                Iterable consensus = this.consensusModel().findConsensus(readsToClean);
                if (consensus.size() > this.maxConsensusNumber()) {
                    Random r = new Random();
                    consensus = (Iterable)((IterableLike)r.shuffle(consensus, Iterable$.MODULE$.canBuildFrom())).take(this.maxConsensusNumber());
                }
                if (target2.isEmpty()) {
                    iterable = reads2;
                } else {
                    if (readsToClean.size() > 0 && consensus.size() > 0) {
                        Tuple3 bestConsensusTuple;
                        int totalMismatchSumPreCleaning = BoxesRunTime.unboxToInt((Object)((TraversableOnce)readsToClean.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ RealignIndels $outer;

                            public final int apply(RichAlignmentRecord x$7) {
                                return this.$outer.sumMismatchQuality(RichAlignmentRecord$.MODULE$.richRecordToRecord(x$7));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, Iterable$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(int x$8, int x$9) {
                                return this.apply$mcIII$sp(x$8, x$9);
                            }

                            public int apply$mcIII$sp(int x$8, int x$9) {
                                return x$8 + x$9;
                            }
                        }));
                        ObjectRef consensusOutcomes = new ObjectRef((Object)Nil$.MODULE$);
                        consensus.foreach((Function1)new Serializable(this, reference2, refStart2, refEnd2, readsToClean, consensusOutcomes){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ RealignIndels $outer;
                            private final String reference$1;
                            private final long refStart$1;
                            private final long refEnd$1;
                            private final Iterable readsToClean$1;
                            private final ObjectRef consensusOutcomes$1;

                            public final void apply(Consensus c) {
                                String consensusSequence = c.insertIntoReference(this.reference$1, this.refStart$1, this.refEnd$1);
                                Iterable sweptValues = (Iterable)this.readsToClean$1.map((Function1)new Serializable(this, consensusSequence){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$realignTargetGroup$1 $outer;
                                    private final String consensusSequence$1;

                                    public final Tuple2<RichAlignmentRecord, Tuple2<Object, Object>> apply(RichAlignmentRecord r) {
                                        Tuple2<Object, Object> tuple2 = this.$outer.org$bdgenomics$adam$rdd$RealignIndels$$anonfun$$$outer().sweepReadOverReferenceForQuality(ImplicitJavaConversions$.MODULE$.charSequenceToString(RichAlignmentRecord$.MODULE$.richRecordToRecord(r).getSequence()), this.consensusSequence$1, (Seq<Object>)Predef$.MODULE$.wrapIntArray(r.qualityScores()));
                                        if (tuple2 != null) {
                                            Tuple2.mcII.sp sp2;
                                            int qual = tuple2._1$mcI$sp();
                                            int pos = tuple2._2$mcI$sp();
                                            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(qual, pos);
                                            int qual2 = sp3._1$mcI$sp();
                                            int pos2 = sp3._2$mcI$sp();
                                            int originalQual = this.$outer.org$bdgenomics$adam$rdd$RealignIndels$$anonfun$$$outer().sumMismatchQuality(RichAlignmentRecord$.MODULE$.richRecordToRecord(r));
                                            return qual2 < originalQual ? new Tuple2((Object)r, (Object)new Tuple2.mcII.sp(qual2, pos2)) : new Tuple2((Object)r, (Object)new Tuple2.mcII.sp(originalQual, -1));
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.consensusSequence$1 = consensusSequence$1;
                                    }
                                }, Iterable$.MODULE$.canBuildFrom());
                                int totalQuality = BoxesRunTime.unboxToInt((Object)((TraversableOnce)sweptValues.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply(Tuple2<RichAlignmentRecord, Tuple2<Object, Object>> x$11) {
                                        return ((Tuple2)x$11._2())._1$mcI$sp();
                                    }
                                }, Iterable$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply(int x$12, int x$13) {
                                        return this.apply$mcIII$sp(x$12, x$13);
                                    }

                                    public int apply$mcIII$sp(int x$12, int x$13) {
                                        return x$12 + x$13;
                                    }
                                }));
                                ObjectRef readMappings = new ObjectRef((Object)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
                                ((IterableLike)sweptValues.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Tuple2<RichAlignmentRecord, Object> apply(Tuple2<RichAlignmentRecord, Tuple2<Object, Object>> kv) {
                                        return new Tuple2(kv._1(), (Object)BoxesRunTime.boxToInteger((int)((Tuple2)kv._2())._2$mcI$sp()));
                                    }
                                }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, readMappings){
                                    public static final long serialVersionUID = 0L;
                                    private final ObjectRef readMappings$1;

                                    public final Map<RichAlignmentRecord, Object> apply(Tuple2<RichAlignmentRecord, Object> m) {
                                        return (Map)((Map)this.readMappings$1.elem).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(m._1()), (Object)BoxesRunTime.boxToInteger((int)m._2$mcI$sp())));
                                    }
                                    {
                                        this.readMappings$1 = readMappings$1;
                                    }
                                });
                                Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)totalQuality), (Object)c, (Object)((Map)readMappings.elem));
                                this.consensusOutcomes$1.elem = ((List)this.consensusOutcomes$1.elem).$colon$colon((Object)tuple3);
                            }

                            public /* synthetic */ RealignIndels org$bdgenomics$adam$rdd$RealignIndels$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.reference$1 = reference$1;
                                this.refStart$1 = refStart$1;
                                this.refEnd$1 = refEnd$1;
                                this.readsToClean$1 = readsToClean$1;
                                this.consensusOutcomes$1 = consensusOutcomes$1;
                            }
                        });
                        Tuple3 tuple34 = bestConsensusTuple = (Tuple3)((List)consensusOutcomes.elem).reduce((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple3<Object, Consensus, Map<RichAlignmentRecord, Object>> apply(Tuple3<Object, Consensus, Map<RichAlignmentRecord, Object>> c1, Tuple3<Object, Consensus, Map<RichAlignmentRecord, Object>> c2) {
                                return BoxesRunTime.unboxToInt((Object)c1._1()) <= BoxesRunTime.unboxToInt((Object)c2._1()) ? c1 : c2;
                            }
                        });
                        if (tuple34 != null) {
                            Tuple3 tuple35;
                            int bestConsensusMismatchSum = BoxesRunTime.unboxToInt((Object)tuple34._1());
                            Consensus bestConsensus = (Consensus)tuple34._2();
                            Map bestMappings = (Map)tuple34._3();
                            Tuple3 tuple36 = tuple35 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)bestConsensusMismatchSum), (Object)bestConsensus, (Object)bestMappings);
                            int bestConsensusMismatchSum2 = BoxesRunTime.unboxToInt((Object)tuple36._1());
                            Consensus bestConsensus2 = (Consensus)tuple36._2();
                            Map bestMappings2 = (Map)tuple36._3();
                            if ((double)(totalMismatchSumPreCleaning - bestConsensusMismatchSum2) / 10.0 > this.lodThreshold()) {
                                Iterable cleanedReads = (Iterable)readsToClean.map((Function1)new Serializable(this, reference2, refStart2, bestConsensus2, bestMappings2){
                                    public static final long serialVersionUID = 0L;
                                    private final String reference$1;
                                    private final long refStart$1;
                                    private final Consensus bestConsensus$1;
                                    private final Map bestMappings$1;

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final RichAlignmentRecord apply(RichAlignmentRecord r) {
                                        RichAlignmentRecord richAlignmentRecord;
                                        AlignmentRecord.Builder builder = AlignmentRecord.newBuilder((AlignmentRecord)RichAlignmentRecord$.MODULE$.richRecordToRecord(r));
                                        int remapping = BoxesRunTime.unboxToInt((Object)this.bestMappings$1.apply((Object)r));
                                        if (remapping != -1) {
                                            Cigar cigar;
                                            builder.setMapq(Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(RichAlignmentRecord$.MODULE$.richRecordToRecord(r).getMapq()) + 10));
                                            builder.setStart(Predef$.MODULE$.long2Long(this.refStart$1 + (long)remapping));
                                            if (this.refStart$1 + (long)remapping >= this.bestConsensus$1.index().start() && this.refStart$1 + (long)remapping <= this.bestConsensus$1.index().end() - 1L) {
                                                Tuple2 tuple2;
                                                Tuple2 tuple22;
                                                Tuple2 tuple23 = tuple22 = this.bestConsensus$1.index().start() == this.bestConsensus$1.index().end() - 1L ? new Tuple2((Object)new CigarElement(this.bestConsensus$1.consensus().length(), CigarOperator.I), (Object)BoxesRunTime.boxToLong((long)((long)(RichAlignmentRecord$.MODULE$.richRecordToRecord(r).getSequence().length() - this.bestConsensus$1.consensus().length()) - (this.bestConsensus$1.index().start() - (this.refStart$1 + (long)remapping))))) : new Tuple2((Object)new CigarElement((int)(this.bestConsensus$1.index().end() - 1L - this.bestConsensus$1.index().start()), CigarOperator.D), (Object)BoxesRunTime.boxToLong((long)((long)RichAlignmentRecord$.MODULE$.richRecordToRecord(r).getSequence().length() - (this.bestConsensus$1.index().start() - (this.refStart$1 + (long)remapping)))));
                                                if (tuple22 == null) throw new MatchError((Object)tuple22);
                                                CigarElement idElement = (CigarElement)tuple22._1();
                                                long endLength = tuple22._2$mcJ$sp();
                                                Tuple2 tuple24 = tuple2 = new Tuple2((Object)idElement, (Object)BoxesRunTime.boxToLong((long)endLength));
                                                CigarElement idElement2 = (CigarElement)tuple24._1();
                                                long endLength2 = tuple24._2$mcJ$sp();
                                                List cigarElements = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CigarElement[]{new CigarElement((int)(this.refStart$1 + (long)remapping - this.bestConsensus$1.index().start()), CigarOperator.M), idElement2, new CigarElement((int)endLength2, CigarOperator.M)}));
                                                cigar = new Cigar(ImplicitJavaConversions$.MODULE$.listToJavaList(cigarElements));
                                            } else {
                                                cigar = new Cigar(ImplicitJavaConversions$.MODULE$.listToJavaList(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CigarElement[]{new CigarElement(RichAlignmentRecord$.MODULE$.richRecordToRecord(r).getSequence().length(), CigarOperator.M)}))));
                                            }
                                            Cigar newCigar = cigar;
                                            builder.setMismatchingPositions((CharSequence)MdTag$.MODULE$.moveAlignment(r, newCigar, (String)new StringOps(Predef$.MODULE$.augmentString(this.reference$1)).drop(remapping), this.refStart$1 + (long)remapping).toString());
                                            builder.setCigar((CharSequence)newCigar.toString());
                                            richAlignmentRecord = new RichAlignmentRecord(builder.build());
                                            return richAlignmentRecord;
                                        } else {
                                            richAlignmentRecord = new RichAlignmentRecord(builder.build());
                                        }
                                        return richAlignmentRecord;
                                    }
                                    {
                                        this.reference$1 = reference$1;
                                        this.refStart$1 = refStart$1;
                                        this.bestConsensus$1 = bestConsensus$1;
                                        this.bestMappings$1 = bestMappings$1;
                                    }
                                }, Iterable$.MODULE$.canBuildFrom());
                                realignedReads = (Iterable)cleanedReads.$plus$plus((GenTraversableOnce)realignedReads, Iterable$.MODULE$.canBuildFrom());
                            } else {
                                realignedReads = (Iterable)readsToClean.$plus$plus((GenTraversableOnce)realignedReads, Iterable$.MODULE$.canBuildFrom());
                            }
                        } else {
                            throw new MatchError((Object)tuple34);
                        }
                    }
                    iterable = realignedReads;
                }
                return iterable;
            }
            throw new MatchError(tuple3);
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<Object, Object> sweepReadOverReferenceForQuality(String read, String reference, Seq<Object> qualities) {
        ObjectRef qualityScores2 = new ObjectRef((Object)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), reference.length() - read.length()).foreach$mVc$sp((Function1)new Serializable(this, read, reference, qualities, qualityScores2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RealignIndels $outer;
            private final String read$1;
            private final String reference$2;
            private final Seq qualities$1;
            private final ObjectRef qualityScores$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int qualityScore = this.$outer.sumMismatchQualityIgnoreCigar(this.read$1, this.reference$2.substring(i, i + this.read$1.length()), (Seq<Object>)this.qualities$1);
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(qualityScore, i);
                this.qualityScores$1.elem = ((List)this.qualityScores$1.elem).$colon$colon((Object)sp2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.read$1 = read$1;
                this.reference$2 = reference$2;
                this.qualities$1 = qualities$1;
                this.qualityScores$1 = qualityScores$1;
            }
        });
        return (Tuple2)((List)qualityScores2.elem).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> p1, Tuple2<Object, Object> p2) {
                return p1._1$mcI$sp() < p2._1$mcI$sp() ? p1 : p2;
            }
        });
    }

    public int sumMismatchQualityIgnoreCigar(String read, String reference, Seq<Object> qualities) {
        IndexedSeq mismatchQualities = (IndexedSeq)((TraversableLike)((TraversableLike)((IterableLike)new StringOps(Predef$.MODULE$.augmentString(read)).zip((GenIterable)Predef$.MODULE$.wrapString(reference), Predef$.MODULE$.fallbackStringCanBuildFrom())).zip(qualities, IndexedSeq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Tuple2<Object, Object>, Object> r) {
                return ((Tuple2)r._1())._1$mcC$sp() != ((Tuple2)r._1())._2$mcC$sp();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Tuple2<Object, Object>, Object> x$18) {
                return x$18._2$mcI$sp();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return mismatchQualities.length() > 0 ? BoxesRunTime.unboxToInt((Object)mismatchQualities.reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$19, int x$20) {
                return this.apply$mcIII$sp(x$19, x$20);
            }

            public int apply$mcIII$sp(int x$19, int x$20) {
                return x$19 + x$20;
            }
        })) : 0;
    }

    public int sumMismatchQuality(AlignmentRecord read) {
        return this.sumMismatchQualityIgnoreCigar(ImplicitJavaConversions$.MODULE$.charSequenceToString(read.getSequence()), ((MdTag)RichAlignmentRecord$.MODULE$.recordToRichRecord(read).mdTag().get()).getReference(RichAlignmentRecord$.MODULE$.recordToRichRecord(read)), (Seq<Object>)Predef$.MODULE$.wrapIntArray(RichAlignmentRecord$.MODULE$.recordToRichRecord(read).qualityScores()));
    }

    public RDD<AlignmentRecord> realignIndels(RDD<AlignmentRecord> rdd) {
        RDD rDD;
        if (this.dataIsSorted()) {
            rDD = rdd.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(AlignmentRecord r) {
                    return Predef$.MODULE$.Boolean2boolean(r.getReadMapped());
                }
            });
        } else {
            OrderedRDDFunctions qual$1 = SparkContext$.MODULE$.rddToOrderedRDDFunctions(rdd.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(AlignmentRecord r) {
                    return Predef$.MODULE$.Boolean2boolean(r.getReadMapped());
                }
            }).keyBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ReferencePosition apply(AlignmentRecord r) {
                    return (ReferencePosition)ReferencePosition$.MODULE$.apply(r).get();
                }
            }), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()), ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(AlignmentRecord.class));
            boolean x$22 = qual$1.sortByKey$default$1();
            int x$23 = qual$1.sortByKey$default$2();
            RDD sr = qual$1.sortByKey(x$22, x$23);
            rDD = sr.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final AlignmentRecord apply(Tuple2<ReferencePosition, AlignmentRecord> kv) {
                    return (AlignmentRecord)kv._2();
                }
            }, ClassTag$.MODULE$.apply(AlignmentRecord.class));
        }
        RDD sortedRdd = rDD;
        RDD rich_rdd = sortedRdd.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RichAlignmentRecord apply(AlignmentRecord x$21) {
                return new RichAlignmentRecord(x$21);
            }
        }, ClassTag$.MODULE$.apply(RichAlignmentRecord.class));
        this.log().info("Generating realignment targets...");
        TreeSet<IndelRealignmentTarget> targets = RealignmentTargetFinder$.MODULE$.apply((RDD<RichAlignmentRecord>)rich_rdd, this.maxIndelSize(), this.maxTargetSize());
        this.log().info("Grouping reads by target...");
        RDD<Tuple2<Option<IndelRealignmentTarget>, Iterable<RichAlignmentRecord>>> readsMappedToTarget = RealignIndels$.MODULE$.mapTargets((RDD<RichAlignmentRecord>)rich_rdd, targets);
        this.log().info("Sorting reads by reference in ADAM RDD");
        return readsMappedToTarget.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RealignIndels $outer;

            public final Iterable<RichAlignmentRecord> apply(Tuple2<Option<IndelRealignmentTarget>, Iterable<RichAlignmentRecord>> targetGroup) {
                return this.$outer.realignTargetGroup(targetGroup);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(RichAlignmentRecord.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AlignmentRecord apply(RichAlignmentRecord r) {
                return r.record();
            }
        }, ClassTag$.MODULE$.apply(AlignmentRecord.class));
    }

    public RealignIndels(ConsensusGenerator consensusModel, boolean dataIsSorted, int maxIndelSize, int maxConsensusNumber, double lodThreshold, int maxTargetSize) {
        this.consensusModel = consensusModel;
        this.dataIsSorted = dataIsSorted;
        this.maxIndelSize = maxIndelSize;
        this.maxConsensusNumber = maxConsensusNumber;
        this.lodThreshold = lodThreshold;
        this.maxTargetSize = maxTargetSize;
        Logging.class.$init$((Logging)this);
    }
}

