/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import org.apache.spark.Logging;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.Rod;
import org.bdgenomics.adam.rdd.PileupAggregator;
import org.bdgenomics.adam.rdd.PileupAggregator$;
import org.bdgenomics.formats.avro.Pileup;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001A3A!\u0001\u0002\u0001\u0017\ty!k\u001c3S\t\u00123UO\\2uS>t7O\u0003\u0002\u0004\t\u0005\u0019!\u000f\u001a3\u000b\u0005\u00151\u0011\u0001B1eC6T!a\u0002\u0005\u0002\u0015\t$w-\u001a8p[&\u001c7OC\u0001\n\u0003\ry'oZ\u0002\u0001'\u0011\u0001ABE\u000b\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\ti1#\u0003\u0002\u0015\u001d\ta1+\u001a:jC2L'0\u00192mKB\u0011acG\u0007\u0002/)\u0011\u0001$G\u0001\u0006gB\f'o\u001b\u0006\u00035!\ta!\u00199bG\",\u0017B\u0001\u000f\u0018\u0005\u001daunZ4j]\u001eD\u0001b\u0001\u0001\u0003\u0002\u0003\u0006IA\b\t\u0004?\u0005\u001aS\"\u0001\u0011\u000b\u0005\r9\u0012B\u0001\u0012!\u0005\r\u0011F\t\u0012\t\u0003I\u001dj\u0011!\n\u0006\u0003M\u0011\ta!\\8eK2\u001c\u0018B\u0001\u0015&\u0005\r\u0011v\u000e\u001a\u0005\u0006U\u0001!\taK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00051r\u0003CA\u0017\u0001\u001b\u0005\u0011\u0001\"B\u0002*\u0001\u0004q\u0002\"\u0002\u0019\u0001\t\u0003\t\u0014AF1eC6\u001c\u0006\u000f\\5u%>$7OQ=TC6\u0004H.Z:\u0015\u0003yAQa\r\u0001\u0005\u0002Q\nq#\u00193b[\u0012Kg/\u001b3f%>$7OQ=TC6\u0004H.Z:\u0015\u0003U\u00022aH\u00117!\u0011iq'\u000f\u001f\n\u0005ar!A\u0002+va2,'\u0007\u0005\u0002%u%\u00111(\n\u0002\u0012%\u00164WM]3oG\u0016\u0004vn]5uS>t\u0007cA\u001fFG9\u0011ah\u0011\b\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003*\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u0005\u0011s\u0011a\u00029bG.\fw-Z\u0005\u0003\r\u001e\u0013A\u0001T5ti*\u0011AI\u0004\u0005\u0006\u0013\u0002!\t!M\u0001\u0012C\u0012\fW.Q4he\u0016<\u0017\r^3S_\u0012\u001c\b\"B&\u0001\t\u0003a\u0015aD1eC6\u0014v\u000eZ\"pm\u0016\u0014\u0018mZ3\u0015\u00035\u0003\"!\u0004(\n\u0005=s!A\u0002#pk\ndW\r")
public class RodRDDFunctions
implements Serializable,
Logging {
    private final RDD<Rod> rdd;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public RDD<Rod> adamSplitRodsBySamples() {
        return this.rdd.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<Rod> apply(Rod x$15) {
                return x$15.splitBySamples();
            }
        }, ClassTag$.MODULE$.apply(Rod.class));
    }

    public RDD<Tuple2<ReferencePosition, List<Rod>>> adamDivideRodsBySamples() {
        return this.rdd.keyBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ReferencePosition apply(Rod x$16) {
                return x$16.position();
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<ReferencePosition, List<Rod>> apply(Tuple2<ReferencePosition, Rod> r) {
                return new Tuple2(r._1(), ((Rod)r._2()).splitBySamples());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public RDD<Rod> adamAggregateRods() {
        PileupAggregator helper = new PileupAggregator(PileupAggregator$.MODULE$.$lessinit$greater$default$1());
        return this.rdd.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<ReferencePosition, List<Pileup>> apply(Rod r) {
                return new Tuple2((Object)r.position(), r.pileups());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1)new Serializable(this, helper){
            public static final long serialVersionUID = 0L;
            private final PileupAggregator helper$1;

            public final Tuple2<ReferencePosition, List<Pileup>> apply(Tuple2<ReferencePosition, List<Pileup>> kv) {
                return new Tuple2(kv._1(), this.helper$1.flatten((Iterable<Pileup>)((Iterable)kv._2())));
            }
            {
                this.helper$1 = helper$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Rod apply(Tuple2<ReferencePosition, List<Pileup>> kv) {
                return new Rod((ReferencePosition)kv._1(), (List<Pileup>)((List)kv._2()));
            }
        }, ClassTag$.MODULE$.apply(Rod.class));
    }

    public double adamRodCoverage() {
        long totalBases = BoxesRunTime.unboxToLong((Object)this.rdd.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(Rod x$17) {
                return x$17.pileups().length();
            }
        }, ClassTag$.MODULE$.Long()).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(long x$18, long x$19) {
                return this.apply$mcJJJ$sp(x$18, x$19);
            }

            public long apply$mcJJJ$sp(long x$18, long x$19) {
                return x$18 + x$19;
            }
        }));
        return (double)totalBases / (double)this.rdd.count();
    }

    public RodRDDFunctions(RDD<Rod> rdd) {
        this.rdd = rdd;
        Logging.class.$init$((Logging)this);
    }
}

