/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.variation;

import fi.tkk.ics.hadoop.bam.VCFFormat;
import fi.tkk.ics.hadoop.bam.VCFInputFormat;
import fi.tkk.ics.hadoop.bam.VariantContextWritable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.converters.VariantContextConverter;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.VariantContext;
import org.bdgenomics.adam.rdd.variation.ADAMVCFOutputFormat;
import org.bdgenomics.adam.rdd.variation.ADAMVCFOutputFormat$;
import org.bdgenomics.adam.rdd.variation.ADAMVariationContext$;
import org.bdgenomics.adam.rdd.variation.GenotypeRDDFunctions;
import org.bdgenomics.adam.rdd.variation.VariantContextRDDFunctions;
import org.bdgenomics.adam.util.HadoopUtil$;
import org.bdgenomics.formats.avro.DatabaseVariantAnnotation;
import org.bdgenomics.formats.avro.Genotype;
import org.slf4j.Logger;
import parquet.hadoop.util.ContextUtil;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ur!B\u0001\u0003\u0011\u0003i\u0011\u0001F!E\u000363\u0016M]5bi&|gnQ8oi\u0016DHO\u0003\u0002\u0004\t\u0005Ia/\u0019:jCRLwN\u001c\u0006\u0003\u000b\u0019\t1A\u001d3e\u0015\t9\u0001\"\u0001\u0003bI\u0006l'BA\u0005\u000b\u0003)\u0011GmZ3o_6L7m\u001d\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001A\u0011abD\u0007\u0002\u0005\u0019)\u0001C\u0001E\u0001#\t!\u0012\tR!N-\u0006\u0014\u0018.\u0019;j_:\u001cuN\u001c;fqR\u001c2a\u0004\n\u0019!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fMB\u00111#G\u0005\u00035Q\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQ\u0001H\b\u0005\u0002u\ta\u0001P5oSRtD#A\u0007\t\u000b}yA1\u0001\u0011\u0002EM\u0004\u0018M]6D_:$X\r\u001f;U_\u0006#\u0015)\u0014,be&\fG/[8o\u0007>tG/\u001a=u)\t\tC\u0010\u0005\u0002\u000fE\u0019!\u0001C\u0001\u0001$'\u0011\u0011#\u0003\u0007\u0013\u0011\u0005\u0015RS\"\u0001\u0014\u000b\u0005\u001dB\u0013!B:qCJ\\'BA\u0015\u000b\u0003\u0019\t\u0007/Y2iK&\u00111F\n\u0002\b\u0019><w-\u001b8h\u0011!i#E!A!\u0002\u0013q\u0013AA:d!\t)s&\u0003\u00021M\ta1\u000b]1sW\u000e{g\u000e^3yi\")AD\tC\u0001eQ\u0011\u0011e\r\u0005\u0006[E\u0002\rA\f\u0005\u0006k\t\"\tAN\u0001\fC\u0012\fWNV\"G\u0019>\fG\rF\u00028\u0005.\u00032\u0001\u000f\u001e=\u001b\u0005I$BA\u0003'\u0013\tY\u0014HA\u0002S\t\u0012\u0003\"!\u0010!\u000e\u0003yR!a\u0010\u0004\u0002\r5|G-\u001a7t\u0013\t\teH\u0001\bWCJL\u0017M\u001c;D_:$X\r\u001f;\t\u000b\r#\u0004\u0019\u0001#\u0002\u0011\u0019LG.\u001a)bi\"\u0004\"!\u0012%\u000f\u0005M1\u0015BA$\u0015\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011J\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001d#\u0002b\u0002'5!\u0003\u0005\r!T\u0001\u0005I&\u001cG\u000fE\u0002\u0014\u001dBK!a\u0014\u000b\u0003\r=\u0003H/[8o!\ti\u0014+\u0003\u0002S}\t\u00112+Z9vK:\u001cW\rR5di&|g.\u0019:z\u0011\u0015!&\u0005\"\u0001V\u0003U\tG-Y7W\u0007\u001a\u000beN\\8uCRLwN\u001c'pC\u0012$2AV0a!\rA$h\u0016\t\u00031vk\u0011!\u0017\u0006\u00035n\u000bA!\u0019<s_*\u0011A\fC\u0001\bM>\u0014X.\u0019;t\u0013\tq\u0016LA\rECR\f'-Y:f-\u0006\u0014\u0018.\u00198u\u0003:tw\u000e^1uS>t\u0007\"B\"T\u0001\u0004!\u0005b\u0002'T!\u0003\u0005\r!\u0014\u0005\u0006E\n\"\taY\u0001\fC\u0012\fWNV\"G'\u00064X\r\u0006\u0003eO\"T\u0007CA\nf\u0013\t1GC\u0001\u0003V]&$\b\"B\"b\u0001\u0004!\u0005\"B5b\u0001\u00049\u0014\u0001\u0003<be&\fg\u000e^:\t\u000f1\u000b\u0007\u0013!a\u0001\u001b\"9ANII\u0001\n\u0003i\u0017!F1eC646I\u0012'pC\u0012$C-\u001a4bk2$HEM\u000b\u0002]*\u0012Qj\\\u0016\u0002aB\u0011\u0011O^\u0007\u0002e*\u00111\u000f^\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u001e\u000b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002xe\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000fe\u0014\u0013\u0013!C\u0001[\u0006y\u0012\rZ1n-\u000e3\u0015I\u001c8pi\u0006$\u0018n\u001c8M_\u0006$G\u0005Z3gCVdG\u000f\n\u001a\t\u000fm\u0014\u0013\u0013!C\u0001[\u0006)\u0012\rZ1n-\u000e35+\u0019<fI\u0011,g-Y;mi\u0012\u001a\u0004\"B\u0017\u001f\u0001\u0004q\u0003\"\u0002@\u0010\t\u0007y\u0018A\u0006:eIR{g+\u0019:jC:$8i\u001c8uKb$(\u000b\u0012#\u0015\t\u0005\u0005\u0011q\u0001\t\u0004\u001d\u0005\r\u0011bAA\u0003\u0005\tQb+\u0019:jC:$8i\u001c8uKb$(\u000b\u0012#Gk:\u001cG/[8og\")Q! a\u0001o!9\u00111B\b\u0005\u0004\u00055\u0011\u0001\u0006:eIR{\u0017\tR!N\u000f\u0016tw\u000e^=qKJ#E\t\u0006\u0003\u0002\u0010\u0005U\u0001c\u0001\b\u0002\u0012%\u0019\u00111\u0003\u0002\u0003)\u001d+gn\u001c;za\u0016\u0014F\t\u0012$v]\u000e$\u0018n\u001c8t\u0011\u001d)\u0011\u0011\u0002a\u0001\u0003/\u0001B\u0001\u000f\u001e\u0002\u001aA\u0019\u0001,a\u0007\n\u0007\u0005u\u0011L\u0001\u0005HK:|G/\u001f9f\u0011%\t\tcDA\u0001\n\u0013\t\u0019#A\u0006sK\u0006$'+Z:pYZ,GCAA\u0013!\u0011\t9#!\r\u000e\u0005\u0005%\"\u0002BA\u0016\u0003[\tA\u0001\\1oO*\u0011\u0011qF\u0001\u0005U\u00064\u0018-\u0003\u0003\u00024\u0005%\"AB(cU\u0016\u001cG\u000f")
public class ADAMVariationContext
implements Serializable,
Logging {
    private final SparkContext sc;
    private transient Logger org$apache$spark$Logging$$log_;

    public static GenotypeRDDFunctions rddToADAMGenotypeRDD(RDD<Genotype> rDD) {
        return ADAMVariationContext$.MODULE$.rddToADAMGenotypeRDD(rDD);
    }

    public static VariantContextRDDFunctions rddToVariantContextRDD(RDD<VariantContext> rDD) {
        return ADAMVariationContext$.MODULE$.rddToVariantContextRDD(rDD);
    }

    public static ADAMVariationContext sparkContextToADAMVariationContext(SparkContext sparkContext) {
        return ADAMVariationContext$.MODULE$.sparkContextToADAMVariationContext(sparkContext);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public RDD<VariantContext> adamVCFLoad(String filePath, Option<SequenceDictionary> dict) {
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Reading VCF file from %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        Job job = HadoopUtil$.MODULE$.newJob(this.sc);
        VariantContextConverter vcc = new VariantContextConverter(dict);
        RDD records = this.sc.newAPIHadoopFile(filePath, VCFInputFormat.class, LongWritable.class, VariantContextWritable.class, ContextUtil.getConfiguration((JobContext)job));
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Converted %d records")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)records.count())})));
        return records.flatMap((Function1)new Serializable(this, vcc){
            public static final long serialVersionUID = 0L;
            private final VariantContextConverter vcc$1;

            public final Seq<VariantContext> apply(Tuple2<LongWritable, VariantContextWritable> p) {
                return this.vcc$1.convert(((VariantContextWritable)p._2()).get());
            }
            {
                this.vcc$1 = vcc$1;
            }
        }, ClassTag$.MODULE$.apply(VariantContext.class));
    }

    public Option<SequenceDictionary> adamVCFLoad$default$2() {
        return None$.MODULE$;
    }

    public RDD<DatabaseVariantAnnotation> adamVCFAnnotationLoad(String filePath, Option<SequenceDictionary> dict) {
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Reading VCF file from %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        Job job = HadoopUtil$.MODULE$.newJob(this.sc);
        VariantContextConverter vcc = new VariantContextConverter(dict);
        RDD records = this.sc.newAPIHadoopFile(filePath, VCFInputFormat.class, LongWritable.class, VariantContextWritable.class, ContextUtil.getConfiguration((JobContext)job));
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Converted %d records")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)records.count())})));
        return records.map((Function1)new Serializable(this, vcc){
            public static final long serialVersionUID = 0L;
            private final VariantContextConverter vcc$2;

            public final DatabaseVariantAnnotation apply(Tuple2<LongWritable, VariantContextWritable> p) {
                return this.vcc$2.convertToAnnotation(((VariantContextWritable)p._2()).get());
            }
            {
                this.vcc$2 = vcc$2;
            }
        }, ClassTag$.MODULE$.apply(DatabaseVariantAnnotation.class));
    }

    public Option<SequenceDictionary> adamVCFAnnotationLoad$default$2() {
        return None$.MODULE$;
    }

    public void adamVCFSave(String filePath, RDD<VariantContext> variants, Option<SequenceDictionary> dict) {
        VCFFormat vcfFormat;
        VCFFormat vCFFormat = vcfFormat = VCFFormat.inferFromFilePath((String)filePath);
        VCFFormat vCFFormat2 = VCFFormat.VCF;
        Predef$.MODULE$.assert(!(vCFFormat != null ? !vCFFormat.equals(vCFFormat2) : vCFFormat2 != null), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "BCF not yet supported";
            }
        });
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Writing %s file to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{vcfFormat, filePath})));
        ADAMVCFOutputFormat$.MODULE$.setHeader((Seq<String>)ADAMVariationContext$.MODULE$.rddToVariantContextRDD(variants).adamGetCallsetSamples());
        VariantContextConverter converter = new VariantContextConverter(dict);
        RDD gatkVCs = variants.map((Function1)new Serializable(this, converter){
            public static final long serialVersionUID = 0L;
            private final VariantContextConverter converter$1;

            /*
             * WARNING - void declaration
             */
            public final VariantContextWritable apply(VariantContext v) {
                void var2_2;
                VariantContextWritable vcw = new VariantContextWritable();
                vcw.set(this.converter$1.convert(v));
                return var2_2;
            }
            {
                this.converter$1 = converter$1;
            }
        }, ClassTag$.MODULE$.apply(VariantContextWritable.class));
        RDD withKey = gatkVCs.keyBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LongWritable apply(VariantContextWritable v) {
                return new LongWritable((long)v.get().getStart());
            }
        });
        Configuration conf = this.sc.hadoopConfiguration();
        conf.set("hadoopbam.vcf.output-format", vcfFormat.toString());
        SparkContext$.MODULE$.rddToPairRDDFunctions(withKey, ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(VariantContextWritable.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms())).saveAsNewAPIHadoopFile(filePath, LongWritable.class, VariantContextWritable.class, ADAMVCFOutputFormat.class, conf);
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Write %d records")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)gatkVCs.count())})));
    }

    public Option<SequenceDictionary> adamVCFSave$default$3() {
        return None$.MODULE$;
    }

    public ADAMVariationContext(SparkContext sc) {
        this.sc = sc;
        Logging.class.$init$((Logging)this);
    }
}

