/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rich;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.samtools.TextCigarCodec;
import org.bdgenomics.adam.rich.RichAlignmentRecord;
import org.bdgenomics.formats.avro.AlignmentRecord;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class RichAlignmentRecord$ {
    public static final RichAlignmentRecord$ MODULE$;
    private final TextCigarCodec CIGAR_CODEC;
    private final Regex ILLUMINA_READNAME_REGEX;
    private final Pattern cigarPattern;

    static {
        new RichAlignmentRecord$();
    }

    public TextCigarCodec CIGAR_CODEC() {
        return this.CIGAR_CODEC;
    }

    public Regex ILLUMINA_READNAME_REGEX() {
        return this.ILLUMINA_READNAME_REGEX;
    }

    public Pattern cigarPattern() {
        return this.cigarPattern;
    }

    public int referenceLengthFromCigar(String cigar) {
        Matcher m = this.cigarPattern().matcher(cigar);
        int i = 0;
        int len = 0;
        while (i < cigar.length()) {
            if (m.find(i)) {
                String op = m.group(2);
                if ("MDNX=".indexOf(op) != -1) {
                    len += new StringOps(Predef$.MODULE$.augmentString(m.group(1))).toInt();
                }
                i = m.end();
                continue;
            }
            return len;
        }
        return len;
    }

    public RichAlignmentRecord apply(AlignmentRecord record) {
        return new RichAlignmentRecord(record);
    }

    public RichAlignmentRecord recordToRichRecord(AlignmentRecord record) {
        return new RichAlignmentRecord(record);
    }

    public AlignmentRecord richRecordToRecord(RichAlignmentRecord record) {
        return record.record();
    }

    private RichAlignmentRecord$() {
        MODULE$ = this;
        this.CIGAR_CODEC = TextCigarCodec.getSingleton();
        this.ILLUMINA_READNAME_REGEX = new StringOps(Predef$.MODULE$.augmentString("[a-zA-Z0-9]+:[0-9]:([0-9]+):([0-9]+):([0-9]+).*")).r();
        this.cigarPattern = Pattern.compile("([0-9]+)([MIDNSHPX=])");
    }
}

