/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.converters;

import htsjdk.samtools.SAMFileReader;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypeType;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.bdgenomics.adam.converters.VariantContextConverter;
import org.bdgenomics.adam.converters.VariantContextConverter$;
import org.bdgenomics.adam.converters.VariantContextConverterSuite$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceDictionary$;
import org.bdgenomics.adam.models.VariantContext$;
import org.bdgenomics.adam.rich.RichVariant;
import org.bdgenomics.adam.rich.RichVariant$;
import org.bdgenomics.formats.avro.Contig;
import org.bdgenomics.formats.avro.Genotype;
import org.bdgenomics.formats.avro.GenotypeAllele;
import org.bdgenomics.formats.avro.Variant;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u3A!\u0001\u0002\u0001\u0017\tab+\u0019:jC:$8i\u001c8uKb$8i\u001c8wKJ$XM]*vSR,'BA\u0002\u0005\u0003)\u0019wN\u001c<feR,'o\u001d\u0006\u0003\u000b\u0019\tA!\u00193b[*\u0011q\u0001C\u0001\u000bE\u0012<WM\\8nS\u000e\u001c(\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!BA\b\t\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002\u0012\u001d\tAa)\u001e8Tk&$X\rC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u0005!9\u0001\u0004\u0001b\u0001\n\u0003I\u0012A\u00033jGRLwN\\1ssV\t!\u0004\u0005\u0002\u001c=5\tAD\u0003\u0002\u001e\t\u00051Qn\u001c3fYNL!a\b\u000f\u0003%M+\u0017/^3oG\u0016$\u0015n\u0019;j_:\f'/\u001f\u0005\u0007C\u0001\u0001\u000b\u0011\u0002\u000e\u0002\u0017\u0011L7\r^5p]\u0006\u0014\u0018\u0010\t\u0005\u0006G\u0001!\t\u0001J\u0001\u000fO\u0006$8n\u0015(W\u0005VLG\u000eZ3s+\u0005)\u0003C\u0001\u0014.\u001b\u00059#B\u0001\u0015*\u000391\u0018M]5b]R\u001cwN\u001c;fqRT!AK\u0016\u0002\u000fY\f'/[1oi*\tA&\u0001\u0004iiNTGm[\u0005\u0003]\u001d\u0012QCV1sS\u0006tGoQ8oi\u0016DHOQ;jY\u0012,'\u000fC\u00031\u0001\u0011\u0005A%\u0001\u000ehCR\\W*\u001e7uS\u0006cG.\u001a7jGNseKQ;jY\u0012,'\u000fC\u00033\u0001\u0011\u0005A%\u0001\u0006hCR\\'+\u001a4T\u001dZCQ\u0001\u000e\u0001\u0005\u0002\u0011\nabZ1uW\u000eseKQ;jY\u0012,'\u000fC\u00037\u0001\u0011\u0005q'\u0001\bbI\u0006l7K\u0014,Ck&dG-\u001a:\u0015\u0005a\"\u0005CA\u001dB\u001d\tQt(D\u0001<\u0015\taT(\u0001\u0003bmJ|'B\u0001 \u0007\u0003\u001d1wN]7biNL!\u0001Q\u001e\u0002\u000fY\u000b'/[1oi&\u0011!i\u0011\u0002\b\u0005VLG\u000eZ3s\u0015\t\u00015\bC\u0004FkA\u0005\t\u0019\u0001$\u0002\r\r|g\u000e^5h!\t9UJ\u0004\u0002I\u00176\t\u0011JC\u0001K\u0003\u0015\u00198-\u00197b\u0013\ta\u0015*\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001d>\u0013aa\u0015;sS:<'B\u0001'J\u0011\u001d\t\u0006!%A\u0005\u0002I\u000b\u0001$\u00193b[NseKQ;jY\u0012,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\u0005\u0019&F\u0001$UW\u0005)\u0006C\u0001,\\\u001b\u00059&B\u0001-Z\u0003%)hn\u00195fG.,GM\u0003\u0002[\u0013\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005q;&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class VariantContextConverterSuite
extends FunSuite {
    private final SequenceDictionary dictionary;

    public SequenceDictionary dictionary() {
        return this.dictionary;
    }

    public VariantContextBuilder gatkSNVBuilder() {
        return new VariantContextBuilder().alleles((Collection)JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Allele[]{Allele.create((String)"A", (boolean)true), Allele.create((String)"T")})))).start(1L).stop(1L).chr("1");
    }

    public VariantContextBuilder gatkMultiAllelicSNVBuilder() {
        return new VariantContextBuilder().alleles((Collection)JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Allele[]{Allele.create((String)"A", (boolean)true), Allele.create((String)"T"), Allele.create((String)"G")})))).start(1L).stop(1L).chr("1");
    }

    public VariantContextBuilder gatkRefSNV() {
        return new VariantContextBuilder().alleles((Collection)JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Allele[]{Allele.create((String)"A", (boolean)true), Allele.create((String)"<NON_REF>", (boolean)false)})))).start(1L).stop(1L).chr("1");
    }

    public VariantContextBuilder gatkCNVBuilder() {
        return new VariantContextBuilder().alleles((Collection)JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Allele[]{Allele.create((String)"A", (boolean)true), Allele.create((String)"<CN0>", (boolean)false)})))).start(10L).stop(20L).chr("1");
    }

    public Variant.Builder adamSNVBuilder(String contig) {
        return Variant.newBuilder().setContig(Contig.newBuilder().setContigName((CharSequence)contig).build()).setStart(Predef$.MODULE$.long2Long(0L)).setReferenceAllele((CharSequence)"A").setAlternateAllele((CharSequence)"T");
    }

    public String adamSNVBuilder$default$1() {
        return "1";
    }

    public VariantContextConverterSuite() {
        String path = ClassLoader.getSystemClassLoader().getResource("dict_with_accession.dict").getFile();
        this.dictionary = SequenceDictionary$.MODULE$.apply(SAMFileReader.getSequenceDictionary((File)new File(path)));
        this.test("Convert GATK site-only SNV to ADAM", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VariantContextConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                VariantContextConverter converter = new VariantContextConverter(VariantContextConverter$.MODULE$.$lessinit$greater$default$1());
                Seq adamVCs = converter.convert(this.$outer.gatkSNVBuilder().make());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)adamVCs.length()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                org.bdgenomics.adam.models.VariantContext adamVC = (org.bdgenomics.adam.models.VariantContext)adamVCs.head();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)adamVC.genotypes().size()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)0), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                RichVariant variant = adamVC.variant();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(RichVariant$.MODULE$.richVariantToVariant(variant).getContig().getContigName());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)"1", $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)"1", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(RichVariant$.MODULE$.richVariantToVariant(variant).getReferenceAllele());
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)"A", $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)"A", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(RichVariant$.MODULE$.richVariantToVariant(variant).getStart());
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToLong((long)0L), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)0L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Convert GATK site-only SNV to ADAM with contig conversion", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VariantContextConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                VariantContextConverter converter = new VariantContextConverter((Option)new Some((Object)this.$outer.dictionary()));
                Seq adamVCs = converter.convert(this.$outer.gatkSNVBuilder().make());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)adamVCs.length()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                org.bdgenomics.adam.models.VariantContext adamVC = (org.bdgenomics.adam.models.VariantContext)adamVCs.head();
                RichVariant variant = adamVC.variant();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(RichVariant$.MODULE$.richVariantToVariant(variant).getContig().getContigName());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)"NC_000001.10", $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)"NC_000001.10", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Convert GATK site-only CNV to ADAM", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VariantContextConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                VariantContextConverter converter = new VariantContextConverter(VariantContextConverter$.MODULE$.$lessinit$greater$default$1());
                Seq adamVCs = converter.convert(this.$outer.gatkCNVBuilder().make());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)adamVCs.length()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                org.bdgenomics.adam.models.VariantContext adamVC = (org.bdgenomics.adam.models.VariantContext)adamVCs.head();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)adamVC.genotypes().size()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)0), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                RichVariant variant = adamVC.variant();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(RichVariant$.MODULE$.richVariantToVariant(variant).getContig().getContigName());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)"1", $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)"1", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(RichVariant$.MODULE$.richVariantToVariant(variant).getReferenceAllele());
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)"A", $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)"A", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(RichVariant$.MODULE$.richVariantToVariant(variant).getAlternateAllele());
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)"<CN0>", $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)"<CN0>", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(RichVariant$.MODULE$.richVariantToVariant(variant).getStart());
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToLong((long)9L), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)9L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(RichVariant$.MODULE$.richVariantToVariant(variant).getEnd());
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToLong((long)20L), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)20L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Convert GATK SNV w/ genotypes w/ phase information to ADAM", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VariantContextConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                VariantContextBuilder vcb = this.$outer.gatkSNVBuilder();
                Tuple2[] tuple2Array = new Tuple2[2];
                Predef$ predef$ = Predef$.MODULE$;
                Integer n = new Integer(50);
                Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                tuple2Array[0] = new Tuple2((Object)"PQ", (Object)n);
                Predef$ predef$2 = Predef$.MODULE$;
                Integer n2 = new Integer(1);
                Predef.ArrowAssoc$ arrowAssoc$2 = Predef.ArrowAssoc$.MODULE$;
                tuple2Array[1] = new Tuple2((Object)"PS", (Object)n2);
                scala.collection.immutable.Map genotypeAttributes = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
                VariantContext vc = vcb.genotypes(new htsjdk.variant.variantcontext.Genotype[]{GenotypeBuilder.create((String)"NA12878", (List)vcb.getAlleles(), (java.util.Map)JavaConversions$.MODULE$.mapAsJavaMap((Map)genotypeAttributes))}).make();
                VariantContextConverter converter = new VariantContextConverter(VariantContextConverter$.MODULE$.$lessinit$greater$default$1());
                Seq adamVCs = converter.convert(vc);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)adamVCs.length()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Seq adamGTs = (Seq)adamVCs.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Genotype> apply(org.bdgenomics.adam.models.VariantContext x$1) {
                        return x$1.genotypes();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)adamGTs.length()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Genotype adamGT = (Genotype)adamGTs.head();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(JavaConversions$.MODULE$.asScalaBuffer(adamGT.getAlleles()).sameElements((GenIterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GenotypeAllele[]{GenotypeAllele.Ref, GenotypeAllele.Alt}))), "scala.collection.JavaConversions.asScalaBuffer[org.bdgenomics.formats.avro.GenotypeAllele](adamGT.getAlleles()).sameElements[org.bdgenomics.formats.avro.GenotypeAllele](immutable.this.List.apply[org.bdgenomics.formats.avro.GenotypeAllele](Ref, Alt))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(adamGT.getPhaseSetId());
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(adamGT.getPhaseQuality());
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)50), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)50), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Convert GATK SNV with different filters to ADAM", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VariantContextConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                VariantContextBuilder vcb = this.$outer.gatkSNVBuilder();
                vcb.genotypes(new htsjdk.variant.variantcontext.Genotype[]{GenotypeBuilder.create((String)"NA12878", (List)vcb.getAlleles())});
                VariantContextConverter converter = new VariantContextConverter(VariantContextConverter$.MODULE$.$lessinit$greater$default$1());
                Seq adamVCs = converter.convert(vcb.make());
                Genotype adamGT = (Genotype)((IterableLike)adamVCs.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Genotype> apply(org.bdgenomics.adam.models.VariantContext x$2) {
                        return x$2.genotypes();
                    }
                }, Seq$.MODULE$.canBuildFrom())).head();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(adamGT.getVariantCallingAnnotations().getVariantIsPassing());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq(null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                vcb.unfiltered().passFilters();
                Seq adamVCs2 = converter.convert(vcb.make());
                Genotype adamGT2 = (Genotype)((IterableLike)adamVCs2.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Genotype> apply(org.bdgenomics.adam.models.VariantContext x$3) {
                        return x$3.genotypes();
                    }
                }, Seq$.MODULE$.canBuildFrom())).head();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.Boolean2boolean(adamGT2.getVariantCallingAnnotations().getVariantIsPassing()), "scala.this.Predef.Boolean2boolean(adamGT.getVariantCallingAnnotations().getVariantIsPassing())");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                vcb.unfiltered().filter("LowMQ");
                Seq adamVCs3 = converter.convert(vcb.make());
                Genotype adamGT3 = (Genotype)((IterableLike)adamVCs3.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Genotype> apply(org.bdgenomics.adam.models.VariantContext x$4) {
                        return x$4.genotypes();
                    }
                }, Seq$.MODULE$.canBuildFrom())).head();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(adamGT3.getVariantCallingAnnotations().getVariantIsPassing());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToBoolean((boolean)false), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)false), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(JavaConversions$.MODULE$.asScalaBuffer(adamGT3.getVariantCallingAnnotations().getVariantFilters()).sameElements((GenIterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LowMQ"}))), "scala.collection.JavaConversions.asScalaBuffer[CharSequence](adamGT.getVariantCallingAnnotations().getVariantFilters()).sameElements[CharSequence](immutable.this.List.apply[String](\"LowMQ\"))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Convert ADAM site-only SNV to GATK", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VariantContextConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                org.bdgenomics.adam.models.VariantContext vc = VariantContext$.MODULE$.apply(this.$outer.adamSNVBuilder(this.$outer.adamSNVBuilder$default$1()).build());
                VariantContextConverter converter = new VariantContextConverter(VariantContextConverter$.MODULE$.$lessinit$greater$default$1());
                VariantContext gatkVC = converter.convert(vc);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(gatkVC.getChr());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"1", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"1", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)gatkVC.getStart()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)gatkVC.getEnd()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(gatkVC.getReference());
                Allele $org_scalatest_assert_macro_right = Allele.create((String)"A", (boolean)true);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(JavaConversions$.MODULE$.asScalaBuffer(gatkVC.getAlternateAlleles()).sameElements((GenIterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Allele[]{Allele.create((String)"T")}))), "scala.collection.JavaConversions.asScalaBuffer[htsjdk.variant.variantcontext.Allele](gatkVC.getAlternateAlleles()).sameElements[htsjdk.variant.variantcontext.Allele](immutable.this.List.apply[htsjdk.variant.variantcontext.Allele](htsjdk.variant.variantcontext.Allele.create(\"T\")))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(gatkVC.hasLog10PError(), "gatkVC.hasLog10PError()"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(gatkVC.hasID(), "gatkVC.hasID()"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(gatkVC.filtersWereApplied(), "gatkVC.filtersWereApplied()"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Convert ADAM site-only SNV to GATK with contig conversion", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VariantContextConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                org.bdgenomics.adam.models.VariantContext vc = VariantContext$.MODULE$.apply(this.$outer.adamSNVBuilder("NC_000001.10").build());
                VariantContextConverter converter = new VariantContextConverter((Option)new Some((Object)this.$outer.dictionary()));
                VariantContext gatkVC = converter.convert(vc);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(gatkVC.getChr());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"1", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"1", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Convert ADAM SNV w/ genotypes to GATK", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VariantContextConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Variant variant = this.$outer.adamSNVBuilder(this.$outer.adamSNVBuilder$default$1()).build();
                Genotype genotype = Genotype.newBuilder().setVariant(variant).setSampleId((CharSequence)"NA12878").setAlleles(JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GenotypeAllele[]{GenotypeAllele.Ref, GenotypeAllele.Alt})))).build();
                VariantContextConverter converter = new VariantContextConverter(VariantContextConverter$.MODULE$.$lessinit$greater$default$1());
                VariantContext gatkVC = converter.convert(VariantContext$.MODULE$.apply(variant, (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Genotype[]{genotype})), VariantContext$.MODULE$.apply$default$3()));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)gatkVC.getNSamples()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(gatkVC.hasGenotype("NA12878"), "gatkVC.hasGenotype(\"NA12878\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                htsjdk.variant.variantcontext.Genotype gatkGT = gatkVC.getGenotype("NA12878");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(gatkGT.getType());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)GenotypeType.HET, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)GenotypeType.HET, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Convert GATK multi-allelic sites-only SNVs to ADAM", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ VariantContextConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                VariantContext vc = this.$outer.gatkMultiAllelicSNVBuilder().make();
                VariantContextConverter converter = new VariantContextConverter(VariantContextConverter$.MODULE$.$lessinit$greater$default$1());
                Seq adamVCs = converter.convert(vc);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)adamVCs.length()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)2), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                ((TraversableLike)JavaConversions$.MODULE$.asScalaBuffer(vc.getAlternateAlleles()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Allele, Object> check$ifrefutable$1) {
                        boolean bl = check$ifrefutable$1 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this, vc, adamVCs){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;
                    private final VariantContext vc$1;
                    private final Seq adamVCs$1;

                    public final void apply(Tuple2<Allele, Object> x$5) {
                        if (x$5 != null) {
                            org.bdgenomics.adam.models.VariantContext adamVC = (org.bdgenomics.adam.models.VariantContext)this.adamVCs$1.apply(x$5._2$mcI$sp());
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.$outer.convertToEqualizer(RichVariant$.MODULE$.richVariantToVariant(adamVC.variant()).getReferenceAllele());
                            String $org_scalatest_assert_macro_right = this.vc$1.getReference().getBaseString();
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                            this.$outer.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.$outer.convertToEqualizer(RichVariant$.MODULE$.richVariantToVariant(adamVC.variant()).getAlternateAllele());
                            String $org_scalatest_assert_macro_right2 = ((Allele)x$5._1()).getBaseString();
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                            this.$outer.org$bdgenomics$adam$converters$VariantContextConverterSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            return;
                        }
                        throw new MatchError(x$5);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.vc$1 = vc$1;
                        this.adamVCs$1 = adamVCs$1;
                    }
                });
            }

            public /* synthetic */ VariantContextConverterSuite org$bdgenomics$adam$converters$VariantContextConverterSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Convert GATK multi-allelic SNVs to ADAM", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ VariantContextConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenotypeBuilder gb = new GenotypeBuilder("NA12878", JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Allele[]{Allele.create((String)"T"), Allele.create((String)"G")}))));
                gb.AD(new int[]{4, 2, 3}).PL(new int[]{59, 0, 181, 1, 66, 102});
                VariantContextBuilder vcb = this.$outer.gatkMultiAllelicSNVBuilder();
                vcb.genotypes(new htsjdk.variant.variantcontext.Genotype[]{gb.make()});
                VariantContextConverter converter = new VariantContextConverter(VariantContextConverter$.MODULE$.$lessinit$greater$default$1());
                Seq adamVCs = converter.convert(vcb.make());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)adamVCs.length()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)2), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                adamVCs.foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;

                    public final void apply(org.bdgenomics.adam.models.VariantContext adamVC) {
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)adamVC.genotypes().size()));
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                        this.$outer.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        Genotype adamGT = (Genotype)adamVC.genotypes().head();
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.Boolean2boolean(adamGT.getSplitFromMultiAllelic()), "scala.this.Predef.Boolean2boolean(adamGT.getSplitFromMultiAllelic())");
                        this.$outer.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$bdgenomics$adam$converters$VariantContextConverterSuite$$anonfun$$$outer().convertToEqualizer(adamGT.getReferenceReadDepth());
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)4), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)4), Equality$.MODULE$.default()));
                        this.$outer.org$bdgenomics$adam$converters$VariantContextConverterSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.Boolean2boolean(adamGT.getIsPhased()), "scala.this.Predef.Boolean2boolean(adamGT.getIsPhased())");
                        this.$outer.org$bdgenomics$adam$converters$VariantContextConverterSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                Genotype adamGT1 = (Genotype)((org.bdgenomics.adam.models.VariantContext)adamVCs.apply(0)).genotypes().head();
                Genotype adamGT2 = (Genotype)((org.bdgenomics.adam.models.VariantContext)adamVCs.apply(1)).genotypes().head();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(JavaConversions$.MODULE$.asScalaBuffer(adamGT1.getAlleles()).sameElements((GenIterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GenotypeAllele[]{GenotypeAllele.Alt, GenotypeAllele.OtherAlt}))), "scala.collection.JavaConversions.asScalaBuffer[org.bdgenomics.formats.avro.GenotypeAllele](adamGT1.getAlleles()).sameElements[org.bdgenomics.formats.avro.GenotypeAllele](immutable.this.List.apply[org.bdgenomics.formats.avro.GenotypeAllele](Alt, OtherAlt))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(adamGT1.getAlternateReadDepth());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(JavaConversions$.MODULE$.asScalaBuffer(adamGT1.getGenotypeLikelihoods()).sameElements((GenIterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{59, 0, 181}))), "scala.collection.JavaConversions.asScalaBuffer[Integer](adamGT1.getGenotypeLikelihoods()).sameElements[Any](immutable.this.List.apply[Int](59, 0, 181))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(JavaConversions$.MODULE$.asScalaBuffer(adamGT2.getAlleles()).sameElements((GenIterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GenotypeAllele[]{GenotypeAllele.OtherAlt, GenotypeAllele.Alt}))), "scala.collection.JavaConversions.asScalaBuffer[org.bdgenomics.formats.avro.GenotypeAllele](adamGT2.getAlleles()).sameElements[org.bdgenomics.formats.avro.GenotypeAllele](immutable.this.List.apply[org.bdgenomics.formats.avro.GenotypeAllele](OtherAlt, Alt))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(adamGT2.getAlternateReadDepth());
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(JavaConversions$.MODULE$.asScalaBuffer(adamGT2.getGenotypeLikelihoods()).sameElements((GenIterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{58, 0, 101}))), "scala.collection.JavaConversions.asScalaBuffer[Integer](adamGT2.getGenotypeLikelihoods()).sameElements[Any](immutable.this.List.apply[Int](58, 0, 101))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
            }

            public /* synthetic */ VariantContextConverterSuite org$bdgenomics$adam$converters$VariantContextConverterSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Convert gVCF reference records to ADAM", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VariantContextConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenotypeBuilder gb = new GenotypeBuilder("NA12878", JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Allele[]{Allele.create((String)"A", (boolean)true), Allele.create((String)"A", (boolean)true)}))));
                gb.PL(new int[]{0, 1, 2}).DP(44).attribute("MIN_DP", (Object)BoxesRunTime.boxToInteger((int)38));
                VariantContextBuilder vcb = this.$outer.gatkRefSNV();
                vcb.genotypes(new htsjdk.variant.variantcontext.Genotype[]{gb.make()});
                VariantContextConverter converter = new VariantContextConverter(VariantContextConverter$.MODULE$.$lessinit$greater$default$1());
                Seq adamVCs = converter.convert(vcb.make());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)adamVCs, "length", (long)adamVCs.length(), (long)1);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Seq adamGTs = (Seq)adamVCs.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Genotype> apply(org.bdgenomics.adam.models.VariantContext x$6) {
                        return x$6.genotypes();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)adamGTs.length()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Genotype adamGT = (Genotype)adamGTs.head();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(adamGT.getVariant().getAlternateAllele());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", null, $org_scalatest_assert_macro_left2.$eq$eq$eq(null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(JavaConversions$.MODULE$.asScalaBuffer(adamGT.getAlleles()).sameElements((GenIterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GenotypeAllele[]{GenotypeAllele.Ref, GenotypeAllele.Ref}))), "scala.collection.JavaConversions.asScalaBuffer[org.bdgenomics.formats.avro.GenotypeAllele](adamGT.getAlleles()).sameElements[org.bdgenomics.formats.avro.GenotypeAllele](immutable.this.List.apply[org.bdgenomics.formats.avro.GenotypeAllele](Ref, Ref))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(adamGT.getMinReadDepth());
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)38), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)38), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                List $org_scalatest_assert_macro_left4 = adamGT.getGenotypeLikelihoods();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left4, "isEmpty", $org_scalatest_assert_macro_left4.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(JavaConversions$.MODULE$.asScalaBuffer(adamGT.getNonReferenceLikelihoods()).sameElements((GenIterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), "scala.collection.JavaConversions.asScalaBuffer[Integer](adamGT.getNonReferenceLikelihoods()).sameElements[Any](immutable.this.List.apply[Int](0, 1, 2))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

