/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.parquet_reimpl;

import org.apache.avro.Schema;
import org.bdgenomics.adam.parquet_reimpl.ParquetLister;
import org.bdgenomics.adam.parquet_reimpl.ParquetLister$;
import org.bdgenomics.adam.projections.FieldValue;
import org.bdgenomics.adam.projections.FlatGenotypeField$;
import org.bdgenomics.adam.projections.Projection$;
import org.bdgenomics.formats.avro.FlatGenotype;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]1A!\u0001\u0002\u0001\u0017\t\u0011\u0002+\u0019:rk\u0016$H*[:uKJ\u001cV/\u001b;f\u0015\t\u0019A!\u0001\bqCJ\fX/\u001a;`e\u0016LW\u000e\u001d7\u000b\u0005\u00151\u0011\u0001B1eC6T!a\u0002\u0005\u0002\u0015\t$w-\u001a8p[&\u001c7OC\u0001\n\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taB\u0003\u0002\u0010\u0011\u0005I1oY1mCR,7\u000f^\u0005\u0003#9\u0011\u0001BR;o'VLG/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\t\u0001")
public class ParquetListerSuite
extends FunSuite {
    public ParquetListerSuite() {
        this.test("can list a single small parquet file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetListerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String path = Thread.currentThread().getContextClassLoader().getResource("small_adam.fgenotype").getPath();
                ParquetLister lister = new ParquetLister(ParquetLister$.MODULE$.$lessinit$greater$default$1(), ClassTag$.MODULE$.apply(FlatGenotype.class));
                Seq recs = lister.materialize(path).toSeq();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)recs.length()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)15), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)15), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("can list all the records in a directory", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetListerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String path = Thread.currentThread().getContextClassLoader().getResource("parquet_lister_dir").getPath();
                ParquetLister lister = new ParquetLister(ParquetLister$.MODULE$.$lessinit$greater$default$1(), ClassTag$.MODULE$.apply(FlatGenotype.class));
                Seq recs = lister.materialize(path).toSeq();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)recs.length()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)30), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)30), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("directories with no parquet files should have 0 records", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetListerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String path = Thread.currentThread().getContextClassLoader().getResource("parquet_lister_dir_empty").getPath();
                ParquetLister lister = new ParquetLister(ParquetLister$.MODULE$.$lessinit$greater$default$1(), ClassTag$.MODULE$.apply(FlatGenotype.class));
                Seq recs = lister.materialize(path).toSeq();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)recs.length()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)0), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("uses projections properly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ParquetListerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Schema proj = Projection$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{FlatGenotypeField$.MODULE$.referenceAllele()}));
                String path = Thread.currentThread().getContextClassLoader().getResource("small_adam.fgenotype").getPath();
                ParquetLister lister = new ParquetLister((Option)new Some((Object)proj), ClassTag$.MODULE$.apply(FlatGenotype.class));
                Seq recs = lister.materialize(path).toSeq();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)recs.length()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)15), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)15), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(recs.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FlatGenotype x$1) {
                        return x$1.getReferenceName() == null;
                    }
                }), "recs.forall(((x$1: org.bdgenomics.formats.avro.FlatGenotype) => x$1.getReferenceName().==(null)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(recs.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FlatGenotype x$2) {
                        return x$2.getReferenceAllele() != null;
                    }
                }), "recs.forall(((x$2: org.bdgenomics.formats.avro.FlatGenotype) => x$2.getReferenceAllele().!=(null)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

