/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.contig;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Level;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.models.ReferenceRegion$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.rdd.contig.ADAMNucleotideContigFragmentContext$;
import org.bdgenomics.adam.util.SparkFunSuite;
import org.bdgenomics.adam.util.SparkFunSuite$class;
import org.bdgenomics.formats.avro.Contig;
import org.bdgenomics.formats.avro.NucleotideContigFragment;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001}1A!\u0001\u0002\u0001\u001b\t)\u0012\tR!N%\u0012#e)\u001e8di&|gn]*vSR,'BA\u0002\u0005\u0003\u0019\u0019wN\u001c;jO*\u0011QAB\u0001\u0004e\u0012$'BA\u0004\t\u0003\u0011\tG-Y7\u000b\u0005%Q\u0011A\u00032eO\u0016tw.\\5dg*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ!!\u0005\u0006\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA\n\u0011\u0005!1UO\\*vSR,\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0007\u0003\u0011)H/\u001b7\n\u0005e1\"!D*qCJ\\g)\u001e8Tk&$X\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005\u0001")
public class ADAMRDDFunctionsSuite
extends FunSuite
implements SparkFunSuite {
    private SparkContext sc;
    private Option<Map<String, Level>> maybeLevels;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public Option<Map<String, Level>> maybeLevels() {
        return this.maybeLevels;
    }

    @Override
    public void maybeLevels_$eq(Option<Map<String, Level>> x$1) {
        this.maybeLevels = x$1;
    }

    @Override
    public void setupSparkContext(String sparkName, boolean silenceSpark) {
        SparkFunSuite$class.setupSparkContext(this, sparkName, silenceSpark);
    }

    @Override
    public void teardownSparkContext() {
        SparkFunSuite$class.teardownSparkContext(this);
    }

    @Override
    public void sparkBefore(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkBefore(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkAfter(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkAfter(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkTest(String name, boolean silenceSpark, Seq<Tag> tags, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, silenceSpark, tags, body);
    }

    @Override
    public void sparkTest(String name, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, body);
    }

    @Override
    public boolean sparkBefore$default$2() {
        return SparkFunSuite$class.sparkBefore$default$2(this);
    }

    @Override
    public boolean setupSparkContext$default$2() {
        return SparkFunSuite$class.setupSparkContext$default$2(this);
    }

    @Override
    public boolean sparkAfter$default$2() {
        return SparkFunSuite$class.sparkAfter$default$2(this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public ADAMRDDFunctionsSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        SparkFunSuite$class.$init$(this);
        this.sparkTest("generate sequence dict from fasta", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig contig0 = Contig.newBuilder().setContigName((CharSequence)"chr0").setContigLength(Predef$.MODULE$.long2Long(1000L)).setReferenceURL((CharSequence)"http://bigdatagenomics.github.io/chr0.fa").build();
                Contig contig1 = Contig.newBuilder().setContigName((CharSequence)"chr1").setContigLength(Predef$.MODULE$.long2Long(900L)).build();
                NucleotideContigFragment ctg0 = NucleotideContigFragment.newBuilder().setContig(contig0).build();
                NucleotideContigFragment ctg1 = NucleotideContigFragment.newBuilder().setContig(contig1).build();
                SparkContext qual$1 = this.$outer.sc();
                List x$1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NucleotideContigFragment[]{ctg0, ctg1}));
                int x$2 = qual$1.parallelize$default$2();
                RDD rdd = qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(NucleotideContigFragment.class));
                SequenceDictionary dict = ADAMNucleotideContigFragmentContext$.MODULE$.rddToContigFragmentRDD(rdd).adamGetSequenceDictionary();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(dict.containsRefName("chr0"), "dict.containsRefName(\"chr0\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SequenceRecord chr0 = (SequenceRecord)dict.apply("chr0").get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)chr0.length()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)1000L), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)1000L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Option $org_scalatest_assert_macro_left2 = chr0.url();
                Some $org_scalatest_assert_macro_right = new Some((Object)"http://bigdatagenomics.github.io/chr0.fa");
                Option option = $org_scalatest_assert_macro_left2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals($org_scalatest_assert_macro_right) : $org_scalatest_assert_macro_right != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(dict.containsRefName("chr1"), "dict.containsRefName(\"chr1\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                SequenceRecord chr1 = (SequenceRecord)dict.apply("chr1").get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)chr1.length()));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)900L), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)900L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("recover reference string from a single contig fragment", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig contig = Contig.newBuilder().setContigName((CharSequence)"chr1").setContigLength(Predef$.MODULE$.long2Long(7L)).build();
                NucleotideContigFragment fragment = NucleotideContigFragment.newBuilder().setContig(contig).setFragmentSequence((CharSequence)"ACTGTAC").setFragmentNumber(Predef$.MODULE$.int2Integer(0)).setFragmentStartPosition(Predef$.MODULE$.long2Long(0L)).setNumberOfFragmentsInContig(Predef$.MODULE$.int2Integer(1)).build();
                ReferenceRegion region = (ReferenceRegion)ReferenceRegion$.MODULE$.apply(fragment).get();
                SparkContext qual$2 = this.$outer.sc();
                List x$3 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NucleotideContigFragment[]{fragment}));
                int x$4 = qual$2.parallelize$default$2();
                RDD rdd = qual$2.parallelize((Seq)x$3, x$4, ClassTag$.MODULE$.apply(NucleotideContigFragment.class));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(ADAMNucleotideContigFragmentContext$.MODULE$.rddToContigFragmentRDD(rdd).adamGetReferenceString(region));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"ACTGTAC", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"ACTGTAC", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("recover trimmed reference string from a single contig fragment", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig contig = Contig.newBuilder().setContigName((CharSequence)"chr1").setContigLength(Predef$.MODULE$.long2Long(7L)).build();
                NucleotideContigFragment fragment = NucleotideContigFragment.newBuilder().setContig(contig).setFragmentSequence((CharSequence)"ACTGTAC").setFragmentNumber(Predef$.MODULE$.int2Integer(0)).setFragmentStartPosition(Predef$.MODULE$.long2Long(0L)).setNumberOfFragmentsInContig(Predef$.MODULE$.int2Integer(1)).build();
                ReferenceRegion region = new ReferenceRegion("chr1", 1L, 6L);
                SparkContext qual$3 = this.$outer.sc();
                List x$5 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NucleotideContigFragment[]{fragment}));
                int x$6 = qual$3.parallelize$default$2();
                RDD rdd = qual$3.parallelize((Seq)x$5, x$6, ClassTag$.MODULE$.apply(NucleotideContigFragment.class));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(ADAMNucleotideContigFragmentContext$.MODULE$.rddToContigFragmentRDD(rdd).adamGetReferenceString(region));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"CTGTA", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"CTGTA", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("recover reference string from multiple contig fragments", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig contig1 = Contig.newBuilder().setContigName((CharSequence)"chr1").setContigLength(Predef$.MODULE$.long2Long(7L)).build();
                Contig contig2 = Contig.newBuilder().setContigName((CharSequence)"chr2").setContigLength(Predef$.MODULE$.long2Long(11L)).build();
                Predef$ predef$ = Predef$.MODULE$;
                String sequence0 = (String)new StringOps("ACTGTACTC").take(7);
                Predef$ predef$2 = Predef$.MODULE$;
                String string = (String)new StringOps("ACTGTACTC").drop(3);
                Predef$ predef$3 = Predef$.MODULE$;
                String sequence1 = (String)new StringOps(string).take(5);
                Predef$ predef$4 = Predef$.MODULE$;
                String string2 = (String)new StringOps("ACTGTACTC").takeRight(6);
                Predef$ predef$5 = Predef$.MODULE$;
                String sequence2 = (String)new StringOps(string2).reverse();
                NucleotideContigFragment fragment0 = NucleotideContigFragment.newBuilder().setContig(contig1).setFragmentSequence((CharSequence)sequence0).setFragmentNumber(Predef$.MODULE$.int2Integer(0)).setFragmentStartPosition(Predef$.MODULE$.long2Long(0L)).setNumberOfFragmentsInContig(Predef$.MODULE$.int2Integer(1)).build();
                NucleotideContigFragment fragment1 = NucleotideContigFragment.newBuilder().setContig(contig2).setFragmentSequence((CharSequence)sequence1).setFragmentNumber(Predef$.MODULE$.int2Integer(0)).setFragmentStartPosition(Predef$.MODULE$.long2Long(0L)).setNumberOfFragmentsInContig(Predef$.MODULE$.int2Integer(2)).build();
                NucleotideContigFragment fragment2 = NucleotideContigFragment.newBuilder().setContig(contig2).setFragmentSequence((CharSequence)sequence2).setFragmentNumber(Predef$.MODULE$.int2Integer(1)).setFragmentStartPosition(Predef$.MODULE$.long2Long(5L)).setNumberOfFragmentsInContig(Predef$.MODULE$.int2Integer(2)).build();
                ReferenceRegion region0 = (ReferenceRegion)ReferenceRegion$.MODULE$.apply(fragment0).get();
                ReferenceRegion region1 = ((ReferenceRegion)ReferenceRegion$.MODULE$.apply(fragment1).get()).merge((ReferenceRegion)ReferenceRegion$.MODULE$.apply(fragment2).get());
                SparkContext qual$4 = this.$outer.sc();
                List x$7 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NucleotideContigFragment[]{fragment0, fragment1, fragment2}));
                int x$8 = qual$4.parallelize$default$2();
                RDD rdd = qual$4.parallelize((Seq)x$7, x$8, ClassTag$.MODULE$.apply(NucleotideContigFragment.class));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(ADAMNucleotideContigFragmentContext$.MODULE$.rddToContigFragmentRDD(rdd).adamGetReferenceString(region0));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"ACTGTAC", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"ACTGTAC", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(ADAMNucleotideContigFragmentContext$.MODULE$.rddToContigFragmentRDD(rdd).adamGetReferenceString(region1));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)"GTACTCTCATG", $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)"GTACTCTCATG", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("recover trimmed reference string from multiple contig fragments", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig contig1 = Contig.newBuilder().setContigName((CharSequence)"chr1").setContigLength(Predef$.MODULE$.long2Long(7L)).build();
                Contig contig2 = Contig.newBuilder().setContigName((CharSequence)"chr2").setContigLength(Predef$.MODULE$.long2Long(11L)).build();
                Predef$ predef$ = Predef$.MODULE$;
                String sequence0 = (String)new StringOps("ACTGTACTC").take(7);
                Predef$ predef$2 = Predef$.MODULE$;
                String string = (String)new StringOps("ACTGTACTC").drop(3);
                Predef$ predef$3 = Predef$.MODULE$;
                String sequence1 = (String)new StringOps(string).take(5);
                Predef$ predef$4 = Predef$.MODULE$;
                String string2 = (String)new StringOps("ACTGTACTC").takeRight(6);
                Predef$ predef$5 = Predef$.MODULE$;
                String sequence2 = (String)new StringOps(string2).reverse();
                NucleotideContigFragment fragment0 = NucleotideContigFragment.newBuilder().setContig(contig1).setFragmentSequence((CharSequence)sequence0).setFragmentNumber(Predef$.MODULE$.int2Integer(0)).setFragmentStartPosition(Predef$.MODULE$.long2Long(0L)).setNumberOfFragmentsInContig(Predef$.MODULE$.int2Integer(1)).build();
                NucleotideContigFragment fragment1 = NucleotideContigFragment.newBuilder().setContig(contig2).setFragmentSequence((CharSequence)sequence1).setFragmentNumber(Predef$.MODULE$.int2Integer(0)).setFragmentStartPosition(Predef$.MODULE$.long2Long(0L)).setNumberOfFragmentsInContig(Predef$.MODULE$.int2Integer(2)).build();
                NucleotideContigFragment fragment2 = NucleotideContigFragment.newBuilder().setContig(contig2).setFragmentSequence((CharSequence)sequence2).setFragmentNumber(Predef$.MODULE$.int2Integer(1)).setFragmentStartPosition(Predef$.MODULE$.long2Long(5L)).setNumberOfFragmentsInContig(Predef$.MODULE$.int2Integer(2)).build();
                ReferenceRegion region0 = new ReferenceRegion("chr1", 1L, 6L);
                ReferenceRegion region1 = new ReferenceRegion("chr2", 3L, 9L);
                SparkContext qual$5 = this.$outer.sc();
                List x$9 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NucleotideContigFragment[]{fragment0, fragment1, fragment2}));
                int x$10 = qual$5.parallelize$default$2();
                RDD rdd = qual$5.parallelize((Seq)x$9, x$10, ClassTag$.MODULE$.apply(NucleotideContigFragment.class));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(ADAMNucleotideContigFragmentContext$.MODULE$.rddToContigFragmentRDD(rdd).adamGetReferenceString(region0));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"CTGTA", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"CTGTA", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(ADAMNucleotideContigFragmentContext$.MODULE$.rddToContigFragmentRDD(rdd).adamGetReferenceString(region1));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)"CTCTCA", $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)"CTCTCA", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

