/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.read;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Level;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.models.Rod;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.read.ADAMAlignmentRecordContext$;
import org.bdgenomics.adam.rdd.read.ADAMAlignmentRecordRDDFunctions;
import org.bdgenomics.adam.rdd.read.ADAMAlignmentRecordRDDFunctionsSuite$;
import org.bdgenomics.adam.rdd.read.ADAMAlignmentRecordRDDFunctionsSuite$$anonfun$1$;
import org.bdgenomics.adam.util.SparkFunSuite;
import org.bdgenomics.adam.util.SparkFunSuite$class;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.formats.avro.Base;
import org.bdgenomics.formats.avro.Contig;
import org.bdgenomics.formats.avro.Pileup;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001}1A!\u0001\u0002\u0001\u001b\t!\u0013\tR!N\u00032LwM\\7f]R\u0014VmY8sIJ#EIR;oGRLwN\\:Tk&$XM\u0003\u0002\u0004\t\u0005!!/Z1e\u0015\t)a!A\u0002sI\u0012T!a\u0002\u0005\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u0013)\t!B\u00193hK:|W.[2t\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\u0011\u0011CC\u0001\ng\u000e\fG.\u0019;fgRL!a\u0005\t\u0003\u0011\u0019+hnU;ji\u0016\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0004\u0002\tU$\u0018\u000e\\\u0005\u00033Y\u0011Qb\u00159be.4UO\\*vSR,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0001")
public class ADAMAlignmentRecordRDDFunctionsSuite
extends FunSuite
implements SparkFunSuite {
    private SparkContext sc;
    private Option<Map<String, Level>> maybeLevels;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public Option<Map<String, Level>> maybeLevels() {
        return this.maybeLevels;
    }

    @Override
    public void maybeLevels_$eq(Option<Map<String, Level>> x$1) {
        this.maybeLevels = x$1;
    }

    @Override
    public void setupSparkContext(String sparkName, boolean silenceSpark) {
        SparkFunSuite$class.setupSparkContext(this, sparkName, silenceSpark);
    }

    @Override
    public void teardownSparkContext() {
        SparkFunSuite$class.teardownSparkContext(this);
    }

    @Override
    public void sparkBefore(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkBefore(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkAfter(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkAfter(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkTest(String name, boolean silenceSpark, Seq<Tag> tags, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, silenceSpark, tags, body);
    }

    @Override
    public void sparkTest(String name, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, body);
    }

    @Override
    public boolean sparkBefore$default$2() {
        return SparkFunSuite$class.sparkBefore$default$2(this);
    }

    @Override
    public boolean setupSparkContext$default$2() {
        return SparkFunSuite$class.setupSparkContext$default$2(this);
    }

    @Override
    public boolean sparkAfter$default$2() {
        return SparkFunSuite$class.sparkAfter$default$2(this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public ADAMAlignmentRecordRDDFunctionsSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        SparkFunSuite$class.$init$(this);
        this.sparkTest("sorting reads", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMAlignmentRecordRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                int x$42;
                Random random = new Random("sorting".hashCode());
                Predef$ predef$ = Predef$.MODULE$;
                IndexedSeq reads = (IndexedSeq)RichInt$.MODULE$.until$extension0(0, 1000).map((Function1)new Serializable(this, random, 1000){
                    public static final long serialVersionUID = 0L;
                    private final Random random$1;
                    private final int numReadsToCreate$1;

                    public final AlignmentRecord apply(int i) {
                        BoxedUnit boxedUnit;
                        boolean mapped = this.random$1.nextBoolean();
                        AlignmentRecord.Builder builder = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(mapped));
                        if (mapped) {
                            Contig contig = Contig.newBuilder().setContigName((CharSequence)((Object)BoxesRunTime.boxToInteger((int)this.random$1.nextInt(this.numReadsToCreate$1 / 10))).toString()).build();
                            int start = this.random$1.nextInt(1000000);
                            boxedUnit = builder.setContig(contig).setStart(Predef$.MODULE$.long2Long((long)start)).setEnd(Predef$.MODULE$.long2Long((long)start));
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return builder.build();
                    }
                    {
                        this.random$1 = random$1;
                        this.numReadsToCreate$1 = numReadsToCreate$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                SparkContext qual$1 = this.$outer.sc();
                RDD rdd = qual$1.parallelize((Seq)reads, x$42 = qual$1.parallelize$default$2(), ClassTag$.MODULE$.apply(AlignmentRecord.class));
                Tuple2[] sortedReads = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])ADAMAlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(rdd).adamSortReadsByReferencePosition().collect()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                Tuple2 tuple2 = Predef$.MODULE$.refArrayOps((Object[])sortedReads).partition((Function1)new $anonfun$1$$anonfun$12(this));
                if (tuple2 != null) {
                    Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
                    Tuple2[] mapped = (Tuple2[])tuple22._1();
                    Tuple2[] unmapped = (Tuple2[])tuple22._2();
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])unmapped).forall((Function1)new Serializable(this, mapped){
                        public static final long serialVersionUID = 0L;
                        private final Tuple2[] mapped$1;

                        public final boolean apply(Tuple2<AlignmentRecord, Object> p) {
                            return p._2$mcI$sp() > ((Tuple2[])Predef$.MODULE$.refArrayOps((Object[])this.mapped$1).takeRight(1))[0]._2$mcI$sp();
                        }
                        {
                            this.mapped$1 = mapped$1;
                        }
                    }), "scala.this.Predef.refArrayOps[(org.bdgenomics.formats.avro.AlignmentRecord, Int)](unmapped).forall(((p: (org.bdgenomics.formats.avro.AlignmentRecord, Int)) => p._2.>(scala.this.Predef.refArrayOps[(org.bdgenomics.formats.avro.AlignmentRecord, Int)](mapped).takeRight(1).apply(0)._2)))");
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    Tuple2[] expectedSortedReads = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])mapped).sortWith((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<AlignmentRecord, Object> a, Tuple2<AlignmentRecord, Object> b) {
                            String string = ((Object)((AlignmentRecord)a._1()).getContig().getContigName()).toString();
                            Predef$ predef$ = Predef$.MODULE$;
                            return new StringOps(string).$less((Object)((Object)((AlignmentRecord)b._1()).getContig().getContigName()).toString()) && Predef$.MODULE$.Long2long(((AlignmentRecord)a._1()).getStart()) < Predef$.MODULE$.Long2long(((AlignmentRecord)b._1()).getStart());
                        }
                    });
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(expectedSortedReads);
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)mapped, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)mapped, Equality$.MODULE$.default()));
                    this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                    return;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("convert an RDD of reads into rods", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMAlignmentRecordRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig contig = Contig.newBuilder().setContigName((CharSequence)"chr0").build();
                AlignmentRecord r0 = AlignmentRecord.newBuilder().setStart(Predef$.MODULE$.long2Long(1L)).setContig(contig).setSequence((CharSequence)"ACG").setMapq(Predef$.MODULE$.int2Integer(30)).setCigar((CharSequence)"3M").setEnd(Predef$.MODULE$.long2Long(4L)).setMismatchingPositions((CharSequence)"3").setReadNegativeStrand(Predef$.MODULE$.boolean2Boolean(false)).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setPrimaryAlignment(Predef$.MODULE$.boolean2Boolean(true)).setQual((CharSequence)"!#$").build();
                AlignmentRecord r1 = AlignmentRecord.newBuilder().setStart(Predef$.MODULE$.long2Long(2L)).setContig(contig).setSequence((CharSequence)"CG").setMapq(Predef$.MODULE$.int2Integer(40)).setCigar((CharSequence)"2M").setEnd(Predef$.MODULE$.long2Long(4L)).setMismatchingPositions((CharSequence)"2").setReadNegativeStrand(Predef$.MODULE$.boolean2Boolean(false)).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setPrimaryAlignment(Predef$.MODULE$.boolean2Boolean(true)).setQual((CharSequence)"%&").build();
                AlignmentRecord r2 = AlignmentRecord.newBuilder().setStart(Predef$.MODULE$.long2Long(3L)).setContig(contig).setSequence((CharSequence)"G").setMapq(Predef$.MODULE$.int2Integer(50)).setCigar((CharSequence)"1M").setEnd(Predef$.MODULE$.long2Long(4L)).setMismatchingPositions((CharSequence)"1").setReadNegativeStrand(Predef$.MODULE$.boolean2Boolean(false)).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setPrimaryAlignment(Predef$.MODULE$.boolean2Boolean(true)).setQual((CharSequence)"%").build();
                SparkContext qual$2 = this.$outer.sc();
                List x$43 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlignmentRecord[]{r0, r1, r2}));
                int x$44 = qual$2.parallelize$default$2();
                RDD reads = qual$2.parallelize((Seq)x$43, x$44, ClassTag$.MODULE$.apply(AlignmentRecord.class));
                ADAMAlignmentRecordRDDFunctions qual$3 = ADAMAlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(reads);
                int x$45 = qual$3.adamRecords2Rods$default$1();
                boolean x$46 = qual$3.adamRecords2Rods$default$2();
                RDD rods = qual$3.adamRecords2Rods(x$45, x$46);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.count()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)3), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])rods.collect()).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$3) {
                        String string = x$3.position().referenceName();
                        return !(string != null ? !string.equals("chr0") : "chr0" != null);
                    }
                }), "scala.this.Predef.refArrayOps[org.bdgenomics.adam.models.Rod](rods.collect()).forall(((x$3: org.bdgenomics.adam.models.Rod) => x$3.position.referenceName.==(\"chr0\")))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$4) {
                        return x$4.position().pos() == 1L;
                    }
                }).count()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Rod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$5) {
                        return x$5.position().pos() == 1L;
                    }
                }).first()).pileups().length()));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(((Rod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$6) {
                        return x$6.position().pos() == 1L;
                    }
                }).first()).pileups().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Pileup x$7) {
                        Base base = x$7.getReadBase();
                        return !(base != null ? !base.equals(Base.A) : Base.A != null);
                    }
                }), "rods.filter(((x$6: org.bdgenomics.adam.models.Rod) => x$6.position.pos.==(1L))).first().pileups.forall(((x$7: org.bdgenomics.formats.avro.Pileup) => x$7.getReadBase().==(A)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$8) {
                        return x$8.position().pos() == 2L;
                    }
                }).count()));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Rod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$9) {
                        return x$9.position().pos() == 2L;
                    }
                }).first()).pileups().length()));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)2), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(((Rod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$10) {
                        return x$10.position().pos() == 2L;
                    }
                }).first()).pileups().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Pileup x$11) {
                        Base base = x$11.getReadBase();
                        return !(base != null ? !base.equals(Base.C) : Base.C != null);
                    }
                }), "rods.filter(((x$10: org.bdgenomics.adam.models.Rod) => x$10.position.pos.==(2L))).first().pileups.forall(((x$11: org.bdgenomics.formats.avro.Pileup) => x$11.getReadBase().==(C)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$12) {
                        return x$12.position().pos() == 3L;
                    }
                }).count()));
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Rod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$13) {
                        return x$13.position().pos() == 3L;
                    }
                }).first()).pileups().length()));
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)3), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(((Rod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$14) {
                        return x$14.position().pos() == 3L;
                    }
                }).first()).pileups().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Pileup x$15) {
                        Base base = x$15.getReadBase();
                        return !(base != null ? !base.equals(Base.G) : Base.G != null);
                    }
                }), "rods.filter(((x$14: org.bdgenomics.adam.models.Rod) => x$14.position.pos.==(3L))).first().pileups.forall(((x$15: org.bdgenomics.formats.avro.Pileup) => x$15.getReadBase().==(G)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("convert an RDD of reads into rods, different references", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMAlignmentRecordRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig contig0 = Contig.newBuilder().setContigName((CharSequence)"chr0").build();
                Contig contig1 = Contig.newBuilder().setContigName((CharSequence)"chr1").build();
                AlignmentRecord r0 = AlignmentRecord.newBuilder().setStart(Predef$.MODULE$.long2Long(1L)).setContig(contig0).setSequence((CharSequence)"AC").setMapq(Predef$.MODULE$.int2Integer(30)).setCigar((CharSequence)"2M").setEnd(Predef$.MODULE$.long2Long(3L)).setMismatchingPositions((CharSequence)"2").setReadNegativeStrand(Predef$.MODULE$.boolean2Boolean(false)).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setPrimaryAlignment(Predef$.MODULE$.boolean2Boolean(true)).setQual((CharSequence)"!#$").build();
                AlignmentRecord r1 = AlignmentRecord.newBuilder().setStart(Predef$.MODULE$.long2Long(2L)).setContig(contig0).setSequence((CharSequence)"C").setMapq(Predef$.MODULE$.int2Integer(40)).setCigar((CharSequence)"1M").setEnd(Predef$.MODULE$.long2Long(3L)).setMismatchingPositions((CharSequence)"1").setReadNegativeStrand(Predef$.MODULE$.boolean2Boolean(false)).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setPrimaryAlignment(Predef$.MODULE$.boolean2Boolean(true)).setQual((CharSequence)"%&").build();
                AlignmentRecord r2 = AlignmentRecord.newBuilder().setStart(Predef$.MODULE$.long2Long(2L)).setContig(contig1).setSequence((CharSequence)"G").setMapq(Predef$.MODULE$.int2Integer(50)).setCigar((CharSequence)"1M").setEnd(Predef$.MODULE$.long2Long(3L)).setMismatchingPositions((CharSequence)"1").setReadNegativeStrand(Predef$.MODULE$.boolean2Boolean(false)).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setPrimaryAlignment(Predef$.MODULE$.boolean2Boolean(true)).setQual((CharSequence)"%").build();
                SparkContext qual$4 = this.$outer.sc();
                List x$47 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlignmentRecord[]{r0, r1, r2}));
                int x$48 = qual$4.parallelize$default$2();
                RDD reads = qual$4.parallelize((Seq)x$47, x$48, ClassTag$.MODULE$.apply(AlignmentRecord.class));
                ADAMAlignmentRecordRDDFunctions qual$5 = ADAMAlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(reads);
                int x$49 = qual$5.adamRecords2Rods$default$1();
                boolean x$50 = qual$5.adamRecords2Rods$default$2();
                RDD rods = qual$5.adamRecords2Rods(x$49, x$50);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.count()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)3), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$16) {
                        String string = x$16.position().referenceName();
                        return !(string != null ? !string.equals("chr0") : "chr0" != null);
                    }
                }).count()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$17) {
                        String string = x$17.position().referenceName();
                        return !(string != null ? !string.equals("chr1") : "chr1" != null);
                    }
                }).count()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$18) {
                        return x$18.position().pos() == 1L;
                    }
                }).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$19) {
                        String string = x$19.position().referenceName();
                        return !(string != null ? !string.equals("chr0") : "chr0" != null);
                    }
                }).count()));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Rod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$20) {
                        return x$20.position().pos() == 1L;
                    }
                }).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$21) {
                        String string = x$21.position().referenceName();
                        return !(string != null ? !string.equals("chr0") : "chr0" != null);
                    }
                }).first()).pileups().length()));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(((Rod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$22) {
                        return x$22.position().pos() == 1L;
                    }
                }).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$23) {
                        String string = x$23.position().referenceName();
                        return !(string != null ? !string.equals("chr0") : "chr0" != null);
                    }
                }).first()).pileups().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Pileup x$24) {
                        Base base = x$24.getReadBase();
                        return !(base != null ? !base.equals(Base.A) : Base.A != null);
                    }
                }), "rods.filter(((x$22: org.bdgenomics.adam.models.Rod) => x$22.position.pos.==(1L))).filter(((x$23: org.bdgenomics.adam.models.Rod) => x$23.position.referenceName.==(\"chr0\"))).first().pileups.forall(((x$24: org.bdgenomics.formats.avro.Pileup) => x$24.getReadBase().==(A)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$25) {
                        return x$25.position().pos() == 2L;
                    }
                }).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$26) {
                        String string = x$26.position().referenceName();
                        return !(string != null ? !string.equals("chr0") : "chr0" != null);
                    }
                }).count()));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Rod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$27) {
                        return x$27.position().pos() == 2L;
                    }
                }).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$28) {
                        String string = x$28.position().referenceName();
                        return !(string != null ? !string.equals("chr0") : "chr0" != null);
                    }
                }).first()).pileups().length()));
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)2), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(((Rod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$29) {
                        return x$29.position().pos() == 2L;
                    }
                }).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$30) {
                        String string = x$30.position().referenceName();
                        return !(string != null ? !string.equals("chr0") : "chr0" != null);
                    }
                }).first()).pileups().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Pileup x$31) {
                        Base base = x$31.getReadBase();
                        return !(base != null ? !base.equals(Base.C) : Base.C != null);
                    }
                }), "rods.filter(((x$29: org.bdgenomics.adam.models.Rod) => x$29.position.pos.==(2L))).filter(((x$30: org.bdgenomics.adam.models.Rod) => x$30.position.referenceName.==(\"chr0\"))).first().pileups.forall(((x$31: org.bdgenomics.formats.avro.Pileup) => x$31.getReadBase().==(C)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$32) {
                        return x$32.position().pos() == 2L;
                    }
                }).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$33) {
                        String string = x$33.position().referenceName();
                        return !(string != null ? !string.equals("chr1") : "chr1" != null);
                    }
                }).count()));
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((Rod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$34) {
                        return x$34.position().pos() == 2L;
                    }
                }).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$35) {
                        String string = x$35.position().referenceName();
                        return !(string != null ? !string.equals("chr1") : "chr1" != null);
                    }
                }).first()).pileups().length()));
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
                Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.simpleMacroBool(((Rod)rods.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$36) {
                        return x$36.position().pos() == 2L;
                    }
                }).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Rod x$37) {
                        String string = x$37.position().referenceName();
                        return !(string != null ? !string.equals("chr1") : "chr1" != null);
                    }
                }).first()).pileups().forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Pileup x$38) {
                        Base base = x$38.getReadBase();
                        return !(base != null ? !base.equals(Base.G) : Base.G != null);
                    }
                }), "rods.filter(((x$36: org.bdgenomics.adam.models.Rod) => x$36.position.pos.==(2L))).filter(((x$37: org.bdgenomics.adam.models.Rod) => x$37.position.referenceName.==(\"chr1\"))).first().pileups.forall(((x$38: org.bdgenomics.formats.avro.Pileup) => x$38.getReadBase().==(G)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("characterizeTags counts integer tag values correctly", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMAlignmentRecordRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Tuple2[] tuple2Array = new Tuple2[3];
                Predef$ predef$ = Predef$.MODULE$;
                Long l = BoxesRunTime.boxToLong((long)10L);
                Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                tuple2Array[0] = new Tuple2((Object)"XT", (Object)l);
                Predef$ predef$2 = Predef$.MODULE$;
                Long l2 = BoxesRunTime.boxToLong((long)9L);
                Predef.ArrowAssoc$ arrowAssoc$2 = Predef.ArrowAssoc$.MODULE$;
                tuple2Array[1] = new Tuple2((Object)"XU", (Object)l2);
                Predef$ predef$3 = Predef$.MODULE$;
                Long l3 = BoxesRunTime.boxToLong((long)8L);
                Predef.ArrowAssoc$ arrowAssoc$3 = Predef.ArrowAssoc$.MODULE$;
                tuple2Array[2] = new Tuple2((Object)"XV", (Object)l3);
                Map tagCounts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
                Iterable readItr = (Iterable)tagCounts.withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, Object> check$ifrefutable$1) {
                        boolean bl = check$ifrefutable$1 != null;
                        return bl;
                    }
                }).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final IndexedSeq<AlignmentRecord> apply(Tuple2<String, Object> x$39) {
                        if (x$39 != null) {
                            Predef$ predef$ = Predef$.MODULE$;
                            return (IndexedSeq)RichInt$.MODULE$.until$extension0(0, (int)x$39._2$mcJ$sp()).map((Function1)new Serializable(this, x$39){
                                public static final long serialVersionUID = 0L;
                                private final Tuple2 x1$1;

                                public final AlignmentRecord apply(int i) {
                                    Predef$ predef$ = Predef$.MODULE$;
                                    return AlignmentRecord.newBuilder().setAttributes((CharSequence)new StringOps("%s:i:%d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$1._1(), BoxesRunTime.boxToInteger((int)i)}))).build();
                                }
                                {
                                    this.x1$1 = x1$1;
                                }
                            }, IndexedSeq$.MODULE$.canBuildFrom());
                        }
                        throw new MatchError(x$39);
                    }
                }, Iterable$.MODULE$.canBuildFrom());
                SparkContext qual$6 = this.$outer.sc();
                Seq x$51 = readItr.toSeq();
                int x$52 = qual$6.parallelize$default$2();
                RDD reads = qual$6.parallelize(x$51, x$52, ClassTag$.MODULE$.apply(AlignmentRecord.class));
                Map mapCounts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])ADAMAlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(reads).adamCharacterizeTags().collect()));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(mapCounts);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)tagCounts, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)tagCounts, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("withTag returns only those records which have the appropriate tag", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMAlignmentRecordRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord r1 = AlignmentRecord.newBuilder().setAttributes((CharSequence)"XX:i:3").build();
                AlignmentRecord r2 = AlignmentRecord.newBuilder().setAttributes((CharSequence)"XX:i:4\tYY:i:10").build();
                AlignmentRecord r3 = AlignmentRecord.newBuilder().setAttributes((CharSequence)"YY:i:20").build();
                SparkContext qual$7 = this.$outer.sc();
                Seq x$53 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlignmentRecord[]{r1, r2, r3}));
                int x$54 = qual$7.parallelize$default$2();
                RDD rdd = qual$7.parallelize(x$53, x$54, ClassTag$.MODULE$.apply(AlignmentRecord.class));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rdd.count()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)3), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                RDD rddXX = ADAMAlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(rdd).adamFilterRecordsWithTag("XX");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rddXX.count()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                AlignmentRecord[] collected = (AlignmentRecord[])rddXX.collect();
                ArrayOps $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])collected);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)r1, $org_scalatest_assert_macro_left3.contains((Object)r1));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                ArrayOps $org_scalatest_assert_macro_left4 = Predef$.MODULE$.refArrayOps((Object[])collected);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)r2, $org_scalatest_assert_macro_left4.contains((Object)r2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("withTag, when given a tag name that doesn't exist in the input, returns an empty RDD", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMAlignmentRecordRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord r1 = AlignmentRecord.newBuilder().setAttributes((CharSequence)"XX:i:3").build();
                AlignmentRecord r2 = AlignmentRecord.newBuilder().setAttributes((CharSequence)"XX:i:4\tYY:i:10").build();
                AlignmentRecord r3 = AlignmentRecord.newBuilder().setAttributes((CharSequence)"YY:i:20").build();
                SparkContext qual$8 = this.$outer.sc();
                Seq x$55 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlignmentRecord[]{r1, r2, r3}));
                int x$56 = qual$8.parallelize$default$2();
                RDD rdd = qual$8.parallelize(x$55, x$56, ClassTag$.MODULE$.apply(AlignmentRecord.class));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rdd.count()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)3), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                RDD rddXX = ADAMAlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(rdd).adamFilterRecordsWithTag("ZZ");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rddXX.count()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)0), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("characterizeTagValues counts distinct values of a tag", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMAlignmentRecordRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord r1 = AlignmentRecord.newBuilder().setAttributes((CharSequence)"XX:i:3").build();
                AlignmentRecord r2 = AlignmentRecord.newBuilder().setAttributes((CharSequence)"XX:i:4\tYY:i:10").build();
                AlignmentRecord r3 = AlignmentRecord.newBuilder().setAttributes((CharSequence)"YY:i:20").build();
                AlignmentRecord r4 = AlignmentRecord.newBuilder().setAttributes((CharSequence)"XX:i:4").build();
                SparkContext qual$9 = this.$outer.sc();
                Seq x$57 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlignmentRecord[]{r1, r2, r3, r4}));
                int x$58 = qual$9.parallelize$default$2();
                RDD rdd = qual$9.parallelize(x$57, x$58, ClassTag$.MODULE$.apply(AlignmentRecord.class));
                Map tagValues = ADAMAlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(rdd).adamCharacterizeTagValues("XX");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)tagValues.keys().size()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)2), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(tagValues.apply((Object)BoxesRunTime.boxToInteger((int)4)));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(tagValues.apply((Object)BoxesRunTime.boxToInteger((int)3)));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("characterizeTags counts tags in a SAM file correctly", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMAlignmentRecordRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String filePath = this.$outer.getClass().getClassLoader().getResource("reads12.sam").getFile();
                ADAMContext qual$10 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc());
                None$ x$60 = qual$10.adamLoad$default$2();
                Option x$61 = qual$10.adamLoad$default$3();
                RDD sam = qual$10.adamLoad(filePath, (Option)x$60, x$61, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(AlignmentRecord.class));
                Map mapCounts = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])ADAMAlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(sam).adamCharacterizeTags().collect()));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(mapCounts.apply((Object)"NM"));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)200), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)200), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(mapCounts.apply((Object)"AS"));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)200), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)200), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(mapCounts.apply((Object)"XS"));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)200), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)200), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("round trip from ADAM to SAM and back to ADAM produces equivalent Read values", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ ADAMAlignmentRecordRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void apply$mcV$sp() {
                String reads12Path = Thread.currentThread().getContextClassLoader().getResource("reads12.sam").getFile();
                ADAMContext qual$11 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc());
                None$ x$63 = qual$11.adamLoad$default$2();
                Option x$64 = qual$11.adamLoad$default$3();
                RDD rdd12A = qual$11.adamLoad(reads12Path, (Option)x$63, x$64, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(AlignmentRecord.class));
                Path tempFile = Files.createTempDirectory("reads12", new FileAttribute[0]);
                ADAMAlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(rdd12A).adamSAMSave(new StringBuilder().append((Object)((Object)tempFile.toAbsolutePath()).toString()).append((Object)"/reads12.sam").toString(), true);
                RDD rdd12B = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc()).adamBamLoad(new StringBuilder().append((Object)((Object)tempFile.toAbsolutePath()).toString()).append((Object)"/reads12.sam/part-r-00000").toString());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rdd12B.count()));
                long $org_scalatest_assert_macro_right = rdd12A.count();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                AlignmentRecord[] reads12A = (AlignmentRecord[])rdd12A.collect();
                AlignmentRecord[] reads12B = (AlignmentRecord[])rdd12B.collect();
                Predef$ predef$ = Predef$.MODULE$;
                Serializable serializable = new Serializable(this, reads12A, reads12B){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;
                    private final AlignmentRecord[] reads12A$1;
                    private final AlignmentRecord[] reads12B$1;

                    public final void apply(int x0$1) {
                        this.apply$mcVI$sp(x0$1);
                    }

                    public void apply$mcVI$sp(int x0$1) {
                        Tuple2 tuple2 = new Tuple2((Object)this.reads12A$1[x0$1], (Object)this.reads12B$1[x0$1]);
                        if (tuple2 != null) {
                            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
                            AlignmentRecord readA = (AlignmentRecord)tuple22._1();
                            AlignmentRecord readB = (AlignmentRecord)tuple22._2();
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.$outer.convertToEqualizer(readA.getSequence());
                            CharSequence $org_scalatest_assert_macro_right = readB.getSequence();
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                            this.$outer.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.$outer.convertToEqualizer(readA.getQual());
                            CharSequence $org_scalatest_assert_macro_right2 = readB.getQual();
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                            this.$outer.org$bdgenomics$adam$rdd$read$ADAMAlignmentRecordRDDFunctionsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$bdgenomics$adam$rdd$read$ADAMAlignmentRecordRDDFunctionsSuite$$anonfun$$$outer().convertToEqualizer(readA.getCigar());
                            CharSequence $org_scalatest_assert_macro_right3 = readB.getCigar();
                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                            this.$outer.org$bdgenomics$adam$rdd$read$ADAMAlignmentRecordRDDFunctionsSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                            return;
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.reads12A$1 = reads12A$1;
                        this.reads12B$1 = reads12B$1;
                    }
                };
                Range range = RichInt$.MODULE$.until$extension0(0, reads12A.length);
                if (!range.validateRangeBoundaries((Function1)serializable)) return;
                int n = range.start();
                int n2 = range.terminalElement();
                int n3 = range.step();
                while (n != n2) {
                    serializable.apply$mcVI$sp(n);
                    n += n3;
                }
                return;
            }

            public /* synthetic */ ADAMAlignmentRecordRDDFunctionsSuite org$bdgenomics$adam$rdd$read$ADAMAlignmentRecordRDDFunctionsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("SAM conversion sets read mapped flag properly", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ ADAMAlignmentRecordRDDFunctionsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String filePath = this.$outer.getClass().getClassLoader().getResource("reads12.sam").getFile();
                ADAMContext qual$12 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc());
                None$ x$66 = qual$12.adamLoad$default$2();
                Option x$67 = qual$12.adamLoad$default$3();
                RDD sam = qual$12.adamLoad(filePath, (Option)x$66, x$67, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(AlignmentRecord.class));
                Predef$.MODULE$.refArrayOps((Object[])sam.collect()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;

                    public final void apply(AlignmentRecord r) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.Boolean2boolean(r.getReadMapped()), "scala.this.Predef.Boolean2boolean(r.getReadMapped())");
                        this.$outer.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ADAMAlignmentRecordRDDFunctionsSuite org$bdgenomics$adam$rdd$read$ADAMAlignmentRecordRDDFunctionsSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

