/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.read.realignment;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Level;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.read.realignment.IndelRealignmentTarget;
import org.bdgenomics.adam.rdd.read.realignment.IndelRealignmentTargetSuite$;
import org.bdgenomics.adam.rdd.read.realignment.RealignmentTargetFinder$;
import org.bdgenomics.adam.rdd.read.realignment.TargetOrdering$;
import org.bdgenomics.adam.rich.RichAlignmentRecord;
import org.bdgenomics.adam.rich.RichAlignmentRecord$;
import org.bdgenomics.adam.util.SparkFunSuite;
import org.bdgenomics.adam.util.SparkFunSuite$class;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.formats.avro.Contig;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.TreeSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00054A!\u0001\u0002\u0001\u001f\tY\u0012J\u001c3fYJ+\u0017\r\\5h]6,g\u000e\u001e+be\u001e,GoU;ji\u0016T!a\u0001\u0003\u0002\u0017I,\u0017\r\\5h]6,g\u000e\u001e\u0006\u0003\u000b\u0019\tAA]3bI*\u0011q\u0001C\u0001\u0004e\u0012$'BA\u0005\u000b\u0003\u0011\tG-Y7\u000b\u0005-a\u0011A\u00032eO\u0016tw.\\5dg*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001!Y\u0001\"!\u0005\u000b\u000e\u0003IQ!a\u0005\u0007\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA\u000b\u0013\u0005!1UO\\*vSR,\u0007CA\f\u001b\u001b\u0005A\"BA\r\t\u0003\u0011)H/\u001b7\n\u0005mA\"!D*qCJ\\g)\u001e8Tk&$X\rC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011\u0001\u0005A\u0007\u0002\u0005!)!\u0005\u0001C\u0001G\u0005YQ.Y:p]~\u0013X-\u00193t+\u0005!\u0003cA\u0013,[5\taE\u0003\u0002\bO)\u0011\u0001&K\u0001\u0006gB\f'o\u001b\u0006\u0003U1\ta!\u00199bG\",\u0017B\u0001\u0017'\u0005\r\u0011F\t\u0012\t\u0003]Ej\u0011a\f\u0006\u0003a!\tAA]5dQ&\u0011!g\f\u0002\u0014%&\u001c\u0007.\u00117jO:lWM\u001c;SK\u000e|'\u000f\u001a\u0005\u0006i\u0001!\taI\u0001\u0011CJ$\u0018NZ5dS\u0006dwL]3bINDQA\u000e\u0001\u0005\u0002]\n\u0011\"\\1lK~\u0013X-\u00193\u0015\u000f5B\u0004)S&Q%\")\u0011(\u000ea\u0001u\u0005)1\u000f^1siB\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t!Aj\u001c8h\u0011\u0015\tU\u00071\u0001C\u0003\u0015\u0019\u0017nZ1s!\t\u0019eI\u0004\u0002<\t&\u0011Q\tP\u0001\u0007!J,G-\u001a4\n\u0005\u001dC%AB*ue&twM\u0003\u0002Fy!)!*\u000ea\u0001\u0005\u0006)Q\u000e\u001a;bO\")A*\u000ea\u0001\u001b\u00061A.\u001a8hi\"\u0004\"a\u000f(\n\u0005=c$aA%oi\")\u0011+\u000ea\u0001\u001b\u0006I!/\u001a4MK:<G\u000f\u001b\u0005\b'V\u0002\n\u00111\u0001N\u0003\tIG\rC\u0004V\u0001E\u0005I\u0011\u0001,\u0002'5\f7.Z0sK\u0006$G\u0005Z3gCVdG\u000f\n\u001c\u0016\u0003]S#!\u0014-,\u0003e\u0003\"AW0\u000e\u0003mS!\u0001X/\u0002\u0013Ut7\r[3dW\u0016$'B\u00010=\u0003)\tgN\\8uCRLwN\\\u0005\u0003An\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class IndelRealignmentTargetSuite
extends FunSuite
implements SparkFunSuite {
    private SparkContext sc;
    private Option<Map<String, Level>> maybeLevels;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public Option<Map<String, Level>> maybeLevels() {
        return this.maybeLevels;
    }

    @Override
    public void maybeLevels_$eq(Option<Map<String, Level>> x$1) {
        this.maybeLevels = x$1;
    }

    @Override
    public void setupSparkContext(String sparkName, boolean silenceSpark) {
        SparkFunSuite$class.setupSparkContext(this, sparkName, silenceSpark);
    }

    @Override
    public void teardownSparkContext() {
        SparkFunSuite$class.teardownSparkContext(this);
    }

    @Override
    public void sparkBefore(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkBefore(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkAfter(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkAfter(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkTest(String name, boolean silenceSpark, Seq<Tag> tags, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, silenceSpark, tags, body);
    }

    @Override
    public void sparkTest(String name, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, body);
    }

    @Override
    public boolean sparkBefore$default$2() {
        return SparkFunSuite$class.sparkBefore$default$2(this);
    }

    @Override
    public boolean setupSparkContext$default$2() {
        return SparkFunSuite$class.setupSparkContext$default$2(this);
    }

    @Override
    public boolean sparkAfter$default$2() {
        return SparkFunSuite$class.sparkAfter$default$2(this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public RDD<RichAlignmentRecord> mason_reads() {
        String path = ClassLoader.getSystemClassLoader().getResource("small_realignment_targets.sam").getFile();
        ADAMContext qual$1 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc());
        None$ x$4 = qual$1.adamLoad$default$2();
        Option x$5 = qual$1.adamLoad$default$3();
        return qual$1.adamLoad(path, (Option)x$4, x$5, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(AlignmentRecord.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RichAlignmentRecord apply(AlignmentRecord x$1) {
                return RichAlignmentRecord$.MODULE$.apply(x$1);
            }
        }, ClassTag$.MODULE$.apply(RichAlignmentRecord.class));
    }

    public RDD<RichAlignmentRecord> artificial_reads() {
        String path = ClassLoader.getSystemClassLoader().getResource("artificial.sam").getFile();
        ADAMContext qual$2 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc());
        None$ x$7 = qual$2.adamLoad$default$2();
        Option x$8 = qual$2.adamLoad$default$3();
        return qual$2.adamLoad(path, (Option)x$7, x$8, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(AlignmentRecord.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RichAlignmentRecord apply(AlignmentRecord x$2) {
                return RichAlignmentRecord$.MODULE$.apply(x$2);
            }
        }, ClassTag$.MODULE$.apply(RichAlignmentRecord.class));
    }

    public RichAlignmentRecord make_read(long start, String cigar, String mdtag, int length, int refLength, int id) {
        Predef$ predef$ = Predef$.MODULE$;
        String sequence = new StringOps("A").$times(length);
        return RichAlignmentRecord$.MODULE$.apply(AlignmentRecord.newBuilder().setReadName((CharSequence)new StringBuilder().append((Object)"read").append((Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString()).toString()).setStart(Predef$.MODULE$.long2Long(start)).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)cigar).setEnd(Predef$.MODULE$.long2Long(start + (long)refLength)).setSequence((CharSequence)sequence).setReadNegativeStrand(Predef$.MODULE$.boolean2Boolean(false)).setMapq(Predef$.MODULE$.int2Integer(60)).setQual((CharSequence)sequence).setContig(Contig.newBuilder().setContigName((CharSequence)"1").build()).setMismatchingPositions((CharSequence)mdtag).build());
    }

    public int make_read$default$6() {
        return 0;
    }

    public IndelRealignmentTargetSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        SparkFunSuite$class.$init$(this);
        this.sparkTest("checking simple realignment target", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelRealignmentTargetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndelRealignmentTarget target1 = new IndelRealignmentTarget((Option)new Some((Object)new ReferenceRegion("1", 1L, 10L)), new ReferenceRegion("1", 1L, 51L));
                IndelRealignmentTarget target2 = new IndelRealignmentTarget((Option)None$.MODULE$, new ReferenceRegion("1", 60L, 91L));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)target1.readRange().start()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)target1.readRange().end()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)51), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)51), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)TargetOrdering$.MODULE$.overlap(target1, target1)));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)true), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)true), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)TargetOrdering$.MODULE$.overlap(target1, target2)));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToBoolean((boolean)false), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)false), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)target2.readRange().start()));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)60), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)60), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)target2.readRange().end()));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)91), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)91), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool((Object)target1, "isEmpty", target1.isEmpty()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.unaryMacroBool((Object)target2, "isEmpty", target2.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("creating simple target from read with deletion", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelRealignmentTargetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TreeSet targets;
                RichAlignmentRecord read = this.$outer.make_read(3L, "2M3D2M", "2^AAA2", 4, 7, this.$outer.make_read$default$6());
                RDD read_rdd = this.$outer.sc().makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RichAlignmentRecord[]{read})), 1, ClassTag$.MODULE$.apply(RichAlignmentRecord.class));
                TreeSet treeSet = targets = RealignmentTargetFinder$.MODULE$.apply(read_rdd, RealignmentTargetFinder$.MODULE$.apply$default$2(), RealignmentTargetFinder$.MODULE$.apply$default$3());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)targets, "!=", null, treeSet != null ? !treeSet.equals(null) : null != null);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)targets.size()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)((IndelRealignmentTarget)targets.head()).variation().get()).start()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)5), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)((IndelRealignmentTarget)targets.head()).variation().get()).end()));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)8), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)8), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)targets.head()).readRange().start()));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)targets.head()).readRange().end()));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)10), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("creating simple target from read with insertion", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelRealignmentTargetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TreeSet targets;
                RichAlignmentRecord read = this.$outer.make_read(3L, "2M3I2M", "4", 7, 4, this.$outer.make_read$default$6());
                RDD read_rdd = this.$outer.sc().makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RichAlignmentRecord[]{read})), 1, ClassTag$.MODULE$.apply(RichAlignmentRecord.class));
                TreeSet treeSet = targets = RealignmentTargetFinder$.MODULE$.apply(read_rdd, RealignmentTargetFinder$.MODULE$.apply$default$2(), RealignmentTargetFinder$.MODULE$.apply$default$3());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)targets, "!=", null, treeSet != null ? !treeSet.equals(null) : null != null);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)targets.size()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)((IndelRealignmentTarget)targets.head()).variation().get()).start()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)5), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)((IndelRealignmentTarget)targets.head()).variation().get()).end()));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)6), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)6), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)targets.head()).readRange().start()));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)3), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)targets.head()).readRange().end()));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)7), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("joining simple realignment targets on same chr", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelRealignmentTargetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndelRealignmentTarget target1 = new IndelRealignmentTarget((Option)new Some((Object)new ReferenceRegion("1", 10L, 16L)), new ReferenceRegion("1", 1L, 21L));
                IndelRealignmentTarget target2 = new IndelRealignmentTarget((Option)new Some((Object)new ReferenceRegion("1", 10L, 16L)), new ReferenceRegion("1", 6L, 26L));
                IndelRealignmentTarget merged_target = target1.merge(target2);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)merged_target.readRange().start()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)merged_target.readRange().end()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)26), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)26), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)merged_target.variation().get()).start()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)10), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)merged_target.variation().get()).end()));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)16), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)16), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("joining simple realignment targets on different chr throws exception", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelRealignmentTargetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndelRealignmentTarget target1 = new IndelRealignmentTarget((Option)new Some((Object)new ReferenceRegion("1", 10L, 16L)), new ReferenceRegion("1", 1L, 21L));
                IndelRealignmentTarget target2 = new IndelRealignmentTarget((Option)new Some((Object)new ReferenceRegion("2", 10L, 16L)), new ReferenceRegion("2", 6L, 26L));
                this.$outer.intercept((Function0)new Serializable(this, target1, target2){
                    public static final long serialVersionUID = 0L;
                    private final IndelRealignmentTarget target1$1;
                    private final IndelRealignmentTarget target2$1;

                    public final IndelRealignmentTarget apply() {
                        return this.target1$1.merge(this.target2$1);
                    }
                    {
                        this.target1$1 = target1$1;
                        this.target2$1 = target2$1;
                    }
                }, ManifestFactory$.MODULE$.classType(AssertionError.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("creating targets from three intersecting reads, same indel", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelRealignmentTargetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TreeSet targets;
                RichAlignmentRecord read1 = this.$outer.make_read(1L, "4M3D2M", "4^AAA2", 6, 9, this.$outer.make_read$default$6());
                RichAlignmentRecord read2 = this.$outer.make_read(2L, "3M3D2M", "3^AAA2", 5, 8, this.$outer.make_read$default$6());
                RichAlignmentRecord read3 = this.$outer.make_read(3L, "2M3D2M", "2^AAA2", 4, 7, this.$outer.make_read$default$6());
                RDD read_rdd = this.$outer.sc().makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RichAlignmentRecord[]{read1, read2, read3})), 1, ClassTag$.MODULE$.apply(RichAlignmentRecord.class));
                TreeSet treeSet = targets = RealignmentTargetFinder$.MODULE$.apply(read_rdd, RealignmentTargetFinder$.MODULE$.apply$default$2(), RealignmentTargetFinder$.MODULE$.apply$default$3());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)targets, "!=", null, treeSet != null ? !treeSet.equals(null) : null != null);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)targets.size()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)((IndelRealignmentTarget)targets.head()).variation().get()).start()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)5), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)((IndelRealignmentTarget)targets.head()).variation().get()).end()));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)8), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)8), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)targets.head()).readRange().start()));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)targets.head()).readRange().end()));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)10), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("creating targets from three intersecting reads, two different indel", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelRealignmentTargetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TreeSet targets;
                RichAlignmentRecord read1 = this.$outer.make_read(1L, "2M2D4M", "2^AA4", 6, 8, 0);
                RichAlignmentRecord read2 = this.$outer.make_read(1L, "2M2D2M2D2M", "2^AA2^AA2", 6, 10, 1);
                RichAlignmentRecord read3 = this.$outer.make_read(5L, "2M2D4M", "2^AA4", 6, 8, 2);
                RDD read_rdd = this.$outer.sc().makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RichAlignmentRecord[]{read1, read2, read3})), 1, ClassTag$.MODULE$.apply(RichAlignmentRecord.class));
                TreeSet treeSet = targets = RealignmentTargetFinder$.MODULE$.apply(read_rdd, RealignmentTargetFinder$.MODULE$.apply$default$2(), RealignmentTargetFinder$.MODULE$.apply$default$3());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)targets, "!=", null, treeSet != null ? !treeSet.equals(null) : null != null);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)targets.size()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)((IndelRealignmentTarget)targets.head()).variation().get()).start()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)3), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)((IndelRealignmentTarget)targets.head()).variation().get()).end()));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)9), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)9), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)targets.head()).readRange().start()));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)targets.head()).readRange().end()));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)13), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)13), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("creating targets from two disjoint reads", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelRealignmentTargetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndelRealignmentTarget[] targets;
                RichAlignmentRecord read1 = this.$outer.make_read(1L, "2M2D2M", "2^AA2", 4, 6, this.$outer.make_read$default$6());
                RichAlignmentRecord read2 = this.$outer.make_read(7L, "2M2D2M", "2^AA2", 4, 6, this.$outer.make_read$default$6());
                RDD read_rdd = this.$outer.sc().makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RichAlignmentRecord[]{read1, read2})), 1, ClassTag$.MODULE$.apply(RichAlignmentRecord.class));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)targets, "!=", null, (targets = (IndelRealignmentTarget[])RealignmentTargetFinder$.MODULE$.apply(read_rdd, RealignmentTargetFinder$.MODULE$.apply$default$2(), RealignmentTargetFinder$.MODULE$.apply$default$3()).toArray(ClassTag$.MODULE$.apply(IndelRealignmentTarget.class))) != null);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])targets).size()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)2), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)targets[0].variation().get()).start()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)3), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)targets[0].variation().get()).end()));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)5), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)targets[0].readRange().start()));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)targets[0].readRange().end()));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)7), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)targets[1].variation().get()).start()));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)9), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)9), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)targets[1].variation().get()).end()));
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)11), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)11), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)targets[1].readRange().start()));
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)7), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)7), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)targets[1].readRange().end()));
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)BoxesRunTime.boxToInteger((int)13), $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)13), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("creating targets for artificial reads: one-by-one", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ IndelRealignmentTargetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RichAlignmentRecord[] reads = (RichAlignmentRecord[])this.$outer.artificial_reads().collect();
                Predef$.MODULE$.refArrayOps((Object[])reads).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final void apply(RichAlignmentRecord read) {
                        RDD read_rdd = this.$outer.$outer.sc().makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RichAlignmentRecord[]{read})), 1, ClassTag$.MODULE$.apply(RichAlignmentRecord.class));
                        TreeSet targets = RealignmentTargetFinder$.MODULE$.apply(read_rdd, RealignmentTargetFinder$.MODULE$.apply$default$2(), RealignmentTargetFinder$.MODULE$.apply$default$3());
                        if (Predef$.MODULE$.Long2long(RichAlignmentRecord$.MODULE$.richRecordToRecord(read).getStart()) < 105L) {
                            TreeSet treeSet = targets;
                            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)targets, "!=", null, treeSet != null ? !treeSet.equals(null) : null != null);
                            this.$outer.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)targets.size()));
                            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                            this.$outer.org$bdgenomics$adam$rdd$read$realignment$IndelRealignmentTargetSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$bdgenomics$adam$rdd$read$realignment$IndelRealignmentTargetSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)targets.head()).readRange().start()));
                            Long $org_scalatest_assert_macro_right = RichAlignmentRecord$.MODULE$.richRecordToRecord(read).getStart();
                            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                            this.$outer.org$bdgenomics$adam$rdd$read$realignment$IndelRealignmentTargetSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.org$bdgenomics$adam$rdd$read$realignment$IndelRealignmentTargetSuite$$anonfun$$$outer().convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)targets.head()).readRange().end()));
                            Long $org_scalatest_assert_macro_right2 = RichAlignmentRecord$.MODULE$.richRecordToRecord(read).getEnd();
                            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                            this.$outer.org$bdgenomics$adam$rdd$read$realignment$IndelRealignmentTargetSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(this.$outer.org$bdgenomics$adam$rdd$read$realignment$IndelRealignmentTargetSuite$$anonfun$$check_indel$1((IndelRealignmentTarget)targets.head(), RichAlignmentRecord$.MODULE$.richRecordToRecord(read)), "check_indel(targets.head, rich.this.RichAlignmentRecord.richRecordToRecord(read))");
                            this.$outer.org$bdgenomics$adam$rdd$read$realignment$IndelRealignmentTargetSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ IndelRealignmentTargetSuite org$bdgenomics$adam$rdd$read$realignment$IndelRealignmentTargetSuite$$anonfun$$$outer() {
                return this.$outer;
            }

            public final boolean org$bdgenomics$adam$rdd$read$realignment$IndelRealignmentTargetSuite$$anonfun$$check_indel$1(IndelRealignmentTarget target, AlignmentRecord read) {
                ReferenceRegion indelRange = (ReferenceRegion)target.variation().get();
                long l = Predef$.MODULE$.Long2long(read.getStart());
                boolean bl = 5L == l ? indelRange.start() == 34L && indelRange.end() == 44L : (10L == l ? indelRange.start() == 54L && indelRange.end() == 64L : (15L == l ? indelRange.start() == 34L && indelRange.end() == 44L : (20L == l ? indelRange.start() == 54L && indelRange.end() == 64L : (25L == l ? indelRange.start() == 34L && indelRange.end() == 44L : false))));
                return bl;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("creating targets for artificial reads: all-at-once (merged)", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelRealignmentTargetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IndelRealignmentTarget[] targets_collected = (IndelRealignmentTarget[])RealignmentTargetFinder$.MODULE$.apply(this.$outer.artificial_reads(), RealignmentTargetFinder$.MODULE$.apply$default$2(), RealignmentTargetFinder$.MODULE$.apply$default$3()).toArray(ClassTag$.MODULE$.apply(IndelRealignmentTarget.class));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])targets_collected).size()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)Predef$.MODULE$.refArrayOps((Object[])targets_collected).head()).readRange().start()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)5), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((IndelRealignmentTarget)Predef$.MODULE$.refArrayOps((Object[])targets_collected).head()).readRange().end()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)95), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)95), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)((IndelRealignmentTarget)Predef$.MODULE$.refArrayOps((Object[])targets_collected).head()).variation().get()).start()));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)34), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)34), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)((IndelRealignmentTarget)Predef$.MODULE$.refArrayOps((Object[])targets_collected).head()).variation().get()).end()));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)64), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)64), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("creating indel targets for mason reads", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IndelRealignmentTargetSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Bool bool;
                Bool bool2;
                Bool bool3;
                IndelRealignmentTarget[] targets_collected = (IndelRealignmentTarget[])RealignmentTargetFinder$.MODULE$.apply(this.$outer.mason_reads(), RealignmentTargetFinder$.MODULE$.apply$default$2(), RealignmentTargetFinder$.MODULE$.apply$default$3()).toArray(ClassTag$.MODULE$.apply(IndelRealignmentTarget.class));
                long $org_scalatest_assert_macro_left = ((ReferenceRegion)targets_collected[0].variation().get()).start();
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)702289), $org_scalatest_assert_macro_left == (long)702289);
                if ($org_scalatest_assert_macro_left2.value()) {
                    long $org_scalatest_assert_macro_left3 = ((ReferenceRegion)targets_collected[0].variation().get()).end();
                    bool3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)702324), $org_scalatest_assert_macro_left3 == (long)702324);
                } else {
                    bool3 = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right = bool3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                long $org_scalatest_assert_macro_left4 = ((ReferenceRegion)targets_collected[1].variation().get()).start();
                Bool $org_scalatest_assert_macro_left5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)807755), $org_scalatest_assert_macro_left4 == (long)807755);
                if ($org_scalatest_assert_macro_left5.value()) {
                    long $org_scalatest_assert_macro_left6 = ((ReferenceRegion)targets_collected[1].variation().get()).end();
                    bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)807756), $org_scalatest_assert_macro_left6 == (long)807756);
                } else {
                    bool2 = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right2 = bool2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "&&", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left5.$amp$amp($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((ReferenceRegion)targets_collected[5].variation().get()).length()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)4), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                long $org_scalatest_assert_macro_left8 = ((ReferenceRegion)targets_collected[5].variation().get()).start();
                Bool $org_scalatest_assert_macro_left9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left8), "==", (Object)BoxesRunTime.boxToInteger((int)869644), $org_scalatest_assert_macro_left8 == (long)869644);
                if ($org_scalatest_assert_macro_left9.value()) {
                    long $org_scalatest_assert_macro_left10 = ((ReferenceRegion)targets_collected[5].variation().get()).end();
                    bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left10), "==", (Object)BoxesRunTime.boxToInteger((int)869648), $org_scalatest_assert_macro_left10 == (long)869648);
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right3 = bool;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left9.$amp$amp($org_scalatest_assert_macro_right3));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

