/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.read.realignment;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Level;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator;
import org.bdgenomics.adam.models.Consensus;
import org.bdgenomics.adam.models.Consensus$;
import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.read.ADAMAlignmentRecordContext$;
import org.bdgenomics.adam.rdd.read.ADAMAlignmentRecordRDDFunctions;
import org.bdgenomics.adam.rdd.read.realignment.IndelRealignmentTarget;
import org.bdgenomics.adam.rdd.read.realignment.RealignIndels;
import org.bdgenomics.adam.rdd.read.realignment.RealignIndels$;
import org.bdgenomics.adam.rdd.read.realignment.RealignIndelsSuite$;
import org.bdgenomics.adam.rdd.read.realignment.RealignmentTargetFinder$;
import org.bdgenomics.adam.rich.RichAlignmentRecord;
import org.bdgenomics.adam.rich.RichAlignmentRecord$;
import org.bdgenomics.adam.util.MdTag;
import org.bdgenomics.adam.util.SparkFunSuite;
import org.bdgenomics.adam.util.SparkFunSuite$class;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.TreeSet;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001m2A!\u0001\u0002\u0001\u001f\t\u0011\"+Z1mS\u001et\u0017J\u001c3fYN\u001cV/\u001b;f\u0015\t\u0019A!A\u0006sK\u0006d\u0017n\u001a8nK:$(BA\u0003\u0007\u0003\u0011\u0011X-\u00193\u000b\u0005\u001dA\u0011a\u0001:eI*\u0011\u0011BC\u0001\u0005C\u0012\fWN\u0003\u0002\f\u0019\u0005Q!\rZ4f]>l\u0017nY:\u000b\u00035\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\t\u0017!\t\tB#D\u0001\u0013\u0015\t\u0019B\"A\u0005tG\u0006d\u0017\r^3ti&\u0011QC\u0005\u0002\t\rVt7+^5uKB\u0011qCG\u0007\u00021)\u0011\u0011\u0004C\u0001\u0005kRLG.\u0003\u0002\u001c1\ti1\u000b]1sW\u001a+hnU;ji\u0016DQ!\b\u0001\u0005\u0002y\ta\u0001P5oSRtD#A\u0010\u0011\u0005\u0001\u0002Q\"\u0001\u0002\t\u000b\t\u0002A\u0011A\u0012\u0002\u00175\f7o\u001c8`e\u0016\fGm]\u000b\u0002IA\u0019QeK\u0017\u000e\u0003\u0019R!aB\u0014\u000b\u0005!J\u0013!B:qCJ\\'B\u0001\u0016\r\u0003\u0019\t\u0007/Y2iK&\u0011AF\n\u0002\u0004%\u0012#\u0005C\u0001\u00184\u001b\u0005y#B\u0001\u00192\u0003\u0011\tgO]8\u000b\u0005IR\u0011a\u00024pe6\fGo]\u0005\u0003i=\u0012q\"\u00117jO:lWM\u001c;SK\u000e|'\u000f\u001a\u0005\u0006m\u0001!\taI\u0001\u0011CJ$\u0018NZ5dS\u0006dwL]3bINDQ\u0001\u000f\u0001\u0005\u0002\r\n!$\u0019:uS\u001aL7-[1m?J,\u0017\r\\5h]\u0016$wL]3bINDQA\u000f\u0001\u0005\u0002\r\nqdZ1uW~\u000b'\u000f^5gS\u000eL\u0017\r\\0sK\u0006d\u0017n\u001a8fI~\u0013X-\u00193t\u0001")
public class RealignIndelsSuite
extends FunSuite
implements SparkFunSuite {
    private SparkContext sc;
    private Option<Map<String, Level>> maybeLevels;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public Option<Map<String, Level>> maybeLevels() {
        return this.maybeLevels;
    }

    @Override
    public void maybeLevels_$eq(Option<Map<String, Level>> x$1) {
        this.maybeLevels = x$1;
    }

    @Override
    public void setupSparkContext(String sparkName, boolean silenceSpark) {
        SparkFunSuite$class.setupSparkContext(this, sparkName, silenceSpark);
    }

    @Override
    public void teardownSparkContext() {
        SparkFunSuite$class.teardownSparkContext(this);
    }

    @Override
    public void sparkBefore(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkBefore(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkAfter(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkAfter(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkTest(String name, boolean silenceSpark, Seq<Tag> tags, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, silenceSpark, tags, body);
    }

    @Override
    public void sparkTest(String name, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, body);
    }

    @Override
    public boolean sparkBefore$default$2() {
        return SparkFunSuite$class.sparkBefore$default$2(this);
    }

    @Override
    public boolean setupSparkContext$default$2() {
        return SparkFunSuite$class.setupSparkContext$default$2(this);
    }

    @Override
    public boolean sparkAfter$default$2() {
        return SparkFunSuite$class.sparkAfter$default$2(this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public RDD<AlignmentRecord> mason_reads() {
        String path = ClassLoader.getSystemClassLoader().getResource("small_realignment_targets.sam").getFile();
        ADAMContext qual$1 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc());
        None$ x$12 = qual$1.adamLoad$default$2();
        Option x$13 = qual$1.adamLoad$default$3();
        RDD reads = qual$1.adamLoad(path, (Option)x$12, x$13, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(AlignmentRecord.class));
        return reads;
    }

    public RDD<AlignmentRecord> artificial_reads() {
        String path = ClassLoader.getSystemClassLoader().getResource("artificial.sam").getFile();
        ADAMContext qual$2 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc());
        None$ x$15 = qual$2.adamLoad$default$2();
        Option x$16 = qual$2.adamLoad$default$3();
        RDD reads = qual$2.adamLoad(path, (Option)x$15, x$16, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(AlignmentRecord.class));
        return reads;
    }

    public RDD<AlignmentRecord> artificial_realigned_reads() {
        ADAMAlignmentRecordRDDFunctions qual$3 = ADAMAlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(this.artificial_reads());
        ConsensusGenerator x$17 = qual$3.adamRealignIndels$default$1();
        boolean x$18 = qual$3.adamRealignIndels$default$2();
        int x$19 = qual$3.adamRealignIndels$default$3();
        int x$20 = qual$3.adamRealignIndels$default$4();
        double x$21 = qual$3.adamRealignIndels$default$5();
        int x$22 = qual$3.adamRealignIndels$default$6();
        return ADAMAlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(qual$3.adamRealignIndels(x$17, x$18, x$19, x$20, x$21, x$22)).adamSortReadsByReferencePosition();
    }

    public RDD<AlignmentRecord> gatk_artificial_realigned_reads() {
        String path = ClassLoader.getSystemClassLoader().getResource("artificial.realigned.sam").getFile();
        ADAMContext qual$4 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc());
        None$ x$24 = qual$4.adamLoad$default$2();
        Option x$25 = qual$4.adamLoad$default$3();
        RDD reads = qual$4.adamLoad(path, (Option)x$24, x$25, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(AlignmentRecord.class));
        return reads;
    }

    public RealignIndelsSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        SparkFunSuite$class.$init$(this);
        this.sparkTest("checking mapping to targets for artificial reads", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RealignIndelsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TreeSet targets = RealignmentTargetFinder$.MODULE$.apply(this.$outer.artificial_reads().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RichAlignmentRecord apply(AlignmentRecord x$1) {
                        return RichAlignmentRecord$.MODULE$.apply(x$1);
                    }
                }, ClassTag$.MODULE$.apply(RichAlignmentRecord.class)), RealignmentTargetFinder$.MODULE$.apply$default$2(), RealignmentTargetFinder$.MODULE$.apply$default$3());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)targets.size()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                RDD rr = this.$outer.artificial_reads().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RichAlignmentRecord apply(AlignmentRecord x$2) {
                        return RichAlignmentRecord$.MODULE$.apply(x$2);
                    }
                }, ClassTag$.MODULE$.apply(RichAlignmentRecord.class));
                Tuple2[] readsMappedToTarget = (Tuple2[])RealignIndels$.MODULE$.mapTargets(rr, targets).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Option<IndelRealignmentTarget>, Iterable<AlignmentRecord>> apply(Tuple2<Option<IndelRealignmentTarget>, Iterable<RichAlignmentRecord>> kv) {
                        if (kv != null) {
                            Tuple2 tuple2 = new Tuple2(kv._1(), kv._2());
                            Option t = (Option)tuple2._1();
                            Iterable r = (Iterable)tuple2._2();
                            return new Tuple2((Object)t, r.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final AlignmentRecord apply(RichAlignmentRecord r) {
                                    return r.record();
                                }
                            }, Iterable$.MODULE$.canBuildFrom()));
                        }
                        throw new MatchError(kv);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class)).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])readsMappedToTarget).size()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Predef$.MODULE$.refArrayOps((Object[])readsMappedToTarget).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Tuple2<Option<IndelRealignmentTarget>, Iterable<AlignmentRecord>> x0$1) {
                        if (x0$1 == null) return false;
                        if (x0$1._1() == null) return false;
                        Option option = (Option)x0$1._1();
                        if (!(x0$1._2() instanceof Seq)) return false;
                        Seq seq = (Seq)x0$1._2();
                        return seq.forall((Function1)new Serializable(this, option){
                            public static final long serialVersionUID = 0L;
                            private final Option x2$1;

                            public final boolean apply(AlignmentRecord read) {
                                boolean bl;
                                if (Predef$.MODULE$.Long2long(read.getStart()) <= 25L) {
                                    boolean result;
                                    boolean bl2 = result = ((IndelRealignmentTarget)this.x2$1.get()).readRange().start() <= Predef$.MODULE$.Long2long(read.getStart());
                                    bl = result && ((IndelRealignmentTarget)this.x2$1.get()).readRange().end() >= Predef$.MODULE$.Long2long(read.getEnd());
                                } else {
                                    bl = this.x2$1.isEmpty();
                                }
                                return bl;
                            }
                            {
                                this.x2$1 = x2$1;
                            }
                        });
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("checking alternative consensus for artificial reads", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RealignIndelsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ObjectRef consensus = new ObjectRef((Object)Nil$.MODULE$);
                Serializable serializable = new Serializable(this, consensus){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef consensus$1;

                    public final void apply(AlignmentRecord r) {
                        block4: {
                            List list;
                            if (!((MdTag)ADAMContext$.MODULE$.recordToRichRecord(r).mdTag().get()).hasMismatches()) break block4;
                            Option option = Consensus$.MODULE$.generateAlternateConsensus(ADAMContext$.MODULE$.charSequenceToString(r.getSequence()), new ReferencePosition("0", Predef$.MODULE$.Long2long(r.getStart())), ADAMContext$.MODULE$.recordToRichRecord(r).samtoolsCigar());
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                Consensus consensus = (Consensus)some.x();
                                list = ((List)this.consensus$1.elem).$colon$colon((Object)consensus);
                            } else {
                                None$ none$ = None$.MODULE$;
                                if (none$ != null ? !none$.equals(option) : option != null) {
                                    throw new MatchError((Object)option);
                                }
                                list = (List)this.consensus$1.elem;
                            }
                            this.consensus$1.elem = list;
                        }
                    }
                    {
                        this.consensus$1 = consensus$1;
                    }
                };
                List list = Predef$.MODULE$.refArrayOps((Object[])this.$outer.artificial_reads().collect()).toList();
                while (!list.isEmpty()) {
                    Object object = list.head();
                    serializable.apply((AlignmentRecord)object);
                    list = (List)list.tail();
                }
                consensus.elem = (List)((List)consensus.elem).distinct();
                int $org_scalatest_assert_macro_left = ((List)consensus.elem).length();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToInteger((int)0), $org_scalatest_assert_macro_left > 0);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((Consensus)ADAMContext$.MODULE$.listToJavaList((List)consensus.elem).get(0)).index().start()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)34), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)34), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((Consensus)ADAMContext$.MODULE$.listToJavaList((List)consensus.elem).get(0)).index().end()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)45), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)45), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(((Consensus)ADAMContext$.MODULE$.listToJavaList((List)consensus.elem).get(0)).consensus());
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)"", $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)"", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((Consensus)ADAMContext$.MODULE$.listToJavaList((List)consensus.elem).get(1)).index().start()));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)54), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)54), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((Consensus)ADAMContext$.MODULE$.listToJavaList((List)consensus.elem).get(1)).index().end()));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)65), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)65), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(((Consensus)ADAMContext$.MODULE$.listToJavaList((List)consensus.elem).get(1)).consensus());
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)"", $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)"", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("checking extraction of reference from reads", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ RealignIndelsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                BoxedUnit[] readReference;
                TreeSet targets = RealignmentTargetFinder$.MODULE$.apply(this.$outer.artificial_reads().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RichAlignmentRecord apply(AlignmentRecord x$5) {
                        return RichAlignmentRecord$.MODULE$.apply(x$5);
                    }
                }, ClassTag$.MODULE$.apply(RichAlignmentRecord.class)), RealignmentTargetFinder$.MODULE$.apply$default$2(), RealignmentTargetFinder$.MODULE$.apply$default$3());
                RDD rr = this.$outer.artificial_reads().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final RichAlignmentRecord apply(AlignmentRecord x$6) {
                        return RichAlignmentRecord$.MODULE$.apply(x$6);
                    }
                }, ClassTag$.MODULE$.apply(RichAlignmentRecord.class));
                Tuple2[] readsMappedToTarget = (Tuple2[])RealignIndels$.MODULE$.mapTargets(rr, targets).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Option<IndelRealignmentTarget>, Iterable<RichAlignmentRecord>> x$7) {
                        return ((Option)x$7._1()).isDefined();
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<IndelRealignmentTarget, Iterable<AlignmentRecord>> apply(Tuple2<Option<IndelRealignmentTarget>, Iterable<RichAlignmentRecord>> kv) {
                        if (kv != null) {
                            Tuple2 tuple2 = new Tuple2(kv._1(), kv._2());
                            Option t = (Option)tuple2._1();
                            Iterable r = (Iterable)tuple2._2();
                            return new Tuple2(t.get(), r.map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final AlignmentRecord apply(RichAlignmentRecord r) {
                                    return r.record();
                                }
                            }, Iterable$.MODULE$.canBuildFrom()));
                        }
                        throw new MatchError(kv);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class)).collect();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)readReference, "!=", null, (readReference = (BoxedUnit[])Predef$.MODULE$.refArrayOps((Object[])readsMappedToTarget).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply(Tuple2<IndelRealignmentTarget, Iterable<AlignmentRecord>> x0$2) {
                        if (x0$2 != null) {
                            if (!((IndelRealignmentTarget)x0$2._1()).isEmpty()) {
                                Bool bool;
                                Tuple3 referenceFromReads = RealignIndels$.MODULE$.getReferenceFromReads((Iterable)((TraversableOnce)((TraversableLike)x0$2._2()).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final RichAlignmentRecord apply(AlignmentRecord r) {
                                        return new RichAlignmentRecord(r);
                                    }
                                }, Iterable$.MODULE$.canBuildFrom())).toSeq());
                                long $org_scalatest_assert_macro_left = BoxesRunTime.unboxToLong((Object)referenceFromReads._2());
                                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)-1), $org_scalatest_assert_macro_left == (long)-1);
                                if ($org_scalatest_assert_macro_left2.value()) {
                                    bool = Bool$.MODULE$.simpleMacroBool(true, "");
                                } else {
                                    int $org_scalatest_assert_macro_left3 = ((String)referenceFromReads._1()).length();
                                    bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), ">", (Object)BoxesRunTime.boxToInteger((int)0), $org_scalatest_assert_macro_left3 > 0);
                                }
                                Bool $org_scalatest_assert_macro_right = bool;
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "||", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.$bar$bar((Function0)new Serializable(this, $org_scalatest_assert_macro_right){
                                    public static final long serialVersionUID = 0L;
                                    private final Bool $org_scalatest_assert_macro_right$1;

                                    public final Bool apply() {
                                        return this.$org_scalatest_assert_macro_right$1;
                                    }
                                    {
                                        this.$org_scalatest_assert_macro_right$1 = $org_scalatest_assert_macro_right$1;
                                    }
                                }));
                                this.$outer.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                this.$outer.org$bdgenomics$adam$rdd$read$realignment$RealignIndelsSuite$$anonfun$$checkReference$1(referenceFromReads);
                            }
                            return;
                        }
                        throw new AssertionError((Object)"Mapping should contain target and reads");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Unit()))) != null);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }

            public /* synthetic */ RealignIndelsSuite org$bdgenomics$adam$rdd$read$realignment$RealignIndelsSuite$$anonfun$$$outer() {
                return this.$outer;
            }

            public final void org$bdgenomics$adam$rdd$read$realignment$RealignIndelsSuite$$anonfun$$checkReference$1(Tuple3 readReference) {
                int startIndex = Math.min((int)BoxesRunTime.unboxToLong((Object)readReference._2()), 120);
                int stopIndex = Math.min((int)BoxesRunTime.unboxToLong((Object)readReference._3()), 180);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(readReference._1());
                String $org_scalatest_assert_macro_right = "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAGGGGGGGGGGAAAAAAAAAAGGGGGGGGGGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA".substring(startIndex, stopIndex);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("checking realigned reads for artificial input", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RealignIndelsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord[] artificial_realigned_reads_collected = (AlignmentRecord[])this.$outer.artificial_realigned_reads().collect();
                AlignmentRecord[] gatk_artificial_realigned_reads_collected = (AlignmentRecord[])this.$outer.gatk_artificial_realigned_reads().collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])artificial_realigned_reads_collected).size()));
                int $org_scalatest_assert_macro_right = Predef$.MODULE$.refArrayOps((Object[])gatk_artificial_realigned_reads_collected).size();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                AlignmentRecord[] artificial_read4 = (AlignmentRecord[])Predef$.MODULE$.refArrayOps((Object[])artificial_realigned_reads_collected).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(AlignmentRecord x$9) {
                        CharSequence charSequence = x$9.getReadName();
                        return !(charSequence != null ? !charSequence.equals("read4") : "read4" != null);
                    }
                });
                AlignmentRecord[] gatk_read4 = (AlignmentRecord[])Predef$.MODULE$.refArrayOps((Object[])gatk_artificial_realigned_reads_collected).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(AlignmentRecord x$10) {
                        CharSequence charSequence = x$10.getReadName();
                        return !(charSequence != null ? !charSequence.equals("read4") : "read4" != null);
                    }
                });
                Tuple2[] result = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])artificial_read4).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])gatk_read4), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])result).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<AlignmentRecord, AlignmentRecord> pair) {
                        CharSequence charSequence = ((AlignmentRecord)pair._1()).getReadName();
                        CharSequence charSequence2 = ((AlignmentRecord)pair._2()).getReadName();
                        return !(charSequence != null ? !charSequence.equals(charSequence2) : charSequence2 != null);
                    }
                }), "scala.this.Predef.refArrayOps[(org.bdgenomics.formats.avro.AlignmentRecord, org.bdgenomics.formats.avro.AlignmentRecord)](result).forall(((pair: (org.bdgenomics.formats.avro.AlignmentRecord, org.bdgenomics.formats.avro.AlignmentRecord)) => pair._1.getReadName().==(pair._2.getReadName())))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])result).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<AlignmentRecord, AlignmentRecord> pair) {
                        Long l = ((AlignmentRecord)pair._1()).getStart();
                        Long l2 = ((AlignmentRecord)pair._2()).getStart();
                        return !(l != null ? !((Object)l).equals(l2) : l2 != null);
                    }
                }), "scala.this.Predef.refArrayOps[(org.bdgenomics.formats.avro.AlignmentRecord, org.bdgenomics.formats.avro.AlignmentRecord)](result).forall(((pair: (org.bdgenomics.formats.avro.AlignmentRecord, org.bdgenomics.formats.avro.AlignmentRecord)) => pair._1.getStart().==(pair._2.getStart())))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])result).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<AlignmentRecord, AlignmentRecord> pair) {
                        CharSequence charSequence = ((AlignmentRecord)pair._1()).getCigar();
                        CharSequence charSequence2 = ((AlignmentRecord)pair._2()).getCigar();
                        return !(charSequence != null ? !charSequence.equals(charSequence2) : charSequence2 != null);
                    }
                }), "scala.this.Predef.refArrayOps[(org.bdgenomics.formats.avro.AlignmentRecord, org.bdgenomics.formats.avro.AlignmentRecord)](result).forall(((pair: (org.bdgenomics.formats.avro.AlignmentRecord, org.bdgenomics.formats.avro.AlignmentRecord)) => pair._1.getCigar().==(pair._2.getCigar())))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])result).forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<AlignmentRecord, AlignmentRecord> pair) {
                        Integer n = ((AlignmentRecord)pair._1()).getMapq();
                        Integer n2 = ((AlignmentRecord)pair._2()).getMapq();
                        return !(n != null ? !((Object)n).equals(n2) : n2 != null);
                    }
                }), "scala.this.Predef.refArrayOps[(org.bdgenomics.formats.avro.AlignmentRecord, org.bdgenomics.formats.avro.AlignmentRecord)](result).forall(((pair: (org.bdgenomics.formats.avro.AlignmentRecord, org.bdgenomics.formats.avro.AlignmentRecord)) => pair._1.getMapq().==(pair._2.getMapq())))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("test mismatch quality scoring", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RealignIndelsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RealignIndels ri = new RealignIndels(RealignIndels$.MODULE$.$lessinit$greater$default$1(), RealignIndels$.MODULE$.$lessinit$greater$default$2(), RealignIndels$.MODULE$.$lessinit$greater$default$3(), RealignIndels$.MODULE$.$lessinit$greater$default$4(), RealignIndels$.MODULE$.$lessinit$greater$default$5(), RealignIndels$.MODULE$.$lessinit$greater$default$6());
                Seq qScores = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{40, 40, 40, 40, 40, 40, 40, 40}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)ri.sumMismatchQualityIgnoreCigar("AAAAAAAA", "AAGGGGAA", qScores)));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)160), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)160), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("test mismatch quality scoring for no mismatches", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RealignIndelsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RealignIndels ri = new RealignIndels(RealignIndels$.MODULE$.$lessinit$greater$default$1(), RealignIndels$.MODULE$.$lessinit$greater$default$2(), RealignIndels$.MODULE$.$lessinit$greater$default$3(), RealignIndels$.MODULE$.$lessinit$greater$default$4(), RealignIndels$.MODULE$.$lessinit$greater$default$5(), RealignIndels$.MODULE$.$lessinit$greater$default$6());
                Seq qScores = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{40, 40, 40, 40, 40, 40, 40, 40}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)ri.sumMismatchQualityIgnoreCigar("AAAAAAAA", "AAAAAAAA", qScores)));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)0), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("test mismatch quality scoring after unpacking read", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RealignIndelsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RealignIndels ri = new RealignIndels(RealignIndels$.MODULE$.$lessinit$greater$default$1(), RealignIndels$.MODULE$.$lessinit$greater$default$2(), RealignIndels$.MODULE$.$lessinit$greater$default$3(), RealignIndels$.MODULE$.$lessinit$greater$default$4(), RealignIndels$.MODULE$.$lessinit$greater$default$5(), RealignIndels$.MODULE$.$lessinit$greater$default$6());
                AlignmentRecord read = (AlignmentRecord)this.$outer.artificial_reads().first();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)ri.sumMismatchQuality(read)));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)800), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)800), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

