/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.variation;

import com.google.common.io.Files;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Level;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.models.VariantContext;
import org.bdgenomics.adam.models.VariantContext$;
import org.bdgenomics.adam.rdd.variation.ADAMVariationContext;
import org.bdgenomics.adam.rdd.variation.ADAMVariationContext$;
import org.bdgenomics.adam.util.SparkFunSuite;
import org.bdgenomics.adam.util.SparkFunSuite$class;
import org.bdgenomics.formats.avro.Contig;
import org.bdgenomics.formats.avro.Genotype;
import org.bdgenomics.formats.avro.GenotypeAllele;
import org.bdgenomics.formats.avro.Variant;
import org.bdgenomics.formats.avro.VariantCallingAnnotations;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y2A!\u0001\u0002\u0001\u001b\tI\u0012\tR!N-\u0006\u0014\u0018.\u0019;j_:\u001cuN\u001c;fqR\u001cV/\u001b;f\u0015\t\u0019A!A\u0005wCJL\u0017\r^5p]*\u0011QAB\u0001\u0004e\u0012$'BA\u0004\t\u0003\u0011\tG-Y7\u000b\u0005%Q\u0011A\u00032eO\u0016tw.\\5dg*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ!!\u0005\u0006\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA\n\u0011\u0005!1UO\\*vSR,\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0007\u0003\u0011)H/\u001b7\n\u0005e1\"!D*qCJ\\g)\u001e8Tk&$X\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!9\u0001\u0005\u0001b\u0001\n\u0003\t\u0013a\u0002;f[B$\u0015N]\u000b\u0002EA\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0003S>T\u0011aJ\u0001\u0005U\u00064\u0018-\u0003\u0002*I\t!a)\u001b7f\u0011\u0019Y\u0003\u0001)A\u0005E\u0005AA/Z7q\t&\u0014\b\u0005C\u0003.\u0001\u0011\u0005a&\u0001\u0005wCJL\u0017M\u001c;t+\u0005y\u0003c\u0001\u00197q5\t\u0011G\u0003\u0002\u0006e)\u00111\u0007N\u0001\u0006gB\f'o\u001b\u0006\u0003k)\ta!\u00199bG\",\u0017BA\u001c2\u0005\r\u0011F\t\u0012\t\u0003sqj\u0011A\u000f\u0006\u0003w\u0019\ta!\\8eK2\u001c\u0018BA\u001f;\u000591\u0016M]5b]R\u001cuN\u001c;fqR\u0004")
public class ADAMVariationContextSuite
extends FunSuite
implements SparkFunSuite {
    private final File tempDir;
    private SparkContext sc;
    private Option<Map<String, Level>> maybeLevels;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public Option<Map<String, Level>> maybeLevels() {
        return this.maybeLevels;
    }

    @Override
    public void maybeLevels_$eq(Option<Map<String, Level>> x$1) {
        this.maybeLevels = x$1;
    }

    @Override
    public void setupSparkContext(String sparkName, boolean silenceSpark) {
        SparkFunSuite$class.setupSparkContext(this, sparkName, silenceSpark);
    }

    @Override
    public void teardownSparkContext() {
        SparkFunSuite$class.teardownSparkContext(this);
    }

    @Override
    public void sparkBefore(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkBefore(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkAfter(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkAfter(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkTest(String name, boolean silenceSpark, Seq<Tag> tags, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, silenceSpark, tags, body);
    }

    @Override
    public void sparkTest(String name, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, body);
    }

    @Override
    public boolean sparkBefore$default$2() {
        return SparkFunSuite$class.sparkBefore$default$2(this);
    }

    @Override
    public boolean setupSparkContext$default$2() {
        return SparkFunSuite$class.setupSparkContext$default$2(this);
    }

    @Override
    public boolean sparkAfter$default$2() {
        return SparkFunSuite$class.sparkAfter$default$2(this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public File tempDir() {
        return this.tempDir;
    }

    public RDD<VariantContext> variants() {
        Variant v0 = Variant.newBuilder().setContig(Contig.newBuilder().setContigName((CharSequence)"chr11").build()).setStart(Predef$.MODULE$.long2Long(17409572L)).setReferenceAllele((CharSequence)"T").setAlternateAllele((CharSequence)"C").build();
        Genotype g0 = Genotype.newBuilder().setVariant(v0).setSampleId((CharSequence)"NA12878").setAlleles(JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GenotypeAllele[]{GenotypeAllele.Ref, GenotypeAllele.Alt})))).build();
        SparkContext qual$1 = this.sc();
        List x$1 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new VariantContext[]{VariantContext$.MODULE$.apply(v0, (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Genotype[]{g0})), VariantContext$.MODULE$.apply$default$3())}));
        int x$2 = qual$1.parallelize$default$2();
        return qual$1.parallelize((Seq)x$1, x$2, ClassTag$.MODULE$.apply(VariantContext.class));
    }

    public ADAMVariationContextSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        SparkFunSuite$class.$init$(this);
        this.tempDir = Files.createTempDir();
        this.sparkTest("can read a small .vcf file", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMVariationContextSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                VariantCallingAnnotations $org_scalatest_assert_macro_left;
                String path = ClassLoader.getSystemClassLoader().getResource("small.vcf").getFile();
                ADAMVariationContext qual$2 = ADAMVariationContext$.MODULE$.sparkContextToADAMVariationContext(this.$outer.sc());
                Option x$4 = qual$2.adamVCFLoad$default$2();
                RDD vcs = qual$2.adamVCFLoad(path, x$4);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)vcs.count()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)5), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)5), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                VariantContext vc = (VariantContext)vcs.first();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)vc.genotypes().size()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Genotype gt = (Genotype)vc.genotypes().head();
                VariantCallingAnnotations variantCallingAnnotations = $org_scalatest_assert_macro_left = gt.getVariantCallingAnnotations();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, variantCallingAnnotations != null ? !variantCallingAnnotations.equals(null) : null != null);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(gt.getVariantCallingAnnotations().getReadDepth());
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)69), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)69), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(gt.getVariantCallingAnnotations().getClippingRankSum());
                Float $org_scalatest_assert_macro_right = Float.valueOf("0.138");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("can write, then read in .vcf file", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMVariationContextSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File path = new File(this.$outer.tempDir(), "test.vcf");
                ADAMVariationContext qual$3 = ADAMVariationContext$.MODULE$.sparkContextToADAMVariationContext(this.$outer.sc());
                String x$5 = path.getAbsolutePath();
                RDD<VariantContext> x$6 = this.$outer.variants();
                Option x$7 = qual$3.adamVCFSave$default$3();
                qual$3.adamVCFSave(x$5, x$6, x$7);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(path.exists(), "path.exists()");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

