/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.util;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.TextCigarCodec;
import org.bdgenomics.adam.rich.RichAlignmentRecord$;
import org.bdgenomics.adam.util.MdTag;
import org.bdgenomics.adam.util.MdTag$;
import org.bdgenomics.adam.util.MdTagSuite$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u00153A!\u0001\u0002\u0001\u0017\tQQ\n\u001a+bON+\u0018\u000e^3\u000b\u0005\r!\u0011\u0001B;uS2T!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\ty\u0001\"A\u0005tG\u0006d\u0017\r^3ti&\u0011\u0011C\u0004\u0002\t\rVt7+^5uK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001\u0005\b1\u0001\u0011\r\u0011\"\u0001\u001a\u0003-\u0019\u0015jR!S?\u000e{E)R\"\u0016\u0003i\u0001\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u0011M\fW\u000e^8pYNT\u0011aH\u0001\u0007QR\u001c(\u000eZ6\n\u0005\u0005b\"A\u0004+fqR\u001c\u0015nZ1s\u0007>$Wm\u0019\u0005\u0007G\u0001\u0001\u000b\u0011\u0002\u000e\u0002\u0019\rKu)\u0011*`\u0007>#Ui\u0011\u0011\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\u000fQ,7\u000f\u001e+bORAq%\f\u001c9u}\n5\t\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0003V]&$\b\"\u0002\u0018%\u0001\u0004y\u0013\u0001\u0002:fC\u0012\u0004\"\u0001M\u001a\u000f\u0005!\n\u0014B\u0001\u001a*\u0003\u0019\u0001&/\u001a3fM&\u0011A'\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005IJ\u0003\"B\u001c%\u0001\u0004y\u0013!\u0003:fM\u0016\u0014XM\\2f\u0011\u0015ID\u00051\u00010\u0003!\u0019\u0017nZ1s'R\u0014\b\"B\u001e%\u0001\u0004a\u0014!B:uCJ$\bC\u0001\u0015>\u0013\tq\u0014F\u0001\u0003M_:<\u0007\"\u0002!%\u0001\u0004y\u0013aC3ya\u0016\u001cG/\u001a3UC\u001eDQA\u0011\u0013A\u0002q\nQ\"\u001a=qK\u000e$X\rZ*uCJ$\b\"\u0002#%\u0001\u0004a\u0014aC3ya\u0016\u001cG/\u001a3F]\u0012\u0004")
public class MdTagSuite
extends FunSuite {
    private final TextCigarCodec CIGAR_CODEC = TextCigarCodec.getSingleton();

    public TextCigarCodec CIGAR_CODEC() {
        return this.CIGAR_CODEC;
    }

    public void testTag(String read, String reference, String cigarStr, long start, String expectedTag, long expectedStart, long expectedEnd) {
        String $org_scalatest_assert_macro_left;
        MdTag tag = MdTag$.MODULE$.apply(read, reference, this.CIGAR_CODEC().decode(cigarStr), start);
        String string = $org_scalatest_assert_macro_left = tag.toString();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)expectedTag, !(string != null ? !string.equals(expectedTag) : expectedTag != null));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
        long $org_scalatest_assert_macro_left2 = tag.start();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)expectedStart), $org_scalatest_assert_macro_left2 == expectedStart);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
        long $org_scalatest_assert_macro_left3 = tag.end();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToLong((long)expectedEnd), $org_scalatest_assert_macro_left3 == expectedEnd);
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
    }

    public MdTagSuite() {
        this.test("null md tag", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                MdTag$.MODULE$.apply(null, 0L);
            }

            public void apply$mcV$sp() {
                MdTag$.MODULE$.apply(null, 0L);
            }
        });
        this.test("zero length md tag", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                MdTag$.MODULE$.apply("", 0L);
            }

            public void apply$mcV$sp() {
                MdTag$.MODULE$.apply("", 0L);
            }
        });
        this.test("md tag with non-digit initial value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MdTag apply() {
                        return MdTag$.MODULE$.apply("ACTG0", 0L);
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("md tag invalid base", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MdTag apply() {
                        return MdTag$.MODULE$.apply("0ACTZ", 0L);
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("md tag with no digit at end", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MdTag apply() {
                        return MdTag$.MODULE$.apply("0ACTG", 0L);
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("md tag, pure insertion", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("0", 1L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tag.start()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)1L), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)1L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(tag.toString());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)"0", $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)"0", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("md tag, pure insertion, test 2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("ACATAC", "", this.$outer.CIGAR_CODEC().decode("6I"), 1L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tag.start()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)1L), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)1L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(tag.toString());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)"0", $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)"0", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("md tag pure insertion equality", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag0 = MdTag$.MODULE$.apply("0", 1L);
                MdTag tag1 = MdTag$.MODULE$.apply("0", 1L);
                MdTag tag2 = MdTag$.MODULE$.apply("0", 3L);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(tag0.equals((Object)tag1), "tag0.equals(tag1)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(tag0.equals((Object)tag2), "tag0.equals(tag2)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("md tag equality and hashcode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag md1 = MdTag$.MODULE$.apply("0A0", 0L);
                MdTag md1Dup = MdTag$.MODULE$.apply("0A0", 0L);
                MdTag mdTag = md1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)md1, "==", (Object)md1Dup, !(mdTag != null ? !mdTag.equals(md1Dup) : md1Dup != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                int $org_scalatest_assert_macro_left = md1.hashCode();
                int $org_scalatest_assert_macro_right = md1Dup.hashCode();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                MdTag md2 = MdTag$.MODULE$.apply("100C0^C20", 0L);
                MdTag md2Dup = MdTag$.MODULE$.apply("100C0^C20", 0L);
                MdTag mdTag2 = md2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)md2, "==", (Object)md2Dup, !(mdTag2 != null ? !mdTag2.equals(md2Dup) : md2Dup != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                int $org_scalatest_assert_macro_left2 = md2.hashCode();
                int $org_scalatest_assert_macro_right2 = md2Dup.hashCode();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                MdTag md3 = MdTag$.MODULE$.apply("22^A79", 0L);
                MdTag md3Dup = MdTag$.MODULE$.apply("22^A79", 0L);
                MdTag mdTag3 = md3;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)md3, "==", (Object)md3Dup, !(mdTag3 != null ? !mdTag3.equals(md3Dup) : md3Dup != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                int $org_scalatest_assert_macro_left3 = md3.hashCode();
                int $org_scalatest_assert_macro_right3 = md3Dup.hashCode();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("valid md tags", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Unable to fully structure code
             */
            public void apply$mcV$sp() {
                md1 = MdTag$.MODULE$.apply("0A0", 0L);
                $org_scalatest_assert_macro_left = md1.mismatchedBase(0L);
                $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToCharacter((char)'A'));
                v0 = $org_scalatest_assert_macro_left;
                $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(v0 != null ? v0.equals($org_scalatest_assert_macro_right) == false : $org_scalatest_assert_macro_right != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)md1.countOfMismatches()));
                $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                md2 = MdTag$.MODULE$.apply("100", 0L);
                var7_8 = Predef$.MODULE$;
                var107_9 = new Serializable(this, md2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;
                    private final MdTag md2$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.md2$1.isMatch((long)i), "md2.isMatch(i.toLong)");
                        this.$outer.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.md2$1 = md2$1;
                    }
                };
                var8_10 = RichInt$.MODULE$.until$extension0(0, 100);
                if (!var8_10.validateRangeBoundaries((Function1)var107_9)) ** GOTO lbl20
                var109_11 = var8_10.start();
                var9_12 = var8_10.terminalElement();
                var108_13 = var8_10.step();
                while (true) {
                    block13: {
                        if (var109_11 != var9_12) break block13;
lbl20:
                        // 2 sources

                        $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(md2.isMatch(-1L), "md2.isMatch(-1L)"));
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)md2.countOfMismatches()));
                        $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)0), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0), Equality$.MODULE$.default()));
                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                        md3 = MdTag$.MODULE$.apply("100C2", 0L);
                        var14_18 = Predef$.MODULE$;
                        var104_19 = new Serializable(this, md3){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$10 $outer;
                            private final MdTag md3$1;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.md3$1.isMatch((long)i), "md3.isMatch(i.toLong)");
                                this.$outer.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.md3$1 = md3$1;
                            }
                        };
                        var15_20 = RichInt$.MODULE$.until$extension0(0, 100);
                        if (!var15_20.validateRangeBoundaries((Function1)var104_19)) ** GOTO lbl35
                        var106_21 = var15_20.start();
                        var16_22 = var15_20.terminalElement();
                        var105_23 = var15_20.step();
                        while (true) {
                            block14: {
                                if (var106_21 != var16_22) break block14;
lbl35:
                                // 2 sources

                                $org_scalatest_assert_macro_left = md3.mismatchedBase(100L);
                                $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToCharacter((char)'C'));
                                v1 = $org_scalatest_assert_macro_left;
                                $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(v1 != null ? v1.equals($org_scalatest_assert_macro_right) == false : $org_scalatest_assert_macro_right != null));
                                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)md3.countOfMismatches()));
                                $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                var22_29 = Predef$.MODULE$;
                                var101_30 = new Serializable(this, md3){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$10 $outer;
                                    private final MdTag md3$1;

                                    public final void apply(int i) {
                                        this.apply$mcVI$sp(i);
                                    }

                                    public void apply$mcVI$sp(int i) {
                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.md3$1.isMatch((long)i), "md3.isMatch(i.toLong)");
                                        this.$outer.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.md3$1 = md3$1;
                                    }
                                };
                                var24_31 = RichInt$.MODULE$.until$extension0(101, 103);
                                if (!var24_31.validateRangeBoundaries((Function1)var101_30)) ** GOTO lbl52
                                var103_32 = var24_31.start();
                                var25_33 = var24_31.terminalElement();
                                var102_34 = var24_31.step();
                                while (true) {
                                    block15: {
                                        if (var103_32 != var25_33) break block15;
lbl52:
                                        // 2 sources

                                        md4 = MdTag$.MODULE$.apply("100C0^C20", 0L);
                                        var26_36 = Predef$.MODULE$;
                                        var98_37 = new Serializable(this, md4){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$10 $outer;
                                            private final MdTag md4$1;

                                            public final void apply(int i) {
                                                this.apply$mcVI$sp(i);
                                            }

                                            public void apply$mcVI$sp(int i) {
                                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.md4$1.isMatch((long)i), "md4.isMatch(i.toLong)");
                                                this.$outer.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                                this.md4$1 = md4$1;
                                            }
                                        };
                                        var27_38 = RichInt$.MODULE$.until$extension0(0, 100);
                                        if (!var27_38.validateRangeBoundaries((Function1)var98_37)) ** GOTO lbl62
                                        var100_39 = var27_38.start();
                                        var28_40 = var27_38.terminalElement();
                                        var99_41 = var27_38.step();
                                        while (true) {
                                            block16: {
                                                if (var100_39 != var28_40) break block16;
lbl62:
                                                // 2 sources

                                                $org_scalatest_assert_macro_left = md4.mismatchedBase(100L);
                                                $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToCharacter((char)'C'));
                                                v2 = $org_scalatest_assert_macro_left;
                                                $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(v2 != null ? v2.equals($org_scalatest_assert_macro_right) == false : $org_scalatest_assert_macro_right != null));
                                                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                $org_scalatest_assert_macro_left = md4.deletedBase(101L);
                                                $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToCharacter((char)'C'));
                                                v3 = $org_scalatest_assert_macro_left;
                                                $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(v3 != null ? v3.equals($org_scalatest_assert_macro_right) == false : $org_scalatest_assert_macro_right != null));
                                                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                var35_48 = Predef$.MODULE$;
                                                var95_49 = new Serializable(this, md4){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ $anonfun$10 $outer;
                                                    private final MdTag md4$1;

                                                    public final void apply(int i) {
                                                        this.apply$mcVI$sp(i);
                                                    }

                                                    public void apply$mcVI$sp(int i) {
                                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.md4$1.isMatch((long)i), "md4.isMatch(i.toLong)");
                                                        this.$outer.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw new NullPointerException();
                                                        }
                                                        this.$outer = $outer;
                                                        this.md4$1 = md4$1;
                                                    }
                                                };
                                                var37_50 = RichInt$.MODULE$.until$extension0(102, 122);
                                                if (!var37_50.validateRangeBoundaries((Function1)var95_49)) ** GOTO lbl81
                                                var97_51 = var37_50.start();
                                                var38_52 = var37_50.terminalElement();
                                                var96_53 = var37_50.step();
                                                while (true) {
                                                    block17: {
                                                        if (var97_51 != var38_52) break block17;
lbl81:
                                                        // 2 sources

                                                        md5 = MdTag$.MODULE$.apply(new StringBuilder().append((Object)"0^").append((Object)"ACGTACGTACGT").append((Object)"10").toString(), 0L);
                                                        var39_55 = Predef$.MODULE$;
                                                        var92_56 = new Serializable(this, "ACGTACGTACGT", md5){
                                                            public static final long serialVersionUID = 0L;
                                                            private final /* synthetic */ $anonfun$10 $outer;
                                                            private final String deletedString$1;
                                                            private final MdTag md5$1;

                                                            public final void apply(int i) {
                                                                this.apply$mcVI$sp(i);
                                                            }

                                                            public void apply$mcVI$sp(int i) {
                                                                Option $org_scalatest_assert_macro_left = this.md5$1.deletedBase((long)i);
                                                                Some $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToCharacter((char)this.deletedString$1.charAt(i)));
                                                                Option option = $org_scalatest_assert_macro_left;
                                                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(option != null ? !option.equals($org_scalatest_assert_macro_right) : $org_scalatest_assert_macro_right != null));
                                                                this.$outer.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                            }
                                                            {
                                                                if ($outer == null) {
                                                                    throw new NullPointerException();
                                                                }
                                                                this.$outer = $outer;
                                                                this.deletedString$1 = deletedString$1;
                                                                this.md5$1 = md5$1;
                                                            }
                                                        };
                                                        var40_57 = RichInt$.MODULE$.until$extension0(0, "ACGTACGTACGT".length());
                                                        if (!var40_57.validateRangeBoundaries((Function1)var92_56)) ** GOTO lbl91
                                                        var94_58 = var40_57.start();
                                                        var41_59 = var40_57.terminalElement();
                                                        var93_60 = var40_57.step();
                                                        while (true) {
                                                            block18: {
                                                                if (var94_58 != var41_59) break block18;
lbl91:
                                                                // 2 sources

                                                                $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)md5.countOfMismatches()));
                                                                $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)0), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0), Equality$.MODULE$.default()));
                                                                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                                md6 = MdTag$.MODULE$.apply("22^A79", 0L);
                                                                var45_64 = Predef$.MODULE$;
                                                                var89_65 = new Serializable(this, md6){
                                                                    public static final long serialVersionUID = 0L;
                                                                    private final /* synthetic */ $anonfun$10 $outer;
                                                                    private final MdTag md6$1;

                                                                    public final void apply(int i) {
                                                                        this.apply$mcVI$sp(i);
                                                                    }

                                                                    public void apply$mcVI$sp(int i) {
                                                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.md6$1.isMatch((long)i), "md6.isMatch(i.toLong)");
                                                                        this.$outer.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                                    }
                                                                    {
                                                                        if ($outer == null) {
                                                                            throw new NullPointerException();
                                                                        }
                                                                        this.$outer = $outer;
                                                                        this.md6$1 = md6$1;
                                                                    }
                                                                };
                                                                var46_66 = RichInt$.MODULE$.until$extension0(0, 22);
                                                                if (!var46_66.validateRangeBoundaries((Function1)var89_65)) ** GOTO lbl104
                                                                var91_67 = var46_66.start();
                                                                var47_68 = var46_66.terminalElement();
                                                                var90_69 = var46_66.step();
                                                                while (true) {
                                                                    block19: {
                                                                        if (var91_67 != var47_68) break block19;
lbl104:
                                                                        // 2 sources

                                                                        $org_scalatest_assert_macro_left = md6.deletedBase(22L);
                                                                        $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToCharacter((char)'A'));
                                                                        v4 = $org_scalatest_assert_macro_left;
                                                                        $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(v4 != null ? v4.equals($org_scalatest_assert_macro_right) == false : $org_scalatest_assert_macro_right != null));
                                                                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                                        var51_73 = Predef$.MODULE$;
                                                                        var86_74 = new Serializable(this, md6){
                                                                            public static final long serialVersionUID = 0L;
                                                                            private final /* synthetic */ $anonfun$10 $outer;
                                                                            private final MdTag md6$1;

                                                                            public final void apply(int i) {
                                                                                this.apply$mcVI$sp(i);
                                                                            }

                                                                            public void apply$mcVI$sp(int i) {
                                                                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.md6$1.isMatch((long)i), "md6.isMatch(i.toLong)");
                                                                                this.$outer.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                                            }
                                                                            {
                                                                                if ($outer == null) {
                                                                                    throw new NullPointerException();
                                                                                }
                                                                                this.$outer = $outer;
                                                                                this.md6$1 = md6$1;
                                                                            }
                                                                        };
                                                                        var53_75 = RichInt$.MODULE$.until$extension0(23, 102);
                                                                        if (!var53_75.validateRangeBoundaries((Function1)var86_74)) ** GOTO lbl118
                                                                        var88_76 = var53_75.start();
                                                                        var54_77 = var53_75.terminalElement();
                                                                        var87_78 = var53_75.step();
                                                                        while (true) {
                                                                            block20: {
                                                                                if (var88_76 != var54_77) break block20;
lbl118:
                                                                                // 2 sources

                                                                                md7 = MdTag$.MODULE$.apply("39r36c23", 0L);
                                                                                var55_80 = Predef$.MODULE$;
                                                                                var83_81 = new Serializable(this, md7){
                                                                                    public static final long serialVersionUID = 0L;
                                                                                    private final /* synthetic */ $anonfun$10 $outer;
                                                                                    private final MdTag md7$1;

                                                                                    public final void apply(int i) {
                                                                                        this.apply$mcVI$sp(i);
                                                                                    }

                                                                                    public void apply$mcVI$sp(int i) {
                                                                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.md7$1.isMatch((long)i), "md7.isMatch(i.toLong)");
                                                                                        this.$outer.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                                                    }
                                                                                    {
                                                                                        if ($outer == null) {
                                                                                            throw new NullPointerException();
                                                                                        }
                                                                                        this.$outer = $outer;
                                                                                        this.md7$1 = md7$1;
                                                                                    }
                                                                                };
                                                                                var56_82 = RichInt$.MODULE$.until$extension0(0, 39);
                                                                                if (!var56_82.validateRangeBoundaries((Function1)var83_81)) ** GOTO lbl128
                                                                                var85_83 = var56_82.start();
                                                                                var57_84 = var56_82.terminalElement();
                                                                                var84_85 = var56_82.step();
                                                                                while (true) {
                                                                                    block21: {
                                                                                        if (var85_83 != var57_84) break block21;
lbl128:
                                                                                        // 2 sources

                                                                                        $org_scalatest_assert_macro_left = md7.mismatchedBase(39L);
                                                                                        $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToCharacter((char)'R'));
                                                                                        v5 = $org_scalatest_assert_macro_left;
                                                                                        $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(v5 != null ? v5.equals($org_scalatest_assert_macro_right) == false : $org_scalatest_assert_macro_right != null));
                                                                                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                                                        var61_89 = Predef$.MODULE$;
                                                                                        var80_90 = new Serializable(this, md7){
                                                                                            public static final long serialVersionUID = 0L;
                                                                                            private final /* synthetic */ $anonfun$10 $outer;
                                                                                            private final MdTag md7$1;

                                                                                            public final void apply(int i) {
                                                                                                this.apply$mcVI$sp(i);
                                                                                            }

                                                                                            public void apply$mcVI$sp(int i) {
                                                                                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.md7$1.isMatch((long)i), "md7.isMatch(i.toLong)");
                                                                                                this.$outer.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                                                            }
                                                                                            {
                                                                                                if ($outer == null) {
                                                                                                    throw new NullPointerException();
                                                                                                }
                                                                                                this.$outer = $outer;
                                                                                                this.md7$1 = md7$1;
                                                                                            }
                                                                                        };
                                                                                        var62_91 = RichInt$.MODULE$.until$extension0(40, 76);
                                                                                        if (!var62_91.validateRangeBoundaries((Function1)var80_90)) ** GOTO lbl142
                                                                                        var82_92 = var62_91.start();
                                                                                        var63_93 = var62_91.terminalElement();
                                                                                        var81_94 = var62_91.step();
                                                                                        while (true) {
                                                                                            block22: {
                                                                                                if (var82_92 != var63_93) break block22;
lbl142:
                                                                                                // 2 sources

                                                                                                $org_scalatest_assert_macro_left = md7.mismatchedBase(76L);
                                                                                                $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToCharacter((char)'C'));
                                                                                                v6 = $org_scalatest_assert_macro_left;
                                                                                                $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(v6 != null ? v6.equals($org_scalatest_assert_macro_right) == false : $org_scalatest_assert_macro_right != null));
                                                                                                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                                                                var67_98 = Predef$.MODULE$;
                                                                                                var77_99 = new Serializable(this, md7){
                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                    private final /* synthetic */ $anonfun$10 $outer;
                                                                                                    private final MdTag md7$1;

                                                                                                    public final void apply(int i) {
                                                                                                        this.apply$mcVI$sp(i);
                                                                                                    }

                                                                                                    public void apply$mcVI$sp(int i) {
                                                                                                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.md7$1.isMatch((long)i), "md7.isMatch(i.toLong)");
                                                                                                        this.$outer.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                                                                    }
                                                                                                    {
                                                                                                        if ($outer == null) {
                                                                                                            throw new NullPointerException();
                                                                                                        }
                                                                                                        this.$outer = $outer;
                                                                                                        this.md7$1 = md7$1;
                                                                                                    }
                                                                                                };
                                                                                                var69_100 = RichInt$.MODULE$.until$extension0(77, 100);
                                                                                                if (!var69_100.validateRangeBoundaries((Function1)var77_99)) ** GOTO lbl156
                                                                                                var79_101 = var69_100.start();
                                                                                                var70_102 = var69_100.terminalElement();
                                                                                                var78_103 = var69_100.step();
                                                                                                while (true) {
                                                                                                    block23: {
                                                                                                        if (var79_101 != var70_102) break block23;
lbl156:
                                                                                                        // 2 sources

                                                                                                        mdy = MdTag$.MODULE$.apply("34Y18G46", 0L);
                                                                                                        $org_scalatest_assert_macro_left = mdy.mismatchedBase(34L);
                                                                                                        $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToCharacter((char)'Y'));
                                                                                                        v7 = $org_scalatest_assert_macro_left;
                                                                                                        $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(v7 != null ? v7.equals($org_scalatest_assert_macro_right) == false : $org_scalatest_assert_macro_right != null));
                                                                                                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                                                                        $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)mdy.countOfMismatches()));
                                                                                                        $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)2), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2), Equality$.MODULE$.default()));
                                                                                                        this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                                                                                                        return;
                                                                                                    }
                                                                                                    var77_99.apply$mcVI$sp(var79_101);
                                                                                                    var79_101 += var78_103;
                                                                                                }
                                                                                            }
                                                                                            var80_90.apply$mcVI$sp(var82_92);
                                                                                            var82_92 += var81_94;
                                                                                        }
                                                                                    }
                                                                                    var83_81.apply$mcVI$sp(var85_83);
                                                                                    var85_83 += var84_85;
                                                                                }
                                                                            }
                                                                            var86_74.apply$mcVI$sp(var88_76);
                                                                            var88_76 += var87_78;
                                                                        }
                                                                    }
                                                                    var89_65.apply$mcVI$sp(var91_67);
                                                                    var91_67 += var90_69;
                                                                }
                                                            }
                                                            var92_56.apply$mcVI$sp(var94_58);
                                                            var94_58 += var93_60;
                                                        }
                                                    }
                                                    var95_49.apply$mcVI$sp(var97_51);
                                                    var97_51 += var96_53;
                                                }
                                            }
                                            var98_37.apply$mcVI$sp(var100_39);
                                            var100_39 += var99_41;
                                        }
                                    }
                                    var101_30.apply$mcVI$sp(var103_32);
                                    var103_32 += var102_34;
                                }
                            }
                            var104_19.apply$mcVI$sp(var106_21);
                            var106_21 += var105_23;
                        }
                    }
                    var107_9.apply$mcVI$sp(var109_11);
                    var109_11 += var108_13;
                }
            }

            public /* synthetic */ MdTagSuite org$bdgenomics$adam$util$MdTagSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get start of read with no mismatches or deletions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("60", 1L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tag.start()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)1L), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)1L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get start of read with no mismatches, but with a deletion at the start", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("0^AC60", 5L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tag.start()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)5L), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)5L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get start of read with mismatches at the start", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("0AC60", 10L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tag.start()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)10L), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)10L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get end of read with no mismatches or deletions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("60", 1L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tag.end()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)60L), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)60L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("check that mdtag and rich record return same end", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$ predef$ = Predef$.MODULE$;
                AlignmentRecord read = AlignmentRecord.newBuilder().setSequence((CharSequence)new StringOps("A").$times(60)).setStart(Predef$.MODULE$.long2Long(1L)).setEnd(Predef$.MODULE$.long2Long(60L)).setCigar((CharSequence)"60M").setMismatchingPositions((CharSequence)"60").setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).build();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((MdTag)RichAlignmentRecord$.MODULE$.recordToRichRecord(read).mdTag().get()).end()));
                Long $org_scalatest_assert_macro_right = read.getEnd();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get end of read with no mismatches, but a deletion at end", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("60^AC0", 1L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tag.end()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)62L), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)62L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get end of read with mismatches and a deletion at end", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("60^AC0A0C0", 1L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tag.end()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)64L), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)64L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get correct string out of mdtag with no mismatches", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("60", 1L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(tag.toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"60", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"60", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get correct string out of mdtag with mismatches at start", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("0A0C10", 100L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(tag.toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"0A0C10", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"0A0C10", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get correct string out of mdtag with deletion at end", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("10^GG0", 200L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tag.start()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)200L), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)200L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tag.end()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)211L), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)211L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(tag.toString());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)"10^GG0", $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)"10^GG0", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get correct string out of mdtag with mismatches at end", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("10G0G0", 200L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tag.start()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)200L), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)200L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tag.end()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)211L), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)211L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(tag.toString());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)"10G0G0", $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)"10G0G0", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get correct string out of complex mdtag", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("0AT0^GC0", 5123L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(tag.toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"0A0T0^GC0", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"0A0T0^GC0", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("check complex mdtag", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord read = AlignmentRecord.newBuilder().setSequence((CharSequence)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA").setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)"29M10D31M").setStart(Predef$.MODULE$.long2Long(5L)).setEnd(Predef$.MODULE$.long2Long(75L)).setMismatchingPositions((CharSequence)"29^GGGGGGGGGG10G0G0G0G0G0G0G0G0G0G11").build();
                MdTag tag = (MdTag)RichAlignmentRecord$.MODULE$.recordToRichRecord(read).mdTag().get();
                Predef$ predef$ = Predef$.MODULE$;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(RichInt$.MODULE$.until$extension0(5, 34).forall((Function1)new Serializable(this, tag){
                    public static final long serialVersionUID = 0L;
                    public final MdTag tag$1;

                    public final boolean apply(int i) {
                        return this.tag$1.isMatch((long)i);
                    }

                    public boolean apply$mcZI$sp(int i) {
                        return this.tag$1.isMatch((long)i);
                    }
                    {
                        this.tag$1 = tag$1;
                    }
                }), "scala.this.Predef.intWrapper(5).until(34).forall(((i: Int) => tag.isMatch(i.toLong)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Predef$ predef$2 = Predef$.MODULE$;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(RichInt$.MODULE$.until$extension0(34, 44).forall((Function1)new Serializable(this, tag){
                    public static final long serialVersionUID = 0L;
                    private final MdTag tag$1;

                    public final boolean apply(int i) {
                        return this.apply$mcZI$sp(i);
                    }

                    public boolean apply$mcZI$sp(int i) {
                        return BoxesRunTime.unboxToChar((Object)this.tag$1.deletedBase((long)i).get()) == 'G';
                    }
                    {
                        this.tag$1 = tag$1;
                    }
                }), "scala.this.Predef.intWrapper(34).until(44).forall(((i: Int) => tag.deletedBase(i.toLong).get.==('G')))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Predef$ predef$3 = Predef$.MODULE$;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(RichInt$.MODULE$.until$extension0(44, 54).forall((Function1)new Serializable(this, tag){
                    public static final long serialVersionUID = 0L;
                    public final MdTag tag$1;

                    public final boolean apply(int i) {
                        return this.tag$1.isMatch((long)i);
                    }

                    public boolean apply$mcZI$sp(int i) {
                        return this.tag$1.isMatch((long)i);
                    }
                    {
                        this.tag$1 = tag$1;
                    }
                }), "scala.this.Predef.intWrapper(44).until(54).forall(((i: Int) => tag.isMatch(i.toLong)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Predef$ predef$4 = Predef$.MODULE$;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(RichInt$.MODULE$.until$extension0(54, 64).forall((Function1)new Serializable(this, tag){
                    public static final long serialVersionUID = 0L;
                    private final MdTag tag$1;

                    public final boolean apply(int i) {
                        return this.apply$mcZI$sp(i);
                    }

                    public boolean apply$mcZI$sp(int i) {
                        return BoxesRunTime.unboxToChar((Object)this.tag$1.mismatchedBase((long)i).get()) == 'G';
                    }
                    {
                        this.tag$1 = tag$1;
                    }
                }), "scala.this.Predef.intWrapper(54).until(64).forall(((i: Int) => tag.mismatchedBase(i.toLong).get.==('G')))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Predef$ predef$5 = Predef$.MODULE$;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(RichInt$.MODULE$.until$extension0(64, (int)Predef$.MODULE$.Long2long(read.getEnd())).forall((Function1)new Serializable(this, tag){
                    public static final long serialVersionUID = 0L;
                    public final MdTag tag$1;

                    public final boolean apply(int i) {
                        return this.tag$1.isMatch((long)i);
                    }

                    public boolean apply$mcZI$sp(int i) {
                        return this.tag$1.isMatch((long)i);
                    }
                    {
                        this.tag$1 = tag$1;
                    }
                }), "scala.this.Predef.intWrapper(64).until(scala.this.Predef.Long2long(read.getEnd()).toInt).forall(((i: Int) => tag.isMatch(i.toLong)))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(tag.getReference(RichAlignmentRecord$.MODULE$.recordToRichRecord(read)));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAGGGGGGGGGGAAAAAAAAAAGGGGGGGGGGAAAAAAAAAAA", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAGGGGGGGGGGAAAAAAAAAAGGGGGGGGGGAAAAAAAAAAA", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("move a cigar alignment by two for a read", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord read = AlignmentRecord.newBuilder().setSequence((CharSequence)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA").setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)"29M10D31M").setStart(Predef$.MODULE$.long2Long(7L)).setMismatchingPositions((CharSequence)"27G0G0^GGGGGGGGAA8G0G0G0G0G0G0G0G0G0G13").build();
                Cigar newCigar = this.$outer.CIGAR_CODEC().decode("27M10D33M");
                MdTag newTag = MdTag$.MODULE$.moveAlignment(RichAlignmentRecord$.MODULE$.recordToRichRecord(read), newCigar);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(newTag.toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"27^GGGGGGGGGG10G0G0G0G0G0G0G0G0G0G13", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"27^GGGGGGGGGG10G0G0G0G0G0G0G0G0G0G13", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rewrite alignment to all matches", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord read = AlignmentRecord.newBuilder().setSequence((CharSequence)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA").setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)"29M10D31M").setStart(Predef$.MODULE$.long2Long(7L)).setMismatchingPositions((CharSequence)"27G0G0^GGGGGGGGAA8G0G0G0G0G0G0G0G0G0G13").build();
                Cigar newCigar = this.$outer.CIGAR_CODEC().decode("60M");
                MdTag newTag = MdTag$.MODULE$.moveAlignment(RichAlignmentRecord$.MODULE$.recordToRichRecord(read), newCigar, "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", 100L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(newTag.toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"60", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"60", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)newTag.start()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)100L), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)100L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)newTag.end()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)159L), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)159L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rewrite alignment to two mismatches followed by all matches", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord read = AlignmentRecord.newBuilder().setSequence((CharSequence)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA").setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)"29M10D31M").setStart(Predef$.MODULE$.long2Long(7L)).setMismatchingPositions((CharSequence)"27G0G0^GGGGGGGGAA8G0G0G0G0G0G0G0G0G0G13").build();
                Cigar newCigar = this.$outer.CIGAR_CODEC().decode("60M");
                MdTag newTag = MdTag$.MODULE$.moveAlignment(RichAlignmentRecord$.MODULE$.recordToRichRecord(read), newCigar, "GGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", 100L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(newTag.toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"0G0G58", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"0G0G58", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)newTag.start()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)100L), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)100L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)newTag.end()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)159L), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)159L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rewrite alignment to include a deletion but otherwise all matches", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord read = AlignmentRecord.newBuilder().setSequence((CharSequence)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA").setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)"29M10D31M").setStart(Predef$.MODULE$.long2Long(7L)).setMismatchingPositions((CharSequence)"27G0G0^GGGGGGGGAA8G0G0G0G0G0G0G0G0G0G13").build();
                Cigar newCigar = this.$outer.CIGAR_CODEC().decode("10M10D50M");
                MdTag newTag = MdTag$.MODULE$.moveAlignment(RichAlignmentRecord$.MODULE$.recordToRichRecord(read), newCigar, "AAAAAAAAAAGGGGGGGGGGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", 100L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(newTag.toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"10^GGGGGGGGGG50", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"10^GGGGGGGGGG50", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)newTag.start()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)100L), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)100L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)newTag.end()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)169L), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)169L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rewrite alignment to include an insertion at the start of the read but otherwise all matches", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord read = AlignmentRecord.newBuilder().setSequence((CharSequence)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA").setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)"29M10D31M").setStart(Predef$.MODULE$.long2Long(7L)).setMismatchingPositions((CharSequence)"27G0G0^GGGGGGGGAA8G0G0G0G0G0G0G0G0G0G13").build();
                Cigar newCigar = this.$outer.CIGAR_CODEC().decode("10I50M");
                MdTag newTag = MdTag$.MODULE$.moveAlignment(RichAlignmentRecord$.MODULE$.recordToRichRecord(read), newCigar, "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", 100L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(newTag.toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"50", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"50", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)newTag.start()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)100L), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)100L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)newTag.end()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)149L), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)149L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create new md tag from read vs. reference, perfect match", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Cigar cigar = this.$outer.CIGAR_CODEC().decode("8M");
                MdTag tag = MdTag$.MODULE$.apply("ACCATAGA", "ACCATAGA", cigar, 0L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(tag.toString());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"8", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"8", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create new md tag from read vs. reference, perfect alignment match, 1 mismatch", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testTag("ACCATAGA", "ACAATAGA", "8M", 0L, "2A5", 0L, 7L);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create new md tag from read vs. reference, alignment with deletion", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testTag("ACCATAGA", "ACCATTTAGA", "5M2D3M", 5L, "5^TT3", 5L, 14L);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create new md tag from read vs. reference, alignment with insert", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testTag("ACCCATAGA", "ACCATAGA", "3M1I5M", 10L, "8", 10L, 17L);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("handle '=' and 'X' operators", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.testTag("ACCCAAGT", "ACCATAGA", "3=2X2=1X", 0L, "3A0T2A0", 0L, 7L);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

