/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.converters;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import java.util.Date;
import org.bdgenomics.adam.models.RecordGroupDictionary;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.util.AttributeUtils$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;

@ScalaSignature(bytes="\u0006\u0001q2A!\u0001\u0002\u0001\u0017\t\u00112+Q'SK\u000e|'\u000fZ\"p]Z,'\u000f^3s\u0015\t\u0019A!\u0001\u0006d_:4XM\u001d;feNT!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u00011c\u0001\u0001\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"!D\n\n\u0005Qq!\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0002\f\u0001\t\u00039\u0012A\u0002\u001fj]&$h\bF\u0001\u0019!\tI\u0002!D\u0001\u0003\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u001d\u0019wN\u001c<feR$B!H\u00130oA\u0011adI\u0007\u0002?)\u0011\u0001%I\u0001\u0005CZ\u0014xN\u0003\u0002#\r\u00059am\u001c:nCR\u001c\u0018B\u0001\u0013 \u0005=\tE.[4o[\u0016tGOU3d_J$\u0007\"\u0002\u0014\u001b\u0001\u00049\u0013!C:b[J+7m\u001c:e!\tAS&D\u0001*\u0015\tQ3&\u0001\u0005tC6$xn\u001c7t\u0015\u0005a\u0013A\u00025ug*$7.\u0003\u0002/S\tI1+Q'SK\u000e|'\u000f\u001a\u0005\u0006ai\u0001\r!M\u0001\u0005I&\u001cG\u000f\u0005\u00023k5\t1G\u0003\u00025\t\u00051Qn\u001c3fYNL!AN\u001a\u0003%M+\u0017/^3oG\u0016$\u0015n\u0019;j_:\f'/\u001f\u0005\u0006qi\u0001\r!O\u0001\u000be\u0016\fGm\u0012:pkB\u001c\bC\u0001\u001a;\u0013\tY4GA\u000bSK\u000e|'\u000fZ$s_V\u0004H)[2uS>t\u0017M]=")
public class SAMRecordConverter
implements Serializable {
    public AlignmentRecord convert(SAMRecord samRecord, SequenceDictionary dict, RecordGroupDictionary readGroups) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        Object object;
        Object object2;
        BoxedUnit boxedUnit3;
        int n;
        String cigar;
        String string = cigar = samRecord.getCigarString();
        String string2 = "*";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            n = 0;
        } else {
            int count2 = new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(cigar)).takeWhile((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char x$1) {
                    return RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(x$1));
                }
            }))).toInt();
            char operator = BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(cigar)).dropWhile((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(char x$2) {
                    return RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(x$2));
                }
            }))).head());
            n = operator == 'H' ? count2 : 0;
        }
        int startTrim = n;
        int endTrim = cigar.endsWith("H") ? new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(cigar)).dropRight(1))).reverse())).takeWhile((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$3) {
                return RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(x$3));
            }
        }))).reverse())).toInt() : 0;
        AlignmentRecord.Builder builder = AlignmentRecord.newBuilder().setReadName((CharSequence)samRecord.getReadName()).setSequence((CharSequence)samRecord.getReadString()).setCigar((CharSequence)cigar).setBasesTrimmedFromStart(Predef$.MODULE$.int2Integer(startTrim)).setBasesTrimmedFromEnd(Predef$.MODULE$.int2Integer(endTrim)).setQual((CharSequence)samRecord.getBaseQualityString());
        int readReference = Predef$.MODULE$.Integer2int(samRecord.getReferenceIndex());
        if (readReference != -1) {
            builder.setContig(SequenceRecord$.MODULE$.toADAMContig((SequenceRecord)dict.apply(samRecord.getReferenceName()).get()));
            int start = samRecord.getAlignmentStart();
            Predef$.MODULE$.assert(start != 0, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Start cannot equal 0 if contig is set.";
                }
            });
            builder.setStart(Predef$.MODULE$.long2Long((long)(start - 1)));
            int end2 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(samRecord.getCigar().getCigarElements()).asScala()).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(CigarElement p) {
                    return p.getOperator().consumesReferenceBases();
                }
            })).foldLeft((Object)BoxesRunTime.boxToInteger((int)(start - 1)), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(int pos, CigarElement cigarEl) {
                    return pos + cigarEl.getLength();
                }
            }));
            builder.setEnd(Predef$.MODULE$.long2Long((long)end2));
            int mapq = samRecord.getMappingQuality();
            Object object3 = mapq != 255 ? builder.setMapq(Predef$.MODULE$.int2Integer(mapq)) : BoxedUnit.UNIT;
            if (samRecord.getReadUnmappedFlag()) {
                boxedUnit3 = builder.setReadMapped(Predef$.MODULE$.boolean2Boolean(false));
            } else {
                builder.setReadMapped(Predef$.MODULE$.boolean2Boolean(true));
                Object object4 = samRecord.getReadNegativeStrandFlag() ? builder.setReadNegativeStrand(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT;
                if (samRecord.getNotPrimaryAlignmentFlag()) {
                    builder.setSupplementaryAlignment(Predef$.MODULE$.boolean2Boolean(samRecord.getSupplementaryAlignmentFlag()));
                    boxedUnit3 = builder.setSecondaryAlignment(Predef$.MODULE$.boolean2Boolean(!samRecord.getSupplementaryAlignmentFlag()));
                } else {
                    boxedUnit3 = builder.setPrimaryAlignment(Predef$.MODULE$.boolean2Boolean(true));
                }
            }
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        int mateReference = Predef$.MODULE$.Integer2int(samRecord.getMateReferenceIndex());
        if (mateReference != -1) {
            builder.setMateContig(SequenceRecord$.MODULE$.toADAMContig((SequenceRecord)dict.apply(samRecord.getMateReferenceName()).get()));
            int mateStart = samRecord.getMateAlignmentStart();
            object2 = mateStart > 0 ? builder.setMateAlignmentStart(Predef$.MODULE$.long2Long((long)(mateStart - 1))) : BoxedUnit.UNIT;
        } else {
            object2 = BoxedUnit.UNIT;
        }
        if (samRecord.getFlags() != 0) {
            Object object5;
            if (samRecord.getReadPairedFlag()) {
                builder.setReadPaired(Predef$.MODULE$.boolean2Boolean(true));
                Object object6 = samRecord.getMateNegativeStrandFlag() ? builder.setMateNegativeStrand(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT;
                Object object7 = samRecord.getMateUnmappedFlag() ? BoxedUnit.UNIT : builder.setMateMapped(Predef$.MODULE$.boolean2Boolean(true));
                Object object8 = samRecord.getProperPairFlag() ? builder.setProperPair(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT;
                Object object9 = samRecord.getFirstOfPairFlag() ? builder.setFirstOfPair(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT;
                object5 = samRecord.getSecondOfPairFlag() ? builder.setSecondOfPair(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT;
            } else {
                object5 = BoxedUnit.UNIT;
            }
            Object object10 = samRecord.getDuplicateReadFlag() ? builder.setDuplicateRead(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT;
            object = samRecord.getReadFailsVendorQualityCheckFlag() ? builder.setFailedVendorQualityChecks(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT;
        } else {
            object = BoxedUnit.UNIT;
        }
        if (samRecord.getAttributes() == null) {
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            ObjectRef tags = new ObjectRef((Object)Nil$.MODULE$);
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(samRecord.getAttributes()).asScala()).foreach((Function1)new Serializable(this, builder, tags){
                public static final long serialVersionUID = 0L;
                private final AlignmentRecord.Builder builder$1;
                private final ObjectRef tags$1;

                public final Object apply(SAMRecord.SAMTagAndValue attr) {
                    AlignmentRecord.Builder builder;
                    String string = attr.tag;
                    String string2 = "MD";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        builder = this.builder$1.setMismatchingPositions((CharSequence)attr.value.toString());
                    } else {
                        String string3 = attr.tag;
                        String string4 = "OQ";
                        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                            builder = this.builder$1.setOrigQual((CharSequence)attr.value.toString());
                        } else {
                            this.tags$1.elem = ((List)this.tags$1.elem).$colon$colon((Object)AttributeUtils$.MODULE$.convertSAMTagAndValue(attr));
                            builder = BoxedUnit.UNIT;
                        }
                    }
                    return builder;
                }
                {
                    this.builder$1 = builder$1;
                    this.tags$1 = tags$1;
                }
            });
            boxedUnit2 = builder.setAttributes((CharSequence)((List)tags.elem).mkString("\t"));
        }
        SAMReadGroupRecord recordGroup = samRecord.getReadGroup();
        if (recordGroup == null) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            Option$.MODULE$.apply((Object)recordGroup.getRunDate()).foreach((Function1)new Serializable(this, builder){
                public static final long serialVersionUID = 0L;
                private final AlignmentRecord.Builder builder$1;

                public final AlignmentRecord.Builder apply(Date date) {
                    return this.builder$1.setRecordGroupRunDateEpoch(Predef$.MODULE$.long2Long(date.getTime()));
                }
                {
                    this.builder$1 = builder$1;
                }
            });
            boxedUnit = builder.setRecordGroupName((CharSequence)recordGroup.getReadGroupId()).setRecordGroupSequencingCenter((CharSequence)recordGroup.getSequencingCenter()).setRecordGroupDescription((CharSequence)recordGroup.getDescription()).setRecordGroupFlowOrder((CharSequence)recordGroup.getFlowOrder()).setRecordGroupKeySequence((CharSequence)recordGroup.getKeySequence()).setRecordGroupLibrary((CharSequence)recordGroup.getLibrary()).setRecordGroupPredictedMedianInsertSize(recordGroup.getPredictedMedianInsertSize()).setRecordGroupPlatform((CharSequence)recordGroup.getPlatform()).setRecordGroupPlatformUnit((CharSequence)recordGroup.getPlatformUnit()).setRecordGroupSample((CharSequence)recordGroup.getSample());
        }
        return builder.build();
    }
}

