/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.converters;

import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.GenotypeLikelihoods;
import htsjdk.variant.variantcontext.GenotypesContext;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayList;
import java.util.Collection;
import org.bdgenomics.adam.converters.VariantAnnotationConverter$;
import org.bdgenomics.adam.converters.VariantContextConverter$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.VariantContext$;
import org.bdgenomics.adam.rich.RichVariant$;
import org.bdgenomics.formats.avro.Contig;
import org.bdgenomics.formats.avro.DatabaseVariantAnnotation;
import org.bdgenomics.formats.avro.Genotype;
import org.bdgenomics.formats.avro.GenotypeAllele;
import org.bdgenomics.formats.avro.Variant;
import org.bdgenomics.formats.avro.VariantCallingAnnotations;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

@ScalaSignature(bytes="\u0006\u0001\t\u0005r!B\u0001\u0003\u0011\u0003Y\u0011a\u0006,be&\fg\u000e^\"p]R,\u0007\u0010^\"p]Z,'\u000f^3s\u0015\t\u0019A!\u0001\u0006d_:4XM\u001d;feNT!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!a\u0006,be&\fg\u000e^\"p]R,\u0007\u0010^\"p]Z,'\u000f^3s'\ri\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E9\u0012B\u0001\r\u0013\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015QR\u0002\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\t1\u0002C\u0004\u001e\u001b\t\u0007I\u0011\u0002\u0010\u0002\u001d9{ej\u0018*F\r~\u000bE\nT#M\u000bV\tq\u0004\u0005\u0002!O5\t\u0011E\u0003\u0002#G\u0005qa/\u0019:jC:$8m\u001c8uKb$(B\u0001\u0013&\u0003\u001d1\u0018M]5b]RT\u0011AJ\u0001\u0007QR\u001c(\u000eZ6\n\u0005!\n#AB!mY\u0016dW\r\u0003\u0004+\u001b\u0001\u0006IaH\u0001\u0010\u001d>suLU#G?\u0006cE*\u0012'FA!AA&\u0004EC\u0002\u0013%Q&\u0001\u000eta2LGO\u0012:p[6+H\u000e^5BY2,G.[2GS\u0016dG-F\u0001/!\tyc'D\u00011\u0015\t\t$'\u0001\u0004TG\",W.\u0019\u0006\u0003gQ\nA!\u0019<s_*\u0011Q\u0007C\u0001\u0007CB\f7\r[3\n\u0005]\u0002$!\u0002$jK2$\u0007\u0002C\u001d\u000e\u0011\u0003\u0005\u000b\u0015\u0002\u0018\u00027M\u0004H.\u001b;Ge>lW*\u001e7uS\u0006cG.\u001a7jG\u001aKW\r\u001c3!\u0011\u0015YT\u0002\"\u0003=\u00035\u0019wN\u001c<feR\fE\u000e\\3mKR\u0019Q\bR%\u0011\u0005y\u0012U\"A \u000b\u0005M\u0002%BA!\u0007\u0003\u001d1wN]7biNL!aQ \u0003\u001d\u001d+gn\u001c;za\u0016\fE\u000e\\3mK\")QI\u000fa\u0001\r\u0006\u0011ao\u0019\t\u0003A\u001dK!\u0001S\u0011\u0003\u001dY\u000b'/[1oi\u000e{g\u000e^3yi\")!J\u000fa\u0001?\u00051\u0011\r\u001c7fY\u0016DQaO\u0007\u0005\n1#2!T-c!\rqek\b\b\u0003\u001fRs!\u0001U*\u000e\u0003ES!A\u0015\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0012BA+\u0013\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0016-\u0003\u0007M+\u0017O\u0003\u0002V%!)!j\u0013a\u00015B\u00111\fY\u0007\u00029*\u0011QLX\u0001\u0005Y\u0006twMC\u0001`\u0003\u0011Q\u0017M^1\n\u0005\u0005d&\u0001D\"iCJ\u001cV-];f]\u000e,\u0007bB2L!\u0003\u0005\r\u0001Z\u0001\u0006SN\u0014VM\u001a\t\u0003#\u0015L!A\u001a\n\u0003\u000f\t{w\u000e\\3b]\")\u0001.\u0004C\u0005S\u0006q1m\u001c8wKJ$\u0018\t\u001c7fY\u0016\u001cHC\u00016q!\rYgnH\u0007\u0002Y*\u0011QNX\u0001\u0005kRLG.\u0003\u0002pY\nQ1i\u001c7mK\u000e$\u0018n\u001c8\t\u000bE<\u0007\u0019\u0001:\u0002\u0003Y\u0004\"AP:\n\u0005Q|$a\u0002,be&\fg\u000e\u001e\u0005\u0006Q6!IA\u001e\u000b\u0003oj\u00042a\u001b= \u0013\tIHN\u0001\u0003MSN$\b\"B>v\u0001\u0004a\u0018!A4\u0011\u0005yj\u0018B\u0001@@\u0005!9UM\\8usB,\u0007\"CA\u0001\u001bE\u0005I\u0011AA\u0002\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0001\u0016\u0005\u0003\u000f\tI\u0002E\u0003\u0012\u0003\u0013\ti!C\u0002\u0002\fI\u0011aa\u00149uS>t\u0007\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005MA!\u0001\u0004n_\u0012,Gn]\u0005\u0005\u0003/\t\tB\u0001\nTKF,XM\\2f\t&\u001cG/[8oCJL8FAA\u000e!\u0011\ti\"a\n\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015\"#\u0001\u0006b]:|G/\u0019;j_:LA!!\u000b\u0002 \t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u00055R\"%A\u0005\n\u0005=\u0012aF2p]Z,'\u000f^!mY\u0016dW\r\n3fM\u0006,H\u000e\u001e\u00133+\t\t\tDK\u0002e\u00033A\u0011\"!\u000e\u000e\u0003\u0003%I!a\u000e\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003s\u00012aWA\u001e\u0013\r\ti\u0004\u0018\u0002\u0007\u001f\nTWm\u0019;\u0007\u000b9\u0011\u0001!!\u0011\u0014\t\u0005}\u0002C\u0006\u0005\f\u0003\u000b\nyD!A!\u0002\u0013\t9!\u0001\u0003eS\u000e$\bb\u0002\u000e\u0002@\u0011\u0005\u0011\u0011\n\u000b\u0005\u0003\u0017\ni\u0005E\u0002\r\u0003\u007fA!\"!\u0012\u0002HA\u0005\t\u0019AA\u0004\u0011-\t\t&a\u0010\t\u0006\u0004%I!a\u0015\u0002\u001d\r|g\u000e^5h)>\u0014VMZ*fcV\u0011\u0011Q\u000b\t\t\u0003/\ni&a\u0019\u0002d9\u0019\u0011#!\u0017\n\u0007\u0005m##\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003?\n\tGA\u0002NCBT1!a\u0017\u0013!\u0011\t9&!\u001a\n\t\u0005\u001d\u0014\u0011\r\u0002\u0007'R\u0014\u0018N\\4\t\u0017\u0005-\u0014q\bE\u0001B\u0003&\u0011QK\u0001\u0010G>tG/[4U_J+gmU3rA!Y\u0011qNA \u0011\u000b\u0007I\u0011BA*\u00039\u0011XMZ*fcR{7i\u001c8uS\u001eD1\"a\u001d\u0002@!\u0005\t\u0015)\u0003\u0002V\u0005y!/\u001a4TKF$vnQ8oi&<\u0007\u0005\u0003\u0005\u0002x\u0005}B\u0011AA=\u0003\u001d\u0019wN\u001c<feR$B!a\u001f\u0002\u0002B!aJVA?!\u0011\ty!a \n\u0007!\u000b\t\u0002\u0003\u0004F\u0003k\u0002\rA\u0012\u0005\t\u0003\u000b\u000by\u0004\"\u0001\u0002\b\u0006\u00192m\u001c8wKJ$Hk\\!o]>$\u0018\r^5p]R!\u0011\u0011RAH!\rq\u00141R\u0005\u0004\u0003\u001b{$!\u0007#bi\u0006\u0014\u0017m]3WCJL\u0017M\u001c;B]:|G/\u0019;j_:Da!RAB\u0001\u00041\u0005\u0002CAJ\u0003\u007f!I!!&\u0002\u0019\r\u0014X-\u0019;f\u0007>tG/[4\u0015\t\u0005]\u0015Q\u0014\t\u0004}\u0005e\u0015bAAN\u007f\t11i\u001c8uS\u001eDa!RAI\u0001\u00041\u0005\u0002CAQ\u0003\u007f!I!a)\u0002#\r\u0014X-\u0019;f\u0003\u0012\u000bUJV1sS\u0006tG\u000fF\u0003s\u0003K\u000b9\u000b\u0003\u0004F\u0003?\u0003\rA\u0012\u0005\t\u0003S\u000by\n1\u0001\u0002,\u0006\u0019\u0011\r\u001c;\u0011\u000bE\tI!a\u0019\t\u0011\u0005=\u0016q\bC\u0005\u0003c\u000b\u0001%\u001a=ue\u0006\u001cGOV1sS\u0006tG\u000fR1uC\n\f7/Z!o]>$\u0018\r^5p]R1\u0011\u0011RAZ\u0003kCa\u0001JAW\u0001\u0004\u0011\bBB#\u0002.\u0002\u0007a\t\u0003\u0005\u0002:\u0006}B\u0011BA^\u0003A)\u0007\u0010\u001e:bGR<UM\\8usB,7\u000f\u0006\u0006\u0002>\u0006}\u0016\u0011YAb\u0003\u001b\u00042A\u0014,}\u0011\u0019)\u0015q\u0017a\u0001\r\"1A%a.A\u0002ID\u0001\"!2\u00028\u0002\u0007\u0011qY\u0001\fC:tw\u000e^1uS>t7\u000fE\u0002?\u0003\u0013L1!a3@\u0005e1\u0016M]5b]R\u001c\u0015\r\u001c7j]\u001e\feN\\8uCRLwN\\:\t\u0011\u0005=\u0017q\u0017a\u0001\u0003#\fQa]3u!2\u0003\u0012\"EAj\u0003/\fY.!;\n\u0007\u0005U'CA\u0005Gk:\u001cG/[8oeA\u0019\u0001%!7\n\u0005y\f\u0003\u0003BAo\u0003Gt1APAp\u0013\r\t\toP\u0001\t\u000f\u0016tw\u000e^=qK&!\u0011Q]At\u0005\u001d\u0011U/\u001b7eKJT1!!9@!\r\t\u00121^\u0005\u0004\u0003[\u0014\"\u0001B+oSRD\u0001\"!=\u0002@\u0011%\u00111_\u0001\u001dKb$(/Y2u\u001d>t'+\u001a4fe\u0016t7-Z$f]>$\u0018\u0010]3t)!\ti,!>\u0002x\u0006e\bBB#\u0002p\u0002\u0007a\t\u0003\u0004%\u0003_\u0004\rA\u001d\u0005\t\u0003\u000b\fy\u000f1\u0001\u0002H\"A\u0011Q`A \t\u0013\ty0A\rfqR\u0014\u0018m\u0019;SK\u001a,'/\u001a8dK\u001e+gn\u001c;za\u0016\u001cH\u0003CA_\u0005\u0003\u0011\u0019A!\u0002\t\r\u0015\u000bY\u00101\u0001G\u0011\u0019!\u00131 a\u0001e\"A\u0011QYA~\u0001\u0004\t9\r\u0003\u0005\u0003\n\u0005}B\u0011\u0002B\u0006\u0003y)\u0007\u0010\u001e:bGR\u0014VMZ3sK:\u001cW-T8eK2<UM\\8usB,7\u000f\u0006\u0005\u0002>\n5!q\u0002B\t\u0011\u0019)%q\u0001a\u0001\r\"1AEa\u0002A\u0002ID\u0001\"!2\u0003\b\u0001\u0007\u0011q\u0019\u0005\t\u0005+\ty\u0004\"\u0003\u0003\u0018\u0005\u0001S\r\u001f;sC\u000e$h+\u0019:jC:$8)\u00197mS:<\u0017I\u001c8pi\u0006$\u0018n\u001c8t)\u0011\t9M!\u0007\t\r\u0015\u0013\u0019\u00021\u0001G\u0011!\t9(a\u0010\u0005\u0002\tuAc\u0001$\u0003 !9QIa\u0007A\u0002\u0005u\u0004")
public class VariantContextConverter
implements Serializable {
    private final Option<SequenceDictionary> dict;
    private Map<String, String> contigToRefSeq;
    private Map<String, String> refSeqToContig;
    private volatile byte bitmap$0;

    public static Option<SequenceDictionary> $lessinit$greater$default$1() {
        return VariantContextConverter$.MODULE$.$lessinit$greater$default$1();
    }

    private Map contigToRefSeq$lzycompute() {
        VariantContextConverter variantContextConverter = this;
        synchronized (variantContextConverter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Map map;
                Option<SequenceDictionary> option = this.dict;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    SequenceDictionary d = (SequenceDictionary)some.x();
                    map = ((TraversableOnce)((TraversableLike)d.records().filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(SequenceRecord x$1) {
                            return x$1.refseq().isDefined();
                        }
                    })).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<String, String> apply(SequenceRecord r) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)r.name()), r.refseq().get());
                        }
                    }, Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                } else {
                    map = Predef$.MODULE$.Map().empty();
                }
                this.contigToRefSeq = map;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.contigToRefSeq;
        }
    }

    private Map refSeqToContig$lzycompute() {
        VariantContextConverter variantContextConverter = this;
        synchronized (variantContextConverter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Map map;
                Option<SequenceDictionary> option = this.dict;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    SequenceDictionary d = (SequenceDictionary)some.x();
                    map = ((TraversableOnce)((TraversableLike)d.records().filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(SequenceRecord x$2) {
                            return x$2.refseq().isDefined();
                        }
                    })).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<String, String> apply(SequenceRecord r) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(r.refseq().get()), (Object)r.name());
                        }
                    }, Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
                } else {
                    map = Predef$.MODULE$.Map().empty();
                }
                this.refSeqToContig = map;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.refSeqToContig;
        }
    }

    private Map<String, String> contigToRefSeq() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.contigToRefSeq$lzycompute() : this.contigToRefSeq;
    }

    private Map<String, String> refSeqToContig() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.refSeqToContig$lzycompute() : this.refSeqToContig;
    }

    public Seq<org.bdgenomics.adam.models.VariantContext> convert(VariantContext vc) {
        Option option;
        Some some;
        ObjectRef calling_annotations$lzy = new ObjectRef(null);
        VolatileByteRef bitmap$0 = new VolatileByteRef(0);
        List list = JavaConversions$.MODULE$.asScalaBuffer(vc.getAlternateAlleles()).toList();
        Some some2 = List$.MODULE$.unapplySeq((Seq)list);
        if (!some2.isEmpty() && some2.get() != null && ((LinearSeqOptimized)some2.get()).lengthCompare(1) == 0) {
            Allele allele = (Allele)((LinearSeqOptimized)some2.get()).apply(0);
            Allele allele2 = VariantContextConverter$.MODULE$.org$bdgenomics$adam$converters$VariantContextConverter$$NON_REF_ALLELE();
            Allele allele3 = allele;
            if (!(allele2 != null ? !allele2.equals(allele3) : allele3 != null)) {
                Variant variant = this.createADAMVariant(vc, (Option<String>)None$.MODULE$);
                Seq<Genotype> genotypes = this.extractReferenceGenotypes(vc, variant, this.calling_annotations$1(vc, calling_annotations$lzy, bitmap$0));
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new org.bdgenomics.adam.models.VariantContext[]{VariantContext$.MODULE$.apply(variant, (Iterable<Genotype>)genotypes, (Option<DatabaseVariantAnnotation>)None$.MODULE$)}));
            }
        }
        if (!(some = List$.MODULE$.unapplySeq((Seq)list)).isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0) {
            Allele allele = (Allele)((LinearSeqOptimized)some.get()).apply(0);
            Predef$.MODULE$.assert(allele.isNonReference(), (Function0)new Serializable(this, vc){
                public static final long serialVersionUID = 0L;
                private final VariantContext vc$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Assertion failed when converting: ").append((Object)this.vc$1.toString()).toString();
                }
                {
                    this.vc$1 = vc$1;
                }
            });
            Variant variant = this.createADAMVariant(vc, (Option<String>)new Some((Object)allele.getDisplayString()));
            Seq<Genotype> genotypes = this.extractReferenceModelGenotypes(vc, variant, this.calling_annotations$1(vc, calling_annotations$lzy, bitmap$0));
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new org.bdgenomics.adam.models.VariantContext[]{VariantContext$.MODULE$.apply(variant, (Iterable<Genotype>)genotypes, (Option<DatabaseVariantAnnotation>)None$.MODULE$)}));
        }
        Some some3 = List$.MODULE$.unapplySeq((Seq)list);
        if (!some3.isEmpty() && some3.get() != null && ((LinearSeqOptimized)some3.get()).lengthCompare(2) == 0) {
            Allele allele = (Allele)((LinearSeqOptimized)some3.get()).apply(0);
            Allele allele4 = (Allele)((LinearSeqOptimized)some3.get()).apply(1);
            Allele allele5 = VariantContextConverter$.MODULE$.org$bdgenomics$adam$converters$VariantContextConverter$$NON_REF_ALLELE();
            Allele allele6 = allele4;
            if (!(allele5 != null ? !allele5.equals(allele6) : allele6 != null)) {
                Predef$.MODULE$.assert(allele.isNonReference(), (Function0)new Serializable(this, vc){
                    public static final long serialVersionUID = 0L;
                    private final VariantContext vc$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Assertion failed when converting: ").append((Object)this.vc$1.toString()).toString();
                    }
                    {
                        this.vc$1 = vc$1;
                    }
                });
                Variant variant = this.createADAMVariant(vc, (Option<String>)new Some((Object)allele.getDisplayString()));
                Seq<Genotype> genotypes = this.extractReferenceModelGenotypes(vc, variant, this.calling_annotations$1(vc, calling_annotations$lzy, bitmap$0));
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new org.bdgenomics.adam.models.VariantContext[]{VariantContext$.MODULE$.apply(variant, (Iterable<Genotype>)genotypes, (Option<DatabaseVariantAnnotation>)None$.MODULE$)}));
            }
        }
        if (!(option = package$.MODULE$.$colon$plus().unapply((SeqLike)list)).isEmpty()) {
            Allele allele = (Allele)((Tuple2)option.get())._2();
            Allele allele7 = VariantContextConverter$.MODULE$.org$bdgenomics$adam$converters$VariantContextConverter$$NON_REF_ALLELE();
            Allele allele8 = allele;
            if (!(allele7 != null ? !allele7.equals(allele8) : allele8 != null)) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"Multi-allelic site with non-ref symbolic allele").append((Object)vc.toString()).toString());
            }
        }
        VariantContextBuilder vcb = new VariantContextBuilder(vc);
        return (Seq)JavaConversions$.MODULE$.asScalaBuffer(vc.getAlternateAlleles()).flatMap((Function1)new Serializable(this, vc, vcb){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ VariantContextConverter $outer;
            public final VariantContext vc$1;
            private final VariantContextBuilder vcb$1;

            public final Seq<org.bdgenomics.adam.models.VariantContext> apply(Allele allele) {
                int idx = this.vc$1.getAlleleIndex(allele);
                Predef$.MODULE$.assert(idx >= 1, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$convert$3 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unexpected index for alternate allele: ").append((Object)this.$outer.vc$1.toString()).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.vcb$1.alleles((Collection)JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Allele[]{this.vc$1.getReference(), allele, VariantContextConverter$.MODULE$.org$bdgenomics$adam$converters$VariantContextConverter$$NON_REF_ALLELE()}))));
                GenotypesContext gc = GenotypesContext.create();
                gc.addAll((Collection)JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer((java.util.List)this.vc$1.getGenotypes()).map((Function1)new Serializable(this, idx){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$convert$3 $outer;
                    private final int idx$1;

                    public final htsjdk.variant.variantcontext.Genotype apply(htsjdk.variant.variantcontext.Genotype x$5) {
                        return this.$outer.org$bdgenomics$adam$converters$VariantContextConverter$$anonfun$$punchOutGenotype$1(x$5, this.idx$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.idx$1 = idx$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom())));
                this.vcb$1.genotypesNoValidation(gc);
                Seq<org.bdgenomics.adam.models.VariantContext> adamVCs = this.$outer.convert(this.vcb$1.make());
                ((IterableLike)adamVCs.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Genotype> apply(org.bdgenomics.adam.models.VariantContext x$6) {
                        return x$6.genotypes();
                    }
                }, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Genotype g) {
                        g.put(VariantContextConverter$.MODULE$.org$bdgenomics$adam$converters$VariantContextConverter$$splitFromMultiAllelicField().pos(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                    }
                });
                return adamVCs;
            }

            public final htsjdk.variant.variantcontext.Genotype org$bdgenomics$adam$converters$VariantContextConverter$$anonfun$$punchOutGenotype$1(htsjdk.variant.variantcontext.Genotype g, int idx) {
                BoxedUnit boxedUnit;
                BoxedUnit boxedUnit2;
                GenotypeBuilder gb = new GenotypeBuilder(g);
                gb.phased(true);
                if (g.hasAD()) {
                    int[] ad = g.getAD();
                    boxedUnit2 = gb.AD(new int[]{ad[0], ad[idx]});
                } else {
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                if (g.hasPL()) {
                    int[] oldPLs = g.getPL();
                    int[] newPLs = (int[])Predef$.MODULE$.intArrayOps(GenotypeLikelihoods.getPLIndecesOfAlleles((int)0, (int)idx)).map((Function1)new Serializable(this, oldPLs){
                        public static final long serialVersionUID = 0L;
                        private final int[] oldPLs$1;

                        public final int apply(int x$3) {
                            return this.apply$mcII$sp(x$3);
                        }

                        public int apply$mcII$sp(int x$3) {
                            return this.oldPLs$1[x$3];
                        }
                        {
                            this.oldPLs$1 = oldPLs$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                    boxedUnit = gb.PL((int[])Predef$.MODULE$.intArrayOps(newPLs).map((Function1)new Serializable(this, newPLs){
                        public static final long serialVersionUID = 0L;
                        private final int[] newPLs$1;

                        public final int apply(int x$4) {
                            return this.apply$mcII$sp(x$4);
                        }

                        public int apply$mcII$sp(int x$4) {
                            return x$4 - BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(this.newPLs$1).min((Ordering)Ordering.Int$.MODULE$));
                        }
                        {
                            this.newPLs$1 = newPLs$1;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return gb.make();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.vc$1 = vc$1;
                this.vcb$1 = vcb$1;
            }
        }, Buffer$.MODULE$.canBuildFrom());
    }

    public DatabaseVariantAnnotation convertToAnnotation(VariantContext vc) {
        Predef$.MODULE$.assert(false, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "TODO";
            }
        });
        return new DatabaseVariantAnnotation();
    }

    private Contig createContig(VariantContext vc) {
        String contigName = (String)this.contigToRefSeq().getOrElse((Object)vc.getChr(), (Function0)new Serializable(this, vc){
            public static final long serialVersionUID = 0L;
            private final VariantContext vc$2;

            public final String apply() {
                return this.vc$2.getChr();
            }
            {
                this.vc$2 = vc$2;
            }
        });
        return Contig.newBuilder().setContigName((CharSequence)contigName).build();
    }

    private Variant createADAMVariant(VariantContext vc, Option<String> alt) {
        Variant.Builder builder = Variant.newBuilder().setContig(this.createContig(vc)).setStart(Predef$.MODULE$.long2Long((long)(vc.getStart() - 1))).setEnd(Predef$.MODULE$.long2Long((long)vc.getEnd())).setReferenceAllele((CharSequence)vc.getReference().getBaseString());
        alt.foreach((Function1)new Serializable(this, builder){
            public static final long serialVersionUID = 0L;
            private final Variant.Builder builder$1;

            public final Variant.Builder apply(String x$7) {
                return this.builder$1.setAlternateAllele((CharSequence)x$7);
            }
            {
                this.builder$1 = builder$1;
            }
        });
        return builder.build();
    }

    private DatabaseVariantAnnotation extractVariantDatabaseAnnotation(Variant variant, VariantContext vc) {
        DatabaseVariantAnnotation annotation = DatabaseVariantAnnotation.newBuilder().setVariant(variant).build();
        return VariantAnnotationConverter$.MODULE$.convert(vc, annotation);
    }

    private Seq<Genotype> extractGenotypes(VariantContext vc, Variant variant, VariantCallingAnnotations annotations, Function2<htsjdk.variant.variantcontext.Genotype, Genotype.Builder, BoxedUnit> setPL) {
        Seq genotypes = ((SeqLike)JavaConversions$.MODULE$.asScalaBuffer((java.util.List)vc.getGenotypes()).map((Function1)new Serializable(this, vc, variant, annotations, setPL){
            public static final long serialVersionUID = 0L;
            public final VariantContext vc$3;
            private final Variant variant$1;
            private final VariantCallingAnnotations annotations$1;
            private final Function2 setPL$1;

            public final Genotype apply(htsjdk.variant.variantcontext.Genotype g) {
                BoxedUnit boxedUnit;
                Genotype.Builder genotype = Genotype.newBuilder().setVariant(this.variant$1).setVariantCallingAnnotations(this.annotations$1).setSampleId((CharSequence)g.getSampleName()).setAlleles(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(g.getAlleles()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final GenotypeAllele apply(Allele x$8) {
                        return VariantContextConverter$.MODULE$.org$bdgenomics$adam$converters$VariantContextConverter$$convertAllele(this.$outer.vc$3, x$8);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, Buffer$.MODULE$.canBuildFrom()))).setIsPhased(Predef$.MODULE$.boolean2Boolean(g.isPhased()));
                Object object = g.hasGQ() ? genotype.setGenotypeQuality(Predef$.MODULE$.int2Integer(g.getGQ())) : BoxedUnit.UNIT;
                Object object2 = g.hasDP() ? genotype.setReadDepth(Predef$.MODULE$.int2Integer(g.getDP())) : BoxedUnit.UNIT;
                if (g.hasAD()) {
                    int[] ad = g.getAD();
                    boxedUnit = genotype.setReferenceReadDepth(Predef$.MODULE$.int2Integer(ad[0])).setAlternateReadDepth(Predef$.MODULE$.int2Integer(ad[1]));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.setPL$1.apply((Object)g, (Object)genotype);
                return VariantAnnotationConverter$.MODULE$.convert(g, genotype.build());
            }
            {
                this.vc$3 = vc$3;
                this.variant$1 = variant$1;
                this.annotations$1 = annotations$1;
                this.setPL$1 = setPL$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSeq();
        return genotypes;
    }

    private Seq<Genotype> extractNonReferenceGenotypes(VariantContext vc, Variant variant, VariantCallingAnnotations annotations) {
        Predef$.MODULE$.assert(vc.isBiallelic());
        return this.extractGenotypes(vc, variant, annotations, (Function2<htsjdk.variant.variantcontext.Genotype, Genotype.Builder, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(htsjdk.variant.variantcontext.Genotype g, Genotype.Builder b) {
                if (g.hasPL()) {
                    b.setGenotypeLikelihoods(JavaConversions$.MODULE$.seqAsJavaList((Seq)Predef$.MODULE$.intArrayOps(g.getPL()).toList().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Integer apply(int p) {
                            return Predef$.MODULE$.int2Integer(p);
                        }
                    }, List$.MODULE$.canBuildFrom())));
                }
            }
        });
    }

    private Seq<Genotype> extractReferenceGenotypes(VariantContext vc, Variant variant, VariantCallingAnnotations annotations) {
        Predef$.MODULE$.assert(vc.isBiallelic());
        return this.extractGenotypes(vc, variant, annotations, (Function2<htsjdk.variant.variantcontext.Genotype, Genotype.Builder, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(htsjdk.variant.variantcontext.Genotype g, Genotype.Builder b) {
                if (g.hasPL()) {
                    b.setNonReferenceLikelihoods(JavaConversions$.MODULE$.seqAsJavaList((Seq)Predef$.MODULE$.intArrayOps(g.getPL()).toList().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Integer apply(int p) {
                            return Predef$.MODULE$.int2Integer(p);
                        }
                    }, List$.MODULE$.canBuildFrom())));
                }
            }
        });
    }

    private Seq<Genotype> extractReferenceModelGenotypes(VariantContext vc, Variant variant, VariantCallingAnnotations annotations) {
        return this.extractGenotypes(vc, variant, annotations, (Function2<htsjdk.variant.variantcontext.Genotype, Genotype.Builder, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(htsjdk.variant.variantcontext.Genotype g, Genotype.Builder b) {
                if (g.hasPL()) {
                    int n;
                    Integer[] pls = (Integer[])Predef$.MODULE$.intArrayOps(g.getPL()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Integer apply(int p) {
                            return Predef$.MODULE$.int2Integer(p);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class)));
                    int n2 = g.getPloidy();
                    switch (n2) {
                        default: {
                            Predef$.MODULE$.assert(false, (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Ploidy > 2 not supported for this operation";
                                }
                            });
                            n = 0;
                            break;
                        }
                        case 2: {
                            n = 3;
                            break;
                        }
                        case 1: {
                            n = 2;
                        }
                    }
                    int splitAt = n;
                    b.setGenotypeLikelihoods(JavaConversions$.MODULE$.seqAsJavaList((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])pls).slice(0, splitAt)).toList()));
                    b.setNonReferenceLikelihoods(JavaConversions$.MODULE$.seqAsJavaList((Seq)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])pls).slice(splitAt, pls.length)).toList()));
                }
            }
        });
    }

    private VariantCallingAnnotations extractVariantCallingAnnotations(VariantContext vc) {
        VariantCallingAnnotations.Builder call = VariantCallingAnnotations.newBuilder();
        Object object = vc.hasLog10PError() ? call.setVariantCallErrorProbability(Predef$.MODULE$.float2Float((float)vc.getPhredScaledQual())) : BoxedUnit.UNIT;
        Object object2 = vc.filtersWereApplied() && vc.isFiltered() ? call.setVariantIsPassing(Predef$.MODULE$.boolean2Boolean(false)).setVariantFilters(new ArrayList(vc.getFilters())) : (vc.filtersWereApplied() ? call.setVariantIsPassing(Predef$.MODULE$.boolean2Boolean(true)) : BoxedUnit.UNIT);
        return VariantAnnotationConverter$.MODULE$.convert(vc, call.build());
    }

    public VariantContext convert(org.bdgenomics.adam.models.VariantContext vc) {
        Variant variant = RichVariant$.MODULE$.richVariantToVariant(vc.variant());
        VariantContextBuilder vcb = new VariantContextBuilder().chr((String)this.refSeqToContig().getOrElse((Object)((Object)variant.getContig().getContigName()).toString(), (Function0)new Serializable(this, variant){
            public static final long serialVersionUID = 0L;
            private final Variant variant$2;

            public final String apply() {
                return ((Object)this.variant$2.getContig().getContigName()).toString();
            }
            {
                this.variant$2 = variant$2;
            }
        })).start(Predef$.MODULE$.Long2long(variant.getStart()) + 1L).stop(Predef$.MODULE$.Long2long(variant.getStart()) + (long)variant.getReferenceAllele().length()).alleles(VariantContextConverter$.MODULE$.org$bdgenomics$adam$converters$VariantContextConverter$$convertAlleles(variant));
        vc.databases().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Option<Integer> apply(DatabaseVariantAnnotation d) {
                return Option$.MODULE$.apply((Object)d.getDbSnpId());
            }
        }).foreach((Function1)new Serializable(this, vcb){
            public static final long serialVersionUID = 0L;
            private final VariantContextBuilder vcb$2;

            public final VariantContextBuilder apply(Integer d) {
                return this.vcb$2.id(new StringBuilder().append((Object)"rs").append((Object)d).toString());
            }
            {
                this.vcb$2 = vcb$2;
            }
        });
        vcb.genotypes(JavaConversions$.MODULE$.asJavaCollection((Iterable)vc.genotypes().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final htsjdk.variant.variantcontext.Genotype apply(Genotype g) {
                VariantCallingAnnotations callAnnotations;
                GenotypeBuilder gb = new GenotypeBuilder(((Object)g.getSampleId()).toString(), VariantContextConverter$.MODULE$.org$bdgenomics$adam$converters$VariantContextConverter$$convertAlleles(g));
                Option$.MODULE$.apply((Object)g.getIsPhased()).foreach((Function1)new Serializable(this, gb){
                    public static final long serialVersionUID = 0L;
                    private final GenotypeBuilder gb$1;

                    public final GenotypeBuilder apply(Boolean x$9) {
                        return this.gb$1.phased(Predef$.MODULE$.Boolean2boolean(x$9));
                    }
                    {
                        this.gb$1 = gb$1;
                    }
                });
                Option$.MODULE$.apply((Object)g.getGenotypeQuality()).foreach((Function1)new Serializable(this, gb){
                    public static final long serialVersionUID = 0L;
                    private final GenotypeBuilder gb$1;

                    public final GenotypeBuilder apply(Integer x$10) {
                        return this.gb$1.GQ(Predef$.MODULE$.Integer2int(x$10));
                    }
                    {
                        this.gb$1 = gb$1;
                    }
                });
                Option$.MODULE$.apply((Object)g.getReadDepth()).foreach((Function1)new Serializable(this, gb){
                    public static final long serialVersionUID = 0L;
                    private final GenotypeBuilder gb$1;

                    public final GenotypeBuilder apply(Integer x$11) {
                        return this.gb$1.DP(Predef$.MODULE$.Integer2int(x$11));
                    }
                    {
                        this.gb$1 = gb$1;
                    }
                });
                Object object = g.getReferenceReadDepth() == null || g.getAlternateReadDepth() == null ? BoxedUnit.UNIT : gb.AD((int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{Predef$.MODULE$.Integer2int(g.getReferenceReadDepth()), Predef$.MODULE$.Integer2int(g.getAlternateReadDepth())}), ClassTag$.MODULE$.Int()));
                Object object2 = g.getVariantCallingAnnotations() == null ? BoxedUnit.UNIT : ((callAnnotations = g.getVariantCallingAnnotations()).getVariantFilters() == null ? BoxedUnit.UNIT : gb.filters(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(callAnnotations.getVariantFilters()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(CharSequence x$12) {
                        return ((Object)x$12).toString();
                    }
                }, Buffer$.MODULE$.canBuildFrom()))));
                Object object3 = g.getGenotypeLikelihoods() == null || g.getGenotypeLikelihoods().isEmpty() ? BoxedUnit.UNIT : gb.PL((int[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(g.getGenotypeLikelihoods()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Integer p) {
                        return Predef$.MODULE$.Integer2int(p);
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int()));
                return gb.make();
            }
        }, Iterable$.MODULE$.canBuildFrom())));
        return vcb.make();
    }

    private final VariantCallingAnnotations calling_annotations$lzycompute$1(VariantContext vc$1, ObjectRef calling_annotations$lzy$1, VolatileByteRef bitmap$0$1) {
        VariantContextConverter variantContextConverter = this;
        synchronized (variantContextConverter) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                calling_annotations$lzy$1.elem = this.extractVariantCallingAnnotations(vc$1);
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (VariantCallingAnnotations)calling_annotations$lzy$1.elem;
        }
    }

    private final VariantCallingAnnotations calling_annotations$1(VariantContext vc$1, ObjectRef calling_annotations$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.calling_annotations$lzycompute$1(vc$1, calling_annotations$lzy$1, bitmap$0$1) : (VariantCallingAnnotations)calling_annotations$lzy$1.elem;
    }

    public VariantContextConverter(Option<SequenceDictionary> dict) {
        this.dict = dict;
    }
}

