/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import htsjdk.samtools.SAMFileHeader;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.converters.SAMRecordConverter;
import org.bdgenomics.adam.models.RecordGroupDictionary;
import org.bdgenomics.adam.models.RecordGroupDictionary$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceDictionary$;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.predicates.ADAMPredicate;
import org.bdgenomics.adam.projections.AlignmentRecordField$;
import org.bdgenomics.adam.projections.FieldValue;
import org.bdgenomics.adam.projections.NucleotideContigFragmentField$;
import org.bdgenomics.adam.projections.Projection$;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMRDDFunctions;
import org.bdgenomics.adam.rich.RichAlignmentRecord;
import org.bdgenomics.adam.util.HadoopUtil$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.formats.avro.NucleotideContigFragment;
import org.seqdoop.hadoop_bam.AnySAMInputFormat;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.util.SAMHeaderReader;
import org.slf4j.Logger;
import parquet.avro.AvroParquetInputFormat;
import parquet.avro.AvroReadSupport;
import parquet.filter.UnboundRecordFilter;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.util.ContextUtil;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\rMt!B\u0001\u0003\u0011\u0003Y\u0011aC!E\u00036\u001buN\u001c;fqRT!a\u0001\u0003\u0002\u0007I$GM\u0003\u0002\u0006\r\u0005!\u0011\rZ1n\u0015\t9\u0001\"\u0001\u0006cI\u001e,gn\\7jGNT\u0011!C\u0001\u0004_J<7\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\f\u0003\u0012\u000bUjQ8oi\u0016DHoE\u0002\u000e!Y\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\t\u0018\u0013\tA\"C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u001b\u001b\u0011\u00051$\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017!)Q$\u0004C\u0002=\u0005I2\u000f]1sW\u000e{g\u000e^3yiR{\u0017\tR!N\u0007>tG/\u001a=u)\ry\"\u0011\u0007\t\u0003\u0019\u00012AA\u0004\u0002\u0001CM!\u0001\u0005\u0005\f#!\t\u0019\u0003&D\u0001%\u0015\t)c%A\u0003ta\u0006\u00148N\u0003\u0002(\u0011\u00051\u0011\r]1dQ\u0016L!!\u000b\u0013\u0003\u000f1{wmZ5oO\"A1\u0006\tBC\u0002\u0013\u0005A&\u0001\u0002tGV\tQ\u0006\u0005\u0002$]%\u0011q\u0006\n\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\tc\u0001\u0012\t\u0011)A\u0005[\u0005\u00191o\u0019\u0011\t\u000bi\u0001C\u0011A\u001a\u0015\u0005}!\u0004\"B\u00163\u0001\u0004i\u0003B\u0002\u001c!\t\u0003\u0011q'A\u000bbI\u0006l')Y7ES\u000e$\u0018n\u001c8befdu.\u00193\u0015\u0005ar\u0004CA\u001d=\u001b\u0005Q$BA\u001e\u0005\u0003\u0019iw\u000eZ3mg&\u0011QH\u000f\u0002\u0013'\u0016\fX/\u001a8dK\u0012K7\r^5p]\u0006\u0014\u0018\u0010C\u0003@k\u0001\u0007\u0001)\u0001\u0005gS2,\u0007+\u0019;i!\t\tEI\u0004\u0002\u0012\u0005&\u00111IE\u0001\u0007!J,G-\u001a4\n\u0005\u00153%AB*ue&twM\u0003\u0002D%!1a\u0007\tC\u0001\u0005!#\"\u0001O%\t\u000b);\u0005\u0019A&\u0002\u0013M\fW\u000eS3bI\u0016\u0014\bC\u0001'R\u001b\u0005i%B\u0001(P\u0003!\u0019\u0018-\u001c;p_2\u001c(\"\u0001)\u0002\r!$8O\u001b3l\u0013\t\u0011VJA\u0007T\u000363\u0015\u000e\\3IK\u0006$WM\u001d\u0005\u0007)\u0002\"\tAA+\u0002+\u0005$\u0017-\u001c\"b[2{\u0017\r\u001a*fC\u0012<%o\\;qgR\u0011a+\u0017\t\u0003s]K!\u0001\u0017\u001e\u0003+I+7m\u001c:e\u000fJ|W\u000f\u001d#jGRLwN\\1ss\")!j\u0015a\u0001\u0017\"11\f\tC\t\u0005q\u000b1\"\u00193b[\n\u000bW\u000eT8bIR\u0011QL\u001b\t\u0004=\u0002\u0014W\"A0\u000b\u0005\r!\u0013BA1`\u0005\r\u0011F\t\u0012\t\u0003G\"l\u0011\u0001\u001a\u0006\u0003K\u001a\fA!\u0019<s_*\u0011qMB\u0001\bM>\u0014X.\u0019;t\u0013\tIGMA\bBY&<g.\\3oiJ+7m\u001c:e\u0011\u0015y$\f1\u0001A\u0011\u0019a\u0007\u0005\"\u0001\u0003[\u0006y\u0011\rZ1n!\u0006\u0014\u0018/^3u\u0019>\fG-\u0006\u0003og\u0006=BcB8\u0002\u001c\u0005u\u0011Q\t\u000b\u0005ar\f\t\u0002E\u0002_AF\u0004\"A]:\r\u0001\u0011)Ao\u001bb\u0001k\n\tA+\u0005\u0002wsB\u0011\u0011c^\u0005\u0003qJ\u0011qAT8uQ&tw\r\u0005\u0002\u0012u&\u00111P\u0005\u0002\u0004\u0003:L\bbB?l\u0003\u0003\u0005\u001dA`\u0001\u000bKZLG-\u001a8dK\u0012\u001a\u0004#B\t\u0000c\u0006\r\u0011bAA\u0001%\tIa)\u001e8di&|g.\r\t\u0005\u0003\u000b\ti!\u0004\u0002\u0002\b)!\u0011\u0011BA\u0006\u0003!\u0019\b/Z2jM&\u001c'BA3'\u0013\u0011\ty!a\u0002\u0003\u001dM\u0003XmY5gS\u000e\u0014VmY8sI\"I\u00111C6\u0002\u0002\u0003\u000f\u0011QC\u0001\u000bKZLG-\u001a8dK\u0012\"\u0004\u0003B!\u0002\u0018EL1!!\u0007G\u0005!i\u0015M\\5gKN$\b\"B l\u0001\u0004\u0001\u0005\"CA\u0010WB\u0005\t\u0019AA\u0011\u0003%\u0001(/\u001a3jG\u0006$X\rE\u0003\u0012\u0003G\t9#C\u0002\u0002&I\u0011aa\u00149uS>t\u0007#B!\u0002*\u00055\u0012bAA\u0016\r\n)1\t\\1tgB\u0019!/a\f\u0005\u000f\u0005E2N1\u0001\u00024\t\tQ+E\u0002w\u0003k\u0001B!a\u000e\u0002B5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$\u0001\u0004gS2$XM\u001d\u0006\u0003\u0003\u007f\tq\u0001]1scV,G/\u0003\u0003\u0002D\u0005e\"aE+oE>,h\u000e\u001a*fG>\u0014HMR5mi\u0016\u0014\b\"CA$WB\u0005\t\u0019AA%\u0003)\u0001(o\u001c6fGRLwN\u001c\t\u0006#\u0005\r\u00121\n\t\u0005\u0003\u001b\ny%\u0004\u0002\u0002\f%!\u0011\u0011KA\u0006\u0005\u0019\u00196\r[3nC\"9\u0011Q\u000b\u0011\u0005\u0002\u0005]\u0013AE1eC6$\u0015n\u0019;j_:\f'/\u001f'pC\u0012,B!!\u0017\u0002fQ!\u00111LA7)\u0015A\u0014QLA4\u0011)\ty&a\u0015\u0002\u0002\u0003\u000f\u0011\u0011M\u0001\u000bKZLG-\u001a8dK\u0012*\u0004CB\t\u0000\u0003G\n\u0019\u0001E\u0002s\u0003K\"a\u0001^A*\u0005\u0004)\bBCA5\u0003'\n\t\u0011q\u0001\u0002l\u0005QQM^5eK:\u001cW\r\n\u001c\u0011\u000b\u0005\u000b9\"a\u0019\t\r}\n\u0019\u00061\u0001A\u0011\u001d\t\t\b\tC\u0001\u0003g\n\u0001\"\u00193b[2{\u0017\rZ\u000b\u0007\u0003k\ni(!&\u0015\u0011\u0005]\u00141RAG\u0003K#b!!\u001f\u0002\u0000\u0005\u0015\u0005\u0003\u00020a\u0003w\u00022A]A?\t\u0019!\u0018q\u000eb\u0001k\"Q\u0011\u0011QA8\u0003\u0003\u0005\u001d!a!\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$s\u0007\u0005\u0004\u0012\u007f\u0006m\u00141\u0001\u0005\u000b\u0003\u000f\u000by'!AA\u0004\u0005%\u0015AC3wS\u0012,gnY3%qA)\u0011)a\u0006\u0002|!1q(a\u001cA\u0002\u0001C!\"a\b\u0002pA\u0005\t\u0019AAH!\u0015\t\u00121EAI!\u0015\t\u0015\u0011FAJ!\r\u0011\u0018Q\u0013\u0003\t\u0003c\tyG1\u0001\u0002\u0018F\u0019a/!'\u0011\r\u0005m\u0015\u0011UA>\u001b\t\tiJC\u0002\u0002 \u0012\t!\u0002\u001d:fI&\u001c\u0017\r^3t\u0013\u0011\t\u0019+!(\u0003\u001b\u0005#\u0015)\u0014)sK\u0012L7-\u0019;f\u0011)\t9%a\u001c\u0011\u0002\u0003\u0007\u0011\u0011\n\u0005\b\u0003S\u0003C\u0011AAV\u0003%1\u0017N\u001c3GS2,7\u000f\u0006\u0004\u0002.\u0006U\u0017\u0011\u001c\t\u0007\u0003_\u000by,!2\u000f\t\u0005E\u00161\u0018\b\u0005\u0003g\u000bI,\u0004\u0002\u00026*\u0019\u0011q\u0017\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0012bAA_%\u00059\u0001/Y2lC\u001e,\u0017\u0002BAa\u0003\u0007\u00141aU3r\u0015\r\tiL\u0005\t\u0005\u0003\u000f\f\t.\u0004\u0002\u0002J*!\u00111ZAg\u0003\t17OC\u0002\u0002P\u001a\na\u0001[1e_>\u0004\u0018\u0002BAj\u0003\u0013\u0014A\u0001U1uQ\"A\u0011q[AT\u0001\u0004\t)-\u0001\u0003qCRD\u0007bBAn\u0003O\u0003\r\u0001Q\u0001\u0006e\u0016<W\r\u001f\u0005\n\u0003?\u0004\u0013\u0013!C\u0001\u0003C\f\u0011$\u00193b[B\u000b'/];fi2{\u0017\r\u001a\u0013eK\u001a\fW\u000f\u001c;%eU1\u00111]A\u0000\u0005\u0003)\"!!:+\t\u0005\u001d\u0018Q\u001e\b\u0004#\u0005%\u0018bAAv%\u0005!aj\u001c8fW\t\ty\u000f\u0005\u0003\u0002r\u0006mXBAAz\u0015\u0011\t)0a>\u0002\u0013Ut7\r[3dW\u0016$'bAA}%\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00181\u001f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GA\u0002;\u0002^\n\u0007Q\u000f\u0002\u0005\u00022\u0005u'\u0019AA\u001a\u0011%\u0011)\u0001II\u0001\n\u0003\u00119!A\rbI\u0006l\u0007+\u0019:rk\u0016$Hj\\1eI\u0011,g-Y;mi\u0012\u001aTC\u0002B\u0005\u0005\u001b\u0011y!\u0006\u0002\u0003\f)\"\u0011\u0011JAw\t\u0019!(1\u0001b\u0001k\u0012A\u0011\u0011\u0007B\u0002\u0005\u0004\t\u0019\u0004C\u0005\u0003\u0014\u0001\n\n\u0011\"\u0001\u0003\u0016\u0005\u0011\u0012\rZ1n\u0019>\fG\r\n3fM\u0006,H\u000e\u001e\u00133+\u0019\t\u0019Oa\u0006\u0003\u001a\u00111AO!\u0005C\u0002U$\u0001\"!\r\u0003\u0012\t\u0007!1D\t\u0004m\nu\u0001CBAN\u0003C\u0013y\u0002E\u0002s\u0005/A\u0011Ba\t!#\u0003%\tA!\n\u0002%\u0005$\u0017-\u001c'pC\u0012$C-\u001a4bk2$HeM\u000b\u0007\u0005\u0013\u00119C!\u000b\u0005\rQ\u0014\tC1\u0001v\t!\t\tD!\tC\u0002\t-\u0012c\u0001<\u0003.A1\u00111TAQ\u0005_\u00012A\u001dB\u0014\u0011\u0015YC\u00041\u0001.\u0011\u001d\u0011)$\u0004C\u0002\u0005o\tAB\u001d3e)>\fE)Q'S\t\u0012+BA!\u000f\u0003FQ!!1\bB*)\u0019\u0011iDa\u0012\u0003NA)ABa\u0010\u0003D%\u0019!\u0011\t\u0002\u0003!\u0005#\u0015)\u0014*E\t\u001a+hn\u0019;j_:\u001c\bc\u0001:\u0003F\u00111AOa\rC\u0002UD!B!\u0013\u00034\u0005\u0005\t9\u0001B&\u0003))g/\u001b3f]\u000e,G%\r\t\u0007#}\u0014\u0019%a\u0001\t\u0015\t=#1GA\u0001\u0002\b\u0011\t&\u0001\u0006fm&$WM\\2fII\u0002R!QA\f\u0005\u0007Bqa\u0001B\u001a\u0001\u0004\u0011)\u0006\u0005\u0003_A\n\r\u0003b\u0002B-\u001b\u0011\r!1L\u0001\u0013e\u0016\u001cwN\u001d3U_JK7\r\u001b*fG>\u0014H\r\u0006\u0003\u0003^\t%\u0004\u0003\u0002B0\u0005Kj!A!\u0019\u000b\u0007\t\rD!\u0001\u0003sS\u000eD\u0017\u0002\u0002B4\u0005C\u00121CU5dQ\u0006c\u0017n\u001a8nK:$(+Z2pe\u0012DqAa\u001b\u0003X\u0001\u0007!-\u0001\u0004sK\u000e|'\u000f\u001a\u0005\b\u0005_jA1\u0001B9\u00039a\u0017n\u001d;U_*\u000bg/\u0019'jgR,BAa\u001d\u0003\bR!!Q\u000fBF!\u0019\u00119H!!\u0003\u00066\u0011!\u0011\u0010\u0006\u0005\u0005w\u0012i(\u0001\u0003vi&d'B\u0001B@\u0003\u0011Q\u0017M^1\n\t\t\r%\u0011\u0010\u0002\u0005\u0019&\u001cH\u000fE\u0002s\u0005\u000f#qA!#\u0003n\t\u0007QOA\u0001B\u0011!\u0011iI!\u001cA\u0002\t=\u0015\u0001\u00027jgR\u0004b!a,\u0003\u0012\n\u0015\u0015\u0002\u0002BB\u0003\u0007DqA!&\u000e\t\u0007\u00119*\u0001\bkCZ\fG*[:u)>d\u0015n\u001d;\u0016\t\te%q\u0014\u000b\u0005\u00057\u0013\t\u000b\u0005\u0004\u00020\nE%Q\u0014\t\u0004e\n}Ea\u0002BE\u0005'\u0013\r!\u001e\u0005\t\u0005\u001b\u0013\u0019\n1\u0001\u0003$B1!q\u000fBA\u0005;CqAa*\u000e\t\u0007\u0011I+\u0001\u0007kCZ\f7+\u001a;U_N+G/\u0006\u0003\u0003,\nUF\u0003\u0002BW\u0005o\u0003R!\u0011BX\u0005gK1A!-G\u0005\r\u0019V\r\u001e\t\u0004e\nUFa\u0002BE\u0005K\u0013\r!\u001e\u0005\t\u0005s\u0013)\u000b1\u0001\u0003<\u0006\u00191/\u001a;\u0011\r\t]$Q\u0018BZ\u0013\u0011\u0011\tL!\u001f\t\u000f\t\u0005W\u0002b\u0001\u0003D\u0006A\u0012N\u001c;MSN$Hk\u001c&bm\u0006Le\u000e^3hKJd\u0015n\u001d;\u0015\t\t\u0015'1\u001b\t\u0007\u0005o\u0012\tIa2\u0011\t\t%'qZ\u0007\u0003\u0005\u0017TAA!4\u0003~\u0005!A.\u00198h\u0013\u0011\u0011\tNa3\u0003\u000f%sG/Z4fe\"A!Q\u0012B`\u0001\u0004\u0011)\u000e\u0005\u0004\u00020\nE%q\u001b\t\u0004#\te\u0017b\u0001Bn%\t\u0019\u0011J\u001c;\t\u000f\t}W\u0002b\u0001\u0003b\u0006!2\r[1s'\u0016\fX/\u001a8dKR{7\u000b\u001e:j]\u001e$2\u0001\u0011Br\u0011!\u0011)O!8A\u0002\t\u001d\u0018AA2t!\u0011\u0011IM!;\n\t\t-(1\u001a\u0002\r\u0007\"\f'oU3rk\u0016t7-\u001a\u0005\b\u0005_lA1\u0001By\u0003I\u0019\u0007.\u0019:TKF,XM\\2f)>d\u0015n\u001d;\u0015\t\tM(1 \t\u0007\u0003_\u0013\tJ!>\u0011\u0007E\u001190C\u0002\u0003zJ\u0011Aa\u00115be\"A!Q\u001dBw\u0001\u0004\u00119\u000fC\u0004\u0003\u00006!\u0019a!\u0001\u0002\u00195\f\u0007\u000fV8KCZ\fW*\u00199\u0016\r\r\r1QBB\t)\u0011\u0019)a!\u0006\u0011\u0011\t]4qAB\u0006\u0007\u001fIAa!\u0003\u0003z\t\u0019Q*\u00199\u0011\u0007I\u001ci\u0001B\u0004\u0003\n\nu(\u0019A;\u0011\u0007I\u001c\t\u0002B\u0004\u0004\u0014\tu(\u0019A;\u0003\u0003\tC\u0001ba\u0006\u0003~\u0002\u00071\u0011D\u0001\u0004[\u0006\u0004\b\u0003CB\u000e\u0007C\u0019Yaa\u0004\u000e\u0005\ru!bAB\u0010%\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\r%1Q\u0004\u0005\b\u0007KiA1AB\u0014\u00031Q\u0017M^1NCB$v.T1q+\u0019\u0019Ica\f\u00044Q!11FB\u001b!!\u0019Yb!\t\u0004.\rE\u0002c\u0001:\u00040\u00119!\u0011RB\u0012\u0005\u0004)\bc\u0001:\u00044\u0011911CB\u0012\u0005\u0004)\b\u0002CB\f\u0007G\u0001\raa\u000e\u0011\u0011\t]4qAB\u0017\u0007cAqaa\u000f\u000e\t\u0007\u0019i$\u0001\rji\u0016\u0014\u0018M\u00197f)>T\u0015M^1D_2dWm\u0019;j_:,Baa\u0010\u0004JQ!1\u0011IB&!\u0019\u00119ha\u0011\u0004H%!1Q\tB=\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0004e\u000e%Ca\u0002BE\u0007s\u0011\r!\u001e\u0005\t\u0007\u001b\u001aI\u00041\u0001\u0004P\u0005\t\u0011\u000e\u0005\u0004\u00020\u000eE3qI\u0005\u0005\u0007'\n\u0019M\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001d\u00199&\u0004C\u0002\u00073\nAb]3u)>T\u0015M^1TKR,Baa\u0017\u0004bQ!1QLB2!\u0019\u00119H!0\u0004`A\u0019!o!\u0019\u0005\u000f\t%5Q\u000bb\u0001k\"A!\u0011XB+\u0001\u0004\u0019)\u0007E\u0003B\u0005_\u001by\u0006C\u0005\u0004j5\t\t\u0011\"\u0003\u0004l\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019i\u0007\u0005\u0003\u0003J\u000e=\u0014\u0002BB9\u0005\u0017\u0014aa\u00142kK\u000e$\b")
public class ADAMContext
implements Serializable,
Logging {
    private final SparkContext sc;
    private transient Logger org$apache$spark$Logging$$log_;

    public static <A> java.util.Set<A> setToJavaSet(scala.collection.immutable.Set<A> set) {
        return ADAMContext$.MODULE$.setToJavaSet(set);
    }

    public static <A> Collection<A> iterableToJavaCollection(Iterable<A> iterable) {
        return ADAMContext$.MODULE$.iterableToJavaCollection(iterable);
    }

    public static <A, B> Map<A, B> javaMapToMap(java.util.Map<A, B> map) {
        return ADAMContext$.MODULE$.javaMapToMap(map);
    }

    public static <A, B> java.util.Map<A, B> mapToJavaMap(Map<A, B> map) {
        return ADAMContext$.MODULE$.mapToJavaMap(map);
    }

    public static List<Object> charSequenceToList(CharSequence charSequence) {
        return ADAMContext$.MODULE$.charSequenceToList(charSequence);
    }

    public static String charSequenceToString(CharSequence charSequence) {
        return ADAMContext$.MODULE$.charSequenceToString(charSequence);
    }

    public static java.util.List<Integer> intListToJavaIntegerList(List<Object> list) {
        return ADAMContext$.MODULE$.intListToJavaIntegerList(list);
    }

    public static <A> scala.collection.immutable.Set<A> javaSetToSet(java.util.Set<A> set) {
        return ADAMContext$.MODULE$.javaSetToSet(set);
    }

    public static <A> List<A> javaListToList(java.util.List<A> list) {
        return ADAMContext$.MODULE$.javaListToList(list);
    }

    public static <A> java.util.List<A> listToJavaList(List<A> list) {
        return ADAMContext$.MODULE$.listToJavaList(list);
    }

    public static RichAlignmentRecord recordToRichRecord(AlignmentRecord alignmentRecord) {
        return ADAMContext$.MODULE$.recordToRichRecord(alignmentRecord);
    }

    public static <T> ADAMRDDFunctions<T> rddToADAMRDD(RDD<T> rDD, Function1<T, SpecificRecord> function1, Manifest<T> manifest) {
        return ADAMContext$.MODULE$.rddToADAMRDD(rDD, function1, manifest);
    }

    public static ADAMContext sparkContextToADAMContext(SparkContext sparkContext) {
        return ADAMContext$.MODULE$.sparkContextToADAMContext(sparkContext);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public SparkContext sc() {
        return this.sc;
    }

    public SequenceDictionary adamBamDictionaryLoad(String filePath) {
        SAMFileHeader samHeader = SAMHeaderReader.readSAMHeaderFrom((Path)new Path(filePath), (Configuration)this.sc().hadoopConfiguration());
        return this.adamBamDictionaryLoad(samHeader);
    }

    public SequenceDictionary adamBamDictionaryLoad(SAMFileHeader samHeader) {
        return SequenceDictionary$.MODULE$.apply(samHeader);
    }

    public RecordGroupDictionary adamBamLoadReadGroups(SAMFileHeader samHeader) {
        return RecordGroupDictionary$.MODULE$.fromSAMHeader(samHeader);
    }

    public RDD<AlignmentRecord> adamBamLoad(String filePath) {
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Reading legacy BAM file format %s to create RDD")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        SAMFileHeader samHeader = SAMHeaderReader.readSAMHeaderFrom((Path)new Path(filePath), (Configuration)this.sc().hadoopConfiguration());
        SequenceDictionary seqDict = this.adamBamDictionaryLoad(samHeader);
        RecordGroupDictionary readGroups = this.adamBamLoadReadGroups(samHeader);
        Job job = HadoopUtil$.MODULE$.newJob(this.sc());
        RDD records = this.sc().newAPIHadoopFile(filePath, AnySAMInputFormat.class, LongWritable.class, SAMRecordWritable.class, ContextUtil.getConfiguration((JobContext)job));
        SAMRecordConverter samRecordConverter = new SAMRecordConverter();
        return records.map((Function1)new Serializable(this, seqDict, readGroups, samRecordConverter){
            public static final long serialVersionUID = 0L;
            private final SequenceDictionary seqDict$1;
            private final RecordGroupDictionary readGroups$1;
            private final SAMRecordConverter samRecordConverter$1;

            public final AlignmentRecord apply(Tuple2<LongWritable, SAMRecordWritable> p) {
                return this.samRecordConverter$1.convert(((SAMRecordWritable)p._2()).get(), this.seqDict$1, this.readGroups$1);
            }
            {
                this.seqDict$1 = seqDict$1;
                this.readGroups$1 = readGroups$1;
                this.samRecordConverter$1 = samRecordConverter$1;
            }
        }, ClassTag$.MODULE$.apply(AlignmentRecord.class));
    }

    public <T, U extends UnboundRecordFilter> RDD<T> adamParquetLoad(String filePath, Option<Class<U>> predicate, Option<Schema> projection, Function1<T, SpecificRecord> evidence$3, Manifest<T> evidence$4) {
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Reading the ADAM file at %s to create RDD")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        Job job = HadoopUtil$.MODULE$.newJob(this.sc());
        ParquetInputFormat.setReadSupportClass((Job)job, AvroReadSupport.class);
        if (predicate.isDefined()) {
            this.log().info("Using the specified push-down predicate");
            ParquetInputFormat.setUnboundRecordFilter((Job)job, (Class)((Class)predicate.get()));
        }
        if (projection.isDefined()) {
            this.log().info("Using the specified projection schema");
            AvroParquetInputFormat.setRequestedProjection((Job)job, (Schema)((Schema)projection.get()));
        }
        RDD records = this.sc().newAPIHadoopFile(filePath, ParquetInputFormat.class, Void.class, Predef$.MODULE$.manifest(evidence$4).runtimeClass(), ContextUtil.getConfiguration((JobContext)job)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final T apply(Tuple2<Void, T> p) {
                return (T)p._2();
            }
        }, evidence$4);
        return predicate.isDefined() ? records.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(T p) {
                return p != null;
            }
        }) : records;
    }

    public <T, U extends UnboundRecordFilter> None$ adamParquetLoad$default$2() {
        return None$.MODULE$;
    }

    public <T, U extends UnboundRecordFilter> Option<Schema> adamParquetLoad$default$3() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> SequenceDictionary adamDictionaryLoad(String filePath, Function1<T, SpecificRecord> evidence$5, Manifest<T> evidence$6) {
        SequenceDictionary sequenceDictionary;
        Schema projection;
        boolean isADAMRecord = AlignmentRecord.class.isAssignableFrom(Predef$.MODULE$.manifest(evidence$6).runtimeClass());
        boolean isADAMContig = NucleotideContigFragment.class.isAssignableFrom(Predef$.MODULE$.manifest(evidence$6).runtimeClass());
        Schema schema = isADAMRecord ? Projection$.MODULE$.apply((Seq<FieldValue>)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{AlignmentRecordField$.MODULE$.contig(), AlignmentRecordField$.MODULE$.mateContig(), AlignmentRecordField$.MODULE$.readPaired(), AlignmentRecordField$.MODULE$.firstOfPair(), AlignmentRecordField$.MODULE$.readMapped(), AlignmentRecordField$.MODULE$.mateMapped()})) : (projection = isADAMContig ? Projection$.MODULE$.apply((Seq<FieldValue>)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{NucleotideContigFragmentField$.MODULE$.contig()})) : Projection$.MODULE$.apply((Seq<FieldValue>)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{AlignmentRecordField$.MODULE$.contig()})));
        if (filePath.endsWith(".bam") || filePath.endsWith(".sam")) {
            if (!isADAMRecord) throw new IllegalArgumentException("If you're reading a BAM/SAM file, the record type must be Read");
            sequenceDictionary = this.adamBamDictionaryLoad(filePath);
            return sequenceDictionary;
        } else {
            SequenceDictionary dict;
            RDD<T> projected = this.adamParquetLoad(filePath, (Option)None$.MODULE$, (Option<Schema>)new Some((Object)projection), evidence$5, evidence$6);
            RDD recs = isADAMRecord ? projected.distinct().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Set<SequenceRecord> apply(AlignmentRecord rec) {
                    return SequenceRecord$.MODULE$.fromADAMRecord(rec);
                }
            }, ClassTag$.MODULE$.apply(SequenceRecord.class)) : (isADAMContig ? projected.distinct().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceRecord apply(NucleotideContigFragment ctg) {
                    return SequenceRecord$.MODULE$.fromADAMContigFragment(ctg);
                }
            }, ClassTag$.MODULE$.apply(SequenceRecord.class)) : projected.distinct().map((Function1)new Serializable(this, evidence$5){
                public static final long serialVersionUID = 0L;
                private final Function1 evidence$5$1;

                public final SequenceRecord apply(T x$1) {
                    return SequenceRecord$.MODULE$.fromSpecificRecord((SpecificRecord)this.evidence$5$1.apply(x$1));
                }
                {
                    this.evidence$5$1 = evidence$5$1;
                }
            }, ClassTag$.MODULE$.apply(SequenceRecord.class)));
            sequenceDictionary = dict = (SequenceDictionary)recs.aggregate((Object)SequenceDictionary$.MODULE$.apply(), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceDictionary apply(SequenceDictionary dict, SequenceRecord rec) {
                    return dict.$plus(rec);
                }
            }, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceDictionary apply(SequenceDictionary dict1, SequenceDictionary dict2) {
                    return dict1.$plus$plus(dict2);
                }
            }, ClassTag$.MODULE$.apply(SequenceDictionary.class));
        }
        return sequenceDictionary;
    }

    public <T, U extends ADAMPredicate<T>> RDD<T> adamLoad(String filePath, Option<Class<U>> predicate, Option<Schema> projection, Function1<T, SpecificRecord> evidence$7, Manifest<T> evidence$8) {
        Object object;
        if (filePath.endsWith(".bam") || filePath.endsWith(".sam") && AlignmentRecord.class.isAssignableFrom(Predef$.MODULE$.manifest(evidence$8).runtimeClass())) {
            if (projection.isDefined()) {
                this.log().warn("Projection is ignored when loading a BAM file");
            }
            RDD<AlignmentRecord> reads = this.adamBamLoad(filePath);
            if (predicate.isDefined()) {
                Class predicateClass = (Class)predicate.get();
                ADAMPredicate filter = (ADAMPredicate)predicateClass.newInstance();
                object = filter.apply(reads);
            } else {
                object = reads;
            }
        } else {
            object = this.adamParquetLoad(filePath, predicate, projection, evidence$7, evidence$8);
        }
        return object;
    }

    public <T, U extends ADAMPredicate<T>> None$ adamLoad$default$2() {
        return None$.MODULE$;
    }

    public <T, U extends ADAMPredicate<T>> Option<Schema> adamLoad$default$3() {
        return None$.MODULE$;
    }

    public Seq<Path> findFiles(Path path, String regex) {
        Tuple2 tuple2;
        block4: {
            Seq seq;
            block3: {
                Tuple2 tuple22;
                block2: {
                    if (regex != null) break block2;
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{path}));
                    break block3;
                }
                FileStatus[] statuses = FileSystem.get((Configuration)this.sc().hadoopConfiguration()).listStatus(path);
                Pattern r = Pattern.compile(regex);
                tuple2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])statuses).filter((Function1)new $anonfun$7(this))).map((Function1)new $anonfun$8(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))).partition((Function1)new $anonfun$9(this, r));
                if (tuple2 == null) break block4;
                Path[] matches = (Path[])tuple2._1();
                Path[] recurse = (Path[])tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)matches, (Object)recurse);
                Path[] matches2 = (Path[])tuple23._1();
                Path[] recurse2 = (Path[])tuple23._2();
                seq = (Seq)Predef$.MODULE$.refArrayOps((Object[])matches2).toSeq().$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])recurse2).flatMap((Function1)new Serializable(this, regex){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ADAMContext $outer;
                    private final String regex$1;

                    public final Seq<Path> apply(Path p) {
                        return this.$outer.findFiles(p, this.regex$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.regex$1 = regex$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))), Seq$.MODULE$.canBuildFrom());
            }
            return seq;
        }
        throw new MatchError((Object)tuple2);
    }

    public ADAMContext(SparkContext sc) {
        this.sc = sc;
        Logging.class.$init$((Logging)this);
    }
}

