/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.read;

import htsjdk.samtools.SAMFileHeader;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.converters.SAMRecordConverter;
import org.bdgenomics.adam.models.RecordGroupDictionary;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.read.ADAMAlignmentRecordContext$;
import org.bdgenomics.adam.rdd.read.ADAMAlignmentRecordRDDFunctions;
import org.bdgenomics.adam.util.HadoopUtil$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.seqdoop.hadoop_bam.AnySAMInputFormat;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.util.SAMHeaderReader;
import org.slf4j.Logger;
import parquet.hadoop.util.ContextUtil;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\rq!B\u0001\u0003\u0011\u0003i\u0011AG!E\u00036\u000bE.[4o[\u0016tGOU3d_J$7i\u001c8uKb$(BA\u0002\u0005\u0003\u0011\u0011X-\u00193\u000b\u0005\u00151\u0011a\u0001:eI*\u0011q\u0001C\u0001\u0005C\u0012\fWN\u0003\u0002\n\u0015\u0005Q!\rZ4f]>l\u0017nY:\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0001\"AD\b\u000e\u0003\t1Q\u0001\u0005\u0002\t\u0002E\u0011!$\u0011#B\u001b\u0006c\u0017n\u001a8nK:$(+Z2pe\u0012\u001cuN\u001c;fqR\u001c2a\u0004\n\u0019!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fMB\u00111#G\u0005\u00035Q\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQ\u0001H\b\u0005\u0002u\ta\u0001P5oSRtD#A\u0007\t\u000b}yA1\u0001\u0011\u00021\u0005$\u0017-\\\"p]R,\u0007\u0010\u001e+p\u0003\u0012\u000bUjQ8oi\u0016DH\u000f\u0006\u0002\"SB\u0011aB\t\u0004\u0005!\t\u00011e\u0005\u0003#%a!\u0003CA\u0013+\u001b\u00051#BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003W\u0019\u0012q\u0001T8hO&tw\r\u0003\u0005.E\t\u0015\r\u0011\"\u0001/\u0003\t\u00198-F\u00010!\t)\u0003'\u0003\u00022M\ta1\u000b]1sW\u000e{g\u000e^3yi\"A1G\tB\u0001B\u0003%q&A\u0002tG\u0002BQ\u0001\b\u0012\u0005\u0002U\"\"!\t\u001c\t\u000b5\"\u0004\u0019A\u0018\t\ra\u0012C\u0011\u0003\u0003:\u0003-\tG-Y7CC6du.\u00193\u0015\u0005i:\u0005cA\u001e>\u007f5\tAH\u0003\u0002\u0006M%\u0011a\b\u0010\u0002\u0004%\u0012#\u0005C\u0001!F\u001b\u0005\t%B\u0001\"D\u0003\u0011\tgO]8\u000b\u0005\u0011C\u0011a\u00024pe6\fGo]\u0005\u0003\r\u0006\u0013q\"\u00117jO:lWM\u001c;SK\u000e|'\u000f\u001a\u0005\u0006\u0011^\u0002\r!S\u0001\tM&dW\rU1uQB\u0011!*\u0014\b\u0003'-K!\u0001\u0014\u000b\u0002\rA\u0013X\rZ3g\u0013\tquJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0019RAQ!\u0015\u0012\u0005\u0002I\u000b\u0011\u0003\\8bI\u0006#\u0015)\u0014$s_6\u0004\u0016\r\u001e5t)\tQ4\u000bC\u0003U!\u0002\u0007Q+A\u0003qCRD7\u000fE\u0002W=\u0006t!a\u0016/\u000f\u0005a[V\"A-\u000b\u0005ic\u0011A\u0002\u001fs_>$h(C\u0001\u0016\u0013\tiF#A\u0004qC\u000e\\\u0017mZ3\n\u0005}\u0003'aA*fc*\u0011Q\f\u0006\t\u0003E\u001el\u0011a\u0019\u0006\u0003I\u0016\f!AZ:\u000b\u0005\u0019D\u0013A\u00025bI>|\u0007/\u0003\u0002iG\n!\u0001+\u0019;i\u0011\u0015Qg\u00041\u0001l\u0003\t\t7\r\u0005\u0002m[6\tA!\u0003\u0002o\t\tY\u0011\tR!N\u0007>tG/\u001a=u\u0011\u0015\u0001x\u0002b\u0001r\u0003I\u0011H\r\u001a+p\u0003\u0012\u000bUJU3d_J$'\u000b\u0012#\u0015\u0005I,\bC\u0001\bt\u0013\t!(AA\u0010B\t\u0006k\u0015\t\\5h]6,g\u000e\u001e*fG>\u0014HM\u0015#E\rVt7\r^5p]NDQ!B8A\u0002iBqa^\b\u0002\u0002\u0013%\u00010A\u0006sK\u0006$'+Z:pYZ,G#A=\u0011\u0005i|X\"A>\u000b\u0005ql\u0018\u0001\u00027b]\u001eT\u0011A`\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0002m\u0014aa\u00142kK\u000e$\b")
public class ADAMAlignmentRecordContext
implements Serializable,
Logging {
    private final SparkContext sc;
    private transient Logger org$apache$spark$Logging$$log_;

    public static ADAMAlignmentRecordRDDFunctions rddToADAMRecordRDD(RDD<AlignmentRecord> rDD) {
        return ADAMAlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(rDD);
    }

    public static ADAMAlignmentRecordContext adamContextToADAMContext(ADAMContext aDAMContext) {
        return ADAMAlignmentRecordContext$.MODULE$.adamContextToADAMContext(aDAMContext);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public SparkContext sc() {
        return this.sc;
    }

    public RDD<AlignmentRecord> adamBamLoad(String filePath) {
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Reading legacy BAM file format %s to create RDD")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        SAMFileHeader samHeader = SAMHeaderReader.readSAMHeaderFrom((Path)new Path(filePath), (Configuration)this.sc().hadoopConfiguration());
        SequenceDictionary seqDict = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc()).adamBamDictionaryLoad(samHeader);
        RecordGroupDictionary readGroups = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc()).adamBamLoadReadGroups(samHeader);
        Job job = HadoopUtil$.MODULE$.newJob(this.sc());
        RDD records = this.sc().newAPIHadoopFile(filePath, AnySAMInputFormat.class, LongWritable.class, SAMRecordWritable.class, ContextUtil.getConfiguration((JobContext)job));
        SAMRecordConverter samRecordConverter = new SAMRecordConverter();
        return records.map((Function1)new Serializable(this, seqDict, readGroups, samRecordConverter){
            public static final long serialVersionUID = 0L;
            private final SequenceDictionary seqDict$1;
            private final RecordGroupDictionary readGroups$1;
            private final SAMRecordConverter samRecordConverter$1;

            public final AlignmentRecord apply(Tuple2<LongWritable, SAMRecordWritable> p) {
                return this.samRecordConverter$1.convert(((SAMRecordWritable)p._2()).get(), this.seqDict$1, this.readGroups$1);
            }
            {
                this.seqDict$1 = seqDict$1;
                this.readGroups$1 = readGroups$1;
                this.samRecordConverter$1 = samRecordConverter$1;
            }
        }, ClassTag$.MODULE$.apply(AlignmentRecord.class));
    }

    public RDD<AlignmentRecord> loadADAMFromPaths(Seq<Path> paths2) {
        return this.sc().union((Seq)((TraversableLike)paths2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMAlignmentRecordContext $outer;

            public final Tuple2<SequenceDictionary, RDD<AlignmentRecord>> apply(Path path) {
                return this.$outer.org$bdgenomics$adam$rdd$read$ADAMAlignmentRecordContext$$loadADAMs$1(path);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RDD<AlignmentRecord> apply(Tuple2<SequenceDictionary, RDD<AlignmentRecord>> v) {
                return (RDD)v._2();
            }
        }, Seq$.MODULE$.canBuildFrom()), ClassTag$.MODULE$.apply(AlignmentRecord.class));
    }

    public final Tuple2 org$bdgenomics$adam$rdd$read$ADAMAlignmentRecordContext$$loadADAMs$1(Path path) {
        SequenceDictionary dict = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc()).adamDictionaryLoad(path.toString(), Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(AlignmentRecord.class));
        ADAMContext qual$1 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.sc());
        String x$1 = path.toString();
        None$ x$2 = qual$1.adamLoad$default$2();
        Option<Schema> x$3 = qual$1.adamLoad$default$3();
        RDD rdd = qual$1.adamLoad(x$1, x$2, x$3, Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(AlignmentRecord.class));
        return new Tuple2((Object)dict, rdd);
    }

    public ADAMAlignmentRecordContext(SparkContext sc) {
        this.sc = sc;
        Logging.class.$init$((Logging)this);
    }
}

