/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.read;

import htsjdk.samtools.SAMFileHeader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.spark.SparkContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGeneratorFromReads;
import org.bdgenomics.adam.converters.AlignmentRecordConverter;
import org.bdgenomics.adam.models.Attribute;
import org.bdgenomics.adam.models.RecordGroup;
import org.bdgenomics.adam.models.RecordGroup$;
import org.bdgenomics.adam.models.RecordGroupDictionary;
import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferencePosition$;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.models.Rod;
import org.bdgenomics.adam.models.SAMFileHeaderWritable;
import org.bdgenomics.adam.models.SAMFileHeaderWritable$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.models.SingleReadBucket;
import org.bdgenomics.adam.models.SingleReadBucket$;
import org.bdgenomics.adam.models.SnpTable;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMSequenceDictionaryRDDAggregator;
import org.bdgenomics.adam.rdd.read.ADAMAlignmentRecordContext$;
import org.bdgenomics.adam.rdd.read.ADAMAlignmentRecordRDDFunctions$;
import org.bdgenomics.adam.rdd.read.ADAMBAMOutputFormat;
import org.bdgenomics.adam.rdd.read.ADAMBAMOutputFormat$;
import org.bdgenomics.adam.rdd.read.ADAMSAMOutputFormat;
import org.bdgenomics.adam.rdd.read.ADAMSAMOutputFormat$;
import org.bdgenomics.adam.rdd.read.FlagStat$;
import org.bdgenomics.adam.rdd.read.FlagStatMetrics;
import org.bdgenomics.adam.rdd.read.MarkDuplicates$;
import org.bdgenomics.adam.rdd.read.Reads2PileupProcessor;
import org.bdgenomics.adam.rdd.read.correction.ErrorCorrection$;
import org.bdgenomics.adam.rdd.read.correction.TrimReads$;
import org.bdgenomics.adam.rdd.read.realignment.RealignIndels$;
import org.bdgenomics.adam.rdd.read.recalibration.BaseQualityRecalibration$;
import org.bdgenomics.adam.rich.RichAlignmentRecord$;
import org.bdgenomics.adam.util.MapTools$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.formats.avro.Pileup;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\t-c\u0001B\u0001\u0003\u00015\u0011q$\u0011#B\u001b\u0006c\u0017n\u001a8nK:$(+Z2pe\u0012\u0014F\t\u0012$v]\u000e$\u0018n\u001c8t\u0015\t\u0019A!\u0001\u0003sK\u0006$'BA\u0003\u0007\u0003\r\u0011H\r\u001a\u0006\u0003\u000f!\tA!\u00193b[*\u0011\u0011BC\u0001\u000bE\u0012<WM\\8nS\u000e\u001c(\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001cA\b\u0011%5\tA!\u0003\u0002\u0012\t\t\u0019\u0013\tR!N'\u0016\fX/\u001a8dK\u0012K7\r^5p]\u0006\u0014\u0018P\u0015#E\u0003\u001e<'/Z4bi>\u0014\bCA\n\u0019\u001b\u0005!\"BA\u000b\u0017\u0003\u0011\tgO]8\u000b\u0005]A\u0011a\u00024pe6\fGo]\u0005\u00033Q\u0011q\"\u00117jO:lWM\u001c;SK\u000e|'\u000f\u001a\u0005\t\u000b\u0001\u0011\t\u0011)A\u00057A\u0019AD\t\n\u000e\u0003uQ!!\u0002\u0010\u000b\u0005}\u0001\u0013!B:qCJ\\'BA\u0011\u000b\u0003\u0019\t\u0007/Y2iK&\u00111%\b\u0002\u0004%\u0012#\u0005\"B\u0013\u0001\t\u00031\u0013A\u0002\u001fj]&$h\b\u0006\u0002(SA\u0011\u0001\u0006A\u0007\u0002\u0005!)Q\u0001\na\u00017!)1\u0006\u0001C\u0001Y\u0005Ib-\u001b7uKJ\u0014\u0015p\u0014<fe2\f\u0007\u000f]5oOJ+w-[8o)\tYR\u0006C\u0003/U\u0001\u0007q&A\u0003rk\u0016\u0014\u0018\u0010\u0005\u00021g5\t\u0011G\u0003\u00023\r\u00051Qn\u001c3fYNL!\u0001N\u0019\u0003\u001fI+g-\u001a:f]\u000e,'+Z4j_:DQA\u000e\u0001\u0005\u0002]\n1\"\u00193b[N\u000bUjU1wKR\u0019\u0001HP$\u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u007fU\u0002\r\u0001Q\u0001\tM&dW\rU1uQB\u0011\u0011\t\u0012\b\u0003s\tK!a\u0011\u001e\u0002\rA\u0013X\rZ3g\u0013\t)eI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0007jBq\u0001S\u001b\u0011\u0002\u0003\u0007\u0011*A\u0003bgN\u000bW\u000e\u0005\u0002:\u0015&\u00111J\u000f\u0002\b\u0005>|G.Z1o\u0011\u0015i\u0005\u0001\"\u0001O\u0003u9W\r^*fcV,gnY3SK\u000e|'\u000fZ:Ge>lW\t\\3nK:$HCA(Y!\r\u00016+V\u0007\u0002#*\u0011!KO\u0001\u000bG>dG.Z2uS>t\u0017B\u0001+R\u0005\r\u0019V\r\u001e\t\u0003aYK!aV\u0019\u0003\u001dM+\u0017/^3oG\u0016\u0014VmY8sI\")\u0011\f\u0014a\u0001%\u0005!Q\r\\3n\u0011\u0015Y\u0006\u0001\"\u0001]\u0003i\tG-Y7HKR\u0014V-\u00193He>,\b\u000fR5di&|g.\u0019:z)\u0005i\u0006C\u0001\u0019_\u0013\ty\u0016GA\u000bSK\u000e|'\u000fZ$s_V\u0004H)[2uS>t\u0017M]=\t\u000b\u0005\u0004A\u0011\u00012\u0002!\u0005$\u0017-\\\"p]Z,'\u000f\u001e+p'\u0006kE#A2\u0011\te\"gm\\\u0005\u0003Kj\u0012a\u0001V;qY\u0016\u0014\u0004c\u0001\u000f#OB\u0011\u0001.\\\u0007\u0002S*\u0011!n[\u0001\u000bQ\u0006$wn\u001c9`E\u0006l'B\u00017\u000b\u0003\u001d\u0019X-\u001d3p_BL!A\\5\u0003#M\u000bUJU3d_J$wK]5uC\ndW\r\u0005\u0002qk6\t\u0011O\u0003\u0002sg\u0006A1/Y7u_>d7OC\u0001u\u0003\u0019AGo\u001d6eW&\u0011a/\u001d\u0002\u000e'\u0006ke)\u001b7f\u0011\u0016\fG-\u001a:\t\u000ba\u0004A\u0011A=\u0002\u001d\u0005$\u0017-\\\"pk:$8*\\3sgR\u0011!p \t\u00049\tZ\b\u0003B\u001de\u0001r\u0004\"!O?\n\u0005yT$\u0001\u0002'p]\u001eDq!!\u0001x\u0001\u0004\t\u0019!\u0001\u0006l[\u0016\u0014H*\u001a8hi\"\u00042!OA\u0003\u0013\r\t9A\u000f\u0002\u0004\u0013:$\bbBA\u0006\u0001\u0011\u0005\u0011QB\u0001\u000fC\u0012\fWnQ8v]R\fV.\u001a:t)\u0011\ty!!\u0007\u0011\tq\u0011\u0013\u0011\u0003\t\u0006s\u0011\u0004\u00151\u0003\t\u0004s\u0005U\u0011bAA\fu\t1Ai\\;cY\u0016D\u0001\"a\u0007\u0002\n\u0001\u0007\u00111A\u0001\u000bc6,'\u000fT3oORD\u0007bBA\u0010\u0001\u0011\u0005\u0011\u0011E\u0001!C\u0012\fWnU8siJ+\u0017\rZ:CsJ+g-\u001a:f]\u000e,\u0007k\\:ji&|g\u000eF\u0001\u001c\u0011\u001d\t)\u0003\u0001C\u0001\u0003C\t!#\u00193b[6\u000b'o\u001b#va2L7-\u0019;fg\"9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0012\u0001C1eC6\u0014\u0015k\u0015*\u0015\u0007m\ti\u0003\u0003\u0005\u00020\u0005\u001d\u0002\u0019AA\u0019\u0003%Ygn\\<o':\u00048\u000f\u0005\u0004\u00024\u0005e\u0012QH\u0007\u0003\u0003kQ1!a\u000e\u001f\u0003%\u0011'o\\1eG\u0006\u001cH/\u0003\u0003\u0002<\u0005U\"!\u0003\"s_\u0006$7-Y:u!\r\u0001\u0014qH\u0005\u0004\u0003\u0003\n$\u0001C*oaR\u000b'\r\\3\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H\u0005\t\u0012\rZ1n%\u0016\fG.[4o\u0013:$W\r\\:\u0015\u001bm\tI%!\u0018\u0002b\u0005\u0015\u0014\u0011NA7\u0011)\tY%a\u0011\u0011\u0002\u0003\u0007\u0011QJ\u0001\u000fG>t7/\u001a8tkNlu\u000eZ3m!\u0011\ty%!\u0017\u000e\u0005\u0005E#\u0002BA*\u0003+\n\u0011bY8og\u0016t7/^:\u000b\u0007\u0005]c!\u0001\u0006bY\u001e|'/\u001b;i[NLA!a\u0017\u0002R\t\u00112i\u001c8tK:\u001cXo]$f]\u0016\u0014\u0018\r^8s\u0011%\ty&a\u0011\u0011\u0002\u0003\u0007\u0011*\u0001\u0005jgN{'\u000f^3e\u0011)\t\u0019'a\u0011\u0011\u0002\u0003\u0007\u00111A\u0001\r[\u0006D\u0018J\u001c3fYNK'0\u001a\u0005\u000b\u0003O\n\u0019\u0005%AA\u0002\u0005\r\u0011AE7bq\u000e{gn]3ogV\u001ch*^7cKJD!\"a\u001b\u0002DA\u0005\t\u0019AA\n\u00031aw\u000e\u001a+ie\u0016\u001c\bn\u001c7e\u0011)\ty'a\u0011\u0011\u0002\u0003\u0007\u00111A\u0001\u000e[\u0006DH+\u0019:hKR\u001c\u0016N_3\t\u000f\u0005M\u0004\u0001\"\u0001\u0002v\u0005a\u0011\rZ1n\r2\fwm\u0015;biR\u0011\u0011q\u000f\t\u0007s\u0011\fI(!\u001f\u0011\u0007!\nY(C\u0002\u0002~\t\u0011qB\u00127bON#\u0018\r^'fiJL7m\u001d\u0005\b\u0003\u0003\u0003A\u0011AAB\u0003U\tG-Y7TS:<G.\u001a*fC\u0012\u0014UoY6fiN$\"!!\"\u0011\tq\u0011\u0013q\u0011\t\u0004a\u0005%\u0015bAAFc\t\u00012+\u001b8hY\u0016\u0014V-\u00193Ck\u000e\\W\r\u001e\u0005\b\u0003\u001f\u0003A\u0011AAI\u0003I\tG-Y7SK\u000e|'\u000fZ:3!&dW-\u001e9\u0015\t\u0005M\u00151\u0014\t\u00059\t\n)\nE\u0002\u0014\u0003/K1!!'\u0015\u0005\u0019\u0001\u0016\u000e\\3va\"I\u0011QTAG!\u0003\u0005\r!S\u0001\u0014g\u0016\u001cwN\u001c3bef\fE.[4o[\u0016tGo\u001d\u0005\b\u0003C\u0003A\u0011AAR\u0003A\tG-Y7SK\u000e|'\u000fZ:3%>$7\u000f\u0006\u0004\u0002&\u00065\u0016\u0011\u0017\t\u00059\t\n9\u000bE\u00021\u0003SK1!a+2\u0005\r\u0011v\u000e\u001a\u0005\u000b\u0003_\u000by\n%AA\u0002\u0005\r\u0011A\u00032vG.,GoU5{K\"I\u0011QTAP!\u0003\u0005\r!\u0013\u0005\b\u0003k\u0003A\u0011AA\\\u0003Q\tG-Y7DQ\u0006\u0014\u0018m\u0019;fe&TX\rV1hgR\t!\u0010C\u0004\u0002<\u0002!\t!!0\u00023\u0005$\u0017-\\\"iCJ\f7\r^3sSj,G+Y4WC2,Xm\u001d\u000b\u0005\u0003\u007f\u000bY\r\u0005\u0004B\u0003\u0003\f)\r`\u0005\u0004\u0003\u00074%aA'baB\u0019\u0011(a2\n\u0007\u0005%'HA\u0002B]fDq!!4\u0002:\u0002\u0007\u0001)A\u0002uC\u001eDq!!5\u0001\t\u0003\t\u0019.\u0001\rbI\u0006lg)\u001b7uKJ\u0014VmY8sIN<\u0016\u000e\u001e5UC\u001e$2aGAk\u0011\u001d\t9.a4A\u0002\u0001\u000bq\u0001^1h\u001d\u0006lW\rC\u0004\u0002\\\u0002!\t!!8\u0002\u001b\u0005$\u0017-\u001c+sS6\u0014V-\u00193t)\u001dY\u0012q\\Ar\u0003OD\u0001\"!9\u0002Z\u0002\u0007\u00111A\u0001\niJLWn\u0015;beRD\u0001\"!:\u0002Z\u0002\u0007\u00111A\u0001\biJLW.\u00128e\u0011%\tI/!7\u0011\u0002\u0003\u0007\u0001)A\u0005sK\u0006$wI]8va\"9\u0011Q\u001e\u0001\u0005\u0002\u0005=\u0018\u0001H1eC6$&/[7M_^\fV/\u00197jif\u0014V-\u00193He>,\bo\u001d\u000b\u00047\u0005E\bBCAz\u0003W\u0004\n\u00111\u0001\u0002\u0004\u0005q\u0001\u000f\u001b:fIRC'/Z:i_2$\u0007\"CA|\u0001E\u0005I\u0011AA}\u0003U\tG-Y7T\u00036\u001b\u0016M^3%I\u00164\u0017-\u001e7uII*\"!a?+\u0007%\u000bip\u000b\u0002\u0002\u0000B!!\u0011\u0001B\u0006\u001b\t\u0011\u0019A\u0003\u0003\u0003\u0006\t\u001d\u0011!C;oG\",7m[3e\u0015\r\u0011IAO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0007\u0005\u0007\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0011\t\u0002AI\u0001\n\u0003\u0011\u0019\"A\u000ebI\u0006l'+Z1mS\u001et\u0017J\u001c3fYN$C-\u001a4bk2$H%M\u000b\u0003\u0005+QC!!\u0014\u0002~\"I!\u0011\u0004\u0001\u0012\u0002\u0013\u0005\u0011\u0011`\u0001\u001cC\u0012\fWNU3bY&<g.\u00138eK2\u001cH\u0005Z3gCVdG\u000f\n\u001a\t\u0013\tu\u0001!%A\u0005\u0002\t}\u0011aG1eC6\u0014V-\u00197jO:Le\u000eZ3mg\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\")\"\u00111AA\u007f\u0011%\u0011)\u0003AI\u0001\n\u0003\u0011y\"A\u000ebI\u0006l'+Z1mS\u001et\u0017J\u001c3fYN$C-\u001a4bk2$H\u0005\u000e\u0005\n\u0005S\u0001\u0011\u0013!C\u0001\u0005W\t1$\u00193b[J+\u0017\r\\5h]&sG-\u001a7tI\u0011,g-Y;mi\u0012*TC\u0001B\u0017U\u0011\t\u0019\"!@\t\u0013\tE\u0002!%A\u0005\u0002\t}\u0011aG1eC6\u0014V-\u00197jO:Le\u000eZ3mg\u0012\"WMZ1vYR$c\u0007C\u0005\u00036\u0001\t\n\u0011\"\u0001\u0002z\u0006a\u0012\rZ1n%\u0016\u001cwN\u001d3teAKG.Z;qI\u0011,g-Y;mi\u0012\n\u0004\"\u0003B\u001d\u0001E\u0005I\u0011\u0001B\u0010\u0003i\tG-Y7SK\u000e|'\u000fZ:3%>$7\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0011%\u0011i\u0004AI\u0001\n\u0003\tI0\u0001\u000ebI\u0006l'+Z2pe\u0012\u001c(GU8eg\u0012\"WMZ1vYR$#\u0007C\u0005\u0003B\u0001\t\n\u0011\"\u0001\u0003D\u00059\u0012\rZ1n)JLWNU3bIN$C-\u001a4bk2$HeM\u000b\u0003\u0005\u000bR3\u0001QA\u007f\u0011%\u0011I\u0005AI\u0001\n\u0003\u0011y\"\u0001\u0014bI\u0006lGK]5n\u0019><\u0018+^1mSRL(+Z1e\u000fJ|W\u000f]:%I\u00164\u0017-\u001e7uIE\u0002")
public class ADAMAlignmentRecordRDDFunctions
extends ADAMSequenceDictionaryRDDAggregator<AlignmentRecord> {
    private final RDD<AlignmentRecord> rdd;

    public RDD<AlignmentRecord> filterByOverlappingRegion(ReferenceRegion query) {
        return this.rdd.filter((Function1)new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMAlignmentRecordRDDFunctions $outer;
            private final ReferenceRegion query$1;

            public final boolean apply(AlignmentRecord rec) {
                return this.$outer.org$bdgenomics$adam$rdd$read$ADAMAlignmentRecordRDDFunctions$$overlapsQuery$1(rec, this.query$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.query$1 = query$1;
            }
        });
    }

    public void adamSAMSave(String filePath, boolean asSam) {
        Tuple2<RDD<SAMRecordWritable>, SAMFileHeader> tuple2;
        block2: {
            boolean bl;
            block5: {
                boolean bl2;
                block8: {
                    block7: {
                        Configuration conf;
                        RDD withKey;
                        block6: {
                            block4: {
                                SAMFileHeader header2;
                                block3: {
                                    Tuple2 tuple22;
                                    tuple2 = ADAMAlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(this.rdd).adamConvertToSAM();
                                    if (tuple2 == null) break block2;
                                    RDD convertRecords = (RDD)tuple2._1();
                                    SAMFileHeader header3 = (SAMFileHeader)tuple2._2();
                                    if (convertRecords == null) break block2;
                                    RDD rDD = convertRecords;
                                    if (header3 == null) break block2;
                                    SAMFileHeader sAMFileHeader = header3;
                                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)rDD, (Object)sAMFileHeader);
                                    RDD convertRecords2 = (RDD)tuple23._1();
                                    header2 = (SAMFileHeader)tuple23._2();
                                    withKey = convertRecords2.keyBy((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final LongWritable apply(SAMRecordWritable v) {
                                            return new LongWritable((long)v.get().getAlignmentStart());
                                        }
                                    });
                                    bl = asSam;
                                    if (!bl) break block3;
                                    ADAMSAMOutputFormat$.MODULE$.addHeader(header2);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block4;
                                }
                                if (bl) break block5;
                                ADAMBAMOutputFormat$.MODULE$.addHeader(header2);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            conf = this.rdd.context().hadoopConfiguration();
                            bl2 = asSam;
                            if (!bl2) break block6;
                            SparkContext$.MODULE$.rddToPairRDDFunctions(withKey, ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(SAMRecordWritable.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms())).saveAsNewAPIHadoopFile(filePath, LongWritable.class, SAMRecordWritable.class, ADAMSAMOutputFormat.class, conf);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block7;
                        }
                        if (bl2) break block8;
                        SparkContext$.MODULE$.rddToPairRDDFunctions(withKey, ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(SAMRecordWritable.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms())).saveAsNewAPIHadoopFile(filePath, LongWritable.class, SAMRecordWritable.class, ADAMBAMOutputFormat.class, conf);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl2));
            }
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        throw new MatchError(tuple2);
    }

    public boolean adamSAMSave$default$2() {
        return true;
    }

    @Override
    public Set<SequenceRecord> getSequenceRecordsFromElement(AlignmentRecord elem) {
        return SequenceRecord$.MODULE$.fromADAMRecord(elem);
    }

    public RecordGroupDictionary adamGetReadGroupDictionary() {
        Seq rgNames = Predef$.MODULE$.refArrayOps((Object[])this.rdd.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<RecordGroup> apply(AlignmentRecord x$2) {
                return Option$.MODULE$.option2Iterable(RecordGroup$.MODULE$.apply(x$2));
            }
        }, ClassTag$.MODULE$.apply(RecordGroup.class)).distinct().collect()).toSeq();
        return new RecordGroupDictionary((Seq<RecordGroup>)rgNames);
    }

    public Tuple2<RDD<SAMRecordWritable>, SAMFileHeader> adamConvertToSAM() {
        SequenceDictionary sd = ADAMAlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(this.rdd).adamGetSequenceDictionary();
        RecordGroupDictionary rgd = ADAMAlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(this.rdd).adamGetReadGroupDictionary();
        AlignmentRecordConverter adamRecordConverter = new AlignmentRecordConverter();
        SAMFileHeader header2 = adamRecordConverter.createSAMHeader(sd, rgd);
        Broadcast hdrBcast = this.rdd.context().broadcast((Object)SAMFileHeaderWritable$.MODULE$.apply(header2), ClassTag$.MODULE$.apply(SAMFileHeaderWritable.class));
        RDD convertedRDD = this.rdd.map((Function1)new Serializable(this, adamRecordConverter, hdrBcast){
            public static final long serialVersionUID = 0L;
            private final AlignmentRecordConverter adamRecordConverter$1;
            private final Broadcast hdrBcast$1;

            /*
             * WARNING - void declaration
             */
            public final SAMRecordWritable apply(AlignmentRecord r) {
                void var2_2;
                SAMRecordWritable srw = new SAMRecordWritable();
                srw.set(this.adamRecordConverter$1.convert(r, (SAMFileHeaderWritable)this.hdrBcast$1.value()));
                return var2_2;
            }
            {
                this.adamRecordConverter$1 = adamRecordConverter$1;
                this.hdrBcast$1 = hdrBcast$1;
            }
        }, ClassTag$.MODULE$.apply(SAMRecordWritable.class));
        return new Tuple2((Object)convertedRDD, (Object)header2);
    }

    public RDD<Tuple2<String, Object>> adamCountKmers(int kmerLength) {
        return SparkContext$.MODULE$.rddToPairRDDFunctions(this.rdd.flatMap((Function1)new Serializable(this, kmerLength){
            public static final long serialVersionUID = 0L;
            private final int kmerLength$1;

            public final Iterator<Tuple2<String, Object>> apply(AlignmentRecord r) {
                return new StringOps(Predef$.MODULE$.augmentString(((Object)r.getSequence()).toString())).sliding(this.kmerLength$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, Object> apply(String k) {
                        return new Tuple2((Object)k, (Object)BoxesRunTime.boxToLong((long)1L));
                    }
                });
            }
            {
                this.kmerLength$1 = kmerLength$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Long(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(long k1, long k2) {
                return this.apply$mcJJJ$sp(k1, k2);
            }

            public long apply$mcJJJ$sp(long k1, long k2) {
                return k1 + k2;
            }
        });
    }

    public RDD<Tuple2<String, Object>> adamCountQmers(int qmerLength) {
        return ErrorCorrection$.MODULE$.countQmers(this.rdd, qmerLength);
    }

    public RDD<AlignmentRecord> adamSortReadsByReferencePosition() {
        this.log().info("Sorting reads by reference position");
        Iterator<String> unmappedReferenceNames = new Iterator<String>(this){
            private int currentOffsetFromEnd;

            public Iterator<String> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<String> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<String> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<String> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<String, B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<String, GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<String> filter(Function1<String, Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<String, B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<String> withFilter(Function1<String, Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<String> filterNot(Function1<String, Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<String, B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, String, B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<String, B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<String> takeWhile(Function1<String, Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<String>, Iterator<String>> partition(Function1<String, Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<String>, Iterator<String>> span(Function1<String, Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<String> dropWhile(Function1<String, Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<String, B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<String, Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<String, U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<String, Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<String, Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<String> find(Function1<String, Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<String, Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<String> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size2) {
                return Iterator.class.grouped((Iterator)this, (int)size2);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size2, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size2, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<String>, Iterator<String>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<String> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<String> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<String> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<String> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<String, Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<String, B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, String, B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<String, B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, String, B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<String, B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, String, B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<String, B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, String, B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<String, B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(B z, Function2<B, String, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public <B> String min(Ordering<B> cmp) {
                return TraversableOnce.class.min((TraversableOnce)this, cmp);
            }

            public <B> String max(Ordering<B> cmp) {
                return TraversableOnce.class.max((TraversableOnce)this, cmp);
            }

            public <B> String maxBy(Function1<String, B> f, Ordering<B> cmp) {
                return TraversableOnce.class.maxBy((TraversableOnce)this, f, cmp);
            }

            public <B> String minBy(Function1<String, B> f, Ordering<B> cmp) {
                return TraversableOnce.class.minBy((TraversableOnce)this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<String> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<String> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<String> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<String> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> scala.collection.immutable.Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<String> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, String, Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<String, Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end2) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end2);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end2) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end2);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            public <A1> A1 $div$colon$bslash(A1 z, Function2<A1, A1, A1> op) {
                return (A1)GenTraversableOnce.class.$div$colon$bslash((GenTraversableOnce)this, z, op);
            }

            public int currentOffsetFromEnd() {
                return this.currentOffsetFromEnd;
            }

            public void currentOffsetFromEnd_$eq(int x$1) {
                this.currentOffsetFromEnd = x$1;
            }

            public boolean hasNext() {
                return true;
            }

            public String next() {
                this.currentOffsetFromEnd_$eq(this.currentOffsetFromEnd() + 1);
                if (this.currentOffsetFromEnd() > 10000) {
                    this.currentOffsetFromEnd_$eq(0);
                }
                return new StringBuilder().append((Object)"unmapped").append((Object)((Object)BoxesRunTime.boxToInteger((int)(Integer.MAX_VALUE - this.currentOffsetFromEnd()))).toString()).toString();
            }
            {
                GenTraversableOnce.class.$init$((GenTraversableOnce)this);
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
                this.currentOffsetFromEnd = 0;
            }
        };
        OrderedRDDFunctions qual$1 = SparkContext$.MODULE$.rddToOrderedRDDFunctions(this.rdd.map((Function1)new Serializable(this, (Iterator)unmappedReferenceNames){
            public static final long serialVersionUID = 0L;
            private final Iterator unmappedReferenceNames$1;

            public final Tuple2<ReferencePosition, AlignmentRecord> apply(AlignmentRecord p) {
                Option<ReferencePosition> option;
                block4: {
                    ReferencePosition referencePosition2;
                    block3: {
                        ReferencePosition pos;
                        block2: {
                            option = ReferencePosition$.MODULE$.apply(p);
                            None$ none$ = None$.MODULE$;
                            Option<ReferencePosition> option2 = option;
                            if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                            referencePosition2 = new ReferencePosition((String)this.unmappedReferenceNames$1.next(), Long.MAX_VALUE);
                            break block3;
                        }
                        if (!(option instanceof Some)) break block4;
                        Some some = (Some)option;
                        referencePosition2 = pos = (ReferencePosition)some.x();
                    }
                    ReferencePosition referencePos = referencePosition2;
                    return new Tuple2((Object)referencePos, (Object)p);
                }
                throw new MatchError(option);
            }
            {
                this.unmappedReferenceNames$1 = unmappedReferenceNames$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()), ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(AlignmentRecord.class));
        boolean x$12 = qual$1.sortByKey$default$1();
        int x$13 = qual$1.sortByKey$default$2();
        return qual$1.sortByKey(x$12, x$13).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AlignmentRecord apply(Tuple2<ReferencePosition, AlignmentRecord> p) {
                return (AlignmentRecord)p._2();
            }
        }, ClassTag$.MODULE$.apply(AlignmentRecord.class));
    }

    public RDD<AlignmentRecord> adamMarkDuplicates() {
        return MarkDuplicates$.MODULE$.apply(this.rdd);
    }

    public RDD<AlignmentRecord> adamBQSR(Broadcast<SnpTable> knownSnps) {
        return BaseQualityRecalibration$.MODULE$.apply(this.rdd, knownSnps);
    }

    public RDD<AlignmentRecord> adamRealignIndels(ConsensusGenerator consensusModel, boolean isSorted, int maxIndelSize, int maxConsensusNumber, double lodThreshold, int maxTargetSize) {
        return RealignIndels$.MODULE$.apply(this.rdd, consensusModel, isSorted, maxIndelSize, maxConsensusNumber, lodThreshold, RealignIndels$.MODULE$.apply$default$7());
    }

    public ConsensusGenerator adamRealignIndels$default$1() {
        return new ConsensusGeneratorFromReads();
    }

    public boolean adamRealignIndels$default$2() {
        return false;
    }

    public int adamRealignIndels$default$3() {
        return 500;
    }

    public int adamRealignIndels$default$4() {
        return 30;
    }

    public double adamRealignIndels$default$5() {
        return 5.0;
    }

    public int adamRealignIndels$default$6() {
        return 3000;
    }

    public Tuple2<FlagStatMetrics, FlagStatMetrics> adamFlagStat() {
        return FlagStat$.MODULE$.apply(this.rdd);
    }

    public RDD<SingleReadBucket> adamSingleReadBuckets() {
        return SingleReadBucket$.MODULE$.apply(this.rdd);
    }

    public RDD<Pileup> adamRecords2Pileup(boolean secondaryAlignments) {
        Reads2PileupProcessor helper = new Reads2PileupProcessor(secondaryAlignments);
        return helper.process(this.rdd);
    }

    public boolean adamRecords2Pileup$default$1() {
        return false;
    }

    public RDD<Rod> adamRecords2Rods(int bucketSize, boolean secondaryAlignments) {
        RDD bucketedReads = SparkContext$.MODULE$.rddToPairRDDFunctions(this.rdd.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AlignmentRecord x$3) {
                return x$3.getStart() != null;
            }
        }).flatMap((Function1)new Serializable(this, bucketSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMAlignmentRecordRDDFunctions $outer;
            private final int bucketSize$1;

            public final List<Tuple2<ReferencePosition, AlignmentRecord>> apply(AlignmentRecord r) {
                return this.$outer.org$bdgenomics$adam$rdd$read$ADAMAlignmentRecordRDDFunctions$$mapToBucket$1(r, this.bucketSize$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.bucketSize$1 = bucketSize$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(AlignmentRecord.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms())).groupByKey();
        Reads2PileupProcessor pp = new Reads2PileupProcessor(secondaryAlignments);
        return bucketedReads.flatMap((Function1)new Serializable(this, pp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMAlignmentRecordRDDFunctions $outer;
            private final Reads2PileupProcessor pp$1;

            public final Iterable<Rod> apply(Tuple2<ReferencePosition, Iterable<AlignmentRecord>> bucket) {
                return this.$outer.org$bdgenomics$adam$rdd$read$ADAMAlignmentRecordRDDFunctions$$bucketedReadsToRods$1(bucket, this.pp$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.pp$1 = pp$1;
            }
        }, ClassTag$.MODULE$.apply(Rod.class));
    }

    public int adamRecords2Rods$default$1() {
        return 1000;
    }

    public boolean adamRecords2Rods$default$2() {
        return false;
    }

    public RDD<Tuple2<String, Object>> adamCharacterizeTags() {
        return SparkContext$.MODULE$.rddToPairRDDFunctions(this.rdd.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Tuple2<String, Object>> apply(AlignmentRecord x$5) {
                return (Seq)RichAlignmentRecord$.MODULE$.apply(x$5).tags().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, Object> apply(Attribute attr) {
                        return new Tuple2((Object)attr.tag(), (Object)BoxesRunTime.boxToLong((long)1L));
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Long(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(long x$6, long x$7) {
                return this.apply$mcJJJ$sp(x$6, x$7);
            }

            public long apply$mcJJJ$sp(long x$6, long x$7) {
                return x$6 + x$7;
            }
        });
    }

    public Map<Object, Object> adamCharacterizeTagValues(String tag) {
        return (Map)this.adamFilterRecordsWithTag(tag).flatMap((Function1)new Serializable(this, tag){
            public static final long serialVersionUID = 0L;
            public final String tag$1;

            public final Iterable<Attribute> apply(AlignmentRecord x$8) {
                return Option$.MODULE$.option2Iterable(RichAlignmentRecord$.MODULE$.apply(x$8).tags().find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$adamCharacterizeTagValues$1 $outer;

                    public final boolean apply(Attribute x$9) {
                        String string = x$9.tag();
                        String string2 = this.$outer.tag$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.tag$1 = tag$1;
            }
        }, ClassTag$.MODULE$.apply(Attribute.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<Object, Object> apply(Attribute attr) {
                return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(attr.value()), (Object)BoxesRunTime.boxToLong((long)1L))}));
            }
        }, ClassTag$.MODULE$.apply(Map.class)).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<Object, Object> apply(Map<Object, Object> map1, Map<Object, Object> map2) {
                return MapTools$.MODULE$.add(map1, map2, Numeric.LongIsIntegral$.MODULE$);
            }
        });
    }

    public RDD<AlignmentRecord> adamFilterRecordsWithTag(String tagName) {
        Predef$.MODULE$.assert(tagName.length() == 2, (Function0)new Serializable(this, tagName){
            public static final long serialVersionUID = 0L;
            private final String tagName$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("withAttribute takes a tagName argument of length 2; tagName=\"%s\"")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tagName$1}));
            }
            {
                this.tagName$1 = tagName$1;
            }
        });
        return this.rdd.filter((Function1)new Serializable(this, tagName){
            public static final long serialVersionUID = 0L;
            public final String tagName$1;

            public final boolean apply(AlignmentRecord x$10) {
                return RichAlignmentRecord$.MODULE$.apply(x$10).tags().exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$adamFilterRecordsWithTag$2 $outer;

                    public final boolean apply(Attribute x$11) {
                        String string = x$11.tag();
                        String string2 = this.$outer.tagName$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.tagName$1 = tagName$1;
            }
        });
    }

    public RDD<AlignmentRecord> adamTrimReads(int trimStart, int trimEnd, String readGroup) {
        return TrimReads$.MODULE$.apply(this.rdd, trimStart, trimEnd, readGroup);
    }

    public String adamTrimReads$default$3() {
        return null;
    }

    public RDD<AlignmentRecord> adamTrimLowQualityReadGroups(int phredThreshold) {
        return TrimReads$.MODULE$.apply(this.rdd, phredThreshold);
    }

    public int adamTrimLowQualityReadGroups$default$1() {
        return 20;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean org$bdgenomics$adam$rdd$read$ADAMAlignmentRecordRDDFunctions$$overlapsQuery$1(AlignmentRecord rec, ReferenceRegion query$1) {
        if (!Predef$.MODULE$.Boolean2boolean(rec.getReadMapped())) return false;
        String string = ((Object)rec.getContig().getContigName()).toString();
        String string2 = query$1.referenceName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (Predef$.MODULE$.Long2long(rec.getStart()) >= query$1.end()) return false;
        if (Predef$.MODULE$.Long2long(rec.getEnd()) <= query$1.start()) return false;
        return true;
    }

    public final List org$bdgenomics$adam$rdd$read$ADAMAlignmentRecordRDDFunctions$$mapToBucket$1(AlignmentRecord r, int bucketSize$1) {
        long s = Predef$.MODULE$.Long2long(r.getStart()) / (long)bucketSize$1;
        long e = Predef$.MODULE$.Long2long(r.getEnd()) / (long)bucketSize$1;
        CharSequence name2 = r.getContig().getContigName();
        return s == e ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new ReferencePosition(ADAMContext$.MODULE$.charSequenceToString(name2), s), (Object)r)})) : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new ReferencePosition(ADAMContext$.MODULE$.charSequenceToString(name2), s), (Object)r), new Tuple2((Object)new ReferencePosition(ADAMContext$.MODULE$.charSequenceToString(name2), e), (Object)r)}));
    }

    public final Iterable org$bdgenomics$adam$rdd$read$ADAMAlignmentRecordRDDFunctions$$bucketedReadsToRods$1(Tuple2 bucket, Reads2PileupProcessor pp$1) {
        Tuple2 tuple2 = bucket;
        if (tuple2 != null) {
            Iterable bucketReads;
            Iterable iterable;
            Iterable bucketReads2 = iterable = (bucketReads = (Iterable)tuple2._2());
            return ((scala.collection.immutable.Seq)((TraversableLike)bucketReads2.flatMap((Function1)new Serializable(this, pp$1){
                public static final long serialVersionUID = 0L;
                private final Reads2PileupProcessor pp$1;

                public final List<Pileup> apply(AlignmentRecord record) {
                    return this.pp$1.readToPileups(record);
                }
                {
                    this.pp$1 = pp$1;
                }
            }, Iterable$.MODULE$.canBuildFrom())).groupBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ReferencePosition apply(Pileup x$4) {
                    return ReferencePosition$.MODULE$.apply(x$4);
                }
            }).toList().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Rod apply(Tuple2<ReferencePosition, Iterable<Pileup>> g) {
                    return new Rod((ReferencePosition)g._1(), (List<Pileup>)((TraversableOnce)g._2()).toList());
                }
            }, List$.MODULE$.canBuildFrom())).toSeq();
        }
        throw new MatchError((Object)tuple2);
    }

    public ADAMAlignmentRecordRDDFunctions(RDD<AlignmentRecord> rdd) {
        this.rdd = rdd;
        super(rdd);
    }
}

