/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.read.recalibration;

import java.io.File;
import java.io.PrintWriter;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.models.SnpTable;
import org.bdgenomics.adam.rdd.read.recalibration.BaseQualityRecalibration$;
import org.bdgenomics.adam.rdd.read.recalibration.Covariate;
import org.bdgenomics.adam.rdd.read.recalibration.CovariateKey;
import org.bdgenomics.adam.rdd.read.recalibration.CovariateSpace;
import org.bdgenomics.adam.rdd.read.recalibration.CovariateSpace$;
import org.bdgenomics.adam.rdd.read.recalibration.CycleCovariate;
import org.bdgenomics.adam.rdd.read.recalibration.DinucCovariate;
import org.bdgenomics.adam.rdd.read.recalibration.ObservationAccumulator;
import org.bdgenomics.adam.rdd.read.recalibration.ObservationAccumulator$;
import org.bdgenomics.adam.rdd.read.recalibration.ObservationTable;
import org.bdgenomics.adam.rdd.read.recalibration.Recalibrator;
import org.bdgenomics.adam.rdd.read.recalibration.Recalibrator$;
import org.bdgenomics.adam.rich.DecadentRead;
import org.bdgenomics.adam.rich.RichAlignmentRecord$;
import org.bdgenomics.adam.util.QualityScore;
import org.bdgenomics.adam.util.QualityScore$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\u0001\u0003\u0001=\u0011\u0001DQ1tKF+\u0018\r\\5usJ+7-\u00197jEJ\fG/[8o\u0015\t\u0019A!A\u0007sK\u000e\fG.\u001b2sCRLwN\u001c\u0006\u0003\u000b\u0019\tAA]3bI*\u0011q\u0001C\u0001\u0004e\u0012$'BA\u0005\u000b\u0003\u0011\tG-Y7\u000b\u0005-a\u0011A\u00032eO\u0016tw.\\5dg*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!YI\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\r\u0005\u0002\u0012/%\u0011\u0001D\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u00035}i\u0011a\u0007\u0006\u00039u\tQa\u001d9be.T!A\b\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\u00013DA\u0004M_\u001e<\u0017N\\4\t\u0011\t\u0002!Q1A\u0005\u0002\r\nQ!\u001b8qkR,\u0012\u0001\n\t\u0004K\u001dJS\"\u0001\u0014\u000b\u0005\u001dY\u0012B\u0001\u0015'\u0005\r\u0011F\t\u0012\t\u0003U5j\u0011a\u000b\u0006\u0003Y!\tAA]5dQ&\u0011af\u000b\u0002\r\t\u0016\u001c\u0017\rZ3oiJ+\u0017\r\u001a\u0005\ta\u0001\u0011\t\u0011)A\u0005I\u00051\u0011N\u001c9vi\u0002B\u0001B\r\u0001\u0003\u0006\u0004%\taM\u0001\nW:|wO\\*oaN,\u0012\u0001\u000e\t\u0004kaRT\"\u0001\u001c\u000b\u0005]Z\u0012!\u00032s_\u0006$7-Y:u\u0013\tIdGA\u0005Ce>\fGmY1tiB\u00111HP\u0007\u0002y)\u0011Q\bC\u0001\u0007[>$W\r\\:\n\u0005}b$\u0001C*oaR\u000b'\r\\3\t\u0011\u0005\u0003!\u0011!Q\u0001\nQ\n!b\u001b8po:\u001cf\u000e]:!\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0003\u0019a\u0014N\\5u}Q\u0019Qi\u0012%\u0011\u0005\u0019\u0003Q\"\u0001\u0002\t\u000b\t\u0012\u0005\u0019\u0001\u0013\t\u000bI\u0012\u0005\u0019\u0001\u001b\t\u000f)\u0003!\u0019!C\u0001\u0017\u0006Q1m\u001c<be&\fG/Z:\u0016\u00031\u0003\"AR'\n\u00059\u0013!AD\"pm\u0006\u0014\u0018.\u0019;f'B\f7-\u001a\u0005\u0007!\u0002\u0001\u000b\u0011\u0002'\u0002\u0017\r|g/\u0019:jCR,7\u000f\t\u0005\b%\u0002\u0011\r\u0011\"\u0001T\u0003Qi\u0017N\\!dG\u0016\u0004H/\u00192mKF+\u0018\r\\5usV\tA\u000b\u0005\u0002V16\taK\u0003\u0002X\u0011\u0005!Q\u000f^5m\u0013\tIfK\u0001\u0007Rk\u0006d\u0017\u000e^=TG>\u0014X\r\u0003\u0004\\\u0001\u0001\u0006I\u0001V\u0001\u0016[&t\u0017iY2faR\f'\r\\3Rk\u0006d\u0017\u000e^=!\u0011\u001di\u0006A1A\u0005\u0002y\u000bA\u0003Z;na>\u00137/\u001a:wCRLwN\u001c+bE2,W#A0\u0011\u0005E\u0001\u0017BA1\u0013\u0005\u001d\u0011un\u001c7fC:Daa\u0019\u0001!\u0002\u0013y\u0016!\u00063v[B|%m]3sm\u0006$\u0018n\u001c8UC\ndW\r\t\u0005\bK\u0002\u0011\r\u0011\"\u0001_\u0003I)g.\u00192mKZK7/\u001b;M_\u001e<\u0017N\\4\t\r\u001d\u0004\u0001\u0015!\u0003`\u0003M)g.\u00192mKZK7/\u001b;M_\u001e<\u0017N\\4!\u0011\u001dI\u0007A1A\u0005\u0002)\fq\u0001Z1uCN,G/F\u0001l!\r)s\u0005\u001c\t\u0005#5|'/\u0003\u0002o%\t1A+\u001e9mKJ\u0002\"A\u00129\n\u0005E\u0014!\u0001D\"pm\u0006\u0014\u0018.\u0019;f\u0017\u0016L\bcA:\u0002\u00049\u0011Ao \b\u0003kzt!A^?\u000f\u0005]dhB\u0001=|\u001b\u0005I(B\u0001>\u000f\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003Y!I1!!\u0001,\u00031!UmY1eK:$(+Z1e\u0013\u0011\t)!a\u0002\u0003\u000fI+7/\u001b3vK*\u0019\u0011\u0011A\u0016\t\u000f\u0005-\u0001\u0001)A\u0005W\u0006AA-\u0019;bg\u0016$\b\u0005C\u0005\u0002\u0010\u0001\u0011\r\u0011\"\u0001\u0002\u0012\u0005AqNY:feZ,G-\u0006\u0002\u0002\u0014A\u0019a)!\u0006\n\u0007\u0005]!A\u0001\tPEN,'O^1uS>tG+\u00192mK\"A\u00111\u0004\u0001!\u0002\u0013\t\u0019\"A\u0005pEN,'O^3eA!I\u0011q\u0004\u0001C\u0002\u0013\u0005\u0011\u0011E\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0016\u0005\u0005\r\u0002\u0003B\u0013(\u0003K\u0001B!a\n\u000225\u0011\u0011\u0011\u0006\u0006\u0005\u0003W\ti#\u0001\u0003bmJ|'bAA\u0018\u0015\u00059am\u001c:nCR\u001c\u0018\u0002BA\u001a\u0003S\u0011q\"\u00117jO:lWM\u001c;SK\u000e|'\u000f\u001a\u0005\t\u0003o\u0001\u0001\u0015!\u0003\u0002$\u00059!/Z:vYR\u0004\u0003bBA\u001e\u0001\u0011%\u0011QH\u0001\u000bIVl\u0007OV5tSR\u001cH\u0003BA \u0003\u000b\u00022!EA!\u0013\r\t\u0019E\u0005\u0002\u0005+:LG\u000f\u0003\u0005\u0002H\u0005e\u0002\u0019AA%\u0003!1\u0017\u000e\\3oC6,\u0007\u0003BA&\u0003#r1!EA'\u0013\r\tyEE\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0013Q\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=#cB\u0004\u0002Z\tA\t!a\u0017\u00021\t\u000b7/Z)vC2LG/\u001f*fG\u0006d\u0017N\u0019:bi&|g\u000eE\u0002G\u0003;2a!\u0001\u0002\t\u0002\u0005}3\u0003BA/!YAqaQA/\t\u0003\t\u0019\u0007\u0006\u0002\u0002\\!A\u0011qMA/\t\u0003\tI'A\u0003baBd\u0017\u0010\u0006\u0004\u0002$\u0005-\u0014Q\u000e\u0005\b\u000f\u0005\u0015\u0004\u0019AA\u0012\u0011\u0019\u0011\u0014Q\ra\u0001i!Q\u0011\u0011OA/\u0003\u0003%I!a\u001d\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003k\u0002B!a\u001e\u0002\u00026\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(\u0001\u0003mC:<'BAA@\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0015\u0011\u0010\u0002\u0007\u001f\nTWm\u0019;")
public class BaseQualityRecalibration
implements Serializable,
Logging {
    private final RDD<DecadentRead> input;
    private final Broadcast<SnpTable> knownSnps;
    private final CovariateSpace covariates;
    private final QualityScore minAcceptableQuality;
    private final boolean dumpObservationTable;
    private final boolean enableVisitLogging;
    private final RDD<Tuple2<CovariateKey, DecadentRead.Residue>> dataset;
    private final ObservationTable observed;
    private final RDD<AlignmentRecord> result;
    private transient Logger org$apache$spark$Logging$$log_;

    public static RDD<AlignmentRecord> apply(RDD<AlignmentRecord> rDD, Broadcast<SnpTable> broadcast) {
        return BaseQualityRecalibration$.MODULE$.apply(rDD, broadcast);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public RDD<DecadentRead> input() {
        return this.input;
    }

    public Broadcast<SnpTable> knownSnps() {
        return this.knownSnps;
    }

    public CovariateSpace covariates() {
        return this.covariates;
    }

    public QualityScore minAcceptableQuality() {
        return this.minAcceptableQuality;
    }

    public boolean dumpObservationTable() {
        return this.dumpObservationTable;
    }

    public boolean enableVisitLogging() {
        return this.enableVisitLogging;
    }

    public RDD<Tuple2<CovariateKey, DecadentRead.Residue>> dataset() {
        return this.dataset;
    }

    public ObservationTable observed() {
        return this.observed;
    }

    public RDD<AlignmentRecord> result() {
        return this.result;
    }

    private void dumpVisits(String filename) {
        Map readLengths = SparkContext$.MODULE$.rddToPairRDDFunctions(this.input().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseQualityRecalibration $outer;

            public final Tuple2<String, Object> apply(DecadentRead read) {
                return new Tuple2((Object)this.$outer.org$bdgenomics$adam$rdd$read$recalibration$BaseQualityRecalibration$$readId$1(read), (Object)BoxesRunTime.boxToInteger((int)read.residues().length()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).collectAsMap();
        Map visited = SparkContext$.MODULE$.rddToPairRDDFunctions(this.dataset().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseQualityRecalibration $outer;

            public final Tuple2<String, Seq<Object>> apply(Tuple2<CovariateKey, DecadentRead.Residue> x0$2) {
                Tuple2<CovariateKey, DecadentRead.Residue> tuple2 = x0$2;
                if (tuple2 != null) {
                    DecadentRead.Residue residue = (DecadentRead.Residue)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)this.$outer.org$bdgenomics$adam$rdd$read$recalibration$BaseQualityRecalibration$$readId$1(residue.read()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{residue.offset()})));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Seq.class), (Ordering)Ordering.String$.MODULE$).reduceByKeyLocally((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Seq<Object> left, Seq<Object> right) {
                return (Seq)left.$plus$plus(right, Seq$.MODULE$.canBuildFrom());
            }
        });
        File outf = new File(filename);
        PrintWriter writer = new PrintWriter(outf);
        visited.foreach((Function1)new Serializable(this, readLengths, writer){
            public static final long serialVersionUID = 0L;
            private final Map readLengths$1;
            private final PrintWriter writer$1;

            public final void apply(Tuple2<String, Seq<Object>> x0$3) {
                Tuple2<String, Seq<Object>> tuple2 = x0$3;
                if (tuple2 != null) {
                    String readName = (String)tuple2._1();
                    Seq visited = (Seq)tuple2._2();
                    int length2 = BoxesRunTime.unboxToInt((Object)this.readLengths$1.apply((Object)readName));
                    char[] buf = (char[])Array$.MODULE$.fill(length2, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final char apply() {
                            return this.apply$mcC$sp();
                        }

                        public char apply$mcC$sp() {
                            return 'O';
                        }
                    }, ClassTag$.MODULE$.Char());
                    visited.foreach((Function1)new Serializable(this, buf){
                        public static final long serialVersionUID = 0L;
                        private final char[] buf$1;

                        public final void apply(int idx) {
                            this.apply$mcVI$sp(idx);
                        }

                        public void apply$mcVI$sp(int idx) {
                            this.buf$1[idx] = 88;
                        }
                        {
                            this.buf$1 = buf$1;
                        }
                    });
                    this.writer$1.println(new StringBuilder().append((Object)readName).append((Object)"\t").append((Object)String.valueOf(buf)).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.readLengths$1 = readLengths$1;
                this.writer$1 = writer$1;
            }
        });
        writer.close();
    }

    public final boolean org$bdgenomics$adam$rdd$read$recalibration$BaseQualityRecalibration$$shouldIncludeRead$1(DecadentRead read) {
        return read.isCanonicalRecord() && read.alignmentQuality().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(QualityScore x$1) {
                return x$1.$greater(QualityScore$.MODULE$.zero());
            }
        }) && read.passedQualityChecks();
    }

    public final boolean org$bdgenomics$adam$rdd$read$recalibration$BaseQualityRecalibration$$shouldIncludeResidue$1(DecadentRead.Residue residue) {
        return residue.quality().$greater(QualityScore$.MODULE$.zero()) && residue.isRegularBase() && !residue.isInsertion() && !((SnpTable)this.knownSnps().value()).isMasked(residue);
    }

    public final Seq org$bdgenomics$adam$rdd$read$recalibration$BaseQualityRecalibration$$observe$1(DecadentRead read) {
        return (Seq)((TraversableLike)this.covariates().apply(read).zip(read.residues(), Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseQualityRecalibration $outer;

            public final boolean apply(Tuple2<CovariateKey, DecadentRead.Residue> x0$1) {
                Tuple2<CovariateKey, DecadentRead.Residue> tuple2 = x0$1;
                if (tuple2 != null) {
                    DecadentRead.Residue residue = (DecadentRead.Residue)tuple2._2();
                    boolean bl = this.$outer.org$bdgenomics$adam$rdd$read$recalibration$BaseQualityRecalibration$$shouldIncludeResidue$1(residue);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public final String org$bdgenomics$adam$rdd$read$recalibration$BaseQualityRecalibration$$readId$1(DecadentRead read) {
        return new StringBuilder().append((Object)read.name()).append((Object)(read.isNegativeRead() ? "-" : "+")).append((Object)(Predef$.MODULE$.Boolean2boolean(RichAlignmentRecord$.MODULE$.richRecordToRecord(read.record()).getFirstOfPair()) ? "1" : "")).append((Object)(Predef$.MODULE$.Boolean2boolean(RichAlignmentRecord$.MODULE$.richRecordToRecord(read.record()).getSecondOfPair()) ? "2" : "")).toString();
    }

    public BaseQualityRecalibration(RDD<DecadentRead> input, Broadcast<SnpTable> knownSnps) {
        this.input = input;
        this.knownSnps = knownSnps;
        Logging.class.$init$((Logging)this);
        this.covariates = CovariateSpace$.MODULE$.apply((Seq<Covariate>)Predef$.MODULE$.wrapRefArray((Object[])new Covariate[]{new CycleCovariate(), new DinucCovariate()}));
        this.minAcceptableQuality = QualityScore$.MODULE$.apply(5);
        this.dumpObservationTable = false;
        this.enableVisitLogging = false;
        this.dataset = input.filter((Function1)new $anonfun$2(this)).flatMap((Function1)new $anonfun$3(this), ClassTag$.MODULE$.apply(Tuple2.class));
        if (this.enableVisitLogging()) {
            input.cache();
            this.dataset().cache();
            this.dumpVisits("bqsr-visits.dump");
        }
        this.observed = ((ObservationAccumulator)this.dataset().map((Function1)new $anonfun$4(this), ClassTag$.MODULE$.apply(Tuple2.class)).aggregate((Object)ObservationAccumulator$.MODULE$.apply(this.covariates()), (Function2)new $anonfun$5(this), (Function2)new $anonfun$6(this), ClassTag$.MODULE$.apply(ObservationAccumulator.class))).result();
        if (this.dumpObservationTable()) {
            Predef$.MODULE$.println((Object)this.observed().toCSV());
        }
        Recalibrator recalibrator = Recalibrator$.MODULE$.apply(this.observed(), this.minAcceptableQuality());
        this.result = input.map((Function1)recalibrator, ClassTag$.MODULE$.apply(AlignmentRecord.class));
    }
}

