/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.variation;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.converters.VariantContextConverter;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.VariantContext;
import org.bdgenomics.adam.rdd.variation.ADAMVCFOutputFormat;
import org.bdgenomics.adam.rdd.variation.ADAMVCFOutputFormat$;
import org.bdgenomics.adam.rdd.variation.ADAMVariationContext$;
import org.bdgenomics.adam.rdd.variation.GenotypeRDDFunctions;
import org.bdgenomics.adam.rdd.variation.VariantContextRDDFunctions;
import org.bdgenomics.adam.util.HadoopUtil$;
import org.bdgenomics.formats.avro.DatabaseVariantAnnotation;
import org.bdgenomics.formats.avro.Genotype;
import org.seqdoop.hadoop_bam.VCFFormat;
import org.seqdoop.hadoop_bam.VCFInputFormat;
import org.seqdoop.hadoop_bam.VariantContextWritable;
import org.slf4j.Logger;
import parquet.hadoop.util.ContextUtil;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ur!B\u0001\u0003\u0011\u0003i\u0011\u0001F!E\u000363\u0016M]5bi&|gnQ8oi\u0016DHO\u0003\u0002\u0004\t\u0005Ia/\u0019:jCRLwN\u001c\u0006\u0003\u000b\u0019\t1A\u001d3e\u0015\t9\u0001\"\u0001\u0003bI\u0006l'BA\u0005\u000b\u0003)\u0011GmZ3o_6L7m\u001d\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001A\u0011abD\u0007\u0002\u0005\u0019)\u0001C\u0001E\u0001#\t!\u0012\tR!N-\u0006\u0014\u0018.\u0019;j_:\u001cuN\u001c;fqR\u001c2a\u0004\n\u0019!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fMB\u00111#G\u0005\u00035Q\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQ\u0001H\b\u0005\u0002u\ta\u0001P5oSRtD#A\u0007\t\u000b}yA1\u0001\u0011\u0002EM\u0004\u0018M]6D_:$X\r\u001f;U_\u0006#\u0015)\u0014,be&\fG/[8o\u0007>tG/\u001a=u)\r\t\u0013\u0011\u0001\t\u0003\u001d\t2A\u0001\u0005\u0002\u0001GM!!E\u0005\r%!\t)#&D\u0001'\u0015\t9\u0003&A\u0003ta\u0006\u00148N\u0003\u0002*\u0015\u00051\u0011\r]1dQ\u0016L!a\u000b\u0014\u0003\u000f1{wmZ5oO\"AQF\tBC\u0002\u0013\u0005a&\u0001\u0002tGV\tq\u0006\u0005\u0002&a%\u0011\u0011G\n\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\tg\t\u0012\t\u0011)A\u0005_\u0005\u00191o\u0019\u0011)\u0005I*\u0004CA\n7\u0013\t9DCA\u0005ue\u0006t7/[3oi\")AD\tC\u0001sQ\u0011\u0011E\u000f\u0005\u0006[a\u0002\ra\f\u0005\u0006y\t\"\t!P\u0001\fC\u0012\fWNV\"G\u0019>\fG\rF\u0002?\u0013J\u00032aP!D\u001b\u0005\u0001%BA\u0003'\u0013\t\u0011\u0005IA\u0002S\t\u0012\u0003\"\u0001R$\u000e\u0003\u0015S!A\u0012\u0004\u0002\r5|G-\u001a7t\u0013\tAUI\u0001\bWCJL\u0017M\u001c;D_:$X\r\u001f;\t\u000b)[\u0004\u0019A&\u0002\u0011\u0019LG.\u001a)bi\"\u0004\"\u0001T(\u000f\u0005Mi\u0015B\u0001(\u0015\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001+\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u00059#\u0002bB*<!\u0003\u0005\r\u0001V\u0001\u0005I&\u001cG\u000fE\u0002\u0014+^K!A\u0016\u000b\u0003\r=\u0003H/[8o!\t!\u0005,\u0003\u0002Z\u000b\n\u00112+Z9vK:\u001cW\rR5di&|g.\u0019:z\u0011\u0015Y&\u0005\"\u0001]\u0003U\tG-Y7W\u0007\u001a\u000beN\\8uCRLwN\u001c'pC\u0012$2!\u00184h!\ry\u0014I\u0018\t\u0003?\u0012l\u0011\u0001\u0019\u0006\u0003C\n\fA!\u0019<s_*\u00111\rC\u0001\bM>\u0014X.\u0019;t\u0013\t)\u0007MA\rECR\f'-Y:f-\u0006\u0014\u0018.\u00198u\u0003:tw\u000e^1uS>t\u0007\"\u0002&[\u0001\u0004Y\u0005bB*[!\u0003\u0005\r\u0001\u0016\u0005\u0006S\n\"\tA[\u0001\fC\u0012\fWNV\"G'\u00064X\r\u0006\u0003?W2t\u0007\"\u0002&i\u0001\u0004Y\u0005\"B7i\u0001\u0004q\u0014\u0001\u0003<be&\fg\u000e^:\t\u000fMC\u0007\u0013!a\u0001)\"9\u0001OII\u0001\n\u0003\t\u0018!F1eC646I\u0012'pC\u0012$C-\u001a4bk2$HEM\u000b\u0002e*\u0012Ak]\u0016\u0002iB\u0011QO_\u0007\u0002m*\u0011q\u000f_\u0001\nk:\u001c\u0007.Z2lK\u0012T!!\u001f\u000b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002|m\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000fu\u0014\u0013\u0013!C\u0001c\u0006y\u0012\rZ1n-\u000e3\u0015I\u001c8pi\u0006$\u0018n\u001c8M_\u0006$G\u0005Z3gCVdG\u000f\n\u001a\t\u000f}\u0014\u0013\u0013!C\u0001c\u0006)\u0012\rZ1n-\u000e35+\u0019<fI\u0011,g-Y;mi\u0012\u001a\u0004\"B\u0017\u001f\u0001\u0004y\u0003bBA\u0003\u001f\u0011\r\u0011qA\u0001\u0017e\u0012$Gk\u001c,be&\fg\u000e^\"p]R,\u0007\u0010\u001e*E\tR!\u0011\u0011BA\b!\rq\u00111B\u0005\u0004\u0003\u001b\u0011!A\u0007,be&\fg\u000e^\"p]R,\u0007\u0010\u001e*E\t\u001a+hn\u0019;j_:\u001c\bBB\u0003\u0002\u0004\u0001\u0007a\bC\u0004\u0002\u0014=!\u0019!!\u0006\u0002)I$G\rV8B\t\u0006ku)\u001a8pif\u0004XM\u0015#E)\u0011\t9\"!\b\u0011\u00079\tI\"C\u0002\u0002\u001c\t\u0011AcR3o_RL\b/\u001a*E\t\u001a+hn\u0019;j_:\u001c\bbB\u0003\u0002\u0012\u0001\u0007\u0011q\u0004\t\u0005\u007f\u0005\u000b\t\u0003E\u0002`\u0003GI1!!\na\u0005!9UM\\8usB,\u0007\"CA\u0015\u001f\u0005\u0005I\u0011BA\u0016\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u00055\u0002\u0003BA\u0018\u0003si!!!\r\u000b\t\u0005M\u0012QG\u0001\u0005Y\u0006twM\u0003\u0002\u00028\u0005!!.\u0019<b\u0013\u0011\tY$!\r\u0003\r=\u0013'.Z2u\u0001")
public class ADAMVariationContext
implements Serializable,
Logging {
    private final transient SparkContext sc;
    private transient Logger org$apache$spark$Logging$$log_;

    public static GenotypeRDDFunctions rddToADAMGenotypeRDD(RDD<Genotype> rDD) {
        return ADAMVariationContext$.MODULE$.rddToADAMGenotypeRDD(rDD);
    }

    public static VariantContextRDDFunctions rddToVariantContextRDD(RDD<VariantContext> rDD) {
        return ADAMVariationContext$.MODULE$.rddToVariantContextRDD(rDD);
    }

    public static ADAMVariationContext sparkContextToADAMVariationContext(SparkContext sparkContext) {
        return ADAMVariationContext$.MODULE$.sparkContextToADAMVariationContext(sparkContext);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public SparkContext sc() {
        return this.sc;
    }

    public RDD<VariantContext> adamVCFLoad(String filePath, Option<SequenceDictionary> dict) {
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Reading VCF file from %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        Job job = HadoopUtil$.MODULE$.newJob(this.sc());
        VariantContextConverter vcc = new VariantContextConverter(dict);
        RDD records = this.sc().newAPIHadoopFile(filePath, VCFInputFormat.class, LongWritable.class, VariantContextWritable.class, ContextUtil.getConfiguration((JobContext)job));
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Converted %d records")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)records.count())})));
        return records.flatMap((Function1)new Serializable(this, vcc){
            public static final long serialVersionUID = 0L;
            private final VariantContextConverter vcc$1;

            public final Seq<VariantContext> apply(Tuple2<LongWritable, VariantContextWritable> p) {
                return this.vcc$1.convert(((VariantContextWritable)p._2()).get());
            }
            {
                this.vcc$1 = vcc$1;
            }
        }, ClassTag$.MODULE$.apply(VariantContext.class));
    }

    public Option<SequenceDictionary> adamVCFLoad$default$2() {
        return None$.MODULE$;
    }

    public RDD<DatabaseVariantAnnotation> adamVCFAnnotationLoad(String filePath, Option<SequenceDictionary> dict) {
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Reading VCF file from %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        Job job = HadoopUtil$.MODULE$.newJob(this.sc());
        VariantContextConverter vcc = new VariantContextConverter(dict);
        RDD records = this.sc().newAPIHadoopFile(filePath, VCFInputFormat.class, LongWritable.class, VariantContextWritable.class, ContextUtil.getConfiguration((JobContext)job));
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Converted %d records")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)records.count())})));
        return records.map((Function1)new Serializable(this, vcc){
            public static final long serialVersionUID = 0L;
            private final VariantContextConverter vcc$2;

            public final DatabaseVariantAnnotation apply(Tuple2<LongWritable, VariantContextWritable> p) {
                return this.vcc$2.convertToAnnotation(((VariantContextWritable)p._2()).get());
            }
            {
                this.vcc$2 = vcc$2;
            }
        }, ClassTag$.MODULE$.apply(DatabaseVariantAnnotation.class));
    }

    public Option<SequenceDictionary> adamVCFAnnotationLoad$default$2() {
        return None$.MODULE$;
    }

    public RDD<VariantContext> adamVCFSave(String filePath, RDD<VariantContext> variants, Option<SequenceDictionary> dict) {
        VCFFormat vcfFormat;
        VCFFormat vCFFormat = vcfFormat = VCFFormat.inferFromFilePath((String)filePath);
        VCFFormat vCFFormat2 = VCFFormat.VCF;
        Predef$.MODULE$.assert(!(vCFFormat != null ? !vCFFormat.equals(vCFFormat2) : vCFFormat2 != null), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "BCF not yet supported";
            }
        });
        variants.cache();
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Writing %s file to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{vcfFormat, filePath})));
        List<String> header2 = ADAMVariationContext$.MODULE$.rddToVariantContextRDD(variants).adamGetCallsetSamples();
        Broadcast bcastHeader = this.sc().broadcast(header2, ClassTag$.MODULE$.apply(List.class));
        long mp = variants.mapPartitionsWithIndex((Function2)new Serializable(this, bcastHeader){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMVariationContext $outer;
            private final Broadcast bcastHeader$1;

            public final Iterator<Object> apply(int idx, Iterator<VariantContext> iter) {
                this.$outer.log().warn(new StringBuilder().append((Object)"Setting header for partition ").append((Object)BoxesRunTime.boxToInteger((int)idx)).toString());
                ADAMVariationContext aDAMVariationContext = this.$outer;
                synchronized (aDAMVariationContext) {
                    ADAMVCFOutputFormat$.MODULE$.setHeader((Seq<String>)((Seq)this.bcastHeader$1.value()));
                    this.$outer.log().warn(new StringBuilder().append((Object)"Set VCF header for partition ").append((Object)BoxesRunTime.boxToInteger((int)idx)).toString());
                    return package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.bcastHeader$1 = bcastHeader$1;
            }
        }, variants.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.Int()).count();
        if (mp != 0L) {
            this.log().warn("Had more than 0 elements after map partitions call to set VCF header across cluster.");
        }
        VariantContextConverter converter = new VariantContextConverter(dict);
        RDD gatkVCs = variants.map((Function1)new Serializable(this, converter){
            public static final long serialVersionUID = 0L;
            private final VariantContextConverter converter$1;

            /*
             * WARNING - void declaration
             */
            public final VariantContextWritable apply(VariantContext v) {
                void var2_2;
                VariantContextWritable vcw = new VariantContextWritable();
                vcw.set(this.converter$1.convert(v));
                return var2_2;
            }
            {
                this.converter$1 = converter$1;
            }
        }, ClassTag$.MODULE$.apply(VariantContextWritable.class));
        RDD withKey = gatkVCs.keyBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final LongWritable apply(VariantContextWritable v) {
                return new LongWritable((long)v.get().getStart());
            }
        });
        Configuration conf = this.sc().hadoopConfiguration();
        conf.set("hadoopbam.vcf.output-format", vcfFormat.toString());
        SparkContext$.MODULE$.rddToPairRDDFunctions(withKey, ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(VariantContextWritable.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms())).saveAsNewAPIHadoopFile(filePath, LongWritable.class, VariantContextWritable.class, ADAMVCFOutputFormat.class, conf);
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Write %d records")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)gatkVCs.count())})));
        return variants.unpersist(variants.unpersist$default$1());
    }

    public Option<SequenceDictionary> adamVCFSave$default$3() {
        return None$.MODULE$;
    }

    public ADAMVariationContext(SparkContext sc) {
        this.sc = sc;
        Logging.class.$init$((Logging)this);
    }
}

