/**
 * Licensed to Big Data Genomics (BDG) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The BDG licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.bdgenomics.adam.predicates

import org.bdgenomics.adam.projections.AlignmentRecordField
import org.bdgenomics.formats.avro.AlignmentRecord

object AlignmentRecordConditions {

  def apply(field: AlignmentRecordField.Value, bool: Boolean = true): RecordCondition[AlignmentRecord] = {
    RecordCondition[AlignmentRecord](FieldCondition(field, bool))
  }

  def apply(field: AlignmentRecordField.Value, filter: Int => Boolean): RecordCondition[AlignmentRecord] = {
    RecordCondition[AlignmentRecord](FieldCondition(field.toString, filter))
  }

  val isMapped = apply(AlignmentRecordField.readMapped)
  val isUnique = apply(AlignmentRecordField.duplicateRead, false)

  val isPrimaryAlignment = apply(AlignmentRecordField.primaryAlignment)

  val passedVendorQualityChecks = apply(AlignmentRecordField.failedVendorQualityChecks, false)

  def isHighQuality(minQuality: Int) = apply(AlignmentRecordField.mapq, (x: Int) => x > minQuality)

}
