/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.converters;

import htsjdk.samtools.SAMRecord;
import org.bdgenomics.adam.converters.AlignmentRecordConverter;
import org.bdgenomics.adam.models.RecordGroupDictionary;
import org.bdgenomics.adam.models.SAMFileHeaderWritable$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceDictionary$;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.formats.avro.Contig;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E3A!\u0001\u0002\u0001\u0017\ti\u0012\t\\5h]6,g\u000e\u001e*fG>\u0014HmQ8om\u0016\u0014H/\u001a:Tk&$XM\u0003\u0002\u0004\t\u0005Q1m\u001c8wKJ$XM]:\u000b\u0005\u00151\u0011\u0001B1eC6T!a\u0002\u0005\u0002\u0015\t$w-\u001a8p[&\u001c7OC\u0001\n\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taB\u0003\u0002\u0010\u0011\u0005I1oY1mCR,7\u000f^\u0005\u0003#9\u0011\u0001BR;o'VLG/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\tAq\u0001\u0007\u0001C\u0002\u0013\u0005\u0011$A\nbI\u0006l'+Z2pe\u0012\u001cuN\u001c<feR,'/F\u0001\u001b!\t12$\u0003\u0002\u001d\u0005\tA\u0012\t\\5h]6,g\u000e\u001e*fG>\u0014HmQ8om\u0016\u0014H/\u001a:\t\ry\u0001\u0001\u0015!\u0003\u001b\u0003Q\tG-Y7SK\u000e|'\u000fZ\"p]Z,'\u000f^3sA!)\u0001\u0005\u0001C\u0001C\u0005IQ.Y6f?J,\u0017\r\u001a\u000b\u0007E)\u00124(\u0010\"\u0011\u0005\rBS\"\u0001\u0013\u000b\u0005\u00152\u0013\u0001B1we>T!a\n\u0004\u0002\u000f\u0019|'/\\1ug&\u0011\u0011\u0006\n\u0002\u0010\u00032LwM\\7f]R\u0014VmY8sI\")1f\ba\u0001Y\u0005)1\u000f^1siB\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t!Aj\u001c8h\u0011\u0015\u0019t\u00041\u00015\u0003\u0015\u0019\u0017nZ1s!\t)\u0004H\u0004\u0002.m%\u0011qGL\u0001\u0007!J,G-\u001a4\n\u0005eR$AB*ue&twM\u0003\u00028]!)Ah\ba\u0001i\u0005)Q\u000e\u001a;bO\")ah\ba\u0001\u007f\u00051A.\u001a8hi\"\u0004\"!\f!\n\u0005\u0005s#aA%oi\"91i\bI\u0001\u0002\u0004y\u0014AA5e\u0011\u001d)\u0005!%A\u0005\u0002\u0019\u000b1#\\1lK~\u0013X-\u00193%I\u00164\u0017-\u001e7uIU*\u0012a\u0012\u0016\u0003\u007f![\u0013!\u0013\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u00059s\u0013AC1o]>$\u0018\r^5p]&\u0011\u0001k\u0013\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class AlignmentRecordConverterSuite
extends FunSuite {
    private final AlignmentRecordConverter adamRecordConverter = new AlignmentRecordConverter();

    public AlignmentRecordConverter adamRecordConverter() {
        return this.adamRecordConverter;
    }

    public AlignmentRecord make_read(long start, String cigar, String mdtag, int length, int id) {
        Predef$ predef$ = Predef$.MODULE$;
        String sequence = new StringOps("A").$times(length);
        return AlignmentRecord.newBuilder().setReadName(new StringBuilder().append((Object)"read").append((Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString()).toString()).setStart(Predef$.MODULE$.long2Long(start)).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar(cigar).setSequence(sequence).setReadNegativeStrand(Predef$.MODULE$.boolean2Boolean(false)).setMapq(Predef$.MODULE$.int2Integer(60)).setQual(sequence).setMismatchingPositions(mdtag).setOldPosition(Predef$.MODULE$.long2Long(12L)).setOldCigar("2^AAA3").build();
    }

    public int make_read$default$5() {
        return 0;
    }

    public AlignmentRecordConverterSuite() {
        this.test("testing the fields in a converted ADAM Read", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AlignmentRecordConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord adamRead = this.$outer.make_read(3L, "2M3D2M", "2^AAA2", 4, this.$outer.make_read$default$5());
                adamRead.setRecordGroupName("testname");
                adamRead.setContig(Contig.newBuilder().setContigName("referencetest").build());
                adamRead.setMateContig(Contig.newBuilder().setContigName("matereferencetest").setContigLength(Predef$.MODULE$.long2Long(6L)).setReferenceURL("test://chrom1").build());
                adamRead.setMateAlignmentStart(Predef$.MODULE$.long2Long(6L));
                SequenceRecord seqRecForDict = SequenceRecord$.MODULE$.apply("referencetest", 5L, "test://chrom1", SequenceRecord$.MODULE$.apply$default$4(), SequenceRecord$.MODULE$.apply$default$5(), SequenceRecord$.MODULE$.apply$default$6(), SequenceRecord$.MODULE$.apply$default$7(), SequenceRecord$.MODULE$.apply$default$8());
                SequenceDictionary dict = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{seqRecForDict}));
                RecordGroupDictionary readGroups = new RecordGroupDictionary((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                SAMRecord toSAM = this.$outer.adamRecordConverter().convert(adamRead, SAMFileHeaderWritable$.MODULE$.apply(this.$outer.adamRecordConverter().createSAMHeader(dict, readGroups)));
                Predef$ predef$ = Predef$.MODULE$;
                String sequence = new StringOps("A").$times(4);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(toSAM.getReadName());
                String $org_scalatest_assert_macro_right = new StringBuilder().append((Object)"read").append((Object)((Object)BoxesRunTime.boxToInteger((int)0)).toString()).toString();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)toSAM.getAlignmentStart()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)4), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)toSAM.getReadUnmappedFlag()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToBoolean((boolean)false), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)false), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(toSAM.getCigarString());
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)"2M3D2M", $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)"2M3D2M", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(toSAM.getReadString());
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)sequence, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)sequence, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToBoolean((boolean)toSAM.getReadNegativeStrandFlag()));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToBoolean((boolean)false), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToBoolean((boolean)false), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)toSAM.getMappingQuality()));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)60), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)60), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(toSAM.getBaseQualityString());
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)sequence, $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)sequence, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left9 = this.$outer.convertToEqualizer(toSAM.getAttribute("MD"));
                Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "===", (Object)"2^AAA2", $org_scalatest_assert_macro_left9.$eq$eq$eq((Object)"2^AAA2", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left10 = this.$outer.convertToEqualizer(toSAM.getIntegerAttribute("OP"));
                Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "===", (Object)BoxesRunTime.boxToInteger((int)13), $org_scalatest_assert_macro_left10.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)13), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left11 = this.$outer.convertToEqualizer(toSAM.getStringAttribute("OC"));
                Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "===", (Object)"2^AAA3", $org_scalatest_assert_macro_left11.$eq$eq$eq((Object)"2^AAA3", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("convert a read to fastq", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AlignmentRecordConverterSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord adamRead = AlignmentRecord.newBuilder().setSequence("ACACCAACATG").setQual(".+**.+;:**.").setReadName("thebestread").build();
                String string = this.$outer.adamRecordConverter().convertToFastq(adamRead, this.$outer.adamRecordConverter().convertToFastq$default$2()).toString();
                Predef$ predef$ = Predef$.MODULE$;
                String[] fastq = new StringOps(string).split('\n');
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(fastq[0]);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"@thebestread", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"@thebestread", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(fastq[1]);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)"ACACCAACATG", $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)"ACACCAACATG", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(fastq[2]);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)"+", $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)"+", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(fastq[3]);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)".+**.+;:**.", $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)".+**.+;:**.", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

