/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.models;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Level;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.models.CDS;
import org.bdgenomics.adam.models.Exon;
import org.bdgenomics.adam.models.Gene;
import org.bdgenomics.adam.models.GeneSuite$;
import org.bdgenomics.adam.models.GeneSuite$$anonfun$3$;
import org.bdgenomics.adam.models.Transcript;
import org.bdgenomics.adam.models.UTR;
import org.bdgenomics.adam.rdd.features.FeaturesContext$;
import org.bdgenomics.adam.rdd.features.GeneFeatureRDD$;
import org.bdgenomics.adam.util.SparkFunSuite;
import org.bdgenomics.adam.util.SparkFunSuite$class;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001=2A!\u0001\u0002\u0001\u0017\tIq)\u001a8f'VLG/\u001a\u0006\u0003\u0007\u0011\ta!\\8eK2\u001c(BA\u0003\u0007\u0003\u0011\tG-Y7\u000b\u0005\u001dA\u0011A\u00032eO\u0016tw.\\5dg*\t\u0011\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u0019I\u0001\"!\u0004\t\u000e\u00039Q!a\u0004\u0005\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018BA\t\u000f\u0005!1UO\\*vSR,\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0011)H/\u001b7\n\u0005]!\"!D*qCJ\\g)\u001e8Tk&$X\rC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0005!)a\u0004\u0001C\u0001?\u0005iAn\\1e\u000fjL\u0007\u000f]3e\r\u0006$\"\u0001I\u0017\u0011\t\u0005:#F\u000b\b\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011aeI\u0001\u0007!J,G-\u001a4\n\u0005!J#aA'ba*\u0011ae\t\t\u0003C-J!\u0001L\u0015\u0003\rM#(/\u001b8h\u0011\u0015qS\u00041\u0001+\u0003\u0011\u0001\u0018\r\u001e5")
public class GeneSuite
extends FunSuite
implements SparkFunSuite {
    private SparkContext sc;
    private Option<Map<String, Level>> maybeLevels;
    private final String appName;
    private final String master;
    private final Map<String, String> properties;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public Option<Map<String, Level>> maybeLevels() {
        return this.maybeLevels;
    }

    @Override
    public void maybeLevels_$eq(Option<Map<String, Level>> x$1) {
        this.maybeLevels = x$1;
    }

    @Override
    public String appName() {
        return this.appName;
    }

    @Override
    public String master() {
        return this.master;
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    @Override
    public void org$bdgenomics$adam$util$SparkFunSuite$_setter_$appName_$eq(String x$1) {
        this.appName = x$1;
    }

    @Override
    public void org$bdgenomics$adam$util$SparkFunSuite$_setter_$master_$eq(String x$1) {
        this.master = x$1;
    }

    @Override
    public void org$bdgenomics$adam$util$SparkFunSuite$_setter_$properties_$eq(Map x$1) {
        this.properties = x$1;
    }

    @Override
    public void setupSparkContext(String sparkName, boolean silenceSpark) {
        SparkFunSuite$class.setupSparkContext(this, sparkName, silenceSpark);
    }

    @Override
    public void teardownSparkContext() {
        SparkFunSuite$class.teardownSparkContext(this);
    }

    @Override
    public void sparkBefore(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkBefore(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkAfter(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkAfter(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkTest(String name, boolean silenceSpark, Seq<Tag> tags, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, silenceSpark, tags, body);
    }

    @Override
    public void sparkTest(String name, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, body);
    }

    @Override
    public String testFile(String name) {
        return SparkFunSuite$class.testFile(this, name);
    }

    @Override
    public boolean sparkBefore$default$2() {
        return SparkFunSuite$class.sparkBefore$default$2(this);
    }

    @Override
    public boolean setupSparkContext$default$2() {
        return SparkFunSuite$class.setupSparkContext$default$2(this);
    }

    @Override
    public boolean sparkAfter$default$2() {
        return SparkFunSuite$class.sparkAfter$default$2(this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public Map<String, String> loadGzippedFa(String path) {
        scala.collection.mutable.Map buildable = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ObjectRef current = new ObjectRef(null);
        GZIPInputStream fis = new GZIPInputStream(new FileInputStream(new File(path)));
        Source$.MODULE$.fromInputStream((InputStream)fis, Codec$.MODULE$.fallbackSystemCodec()).getLines().foreach((Function1)new Serializable(this, buildable, current){
            public static final long serialVersionUID = 0L;
            private final scala.collection.mutable.Map buildable$1;
            private final ObjectRef current$1;

            public final Object apply(String line) {
                BoxedUnit boxedUnit;
                if (line.startsWith(">")) {
                    this.current$1.elem = line.substring(1, line.length());
                    boxedUnit = this.buildable$1.put((Object)((String)this.current$1.elem), (Object)new StringBuilder());
                } else {
                    Option option = this.buildable$1.get((Object)((String)this.current$1.elem));
                    if (!option.isEmpty()) {
                        ((StringBuilder)option.get()).append(line.trim());
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            {
                this.buildable$1 = buildable$1;
                this.current$1 = current$1;
            }
        });
        return ((TraversableOnce)buildable.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple2<String, StringBuilder> x0$1) {
                if (x0$1 != null && x0$1._1() != null) {
                    String string = (String)x0$1._1();
                    if (x0$1._2() != null) {
                        StringBuilder stringBuilder = (StringBuilder)x0$1._2();
                        return new Tuple2((Object)string, (Object)stringBuilder.toString());
                    }
                }
                throw new MatchError(x0$1);
            }
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public GeneSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        SparkFunSuite$class.$init$(this);
        this.sparkTest("can load a set of gene models from an Ensembl GTF file", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeneSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String path = this.$outer.testFile("features/Homo_sapiens.GRCh37.75.trun100.gtf");
                RDD features = FeaturesContext$.MODULE$.sparkContextToADAMFeaturesContext(this.$outer.sc()).adamGTFFeatureLoad(path);
                RDD genes = GeneFeatureRDD$.MODULE$.convertBaseFeatureRDDToGeneFeatureRDD(features).asGenes();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)genes.count()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)4), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                RDD transcripts = genes.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Transcript> apply(Gene x$1) {
                        return x$1.transcripts();
                    }
                }, ClassTag$.MODULE$.apply(Transcript.class));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)transcripts.count()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)13), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)13), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                RDD exons = transcripts.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Exon> apply(Transcript x$2) {
                        return x$2.exons();
                    }
                }, ClassTag$.MODULE$.apply(Exon.class));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)exons.count()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)78), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)78), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("can load a set of gene models from a Gencode GTF file", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeneSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String path = this.$outer.testFile("features/gencode.v19.annotation.chr20.250k.gtf");
                RDD features = FeaturesContext$.MODULE$.sparkContextToADAMFeaturesContext(this.$outer.sc()).adamGTFFeatureLoad(path);
                RDD genes = GeneFeatureRDD$.MODULE$.convertBaseFeatureRDDToGeneFeatureRDD(features).asGenes();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)genes.count()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)8), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)8), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                RDD transcripts = genes.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Transcript> apply(Gene x$3) {
                        return x$3.transcripts();
                    }
                }, ClassTag$.MODULE$.apply(Transcript.class));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)transcripts.count()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)10), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                RDD exons = transcripts.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Exon> apply(Transcript x$4) {
                        return x$4.exons();
                    }
                }, ClassTag$.MODULE$.apply(Exon.class));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)exons.count()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)20), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)20), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                RDD cds = transcripts.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<CDS> apply(Transcript x$5) {
                        return x$5.cds();
                    }
                }, ClassTag$.MODULE$.apply(CDS.class));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)cds.count()));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)12), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)12), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                RDD utrs = transcripts.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<UTR> apply(Transcript x$6) {
                        return x$6.utrs();
                    }
                }, ClassTag$.MODULE$.apply(UTR.class));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)utrs.count()));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)11), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)11), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("chr20 gencode transcript sequences match the published sequences", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ GeneSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String path = this.$outer.testFile("features/gencode.v19.annotation.chr20.250k.gtf");
                String chr20path = this.$outer.testFile("chr20.250k.fa.gz");
                String gencodeTranscriptsFa = this.$outer.testFile("gencode.v19.pc_transcripts.250k.fa.gz");
                Option chr20sequence = this.$outer.loadGzippedFa(chr20path).values().headOption();
                Map gencodeTranscripts = (Map)this.$outer.loadGzippedFa(gencodeTranscriptsFa).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, String> apply(Tuple2<String, String> x0$2) {
                        if (x0$2 != null && x0$2._1() != null) {
                            String string = (String)x0$2._1();
                            if (x0$2._2() != null) {
                                String string2 = (String)x0$2._2();
                                return new Tuple2(Predef$.MODULE$.refArrayOps((Object[])string.split("\\|")).head(), (Object)string2);
                            }
                        }
                        throw new MatchError(x0$2);
                    }
                }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
                RDD features = FeaturesContext$.MODULE$.sparkContextToADAMFeaturesContext(this.$outer.sc()).adamGTFFeatureLoad(path);
                RDD genes = GeneFeatureRDD$.MODULE$.convertBaseFeatureRDDToGeneFeatureRDD(features).asGenes();
                WrappedArray transcripts = Predef$.MODULE$.wrapRefArray((Object[])genes.flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<Transcript> apply(Gene g) {
                        return g.transcripts();
                    }
                }, ClassTag$.MODULE$.apply(Transcript.class)).take(100));
                transcripts.foreach((Function1)new Serializable(this, chr20sequence, gencodeTranscripts){
                    public static final long serialVersionUID = 0L;
                    public final /* synthetic */ $anonfun$3 $outer;
                    private final Option chr20sequence$1;
                    private final Map gencodeTranscripts$1;

                    /*
                     * Handled impossible loop by adding 'first' condition
                     * Enabled aggressive block sorting
                     */
                    public final void apply(Transcript transcript) {
                        String mySequence = transcript.extractSplicedmRNASequence((String)this.chr20sequence$1.get());
                        Option gencodeSequence = this.gencodeTranscripts$1.get((Object)transcript.id());
                        if (!gencodeSequence.isDefined()) return;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(gencodeSequence.isDefined(), "gencodeSequence.isDefined");
                        Predef$ predef$ = Predef$.MODULE$;
                        this.$outer.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringOps("Transcript %s doesn't have a gencode seq").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transcript.id()})));
                        String gseq = (String)gencodeSequence.get();
                        Seq exonLengths = (Seq)((TraversableLike)(transcript.strand() ? transcript.exons().toSeq().sortBy((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(Exon x$8) {
                                return x$8.region().start();
                            }
                        }, (Ordering)Ordering.Long$.MODULE$) : ((SeqLike)transcript.exons().toSeq().sortBy((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(Exon x$9) {
                                return x$9.region().start();
                            }
                        }, (Ordering)Ordering.Long$.MODULE$)).reverse())).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply(Exon x$10) {
                                return x$10.region().length();
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Seq exonStarts = (Seq)exonLengths.scanLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(int sum, long v) {
                                return sum + (int)v;
                            }

                            public int apply$mcIIJ$sp(int sum, long v) {
                                return sum + (int)v;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        String[] gseqExons = (String[])((TraversableOnce)((TraversableLike)exonStarts.zip((GenIterable)exonLengths, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, gseq){
                            public static final long serialVersionUID = 0L;
                            private final String gseq$1;

                            public final String apply(Tuple2<Object, Object> x0$3) {
                                if (x0$3 != null) {
                                    return this.gseq$1.substring(x0$3._1$mcI$sp(), x0$3._1$mcI$sp() + (int)x0$3._2$mcJ$sp());
                                }
                                throw new MatchError(x0$3);
                            }
                            {
                                this.gseq$1 = gseq$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                        String[] myExons = (String[])((TraversableOnce)((TraversableLike)exonStarts.zip((GenIterable)exonLengths, Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this, mySequence){
                            public static final long serialVersionUID = 0L;
                            private final String mySequence$1;

                            public final String apply(Tuple2<Object, Object> x0$4) {
                                if (x0$4 != null) {
                                    return this.mySequence$1.substring(x0$4._1$mcI$sp(), x0$4._1$mcI$sp() + (int)x0$4._2$mcJ$sp());
                                }
                                throw new MatchError(x0$4);
                            }
                            {
                                this.mySequence$1 = mySequence$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)gseqExons.length));
                        int $org_scalatest_assert_macro_right = myExons.length;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                        this.$outer.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                        Predef$ predef$2 = Predef$.MODULE$;
                        Serializable serializable = new Serializable(this, gseqExons, myExons){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$3$$anonfun$apply$mcV$sp$1 $outer;
                            private final String[] gseqExons$1;
                            private final String[] myExons$1;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.$outer.$outer.convertToEqualizer(this.myExons$1[i]);
                                String $org_scalatest_assert_macro_right = this.gseqExons$1[i];
                                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                                Predef$ predef$ = Predef$.MODULE$;
                                this.$outer.$outer.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringOps("Exons %d don't match").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.gseqExons$1 = gseqExons$1;
                                this.myExons$1 = myExons$1;
                            }
                        };
                        Range range = RichInt$.MODULE$.until$extension0(0, myExons.length);
                        boolean bl = true;
                        while (true) {
                            int n;
                            int n2;
                            block5: {
                                block4: {
                                    int n3;
                                    block3: {
                                        if (!bl || (bl = false)) break block3;
                                        if (!range.validateRangeBoundaries((Function1)serializable)) break block4;
                                        n2 = range.start();
                                        n3 = range.terminalElement();
                                        n = range.step();
                                    }
                                    if (n2 != n3) break block5;
                                }
                                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.org$bdgenomics$adam$models$GeneSuite$$anonfun$$$outer().convertToEqualizer(mySequence);
                                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)gseq, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)gseq, Equality$.MODULE$.default()));
                                Predef$ predef$3 = Predef$.MODULE$;
                                this.$outer.org$bdgenomics$adam$models$GeneSuite$$anonfun$$$outer().assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)new StringOps("Transcript %s (%s:%d-%d:%s) didn't match: \n%s\ndidn't match gencode\n%s\n").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transcript.id(), transcript.region().referenceName(), BoxesRunTime.boxToLong((long)transcript.region().start()), BoxesRunTime.boxToLong((long)transcript.region().end()), BoxesRunTime.boxToBoolean((boolean)transcript.strand()), mySequence, !gencodeSequence.isEmpty() ? gencodeSequence.get() : "NO SEQUENCE"})));
                                return;
                            }
                            serializable.apply$mcVI$sp(n2);
                            n2 += n;
                        }
                    }

                    public /* synthetic */ $anonfun$3 org$bdgenomics$adam$models$GeneSuite$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.chr20sequence$1 = chr20sequence$1;
                        this.gencodeTranscripts$1 = gencodeTranscripts$1;
                    }
                });
            }

            public /* synthetic */ GeneSuite org$bdgenomics$adam$models$GeneSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

