/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.models;

import htsjdk.samtools.SAMReadGroupRecord;
import org.bdgenomics.adam.models.RecordGroup;
import org.bdgenomics.adam.models.RecordGroup$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]1A!\u0001\u0002\u0001\u0017\tQ\"+Z2pe\u0012<%o\\;q\t&\u001cG/[8oCJL8+^5uK*\u00111\u0001B\u0001\u0007[>$W\r\\:\u000b\u0005\u00151\u0011\u0001B1eC6T!a\u0002\u0005\u0002\u0015\t$w-\u001a8p[&\u001c7OC\u0001\n\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taB\u0003\u0002\u0010\u0011\u0005I1oY1mCR,7\u000f^\u0005\u0003#9\u0011\u0001BR;o'VLG/\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003U\u0001\"A\u0006\u0001\u000e\u0003\t\u0001")
public class RecordGroupDictionarySuite
extends FunSuite {
    public RecordGroupDictionarySuite() {
        this.test("simple conversion to and from sam read group", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecordGroupDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String $org_scalatest_assert_macro_left;
                String $org_scalatest_assert_macro_left2;
                SAMReadGroupRecord origSAMRGR = new SAMReadGroupRecord("myId");
                origSAMRGR.setSample("mySample");
                RecordGroup rg = RecordGroup$.MODULE$.apply(origSAMRGR);
                String string = $org_scalatest_assert_macro_left2 = rg.sample();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)"mySample", !(string != null ? !string.equals("mySample") : "mySample" != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                String string2 = $org_scalatest_assert_macro_left = rg.recordGroupName();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)"myId", !(string2 != null ? !string2.equals("myId") : "myId" != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                SAMReadGroupRecord newSAMRGR = rg.toSAMReadGroupRecord();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(origSAMRGR.equals((Object)newSAMRGR), "origSAMRGR.equals(newSAMRGR)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sample name must be set", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecordGroupDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SAMReadGroupRecord samRGR = new SAMReadGroupRecord("myId");
                this.$outer.intercept((Function0)new Serializable(this, samRGR){
                    public static final long serialVersionUID = 0L;
                    private final SAMReadGroupRecord samRGR$1;

                    public final RecordGroup apply() {
                        return RecordGroup$.MODULE$.apply(this.samRGR$1);
                    }
                    {
                        this.samRGR$1 = samRGR$1;
                    }
                }, ManifestFactory$.MODULE$.classType(AssertionError.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create a record group from a read", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecordGroupDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord ar = AlignmentRecord.newBuilder().setRecordGroupSample("mySample").setRecordGroupName("myName").build();
                Option rg = RecordGroup$.MODULE$.apply(ar);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rg.isDefined(), "rg.isDefined");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(((RecordGroup)rg.get()).sample());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"mySample", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"mySample", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(((RecordGroup)rg.get()).recordGroupName());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)"myName", $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)"myName", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("don't create a record group from a read without record group info", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecordGroupDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord ar = AlignmentRecord.newBuilder().build();
                Option rg = RecordGroup$.MODULE$.apply(ar);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)rg, "isEmpty", rg.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("simple equality checks", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RecordGroupDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RecordGroup rg1a = new RecordGroup("me", "rg1", RecordGroup$.MODULE$.$lessinit$greater$default$3(), RecordGroup$.MODULE$.$lessinit$greater$default$4(), RecordGroup$.MODULE$.$lessinit$greater$default$5(), RecordGroup$.MODULE$.$lessinit$greater$default$6(), RecordGroup$.MODULE$.$lessinit$greater$default$7(), RecordGroup$.MODULE$.$lessinit$greater$default$8(), RecordGroup$.MODULE$.$lessinit$greater$default$9(), RecordGroup$.MODULE$.$lessinit$greater$default$10(), RecordGroup$.MODULE$.$lessinit$greater$default$11());
                Option rg1b = RecordGroup$.MODULE$.apply(AlignmentRecord.newBuilder().setRecordGroupSample("me").setRecordGroupName("rg1").build());
                RecordGroup rg2 = new RecordGroup("me", "rg2", RecordGroup$.MODULE$.$lessinit$greater$default$3(), RecordGroup$.MODULE$.$lessinit$greater$default$4(), RecordGroup$.MODULE$.$lessinit$greater$default$5(), RecordGroup$.MODULE$.$lessinit$greater$default$6(), RecordGroup$.MODULE$.$lessinit$greater$default$7(), RecordGroup$.MODULE$.$lessinit$greater$default$8(), RecordGroup$.MODULE$.$lessinit$greater$default$9(), RecordGroup$.MODULE$.$lessinit$greater$default$10(), RecordGroup$.MODULE$.$lessinit$greater$default$11());
                RecordGroup rg3 = new RecordGroup("you", "rg1", RecordGroup$.MODULE$.$lessinit$greater$default$3(), RecordGroup$.MODULE$.$lessinit$greater$default$4(), RecordGroup$.MODULE$.$lessinit$greater$default$5(), RecordGroup$.MODULE$.$lessinit$greater$default$6(), RecordGroup$.MODULE$.$lessinit$greater$default$7(), RecordGroup$.MODULE$.$lessinit$greater$default$8(), RecordGroup$.MODULE$.$lessinit$greater$default$9(), RecordGroup$.MODULE$.$lessinit$greater$default$10(), RecordGroup$.MODULE$.$lessinit$greater$default$11());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(rg1a.equals((Object)rg1a), "rg1a.equals(rg1a)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(rg1a.sample());
                String $org_scalatest_assert_macro_right = ((RecordGroup)rg1b.get()).sample();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(rg1a.recordGroupName());
                String $org_scalatest_assert_macro_right2 = ((RecordGroup)rg1b.get()).recordGroupName();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(rg1a.equals((Object)rg1b), "rg1a.equals(rg1b)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(rg1a.equals(rg1b.get()), "rg1a.equals(rg1b.get)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(rg1a.equals((Object)rg2), "rg1a.equals(rg2)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(rg1a.equals((Object)rg3), "rg1a.equals(rg3)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

