/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.models;

import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferencePosition$;
import org.bdgenomics.adam.models.ReferencePositionWithOrientation;
import org.bdgenomics.adam.models.ReferencePositionWithOrientation$;
import org.bdgenomics.adam.models.ReferenceRegionWithOrientation;
import org.bdgenomics.adam.models.ReferenceRegionWithOrientation$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.formats.avro.Contig;
import org.bdgenomics.formats.avro.Genotype;
import org.bdgenomics.formats.avro.Pileup;
import org.bdgenomics.formats.avro.Variant;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]1A!\u0001\u0002\u0001\u0017\t1\"+\u001a4fe\u0016t7-\u001a)pg&$\u0018n\u001c8Tk&$XM\u0003\u0002\u0004\t\u00051Qn\u001c3fYNT!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\ty\u0001\"A\u0005tG\u0006d\u0017\r^3ti&\u0011\u0011C\u0004\u0002\t\rVt7+^5uK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001")
public class ReferencePositionSuite
extends FunSuite {
    public ReferencePositionSuite() {
        this.test("create reference position from mapped read", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig contig = Contig.newBuilder().setContigName("chr1").build();
                AlignmentRecord read = AlignmentRecord.newBuilder().setContig(contig).setStart(Predef$.MODULE$.long2Long(1L)).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).build();
                Option refPosOpt = ReferencePosition$.MODULE$.apply(read);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(refPosOpt.isDefined(), "refPosOpt.isDefined");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                ReferencePosition refPos = (ReferencePosition)refPosOpt.get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(refPos.referenceName());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"chr1", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"chr1", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)refPos.pos()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)1L), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)1L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create reference position from unmapped read", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord read = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(false)).build();
                Option refPosOpt = ReferencePosition$.MODULE$.apply(read);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)refPosOpt, "isEmpty", refPosOpt.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create reference position from mapped read but contig not specified", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord read = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setStart(Predef$.MODULE$.long2Long(1L)).build();
                Option refPosOpt = ReferencePosition$.MODULE$.apply(read);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)refPosOpt, "isEmpty", refPosOpt.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create reference position from mapped read but contig is underspecified", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig contig = Contig.newBuilder().build();
                AlignmentRecord read = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setStart(Predef$.MODULE$.long2Long(1L)).setContig(contig).build();
                Option refPosOpt = ReferencePosition$.MODULE$.apply(read);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)refPosOpt, "isEmpty", refPosOpt.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create reference position from mapped read but start not specified", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig contig = Contig.newBuilder().setContigName("chr1").build();
                AlignmentRecord read = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setContig(contig).build();
                Option refPosOpt = ReferencePosition$.MODULE$.apply(read);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)refPosOpt, "isEmpty", refPosOpt.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create reference position from pileup", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig contig = Contig.newBuilder().setContigName("chr2").build();
                Pileup pileup = Pileup.newBuilder().setPosition(Predef$.MODULE$.long2Long(2L)).setContig(contig).build();
                ReferencePosition refPos = ReferencePosition$.MODULE$.apply(pileup);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(refPos.referenceName());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"chr2", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"chr2", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)refPos.pos()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)2L), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)2L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create reference position from variant", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Variant variant = Variant.newBuilder().setContig(Contig.newBuilder().setContigName("chr10").build()).setReferenceAllele("A").setAlternateAllele("T").setStart(Predef$.MODULE$.long2Long(10L)).build();
                ReferencePosition refPos = ReferencePosition$.MODULE$.apply(variant);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(refPos.referenceName());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"chr10", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"chr10", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)refPos.pos()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)10L), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)10L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create reference position from genotype", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Variant variant = Variant.newBuilder().setStart(Predef$.MODULE$.long2Long(100L)).setContig(Contig.newBuilder().setContigName("chr10").build()).setReferenceAllele("A").setAlternateAllele("T").build();
                Genotype genotype = Genotype.newBuilder().setVariant(variant).setSampleId("NA12878").build();
                ReferencePosition refPos = ReferencePosition$.MODULE$.apply(genotype);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(refPos.referenceName());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"chr10", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"chr10", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)refPos.pos()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)100L), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)100L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("liftOverToReference works with a multi-block alignment on the forward strand", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq exons = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReferenceRegionWithOrientation[]{ReferenceRegionWithOrientation$.MODULE$.apply("1", 100L, 200L, false), ReferenceRegionWithOrientation$.MODULE$.apply("1", 300L, 400L, false), ReferenceRegionWithOrientation$.MODULE$.apply("1", 500L, 600L, false)}));
                ReferencePositionWithOrientation p0 = ReferencePositionWithOrientation$.MODULE$.liftOverToReference(0L, exons);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(p0.refPos().referenceName());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"1", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"1", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)p0.refPos().pos()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)100), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)100), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                ReferencePositionWithOrientation p1 = ReferencePositionWithOrientation$.MODULE$.liftOverToReference(50L, exons);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(p1.refPos().referenceName());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)"1", $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)"1", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)p1.refPos().pos()));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)150), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)150), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                ReferencePositionWithOrientation p2 = ReferencePositionWithOrientation$.MODULE$.liftOverToReference(150L, exons);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(p2.refPos().referenceName());
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)"1", $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)"1", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)p2.refPos().pos()));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)350), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)350), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                ReferencePositionWithOrientation p3 = ReferencePositionWithOrientation$.MODULE$.liftOverToReference(250L, exons);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(p3.refPos().referenceName());
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)"1", $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)"1", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left8 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)p3.refPos().pos()));
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "===", (Object)BoxesRunTime.boxToInteger((int)550), $org_scalatest_assert_macro_left8.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)550), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("liftOverToReference works with a multi-block alignment on the reverse strand", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq exons = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReferenceRegionWithOrientation[]{ReferenceRegionWithOrientation$.MODULE$.apply("1", 100L, 200L, true), ReferenceRegionWithOrientation$.MODULE$.apply("1", 300L, 400L, true), ReferenceRegionWithOrientation$.MODULE$.apply("1", 500L, 600L, true)}));
                ReferencePositionWithOrientation p1 = ReferencePositionWithOrientation$.MODULE$.liftOverToReference(50L, exons);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(p1.refPos().referenceName());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"1", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"1", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)p1.refPos().pos()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)549), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)549), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                ReferencePositionWithOrientation p2 = ReferencePositionWithOrientation$.MODULE$.liftOverToReference(150L, exons);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(p2.refPos().referenceName());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)"1", $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)"1", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)p2.refPos().pos()));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)349), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)349), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                ReferencePositionWithOrientation p3 = ReferencePositionWithOrientation$.MODULE$.liftOverToReference(250L, exons);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(p3.refPos().referenceName());
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)"1", $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)"1", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)p3.refPos().pos()));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)149), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)149), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("lift over between two transcripts on the forward strand", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq t1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReferenceRegionWithOrientation[]{ReferenceRegionWithOrientation$.MODULE$.apply("chr0", 0L, 201L, false)}));
                Seq t2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReferenceRegionWithOrientation[]{ReferenceRegionWithOrientation$.MODULE$.apply("chr0", 50L, 101L, false), ReferenceRegionWithOrientation$.MODULE$.apply("chr0", 175L, 201L, false)}));
                ReferencePositionWithOrientation pos = ReferencePositionWithOrientation$.MODULE$.liftOverToReference(60L, t1);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(pos.refPos().referenceName());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"chr0", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"chr0", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)pos.refPos().pos()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)60L), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)60L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(pos.negativeStrand(), "pos.negativeStrand"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                long idx = pos.liftOverFromReference(t2);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)idx));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)10L), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)10L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("lift over between two transcripts on the reverse strand", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq t1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReferenceRegionWithOrientation[]{ReferenceRegionWithOrientation$.MODULE$.apply("chr0", 0L, 201L, true)}));
                Seq t2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReferenceRegionWithOrientation[]{ReferenceRegionWithOrientation$.MODULE$.apply("chr0", 175L, 201L, true), ReferenceRegionWithOrientation$.MODULE$.apply("chr0", 50L, 101L, true)}));
                long idx = new ReferencePositionWithOrientation(new ReferencePosition("chr0", 190L), true).liftOverFromReference(t2);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)idx));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)11L), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)11L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                ReferencePositionWithOrientation pos = ReferencePositionWithOrientation$.MODULE$.liftOverToReference(idx, t1);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(pos.refPos().referenceName());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)"chr0", $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)"chr0", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)pos.refPos().pos()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)189L), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)189L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(pos.negativeStrand(), "pos.negativeStrand");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

