/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.models;

import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferencePositionWithOrientation;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.models.ReferenceRegion$;
import org.bdgenomics.adam.models.ReferenceRegionSuite$;
import org.bdgenomics.adam.models.ReferenceRegionWithOrientation;
import org.bdgenomics.adam.models.ReferenceRegionWithOrientation$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.formats.avro.Contig;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e2A!\u0001\u0002\u0001\u0017\t!\"+\u001a4fe\u0016t7-\u001a*fO&|gnU;ji\u0016T!a\u0001\u0003\u0002\r5|G-\u001a7t\u0015\t)a!\u0001\u0003bI\u0006l'BA\u0004\t\u0003)\u0011GmZ3o_6L7m\u001d\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0003\u001f!\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005Eq!\u0001\u0003$v]N+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001\"\u0002\r\u0001\t\u0003I\u0012A\u0002:fO&|g\u000e\u0006\u0003\u001b;%r\u0003C\u0001\f\u001c\u0013\ta\"AA\bSK\u001a,'/\u001a8dKJ+w-[8o\u0011\u0015qr\u00031\u0001 \u0003\u001d\u0011XM\u001a(b[\u0016\u0004\"\u0001\t\u0014\u000f\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0002\rA\u0013X\rZ3g\u0013\t9\u0003F\u0001\u0004TiJLgn\u001a\u0006\u0003K\tBQAK\fA\u0002-\nQa\u001d;beR\u0004\"!\t\u0017\n\u00055\u0012#\u0001\u0002'p]\u001eDQaL\fA\u0002-\n1!\u001a8e\u0011\u0015\t\u0004\u0001\"\u00013\u0003\u0015\u0001x.\u001b8u)\r\u0019dg\u000e\t\u0003-QJ!!\u000e\u0002\u0003#I+g-\u001a:f]\u000e,\u0007k\\:ji&|g\u000eC\u0003\u001fa\u0001\u0007q\u0004C\u00039a\u0001\u00071&A\u0002q_N\u0004")
public class ReferenceRegionSuite
extends FunSuite {
    public ReferenceRegion region(String refName, long start, long end) {
        return new ReferenceRegion(refName, start, end);
    }

    public ReferencePosition point(String refName, long pos) {
        return new ReferencePosition(refName, pos);
    }

    public ReferenceRegionSuite() {
        this.test("contains(: ReferenceRegion)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ReferenceRegion $org_scalatest_assert_macro_left = this.$outer.region("chr0", 10L, 100L);
                ReferenceRegion $org_scalatest_assert_macro_right = this.$outer.region("chr0", 50L, 70L);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                ReferenceRegion $org_scalatest_assert_macro_left2 = this.$outer.region("chr0", 10L, 100L);
                ReferenceRegion $org_scalatest_assert_macro_right2 = this.$outer.region("chr0", 10L, 100L);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                ReferenceRegion $org_scalatest_assert_macro_left3 = this.$outer.region("chr0", 10L, 100L);
                ReferenceRegion $org_scalatest_assert_macro_right3 = this.$outer.region("chr1", 50L, 70L);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                ReferenceRegion $org_scalatest_assert_macro_left4 = this.$outer.region("chr0", 10L, 100L);
                ReferenceRegion $org_scalatest_assert_macro_right4 = this.$outer.region("chr0", 50L, 100L);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                ReferenceRegion $org_scalatest_assert_macro_left5 = this.$outer.region("chr0", 10L, 100L);
                ReferenceRegion $org_scalatest_assert_macro_right5 = this.$outer.region("chr0", 50L, 101L);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("contains(: ReferencePosition)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ReferenceRegion $org_scalatest_assert_macro_left = this.$outer.region("chr0", 10L, 100L);
                ReferencePosition $org_scalatest_assert_macro_right = this.$outer.point("chr0", 50L);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                ReferenceRegion $org_scalatest_assert_macro_left2 = this.$outer.region("chr0", 10L, 100L);
                ReferencePosition $org_scalatest_assert_macro_right2 = this.$outer.point("chr0", 10L);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                ReferenceRegion $org_scalatest_assert_macro_left3 = this.$outer.region("chr0", 10L, 100L);
                ReferencePosition $org_scalatest_assert_macro_right3 = this.$outer.point("chr0", 99L);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                ReferenceRegion $org_scalatest_assert_macro_left4 = this.$outer.region("chr0", 10L, 100L);
                ReferencePosition $org_scalatest_assert_macro_right4 = this.$outer.point("chr0", 100L);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                ReferenceRegion $org_scalatest_assert_macro_left5 = this.$outer.region("chr0", 10L, 100L);
                ReferencePosition $org_scalatest_assert_macro_right5 = this.$outer.point("chr1", 50L);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("merge", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final ReferenceRegion apply() {
                        return this.$outer.$outer.region("chr0", 10L, 100L).merge(this.$outer.$outer.region("chr1", 10L, 100L));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(AssertionError.class));
                ReferenceRegion r1 = this.$outer.region("chr0", 10L, 100L);
                ReferenceRegion r2 = this.$outer.region("chr0", 0L, 15L);
                ReferenceRegion r3 = this.$outer.region("chr0", 50L, 150L);
                ReferenceRegion r12 = this.$outer.region("chr0", 0L, 100L);
                ReferenceRegion r13 = this.$outer.region("chr0", 10L, 150L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(r1.merge(r1));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)r1, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)r1, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(r1.merge(r2));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)r12, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)r12, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(r1.merge(r3));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)r13, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)r13, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }

            public /* synthetic */ ReferenceRegionSuite org$bdgenomics$adam$models$ReferenceRegionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("overlaps", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(this.$outer.region("chr0", 10L, 100L).overlaps(this.$outer.region("chr0", 20L, 50L)), "ReferenceRegionSuite.this.region(\"chr0\", 10L, 100L).overlaps(ReferenceRegionSuite.this.region(\"chr0\", 20L, 50L))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(this.$outer.region("chr0", 10L, 100L).overlaps(this.$outer.region("chr0", 50L, 250L)), "ReferenceRegionSuite.this.region(\"chr0\", 10L, 100L).overlaps(ReferenceRegionSuite.this.region(\"chr0\", 50L, 250L))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(this.$outer.region("chr0", 10L, 100L).overlaps(this.$outer.region("chr0", 5L, 15L)), "ReferenceRegionSuite.this.region(\"chr0\", 10L, 100L).overlaps(ReferenceRegionSuite.this.region(\"chr0\", 5L, 15L))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(this.$outer.region("chr0", 10L, 100L).overlaps(this.$outer.region("chr0", 5L, 11L)), "ReferenceRegionSuite.this.region(\"chr0\", 10L, 100L).overlaps(ReferenceRegionSuite.this.region(\"chr0\", 5L, 11L))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.region("chr0", 10L, 100L).overlaps(this.$outer.region("chr0", 5L, 10L)), "ReferenceRegionSuite.this.region(\"chr0\", 10L, 100L).overlaps(ReferenceRegionSuite.this.region(\"chr0\", 5L, 10L))"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(this.$outer.region("chr0", 10L, 100L).overlaps(this.$outer.region("chr0", 99L, 200L)), "ReferenceRegionSuite.this.region(\"chr0\", 10L, 100L).overlaps(ReferenceRegionSuite.this.region(\"chr0\", 99L, 200L))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.region("chr0", 10L, 100L).overlaps(this.$outer.region("chr0", 100L, 200L)), "ReferenceRegionSuite.this.region(\"chr0\", 10L, 100L).overlaps(ReferenceRegionSuite.this.region(\"chr0\", 100L, 200L))"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(this.$outer.region("chr0", 10L, 100L).overlaps(this.$outer.region("chr1", 50L, 200L)), "ReferenceRegionSuite.this.region(\"chr0\", 10L, 100L).overlaps(ReferenceRegionSuite.this.region(\"chr1\", 50L, 200L))"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("distance(: ReferenceRegion)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.region("chr0", 10L, 100L).distance(this.$outer.region("chr0", 200L, 300L)));
                Some $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToInteger((int)101));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(this.$outer.region("chr0", 100L, 200L).distance(this.$outer.region("chr0", 10L, 50L)));
                Some $org_scalatest_assert_macro_right2 = new Some((Object)BoxesRunTime.boxToInteger((int)51));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(this.$outer.region("chr0", 100L, 200L).distance(this.$outer.region("chr1", 10L, 50L)));
                None$ $org_scalatest_assert_macro_right3 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(this.$outer.region("chr0", 10L, 100L).distance(this.$outer.region("chr0", 100L, 200L)));
                Some $org_scalatest_assert_macro_right4 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(this.$outer.region("chr0", 10L, 100L).distance(this.$outer.region("chr0", 50L, 150L)));
                Some $org_scalatest_assert_macro_right5 = new Some((Object)BoxesRunTime.boxToInteger((int)0));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(this.$outer.region("chr0", 10L, 100L).distance(this.$outer.region("chr0", 0L, 10L)));
                Some $org_scalatest_assert_macro_right6 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("distance(: ReferencePosition)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.region("chr0", 10L, 100L).distance(this.$outer.point("chr0", 50L)));
                Some $org_scalatest_assert_macro_right = new Some((Object)BoxesRunTime.boxToInteger((int)0));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(this.$outer.region("chr0", 10L, 100L).distance(this.$outer.point("chr0", 10L)));
                Some $org_scalatest_assert_macro_right2 = new Some((Object)BoxesRunTime.boxToInteger((int)0));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(this.$outer.region("chr0", 10L, 100L).distance(this.$outer.point("chr0", 100L)));
                Some $org_scalatest_assert_macro_right3 = new Some((Object)BoxesRunTime.boxToInteger((int)1));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(this.$outer.region("chr0", 10L, 100L).distance(this.$outer.point("chr0", 150L)));
                Some $org_scalatest_assert_macro_right4 = new Some((Object)BoxesRunTime.boxToInteger((int)51));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(this.$outer.region("chr0", 100L, 200L).distance(this.$outer.point("chr0", 50L)));
                Some $org_scalatest_assert_macro_right5 = new Some((Object)BoxesRunTime.boxToInteger((int)50));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(this.$outer.region("chr0", 100L, 200L).distance(this.$outer.point("chr1", 50L)));
                None$ $org_scalatest_assert_macro_right6 = None$.MODULE$;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)$org_scalatest_assert_macro_right6, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create region from unmapped read fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord read = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(false)).build();
                Option $org_scalatest_assert_macro_left = ReferenceRegion$.MODULE$.apply(read);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create region from mapped read contains read start and end", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                AlignmentRecord read = AlignmentRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setSequence("AAAAA").setStart(Predef$.MODULE$.long2Long(1L)).setCigar("5M").setEnd(Predef$.MODULE$.long2Long(6L)).setContig(Contig.newBuilder().setContigName("chr1").setContigLength(Predef$.MODULE$.long2Long(10L)).build()).build();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ReferenceRegion$.MODULE$.apply(read).isDefined(), "ReferenceRegion.apply(read).isDefined");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                ReferenceRegion $org_scalatest_assert_macro_left = (ReferenceRegion)ReferenceRegion$.MODULE$.apply(read).get();
                ReferencePosition $org_scalatest_assert_macro_right = this.$outer.point("chr1", 1L);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                ReferenceRegion $org_scalatest_assert_macro_left2 = (ReferenceRegion)ReferenceRegion$.MODULE$.apply(read).get();
                ReferencePosition $org_scalatest_assert_macro_right2 = this.$outer.point("chr1", 5L);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                ReferenceRegion $org_scalatest_assert_macro_left3 = (ReferenceRegion)ReferenceRegion$.MODULE$.apply(read).get();
                ReferencePosition $org_scalatest_assert_macro_right3 = this.$outer.point("chr1", 6L);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("validate that adjacent regions can be merged", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ReferenceRegion r1 = this.$outer.region("chr1", 0L, 6L);
                ReferenceRegion r2 = this.$outer.region("chr1", 6L, 10L);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(r1.distance(r2).get());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(r1.isAdjacent(r2), "r1.isAdjacent(r2)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                ReferenceRegion $org_scalatest_assert_macro_left2 = r1.merge(r2);
                ReferenceRegion $org_scalatest_assert_macro_right = this.$outer.region("chr1", 0L, 10L);
                ReferenceRegion referenceRegion = $org_scalatest_assert_macro_left2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right, !(referenceRegion != null ? !referenceRegion.equals($org_scalatest_assert_macro_right) : $org_scalatest_assert_macro_right != null));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("validate that non-adjacent regions cannot be merged", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ReferenceRegion r1 = this.$outer.region("chr1", 0L, 5L);
                ReferenceRegion r2 = this.$outer.region("chr1", 7L, 10L);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(r1.isAdjacent(r2), "r1.isAdjacent(r2)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                this.$outer.intercept((Function0)new Serializable(this, r1, r2){
                    public static final long serialVersionUID = 0L;
                    private final ReferenceRegion r1$1;
                    private final ReferenceRegion r2$1;

                    public final ReferenceRegion apply() {
                        return this.r1$1.merge(this.r2$1);
                    }
                    {
                        this.r1$1 = r1$1;
                        this.r2$1 = r2$1;
                    }
                }, ManifestFactory$.MODULE$.classType(AssertionError.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("compute convex hull of two sets", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ReferenceRegion r1 = this.$outer.region("chr1", 0L, 5L);
                ReferenceRegion r2 = this.$outer.region("chr1", 7L, 10L);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(r1.isAdjacent(r2), "r1.isAdjacent(r2)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                ReferenceRegion hull1 = r1.hull(r2);
                ReferenceRegion hull2 = r2.hull(r1);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(hull1);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)hull2, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)hull2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(hull1.overlaps(r1), "hull1.overlaps(r1)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(hull1.overlaps(r2), "hull1.overlaps(r2)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                long $org_scalatest_assert_macro_left2 = hull1.start();
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)0L), $org_scalatest_assert_macro_left2 == 0L);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                long $org_scalatest_assert_macro_left3 = hull1.end();
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToLong((long)10L), $org_scalatest_assert_macro_left3 == 10L);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("region name is sanitized when creating region from read", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Contig contig = Contig.newBuilder().setContigName("chrM").build();
                AlignmentRecord read = AlignmentRecord.newBuilder().setStart(Predef$.MODULE$.long2Long(5L)).setSequence("ACGT").setContig(contig).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar("5M").setEnd(Predef$.MODULE$.long2Long(10L)).setMismatchingPositions("5").build();
                Option region = ReferenceRegion$.MODULE$.apply(read);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(region.isDefined(), "region.isDefined");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                ReferenceRegion r = (ReferenceRegion)region.get();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(r.referenceName());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"chrM", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"chrM", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)r.start()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)5L), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)5L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)r.end()));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)10L), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)10L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("intersection fails on non-overlapping regions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ReferenceRegion apply() {
                        return new ReferenceRegion("chr1", 1L, 10L).intersection(new ReferenceRegion("chr1", 11L, 20L));
                    }
                }, ManifestFactory$.MODULE$.classType(AssertionError.class));
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ReferenceRegion apply() {
                        return new ReferenceRegion("chr1", 1L, 10L).intersection(new ReferenceRegion("chr2", 1L, 10L));
                    }
                }, ManifestFactory$.MODULE$.classType(AssertionError.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("compute intersection", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ReferenceRegion overlapRegion = new ReferenceRegion("chr1", 1L, 10L).intersection(new ReferenceRegion("chr1", 5L, 15L));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(overlapRegion.referenceName());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"chr1", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"chr1", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)overlapRegion.start()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)5L), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)5L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)overlapRegion.end()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)10L), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)10L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("build oriented reference region from non-oriented", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ReferenceRegionWithOrientation rrf = new ReferenceRegionWithOrientation(new ReferenceRegion("chr1", 10L, 20L), false);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(rrf.referenceName());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"chr1", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"chr1", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rrf.start()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)10L), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)10L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rrf.end()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToLong((long)20L), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)20L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(rrf.negativeStrand(), "rrf.negativeStrand"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                ReferenceRegionWithOrientation rrr = new ReferenceRegionWithOrientation(new ReferenceRegion("chr1", 10L, 20L), true);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(rrr.referenceName());
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)"chr1", $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)"chr1", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rrr.start()));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToLong((long)10L), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)10L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rrr.end()));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToLong((long)20L), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)20L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
                Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.simpleMacroBool(rrr.negativeStrand(), "rrr.negativeStrand");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("comparison tests for oriented reference region", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ReferenceRegionWithOrientation $org_scalatest_assert_macro_left = ReferenceRegionWithOrientation$.MODULE$.apply("chr1", 10L, 20L, false);
                ReferenceRegionWithOrientation $org_scalatest_assert_macro_right = ReferenceRegionWithOrientation$.MODULE$.apply("chr1", 10L, 20L, false);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                ReferenceRegionWithOrientation $org_scalatest_assert_macro_left2 = ReferenceRegionWithOrientation$.MODULE$.apply("chr1", 10L, 20L, true);
                ReferenceRegionWithOrientation $org_scalatest_assert_macro_right2 = ReferenceRegionWithOrientation$.MODULE$.apply("chr1", 15L, 17L, true);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                ReferenceRegionWithOrientation rrf = new ReferenceRegionWithOrientation(new ReferenceRegion("chr1", 10L, 20L), false);
                ReferenceRegionWithOrientation rrr = new ReferenceRegionWithOrientation(new ReferenceRegion("chr1", 10L, 20L), true);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)rrf, "contains", (Object)rrr, rrf.contains(rrr)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                ReferenceRegionWithOrientation $org_scalatest_assert_macro_left3 = ReferenceRegionWithOrientation$.MODULE$.apply("chr1", 10L, 20L, false);
                ReferenceRegionWithOrientation $org_scalatest_assert_macro_right3 = ReferenceRegionWithOrientation$.MODULE$.apply("chr2", 10L, 20L, false);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                ReferenceRegionWithOrientation $org_scalatest_assert_macro_left4 = ReferenceRegionWithOrientation$.MODULE$.apply("chr1", 20L, 50L, true);
                ReferenceRegionWithOrientation $org_scalatest_assert_macro_right4 = ReferenceRegionWithOrientation$.MODULE$.apply("chr1", 50L, 100L, true);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("comparison tests for oriented reference region vs position", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ReferenceRegionWithOrientation $org_scalatest_assert_macro_left = ReferenceRegionWithOrientation$.MODULE$.apply("chr1", 10L, 20L, false);
                ReferencePositionWithOrientation $org_scalatest_assert_macro_right = new ReferencePositionWithOrientation(new ReferencePosition("chr1", 10L), false);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                ReferenceRegionWithOrientation $org_scalatest_assert_macro_left2 = ReferenceRegionWithOrientation$.MODULE$.apply("chr1", 10L, 20L, true);
                ReferencePositionWithOrientation $org_scalatest_assert_macro_right2 = new ReferencePositionWithOrientation(new ReferencePosition("chr1", 17L), true);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                ReferenceRegionWithOrientation $org_scalatest_assert_macro_left3 = new ReferenceRegionWithOrientation(new ReferenceRegion("chr1", 10L, 20L), false);
                ReferencePositionWithOrientation $org_scalatest_assert_macro_right3 = new ReferencePositionWithOrientation(new ReferencePosition("chr1", 17L), true);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                ReferenceRegionWithOrientation $org_scalatest_assert_macro_left4 = new ReferenceRegionWithOrientation(new ReferenceRegion("chr1", 10L, 20L), true);
                ReferencePositionWithOrientation $org_scalatest_assert_macro_right4 = new ReferencePositionWithOrientation(new ReferencePosition("chr1", 10L), false);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                ReferenceRegionWithOrientation $org_scalatest_assert_macro_left5 = ReferenceRegionWithOrientation$.MODULE$.apply("chr1", 10L, 20L, false);
                ReferencePositionWithOrientation $org_scalatest_assert_macro_right5 = new ReferencePositionWithOrientation(new ReferencePosition("chr2", 10L), false);
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                ReferenceRegionWithOrientation $org_scalatest_assert_macro_left6 = ReferenceRegionWithOrientation$.MODULE$.apply("chr1", 20L, 50L, true);
                ReferencePositionWithOrientation $org_scalatest_assert_macro_right6 = new ReferencePositionWithOrientation(new ReferencePosition("chr1", 100L), true);
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.contains($org_scalatest_assert_macro_right6)));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("overlap tests for oriented reference region", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ReferenceRegionWithOrientation$.MODULE$.apply("chr1", 10L, 20L, false).overlaps(ReferenceRegionWithOrientation$.MODULE$.apply("chr1", 15L, 25L, false)), "ReferenceRegionWithOrientation.apply(\"chr1\", 10L, 20L, false).overlaps(ReferenceRegionWithOrientation.apply(\"chr1\", 15L, 25L, false))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(ReferenceRegionWithOrientation$.MODULE$.apply("chr1", 10L, 20L, true).overlaps(ReferenceRegionWithOrientation$.MODULE$.apply("chr1", 5L, 15L, true)), "ReferenceRegionWithOrientation.apply(\"chr1\", 10L, 20L, true).overlaps(ReferenceRegionWithOrientation.apply(\"chr1\", 5L, 15L, true))");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(ReferenceRegionWithOrientation$.MODULE$.apply("chr1", 10L, 20L, false).overlaps(ReferenceRegionWithOrientation$.MODULE$.apply("chr2", 10L, 20L, false)), "ReferenceRegionWithOrientation.apply(\"chr1\", 10L, 20L, false).overlaps(ReferenceRegionWithOrientation.apply(\"chr2\", 10L, 20L, false))"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(ReferenceRegionWithOrientation$.MODULE$.apply("chr1", 20L, 50L, true).overlaps(ReferenceRegionWithOrientation$.MODULE$.apply("chr1", 51L, 100L, true)), "ReferenceRegionWithOrientation.apply(\"chr1\", 20L, 50L, true).overlaps(ReferenceRegionWithOrientation.apply(\"chr1\", 51L, 100L, true))"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("check the width of a reference region", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)new ReferenceRegion("chr1", 100L, 201L).width()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)101), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)101), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)ReferenceRegionWithOrientation$.MODULE$.apply("chr2", 200L, 401L, false).width()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)201), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)201), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)ReferenceRegionWithOrientation$.MODULE$.apply("chr3", 399L, 1000L, true).width()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)601), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)601), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

