/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.models;

import htsjdk.samtools.SAMFileReader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import java.io.File;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceDictionary$;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!3A!\u0001\u0002\u0001\u0017\t92+Z9vK:\u001cW\rR5di&|g.\u0019:z'VLG/\u001a\u0006\u0003\u0007\u0011\ta!\\8eK2\u001c(BA\u0003\u0007\u0003\u0011\tG-Y7\u000b\u0005\u001dA\u0011A\u00032eO\u0016tw.\\5dg*\t\u0011\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\u0011q\u0002C\u0001\ng\u000e\fG.\u0019;fgRL!!\u0005\b\u0003\u0011\u0019+hnU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000ba\u0001A\u0011A\r\u0002\rI,7m\u001c:e)\u0015QR$\u000b\u00184!\t12$\u0003\u0002\u001d\u0005\tq1+Z9vK:\u001cWMU3d_J$\u0007\"\u0002\u0010\u0018\u0001\u0004y\u0012\u0001\u00028b[\u0016\u0004\"\u0001\t\u0014\u000f\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0002\rA\u0013X\rZ3g\u0013\t9\u0003F\u0001\u0004TiJLgn\u001a\u0006\u0003K\tBqAK\f\u0011\u0002\u0003\u00071&\u0001\u0004mK:<G\u000f\u001b\t\u0003C1J!!\f\u0012\u0003\t1{gn\u001a\u0005\b_]\u0001\n\u00111\u00011\u0003\r)(\u000f\u001c\t\u0004CEz\u0012B\u0001\u001a#\u0005\u0019y\u0005\u000f^5p]\"9Ag\u0006I\u0001\u0002\u0004\u0001\u0014aA7ek!9a\u0007AI\u0001\n\u00039\u0014\u0001\u0005:fG>\u0014H\r\n3fM\u0006,H\u000e\u001e\u00133+\u0005A$FA\u0016:W\u0005Q\u0004CA\u001eA\u001b\u0005a$BA\u001f?\u0003%)hn\u00195fG.,GM\u0003\u0002@E\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005\u0005c$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"91\tAI\u0001\n\u0003!\u0015\u0001\u0005:fG>\u0014H\r\n3fM\u0006,H\u000e\u001e\u00134+\u0005)%F\u0001\u0019:\u0011\u001d9\u0005!%A\u0005\u0002\u0011\u000b\u0001C]3d_J$G\u0005Z3gCVdG\u000f\n\u001b")
public class SequenceDictionarySuite
extends FunSuite {
    public SequenceRecord record(String name, long length, Option<String> url, Option<String> md5) {
        return new SequenceRecord(name, length, url, md5, SequenceRecord$.MODULE$.$lessinit$greater$default$5(), SequenceRecord$.MODULE$.$lessinit$greater$default$6(), SequenceRecord$.MODULE$.$lessinit$greater$default$7(), SequenceRecord$.MODULE$.$lessinit$greater$default$8());
    }

    public long record$default$2() {
        return 1000L;
    }

    public Option<String> record$default$3() {
        return None$.MODULE$;
    }

    public Option<String> record$default$4() {
        return None$.MODULE$;
    }

    public SequenceDictionarySuite() {
        this.test("Convert from sam sequence record and back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SAMSequenceRecord sr = new SAMSequenceRecord("1", 1000);
                sr.setAttribute("UR", "http://bigdatagenomics.github.io/1");
                SequenceRecord asASR = SequenceRecord$.MODULE$.fromSAMSequenceRecord(sr);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(asASR.name());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"1", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"1", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)asASR.length()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)1000L), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)1000L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(asASR.url());
                Some $org_scalatest_assert_macro_right = new Some((Object)"http://bigdatagenomics.github.io/1");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                SAMSequenceRecord asPSR = SequenceRecord$.MODULE$.toSAMSequenceRecord(asASR);
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(sr.isSameSequence(asPSR), "sr.isSameSequence(asPSR)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Convert from SAM sequence dictionary file (with extra fields)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SAMSequenceRecord chr1;
                String path = ClassLoader.getSystemClassLoader().getResource("dict_with_accession.dict").getFile();
                SAMSequenceDictionary ssd = SAMFileReader.getSequenceDictionary((File)new File(path));
                SAMSequenceRecord sAMSequenceRecord = chr1 = ssd.getSequence("1");
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)chr1, "!=", null, sAMSequenceRecord != null ? !sAMSequenceRecord.equals(null) : null != null);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                String refseq = chr1.getAttribute("REFSEQ");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(refseq);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"NC_000001.10", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"NC_000001.10", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                SequenceDictionary asd = SequenceDictionary$.MODULE$.apply(ssd);
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(asd.containsRefName("1"), "asd.containsRefName(\"1\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(asd.containsRefName("2"), "asd.containsRefName(\"2\")"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("merge into existing dictionary", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String path = ClassLoader.getSystemClassLoader().getResource("dict_with_accession.dict").getFile();
                SAMSequenceDictionary ssd = SAMFileReader.getSequenceDictionary((File)new File(path));
                SequenceDictionary asd = SequenceDictionary$.MODULE$.apply(ssd);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(asd.containsRefName("1"), "asd.containsRefName(\"1\")");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                SequenceRecord chr1 = (SequenceRecord)asd.apply("1").get();
                SequenceRecord[] sequenceRecordArray = new SequenceRecord[1];
                String x$1 = chr1.name();
                long x$2 = chr1.length();
                Option x$3 = chr1.md5();
                Option<String> x$4 = this.$outer.record$default$3();
                sequenceRecordArray[0] = this.$outer.record(x$1, x$2, x$4, (Option<String>)x$3);
                SequenceDictionary myDict = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])sequenceRecordArray));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(asd.isCompatibleWith(myDict), "asd.isCompatibleWith(myDict)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(myDict.isCompatibleWith(asd), "myDict.isCompatibleWith(asd)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Convert from SAM sequence dictionary and back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String path = ClassLoader.getSystemClassLoader().getResource("dict_with_accession.dict").getFile();
                SAMSequenceDictionary ssd = SAMFileReader.getSequenceDictionary((File)new File(path));
                SequenceDictionary asd = SequenceDictionary$.MODULE$.apply(ssd);
                ssd.assertSameDictionary(SequenceDictionary$.MODULE$.toSAMSequenceDictionary(asd));
            }
        });
        this.test("Can retrieve sequence by name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceRecord rec = this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4());
                SequenceDictionary asd = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{rec}));
                Option recFromName = asd.apply(rec.name());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(recFromName);
                Some $org_scalatest_assert_macro_right = new Some((Object)rec);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SequenceDictionary's with same single element are equal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary asd1 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary asd2 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(asd1);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)asd2, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)asd2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SequenceDictionary's with same two elements are equals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary asd1 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr2", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary asd2 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr2", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(asd1);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)asd2, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)asd2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SequenceDictionary's with different elements are unequal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary asd1 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr2", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary asd2 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr3", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary sequenceDictionary = asd1;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)asd1, "!=", (Object)asd2, sequenceDictionary != null ? !sequenceDictionary.equals(asd2) : asd2 != null);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SequenceDictionaries with same elements in different order are compatible", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary asd1 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr2", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary asd2 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("chr2", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(asd1.isCompatibleWith(asd2), "asd1.isCompatibleWith(asd2)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("isCompatible tests equality on overlap", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary s1 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary s2 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("quux", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary s3 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary s4 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", 1001L, this.$outer.record$default$3(), this.$outer.record$default$4())}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(s1.isCompatibleWith(s2), "s1.isCompatibleWith(s2)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(s1.isCompatibleWith(s3), "s1.isCompatibleWith(s3)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(s3.isCompatibleWith(s4), "s3.isCompatibleWith(s4)"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("The addition + works correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary s1 = SequenceDictionary$.MODULE$.apply();
                SequenceDictionary s2 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary s3 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(s1.$plus(this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)s2, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)s2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(s2.$plus(this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)s2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)s2, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(s2.$plus(this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)s3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)s3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("The append operation ++ works correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary s1 = SequenceDictionary$.MODULE$.apply();
                SequenceDictionary s2a = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary s2b = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary s3 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("bar", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(s1.$plus$plus(s1));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)s1, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)s1, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(s1.$plus$plus(s2a));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)s2a, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)s2a, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(s1.$plus$plus(s2b));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)s2b, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)s2b, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(s2a.$plus$plus(s2b));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)s3, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)s3, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("ContainsRefName works correctly for different string types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary dict = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("chr0", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr2", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr3", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(dict.containsRefName("chr0"), "dict.containsRefName(str0)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(dict.containsRefName("chr1"), "dict.containsRefName(str1)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Apply on name works correctly for different String types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary dict = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("chr0", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr1", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr2", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("chr3", this.$outer.record$default$2(), this.$outer.record$default$3(), this.$outer.record$default$4())}));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(((SequenceRecord)dict.apply("chr0").get()).name());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"chr0", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"chr0", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(((SequenceRecord)dict.apply("chr1").get()).name());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)"chr1", $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)"chr1", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("convert from sam sequence record and back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SAMSequenceRecord sr = new SAMSequenceRecord("chr0", 1000);
                sr.setAttribute("UR", "http://bigdatagenomics.github.io/chr0");
                SequenceRecord conv = SequenceRecord$.MODULE$.fromSAMSequenceRecord(sr);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(conv.name());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)"chr0", $org_scalatest_assert_macro_left.$eq$eq$eq((Object)"chr0", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)conv.length()));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToLong((long)1000L), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)1000L), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(conv.url().get());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)"http://bigdatagenomics.github.io/chr0", $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)"http://bigdatagenomics.github.io/chr0", Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                SAMSequenceRecord convSr = conv.toSAMSequenceRecord();
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(convSr.isSameSequence(sr), "convSr.isSameSequence(sr)");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("convert from sam sequence dictionary and back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SAMSequenceRecord sr0 = new SAMSequenceRecord("chr0", 1000);
                List srs = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SAMSequenceRecord[]{sr0}));
                SAMSequenceDictionary ssd = new SAMSequenceDictionary(ADAMContext$.MODULE$.listToJavaList(srs));
                SequenceDictionary asd = SequenceDictionary$.MODULE$.fromSAMSequenceDictionary(ssd);
                SAMSequenceDictionary toSSD = asd.toSAMSequenceDictionary();
                toSSD.assertSameDictionary(ssd);
            }
        });
    }
}

