/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import java.io.File;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Level;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.predicates.HighQualityReadPredicate;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.util.PhredUtils$;
import org.bdgenomics.adam.util.SparkFunSuite;
import org.bdgenomics.adam.util.SparkFunSuite$class;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u1A!\u0001\u0002\u0001\u0017\t\u0001\u0012\tR!N\u0007>tG/\u001a=u'VLG/\u001a\u0006\u0003\u0007\u0011\t1A\u001d3e\u0015\t)a!\u0001\u0003bI\u0006l'BA\u0004\t\u0003)\u0011GmZ3o_6L7m\u001d\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0005=A\u0011!C:dC2\fG/Z:u\u0013\t\tbB\u0001\u0005Gk:\u001cV/\u001b;f!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0003vi&d\u0017BA\f\u0015\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001")
public class ADAMContextSuite
extends FunSuite
implements SparkFunSuite {
    private SparkContext sc;
    private Option<Map<String, Level>> maybeLevels;
    private final String appName;
    private final String master;
    private final Map<String, String> properties;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public Option<Map<String, Level>> maybeLevels() {
        return this.maybeLevels;
    }

    @Override
    public void maybeLevels_$eq(Option<Map<String, Level>> x$1) {
        this.maybeLevels = x$1;
    }

    @Override
    public String appName() {
        return this.appName;
    }

    @Override
    public String master() {
        return this.master;
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    @Override
    public void org$bdgenomics$adam$util$SparkFunSuite$_setter_$appName_$eq(String x$1) {
        this.appName = x$1;
    }

    @Override
    public void org$bdgenomics$adam$util$SparkFunSuite$_setter_$master_$eq(String x$1) {
        this.master = x$1;
    }

    @Override
    public void org$bdgenomics$adam$util$SparkFunSuite$_setter_$properties_$eq(Map x$1) {
        this.properties = x$1;
    }

    @Override
    public void setupSparkContext(String sparkName, boolean silenceSpark) {
        SparkFunSuite$class.setupSparkContext(this, sparkName, silenceSpark);
    }

    @Override
    public void teardownSparkContext() {
        SparkFunSuite$class.teardownSparkContext(this);
    }

    @Override
    public void sparkBefore(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkBefore(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkAfter(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkAfter(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkTest(String name, boolean silenceSpark, Seq<Tag> tags, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, silenceSpark, tags, body);
    }

    @Override
    public void sparkTest(String name, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, body);
    }

    @Override
    public String testFile(String name) {
        return SparkFunSuite$class.testFile(this, name);
    }

    @Override
    public boolean sparkBefore$default$2() {
        return SparkFunSuite$class.sparkBefore$default$2(this);
    }

    @Override
    public boolean setupSparkContext$default$2() {
        return SparkFunSuite$class.setupSparkContext$default$2(this);
    }

    @Override
    public boolean sparkAfter$default$2() {
        return SparkFunSuite$class.sparkAfter$default$2(this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public ADAMContextSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        SparkFunSuite$class.$init$(this);
        this.sparkTest("sc.adamLoad should not fail on unmapped reads", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMContextSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String readsFilepath = ClassLoader.getSystemClassLoader().getResource("unmapped.sam").getFile();
                ADAMContext qual$1 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc());
                None$ x$3 = qual$1.loadAlignments$default$2();
                Option x$4 = qual$1.loadAlignments$default$3();
                RDD bamReads = qual$1.loadAlignments(readsFilepath, (Option)x$3, x$4);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)bamReads.count()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)200), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)200), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("can read a small .SAM file", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMContextSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String path = ClassLoader.getSystemClassLoader().getResource("small.sam").getFile();
                ADAMContext qual$2 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc());
                None$ x$6 = qual$2.loadAlignments$default$2();
                Option x$7 = qual$2.loadAlignments$default$3();
                RDD reads = qual$2.loadAlignments(path, (Option)x$6, x$7);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)reads.count()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)20), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)20), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("can filter a .SAM file based on quality", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMContextSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String path = ClassLoader.getSystemClassLoader().getResource("small.sam").getFile();
                ADAMContext qual$3 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc());
                Some x$9 = new Some(HighQualityReadPredicate.class);
                Option x$10 = qual$3.loadAlignments$default$3();
                RDD reads = qual$3.loadAlignments(path, (Option)x$9, x$10);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)reads.count()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)18), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)18), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Can convert to phred", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMContextSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)PhredUtils$.MODULE$.successProbabilityToPhred(0.9)));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)10), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)PhredUtils$.MODULE$.successProbabilityToPhred(0.99999)));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)50), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)50), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Can convert from phred", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMContextSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Bool bool;
                Bool bool2;
                double $org_scalatest_assert_macro_left = PhredUtils$.MODULE$.phredToSuccessProbability(10);
                Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left), ">", (Object)BoxesRunTime.boxToDouble((double)0.89), $org_scalatest_assert_macro_left > 0.89);
                if ($org_scalatest_assert_macro_left2.value()) {
                    double $org_scalatest_assert_macro_left3 = PhredUtils$.MODULE$.phredToSuccessProbability(10);
                    bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left3), "<", (Object)BoxesRunTime.boxToDouble((double)0.91), $org_scalatest_assert_macro_left3 < 0.91);
                } else {
                    bool2 = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right = bool2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left2.$amp$amp($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                double $org_scalatest_assert_macro_left4 = PhredUtils$.MODULE$.phredToSuccessProbability(50);
                Bool $org_scalatest_assert_macro_left5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left4), ">", (Object)BoxesRunTime.boxToDouble((double)0.99998), $org_scalatest_assert_macro_left4 > 0.99998);
                if ($org_scalatest_assert_macro_left5.value()) {
                    double $org_scalatest_assert_macro_left6 = PhredUtils$.MODULE$.phredToSuccessProbability(50);
                    bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToDouble((double)$org_scalatest_assert_macro_left6), "<", (Object)BoxesRunTime.boxToDouble((double)0.999999), $org_scalatest_assert_macro_left6 < 0.999999);
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "");
                }
                Bool $org_scalatest_assert_macro_right2 = bool;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "&&", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left5.$amp$amp($org_scalatest_assert_macro_right2));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("findFiles correctly finds a nested set of directories", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMContextSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File tempDir = File.createTempFile("ADAMContextSuite", "").getParentFile();
                String parentName = new StringBuilder().append((Object)"parent-").append((Object)UUID.randomUUID().toString()).toString();
                File parentDir = this.createDir$1(tempDir, parentName);
                File subDir1 = this.createDir$1(parentDir, "subDir1");
                File subDir2 = this.createDir$1(parentDir, "subDir2");
                this.createDir$1(subDir1, "match1");
                this.createDir$1(subDir1, "match2");
                this.createDir$1(subDir2, "match3");
                this.createDir$1(subDir2, "nomatch4");
                this.createDir$1(parentDir, "match5");
                this.createDir$1(parentDir, "nomatch6");
                Seq paths = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc()).findFiles(new Path(parentDir.getAbsolutePath()), "^match.*");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)paths.size()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)4), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)4), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                Seq pathNames = (Seq)paths.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Path x$1) {
                        return x$1.getName();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)pathNames, "contains", (Object)"match1", pathNames.contains((Object)"match1"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)pathNames, "contains", (Object)"match2", pathNames.contains((Object)"match2"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)pathNames, "contains", (Object)"match3", pathNames.contains((Object)"match3"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)pathNames, "contains", (Object)"match5", pathNames.contains((Object)"match5"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
            }

            /*
             * WARNING - void declaration
             */
            private final File createDir$1(File dir, String name) {
                void var3_3;
                File dirFile = new File(dir, name);
                dirFile.mkdir();
                return var3_3;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

