/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.avro.Schema;
import org.apache.log4j.Level;
import org.apache.spark.Partitioner;
import org.apache.spark.RangePartitioner;
import org.apache.spark.RangePartitioner$;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferencePosition$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceDictionary$;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.projections.AlignmentRecordField$;
import org.bdgenomics.adam.projections.FieldValue;
import org.bdgenomics.adam.projections.Projection$;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.GenomicRegionPartitioner;
import org.bdgenomics.adam.rdd.GenomicRegionPartitioner$;
import org.bdgenomics.adam.rdd.GenomicRegionPartitionerSuite$;
import org.bdgenomics.adam.util.SparkFunSuite;
import org.bdgenomics.adam.util.SparkFunSuite$class;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.formats.avro.Contig;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfter;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001\u0017\tir)\u001a8p[&\u001c'+Z4j_:\u0004\u0016M\u001d;ji&|g.\u001a:Tk&$XM\u0003\u0002\u0004\t\u0005\u0019!\u000f\u001a3\u000b\u0005\u00151\u0011\u0001B1eC6T!a\u0002\u0005\u0002\u0015\t$w-\u001a8p[&\u001c7OC\u0001\n\u0003\ry'oZ\u0002\u0001'\r\u0001AB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0003\u001f!\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005Eq!\u0001\u0003$v]N+\u0018\u000e^3\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011\u0001B;uS2L!a\u0006\u000b\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0003\u001f\u0001\u0011\u0005q$\u0001\u0006bI\u0006l'+Z2pe\u0012$R\u0001\t\u00155mm\u0002\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\t\u00054(o\u001c\u0006\u0003K\u0019\tqAZ8s[\u0006$8/\u0003\u0002(E\ty\u0011\t\\5h]6,g\u000e\u001e*fG>\u0014H\rC\u0003*;\u0001\u0007!&A\u0007sK\u001a,'/\u001a8dK:\u000bW.\u001a\t\u0003WEr!\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\na\u0001\u0015:fI\u00164\u0017B\u0001\u001a4\u0005\u0019\u0019FO]5oO*\u0011\u0001'\f\u0005\u0006ku\u0001\rAK\u0001\te\u0016\fGMT1nK\")q'\ba\u0001q\u0005)1\u000f^1siB\u0011A&O\u0005\u0003u5\u0012A\u0001T8oO\")A(\ba\u0001{\u0005Q!/Z1e\u001b\u0006\u0004\b/\u001a3\u0011\u00051r\u0014BA .\u0005\u001d\u0011un\u001c7fC:DQ!\u0011\u0001\u0005\u0002\t\u000baA]3d_J$GcA\"J\u0017B\u0011AiR\u0007\u0002\u000b*\u0011a\tB\u0001\u0007[>$W\r\\:\n\u0005!+%AD*fcV,gnY3SK\u000e|'\u000f\u001a\u0005\u0006\u0015\u0002\u0003\rAK\u0001\u0005]\u0006lW\rC\u0003M\u0001\u0002\u0007\u0001(\u0001\u0004mK:<G\u000f\u001b")
public class GenomicRegionPartitionerSuite
extends FunSuite
implements SparkFunSuite {
    private SparkContext sc;
    private Option<Map<String, Level>> maybeLevels;
    private final String appName;
    private final String master;
    private final Map<String, String> properties;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public Option<Map<String, Level>> maybeLevels() {
        return this.maybeLevels;
    }

    @Override
    public void maybeLevels_$eq(Option<Map<String, Level>> x$1) {
        this.maybeLevels = x$1;
    }

    @Override
    public String appName() {
        return this.appName;
    }

    @Override
    public String master() {
        return this.master;
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    @Override
    public void org$bdgenomics$adam$util$SparkFunSuite$_setter_$appName_$eq(String x$1) {
        this.appName = x$1;
    }

    @Override
    public void org$bdgenomics$adam$util$SparkFunSuite$_setter_$master_$eq(String x$1) {
        this.master = x$1;
    }

    @Override
    public void org$bdgenomics$adam$util$SparkFunSuite$_setter_$properties_$eq(Map x$1) {
        this.properties = x$1;
    }

    @Override
    public void setupSparkContext(String sparkName, boolean silenceSpark) {
        SparkFunSuite$class.setupSparkContext(this, sparkName, silenceSpark);
    }

    @Override
    public void teardownSparkContext() {
        SparkFunSuite$class.teardownSparkContext(this);
    }

    @Override
    public void sparkBefore(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkBefore(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkAfter(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkAfter(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkTest(String name, boolean silenceSpark, Seq<Tag> tags, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, silenceSpark, tags, body);
    }

    @Override
    public void sparkTest(String name, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, body);
    }

    @Override
    public String testFile(String name) {
        return SparkFunSuite$class.testFile(this, name);
    }

    @Override
    public boolean sparkBefore$default$2() {
        return SparkFunSuite$class.sparkBefore$default$2(this);
    }

    @Override
    public boolean setupSparkContext$default$2() {
        return SparkFunSuite$class.setupSparkContext$default$2(this);
    }

    @Override
    public boolean sparkAfter$default$2() {
        return SparkFunSuite$class.sparkAfter$default$2(this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public Status org$scalatest$BeforeAndAfter$$super$runTest(String testName, Args args) {
        return FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Args)args);
    }

    public Status org$scalatest$BeforeAndAfter$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Args)args);
    }

    public AlignmentRecord adamRecord(String referenceName, String readName, long start, boolean readMapped) {
        Contig contig = Contig.newBuilder().setContigName(referenceName).build();
        return AlignmentRecord.newBuilder().setContig(contig).setReadName(readName).setReadMapped(Predef$.MODULE$.boolean2Boolean(readMapped)).setStart(Predef$.MODULE$.long2Long(start)).build();
    }

    public SequenceRecord record(String name, long length) {
        return SequenceRecord$.MODULE$.apply(name.toString(), (long)((int)length), SequenceRecord$.MODULE$.apply$default$3(), SequenceRecord$.MODULE$.apply$default$4(), SequenceRecord$.MODULE$.apply$default$5(), SequenceRecord$.MODULE$.apply$default$6(), SequenceRecord$.MODULE$.apply$default$7(), SequenceRecord$.MODULE$.apply$default$8());
    }

    public GenomicRegionPartitionerSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        SparkFunSuite$class.$init$(this);
        this.test("partitions the UNMAPPED ReferencePosition into the top partition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenomicRegionPartitionerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenomicRegionPartitioner parter = GenomicRegionPartitioner$.MODULE$.apply(10, SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", 1000L)})));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.numPartitions()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)11), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)11), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)ReferencePosition$.MODULE$.UNMAPPED())));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)10), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("partitioning into N pieces on M total sequence length, where N > M, results in M partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenomicRegionPartitionerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenomicRegionPartitioner parter = GenomicRegionPartitioner$.MODULE$.apply(10, SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", 9L)})));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.numPartitions()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)10), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("correctly partitions a single dummy sequence into two pieces", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenomicRegionPartitionerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenomicRegionPartitioner parter = GenomicRegionPartitioner$.MODULE$.apply(2, SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", 10L)})));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition("foo", 3L))));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)0), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition("foo", 7L))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("correctly counts cumulative lengths", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenomicRegionPartitionerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenomicRegionPartitioner parter = GenomicRegionPartitioner$.MODULE$.apply(3, SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("foo", 20L), this.$outer.record("bar", 10L)})));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(parter.cumulativeLengths().apply((Object)"bar"));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)0), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(parter.cumulativeLengths().apply((Object)"foo"));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)10), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("correctly partitions positions across two dummy sequences", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenomicRegionPartitionerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenomicRegionPartitioner parter = GenomicRegionPartitioner$.MODULE$.apply(3, SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record("bar", 20L), this.$outer.record("foo", 10L)})));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition("foo", 8L))));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)2), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition("foo", 18L))));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)3), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition("bar", 18L))));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition("bar", 8L))));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)0), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition("foo", 0L))));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)BoxesRunTime.boxToInteger((int)2), $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left6 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition("foo", 10L))));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "===", (Object)BoxesRunTime.boxToInteger((int)3), $org_scalatest_assert_macro_left6.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"");
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left7 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition("bar", 0L))));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "===", (Object)BoxesRunTime.boxToInteger((int)0), $org_scalatest_assert_macro_left7.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("test that we can range partition ADAMRecords", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ GenomicRegionPartitionerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Random rand = new Random(1000L);
                Predef$ predef$ = Predef$.MODULE$;
                RDD pos = this.$outer.sc().parallelize((Seq)RichInt$.MODULE$.to$extension0(1, 1000).map((Function1)new Serializable(this, rand){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    private final Random rand$1;

                    public final AlignmentRecord apply(int i) {
                        Predef$ predef$ = Predef$.MODULE$;
                        return this.$outer.$outer.adamRecord("chr1", new StringOps("read_%d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), this.rand$1.nextInt(100), true);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.rand$1 = rand$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom()), 1, ClassTag$.MODULE$.apply(AlignmentRecord.class));
                RDD pairs = pos.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<ReferencePosition, AlignmentRecord> apply(AlignmentRecord p) {
                        return new Tuple2((Object)new ReferencePosition(p.getContig().getContigName(), Predef$.MODULE$.Long2long(p.getStart())), (Object)p);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                RangePartitioner parter = new RangePartitioner(200, pairs, RangePartitioner$.MODULE$.$lessinit$greater$default$3(), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()), ClassTag$.MODULE$.apply(ReferencePosition.class));
                OrderedRDDFunctions qual$1 = SparkContext$.MODULE$.rddToOrderedRDDFunctions(pairs, Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()), ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(AlignmentRecord.class));
                boolean x$2 = qual$1.sortByKey$default$1();
                int x$3 = qual$1.sortByKey$default$2();
                RDD partitioned = SparkContext$.MODULE$.rddToPairRDDFunctions(qual$1.sortByKey(x$2, x$3), ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(AlignmentRecord.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms())).partitionBy((Partitioner)parter);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)partitioned.count()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)1000), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1000), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                int $org_scalatest_assert_macro_left2 = partitioned.partitions().length;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)1), $org_scalatest_assert_macro_left2 > 1);
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            }

            public /* synthetic */ GenomicRegionPartitionerSuite org$bdgenomics$adam$rdd$GenomicRegionPartitionerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("test that simple partitioning works okay on a reasonable set of ADAMRecords", (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenomicRegionPartitionerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String filename = ClassLoader.getSystemClassLoader().getResource("reads12.sam").getFile();
                SequenceDictionary dict = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc()).adamDictionaryLoad(filename, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(AlignmentRecord.class));
                GenomicRegionPartitioner parter = GenomicRegionPartitioner$.MODULE$.apply(1, dict);
                Schema p = Projection$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{AlignmentRecordField$.MODULE$.contig(), AlignmentRecordField$.MODULE$.start(), AlignmentRecordField$.MODULE$.readName(), AlignmentRecordField$.MODULE$.readMapped()}));
                ADAMContext qual$2 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc());
                Some x$5 = new Some((Object)p);
                None$ x$6 = qual$2.loadAlignments$default$2();
                RDD rdd = qual$2.loadAlignments(filename, (Option)x$6, (Option)x$5);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rdd.count()));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)200), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)200), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
                OrderedRDDFunctions qual$3 = SparkContext$.MODULE$.rddToOrderedRDDFunctions(rdd.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<ReferencePosition, AlignmentRecord> apply(AlignmentRecord rec) {
                        return new Tuple2((Object)new ReferencePosition(rec.getContig().getContigName(), Predef$.MODULE$.Long2long(rec.getStart())), (Object)rec);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class)), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()), ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(AlignmentRecord.class));
                boolean x$7 = qual$3.sortByKey$default$1();
                int x$8 = qual$3.sortByKey$default$2();
                RDD keyed = qual$3.sortByKey(x$7, x$8);
                ReferencePosition[] keys = (ReferencePosition[])keyed.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ReferencePosition apply(Tuple2<ReferencePosition, AlignmentRecord> x$1) {
                        return (ReferencePosition)x$1._1();
                    }
                }, ClassTag$.MODULE$.apply(ReferencePosition.class)).collect();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(Predef$.MODULE$.refArrayOps((Object[])keys).exists((Function1)new Serializable(this, 1, parter){
                    public static final long serialVersionUID = 0L;
                    private final int parts$1;
                    private final GenomicRegionPartitioner parter$1;

                    public final boolean apply(ReferencePosition rp) {
                        return this.parter$1.getPartition((Object)rp) < 0 || this.parter$1.getPartition((Object)rp) >= this.parts$1;
                    }
                    {
                        this.parts$1 = parts$1;
                        this.parter$1 = parter$1;
                    }
                }), "scala.this.Predef.refArrayOps[org.bdgenomics.adam.models.ReferencePosition](keys).exists(((rp: org.bdgenomics.adam.models.ReferencePosition) => parter.getPartition(rp).<(0).||(parter.getPartition(rp).>=(parts))))"));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
                RDD partitioned = SparkContext$.MODULE$.rddToPairRDDFunctions(keyed, ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(AlignmentRecord.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms())).partitionBy((Partitioner)parter);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)partitioned.count()));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)200), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)200), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"");
                RDD partSizes = partitioned.mapPartitions((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterator<Object> apply(Iterator<Tuple2<ReferencePosition, AlignmentRecord>> itr) {
                        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{itr.size()})).iterator();
                    }
                }, partitioned.mapPartitions$default$2(), ClassTag$.MODULE$.Int());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)partSizes.count()));
                int $org_scalatest_assert_macro_right = 1 + 1;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

