/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.read.realignment;

import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext$;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator;
import org.bdgenomics.adam.models.Consensus;
import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferencePosition$;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.rdd.read.realignment.IndelRealignmentTarget;
import org.bdgenomics.adam.rdd.read.realignment.RealignIndels$;
import org.bdgenomics.adam.rdd.read.realignment.RealignmentTargetFinder$;
import org.bdgenomics.adam.rdd.read.realignment.ZippedTargetSet;
import org.bdgenomics.adam.rich.RichAlignmentRecord;
import org.bdgenomics.adam.rich.RichAlignmentRecord$;
import org.bdgenomics.adam.util.ImplicitJavaConversions$;
import org.bdgenomics.adam.util.MdTag;
import org.bdgenomics.adam.util.MdTag$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.TreeSet;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\t-sAB\u0001\u0003\u0011\u00031a\"A\u0007SK\u0006d\u0017n\u001a8J]\u0012,Gn\u001d\u0006\u0003\u0007\u0011\t1B]3bY&<g.\\3oi*\u0011QAB\u0001\u0005e\u0016\fGM\u0003\u0002\b\u0011\u0005\u0019!\u000f\u001a3\u000b\u0005%Q\u0011\u0001B1eC6T!a\u0003\u0007\u0002\u0015\t$w-\u001a8p[&\u001c7OC\u0001\u000e\u0003\ry'o\u001a\t\u0003\u001fAi\u0011A\u0001\u0004\u0007#\tA\tA\u0002\n\u0003\u001bI+\u0017\r\\5h]&sG-\u001a7t'\u0011\u00012#\u0007\u000f\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\r\u0005s\u0017PU3g!\t!\"$\u0003\u0002\u001c+\ta1+\u001a:jC2L'0\u00192mKB\u0011QDI\u0007\u0002=)\u0011q\u0004I\u0001\u0006gB\f'o\u001b\u0006\u0003C1\ta!\u00199bG\",\u0017BA\u0012\u001f\u0005\u001daunZ4j]\u001eDQ!\n\t\u0005\u0002\u001d\na\u0001P5oSRt4\u0001\u0001\u000b\u0002\u001d!)\u0011\u0006\u0005C\u0001U\u0005)\u0011\r\u001d9msRA1\u0006O\u001dD\u00116{E\u000bE\u0002-]Aj\u0011!\f\u0006\u0003\u000fyI!aL\u0017\u0003\u0007I#E\t\u0005\u00022m5\t!G\u0003\u00024i\u0005!\u0011M\u001e:p\u0015\t)$\"A\u0004g_Jl\u0017\r^:\n\u0005]\u0012$aD!mS\u001etW.\u001a8u%\u0016\u001cwN\u001d3\t\u000b\u001dA\u0003\u0019A\u0016\t\u000fiB\u0003\u0013!a\u0001w\u0005q1m\u001c8tK:\u001cXo]'pI\u0016d\u0007C\u0001\u001fB\u001b\u0005i$B\u0001 @\u0003%\u0019wN\\:f]N,8O\u0003\u0002A\u0011\u0005Q\u0011\r\\4pe&$\b.\\:\n\u0005\tk$AE\"p]N,gn];t\u000f\u0016tWM]1u_JDq\u0001\u0012\u0015\u0011\u0002\u0003\u0007Q)\u0001\u0007eCR\f\u0017j]*peR,G\r\u0005\u0002\u0015\r&\u0011q)\u0006\u0002\b\u0005>|G.Z1o\u0011\u001dI\u0005\u0006%AA\u0002)\u000bA\"\\1y\u0013:$W\r\\*ju\u0016\u0004\"\u0001F&\n\u00051+\"aA%oi\"9a\n\u000bI\u0001\u0002\u0004Q\u0015AE7bq\u000e{gn]3ogV\u001ch*^7cKJDq\u0001\u0015\u0015\u0011\u0002\u0003\u0007\u0011+\u0001\u0007m_\u0012$\u0006N]3tQ>dG\r\u0005\u0002\u0015%&\u00111+\u0006\u0002\u0007\t>,(\r\\3\t\u000fUC\u0003\u0013!a\u0001\u0015\u0006iQ.\u0019=UCJ<W\r^*ju\u0016DQa\u0016\t\u0005\u0006a\u000b1\"\\1q)>$\u0016M]4fiR\u0019!*\u00171\t\u000b\u00151\u0006\u0019\u0001.\u0011\u0005msV\"\u0001/\u000b\u0005uC\u0011\u0001\u0002:jG\"L!a\u0018/\u0003'IK7\r[!mS\u001etW.\u001a8u%\u0016\u001cwN\u001d3\t\u000b\u00054\u0006\u0019\u00012\u0002\u000fQ\f'oZ3ugB\u00191\r\u001b6\u000e\u0003\u0011T!!\u001a4\u0002\u0013%lW.\u001e;bE2,'BA4\u0016\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003S\u0012\u0014q\u0001\u0016:fKN+G\u000f\u0005\u0003\u0015W6T\u0015B\u00017\u0016\u0005\u0019!V\u000f\u001d7feA\u0011qB\\\u0005\u0003_\n\u0011a#\u00138eK2\u0014V-\u00197jO:lWM\u001c;UCJ<W\r\u001e\u0015\u0003-F\u0004\"A];\u000e\u0003MT!\u0001^\u000b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002wg\n9A/Y5me\u0016\u001c\u0007\"B,\u0011\t\u0003AHc\u0001&zu\")Qa\u001ea\u00015\")\u0011m\u001ea\u0001wB\u0011q\u0002`\u0005\u0003{\n\u0011qBW5qa\u0016$G+\u0019:hKR\u001cV\r\u001e\u0005\u0007\u007fB!\t!!\u0001\u0002'5\f\u0007\u000fV8UCJ<W\r^+oa\u0006\u001c7.\u001a3\u0015\r\u0005\r\u0011\u0011BA\u0007!\u0011!\u0012QA7\n\u0007\u0005\u001dQC\u0001\u0004PaRLwN\u001c\u0005\u0007\u0003\u0017q\b\u0019\u0001&\u0002\u0017Q\f'oZ3u\u0013:$W\r\u001f\u0005\u0006Cz\u0004\rA\u0019\u0005\u0007/B!\t!!\u0005\u0015\r\u0005\r\u00111CA\u000b\u0011\u001d\tY!a\u0004A\u0002)Ca!YA\b\u0001\u0004Y\bbBA\r!\u0011\u0005\u00111D\u0001\u000b[\u0006\u0004H+\u0019:hKR\u001cHCBA\u000f\u0003s\ty\u0004\u0005\u0003-]\u0005}\u0001C\u0002\u000bl\u0003\u0007\t\t\u0003E\u0003\u0002$\u0005M\"L\u0004\u0003\u0002&\u0005=b\u0002BA\u0014\u0003[i!!!\u000b\u000b\u0007\u0005-b%\u0001\u0004=e>|GOP\u0005\u0002-%\u0019\u0011\u0011G\u000b\u0002\u000fA\f7m[1hK&!\u0011QGA\u001c\u0005!IE/\u001a:bE2,'bAA\u0019+!A\u00111HA\f\u0001\u0004\ti$\u0001\u0005sS\u000eDwL\u001d3e!\racF\u0017\u0005\bC\u0006]\u0001\u0019AA!!\r\u0019\u0007.\u001c\u0005\b\u0003\u000b\u0002B\u0011AA$\u0003U9W\r\u001e*fM\u0016\u0014XM\\2f\rJ|WNU3bIN$B!!\u0013\u0002dAIA#a\u0013\u0002P\u0005u\u0013QL\u0005\u0004\u0003\u001b*\"A\u0002+va2,7\u0007\u0005\u0003\u0002R\u0005]cb\u0001\u000b\u0002T%\u0019\u0011QK\u000b\u0002\rA\u0013X\rZ3g\u0013\u0011\tI&a\u0017\u0003\rM#(/\u001b8h\u0015\r\t)&\u0006\t\u0004)\u0005}\u0013bAA1+\t!Aj\u001c8h\u0011!\t)'a\u0011A\u0002\u0005\u0005\u0012!\u0002:fC\u0012\u001c\b\"CA5!E\u0005I\u0011AA6\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012TCAA7U\rY\u0014qN\u0016\u0003\u0003c\u0002B!a\u001d\u0002z5\u0011\u0011Q\u000f\u0006\u0004\u0003o\u001a\u0018!C;oG\",7m[3e\u0013\u0011\tY(!\u001e\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002\u0000A\t\n\u0011\"\u0001\u0002\u0002\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0004*\u001aQ)a\u001c\t\u0013\u0005\u001d\u0005#%A\u0005\u0002\u0005%\u0015aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005-%f\u0001&\u0002p!I\u0011q\u0012\t\u0012\u0002\u0013\u0005\u0011\u0011R\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%k!I\u00111\u0013\t\u0012\u0002\u0013\u0005\u0011QS\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u0011q\u0013\u0016\u0004#\u0006=\u0004\"CAN!E\u0005I\u0011AAE\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012:\u0004\"CAP!E\u0005I\u0011AA6\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c!I\u00111\u0015\t\u0012\u0002\u0013\u0005\u0011\u0011Q\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\t\u0013\u0005\u001d\u0006#%A\u0005\u0002\u0005%\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$3\u0007C\u0005\u0002,B\t\n\u0011\"\u0001\u0002\n\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQB\u0011\"a,\u0011#\u0003%\t!!&\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0011%\t\u0019\fEI\u0001\n\u0003\tI)A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HE\u000e\u0005\n\u0003o\u0003\u0012\u0011!C\u0005\u0003s\u000b1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0018\t\u0005\u0003{\u000b9-\u0004\u0002\u0002@*!\u0011\u0011YAb\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0017\u0001\u00026bm\u0006LA!!3\u0002@\n1qJ\u00196fGR4a!\u0005\u0002\u0001\r\u000557#BAf'ea\u0002B\u0003\u001e\u0002L\n\u0015\r\u0011\"\u0001\u0002RV\t1\b\u0003\u0006\u0002V\u0006-'\u0011!Q\u0001\nm\nqbY8og\u0016t7/^:N_\u0012,G\u000e\t\u0005\u000b\t\u0006-'Q1A\u0005\u0002\u0005eW#A#\t\u0015\u0005u\u00171\u001aB\u0001B\u0003%Q)A\u0007eCR\f\u0017j]*peR,G\r\t\u0005\u000b\u0013\u0006-'Q1A\u0005\u0002\u0005\u0005X#\u0001&\t\u0015\u0005\u0015\u00181\u001aB\u0001B\u0003%!*A\u0007nCbLe\u000eZ3m'&TX\r\t\u0005\u000b\u001d\u0006-'Q1A\u0005\u0002\u0005\u0005\bBCAv\u0003\u0017\u0014\t\u0011)A\u0005\u0015\u0006\u0019R.\u0019=D_:\u001cXM\\:vg:+XNY3sA!Q\u0001+a3\u0003\u0006\u0004%\t!a<\u0016\u0003EC!\"a=\u0002L\n\u0005\t\u0015!\u0003R\u00035aw\u000e\u001a+ie\u0016\u001c\bn\u001c7eA!QQ+a3\u0003\u0006\u0004%\t!!9\t\u0015\u0005e\u00181\u001aB\u0001B\u0003%!*\u0001\bnCb$\u0016M]4fiNK'0\u001a\u0011\t\u000f\u0015\nY\r\"\u0001\u0002~Rq\u0011q B\u0001\u0005\u0007\u0011)Aa\u0002\u0003\n\t-\u0001cA\b\u0002L\"A!(a?\u0011\u0002\u0003\u00071\b\u0003\u0005E\u0003w\u0004\n\u00111\u0001F\u0011!I\u00151 I\u0001\u0002\u0004Q\u0005\u0002\u0003(\u0002|B\u0005\t\u0019\u0001&\t\u0011A\u000bY\u0010%AA\u0002EC\u0001\"VA~!\u0003\u0005\rA\u0013\u0005\t\u0005\u001f\tY\r\"\u0001\u0003\u0012\u0005\u0011\"/Z1mS\u001etG+\u0019:hKR<%o\\;q)\u0011\t\tCa\u0005\t\u0011\tU!Q\u0002a\u0001\u0003?\t1\u0002^1sO\u0016$xI]8va\"A!\u0011DAf\t\u0003\u0011Y\"\u0001\u0011to\u0016,\u0007OU3bI>3XM\u001d*fM\u0016\u0014XM\\2f\r>\u0014\u0018+^1mSRLH\u0003\u0003B\u000f\u0005?\u0011\tC!\n\u0011\tQY'J\u0013\u0005\b\u000b\t]\u0001\u0019AA(\u0011!\u0011\u0019Ca\u0006A\u0002\u0005=\u0013!\u0003:fM\u0016\u0014XM\\2f\u0011!\u00119Ca\u0006A\u0002\t%\u0012!C9vC2LG/[3t!\u0015\t\u0019Ca\u000bK\u0013\u0011\u0011i#a\u000e\u0003\u0007M+\u0017\u000f\u0003\u0005\u00032\u0005-G\u0011\u0001B\u001a\u0003u\u0019X/\\'jg6\fGo\u00195Rk\u0006d\u0017\u000e^=JO:|'/Z\"jO\u0006\u0014Hc\u0002&\u00036\t]\"\u0011\b\u0005\b\u000b\t=\u0002\u0019AA(\u0011!\u0011\u0019Ca\fA\u0002\u0005=\u0003\u0002\u0003B\u0014\u0005_\u0001\rA!\u000b\t\u0011\tu\u00121\u001aC\u0001\u0005\u007f\t!c];n\u001b&\u001cX.\u0019;dQF+\u0018\r\\5usR\u0019!J!\u0011\t\r\u0015\u0011Y\u00041\u00011\u0011!\u0011)%a3\u0005\u0002\t\u001d\u0013!\u0004:fC2LwM\\%oI\u0016d7\u000fF\u0002,\u0005\u0013Baa\u0002B\"\u0001\u0004Y\u0003")
public class RealignIndels
implements Serializable,
Logging {
    private final ConsensusGenerator consensusModel;
    private final boolean dataIsSorted;
    private final int maxIndelSize;
    private final int maxConsensusNumber;
    private final double lodThreshold;
    private final int maxTargetSize;
    private transient Logger org$apache$spark$Logging$$log_;

    public static int $lessinit$greater$default$6() {
        return RealignIndels$.MODULE$.$lessinit$greater$default$6();
    }

    public static double $lessinit$greater$default$5() {
        return RealignIndels$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return RealignIndels$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return RealignIndels$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$2() {
        return RealignIndels$.MODULE$.$lessinit$greater$default$2();
    }

    public static ConsensusGenerator $lessinit$greater$default$1() {
        return RealignIndels$.MODULE$.$lessinit$greater$default$1();
    }

    public static int apply$default$7() {
        return RealignIndels$.MODULE$.apply$default$7();
    }

    public static double apply$default$6() {
        return RealignIndels$.MODULE$.apply$default$6();
    }

    public static int apply$default$5() {
        return RealignIndels$.MODULE$.apply$default$5();
    }

    public static int apply$default$4() {
        return RealignIndels$.MODULE$.apply$default$4();
    }

    public static boolean apply$default$3() {
        return RealignIndels$.MODULE$.apply$default$3();
    }

    public static ConsensusGenerator apply$default$2() {
        return RealignIndels$.MODULE$.apply$default$2();
    }

    public static Tuple3<String, Object, Object> getReferenceFromReads(Iterable<RichAlignmentRecord> iterable) {
        return RealignIndels$.MODULE$.getReferenceFromReads(iterable);
    }

    public static RDD<Tuple2<Option<IndelRealignmentTarget>, Iterable<RichAlignmentRecord>>> mapTargets(RDD<RichAlignmentRecord> rDD, TreeSet<IndelRealignmentTarget> treeSet) {
        return RealignIndels$.MODULE$.mapTargets(rDD, treeSet);
    }

    public static Option<IndelRealignmentTarget> mapToTarget(int n, ZippedTargetSet zippedTargetSet) {
        return RealignIndels$.MODULE$.mapToTarget(n, zippedTargetSet);
    }

    public static Option<IndelRealignmentTarget> mapToTargetUnpacked(int n, TreeSet<Tuple2<IndelRealignmentTarget, Object>> treeSet) {
        return RealignIndels$.MODULE$.mapToTargetUnpacked(n, treeSet);
    }

    public static int mapToTarget(RichAlignmentRecord richAlignmentRecord, ZippedTargetSet zippedTargetSet) {
        return RealignIndels$.MODULE$.mapToTarget(richAlignmentRecord, zippedTargetSet);
    }

    public static int mapToTarget(RichAlignmentRecord richAlignmentRecord, TreeSet<Tuple2<IndelRealignmentTarget, Object>> treeSet) {
        return RealignIndels$.MODULE$.mapToTarget(richAlignmentRecord, treeSet);
    }

    public static RDD<AlignmentRecord> apply(RDD<AlignmentRecord> rDD, ConsensusGenerator consensusGenerator, boolean bl, int n, int n2, double d, int n3) {
        return RealignIndels$.MODULE$.apply(rDD, consensusGenerator, bl, n, n2, d, n3);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public ConsensusGenerator consensusModel() {
        return this.consensusModel;
    }

    public boolean dataIsSorted() {
        return this.dataIsSorted;
    }

    public int maxIndelSize() {
        return this.maxIndelSize;
    }

    public int maxConsensusNumber() {
        return this.maxConsensusNumber;
    }

    public double lodThreshold() {
        return this.lodThreshold;
    }

    public int maxTargetSize() {
        return this.maxTargetSize;
    }

    public Iterable<RichAlignmentRecord> realignTargetGroup(Tuple2<Option<IndelRealignmentTarget>, Iterable<RichAlignmentRecord>> targetGroup) {
        Tuple2<Option<IndelRealignmentTarget>, Iterable<RichAlignmentRecord>> tuple2;
        block9: {
            Tuple3<String, Object, Object> tuple3;
            block12: {
                Iterable iterable;
                block11: {
                    Tuple3 tuple32;
                    Iterable reads;
                    block10: {
                        Tuple2 tuple22;
                        tuple2 = targetGroup;
                        if (tuple2 == null) break block9;
                        Option target = (Option)tuple2._1();
                        Iterable reads2 = (Iterable)tuple2._2();
                        Tuple2 tuple23 = tuple22 = new Tuple2((Object)target, (Object)reads2);
                        Option target2 = (Option)tuple23._1();
                        reads = (Iterable)tuple23._2();
                        if (!target2.isEmpty()) break block10;
                        iterable = reads;
                        break block11;
                    }
                    Iterable realignedReads = (Iterable)reads.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(RichAlignmentRecord r) {
                            return r.mdTag().isDefined() && !((MdTag)r.mdTag().get()).hasMismatches();
                        }
                    });
                    tuple3 = RealignIndels$.MODULE$.getReferenceFromReads((Iterable<RichAlignmentRecord>)((Iterable)reads.map((Function1)new $anonfun$10(this), Iterable$.MODULE$.canBuildFrom())));
                    if (tuple3 == null) break block12;
                    String reference = (String)tuple3._1();
                    long refStart = BoxesRunTime.unboxToLong((Object)tuple3._2());
                    long refEnd = BoxesRunTime.unboxToLong((Object)tuple3._3());
                    Tuple3 tuple33 = tuple32 = new Tuple3((Object)reference, (Object)BoxesRunTime.boxToLong((long)refStart), (Object)BoxesRunTime.boxToLong((long)refEnd));
                    String reference2 = (String)tuple33._1();
                    long refStart2 = BoxesRunTime.unboxToLong((Object)tuple33._2());
                    long refEnd2 = BoxesRunTime.unboxToLong((Object)tuple33._3());
                    ReferenceRegion refRegion = new ReferenceRegion(((RichAlignmentRecord)reads.head()).record().getContig().getContigName(), refStart2, refEnd2);
                    Iterable<RichAlignmentRecord> readsToClean = this.consensusModel().preprocessReadsForRealignment((Iterable<RichAlignmentRecord>)((Iterable)reads.filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(RichAlignmentRecord r) {
                            return !r.mdTag().isDefined() || ((MdTag)r.mdTag().get()).hasMismatches();
                        }
                    })), reference2, refRegion);
                    Iterable consensus = this.consensusModel().findConsensus(readsToClean);
                    if (consensus.size() > this.maxConsensusNumber()) {
                        Random r = new Random();
                        consensus = (Iterable)((IterableLike)r.shuffle(consensus, Iterable$.MODULE$.canBuildFrom())).take(this.maxConsensusNumber());
                    }
                    if (readsToClean.size() > 0 && consensus.size() > 0) {
                        Tuple3 bestConsensusTuple;
                        int totalMismatchSumPreCleaning = BoxesRunTime.unboxToInt((Object)((TraversableOnce)readsToClean.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ RealignIndels $outer;

                            public final int apply(RichAlignmentRecord x$7) {
                                return this.$outer.sumMismatchQuality(RichAlignmentRecord$.MODULE$.richRecordToRecord(x$7));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, Iterable$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(int x$8, int x$9) {
                                return this.apply$mcIII$sp(x$8, x$9);
                            }

                            public int apply$mcIII$sp(int x$8, int x$9) {
                                return x$8 + x$9;
                            }
                        }));
                        ObjectRef consensusOutcomes = new ObjectRef((Object)Nil$.MODULE$);
                        consensus.foreach((Function1)new Serializable(this, reference2, refStart2, refEnd2, readsToClean, consensusOutcomes){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ RealignIndels $outer;
                            private final String reference$1;
                            private final long refStart$1;
                            private final long refEnd$1;
                            private final Iterable readsToClean$1;
                            private final ObjectRef consensusOutcomes$1;

                            public final void apply(Consensus c) {
                                String consensusSequence = c.insertIntoReference(this.reference$1, this.refStart$1, this.refEnd$1);
                                Iterable sweptValues = (Iterable)this.readsToClean$1.map((Function1)new Serializable(this, consensusSequence){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$realignTargetGroup$1 $outer;
                                    private final String consensusSequence$1;

                                    public final Tuple2<RichAlignmentRecord, Tuple2<Object, Object>> apply(RichAlignmentRecord r) {
                                        Tuple2<Object, Object> tuple2 = this.$outer.org$bdgenomics$adam$rdd$read$realignment$RealignIndels$$anonfun$$$outer().sweepReadOverReferenceForQuality(RichAlignmentRecord$.MODULE$.richRecordToRecord(r).getSequence(), this.consensusSequence$1, (Seq<Object>)Predef$.MODULE$.wrapIntArray(r.qualityScores()));
                                        if (tuple2 != null) {
                                            Tuple2.mcII.sp sp2;
                                            int qual = tuple2._1$mcI$sp();
                                            int pos = tuple2._2$mcI$sp();
                                            Tuple2.mcII.sp sp3 = sp2 = new Tuple2.mcII.sp(qual, pos);
                                            int qual2 = sp3._1$mcI$sp();
                                            int pos2 = sp3._2$mcI$sp();
                                            int originalQual = this.$outer.org$bdgenomics$adam$rdd$read$realignment$RealignIndels$$anonfun$$$outer().sumMismatchQuality(RichAlignmentRecord$.MODULE$.richRecordToRecord(r));
                                            return qual2 < originalQual ? new Tuple2((Object)r, (Object)new Tuple2.mcII.sp(qual2, pos2)) : new Tuple2((Object)r, (Object)new Tuple2.mcII.sp(originalQual, -1));
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.consensusSequence$1 = consensusSequence$1;
                                    }
                                }, Iterable$.MODULE$.canBuildFrom());
                                int totalQuality = BoxesRunTime.unboxToInt((Object)((TraversableOnce)sweptValues.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply(Tuple2<RichAlignmentRecord, Tuple2<Object, Object>> x$11) {
                                        return ((Tuple2)x$11._2())._1$mcI$sp();
                                    }
                                }, Iterable$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply(int x$12, int x$13) {
                                        return this.apply$mcIII$sp(x$12, x$13);
                                    }

                                    public int apply$mcIII$sp(int x$12, int x$13) {
                                        return x$12 + x$13;
                                    }
                                }));
                                ObjectRef readMappings = new ObjectRef((Object)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
                                ((IterableLike)sweptValues.map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Tuple2<RichAlignmentRecord, Object> apply(Tuple2<RichAlignmentRecord, Tuple2<Object, Object>> kv) {
                                        return new Tuple2(kv._1(), (Object)BoxesRunTime.boxToInteger((int)((Tuple2)kv._2())._2$mcI$sp()));
                                    }
                                }, Iterable$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this, readMappings){
                                    public static final long serialVersionUID = 0L;
                                    private final ObjectRef readMappings$1;

                                    public final Map<RichAlignmentRecord, Object> apply(Tuple2<RichAlignmentRecord, Object> m) {
                                        return (Map)((Map)this.readMappings$1.elem).$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(m._1()), (Object)BoxesRunTime.boxToInteger((int)m._2$mcI$sp())));
                                    }
                                    {
                                        this.readMappings$1 = readMappings$1;
                                    }
                                });
                                Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)totalQuality), (Object)c, (Object)((Map)readMappings.elem));
                                this.consensusOutcomes$1.elem = ((List)this.consensusOutcomes$1.elem).$colon$colon((Object)tuple3);
                            }

                            public /* synthetic */ RealignIndels org$bdgenomics$adam$rdd$read$realignment$RealignIndels$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.reference$1 = reference$1;
                                this.refStart$1 = refStart$1;
                                this.refEnd$1 = refEnd$1;
                                this.readsToClean$1 = readsToClean$1;
                                this.consensusOutcomes$1 = consensusOutcomes$1;
                            }
                        });
                        Tuple3 tuple34 = bestConsensusTuple = (Tuple3)((List)consensusOutcomes.elem).reduce((Function2)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Tuple3<Object, Consensus, Map<RichAlignmentRecord, Object>> apply(Tuple3<Object, Consensus, Map<RichAlignmentRecord, Object>> c1, Tuple3<Object, Consensus, Map<RichAlignmentRecord, Object>> c2) {
                                return BoxesRunTime.unboxToInt((Object)c1._1()) <= BoxesRunTime.unboxToInt((Object)c2._1()) ? c1 : c2;
                            }
                        });
                        if (tuple34 != null) {
                            Tuple3 tuple35;
                            int bestConsensusMismatchSum = BoxesRunTime.unboxToInt((Object)tuple34._1());
                            Consensus bestConsensus = (Consensus)tuple34._2();
                            Map bestMappings = (Map)tuple34._3();
                            Tuple3 tuple36 = tuple35 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)bestConsensusMismatchSum), (Object)bestConsensus, (Object)bestMappings);
                            int bestConsensusMismatchSum2 = BoxesRunTime.unboxToInt((Object)tuple36._1());
                            Consensus bestConsensus2 = (Consensus)tuple36._2();
                            Map bestMappings2 = (Map)tuple36._3();
                            this.log().info(new StringBuilder().append((Object)"On ").append((Object)refRegion).append((Object)", before realignment, sum was ").append((Object)BoxesRunTime.boxToInteger((int)totalMismatchSumPreCleaning)).append((Object)", best realignment has ").append((Object)BoxesRunTime.boxToInteger((int)bestConsensusMismatchSum2)).toString());
                            double lodImprovement = (double)(totalMismatchSumPreCleaning - bestConsensusMismatchSum2) / 10.0;
                            if (lodImprovement > this.lodThreshold()) {
                                IntRef realignedReadCount = new IntRef(0);
                                Iterable cleanedReads = (Iterable)readsToClean.map((Function1)new Serializable(this, reference2, refStart2, bestConsensus2, bestMappings2, realignedReadCount){
                                    public static final long serialVersionUID = 0L;
                                    private final String reference$1;
                                    private final long refStart$1;
                                    private final Consensus bestConsensus$1;
                                    private final Map bestMappings$1;
                                    private final IntRef realignedReadCount$1;

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final RichAlignmentRecord apply(RichAlignmentRecord r) {
                                        RichAlignmentRecord richAlignmentRecord;
                                        AlignmentRecord.Builder builder = AlignmentRecord.newBuilder((AlignmentRecord)RichAlignmentRecord$.MODULE$.richRecordToRecord(r));
                                        int remapping = BoxesRunTime.unboxToInt((Object)this.bestMappings$1.apply((Object)r));
                                        if (remapping != -1) {
                                            Tuple3 tuple3;
                                            Tuple3 tuple32;
                                            ++this.realignedReadCount$1.elem;
                                            builder.setMapq(Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(RichAlignmentRecord$.MODULE$.richRecordToRecord(r).getMapq()) + 10));
                                            builder.setStart(Predef$.MODULE$.long2Long(this.refStart$1 + (long)remapping));
                                            Tuple3 tuple33 = tuple32 = this.bestConsensus$1.index().start() == this.bestConsensus$1.index().end() - 1L ? new Tuple3((Object)new CigarElement(this.bestConsensus$1.consensus().length(), CigarOperator.I), (Object)BoxesRunTime.boxToLong((long)((long)(RichAlignmentRecord$.MODULE$.richRecordToRecord(r).getSequence().length() - this.bestConsensus$1.consensus().length()) - (this.bestConsensus$1.index().start() - (this.refStart$1 + (long)remapping)))), (Object)BoxesRunTime.boxToInteger((int)(-this.bestConsensus$1.consensus().length()))) : new Tuple3((Object)new CigarElement((int)(this.bestConsensus$1.index().end() - 1L - this.bestConsensus$1.index().start()), CigarOperator.D), (Object)BoxesRunTime.boxToLong((long)((long)RichAlignmentRecord$.MODULE$.richRecordToRecord(r).getSequence().length() - (this.bestConsensus$1.index().start() - (this.refStart$1 + (long)remapping)))), (Object)BoxesRunTime.boxToInteger((int)this.bestConsensus$1.consensus().length()));
                                            if (tuple32 == null) throw new MatchError((Object)tuple32);
                                            CigarElement idElement = (CigarElement)tuple32._1();
                                            long endLength = BoxesRunTime.unboxToLong((Object)tuple32._2());
                                            int endPenalty = BoxesRunTime.unboxToInt((Object)tuple32._3());
                                            Tuple3 tuple34 = tuple3 = new Tuple3((Object)idElement, (Object)BoxesRunTime.boxToLong((long)endLength), (Object)BoxesRunTime.boxToInteger((int)endPenalty));
                                            CigarElement idElement2 = (CigarElement)tuple34._1();
                                            long endLength2 = BoxesRunTime.unboxToLong((Object)tuple34._2());
                                            int endPenalty2 = BoxesRunTime.unboxToInt((Object)tuple34._3());
                                            builder.setEnd(Predef$.MODULE$.long2Long(this.refStart$1 + (long)remapping + (long)RichAlignmentRecord$.MODULE$.richRecordToRecord(r).getSequence().length() + (long)endPenalty2));
                                            List cigarElements = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CigarElement[]{new CigarElement((int)(this.bestConsensus$1.index().start() - (this.refStart$1 + (long)remapping)), CigarOperator.M), idElement2, new CigarElement((int)endLength2, CigarOperator.M)}));
                                            Cigar newCigar = new Cigar(ImplicitJavaConversions$.MODULE$.listToJavaList(cigarElements));
                                            builder.setMismatchingPositions(MdTag$.MODULE$.moveAlignment(r, newCigar, (String)new StringOps(Predef$.MODULE$.augmentString(this.reference$1)).drop(remapping), this.refStart$1 + (long)remapping).toString());
                                            builder.setOldPosition(RichAlignmentRecord$.MODULE$.richRecordToRecord(r).getStart());
                                            builder.setOldCigar(RichAlignmentRecord$.MODULE$.richRecordToRecord(r).getCigar());
                                            builder.setCigar(newCigar.toString());
                                            richAlignmentRecord = new RichAlignmentRecord(builder.build());
                                            return richAlignmentRecord;
                                        } else {
                                            richAlignmentRecord = new RichAlignmentRecord(builder.build());
                                        }
                                        return richAlignmentRecord;
                                    }
                                    {
                                        this.reference$1 = reference$1;
                                        this.refStart$1 = refStart$1;
                                        this.bestConsensus$1 = bestConsensus$1;
                                        this.bestMappings$1 = bestMappings$1;
                                        this.realignedReadCount$1 = realignedReadCount$1;
                                    }
                                }, Iterable$.MODULE$.canBuildFrom());
                                this.log().info(new StringBuilder().append((Object)"On ").append((Object)refRegion).append((Object)", realigned ").append((Object)BoxesRunTime.boxToInteger((int)realignedReadCount.elem)).append((Object)" reads to ").append((Object)bestConsensus2).append((Object)" due to LOD improvement of ").append((Object)BoxesRunTime.boxToDouble((double)lodImprovement)).toString());
                                realignedReads = (Iterable)cleanedReads.$plus$plus((GenTraversableOnce)realignedReads, Iterable$.MODULE$.canBuildFrom());
                            } else {
                                this.log().info(new StringBuilder().append((Object)"On ").append((Object)refRegion).append((Object)", skipping realignment due to insufficient LOD improvement (").append((Object)BoxesRunTime.boxToDouble((double)lodImprovement)).append((Object)"for consensus ").append((Object)bestConsensus2).toString());
                                realignedReads = (Iterable)readsToClean.$plus$plus((GenTraversableOnce)realignedReads, Iterable$.MODULE$.canBuildFrom());
                            }
                        } else {
                            throw new MatchError((Object)tuple34);
                        }
                    }
                    iterable = realignedReads;
                }
                return iterable;
            }
            throw new MatchError(tuple3);
        }
        throw new MatchError(tuple2);
    }

    public Tuple2<Object, Object> sweepReadOverReferenceForQuality(String read, String reference, Seq<Object> qualities) {
        ObjectRef qualityScores2 = new ObjectRef((Object)Nil$.MODULE$);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), reference.length() - read.length()).foreach$mVc$sp((Function1)new Serializable(this, read, reference, qualities, qualityScores2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RealignIndels $outer;
            private final String read$1;
            private final String reference$2;
            private final Seq qualities$1;
            private final ObjectRef qualityScores$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int qualityScore = this.$outer.sumMismatchQualityIgnoreCigar(this.read$1, this.reference$2.substring(i, i + this.read$1.length()), (Seq<Object>)this.qualities$1);
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(qualityScore, i);
                this.qualityScores$1.elem = ((List)this.qualityScores$1.elem).$colon$colon((Object)sp2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.read$1 = read$1;
                this.reference$2 = reference$2;
                this.qualities$1 = qualities$1;
                this.qualityScores$1 = qualityScores$1;
            }
        });
        return (Tuple2)((List)qualityScores2.elem).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> p1, Tuple2<Object, Object> p2) {
                return p1._1$mcI$sp() < p2._1$mcI$sp() ? p1 : p2;
            }
        });
    }

    public int sumMismatchQualityIgnoreCigar(String read, String reference, Seq<Object> qualities) {
        IndexedSeq mismatchQualities = (IndexedSeq)((TraversableLike)((TraversableLike)((IterableLike)new StringOps(Predef$.MODULE$.augmentString(read)).zip((GenIterable)Predef$.MODULE$.wrapString(reference), Predef$.MODULE$.fallbackStringCanBuildFrom())).zip(qualities, IndexedSeq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Tuple2<Object, Object>, Object> r) {
                return ((Tuple2)r._1())._1$mcC$sp() != ((Tuple2)r._1())._2$mcC$sp();
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Tuple2<Object, Object>, Object> x$18) {
                return x$18._2$mcI$sp();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return mismatchQualities.length() > 0 ? BoxesRunTime.unboxToInt((Object)mismatchQualities.reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int x$19, int x$20) {
                return this.apply$mcIII$sp(x$19, x$20);
            }

            public int apply$mcIII$sp(int x$19, int x$20) {
                return x$19 + x$20;
            }
        })) : 0;
    }

    public int sumMismatchQuality(AlignmentRecord read) {
        return this.sumMismatchQualityIgnoreCigar(read.getSequence(), ((MdTag)RichAlignmentRecord$.MODULE$.recordToRichRecord(read).mdTag().get()).getReference(RichAlignmentRecord$.MODULE$.recordToRichRecord(read)), (Seq<Object>)Predef$.MODULE$.wrapIntArray(RichAlignmentRecord$.MODULE$.recordToRichRecord(read).qualityScores()));
    }

    public RDD<AlignmentRecord> realignIndels(RDD<AlignmentRecord> rdd) {
        RDD rDD;
        RDD rDD2;
        if (this.dataIsSorted()) {
            rDD2 = rdd.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(AlignmentRecord r) {
                    return Predef$.MODULE$.Boolean2boolean(r.getReadMapped());
                }
            });
        } else {
            OrderedRDDFunctions qual$1 = SparkContext$.MODULE$.rddToOrderedRDDFunctions(rdd.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(AlignmentRecord r) {
                    return Predef$.MODULE$.Boolean2boolean(r.getReadMapped());
                }
            }).keyBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ReferencePosition apply(AlignmentRecord r) {
                    return (ReferencePosition)ReferencePosition$.MODULE$.apply(r).get();
                }
            }), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()), ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(AlignmentRecord.class));
            boolean x$22 = qual$1.sortByKey$default$1();
            int x$23 = qual$1.sortByKey$default$2();
            RDD sr = qual$1.sortByKey(x$22, x$23);
            rDD2 = sr.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final AlignmentRecord apply(Tuple2<ReferencePosition, AlignmentRecord> kv) {
                    return (AlignmentRecord)kv._2();
                }
            }, ClassTag$.MODULE$.apply(AlignmentRecord.class));
        }
        RDD sortedRdd = rDD2;
        RDD richRdd = sortedRdd.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final RichAlignmentRecord apply(AlignmentRecord x$21) {
                return new RichAlignmentRecord(x$21);
            }
        }, ClassTag$.MODULE$.apply(RichAlignmentRecord.class));
        richRdd.cache();
        this.log().info("Generating realignment targets...");
        TreeSet<IndelRealignmentTarget> targets = RealignmentTargetFinder$.MODULE$.apply((RDD<RichAlignmentRecord>)richRdd, this.maxIndelSize(), this.maxTargetSize());
        if (targets.isEmpty()) {
            RDD readRdd = richRdd.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final AlignmentRecord apply(RichAlignmentRecord r) {
                    return r.record();
                }
            }, ClassTag$.MODULE$.apply(AlignmentRecord.class));
            richRdd.unpersist(richRdd.unpersist$default$1());
            rDD = readRdd;
        } else {
            this.log().info("Grouping reads by target...");
            RDD<Tuple2<Option<IndelRealignmentTarget>, Iterable<RichAlignmentRecord>>> readsMappedToTarget = RealignIndels$.MODULE$.mapTargets((RDD<RichAlignmentRecord>)richRdd, targets);
            richRdd.unpersist(richRdd.unpersist$default$1());
            this.log().info("Sorting reads by reference in ADAM RDD");
            rDD = readsMappedToTarget.flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RealignIndels $outer;

                public final Iterable<RichAlignmentRecord> apply(Tuple2<Option<IndelRealignmentTarget>, Iterable<RichAlignmentRecord>> targetGroup) {
                    return this.$outer.realignTargetGroup(targetGroup);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, ClassTag$.MODULE$.apply(RichAlignmentRecord.class)).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final AlignmentRecord apply(RichAlignmentRecord r) {
                    return r.record();
                }
            }, ClassTag$.MODULE$.apply(AlignmentRecord.class));
        }
        return rDD;
    }

    public RealignIndels(ConsensusGenerator consensusModel, boolean dataIsSorted, int maxIndelSize, int maxConsensusNumber, double lodThreshold, int maxTargetSize) {
        this.consensusModel = consensusModel;
        this.dataIsSorted = dataIsSorted;
        this.maxIndelSize = maxIndelSize;
        this.maxConsensusNumber = maxConsensusNumber;
        this.lodThreshold = lodThreshold;
        this.maxTargetSize = maxTargetSize;
        Logging.class.$init$((Logging)this);
    }
}

