/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.read.recalibration;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.models.SnpTable;
import org.bdgenomics.adam.rdd.read.recalibration.BaseQualityRecalibration$;
import org.bdgenomics.adam.rdd.read.recalibration.Covariate;
import org.bdgenomics.adam.rdd.read.recalibration.CovariateKey;
import org.bdgenomics.adam.rdd.read.recalibration.CovariateSpace;
import org.bdgenomics.adam.rdd.read.recalibration.CovariateSpace$;
import org.bdgenomics.adam.rdd.read.recalibration.CycleCovariate;
import org.bdgenomics.adam.rdd.read.recalibration.DinucCovariate;
import org.bdgenomics.adam.rdd.read.recalibration.ObservationAccumulator;
import org.bdgenomics.adam.rdd.read.recalibration.ObservationAccumulator$;
import org.bdgenomics.adam.rdd.read.recalibration.ObservationTable;
import org.bdgenomics.adam.rdd.read.recalibration.Recalibrator;
import org.bdgenomics.adam.rdd.read.recalibration.Recalibrator$;
import org.bdgenomics.adam.rich.DecadentRead;
import org.bdgenomics.adam.rich.RichAlignmentRecord$;
import org.bdgenomics.adam.util.QualityScore;
import org.bdgenomics.adam.util.QualityScore$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001B\u0001\u0003\u0001=\u0011\u0001DQ1tKF+\u0018\r\\5usJ+7-\u00197jEJ\fG/[8o\u0015\t\u0019A!A\u0007sK\u000e\fG.\u001b2sCRLwN\u001c\u0006\u0003\u000b\u0019\tAA]3bI*\u0011q\u0001C\u0001\u0004e\u0012$'BA\u0005\u000b\u0003\u0011\tG-Y7\u000b\u0005-a\u0011A\u00032eO\u0016tw.\\5dg*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001!Yq\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\r\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005\u0011\u0011n\u001c\u0006\u00027\u0005!!.\u0019<b\u0013\ti\u0002D\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0005\u0002 I5\t\u0001E\u0003\u0002\"E\u0005)1\u000f]1sW*\u00111\u0005D\u0001\u0007CB\f7\r[3\n\u0005\u0015\u0002#a\u0002'pO\u001eLgn\u001a\u0005\tO\u0001\u0011)\u0019!C\u0001Q\u0005)\u0011N\u001c9viV\t\u0011\u0006E\u0002+Y9j\u0011a\u000b\u0006\u0003\u000f\u0001J!!L\u0016\u0003\u0007I#E\t\u0005\u00020e5\t\u0001G\u0003\u00022\u0011\u0005!!/[2i\u0013\t\u0019\u0004G\u0001\u0007EK\u000e\fG-\u001a8u%\u0016\fG\r\u0003\u00056\u0001\t\u0005\t\u0015!\u0003*\u0003\u0019Ig\u000e];uA!Aq\u0007\u0001BC\u0002\u0013\u0005\u0001(A\u0005l]><hn\u00158qgV\t\u0011\bE\u0002;{}j\u0011a\u000f\u0006\u0003y\u0001\n\u0011B\u0019:pC\u0012\u001c\u0017m\u001d;\n\u0005yZ$!\u0003\"s_\u0006$7-Y:u!\t\u00015)D\u0001B\u0015\t\u0011\u0005\"\u0001\u0004n_\u0012,Gn]\u0005\u0003\t\u0006\u0013\u0001b\u00158q)\u0006\u0014G.\u001a\u0005\t\r\u0002\u0011\t\u0011)A\u0005s\u0005Q1N\\8x]Ns\u0007o\u001d\u0011\t\u0011!\u0003!Q1A\u0005\u0002%\u000b\u0001\u0004Z;na>\u00137/\u001a:wCRLwN\u001c+bE2,g)\u001b7f+\u0005Q\u0005cA\tL\u001b&\u0011AJ\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00059\u000bfBA\tP\u0013\t\u0001&#\u0001\u0004Qe\u0016$WMZ\u0005\u0003%N\u0013aa\u0015;sS:<'B\u0001)\u0013\u0011!)\u0006A!A!\u0002\u0013Q\u0015!\u00073v[B|%m]3sm\u0006$\u0018n\u001c8UC\ndWMR5mK\u0002BQa\u0016\u0001\u0005\u0002a\u000ba\u0001P5oSRtD\u0003B-\\9v\u0003\"A\u0017\u0001\u000e\u0003\tAQa\n,A\u0002%BQa\u000e,A\u0002eBq\u0001\u0013,\u0011\u0002\u0003\u0007!\nC\u0004`\u0001\t\u0007I\u0011\u00011\u0002\u0015\r|g/\u0019:jCR,7/F\u0001b!\tQ&-\u0003\u0002d\u0005\tq1i\u001c<be&\fG/Z*qC\u000e,\u0007BB3\u0001A\u0003%\u0011-A\u0006d_Z\f'/[1uKN\u0004\u0003bB4\u0001\u0005\u0004%\t\u0001[\u0001\u0015[&t\u0017iY2faR\f'\r\\3Rk\u0006d\u0017\u000e^=\u0016\u0003%\u0004\"A[7\u000e\u0003-T!\u0001\u001c\u0005\u0002\tU$\u0018\u000e\\\u0005\u0003].\u0014A\"U;bY&$\u0018pU2pe\u0016Da\u0001\u001d\u0001!\u0002\u0013I\u0017!F7j]\u0006\u001b7-\u001a9uC\ndW-U;bY&$\u0018\u0010\t\u0005\be\u0002\u0011\r\u0011\"\u0001t\u0003I)g.\u00192mKZK7/\u001b;M_\u001e<\u0017N\\4\u0016\u0003Q\u0004\"!E;\n\u0005Y\u0014\"a\u0002\"p_2,\u0017M\u001c\u0005\u0007q\u0002\u0001\u000b\u0011\u0002;\u0002'\u0015t\u0017M\u00197f-&\u001c\u0018\u000e\u001e'pO\u001eLgn\u001a\u0011\t\u000fi\u0004!\u0019!C\u0001w\u00069A-\u0019;bg\u0016$X#\u0001?\u0011\u0007)bS\u0010\u0005\u0004\u0012}\u0006\u0005\u0011qA\u0005\u0003\u007fJ\u0011a\u0001V;qY\u0016\u0014\u0004c\u0001.\u0002\u0004%\u0019\u0011Q\u0001\u0002\u0003\u0019\r{g/\u0019:jCR,7*Z=\u0011\t\u0005%\u0011Q\u0005\b\u0005\u0003\u0017\t\tC\u0004\u0003\u0002\u000e\u0005}a\u0002BA\b\u0003;qA!!\u0005\u0002\u001c9!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u00189\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005-a\u0011BA\u0005\u000b\u0013\t\t\u0004\"C\u0002\u0002$A\nA\u0002R3dC\u0012,g\u000e\u001e*fC\u0012LA!a\n\u0002*\t9!+Z:jIV,'bAA\u0012a!9\u0011Q\u0006\u0001!\u0002\u0013a\u0018\u0001\u00033bi\u0006\u001cX\r\u001e\u0011\t\u0013\u0005E\u0002A1A\u0005\u0002\u0005M\u0012\u0001C8cg\u0016\u0014h/\u001a3\u0016\u0005\u0005U\u0002c\u0001.\u00028%\u0019\u0011\u0011\b\u0002\u0003!=\u00137/\u001a:wCRLwN\u001c+bE2,\u0007\u0002CA\u001f\u0001\u0001\u0006I!!\u000e\u0002\u0013=\u00147/\u001a:wK\u0012\u0004\u0003\"CA!\u0001\t\u0007I\u0011AA\"\u0003\u0019\u0011Xm];miV\u0011\u0011Q\t\t\u0005U1\n9\u0005\u0005\u0003\u0002J\u0005MSBAA&\u0015\u0011\ti%a\u0014\u0002\t\u00054(o\u001c\u0006\u0004\u0003#R\u0011a\u00024pe6\fGo]\u0005\u0005\u0003+\nYEA\bBY&<g.\\3oiJ+7m\u001c:e\u0011!\tI\u0006\u0001Q\u0001\n\u0005\u0015\u0013a\u0002:fgVdG\u000f\t\u0005\b\u0003;\u0002A\u0011BA0\u0003)!W/\u001c9WSNLGo\u001d\u000b\u0005\u0003C\n9\u0007E\u0002\u0012\u0003GJ1!!\u001a\u0013\u0005\u0011)f.\u001b;\t\u000f\u0005%\u00141\fa\u0001\u001b\u0006Aa-\u001b7f]\u0006lWmB\u0004\u0002n\tA\t!a\u001c\u00021\t\u000b7/Z)vC2LG/\u001f*fG\u0006d\u0017N\u0019:bi&|g\u000eE\u0002[\u0003c2a!\u0001\u0002\t\u0002\u0005M4#BA9!\u0005U\u0004cA\t\u0002x%\u0011QD\u0005\u0005\b/\u0006ED\u0011AA>)\t\ty\u0007\u0003\u0005\u0002\u0000\u0005ED\u0011AAA\u0003\u0015\t\u0007\u000f\u001d7z)!\t)%a!\u0002\u0006\u0006\u001d\u0005bB\u0004\u0002~\u0001\u0007\u0011Q\t\u0005\u0007o\u0005u\u0004\u0019A\u001d\t\u0013\u0005%\u0015Q\u0010I\u0001\u0002\u0004Q\u0015aE8cg\u0016\u0014h/\u0019;j_:$U/\u001c9GS2,\u0007BCAG\u0003c\n\n\u0011\"\u0001\u0002\u0010\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0012*\u001a!*a%,\u0005\u0005U\u0005\u0003BAL\u0003Ck!!!'\u000b\t\u0005m\u0015QT\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a(\u0013\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003G\u000bIJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D!\"a*\u0002rE\u0005I\u0011AAH\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g!Q\u00111VA9\u0003\u0003%I!!,\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003_\u0003B!!-\u000286\u0011\u00111\u0017\u0006\u0004\u0003kS\u0012\u0001\u00027b]\u001eLA!!/\u00024\n1qJ\u00196fGR\u0004")
public class BaseQualityRecalibration
implements Serializable,
Logging {
    private final RDD<DecadentRead> input;
    private final Broadcast<SnpTable> knownSnps;
    private final Option<String> dumpObservationTableFile;
    private final CovariateSpace covariates;
    private final QualityScore minAcceptableQuality;
    private final boolean enableVisitLogging;
    private final RDD<Tuple2<CovariateKey, DecadentRead.Residue>> dataset;
    private final ObservationTable observed;
    private final RDD<AlignmentRecord> result;
    private transient Logger org$apache$spark$Logging$$log_;

    public static Option<String> $lessinit$greater$default$3() {
        return BaseQualityRecalibration$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<String> apply$default$3() {
        return BaseQualityRecalibration$.MODULE$.apply$default$3();
    }

    public static RDD<AlignmentRecord> apply(RDD<AlignmentRecord> rDD, Broadcast<SnpTable> broadcast, Option<String> option) {
        return BaseQualityRecalibration$.MODULE$.apply(rDD, broadcast, option);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public RDD<DecadentRead> input() {
        return this.input;
    }

    public Broadcast<SnpTable> knownSnps() {
        return this.knownSnps;
    }

    public Option<String> dumpObservationTableFile() {
        return this.dumpObservationTableFile;
    }

    public CovariateSpace covariates() {
        return this.covariates;
    }

    public QualityScore minAcceptableQuality() {
        return this.minAcceptableQuality;
    }

    public boolean enableVisitLogging() {
        return this.enableVisitLogging;
    }

    public RDD<Tuple2<CovariateKey, DecadentRead.Residue>> dataset() {
        return this.dataset;
    }

    public ObservationTable observed() {
        return this.observed;
    }

    public RDD<AlignmentRecord> result() {
        return this.result;
    }

    private void dumpVisits(String filename) {
        Map readLengths = SparkContext$.MODULE$.rddToPairRDDFunctions(this.input().map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseQualityRecalibration $outer;

            public final Tuple2<String, Object> apply(DecadentRead read) {
                return new Tuple2((Object)this.$outer.org$bdgenomics$adam$rdd$read$recalibration$BaseQualityRecalibration$$readId$1(read), (Object)BoxesRunTime.boxToInteger((int)read.residues().length()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).collectAsMap();
        Map visited = SparkContext$.MODULE$.rddToPairRDDFunctions(this.dataset().map((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseQualityRecalibration $outer;

            public final Tuple2<String, Seq<Object>> apply(Tuple2<CovariateKey, DecadentRead.Residue> x0$2) {
                Tuple2<CovariateKey, DecadentRead.Residue> tuple2 = x0$2;
                if (tuple2 != null) {
                    DecadentRead.Residue residue = (DecadentRead.Residue)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)this.$outer.org$bdgenomics$adam$rdd$read$recalibration$BaseQualityRecalibration$$readId$1(residue.read()), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{residue.offset()})));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Seq.class), (Ordering)Ordering.String$.MODULE$).reduceByKeyLocally((Function2)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Seq<Object> left, Seq<Object> right) {
                return (Seq)left.$plus$plus(right, Seq$.MODULE$.canBuildFrom());
            }
        });
        File outf = new File(filename);
        PrintWriter writer = new PrintWriter(outf);
        visited.foreach((Function1)new scala.Serializable(this, readLengths, writer){
            public static final long serialVersionUID = 0L;
            private final Map readLengths$1;
            private final PrintWriter writer$1;

            public final void apply(Tuple2<String, Seq<Object>> x0$3) {
                Tuple2<String, Seq<Object>> tuple2 = x0$3;
                if (tuple2 != null) {
                    String readName = (String)tuple2._1();
                    Seq visited = (Seq)tuple2._2();
                    int length2 = BoxesRunTime.unboxToInt((Object)this.readLengths$1.apply((Object)readName));
                    char[] buf = (char[])Array$.MODULE$.fill(length2, (Function0)new scala.Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final char apply() {
                            return this.apply$mcC$sp();
                        }

                        public char apply$mcC$sp() {
                            return 'O';
                        }
                    }, ClassTag$.MODULE$.Char());
                    visited.foreach((Function1)new scala.Serializable(this, buf){
                        public static final long serialVersionUID = 0L;
                        private final char[] buf$1;

                        public final void apply(int idx) {
                            this.apply$mcVI$sp(idx);
                        }

                        public void apply$mcVI$sp(int idx) {
                            this.buf$1[idx] = 88;
                        }
                        {
                            this.buf$1 = buf$1;
                        }
                    });
                    this.writer$1.println(new StringBuilder().append((Object)readName).append((Object)"\t").append((Object)String.valueOf(buf)).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.readLengths$1 = readLengths$1;
                this.writer$1 = writer$1;
            }
        });
        writer.close();
    }

    public final boolean org$bdgenomics$adam$rdd$read$recalibration$BaseQualityRecalibration$$shouldIncludeRead$1(DecadentRead read) {
        return read.isCanonicalRecord() && read.alignmentQuality().exists((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(QualityScore x$1) {
                return x$1.$greater(QualityScore$.MODULE$.zero());
            }
        }) && read.passedQualityChecks();
    }

    public final boolean org$bdgenomics$adam$rdd$read$recalibration$BaseQualityRecalibration$$shouldIncludeResidue$1(DecadentRead.Residue residue) {
        return residue.quality().$greater(QualityScore$.MODULE$.zero()) && residue.isRegularBase() && !residue.isInsertion() && !((SnpTable)this.knownSnps().value()).isMasked(residue);
    }

    public final Seq org$bdgenomics$adam$rdd$read$recalibration$BaseQualityRecalibration$$observe$1(DecadentRead read) {
        return (Seq)((TraversableLike)this.covariates().apply(read).zip(read.residues(), Seq$.MODULE$.canBuildFrom())).filter((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseQualityRecalibration $outer;

            public final boolean apply(Tuple2<CovariateKey, DecadentRead.Residue> x0$1) {
                Tuple2<CovariateKey, DecadentRead.Residue> tuple2 = x0$1;
                if (tuple2 != null) {
                    DecadentRead.Residue residue = (DecadentRead.Residue)tuple2._2();
                    boolean bl = this.$outer.org$bdgenomics$adam$rdd$read$recalibration$BaseQualityRecalibration$$shouldIncludeResidue$1(residue);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public final String org$bdgenomics$adam$rdd$read$recalibration$BaseQualityRecalibration$$readId$1(DecadentRead read) {
        return new StringBuilder().append((Object)read.name()).append((Object)(read.isNegativeRead() ? "-" : "+")).append((Object)(Predef$.MODULE$.Boolean2boolean(RichAlignmentRecord$.MODULE$.richRecordToRecord(read.record()).getFirstOfPair()) ? "1" : "")).append((Object)(Predef$.MODULE$.Boolean2boolean(RichAlignmentRecord$.MODULE$.richRecordToRecord(read.record()).getSecondOfPair()) ? "2" : "")).toString();
    }

    public BaseQualityRecalibration(RDD<DecadentRead> input, Broadcast<SnpTable> knownSnps, Option<String> dumpObservationTableFile) {
        this.input = input;
        this.knownSnps = knownSnps;
        this.dumpObservationTableFile = dumpObservationTableFile;
        Logging.class.$init$((Logging)this);
        this.covariates = CovariateSpace$.MODULE$.apply((Seq<Covariate>)Predef$.MODULE$.wrapRefArray((Object[])new Covariate[]{new CycleCovariate(), new DinucCovariate()}));
        this.minAcceptableQuality = QualityScore$.MODULE$.apply(5);
        this.enableVisitLogging = false;
        this.dataset = input.filter((Function1)new $anonfun$2(this)).flatMap((Function1)new $anonfun$3(this), ClassTag$.MODULE$.apply(Tuple2.class));
        if (this.enableVisitLogging()) {
            input.cache();
            this.dataset().cache();
            this.dumpVisits("bqsr-visits.dump");
        }
        this.observed = ((ObservationAccumulator)this.dataset().map((Function1)new $anonfun$4(this), ClassTag$.MODULE$.apply(Tuple2.class)).aggregate((Object)ObservationAccumulator$.MODULE$.apply(this.covariates()), (Function2)new $anonfun$5(this), (Function2)new $anonfun$6(this), ClassTag$.MODULE$.apply(ObservationAccumulator.class))).result();
        dumpObservationTableFile.foreach((Function1)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseQualityRecalibration $outer;

            public final void apply(String p) {
                PrintWriter writer = new PrintWriter(new File(p));
                writer.write(this.$outer.observed().toCSV());
                writer.close();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Recalibrator recalibrator = Recalibrator$.MODULE$.apply(this.observed(), this.minAcceptableQuality());
        this.result = input.map((Function1)recalibrator, ClassTag$.MODULE$.apply(AlignmentRecord.class));
    }
}

