/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.models;

import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceDictionary$;
import org.bdgenomics.adam.models.SequenceDictionarySuite$;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r3A!\u0001\u0002\u0001\u0017\t92+Z9vK:\u001cW\rR5di&|g.\u0019:z'VLG/\u001a\u0006\u0003\u0007\u0011\ta!\\8eK2\u001c(BA\u0003\u0007\u0003\u0011\tG-Y7\u000b\u0005\u001dA\u0011A\u00032eO\u0016tw.\\5dg*\t\u0011\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\u0011q\u0002C\u0001\ng\u000e\fG.\u0019;fgRL!!\u0005\b\u0003\u0011\u0019+hnU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000ba\u0001A\u0011A\r\u0002\rI,7m\u001c:e)\u0015QR$\n\u00181!\t12$\u0003\u0002\u001d\u0005\tq1+Z9vK:\u001cWMU3d_J$\u0007\"\u0002\u0010\u0018\u0001\u0004y\u0012AA5e!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\rIe\u000e\u001e\u0005\u0006M]\u0001\raJ\u0001\u0005]\u0006lW\r\u0005\u0002)W9\u0011\u0001%K\u0005\u0003U\u0005\na\u0001\u0015:fI\u00164\u0017B\u0001\u0017.\u0005\u0019\u0019FO]5oO*\u0011!&\t\u0005\b_]\u0001\n\u00111\u0001 \u0003\u0019aWM\\4uQ\"9\u0011g\u0006I\u0001\u0002\u00049\u0013aA;sY\"91\u0007AI\u0001\n\u0003!\u0014\u0001\u0005:fG>\u0014H\r\n3fM\u0006,H\u000e\u001e\u00134+\u0005)$FA\u00107W\u00059\u0004C\u0001\u001d>\u001b\u0005I$B\u0001\u001e<\u0003%)hn\u00195fG.,GM\u0003\u0002=C\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005yJ$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"9\u0001\tAI\u0001\n\u0003\t\u0015\u0001\u0005:fG>\u0014H\r\n3fM\u0006,H\u000e\u001e\u00135+\u0005\u0011%FA\u00147\u0001")
public class SequenceDictionarySuite
extends FunSuite {
    public SequenceRecord record(int id, String name, int length, String url) {
        return SequenceRecord$.MODULE$.apply(id, (CharSequence)name, (long)length, (CharSequence)url, SequenceRecord$.MODULE$.apply$default$5());
    }

    public int record$default$3() {
        return 1000;
    }

    public String record$default$4() {
        return null;
    }

    public SequenceDictionarySuite() {
        this.test("Can retrieve sequence by ID", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceRecord rec1 = this.$outer.record(0, "foo", this.$outer.record$default$3(), this.$outer.record$default$4());
                SequenceRecord rec2 = this.$outer.record(1, "bar", this.$outer.record$default$3(), this.$outer.record$default$4());
                this.$outer.assert(this.$outer.convertToEqualizer(SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{rec1, rec2})).apply(rec1.id())).$eq$eq$eq((Object)rec1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("containsRefName works as expected 1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceRecord rec1 = this.$outer.record(0, "foo", this.$outer.record$default$3(), this.$outer.record$default$4());
                SequenceRecord rec2 = this.$outer.record(1, "bar", this.$outer.record$default$3(), this.$outer.record$default$4());
                this.$outer.assert(SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{rec1, rec2})).containsRefName((CharSequence)"foo"));
                this.$outer.assert(SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{rec1, rec2})).containsRefName((CharSequence)"bar"));
                this.$outer.assert(!SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{rec1, rec2})).containsRefName((CharSequence)"foo "));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("containsRefName works as expected 2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceRecord rec1 = this.$outer.record(0, "foo", this.$outer.record$default$3(), this.$outer.record$default$4());
                SequenceRecord rec2 = this.$outer.record(1, "bar", this.$outer.record$default$3(), this.$outer.record$default$4());
                SequenceDictionary sd = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{rec1, rec2}));
                Iterable names = sd.getReferenceNames();
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((LinearSeqOptimized)names.toList().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$1) {
                        String string = x$1;
                        return !(string != null ? !string.equals("foo") : "foo" != null);
                    }
                })).length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)((LinearSeqOptimized)names.toList().filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String x$2) {
                        String string = x$2;
                        return !(string != null ? !string.equals("bar") : "bar" != null);
                    }
                })).length())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("containsRefId works as expected", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceRecord rec1 = this.$outer.record(0, "foo", this.$outer.record$default$3(), this.$outer.record$default$4());
                SequenceRecord rec2 = this.$outer.record(1, "bar", this.$outer.record$default$3(), this.$outer.record$default$4());
                this.$outer.assert(SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{rec1, rec2})).containsRefId(0));
                this.$outer.assert(SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{rec1, rec2})).containsRefId(1));
                this.$outer.assert(!SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{rec1, rec2})).containsRefId(2));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Can retrieve sequence by Name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceRecord rec1 = this.$outer.record(0, "foo", this.$outer.record$default$3(), this.$outer.record$default$4());
                SequenceRecord rec2 = this.$outer.record(1, "bar", this.$outer.record$default$3(), this.$outer.record$default$4());
                this.$outer.assert(this.$outer.convertToEqualizer(SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{rec1, rec2})).apply(rec1.name())).$eq$eq$eq((Object)rec1));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SequenceDictionaries with same single element are equal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(0, "foo", this.$outer.record$default$3(), this.$outer.record$default$4())}))).$eq$eq$eq((Object)SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(0, "foo", this.$outer.record$default$3(), this.$outer.record$default$4())}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SequenceDictionaries with same two elements are equals", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(0, "foo", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(1, "bar", this.$outer.record$default$3(), this.$outer.record$default$4())}))).$eq$eq$eq((Object)SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(0, "foo", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(1, "bar", this.$outer.record$default$3(), this.$outer.record$default$4())}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SequenceDictionaries with different elements are unequal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary sequenceDictionary = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(0, "foo", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(1, "bar", this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary sequenceDictionary2 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(0, "foo", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(1, "quux", this.$outer.record$default$3(), this.$outer.record$default$4())}));
                this.$outer.assert(sequenceDictionary != null ? !sequenceDictionary.equals(sequenceDictionary2) : sequenceDictionary2 != null);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("SequenceDictionaries with same elements in different order are equal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(0, "foo", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(1, "bar", this.$outer.record$default$3(), this.$outer.record$default$4())}))).$eq$eq$eq((Object)SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(1, "bar", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(0, "foo", this.$outer.record$default$3(), this.$outer.record$default$4())}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("double referenceIds throws an exception", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;

                    public final SequenceDictionary apply() {
                        return SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.$outer.record(0, "foo", this.$outer.$outer.record$default$3(), this.$outer.$outer.record$default$4()), this.$outer.org$bdgenomics$adam$models$SequenceDictionarySuite$$anonfun$$$outer().record(0, "bar", this.$outer.org$bdgenomics$adam$models$SequenceDictionarySuite$$anonfun$$$outer().record$default$3(), this.$outer.org$bdgenomics$adam$models$SequenceDictionarySuite$$anonfun$$$outer().record$default$4())}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(AssertionError.class));
            }

            public /* synthetic */ SequenceDictionarySuite org$bdgenomics$adam$models$SequenceDictionarySuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("double referenceNames throws an exception", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$11 $outer;

                    public final SequenceDictionary apply() {
                        return SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.$outer.record(0, "foo", this.$outer.$outer.record$default$3(), this.$outer.$outer.record$default$4()), this.$outer.org$bdgenomics$adam$models$SequenceDictionarySuite$$anonfun$$$outer().record(1, "foo", this.$outer.org$bdgenomics$adam$models$SequenceDictionarySuite$$anonfun$$$outer().record$default$3(), this.$outer.org$bdgenomics$adam$models$SequenceDictionarySuite$$anonfun$$$outer().record$default$4())}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(AssertionError.class));
            }

            public /* synthetic */ SequenceDictionarySuite org$bdgenomics$adam$models$SequenceDictionarySuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("mapTo generates correct identifier mappings", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary fromDict = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(0, "foo", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(1, "bar", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(2, "quux", this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary toDict = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(10, "bar", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(20, "quux", this.$outer.record$default$3(), this.$outer.record$default$4())}));
                Tuple2[] tuple2Array = new Tuple2[3];
                Integer n = BoxesRunTime.boxToInteger((int)0);
                Predef$ predef$ = Predef$.MODULE$;
                Integer n2 = BoxesRunTime.boxToInteger((int)0);
                Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                tuple2Array[0] = new Tuple2((Object)n, (Object)n2);
                Integer n3 = BoxesRunTime.boxToInteger((int)1);
                Predef$ predef$2 = Predef$.MODULE$;
                Integer n4 = BoxesRunTime.boxToInteger((int)10);
                Predef.ArrowAssoc$ arrowAssoc$2 = Predef.ArrowAssoc$.MODULE$;
                tuple2Array[1] = new Tuple2((Object)n3, (Object)n4);
                Integer n5 = BoxesRunTime.boxToInteger((int)2);
                Predef$ predef$3 = Predef$.MODULE$;
                Integer n6 = BoxesRunTime.boxToInteger((int)20);
                Predef.ArrowAssoc$ arrowAssoc$3 = Predef.ArrowAssoc$.MODULE$;
                tuple2Array[2] = new Tuple2((Object)n5, (Object)n6);
                this.$outer.assert(this.$outer.convertToEqualizer(fromDict.mapTo(toDict)).$eq$eq$eq((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("isCompatible tests equality on overlap", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary s1 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(0, "foo", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(1, "bar", this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary s2 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(1, "bar", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(2, "quux", this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary s3 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(0, "foo", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(2, "bar", this.$outer.record$default$3(), this.$outer.record$default$4())}));
                this.$outer.assert(s1.isCompatibleWith(s2));
                this.$outer.assert(!s1.isCompatibleWith(s3));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("remap and mapTo generate equality for dictionaries with the same names", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary s1 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(1, "foo", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(2, "bar", this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary s2 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(20, "bar", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(10, "foo", this.$outer.record$default$3(), this.$outer.record$default$4())}));
                Tuple2[] tuple2Array = new Tuple2[2];
                Integer n = BoxesRunTime.boxToInteger((int)1);
                Predef$ predef$ = Predef$.MODULE$;
                Integer n2 = BoxesRunTime.boxToInteger((int)10);
                Predef.ArrowAssoc$ arrowAssoc$ = Predef.ArrowAssoc$.MODULE$;
                tuple2Array[0] = new Tuple2((Object)n, (Object)n2);
                Integer n3 = BoxesRunTime.boxToInteger((int)2);
                Predef$ predef$2 = Predef$.MODULE$;
                Integer n4 = BoxesRunTime.boxToInteger((int)20);
                Predef.ArrowAssoc$ arrowAssoc$2 = Predef.ArrowAssoc$.MODULE$;
                tuple2Array[1] = new Tuple2((Object)n3, (Object)n4);
                this.$outer.assert(this.$outer.convertToEqualizer(s1.mapTo(s2)).$eq$eq$eq((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))));
                this.$outer.assert(this.$outer.convertToEqualizer(s1.remap(s1.mapTo(s2))).$eq$eq$eq((Object)s2));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("all five cases for toMap", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary s1 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(1, "s1", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(3, "s2", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(4, "s4", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(6, "s6", this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary s2 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(1, "s1", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(2, "s2", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(4, "s3", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(5, "s5", this.$outer.record$default$3(), this.$outer.record$default$4())}));
                Map map = s1.mapTo(s2);
                this.$outer.assert(this.$outer.convertToEqualizer(map.apply((Object)BoxesRunTime.boxToInteger((int)1))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(!map.contains((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(map.apply((Object)BoxesRunTime.boxToInteger((int)3))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(map.apply((Object)BoxesRunTime.boxToInteger((int)4))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)s2.nonoverlappingHash((CharSequence)"s4"))));
                this.$outer.assert(!map.contains((Object)BoxesRunTime.boxToInteger((int)5)));
                this.$outer.assert(this.$outer.convertToEqualizer(map.apply((Object)BoxesRunTime.boxToInteger((int)6))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)6)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("mapTo and remap produce a compatible dictionary", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary s1 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(1, "s1", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(3, "s2", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(2, "s3", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(5, "s4", this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary s2 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(1, "s1", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(2, "s2", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(3, "s3", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(5, "s5", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record("s4".hashCode(), "s6", this.$outer.record$default$3(), this.$outer.record$default$4())}));
                Map map = s1.mapTo(s2);
                this.$outer.assert(this.$outer.convertToEqualizer(map.apply((Object)BoxesRunTime.boxToInteger((int)5))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)("s4".hashCode() + 1))));
                this.$outer.assert(s1.remap(map).isCompatibleWith(s2));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("toMap handles permutations correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary s1 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(1, "s2", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(2, "s3", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(3, "s1", this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary s2 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(1, "s1", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(2, "s2", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(3, "s3", this.$outer.record$default$3(), this.$outer.record$default$4())}));
                Map map = s1.mapTo(s2);
                this.$outer.assert(this.$outer.convertToEqualizer(map.apply((Object)BoxesRunTime.boxToInteger((int)1))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(map.apply((Object)BoxesRunTime.boxToInteger((int)2))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3)));
                this.$outer.assert(this.$outer.convertToEqualizer(map.apply((Object)BoxesRunTime.boxToInteger((int)3))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("the addition + works correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary s1 = SequenceDictionary$.MODULE$.apply((Seq)Nil$.MODULE$);
                SequenceDictionary s2 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(1, "foo", this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary s3 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(1, "foo", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(2, "bar", this.$outer.record$default$3(), this.$outer.record$default$4())}));
                this.$outer.assert(this.$outer.convertToEqualizer(s1.$plus(this.$outer.record(1, "foo", this.$outer.record$default$3(), this.$outer.record$default$4()))).$eq$eq$eq((Object)s2));
                this.$outer.assert(this.$outer.convertToEqualizer(s2.$plus(this.$outer.record(1, "foo", this.$outer.record$default$3(), this.$outer.record$default$4()))).$eq$eq$eq((Object)s2));
                this.$outer.assert(this.$outer.convertToEqualizer(s2.$plus(this.$outer.record(2, "bar", this.$outer.record$default$3(), this.$outer.record$default$4()))).$eq$eq$eq((Object)s3));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("the append operation ++ works correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary s1 = SequenceDictionary$.MODULE$.apply((Seq)Nil$.MODULE$);
                SequenceDictionary s2a = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(1, "foo", this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary s2b = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(2, "bar", this.$outer.record$default$3(), this.$outer.record$default$4())}));
                SequenceDictionary s3 = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(1, "foo", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(2, "bar", this.$outer.record$default$3(), this.$outer.record$default$4())}));
                this.$outer.assert(this.$outer.convertToEqualizer(s1.$plus$plus(s1)).$eq$eq$eq((Object)s1));
                this.$outer.assert(this.$outer.convertToEqualizer(s1.$plus$plus(s2a)).$eq$eq$eq((Object)s2a));
                this.$outer.assert(this.$outer.convertToEqualizer(s1.$plus$plus(s2b)).$eq$eq$eq((Object)s2b));
                this.$outer.assert(this.$outer.convertToEqualizer(s2a.$plus$plus(s2b)).$eq$eq$eq((Object)s3));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("containsRefName works correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary dict = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(0, "chr0", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(1, "chr1", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(2, "chr2", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(3, "chr3", this.$outer.record$default$3(), this.$outer.record$default$4())}));
                this.$outer.assert(dict.containsRefName((CharSequence)"chr0"));
                this.$outer.assert(dict.containsRefName((CharSequence)"chr1"));
                this.$outer.assert(dict.containsRefName((CharSequence)"chr2"));
                this.$outer.assert(dict.containsRefName((CharSequence)"chr3"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("apply on name works correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SequenceDictionary dict = SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(0, "chr0", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(1, "chr1", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(2, "chr2", this.$outer.record$default$3(), this.$outer.record$default$4()), this.$outer.record(3, "chr3", this.$outer.record$default$3(), this.$outer.record$default$4())}));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)dict.apply((CharSequence)"chr0").id())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)dict.apply((CharSequence)"chr1").id())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)dict.apply((CharSequence)"chr2").id())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)dict.apply((CharSequence)"chr3").id())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)3)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("convert from sam sequence record and back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SAMSequenceRecord sr = new SAMSequenceRecord("chr0", 1000);
                sr.setAssembly("http://bigdatagenomics.github.io/chr0");
                SequenceRecord conv = SequenceRecord$.MODULE$.fromSamSequenceRecord(sr);
                this.$outer.assert(this.$outer.convertToEqualizer(conv.name()).$eq$eq$eq((Object)"chr0"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)conv.length())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)1000L)));
                this.$outer.assert(this.$outer.convertToEqualizer(conv.url()).$eq$eq$eq((Object)"http://bigdatagenomics.github.io/chr0"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)conv.id())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)-1)));
                SAMSequenceRecord convSr = conv.toSAMSequenceRecord();
                this.$outer.assert(convSr.isSameSequence(sr));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("convert from sam sequence dictionary", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SequenceDictionarySuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SAMSequenceRecord sr0 = new SAMSequenceRecord("chr0", 1000);
                Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)sr0.getSequenceIndex()));
                List srs = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SAMSequenceRecord[]{sr0}));
                SAMSequenceDictionary ssd = new SAMSequenceDictionary(ADAMContext$.MODULE$.listToJavaList(srs));
                SequenceDictionary asd = SequenceDictionary$.MODULE$.fromSAMSequenceDictionary(ssd);
                this.$outer.assert(this.$outer.convertToEqualizer(asd.apply(0).name()).$eq$eq$eq((Object)"chr0"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)asd.apply((CharSequence)"chr0").id())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

