/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.avro.Schema;
import org.apache.log4j.Level;
import org.apache.spark.Partitioner;
import org.apache.spark.RangePartitioner;
import org.apache.spark.RangePartitioner$;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.avro.ADAMRecord;
import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferencePosition$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceDictionary$;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.projections.ADAMRecordField$;
import org.bdgenomics.adam.projections.FieldValue;
import org.bdgenomics.adam.projections.Projection$;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.GenomicRegionPartitioner;
import org.bdgenomics.adam.rdd.GenomicRegionPartitionerSuite$;
import org.bdgenomics.adam.util.SparkFunSuite;
import org.bdgenomics.adam.util.SparkFunSuite$class;
import org.scalatest.BeforeAndAfter;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.FunSuite;
import org.scalatest.FunSuiteLike;
import org.scalatest.Reporter;
import org.scalatest.Stopper;
import org.scalatest.Tag;
import org.scalatest.Tracker;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0001\u0002\u0001\u0017\tir)\u001a8p[&\u001c'+Z4j_:\u0004\u0016M\u001d;ji&|g.\u001a:Tk&$XM\u0003\u0002\u0004\t\u0005\u0019!\u000f\u001a3\u000b\u0005\u00151\u0011\u0001B1eC6T!a\u0002\u0005\u0002\u0015\t$w-\u001a8p[&\u001c7OC\u0001\n\u0003\ry'oZ\u0002\u0001'\r\u0001AB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0003\u001f!\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005Eq!\u0001\u0003$v]N+\u0018\u000e^3\u0011\u0005M1R\"\u0001\u000b\u000b\u0005U!\u0011\u0001B;uS2L!a\u0006\u000b\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0003\u001f\u0001\u0011\u0005q$\u0001\u0006bI\u0006l'+Z2pe\u0012$b\u0001\t\u0014/oer\u0004CA\u0011%\u001b\u0005\u0011#BA\u0012\u0005\u0003\u0011\tgO]8\n\u0005\u0015\u0012#AC!E\u00036\u0013VmY8sI\")q%\ba\u0001Q\u0005Y!/\u001a4fe\u0016t7-Z%e!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\rIe\u000e\u001e\u0005\u0006_u\u0001\r\u0001M\u0001\u000ee\u00164WM]3oG\u0016t\u0015-\\3\u0011\u0005E\"dBA\u00153\u0013\t\u0019$&\u0001\u0004Qe\u0016$WMZ\u0005\u0003kY\u0012aa\u0015;sS:<'BA\u001a+\u0011\u0015AT\u00041\u00011\u0003!\u0011X-\u00193OC6,\u0007\"\u0002\u001e\u001e\u0001\u0004Y\u0014!B:uCJ$\bCA\u0015=\u0013\ti$F\u0001\u0003M_:<\u0007\"B \u001e\u0001\u0004\u0001\u0015A\u0003:fC\u0012l\u0015\r\u001d9fIB\u0011\u0011&Q\u0005\u0003\u0005*\u0012qAQ8pY\u0016\fg\u000eC\u0003E\u0001\u0011\u0005Q)\u0001\u0004sK\u000e|'\u000f\u001a\u000b\u0005\r2s\u0005\f\u0005\u0002H\u00156\t\u0001J\u0003\u0002J\t\u00051Qn\u001c3fYNL!a\u0013%\u0003\u001dM+\u0017/^3oG\u0016\u0014VmY8sI\")Qj\u0011a\u0001Q\u0005\u0011\u0011\u000e\u001a\u0005\u0006\u001f\u000e\u0003\r\u0001U\u0001\u0005]\u0006lW\r\u0005\u0002R-6\t!K\u0003\u0002T)\u0006!A.\u00198h\u0015\u0005)\u0016\u0001\u00026bm\u0006L!a\u0016*\u0003\u0019\rC\u0017M]*fcV,gnY3\t\u000be\u001b\u0005\u0019A\u001e\u0002\r1,gn\u001a;i\u0001")
public class GenomicRegionPartitionerSuite
extends FunSuite
implements SparkFunSuite {
    private final String sparkPortProperty;
    private SparkContext sc;
    private Option<Map<String, Level>> maybeLevels;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    private final AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    private volatile boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked;

    @Override
    public String sparkPortProperty() {
        return this.sparkPortProperty;
    }

    @Override
    public SparkContext sc() {
        return this.sc;
    }

    @Override
    public void sc_$eq(SparkContext x$1) {
        this.sc = x$1;
    }

    @Override
    public Option<Map<String, Level>> maybeLevels() {
        return this.maybeLevels;
    }

    @Override
    public void maybeLevels_$eq(Option<Map<String, Level>> x$1) {
        this.maybeLevels = x$1;
    }

    @Override
    public void org$bdgenomics$adam$util$SparkFunSuite$_setter_$sparkPortProperty_$eq(String x$1) {
        this.sparkPortProperty = x$1;
    }

    @Override
    public SparkContext createSpark(String sparkName, boolean silenceSpark) {
        return SparkFunSuite$class.createSpark(this, sparkName, silenceSpark);
    }

    @Override
    public void destroySpark() {
        SparkFunSuite$class.destroySpark(this);
    }

    @Override
    public void sparkBefore(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkBefore(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkAfter(String beforeName, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkAfter(this, beforeName, silenceSpark, body);
    }

    @Override
    public void sparkTest(String name, boolean silenceSpark, Function0<BoxedUnit> body) {
        SparkFunSuite$class.sparkTest(this, name, silenceSpark, body);
    }

    @Override
    public boolean sparkTest$default$2() {
        return SparkFunSuite$class.sparkTest$default$2(this);
    }

    @Override
    public boolean sparkBefore$default$2() {
        return SparkFunSuite$class.sparkBefore$default$2(this);
    }

    @Override
    public boolean createSpark$default$2() {
        return SparkFunSuite$class.createSpark$default$2(this);
    }

    @Override
    public boolean sparkAfter$default$2() {
        return SparkFunSuite$class.sparkAfter$default$2(this);
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$beforeFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic;
    }

    public AtomicReference<Option<Function0<Object>>> org$scalatest$BeforeAndAfter$$afterFunctionAtomic() {
        return this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic;
    }

    public boolean org$scalatest$BeforeAndAfter$$runHasBeenInvoked() {
        return this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked;
    }

    public void org$scalatest$BeforeAndAfter$$runHasBeenInvoked_$eq(boolean x$1) {
        this.org$scalatest$BeforeAndAfter$$runHasBeenInvoked = x$1;
    }

    public void org$scalatest$BeforeAndAfter$$super$runTest(String testName, Reporter reporter, Stopper stopper, Map configMap, Tracker tracker) {
        FunSuiteLike.class.runTest((FunSuiteLike)this, (String)testName, (Reporter)reporter, (Stopper)stopper, (Map)configMap, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$$super$run(Option testName, Reporter reporter, Stopper stopper, Filter filter, Map configMap, Option distributor, Tracker tracker) {
        FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, (Map)configMap, (Option)distributor, (Tracker)tracker);
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$beforeFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$beforeFunctionAtomic = x$1;
    }

    public void org$scalatest$BeforeAndAfter$_setter_$org$scalatest$BeforeAndAfter$$afterFunctionAtomic_$eq(AtomicReference x$1) {
        this.org$scalatest$BeforeAndAfter$$afterFunctionAtomic = x$1;
    }

    public void before(Function0<Object> fun) {
        BeforeAndAfter.class.before((BeforeAndAfter)this, fun);
    }

    public void after(Function0<Object> fun) {
        BeforeAndAfter.class.after((BeforeAndAfter)this, fun);
    }

    public void runTest(String testName, Reporter reporter, Stopper stopper, Map<String, Object> configMap, Tracker tracker) {
        BeforeAndAfter.class.runTest((BeforeAndAfter)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    public void run(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        BeforeAndAfter.class.run((BeforeAndAfter)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public ADAMRecord adamRecord(int referenceId, String referenceName, String readName, long start, boolean readMapped) {
        return ADAMRecord.newBuilder().setReferenceId(Predef$.MODULE$.int2Integer(referenceId)).setReferenceName((CharSequence)referenceName).setReadName((CharSequence)readName).setReadMapped(Predef$.MODULE$.boolean2Boolean(readMapped)).setStart(Predef$.MODULE$.long2Long(start)).build();
    }

    public SequenceRecord record(int id, CharSequence name, long length) {
        return SequenceRecord$.MODULE$.apply(id, name, length, (CharSequence)"", SequenceRecord$.MODULE$.apply$default$5());
    }

    public GenomicRegionPartitionerSuite() {
        BeforeAndAfter.class.$init$((BeforeAndAfter)this);
        SparkFunSuite$class.$init$(this);
        this.test("partitions the UNMAPPED ReferencePosition into the top partition", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenomicRegionPartitionerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenomicRegionPartitioner parter = new GenomicRegionPartitioner(10, SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(0, "foo", 1000L)})));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.numPartitions())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)11)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)ReferencePosition$.MODULE$.UNMAPPED()))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("partitioning into N pieces on M total sequence length, where N > M, results in M partitions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenomicRegionPartitionerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenomicRegionPartitioner parter = new GenomicRegionPartitioner(10, SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(0, "foo", 9L)})));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.numPartitions())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("correctly partitions a single dummy sequence into two pieces", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenomicRegionPartitionerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenomicRegionPartitioner parter = new GenomicRegionPartitioner(2, SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(0, "foo", 10L)})));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition(0, 3L)))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition(0, 7L)))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("correctly counts cumulative lengths", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenomicRegionPartitionerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenomicRegionPartitioner parter = new GenomicRegionPartitioner(3, SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(0, "foo", 20L), this.$outer.record(1, "bar", 10L)})));
                this.$outer.assert(this.$outer.convertToEqualizer(parter.cumulativeLengths().apply((Object)BoxesRunTime.boxToInteger((int)0))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.assert(this.$outer.convertToEqualizer(parter.cumulativeLengths().apply((Object)BoxesRunTime.boxToInteger((int)1))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)20)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("correctly partitions positions across two dummy sequences", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenomicRegionPartitionerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GenomicRegionPartitioner parter = new GenomicRegionPartitioner(3, SequenceDictionary$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SequenceRecord[]{this.$outer.record(0, "foo", 20L), this.$outer.record(1, "bar", 10L)})));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition(0, 8L)))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition(0, 18L)))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition(1, 8L)))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition(0, 0L)))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition(0, 10L)))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)parter.getPartition((Object)new ReferencePosition(1, 0L)))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("test that we can range partition ADAMRecords", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ GenomicRegionPartitionerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Random rand = new Random(1000L);
                SparkContext qual$1 = this.$outer.sc();
                Predef$ predef$ = Predef$.MODULE$;
                IndexedSeq x$2 = (IndexedSeq)RichInt$.MODULE$.to$extension0(1, 1000).map((Function1)new Serializable(this, rand){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    private final Random rand$1;

                    public final ADAMRecord apply(int i) {
                        Predef$ predef$ = Predef$.MODULE$;
                        return this.$outer.$outer.adamRecord(0, "1", new StringOps("read_%d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})), this.rand$1.nextInt(100), true);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.rand$1 = rand$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                int x$3 = qual$1.parallelize$default$2();
                RDD pos = qual$1.parallelize((Seq)x$2, x$3, ClassTag$.MODULE$.apply(ADAMRecord.class));
                RDD pairs = pos.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<ReferencePosition, ADAMRecord> apply(ADAMRecord p) {
                        return new Tuple2((Object)new ReferencePosition(Predef$.MODULE$.Integer2int(p.getReferenceId()), Predef$.MODULE$.Long2long(p.getStart())), (Object)p);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                RangePartitioner parter = new RangePartitioner(200, pairs, RangePartitioner$.MODULE$.$lessinit$greater$default$3(), (Function1)Predef$.MODULE$.conforms(), ClassTag$.MODULE$.apply(ReferencePosition.class));
                OrderedRDDFunctions qual$2 = SparkContext$.MODULE$.rddToOrderedRDDFunctions(pairs, (Function1)Predef$.MODULE$.conforms(), ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(ADAMRecord.class));
                boolean x$4 = qual$2.sortByKey$default$1();
                int x$5 = qual$2.sortByKey$default$2();
                RDD partitioned = SparkContext$.MODULE$.rddToPairRDDFunctions(qual$2.sortByKey(x$4, x$5), ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(ADAMRecord.class)).partitionBy((Partitioner)parter);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)partitioned.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1000)));
                RDD sizes = partitioned.mapPartitions((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterator<Object> apply(Iterator<Tuple2<ReferencePosition, ADAMRecord>> itr) {
                        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{itr.size()})).iterator();
                    }
                }, partitioned.mapPartitions$default$2(), ClassTag$.MODULE$.Int());
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)Predef$.MODULE$.intArrayOps((int[])sizes.collect()).size())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)200)));
            }

            public /* synthetic */ GenomicRegionPartitionerSuite org$bdgenomics$adam$rdd$GenomicRegionPartitionerSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.sparkTest("test that simple partitioning works okay on a reasonable set of ADAMRecords", this.sparkTest$default$2(), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GenomicRegionPartitionerSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String filename = ClassLoader.getSystemClassLoader().getResource("reads12.sam").getFile();
                SequenceDictionary dict = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc()).adamDictionaryLoad(filename, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(ADAMRecord.class));
                GenomicRegionPartitioner parter = new GenomicRegionPartitioner(1, dict);
                Schema p = Projection$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{ADAMRecordField$.MODULE$.referenceName(), ADAMRecordField$.MODULE$.referenceId(), ADAMRecordField$.MODULE$.start(), ADAMRecordField$.MODULE$.readName(), ADAMRecordField$.MODULE$.readMapped()}));
                ADAMContext qual$3 = ADAMContext$.MODULE$.sparkContextToADAMContext(this.$outer.sc());
                Some x$7 = new Some((Object)p);
                None$ x$8 = qual$3.adamLoad$default$2();
                RDD rdd = qual$3.adamLoad(filename, (Option)x$8, (Option)x$7, (Function1)Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(ADAMRecord.class));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)rdd.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)200)));
                OrderedRDDFunctions qual$4 = SparkContext$.MODULE$.rddToOrderedRDDFunctions(rdd.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<ReferencePosition, ADAMRecord> apply(ADAMRecord rec) {
                        return new Tuple2((Object)new ReferencePosition(Predef$.MODULE$.Integer2int(rec.getReferenceId()), Predef$.MODULE$.Long2long(rec.getStart())), (Object)rec);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class)), (Function1)Predef$.MODULE$.conforms(), ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(ADAMRecord.class));
                boolean x$9 = qual$4.sortByKey$default$1();
                int x$10 = qual$4.sortByKey$default$2();
                RDD keyed = qual$4.sortByKey(x$9, x$10);
                ReferencePosition[] keys = (ReferencePosition[])keyed.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ReferencePosition apply(Tuple2<ReferencePosition, ADAMRecord> x$1) {
                        return (ReferencePosition)x$1._1();
                    }
                }, ClassTag$.MODULE$.apply(ReferencePosition.class)).collect();
                this.$outer.assert(!Predef$.MODULE$.refArrayOps((Object[])keys).exists((Function1)new Serializable(this, 1, parter){
                    public static final long serialVersionUID = 0L;
                    private final int parts$1;
                    private final GenomicRegionPartitioner parter$1;

                    public final boolean apply(ReferencePosition rp) {
                        return this.parter$1.getPartition((Object)rp) < 0 || this.parter$1.getPartition((Object)rp) >= this.parts$1;
                    }
                    {
                        this.parts$1 = parts$1;
                        this.parter$1 = parter$1;
                    }
                }));
                RDD partitioned = SparkContext$.MODULE$.rddToPairRDDFunctions(keyed, ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(ADAMRecord.class)).partitionBy((Partitioner)parter);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)partitioned.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)200)));
                RDD partSizes = partitioned.mapPartitions((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterator<Object> apply(Iterator<Tuple2<ReferencePosition, ADAMRecord>> itr) {
                        return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{itr.size()})).iterator();
                    }
                }, partitioned.mapPartitions$default$2(), ClassTag$.MODULE$.Int());
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)partSizes.count())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)(1 + 1))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

