/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.util;

import net.sf.samtools.Cigar;
import net.sf.samtools.TextCigarCodec;
import org.bdgenomics.adam.avro.ADAMRecord;
import org.bdgenomics.adam.rich.RichADAMRecord$;
import org.bdgenomics.adam.util.MdTag;
import org.bdgenomics.adam.util.MdTag$;
import org.bdgenomics.adam.util.MdTagSuite$;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001]1A!\u0001\u0002\u0001\u0017\tQQ\n\u001a+bON+\u0018\u000e^3\u000b\u0005\r!\u0011\u0001B;uS2T!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\ty\u0001\"A\u0005tG\u0006d\u0017\r^3ti&\u0011\u0011C\u0004\u0002\t\rVt7+^5uK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001")
public class MdTagSuite
extends FunSuite {
    public MdTagSuite() {
        this.test("null md tag", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                MdTag$.MODULE$.apply(null, 0L);
            }

            public void apply$mcV$sp() {
                MdTag$.MODULE$.apply(null, 0L);
            }
        });
        this.test("zero length md tag", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply() {
                MdTag$.MODULE$.apply("", 0L);
            }

            public void apply$mcV$sp() {
                MdTag$.MODULE$.apply("", 0L);
            }
        });
        this.test("md tag with non-digit initial value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MdTag apply() {
                        return MdTag$.MODULE$.apply("ACTG0", 0L);
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("md tag invalid base", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MdTag apply() {
                        return MdTag$.MODULE$.apply("0ACTZ", 0L);
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("md tag with no digit at end", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MdTag apply() {
                        return MdTag$.MODULE$.apply("0ACTG", 0L);
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("valid md tags", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            /*
             * Unable to fully structure code
             */
            public void apply$mcV$sp() {
                md1 = MdTag$.MODULE$.apply("0A0", 0L);
                v0 = md1.mismatchedBase(0L);
                var2_2 = new Some((Object)BoxesRunTime.boxToCharacter((char)'A'));
                this.$outer.assert(!(v0 != null ? v0.equals(var2_2) == false : var2_2 != null));
                md2 = MdTag$.MODULE$.apply("100", 0L);
                var3_4 = Predef$.MODULE$;
                var80_5 = new Serializable(this, md2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;
                    private final MdTag md2$1;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        this.$outer.$outer.assert(this.md2$1.isMatch((long)i));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.md2$1 = md2$1;
                    }
                };
                var4_6 = RichInt$.MODULE$.until$extension0(0, 100);
                if (!var4_6.validateRangeBoundaries((Function1)var80_5)) ** GOTO lbl15
                var82_7 = var4_6.start();
                var5_8 = var4_6.terminalElement();
                var81_9 = var4_6.step();
                while (true) {
                    block13: {
                        if (var82_7 != var5_8) break block13;
lbl15:
                        // 2 sources

                        this.$outer.assert(md2.isMatch(-1L) == false);
                        md3 = MdTag$.MODULE$.apply("100C2", 0L);
                        var7_11 = Predef$.MODULE$;
                        var77_12 = new Serializable(this, md3){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$6 $outer;
                            private final MdTag md3$1;

                            public final void apply(int i) {
                                this.apply$mcVI$sp(i);
                            }

                            public void apply$mcVI$sp(int i) {
                                this.$outer.$outer.assert(this.md3$1.isMatch((long)i));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.md3$1 = md3$1;
                            }
                        };
                        var8_13 = RichInt$.MODULE$.until$extension0(0, 100);
                        if (!var8_13.validateRangeBoundaries((Function1)var77_12)) ** GOTO lbl26
                        var79_14 = var8_13.start();
                        var9_15 = var8_13.terminalElement();
                        var78_16 = var8_13.step();
                        while (true) {
                            block14: {
                                if (var79_14 != var9_15) break block14;
lbl26:
                                // 2 sources

                                v1 = md3.mismatchedBase(100L);
                                var10_17 = new Some((Object)BoxesRunTime.boxToCharacter((char)'C'));
                                this.$outer.assert(!(v1 != null ? v1.equals(var10_17) == false : var10_17 != null));
                                var11_18 = Predef$.MODULE$;
                                var74_19 = new Serializable(this, md3){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$6 $outer;
                                    private final MdTag md3$1;

                                    public final void apply(int i) {
                                        this.apply$mcVI$sp(i);
                                    }

                                    public void apply$mcVI$sp(int i) {
                                        this.$outer.$outer.assert(this.md3$1.isMatch((long)i));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.md3$1 = md3$1;
                                    }
                                };
                                var13_20 = RichInt$.MODULE$.until$extension0(101, 103);
                                if (!var13_20.validateRangeBoundaries((Function1)var74_19)) ** GOTO lbl38
                                var76_21 = var13_20.start();
                                var14_22 = var13_20.terminalElement();
                                var75_23 = var13_20.step();
                                while (true) {
                                    block15: {
                                        if (var76_21 != var14_22) break block15;
lbl38:
                                        // 2 sources

                                        md4 = MdTag$.MODULE$.apply("100C0^C20", 0L);
                                        var15_25 = Predef$.MODULE$;
                                        var71_26 = new Serializable(this, md4){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$6 $outer;
                                            private final MdTag md4$1;

                                            public final void apply(int i) {
                                                this.apply$mcVI$sp(i);
                                            }

                                            public void apply$mcVI$sp(int i) {
                                                this.$outer.$outer.assert(this.md4$1.isMatch((long)i));
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                                this.md4$1 = md4$1;
                                            }
                                        };
                                        var16_27 = RichInt$.MODULE$.until$extension0(0, 100);
                                        if (!var16_27.validateRangeBoundaries((Function1)var71_26)) ** GOTO lbl48
                                        var73_28 = var16_27.start();
                                        var17_29 = var16_27.terminalElement();
                                        var72_30 = var16_27.step();
                                        while (true) {
                                            block16: {
                                                if (var73_28 != var17_29) break block16;
lbl48:
                                                // 2 sources

                                                v2 = md4.mismatchedBase(100L);
                                                var18_31 = new Some((Object)BoxesRunTime.boxToCharacter((char)'C'));
                                                this.$outer.assert(!(v2 != null ? v2.equals(var18_31) == false : var18_31 != null));
                                                v3 = md4.deletedBase(101L);
                                                var19_32 = new Some((Object)BoxesRunTime.boxToCharacter((char)'C'));
                                                this.$outer.assert(!(v3 != null ? v3.equals(var19_32) == false : var19_32 != null));
                                                var20_33 = Predef$.MODULE$;
                                                var68_34 = new Serializable(this, md4){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ $anonfun$6 $outer;
                                                    private final MdTag md4$1;

                                                    public final void apply(int i) {
                                                        this.apply$mcVI$sp(i);
                                                    }

                                                    public void apply$mcVI$sp(int i) {
                                                        this.$outer.$outer.assert(this.md4$1.isMatch((long)i));
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw new NullPointerException();
                                                        }
                                                        this.$outer = $outer;
                                                        this.md4$1 = md4$1;
                                                    }
                                                };
                                                var22_35 = RichInt$.MODULE$.until$extension0(102, 122);
                                                if (!var22_35.validateRangeBoundaries((Function1)var68_34)) ** GOTO lbl63
                                                var70_36 = var22_35.start();
                                                var23_37 = var22_35.terminalElement();
                                                var69_38 = var22_35.step();
                                                while (true) {
                                                    block17: {
                                                        if (var70_36 != var23_37) break block17;
lbl63:
                                                        // 2 sources

                                                        md5 = MdTag$.MODULE$.apply(new StringBuilder().append((Object)"0^").append((Object)"ACGTACGTACGT").append((Object)"10").toString(), 0L);
                                                        var24_40 = Predef$.MODULE$;
                                                        var65_41 = new Serializable(this, "ACGTACGTACGT", md5){
                                                            public static final long serialVersionUID = 0L;
                                                            private final /* synthetic */ $anonfun$6 $outer;
                                                            private final String deletedString$1;
                                                            private final MdTag md5$1;

                                                            public final void apply(int i) {
                                                                this.apply$mcVI$sp(i);
                                                            }

                                                            public void apply$mcVI$sp(int i) {
                                                                Option option = this.md5$1.deletedBase((long)i);
                                                                Some some = new Some((Object)BoxesRunTime.boxToCharacter((char)this.deletedString$1.charAt(i)));
                                                                this.$outer.$outer.assert(!(option != null ? !option.equals(some) : some != null));
                                                            }
                                                            {
                                                                if ($outer == null) {
                                                                    throw new NullPointerException();
                                                                }
                                                                this.$outer = $outer;
                                                                this.deletedString$1 = deletedString$1;
                                                                this.md5$1 = md5$1;
                                                            }
                                                        };
                                                        var26_42 = RichInt$.MODULE$.until$extension0(0, "ACGTACGTACGT".length());
                                                        if (!var26_42.validateRangeBoundaries((Function1)var65_41)) ** GOTO lbl73
                                                        var67_43 = var26_42.start();
                                                        var27_44 = var26_42.terminalElement();
                                                        var66_45 = var26_42.step();
                                                        while (true) {
                                                            block18: {
                                                                if (var67_43 != var27_44) break block18;
lbl73:
                                                                // 2 sources

                                                                md6 = MdTag$.MODULE$.apply("22^A79", 0L);
                                                                var28_47 = Predef$.MODULE$;
                                                                var62_48 = new Serializable(this, md6){
                                                                    public static final long serialVersionUID = 0L;
                                                                    private final /* synthetic */ $anonfun$6 $outer;
                                                                    private final MdTag md6$1;

                                                                    public final void apply(int i) {
                                                                        this.apply$mcVI$sp(i);
                                                                    }

                                                                    public void apply$mcVI$sp(int i) {
                                                                        this.$outer.$outer.assert(this.md6$1.isMatch((long)i));
                                                                    }
                                                                    {
                                                                        if ($outer == null) {
                                                                            throw new NullPointerException();
                                                                        }
                                                                        this.$outer = $outer;
                                                                        this.md6$1 = md6$1;
                                                                    }
                                                                };
                                                                var29_49 = RichInt$.MODULE$.until$extension0(0, 22);
                                                                if (!var29_49.validateRangeBoundaries((Function1)var62_48)) ** GOTO lbl83
                                                                var64_50 = var29_49.start();
                                                                var30_51 = var29_49.terminalElement();
                                                                var63_52 = var29_49.step();
                                                                while (true) {
                                                                    block19: {
                                                                        if (var64_50 != var30_51) break block19;
lbl83:
                                                                        // 2 sources

                                                                        v4 = md6.deletedBase(22L);
                                                                        var31_53 = new Some((Object)BoxesRunTime.boxToCharacter((char)'A'));
                                                                        this.$outer.assert(!(v4 != null ? v4.equals(var31_53) == false : var31_53 != null));
                                                                        var32_54 = Predef$.MODULE$;
                                                                        var59_55 = new Serializable(this, md6){
                                                                            public static final long serialVersionUID = 0L;
                                                                            private final /* synthetic */ $anonfun$6 $outer;
                                                                            private final MdTag md6$1;

                                                                            public final void apply(int i) {
                                                                                this.apply$mcVI$sp(i);
                                                                            }

                                                                            public void apply$mcVI$sp(int i) {
                                                                                this.$outer.$outer.assert(this.md6$1.isMatch((long)i));
                                                                            }
                                                                            {
                                                                                if ($outer == null) {
                                                                                    throw new NullPointerException();
                                                                                }
                                                                                this.$outer = $outer;
                                                                                this.md6$1 = md6$1;
                                                                            }
                                                                        };
                                                                        var34_56 = RichInt$.MODULE$.until$extension0(23, 102);
                                                                        if (!var34_56.validateRangeBoundaries((Function1)var59_55)) ** GOTO lbl95
                                                                        var61_57 = var34_56.start();
                                                                        var35_58 = var34_56.terminalElement();
                                                                        var60_59 = var34_56.step();
                                                                        while (true) {
                                                                            block20: {
                                                                                if (var61_57 != var35_58) break block20;
lbl95:
                                                                                // 2 sources

                                                                                md7 = MdTag$.MODULE$.apply("39r36c23", 0L);
                                                                                var36_61 = Predef$.MODULE$;
                                                                                var56_62 = new Serializable(this, md7){
                                                                                    public static final long serialVersionUID = 0L;
                                                                                    private final /* synthetic */ $anonfun$6 $outer;
                                                                                    private final MdTag md7$1;

                                                                                    public final void apply(int i) {
                                                                                        this.apply$mcVI$sp(i);
                                                                                    }

                                                                                    public void apply$mcVI$sp(int i) {
                                                                                        this.$outer.$outer.assert(this.md7$1.isMatch((long)i));
                                                                                    }
                                                                                    {
                                                                                        if ($outer == null) {
                                                                                            throw new NullPointerException();
                                                                                        }
                                                                                        this.$outer = $outer;
                                                                                        this.md7$1 = md7$1;
                                                                                    }
                                                                                };
                                                                                var37_63 = RichInt$.MODULE$.until$extension0(0, 39);
                                                                                if (!var37_63.validateRangeBoundaries((Function1)var56_62)) ** GOTO lbl105
                                                                                var58_64 = var37_63.start();
                                                                                var38_65 = var37_63.terminalElement();
                                                                                var57_66 = var37_63.step();
                                                                                while (true) {
                                                                                    block21: {
                                                                                        if (var58_64 != var38_65) break block21;
lbl105:
                                                                                        // 2 sources

                                                                                        v5 = md7.mismatchedBase(39L);
                                                                                        var39_67 = new Some((Object)BoxesRunTime.boxToCharacter((char)'R'));
                                                                                        this.$outer.assert(!(v5 != null ? v5.equals(var39_67) == false : var39_67 != null));
                                                                                        var40_68 = Predef$.MODULE$;
                                                                                        var53_69 = new Serializable(this, md7){
                                                                                            public static final long serialVersionUID = 0L;
                                                                                            private final /* synthetic */ $anonfun$6 $outer;
                                                                                            private final MdTag md7$1;

                                                                                            public final void apply(int i) {
                                                                                                this.apply$mcVI$sp(i);
                                                                                            }

                                                                                            public void apply$mcVI$sp(int i) {
                                                                                                this.$outer.$outer.assert(this.md7$1.isMatch((long)i));
                                                                                            }
                                                                                            {
                                                                                                if ($outer == null) {
                                                                                                    throw new NullPointerException();
                                                                                                }
                                                                                                this.$outer = $outer;
                                                                                                this.md7$1 = md7$1;
                                                                                            }
                                                                                        };
                                                                                        var41_70 = RichInt$.MODULE$.until$extension0(40, 76);
                                                                                        if (!var41_70.validateRangeBoundaries((Function1)var53_69)) ** GOTO lbl117
                                                                                        var55_71 = var41_70.start();
                                                                                        var42_72 = var41_70.terminalElement();
                                                                                        var54_73 = var41_70.step();
                                                                                        while (true) {
                                                                                            block22: {
                                                                                                if (var55_71 != var42_72) break block22;
lbl117:
                                                                                                // 2 sources

                                                                                                v6 = md7.mismatchedBase(76L);
                                                                                                var43_74 = new Some((Object)BoxesRunTime.boxToCharacter((char)'C'));
                                                                                                this.$outer.assert(!(v6 != null ? v6.equals(var43_74) == false : var43_74 != null));
                                                                                                var44_75 = Predef$.MODULE$;
                                                                                                var50_76 = new Serializable(this, md7){
                                                                                                    public static final long serialVersionUID = 0L;
                                                                                                    private final /* synthetic */ $anonfun$6 $outer;
                                                                                                    private final MdTag md7$1;

                                                                                                    public final void apply(int i) {
                                                                                                        this.apply$mcVI$sp(i);
                                                                                                    }

                                                                                                    public void apply$mcVI$sp(int i) {
                                                                                                        this.$outer.$outer.assert(this.md7$1.isMatch((long)i));
                                                                                                    }
                                                                                                    {
                                                                                                        if ($outer == null) {
                                                                                                            throw new NullPointerException();
                                                                                                        }
                                                                                                        this.$outer = $outer;
                                                                                                        this.md7$1 = md7$1;
                                                                                                    }
                                                                                                };
                                                                                                var46_77 = RichInt$.MODULE$.until$extension0(77, 100);
                                                                                                if (!var46_77.validateRangeBoundaries((Function1)var50_76)) ** GOTO lbl129
                                                                                                var52_78 = var46_77.start();
                                                                                                var47_79 = var46_77.terminalElement();
                                                                                                var51_80 = var46_77.step();
                                                                                                while (true) {
                                                                                                    block23: {
                                                                                                        if (var52_78 != var47_79) break block23;
lbl129:
                                                                                                        // 2 sources

                                                                                                        mdy = MdTag$.MODULE$.apply("34Y18G46", 0L);
                                                                                                        v7 = mdy.mismatchedBase(34L);
                                                                                                        var49_82 = new Some((Object)BoxesRunTime.boxToCharacter((char)'Y'));
                                                                                                        this.$outer.assert(!(v7 != null ? v7.equals(var49_82) == false : var49_82 != null));
                                                                                                        return;
                                                                                                    }
                                                                                                    var50_76.apply$mcVI$sp(var52_78);
                                                                                                    var52_78 += var51_80;
                                                                                                }
                                                                                            }
                                                                                            var53_69.apply$mcVI$sp(var55_71);
                                                                                            var55_71 += var54_73;
                                                                                        }
                                                                                    }
                                                                                    var56_62.apply$mcVI$sp(var58_64);
                                                                                    var58_64 += var57_66;
                                                                                }
                                                                            }
                                                                            var59_55.apply$mcVI$sp(var61_57);
                                                                            var61_57 += var60_59;
                                                                        }
                                                                    }
                                                                    var62_48.apply$mcVI$sp(var64_50);
                                                                    var64_50 += var63_52;
                                                                }
                                                            }
                                                            var65_41.apply$mcVI$sp(var67_43);
                                                            var67_43 += var66_45;
                                                        }
                                                    }
                                                    var68_34.apply$mcVI$sp(var70_36);
                                                    var70_36 += var69_38;
                                                }
                                            }
                                            var71_26.apply$mcVI$sp(var73_28);
                                            var73_28 += var72_30;
                                        }
                                    }
                                    var74_19.apply$mcVI$sp(var76_21);
                                    var76_21 += var75_23;
                                }
                            }
                            var77_12.apply$mcVI$sp(var79_14);
                            var79_14 += var78_16;
                        }
                    }
                    var80_5.apply$mcVI$sp(var82_7);
                    var82_7 += var81_9;
                }
            }

            public /* synthetic */ MdTagSuite org$bdgenomics$adam$util$MdTagSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get start of read with no mismatches or deletions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("60", 1L);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tag.start())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)1L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get start of read with no mismatches, but with a deletion at the start", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("0^AC60", 5L);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tag.start())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)5L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get start of read with mismatches at the start", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("0AC60", 10L);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tag.start())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)10L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get end of read with no mismatches or deletions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("60", 1L);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tag.end())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)60L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("check that mdtag and rich record return same end", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$ predef$ = Predef$.MODULE$;
                ADAMRecord read = ADAMRecord.newBuilder().setSequence((CharSequence)new StringOps("A").$times(60)).setStart(Predef$.MODULE$.long2Long(1L)).setCigar((CharSequence)"60M").setMismatchingPositions((CharSequence)"60").setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).build();
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)((MdTag)RichADAMRecord$.MODULE$.recordToRichRecord(read).mdTag().get()).end())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)RichADAMRecord$.MODULE$.recordToRichRecord(read).end().get()) - 1L))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get end of read with no mismatches, but a deletion at end", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("60^AC0", 1L);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tag.end())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)62L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get end of read with mismatches and a deletion at end", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("60^AC0A0C0", 1L);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tag.end())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)64L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get correct string out of mdtag with no mismatches", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("60", 1L);
                this.$outer.assert(this.$outer.convertToEqualizer(tag.toString()).$eq$eq$eq((Object)"60"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get correct string out of mdtag with mismatches at start", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("0A0C10", 100L);
                this.$outer.assert(this.$outer.convertToEqualizer(tag.toString()).$eq$eq$eq((Object)"0A0C10"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get correct string out of mdtag with deletion at end", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("10^GG0", 200L);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tag.start())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)200L)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tag.end())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)211L)));
                this.$outer.assert(this.$outer.convertToEqualizer(tag.toString()).$eq$eq$eq((Object)"10^GG0"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get correct string out of mdtag with mismatches at end", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("10G0G0", 200L);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tag.start())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)200L)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)tag.end())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)211L)));
                this.$outer.assert(this.$outer.convertToEqualizer(tag.toString()).$eq$eq$eq((Object)"10G0G0"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("get correct string out of complex mdtag", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MdTag tag = MdTag$.MODULE$.apply("0AT0^GC0", 5123L);
                this.$outer.assert(this.$outer.convertToEqualizer(tag.toString()).$eq$eq$eq((Object)"0A0T0^GC0"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("check complex mdtag", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMRecord read = ADAMRecord.newBuilder().setSequence((CharSequence)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA").setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)"29M10D31M").setStart(Predef$.MODULE$.long2Long(5L)).setMismatchingPositions((CharSequence)"29^GGGGGGGGGG10G0G0G0G0G0G0G0G0G0G11").build();
                MdTag tag = (MdTag)RichADAMRecord$.MODULE$.recordToRichRecord(read).mdTag().get();
                Predef$ predef$ = Predef$.MODULE$;
                this.$outer.assert(RichInt$.MODULE$.until$extension0(5, 34).forall((Function1)new Serializable(this, tag){
                    public static final long serialVersionUID = 0L;
                    public final MdTag tag$1;

                    public final boolean apply(int i) {
                        return this.tag$1.isMatch((long)i);
                    }

                    public boolean apply$mcZI$sp(int i) {
                        return this.tag$1.isMatch((long)i);
                    }
                    {
                        this.tag$1 = tag$1;
                    }
                }));
                Predef$ predef$2 = Predef$.MODULE$;
                this.$outer.assert(RichInt$.MODULE$.until$extension0(34, 44).forall((Function1)new Serializable(this, tag){
                    public static final long serialVersionUID = 0L;
                    private final MdTag tag$1;

                    public final boolean apply(int i) {
                        return this.apply$mcZI$sp(i);
                    }

                    public boolean apply$mcZI$sp(int i) {
                        return BoxesRunTime.unboxToChar((Object)this.tag$1.deletedBase((long)i).get()) == 'G';
                    }
                    {
                        this.tag$1 = tag$1;
                    }
                }));
                Predef$ predef$3 = Predef$.MODULE$;
                this.$outer.assert(RichInt$.MODULE$.until$extension0(44, 54).forall((Function1)new Serializable(this, tag){
                    public static final long serialVersionUID = 0L;
                    public final MdTag tag$1;

                    public final boolean apply(int i) {
                        return this.tag$1.isMatch((long)i);
                    }

                    public boolean apply$mcZI$sp(int i) {
                        return this.tag$1.isMatch((long)i);
                    }
                    {
                        this.tag$1 = tag$1;
                    }
                }));
                Predef$ predef$4 = Predef$.MODULE$;
                this.$outer.assert(RichInt$.MODULE$.until$extension0(54, 64).forall((Function1)new Serializable(this, tag){
                    public static final long serialVersionUID = 0L;
                    private final MdTag tag$1;

                    public final boolean apply(int i) {
                        return this.apply$mcZI$sp(i);
                    }

                    public boolean apply$mcZI$sp(int i) {
                        return BoxesRunTime.unboxToChar((Object)this.tag$1.mismatchedBase((long)i).get()) == 'G';
                    }
                    {
                        this.tag$1 = tag$1;
                    }
                }));
                Predef$ predef$5 = Predef$.MODULE$;
                this.$outer.assert(RichInt$.MODULE$.until$extension0(64, (int)BoxesRunTime.unboxToLong((Object)RichADAMRecord$.MODULE$.recordToRichRecord(read).end().get())).forall((Function1)new Serializable(this, tag){
                    public static final long serialVersionUID = 0L;
                    public final MdTag tag$1;

                    public final boolean apply(int i) {
                        return this.tag$1.isMatch((long)i);
                    }

                    public boolean apply$mcZI$sp(int i) {
                        return this.tag$1.isMatch((long)i);
                    }
                    {
                        this.tag$1 = tag$1;
                    }
                }));
                this.$outer.assert(this.$outer.convertToEqualizer(tag.getReference(RichADAMRecord$.MODULE$.recordToRichRecord(read))).$eq$eq$eq((Object)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAGGGGGGGGGGAAAAAAAAAAGGGGGGGGGGAAAAAAAAAAA"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("move a cigar alignment by two for a read", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMRecord read = ADAMRecord.newBuilder().setSequence((CharSequence)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA").setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)"29M10D31M").setStart(Predef$.MODULE$.long2Long(7L)).setMismatchingPositions((CharSequence)"27G0G0^GGGGGGGGAA8G0G0G0G0G0G0G0G0G0G13").build();
                TextCigarCodec CIGAR_CODEC = TextCigarCodec.getSingleton();
                Cigar newCigar = CIGAR_CODEC.decode("27M10D33M");
                MdTag newTag = MdTag$.MODULE$.moveAlignment(RichADAMRecord$.MODULE$.recordToRichRecord(read), newCigar);
                this.$outer.assert(this.$outer.convertToEqualizer(newTag.toString()).$eq$eq$eq((Object)"27^GGGGGGGGGG10G0G0G0G0G0G0G0G0G0G13"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rewrite alignment to all matches", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMRecord read = ADAMRecord.newBuilder().setSequence((CharSequence)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA").setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)"29M10D31M").setStart(Predef$.MODULE$.long2Long(7L)).setMismatchingPositions((CharSequence)"27G0G0^GGGGGGGGAA8G0G0G0G0G0G0G0G0G0G13").build();
                TextCigarCodec CIGAR_CODEC = TextCigarCodec.getSingleton();
                Cigar newCigar = CIGAR_CODEC.decode("60M");
                MdTag newTag = MdTag$.MODULE$.moveAlignment(RichADAMRecord$.MODULE$.recordToRichRecord(read), newCigar, "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", 100L);
                this.$outer.assert(this.$outer.convertToEqualizer(newTag.toString()).$eq$eq$eq((Object)"60"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)newTag.start())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)100L)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)newTag.end())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)159L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rewrite alignment to two mismatches followed by all matches", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMRecord read = ADAMRecord.newBuilder().setSequence((CharSequence)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA").setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)"29M10D31M").setStart(Predef$.MODULE$.long2Long(7L)).setMismatchingPositions((CharSequence)"27G0G0^GGGGGGGGAA8G0G0G0G0G0G0G0G0G0G13").build();
                TextCigarCodec CIGAR_CODEC = TextCigarCodec.getSingleton();
                Cigar newCigar = CIGAR_CODEC.decode("60M");
                MdTag newTag = MdTag$.MODULE$.moveAlignment(RichADAMRecord$.MODULE$.recordToRichRecord(read), newCigar, "GGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", 100L);
                this.$outer.assert(this.$outer.convertToEqualizer(newTag.toString()).$eq$eq$eq((Object)"0G0G58"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)newTag.start())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)100L)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)newTag.end())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)159L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rewrite alignment to include a deletion but otherwise all matches", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMRecord read = ADAMRecord.newBuilder().setSequence((CharSequence)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA").setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)"29M10D31M").setStart(Predef$.MODULE$.long2Long(7L)).setMismatchingPositions((CharSequence)"27G0G0^GGGGGGGGAA8G0G0G0G0G0G0G0G0G0G13").build();
                TextCigarCodec CIGAR_CODEC = TextCigarCodec.getSingleton();
                Cigar newCigar = CIGAR_CODEC.decode("10M10D50M");
                MdTag newTag = MdTag$.MODULE$.moveAlignment(RichADAMRecord$.MODULE$.recordToRichRecord(read), newCigar, "AAAAAAAAAAGGGGGGGGGGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", 100L);
                this.$outer.assert(this.$outer.convertToEqualizer(newTag.toString()).$eq$eq$eq((Object)"10^GGGGGGGGGG50"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)newTag.start())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)100L)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)newTag.end())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)169L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rewrite alignment to include an insertion at the start of the read but otherwise all matches", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MdTagSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMRecord read = ADAMRecord.newBuilder().setSequence((CharSequence)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA").setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)"29M10D31M").setStart(Predef$.MODULE$.long2Long(7L)).setMismatchingPositions((CharSequence)"27G0G0^GGGGGGGGAA8G0G0G0G0G0G0G0G0G0G13").build();
                TextCigarCodec CIGAR_CODEC = TextCigarCodec.getSingleton();
                Cigar newCigar = CIGAR_CODEC.decode("10I50M");
                MdTag newTag = MdTag$.MODULE$.moveAlignment(RichADAMRecord$.MODULE$.recordToRichRecord(read), newCigar, "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", 100L);
                this.$outer.assert(this.$outer.convertToEqualizer(newTag.toString()).$eq$eq$eq((Object)"50"));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)newTag.start())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)100L)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)newTag.end())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)149L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

