/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.util;

import net.sf.samtools.Cigar;
import net.sf.samtools.TextCigarCodec;
import org.bdgenomics.adam.avro.ADAMRecord;
import org.bdgenomics.adam.rich.RichADAMRecord;
import org.bdgenomics.adam.rich.RichADAMRecord$;
import org.bdgenomics.adam.util.NormalizationUtils$;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00192A!\u0001\u0002\u0001\u0017\t9bj\u001c:nC2L'0\u0019;j_:,F/\u001b7t'VLG/\u001a\u0006\u0003\u0007\u0011\tA!\u001e;jY*\u0011QAB\u0001\u0005C\u0012\fWN\u0003\u0002\b\u0011\u0005Q!\rZ4f]>l\u0017nY:\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0005=A\u0011!C:dC2\fG/Z:u\u0013\t\tbB\u0001\u0005Gk:\u001cV/\u001b;f\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001C\u0004\u0019\u0001\t\u0007I\u0011A\r\u0002\u0017\rKu)\u0011*`\u0007>#UiQ\u000b\u00025A\u00111DI\u0007\u00029)\u0011QDH\u0001\tg\u0006lGo\\8mg*\u0011q\u0004I\u0001\u0003g\u001aT\u0011!I\u0001\u0004]\u0016$\u0018BA\u0012\u001d\u00059!V\r\u001f;DS\u001e\f'oQ8eK\u000eDa!\n\u0001!\u0002\u0013Q\u0012\u0001D\"J\u000f\u0006\u0013vlQ(E\u000b\u000e\u0003\u0003")
public class NormalizationUtilsSuite
extends FunSuite {
    private final TextCigarCodec CIGAR_CODEC = TextCigarCodec.getSingleton();

    public TextCigarCodec CIGAR_CODEC() {
        return this.CIGAR_CODEC;
    }

    public NormalizationUtilsSuite() {
        this.test("cannot move an indel left if there are no bases to it's left", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizationUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)NormalizationUtils$.MODULE$.numberOfPositionsToShiftIndel("ATC", ""))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("move a simple indel to farthest position left until bases run out", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizationUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)NormalizationUtils$.MODULE$.numberOfPositionsToShiftIndel("AAA", "AA"))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("move a simple indel to farthest position left, past length of indel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizationUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)NormalizationUtils$.MODULE$.numberOfPositionsToShiftIndel("AAA", "TGAAAA"))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)4)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("cannot move a left normalized indel in a short tandem repeat", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizationUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)NormalizationUtils$.MODULE$.numberOfPositionsToShiftIndel("ATAT", "TGTCC"))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("move an indel in a short tandem repeat", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizationUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)NormalizationUtils$.MODULE$.numberOfPositionsToShiftIndel("ATAT", "TGTCCATATATAT"))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)8)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("move an indel in a short tandem repeat of more than 2 bases, where shift is not an integer multiple of repeated sequence length", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizationUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)NormalizationUtils$.MODULE$.numberOfPositionsToShiftIndel("ATGATG", "TGTCCTGATG"))).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)5)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("moving a simple read with single deletion that cannot shift", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizationUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RichADAMRecord read = RichADAMRecord$.MODULE$.recordToRichRecord(ADAMRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setSequence((CharSequence)"AAAAACCCCCGGGGGTTTTT").setStart(Predef$.MODULE$.long2Long(0L)).setCigar((CharSequence)"10M10D10M").setMismatchingPositions((CharSequence)"10^ATATATATAT10").build());
                Cigar new_cigar = NormalizationUtils$.MODULE$.leftAlignIndel(RichADAMRecord$.MODULE$.richRecordToRecord(read));
                Predef$.MODULE$.println((Object)new_cigar);
                String string = new_cigar.toString();
                this.$outer.assert(!(string != null ? !string.equals("10M10D10M") : "10M10D10M" != null));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)RichADAMRecord$.MODULE$.apply(RichADAMRecord$.MODULE$.richRecordToRecord(read)).samtoolsCigar().getReadLength())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)new_cigar.getReadLength())));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shift an indel left by 0 in a cigar", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizationUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Cigar cigar = this.$outer.CIGAR_CODEC().decode("10M10D10M");
                this.$outer.assert(this.$outer.convertToEqualizer(cigar).$eq$eq$eq((Object)NormalizationUtils$.MODULE$.shiftIndel(cigar, 1, 0)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shift an indel left by 1 in a cigar", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizationUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Cigar cigar = this.$outer.CIGAR_CODEC().decode("10M10D10M");
                Cigar newCigar = NormalizationUtils$.MODULE$.shiftIndel(cigar, 1, 1);
                String string = newCigar.toString();
                this.$outer.assert(!(string != null ? !string.equals("9M10D11M") : "9M10D11M" != null));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("do not left align a complex read which is already left aligned", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizationUtilsSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMRecord read = ADAMRecord.newBuilder().setSequence((CharSequence)"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA").setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setCigar((CharSequence)"29M10D31M").setStart(Predef$.MODULE$.long2Long(5L)).setMismatchingPositions((CharSequence)"29^GGGGGGGGGG10G0G0G0G0G0G0G0G0G0G11").build();
                Cigar cigar = NormalizationUtils$.MODULE$.leftAlignIndel(read);
                this.$outer.assert(this.$outer.convertToEqualizer(cigar.toString()).$eq$eq$eq((Object)"29M10D31M"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

