/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.algorithms.realignmenttarget;

import org.bdgenomics.adam.algorithms.realignmenttarget.IndelRange;
import org.bdgenomics.adam.algorithms.realignmenttarget.IndelRealignmentTarget;
import org.bdgenomics.adam.algorithms.realignmenttarget.SNPRange;
import org.bdgenomics.adam.avro.ADAMPileup;
import org.bdgenomics.adam.avro.Base;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Set;
import scala.math.Integral;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;

public final class IndelRealignmentTarget$ {
    public static final IndelRealignmentTarget$ MODULE$;
    private final double mismatchThreshold;

    static {
        new IndelRealignmentTarget$();
    }

    public double mismatchThreshold() {
        return this.mismatchThreshold;
    }

    public IndelRealignmentTarget apply(Seq<ADAMPileup> rod) {
        Seq<ADAMPileup> indels = this.extractIndels(rod);
        Seq<ADAMPileup> matches = this.extractMatches(rod);
        Seq<ADAMPileup> mismatches = this.extractMismatches(rod);
        int matchQuality = matches.size() > 0 ? Predef$.MODULE$.Integer2int((Integer)((TraversableOnce)matches.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Integer apply(ADAMPileup x$1) {
                return x$1.getSangerQuality();
            }
        }, Seq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Integer apply(Integer x$2, Integer x$3) {
                return Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(x$2) + Predef$.MODULE$.Integer2int(x$3));
            }
        })) : 0;
        int mismatchQuality = mismatches.size() > 0 ? Predef$.MODULE$.Integer2int((Integer)((TraversableOnce)mismatches.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Integer apply(ADAMPileup x$4) {
                return x$4.getSangerQuality();
            }
        }, Seq$.MODULE$.canBuildFrom())).reduce((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Integer apply(Integer x$5, Integer x$6) {
                return Predef$.MODULE$.int2Integer(Predef$.MODULE$.Integer2int(x$5) + Predef$.MODULE$.Integer2int(x$6));
            }
        })) : 0;
        return matchQuality == 0 || (double)mismatchQuality / (double)matchQuality >= this.mismatchThreshold() ? new IndelRealignmentTarget((Set<IndelRange>)((Set)new HashSet().union((GenSet)((TraversableOnce)indels.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final IndelRange apply(ADAMPileup pileup) {
                return IndelRealignmentTarget$.MODULE$.org$bdgenomics$adam$algorithms$realignmenttarget$IndelRealignmentTarget$$mapEvent$1(pileup);
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet())), (Set<SNPRange>)((Set)new HashSet().union((GenSet)((TraversableOnce)mismatches.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SNPRange apply(ADAMPileup pileup) {
                return IndelRealignmentTarget$.MODULE$.org$bdgenomics$adam$algorithms$realignmenttarget$IndelRealignmentTarget$$mapPoint$1(pileup);
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet()))) : new IndelRealignmentTarget((Set<IndelRange>)((Set)new HashSet().union((GenSet)((TraversableOnce)indels.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final IndelRange apply(ADAMPileup pileup) {
                return IndelRealignmentTarget$.MODULE$.org$bdgenomics$adam$algorithms$realignmenttarget$IndelRealignmentTarget$$mapEvent$1(pileup);
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet())), (Set<SNPRange>)((Set)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    public Seq<ADAMPileup> extractMismatches(Seq<ADAMPileup> rod) {
        return (Seq)((TraversableLike)rod.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(ADAMPileup r) {
                if (r.getRangeOffset() != null) return false;
                Integer n = BoxesRunTime.boxToInteger((int)0);
                Integer n2 = r.getNumSoftClipped();
                if (n2 == n) return true;
                if (n2 == null) return false;
                boolean bl = !(n2 instanceof Number) ? (!(n2 instanceof Character) ? ((Object)n2).equals(n) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)n2)), (Object)n)) : BoxesRunTime.equalsNumObject((Number)n2, (Object)n);
                if (!bl) return false;
                return true;
            }
        })).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ADAMPileup r) {
                Base base = r.getReadBase();
                Base base2 = r.getReferenceBase();
                return base != null ? !base.equals(base2) : base2 != null;
            }
        });
    }

    public Seq<ADAMPileup> extractMatches(Seq<ADAMPileup> rod) {
        return (Seq)((TraversableLike)rod.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(ADAMPileup r) {
                if (r.getRangeOffset() != null) return false;
                Integer n = BoxesRunTime.boxToInteger((int)0);
                Integer n2 = r.getNumSoftClipped();
                if (n2 == n) return true;
                if (n2 == null) return false;
                boolean bl = !(n2 instanceof Number) ? (!(n2 instanceof Character) ? ((Object)n2).equals(n) : BoxesRunTime.equalsCharObject((Character)((Character)((Object)n2)), (Object)n)) : BoxesRunTime.equalsNumObject((Number)n2, (Object)n);
                if (!bl) return false;
                return true;
            }
        })).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ADAMPileup r) {
                Base base = r.getReadBase();
                Base base2 = r.getReferenceBase();
                return !(base != null ? !base.equals(base2) : base2 != null);
            }
        });
    }

    public Seq<ADAMPileup> extractIndels(Seq<ADAMPileup> rod) {
        return (Seq)rod.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ADAMPileup x$7) {
                return x$7.getRangeOffset() != null;
            }
        });
    }

    public IndelRealignmentTarget emptyTarget() {
        return new IndelRealignmentTarget((Set<IndelRange>)new HashSet(), (Set<SNPRange>)new HashSet());
    }

    public final IndelRange org$bdgenomics$adam$algorithms$realignmenttarget$IndelRealignmentTarget$$mapEvent$1(ADAMPileup pileup) {
        Option option;
        block4: {
            IndelRange indelRange;
            block3: {
                block2: {
                    option = Option$.MODULE$.apply((Object)pileup.getReadBase());
                    None$ none$ = None$.MODULE$;
                    if (none$ != null ? !none$.equals(option) : option != null) break block2;
                    indelRange = new IndelRange((NumericRange<Object>)new NumericRange.Inclusive((Object)BoxesRunTime.boxToLong((long)(Predef$.MODULE$.Long2long(pileup.getPosition()) - (long)Predef$.MODULE$.Integer2int(pileup.getRangeOffset()))), (Object)BoxesRunTime.boxToLong((long)(Predef$.MODULE$.Long2long(pileup.getPosition()) + (long)Predef$.MODULE$.Integer2int(pileup.getRangeLength()) - (long)Predef$.MODULE$.Integer2int(pileup.getRangeOffset()) - 1L)), (Object)BoxesRunTime.boxToLong((long)1L), (Integral)Numeric.LongIsIntegral$.MODULE$), (NumericRange<Object>)new NumericRange.Inclusive((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(pileup.getReadStart())), (Object)BoxesRunTime.boxToLong((long)(Predef$.MODULE$.Long2long(pileup.getReadEnd()) - 1L)), (Object)BoxesRunTime.boxToLong((long)1L), (Integral)Numeric.LongIsIntegral$.MODULE$));
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                indelRange = new IndelRange((NumericRange<Object>)new NumericRange.Inclusive((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(pileup.getPosition())), (Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(pileup.getPosition())), (Object)BoxesRunTime.boxToLong((long)1L), (Integral)Numeric.LongIsIntegral$.MODULE$), (NumericRange<Object>)new NumericRange.Inclusive((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(pileup.getReadStart())), (Object)BoxesRunTime.boxToLong((long)(Predef$.MODULE$.Long2long(pileup.getReadEnd()) - 1L)), (Object)BoxesRunTime.boxToLong((long)1L), (Integral)Numeric.LongIsIntegral$.MODULE$));
            }
            return indelRange;
        }
        throw new MatchError((Object)option);
    }

    public final SNPRange org$bdgenomics$adam$algorithms$realignmenttarget$IndelRealignmentTarget$$mapPoint$1(ADAMPileup pileup) {
        NumericRange.Inclusive range = new NumericRange.Inclusive((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(pileup.getReadStart())), (Object)BoxesRunTime.boxToLong((long)(Predef$.MODULE$.Long2long(pileup.getReadEnd()) - 1L)), (Object)BoxesRunTime.boxToLong((long)1L), (Integral)Numeric.LongIsIntegral$.MODULE$);
        return new SNPRange(Predef$.MODULE$.Long2long(pileup.getPosition()), (NumericRange<Object>)range);
    }

    private IndelRealignmentTarget$() {
        MODULE$ = this;
        this.mismatchThreshold = 0.15;
    }
}

