/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.converters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bdgenomics.adam.avro.ADAMContig;
import org.bdgenomics.adam.avro.ADAMDatabaseVariantAnnotation;
import org.bdgenomics.adam.avro.ADAMGenotype;
import org.bdgenomics.adam.avro.ADAMGenotypeAllele;
import org.bdgenomics.adam.avro.ADAMVariant;
import org.bdgenomics.adam.avro.VariantCallingAnnotations;
import org.bdgenomics.adam.converters.VariantAnnotationConverter$;
import org.bdgenomics.adam.converters.VariantContextConverter$;
import org.bdgenomics.adam.models.ADAMVariantContext;
import org.bdgenomics.adam.models.ADAMVariantContext$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.rich.RichADAMVariant;
import org.bdgenomics.adam.rich.RichADAMVariant$;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005%u!B\u0001\u0003\u0011\u0003Y\u0011a\u0006,be&\fg\u000e^\"p]R,\u0007\u0010^\"p]Z,'\u000f^3s\u0015\t\u0019A!\u0001\u0006d_:4XM\u001d;feNT!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!a\u0006,be&\fg\u000e^\"p]R,\u0007\u0010^\"p]Z,'\u000f^3s'\ri\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005E9\u0012B\u0001\r\u0013\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015QR\u0002\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\t1\u0002C\u0003\u001e\u001b\u0011%a$A\u0007d_:4XM\u001d;BY2,G.\u001a\u000b\u0003?\u0015\u0002\"\u0001I\u0012\u000e\u0003\u0005R!A\t\u0003\u0002\t\u00054(o\\\u0005\u0003I\u0005\u0012!#\u0011#B\u001b\u001e+gn\u001c;za\u0016\fE\u000e\\3mK\")a\u0005\ba\u0001O\u00051\u0011\r\u001c7fY\u0016\u0004\"\u0001K\u0018\u000e\u0003%R!AK\u0016\u0002\u001dY\f'/[1oi\u000e|g\u000e^3yi*\u0011A&L\u0001\bm\u0006\u0014\u0018.\u00198u\u0015\tq\u0003\"\u0001\bce>\fG-\u001b8ti&$X\u000f^3\n\u0005AJ#AB!mY\u0016dW\rC\u0003\u001e\u001b\u0011%!\u0007F\u00024\u007f!\u00032\u0001\u000e\u001f(\u001d\t)$H\u0004\u00027s5\tqG\u0003\u00029\u0015\u00051AH]8pizJ\u0011aE\u0005\u0003wI\tq\u0001]1dW\u0006<W-\u0003\u0002>}\t\u00191+Z9\u000b\u0005m\u0012\u0002\"\u0002\u00142\u0001\u0004\u0001\u0005CA!G\u001b\u0005\u0011%BA\"E\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\u000bAA[1wC&\u0011qI\u0011\u0002\r\u0007\"\f'oU3rk\u0016t7-\u001a\u0005\b\u0013F\u0002\n\u00111\u0001K\u0003\u0015I7OU3g!\t\t2*\u0003\u0002M%\t9!i\\8mK\u0006t\u0007\"\u0002(\u000e\t\u0013y\u0015AD2p]Z,'\u000f^!mY\u0016dWm\u001d\u000b\u0003!Z\u00032!\u0015+(\u001b\u0005\u0011&BA*E\u0003\u0011)H/\u001b7\n\u0005U\u0013&AC\"pY2,7\r^5p]\")q+\u0014a\u00011\u0006\ta\u000f\u0005\u0002!3&\u0011!,\t\u0002\f\u0003\u0012\u000bUJV1sS\u0006tG\u000fC\u0003O\u001b\u0011%A\f\u0006\u0002^AB\u0019\u0011KX\u0014\n\u0005}\u0013&\u0001\u0002'jgRDQ!Y.A\u0002\t\f\u0011a\u001a\t\u0003A\rL!\u0001Z\u0011\u0003\u0019\u0005#\u0015)T$f]>$\u0018\u0010]3\t\u000f\u0019l\u0011\u0013!C\u0001O\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE*\u0012\u0001\u001b\u0016\u0003SJ\u00042!\u00056m\u0013\tY'C\u0001\u0004PaRLwN\u001c\t\u0003[Bl\u0011A\u001c\u0006\u0003_\u0012\ta!\\8eK2\u001c\u0018BA9o\u0005I\u0019V-];f]\u000e,G)[2uS>t\u0017M]=,\u0003M\u0004\"\u0001^=\u000e\u0003UT!A^<\u0002\u0013Ut7\r[3dW\u0016$'B\u0001=\u0013\u0003)\tgN\\8uCRLwN\\\u0005\u0003uV\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011\u001daX\"%A\u0005\nu\fqcY8om\u0016\u0014H/\u00117mK2,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0003yT#A\u0013:\t\u0013\u0005\u0005Q\"!A\u0005\n\u0005\r\u0011a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!\u0002\u0011\u0007\u0005\u000b9!C\u0002\u0002\n\t\u0013aa\u00142kK\u000e$h!\u0002\b\u0003\u0001\u000551\u0003BA\u0006!YA!\"!\u0005\u0002\f\t\u0005\t\u0015!\u0003j\u0003\u0011!\u0017n\u0019;\t\u000fi\tY\u0001\"\u0001\u0002\u0016Q!\u0011qCA\r!\ra\u00111\u0002\u0005\n\u0003#\t\u0019\u0002%AA\u0002%D\u0001\"!\b\u0002\f\u0011\r\u0011qD\u0001\u0019O\u0006$8.\u00117mK2,7\u000fV8B\t\u0006k\u0015\t\u001c7fY\u0016\u001cH\u0003BA\u0011\u0003G\u00012!\u00150 \u0011\u001d\t)#a\u0007A\u0002u\u000b1bZ1uW\u0006cG.\u001a7fg\"A\u0011\u0011FA\u0006\t\u0003\tY#A\u0004d_:4XM\u001d;\u0015\r\u00055\u0012QGA !\u0011!D(a\f\u0011\u00075\f\t$C\u0002\u000249\u0014!#\u0011#B\u001bZ\u000b'/[1oi\u000e{g\u000e^3yi\"A\u0011qGA\u0014\u0001\u0004\tI$\u0001\u0002wGB\u0019\u0001&a\u000f\n\u0007\u0005u\u0012F\u0001\bWCJL\u0017M\u001c;D_:$X\r\u001f;\t\u0013\u0005\u0005\u0013q\u0005I\u0001\u0002\u0004Q\u0015AG3yiJ\f7\r^#yi\u0016\u0014h.\u00197B]:|G/\u0019;j_:\u001c\b\u0002CA#\u0003\u0017!\t!a\u0012\u0002'\r|gN^3siR{\u0017I\u001c8pi\u0006$\u0018n\u001c8\u0015\t\u0005%\u0013q\n\t\u0004A\u0005-\u0013bAA'C\ti\u0012\tR!N\t\u0006$\u0018MY1tKZ\u000b'/[1oi\u0006sgn\u001c;bi&|g\u000e\u0003\u0005\u00028\u0005\r\u0003\u0019AA\u001d\u0011!\t\u0019&a\u0003\u0005\n\u0005U\u0013!E2sK\u0006$X-\u0011#B\u001bZ\u000b'/[1oiR\u0019\u0001,a\u0016\t\u0011\u0005]\u0012\u0011\u000ba\u0001\u0003sA\u0001\"a\u0017\u0002\f\u0011%\u0011QL\u0001!Kb$(/Y2u-\u0006\u0014\u0018.\u00198u\t\u0006$\u0018MY1tK\u0006sgn\u001c;bi&|g\u000e\u0006\u0004\u0002J\u0005}\u0013\u0011\r\u0005\u0007Y\u0005e\u0003\u0019\u0001-\t\u0011\u0005]\u0012\u0011\fa\u0001\u0003sA\u0001\"!\u001a\u0002\f\u0011%\u0011qM\u0001\u0011Kb$(/Y2u\u000f\u0016tw\u000e^=qKN$b!!\u001b\u0002l\u00055\u0004c\u0001\u001b=E\"A\u0011qGA2\u0001\u0004\tI\u0004C\u0004\u0002p\u0005\r\u0004\u0019\u00012\u0002\u001dMD\u0017M]3e\u000f\u0016tw\u000e^=qK\"A\u00111OA\u0006\t\u0013\t)(\u0001\u0011fqR\u0014\u0018m\u0019;WCJL\u0017M\u001c;DC2d\u0017N\\4B]:|G/\u0019;j_:\u001cH\u0003BA<\u0003{\u00022\u0001IA=\u0013\r\tY(\t\u0002\u001a-\u0006\u0014\u0018.\u00198u\u0007\u0006dG.\u001b8h\u0003:tw\u000e^1uS>t7\u000f\u0003\u0005\u00028\u0005E\u0004\u0019AA\u001d\u0011!\tI#a\u0003\u0005\u0002\u0005\u0005E\u0003BA\u001d\u0003\u0007C\u0001\"a\u000e\u0002\u0000\u0001\u0007\u0011q\u0006\u0005\n\u0003\u000f\u000bY!%A\u0005\u0002u\f\u0011cY8om\u0016\u0014H\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0001")
public class VariantContextConverter
implements Serializable {
    private final Option<SequenceDictionary> dict;

    public static Option<SequenceDictionary> $lessinit$greater$default$1() {
        return VariantContextConverter$.MODULE$.$lessinit$greater$default$1();
    }

    public List<ADAMGenotypeAllele> gatkAllelesToADAMAlleles(List<Allele> gatkAlleles) {
        return JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(gatkAlleles).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ADAMGenotypeAllele apply(Allele x$1) {
                return VariantContextConverter$.MODULE$.org$bdgenomics$adam$converters$VariantContextConverter$$convertAllele(x$1);
            }
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    public Seq<ADAMVariantContext> convert(VariantContext vc, boolean extractExternalAnnotations) {
        if (vc.isBiallelic()) {
            ADAMVariant variant = this.createADAMVariant(vc);
            ADAMGenotype.Builder sharedGenotypeBuilder = ADAMGenotype.newBuilder().setVariant(variant);
            sharedGenotypeBuilder.setVariantCallingAnnotations(this.extractVariantCallingAnnotations(vc));
            ADAMGenotype sharedGenotype = sharedGenotypeBuilder.build();
            Seq<ADAMGenotype> genotypes = this.extractGenotypes(vc, sharedGenotype);
            None$ annotation = extractExternalAnnotations ? new Some((Object)this.extractVariantDatabaseAnnotation(variant, vc)) : None$.MODULE$;
            return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ADAMVariantContext[]{ADAMVariantContext$.MODULE$.apply(variant, genotypes, (Option<ADAMDatabaseVariantAnnotation>)annotation)}));
        }
        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public ADAMDatabaseVariantAnnotation convertToAnnotation(VariantContext vc) {
        ADAMVariant variant = this.createADAMVariant(vc);
        return this.extractVariantDatabaseAnnotation(variant, vc);
    }

    private ADAMVariant createADAMVariant(VariantContext vc) {
        BoxedUnit boxedUnit;
        int contigId = 0;
        try {
            String string = vc.getID();
            Predef$ predef$ = Predef$.MODULE$;
            contigId = new StringOps(string).toInt();
        }
        catch (NumberFormatException numberFormatException) {}
        ADAMContig.Builder contig = ADAMContig.newBuilder().setContigName((CharSequence)vc.getChr()).setContigId(Predef$.MODULE$.int2Integer(contigId));
        if (this.dict.isDefined()) {
            SequenceRecord sr = ((SequenceDictionary)this.dict.get()).apply(vc.getChr());
            boxedUnit = contig.setContigLength(Predef$.MODULE$.long2Long(sr.length())).setReferenceURL(sr.url()).setContigMD5(sr.md5());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return ADAMVariant.newBuilder().setContig(contig.build()).setPosition(Predef$.MODULE$.long2Long((long)(vc.getStart() - 1))).setReferenceAllele((CharSequence)vc.getReference().getBaseString()).setVariantAllele((CharSequence)vc.getAlternateAllele(0).getBaseString()).build();
    }

    private ADAMDatabaseVariantAnnotation extractVariantDatabaseAnnotation(ADAMVariant variant, VariantContext vc) {
        ADAMDatabaseVariantAnnotation annotation = ADAMDatabaseVariantAnnotation.newBuilder().setVariant(variant).build();
        return VariantAnnotationConverter$.MODULE$.convert(vc, annotation);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<ADAMGenotype> extractGenotypes(VariantContext vc, ADAMGenotype sharedGenotype) {
        void var3_3;
        Seq genotypes = ((SeqLike)JavaConversions$.MODULE$.asScalaBuffer((List)vc.getGenotypes()).map((Function1)new Serializable(this, sharedGenotype){
            public static final long serialVersionUID = 0L;
            private final ADAMGenotype sharedGenotype$1;

            public final ADAMGenotype apply(Genotype g) {
                BoxedUnit boxedUnit;
                ADAMGenotype.Builder genotype = ADAMGenotype.newBuilder((ADAMGenotype)this.sharedGenotype$1).setSampleId((CharSequence)g.getSampleName()).setAlleles(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(g.getAlleles()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final ADAMGenotypeAllele apply(Allele x$2) {
                        return VariantContextConverter$.MODULE$.org$bdgenomics$adam$converters$VariantContextConverter$$convertAllele(x$2);
                    }
                }, Buffer$.MODULE$.canBuildFrom()))).setIsPhased(Predef$.MODULE$.boolean2Boolean(g.isPhased()));
                Object object = g.hasGQ() ? genotype.setGenotypeQuality(Predef$.MODULE$.int2Integer(g.getGQ())) : BoxedUnit.UNIT;
                Object object2 = g.hasDP() ? genotype.setReadDepth(Predef$.MODULE$.int2Integer(g.getDP())) : BoxedUnit.UNIT;
                if (g.hasAD()) {
                    int[] ad = g.getAD();
                    boolean bl = ad.length == 2;
                    Predef$ predef$ = Predef$.MODULE$;
                    if (!bl) {
                        throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)"Unexpected number of allele depths for bi-allelic variant").toString());
                    }
                    boxedUnit = genotype.setReferenceReadDepth(Predef$.MODULE$.int2Integer(ad[0])).setAlternateReadDepth(Predef$.MODULE$.int2Integer(ad[1]));
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Object object3 = g.hasPL() ? genotype.setGenotypeLikelihoods(JavaConversions$.MODULE$.seqAsJavaList((Seq)Predef$.MODULE$.intArrayOps(g.getPL()).toList().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Integer apply(int p) {
                        return Predef$.MODULE$.int2Integer(p);
                    }
                }, List$.MODULE$.canBuildFrom()))) : BoxedUnit.UNIT;
                ADAMGenotype builtGenotype = genotype.build();
                VariantAnnotationConverter$.MODULE$.VCF2GTAnnotations().withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, Tuple2<Object, Function1<Object, Object>>> check$ifrefutable$1) {
                        boolean bl = check$ifrefutable$1 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this, g, builtGenotype){
                    public static final long serialVersionUID = 0L;
                    private final Genotype g$2;
                    private final ADAMGenotype builtGenotype$1;

                    public final void apply(Tuple2<String, Tuple2<Object, Function1<Object, Object>>> x$3) {
                        if (x$3 != null) {
                            Object attr = this.g$2.getExtendedAttribute((String)x$3._1());
                            if (attr != null) {
                                Object object = attr;
                                if (object == null ? "." != null : !object.equals(".")) {
                                    this.builtGenotype$1.put(((Tuple2)x$3._2())._1$mcI$sp(), ((Function1)((Tuple2)x$3._2())._2()).apply(attr));
                                }
                            }
                            return;
                        }
                        throw new MatchError(x$3);
                    }
                    {
                        this.g$2 = g$2;
                        this.builtGenotype$1 = builtGenotype$1;
                    }
                });
                return builtGenotype;
            }
            {
                this.sharedGenotype$1 = sharedGenotype$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSeq();
        return var3_3;
    }

    private VariantCallingAnnotations extractVariantCallingAnnotations(VariantContext vc) {
        VariantCallingAnnotations.Builder call = VariantCallingAnnotations.newBuilder();
        Object object = vc.hasLog10PError() ? call.setVariantCallErrorProbability(Predef$.MODULE$.float2Float((float)vc.getPhredScaledQual())) : BoxedUnit.UNIT;
        VariantCallingAnnotations.Builder builder = vc.isFiltered() ? call.setVariantIsPassing(Predef$.MODULE$.boolean2Boolean(vc.isFiltered()) == false).setVariantFilters(new ArrayList(vc.getFilters())) : call.setVariantIsPassing(true);
        return VariantAnnotationConverter$.MODULE$.convert(vc, call.build());
    }

    public VariantContext convert(ADAMVariantContext vc) {
        None$ none$;
        None$ none$2;
        RichADAMVariant richADAMVariant = vc.variant();
        RichADAMVariant$ richADAMVariant$ = RichADAMVariant$.MODULE$;
        ADAMVariant variant = richADAMVariant.variant();
        Long l = variant.getPosition();
        Predef$ predef$ = Predef$.MODULE$;
        Long l2 = variant.getPosition();
        Predef$ predef$2 = Predef$.MODULE$;
        VariantContextBuilder vcb = new VariantContextBuilder().chr(((Object)variant.getContig().getContigName()).toString()).start(l + 1L).stop(l2 + 1L + (long)variant.getReferenceAllele().length() - 1L).alleles(VariantContextConverter$.MODULE$.org$bdgenomics$adam$converters$VariantContextConverter$$convertAlleles(variant));
        Option<ADAMDatabaseVariantAnnotation> option = vc.databases();
        if (!option.isEmpty()) {
            ADAMDatabaseVariantAnnotation aDAMDatabaseVariantAnnotation = (ADAMDatabaseVariantAnnotation)option.get();
            none$2 = Option$.MODULE$.apply((Object)aDAMDatabaseVariantAnnotation.getDbSnpId());
        } else {
            none$2 = none$ = None$.MODULE$;
        }
        if (!none$2.isEmpty()) {
            Integer n = (Integer)none$.get();
            vcb.id(new StringBuilder().append((Object)"rs").append((Object)n).toString());
        }
        vcb.genotypes((Collection)JavaConversions$.MODULE$.seqAsJavaList((Seq)vc.genotypes().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Genotype apply(ADAMGenotype g) {
                VariantCallingAnnotations callAnnotations;
                Option option;
                Option option2;
                GenotypeBuilder gb = new GenotypeBuilder(((Object)g.getSampleId()).toString(), VariantContextConverter$.MODULE$.org$bdgenomics$adam$converters$VariantContextConverter$$convertAlleles(g));
                Option option3 = Option$.MODULE$.apply((Object)g.getIsPhased());
                if (!option3.isEmpty()) {
                    Boolean bl = (Boolean)option3.get();
                    gb.phased(Predef$.MODULE$.Boolean2boolean(bl));
                }
                if (!(option2 = Option$.MODULE$.apply((Object)g.getGenotypeQuality())).isEmpty()) {
                    Integer n = (Integer)option2.get();
                    gb.GQ(Predef$.MODULE$.Integer2int(n));
                }
                if (!(option = Option$.MODULE$.apply((Object)g.getReadDepth())).isEmpty()) {
                    Integer n = (Integer)option.get();
                    gb.DP(Predef$.MODULE$.Integer2int(n));
                }
                Object object = g.getReferenceReadDepth() == null || g.getAlternateReadDepth() == null ? BoxedUnit.UNIT : gb.AD((int[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{Predef$.MODULE$.Integer2int(g.getReferenceReadDepth()), Predef$.MODULE$.Integer2int(g.getAlternateReadDepth())}), ClassTag$.MODULE$.Int()));
                Object object2 = g.getVariantCallingAnnotations() == null ? BoxedUnit.UNIT : ((callAnnotations = g.getVariantCallingAnnotations()).getVariantFilters() == null ? BoxedUnit.UNIT : gb.filters(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(callAnnotations.getVariantFilters()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(CharSequence x$7) {
                        return ((Object)x$7).toString();
                    }
                }, Buffer$.MODULE$.canBuildFrom()))));
                Object object3 = JavaConversions$.MODULE$.asScalaBuffer(g.getGenotypeLikelihoods()).nonEmpty() ? gb.PL((int[])((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(g.getGenotypeLikelihoods()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Integer p) {
                        return Predef$.MODULE$.Integer2int(p);
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int())) : BoxedUnit.UNIT;
                return gb.make();
            }
        }, Seq$.MODULE$.canBuildFrom())));
        return vcb.make();
    }

    public boolean convert$default$2() {
        return false;
    }

    public VariantContextConverter(Option<SequenceDictionary> dict) {
        this.dict = dict;
    }
}

