/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import fi.tkk.ics.hadoop.bam.AnySAMInputFormat;
import fi.tkk.ics.hadoop.bam.SAMRecordWritable;
import fi.tkk.ics.hadoop.bam.util.SAMHeaderReader;
import java.util.Collection;
import java.util.regex.Pattern;
import net.sf.samtools.SAMFileHeader;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.avro.ADAMNucleotideContigFragment;
import org.bdgenomics.adam.avro.ADAMPileup;
import org.bdgenomics.adam.avro.ADAMRecord;
import org.bdgenomics.adam.converters.SAMRecordConverter;
import org.bdgenomics.adam.models.ADAMRod;
import org.bdgenomics.adam.models.RecordGroupDictionary;
import org.bdgenomics.adam.models.RecordGroupDictionary$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceDictionary$;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.projections.ADAMNucleotideContigFragmentField$;
import org.bdgenomics.adam.projections.ADAMRecordField$;
import org.bdgenomics.adam.projections.FieldValue;
import org.bdgenomics.adam.projections.Projection$;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMNucleotideContigFragmentRDDFunctions;
import org.bdgenomics.adam.rdd.ADAMPileupRDDFunctions;
import org.bdgenomics.adam.rdd.ADAMRDDFunctions;
import org.bdgenomics.adam.rdd.ADAMRecordRDDFunctions;
import org.bdgenomics.adam.rdd.ADAMRodRDDFunctions;
import org.bdgenomics.adam.rich.RichADAMRecord;
import org.bdgenomics.adam.rich.RichRDDReferenceRecords$;
import org.slf4j.Logger;
import parquet.avro.AvroParquetInputFormat;
import parquet.avro.AvroReadSupport;
import parquet.filter.UnboundRecordFilter;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.util.ContextUtil;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r=w!B\u0001\u0003\u0011\u0003Y\u0011aC!E\u00036\u001buN\u001c;fqRT!a\u0001\u0003\u0002\u0007I$GM\u0003\u0002\u0006\r\u0005!\u0011\rZ1n\u0015\t9\u0001\"\u0001\u0006cI\u001e,gn\\7jGNT\u0011!C\u0001\u0004_J<7\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\f\u0003\u0012\u000bUjQ8oi\u0016DHoE\u0002\u000e!Y\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\t\u0018\u0013\tA\"C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u001b\u001b\u0011\u00051$\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017!)Q$\u0004C\u0002=\u0005I2\u000f]1sW\u000e{g\u000e^3yiR{\u0017\tR!N\u0007>tG/\u001a=u)\ry\"1\u0004\t\u0003\u0019\u00012AA\u0004\u0002\u0001CM!\u0001\u0005\u0005\f#!\t\u0019\u0003&D\u0001%\u0015\t)c%A\u0003ta\u0006\u00148N\u0003\u0002(\u0011\u00051\u0011\r]1dQ\u0016L!!\u000b\u0013\u0003\u000f1{wmZ5oO\"A1\u0006\tB\u0001B\u0003%A&\u0001\u0002tGB\u00111%L\u0005\u0003]\u0011\u0012Ab\u00159be.\u001cuN\u001c;fqRDQA\u0007\u0011\u0005\u0002A\"\"aH\u0019\t\u000b-z\u0003\u0019\u0001\u0017\t\u000bM\u0002C\u0011\u0002\u001b\u0002+\u0005$\u0017-\u001c\"b[\u0012K7\r^5p]\u0006\u0014\u0018\u0010T8bIR\u0011Qg\u000f\t\u0003mej\u0011a\u000e\u0006\u0003q\u0011\ta!\\8eK2\u001c\u0018B\u0001\u001e8\u0005I\u0019V-];f]\u000e,G)[2uS>t\u0017M]=\t\u000bq\u0012\u0004\u0019A\u001f\u0002\u0011\u0019LG.\u001a)bi\"\u0004\"AP!\u000f\u0005Ey\u0014B\u0001!\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011!i\u0011\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001\u0013\u0002\"B\u001a!\t\u0013)ECA\u001bG\u0011\u00159E\t1\u0001I\u0003%\u0019\u0018-\u001c%fC\u0012,'\u000f\u0005\u0002J!6\t!J\u0003\u0002L\u0019\u0006A1/Y7u_>d7O\u0003\u0002N\u001d\u0006\u00111O\u001a\u0006\u0002\u001f\u0006\u0019a.\u001a;\n\u0005ES%!D*B\u001b\u001aKG.\u001a%fC\u0012,'\u000fC\u0003TA\u0011%A+A\u000bbI\u0006l')Y7M_\u0006$'+Z1e\u000fJ|W\u000f]:\u0015\u0005UC\u0006C\u0001\u001cW\u0013\t9vGA\u000bSK\u000e|'\u000fZ$s_V\u0004H)[2uS>t\u0017M]=\t\u000b\u001d\u0013\u0006\u0019\u0001%\t\u000bi\u0003C\u0011B.\u0002\u0017\u0005$\u0017-\u001c\"b[2{\u0017\r\u001a\u000b\u00039\u001e\u00042!X0b\u001b\u0005q&BA\u0002%\u0013\t\u0001gLA\u0002S\t\u0012\u0003\"AY3\u000e\u0003\rT!\u0001\u001a\u0003\u0002\t\u00054(o\\\u0005\u0003M\u000e\u0014!\"\u0011#B\u001bJ+7m\u001c:e\u0011\u0015a\u0014\f1\u0001>\u0011\u0015I\u0007\u0005\"\u0003k\u0003=\tG-Y7QCJ\fX/\u001a;M_\u0006$W\u0003B6q\u0003S!r\u0001\\A\u000b\u0003/\ty\u0004\u0006\u0003ns\u0006-\u0001cA/`]B\u0011q\u000e\u001d\u0007\u0001\t\u0015\t\bN1\u0001s\u0005\u0005!\u0016CA:w!\t\tB/\u0003\u0002v%\t9aj\u001c;iS:<\u0007CA\tx\u0013\tA(CA\u0002B]fDqA\u001f5\u0002\u0002\u0003\u000f10\u0001\u0006fm&$WM\\2fIM\u0002B!\u0005?o}&\u0011QP\u0005\u0002\n\rVt7\r^5p]F\u00022a`A\u0004\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011\u0001C:qK\u000eLg-[2\u000b\u0005\u00114\u0013\u0002BA\u0005\u0003\u0003\u0011ab\u00159fG&4\u0017n\u0019*fG>\u0014H\rC\u0005\u0002\u000e!\f\t\u0011q\u0001\u0002\u0010\u0005QQM^5eK:\u001cW\r\n\u001b\u0011\ty\n\tB\\\u0005\u0004\u0003'\u0019%\u0001C'b]&4Wm\u001d;\t\u000bqB\u0007\u0019A\u001f\t\u0013\u0005e\u0001\u000e%AA\u0002\u0005m\u0011!\u00039sK\u0012L7-\u0019;f!\u0015\t\u0012QDA\u0011\u0013\r\tyB\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000by\n\u0019#a\n\n\u0007\u0005\u00152IA\u0003DY\u0006\u001c8\u000fE\u0002p\u0003S!q!a\u000bi\u0005\u0004\tiCA\u0001V#\r\u0019\u0018q\u0006\t\u0005\u0003c\tY$\u0004\u0002\u00024)!\u0011QGA\u001c\u0003\u00191\u0017\u000e\u001c;fe*\u0011\u0011\u0011H\u0001\ba\u0006\u0014\u0018/^3u\u0013\u0011\ti$a\r\u0003'Us'm\\;oIJ+7m\u001c:e\r&dG/\u001a:\t\u0013\u0005\u0005\u0003\u000e%AA\u0002\u0005\r\u0013A\u00039s_*,7\r^5p]B)\u0011#!\b\u0002FA!\u0011qIA%\u001b\t\t)!\u0003\u0003\u0002L\u0005\u0015!AB*dQ\u0016l\u0017\rC\u0004\u0002P\u0001\"\t!!\u0015\u0002%\u0005$\u0017-\u001c#jGRLwN\\1ss2{\u0017\rZ\u000b\u0005\u0003'\ny\u0006\u0006\u0003\u0002V\u0005\u001dD#B\u001b\u0002X\u0005\u0005\u0004BCA-\u0003\u001b\n\t\u0011q\u0001\u0002\\\u0005QQM^5eK:\u001cW\rJ\u001b\u0011\u000bEa\u0018Q\f@\u0011\u0007=\fy\u0006\u0002\u0004r\u0003\u001b\u0012\rA\u001d\u0005\u000b\u0003G\ni%!AA\u0004\u0005\u0015\u0014AC3wS\u0012,gnY3%mA)a(!\u0005\u0002^!1A(!\u0014A\u0002uBq!a\u001b!\t\u0003\ti'\u0001\u0005bI\u0006lGj\\1e+\u0019\ty'a\u001e\u0002\u0010RA\u0011\u0011OAC\u0003\u000f\u000b\t\n\u0006\u0004\u0002t\u0005e\u0014q\u0010\t\u0005;~\u000b)\bE\u0002p\u0003o\"a!]A5\u0005\u0004\u0011\bBCA>\u0003S\n\t\u0011q\u0001\u0002~\u0005QQM^5eK:\u001cW\rJ\u001c\u0011\u000bEa\u0018Q\u000f@\t\u0015\u0005\u0005\u0015\u0011NA\u0001\u0002\b\t\u0019)\u0001\u0006fm&$WM\\2fIa\u0002RAPA\t\u0003kBa\u0001PA5\u0001\u0004i\u0004BCA\r\u0003S\u0002\n\u00111\u0001\u0002\nB)\u0011#!\b\u0002\fB)a(a\t\u0002\u000eB\u0019q.a$\u0005\u0011\u0005-\u0012\u0011\u000eb\u0001\u0003[A!\"!\u0011\u0002jA\u0005\t\u0019AA\"\u0011\u001d\t)\n\tC\u0001\u0003/\u000b\u0011BZ5oI\u001aKG.Z:\u0015\r\u0005e\u0015\u0011YAc!\u0019\tY*a+\u00022:!\u0011QTAT\u001d\u0011\ty*!*\u000e\u0005\u0005\u0005&bAAR\u0015\u00051AH]8pizJ\u0011aE\u0005\u0004\u0003S\u0013\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003[\u000byKA\u0002TKFT1!!+\u0013!\u0011\t\u0019,!0\u000e\u0005\u0005U&\u0002BA\\\u0003s\u000b!AZ:\u000b\u0007\u0005mf%\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0003\u007f\u000b)L\u0001\u0003QCRD\u0007\u0002CAb\u0003'\u0003\r!!-\u0002\tA\fG\u000f\u001b\u0005\b\u0003\u000f\f\u0019\n1\u0001>\u0003\u0015\u0011XmZ3y\u0011\u001d\tY\r\tC\u0001\u0003\u001b\f\u0011\u0003\\8bI\u0006#\u0015)\u0014$s_6\u0004\u0016\r\u001e5t)\ra\u0016q\u001a\u0005\t\u0003#\fI\r1\u0001\u0002\u001a\u0006)\u0001/\u0019;ig\"I\u0011Q\u001b\u0011\u0012\u0002\u0013%\u0011q[\u0001\u001aC\u0012\fW\u000eU1scV,G\u000fT8bI\u0012\"WMZ1vYR$#'\u0006\u0004\u0002Z\u0006U\u0018q_\u000b\u0003\u00037TC!!8\u0002d:\u0019\u0011#a8\n\u0007\u0005\u0005(#\u0001\u0003O_:,7FAAs!\u0011\t9/!=\u000e\u0005\u0005%(\u0002BAv\u0003[\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=(#\u0001\u0006b]:|G/\u0019;j_:LA!a=\u0002j\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\rE\f\u0019N1\u0001s\t!\tY#a5C\u0002\u00055\u0002\"CA~AE\u0005I\u0011BA\u007f\u0003e\tG-Y7QCJ\fX/\u001a;M_\u0006$G\u0005Z3gCVdG\u000fJ\u001a\u0016\r\u0005}(1\u0001B\u0003+\t\u0011\tA\u000b\u0003\u0002D\u0005\rHAB9\u0002z\n\u0007!\u000f\u0002\u0005\u0002,\u0005e(\u0019AA\u0017\u0011%\u0011I\u0001II\u0001\n\u0003\u0011Y!\u0001\nbI\u0006lGj\\1eI\u0011,g-Y;mi\u0012\u0012TCBAm\u0005\u001b\u0011y\u0001\u0002\u0004r\u0005\u000f\u0011\rA\u001d\u0003\t\u0003W\u00119A1\u0001\u0002.!I!1\u0003\u0011\u0012\u0002\u0013\u0005!QC\u0001\u0013C\u0012\fW\u000eT8bI\u0012\"WMZ1vYR$3'\u0006\u0004\u0002\u0000\n]!\u0011\u0004\u0003\u0007c\nE!\u0019\u0001:\u0005\u0011\u0005-\"\u0011\u0003b\u0001\u0003[AQa\u000b\u000fA\u00021BqAa\b\u000e\t\u0007\u0011\t#\u0001\nsI\u0012$v.\u0011#B\u001bJ+7m\u001c:e%\u0012#E\u0003\u0002B\u0012\u0005S\u00012\u0001\u0004B\u0013\u0013\r\u00119C\u0001\u0002\u0017\u0003\u0012\u000bUJU3d_J$'\u000b\u0012#Gk:\u001cG/[8og\"11A!\bA\u0002qCqA!\f\u000e\t\u0007\u0011y#\u0001\nsI\u0012$v.\u0011#B\u001bBKG.Z;q%\u0012#E\u0003\u0002B\u0019\u0005o\u00012\u0001\u0004B\u001a\u0013\r\u0011)D\u0001\u0002\u0017\u0003\u0012\u000bU\nU5mKV\u0004(\u000b\u0012#Gk:\u001cG/[8og\"91Aa\u000bA\u0002\te\u0002\u0003B/`\u0005w\u00012A\u0019B\u001f\u0013\r\u0011yd\u0019\u0002\u000b\u0003\u0012\u000bU\nU5mKV\u0004\bb\u0002B\"\u001b\u0011\r!QI\u0001\u0010e\u0012$Gk\\!E\u00036\u0013v\u000e\u001a*E\tR!!q\tB'!\ra!\u0011J\u0005\u0004\u0005\u0017\u0012!aE!E\u00036\u0013v\u000e\u001a*E\t\u001a+hn\u0019;j_:\u001c\bbB\u0002\u0003B\u0001\u0007!q\n\t\u0005;~\u0013\t\u0006E\u00027\u0005'J1A!\u00168\u0005\u001d\tE)Q'S_\u0012DqA!\u0017\u000e\t\u0007\u0011Y&\u0001\u0007sI\u0012$v.\u0011#B\u001bJ#E)\u0006\u0003\u0003^\t%D\u0003\u0002B0\u0005o\"bA!\u0019\u0003l\tE\u0004#\u0002\u0007\u0003d\t\u001d\u0014b\u0001B3\u0005\t\u0001\u0012\tR!N%\u0012#e)\u001e8di&|gn\u001d\t\u0004_\n%DAB9\u0003X\t\u0007!\u000f\u0003\u0006\u0003n\t]\u0013\u0011!a\u0002\u0005_\n!\"\u001a<jI\u0016t7-\u001a\u00132!\u0015\tBPa\u001a\u007f\u0011)\u0011\u0019Ha\u0016\u0002\u0002\u0003\u000f!QO\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004#\u0002 \u0002\u0012\t\u001d\u0004bB\u0002\u0003X\u0001\u0007!\u0011\u0010\t\u0005;~\u00139\u0007C\u0004\u0003Z5!\u0019A! \u0015\t\t}$Q\u0011\t\u0004\u0019\t\u0005\u0015b\u0001BB\u0005\tA\u0013\tR!N\u001dV\u001cG.Z8uS\u0012,7i\u001c8uS\u001e4%/Y4nK:$(\u000b\u0012#Gk:\u001cG/[8og\"91Aa\u001fA\u0002\t\u001d\u0005\u0003B/`\u0005\u0013\u00032A\u0019BF\u0013\r\u0011ii\u0019\u0002\u001d\u0003\u0012\u000bUJT;dY\u0016|G/\u001b3f\u0007>tG/[4Ge\u0006<W.\u001a8u\u0011\u001d\u0011\t*\u0004C\u0002\u0005'\u000b!C]3d_J$Gk\u001c*jG\"\u0014VmY8sIR!!Q\u0013BQ!\u0011\u00119J!(\u000e\u0005\te%b\u0001BN\t\u0005!!/[2i\u0013\u0011\u0011yJ!'\u0003\u001dIK7\r[!E\u00036\u0013VmY8sI\"9!1\u0015BH\u0001\u0004\t\u0017A\u0002:fG>\u0014H\rC\u0004\u0003(6!\u0019A!+\u0002\u001d1L7\u000f\u001e+p\u0015\u00064\u0018\rT5tiV!!1\u0016B`)\u0011\u0011iKa1\u0011\r\t=&\u0011\u0018B_\u001b\t\u0011\tL\u0003\u0003\u00034\nU\u0016\u0001B;uS2T!Aa.\u0002\t)\fg/Y\u0005\u0005\u0005w\u0013\tL\u0001\u0003MSN$\bcA8\u0003@\u00129!\u0011\u0019BS\u0005\u0004\u0011(!A!\t\u0011\t\u0015'Q\u0015a\u0001\u0005\u000f\fA\u0001\\5tiB1\u00111\u0014Be\u0005{KAAa/\u00020\"9!QZ\u0007\u0005\u0004\t=\u0017A\u00046bm\u0006d\u0015n\u001d;U_2K7\u000f^\u000b\u0005\u0005#\u00149\u000e\u0006\u0003\u0003T\ne\u0007CBAN\u0005\u0013\u0014)\u000eE\u0002p\u0005/$qA!1\u0003L\n\u0007!\u000f\u0003\u0005\u0003F\n-\u0007\u0019\u0001Bn!\u0019\u0011yK!/\u0003V\"9!q\\\u0007\u0005\u0004\t\u0005\u0018\u0001\u00046bm\u0006\u001cV\r\u001e+p'\u0016$X\u0003\u0002Br\u0005[$BA!:\u0003pB)aHa:\u0003l&\u0019!\u0011^\"\u0003\u0007M+G\u000fE\u0002p\u0005[$qA!1\u0003^\n\u0007!\u000f\u0003\u0005\u0003r\nu\u0007\u0019\u0001Bz\u0003\r\u0019X\r\u001e\t\u0007\u0005_\u0013)Pa;\n\t\t%(\u0011\u0017\u0005\b\u0005slA1\u0001B~\u0003aIg\u000e\u001e'jgR$vNS1wC&sG/Z4fe2K7\u000f\u001e\u000b\u0005\u0005{\u001cY\u0001\u0005\u0004\u00030\ne&q \t\u0005\u0007\u0003\u00199!\u0004\u0002\u0004\u0004)!1Q\u0001B[\u0003\u0011a\u0017M\\4\n\t\r%11\u0001\u0002\b\u0013:$XmZ3s\u0011!\u0011)Ma>A\u0002\r5\u0001CBAN\u0005\u0013\u001cy\u0001E\u0002\u0012\u0007#I1aa\u0005\u0013\u0005\rIe\u000e\u001e\u0005\b\u0007/iA1AB\r\u0003Q\u0019\u0007.\u0019:TKF,XM\\2f)>\u001cFO]5oOR\u0019Qha\u0007\t\u0011\ru1Q\u0003a\u0001\u0007?\t!aY:\u0011\t\r\u00051\u0011E\u0005\u0005\u0007G\u0019\u0019A\u0001\u0007DQ\u0006\u00148+Z9vK:\u001cW\rC\u0004\u0004(5!\u0019a!\u000b\u0002%\rD\u0017M]*fcV,gnY3U_2K7\u000f\u001e\u000b\u0005\u0007W\u0019\u0019\u0004\u0005\u0004\u0002\u001c\n%7Q\u0006\t\u0004#\r=\u0012bAB\u0019%\t!1\t[1s\u0011!\u0019ib!\nA\u0002\r}\u0001bBB\u001c\u001b\u0011\r1\u0011H\u0001\r[\u0006\u0004Hk\u001c&bm\u0006l\u0015\r]\u000b\u0007\u0007w\u0019)e!\u0013\u0015\t\ru2Q\n\t\t\u0005_\u001byda\u0011\u0004H%!1\u0011\tBY\u0005\ri\u0015\r\u001d\t\u0004_\u000e\u0015Ca\u0002Ba\u0007k\u0011\rA\u001d\t\u0004_\u000e%CaBB&\u0007k\u0011\rA\u001d\u0002\u0002\u0005\"A1qJB\u001b\u0001\u0004\u0019\t&A\u0002nCB\u0004\u0002ba\u0015\u0004Z\r\r3qI\u0007\u0003\u0007+R1aa\u0016\u0013\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0007\u0003\u001a)\u0006C\u0004\u0004^5!\u0019aa\u0018\u00021%$XM]1cY\u0016$vNS1wC\u000e{G\u000e\\3di&|g.\u0006\u0003\u0004b\r-D\u0003BB2\u0007[\u0002bAa,\u0004f\r%\u0014\u0002BB4\u0005c\u0013!bQ8mY\u0016\u001cG/[8o!\ry71\u000e\u0003\b\u0005\u0003\u001cYF1\u0001s\u0011!\u0019yga\u0017A\u0002\rE\u0014!A5\u0011\r\u0005m51OB5\u0013\u0011\u0019)(a,\u0003\u0011%#XM]1cY\u0016Dqa!\u001f\u000e\t\u0007\u0019Y(\u0001\u0007tKR$vNS1wCN+G/\u0006\u0003\u0004~\r\rE\u0003BB@\u0007\u000b\u0003bAa,\u0003v\u000e\u0005\u0005cA8\u0004\u0004\u00129!\u0011YB<\u0005\u0004\u0011\b\u0002\u0003By\u0007o\u0002\raa\"\u0011\u000by\u00129o!!\t\u000f\r-U\u0002\"\u0001\u0004\u000e\u0006\u00112M]3bi\u0016\u001c\u0006/\u0019:l\u0007>tG/\u001a=u)=a3qRBJ\u0007/\u001bYj!)\u0004&\u000e=\u0006bBBI\u0007\u0013\u0003\r!P\u0001\u0005]\u0006lW\rC\u0004\u0004\u0016\u000e%\u0005\u0019A\u001f\u0002\r5\f7\u000f^3s\u0011\u001d\u0019Ij!#A\u0002u\n\u0011b\u001d9be.Du.\\3\t\u0011\ru5\u0011\u0012a\u0001\u0007?\u000b\u0011b\u001d9be.T\u0015M]:\u0011\u000b\u0005m\u00151V\u001f\t\u0011\r\r6\u0011\u0012a\u0001\u0007?\u000bAb\u001d9be.,eN\u001e,beND!ba*\u0004\nB\u0005\t\u0019ABU\u0003U\u0019\b/\u0019:l\u0003\u0012$7\u000b^1ug2K7\u000f^3oKJ\u00042!EBV\u0013\r\u0019iK\u0005\u0002\b\u0005>|G.Z1o\u0011)\u0019\tl!#\u0011\u0002\u0003\u00071qB\u0001\u0014gB\f'o[&ss>\u0014UO\u001a4feNK'0\u001a\u0005\n\u0007kk\u0011\u0013!C\u0001\u0007o\u000bAd\u0019:fCR,7\u000b]1sW\u000e{g\u000e^3yi\u0012\"WMZ1vYR$c'\u0006\u0002\u0004:*\"1\u0011VAr\u0011%\u0019i,DI\u0001\n\u0003\u0019y,\u0001\u000fde\u0016\fG/Z*qCJ\\7i\u001c8uKb$H\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\r\u0005'\u0006BB\b\u0003GD\u0011b!2\u000e\u0003\u0003%Iaa2\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0007\u0013\u0004Ba!\u0001\u0004L&!1QZB\u0002\u0005\u0019y%M[3di\u0002")
public class ADAMContext
implements Serializable,
Logging {
    public final SparkContext org$bdgenomics$adam$rdd$ADAMContext$$sc;
    private transient Logger org$apache$spark$Logging$$log_;

    public static int createSparkContext$default$7() {
        return ADAMContext$.MODULE$.createSparkContext$default$7();
    }

    public static boolean createSparkContext$default$6() {
        return ADAMContext$.MODULE$.createSparkContext$default$6();
    }

    public static SparkContext createSparkContext(String string, String string2, String string3, Seq<String> seq, Seq<String> seq2, boolean bl, int n) {
        return ADAMContext$.MODULE$.createSparkContext(string, string2, string3, seq, seq2, bl, n);
    }

    public static <A> java.util.Set<A> setToJavaSet(scala.collection.immutable.Set<A> set) {
        return ADAMContext$.MODULE$.setToJavaSet(set);
    }

    public static <A> Collection<A> iterableToJavaCollection(Iterable<A> iterable) {
        return ADAMContext$.MODULE$.iterableToJavaCollection(iterable);
    }

    public static <A, B> java.util.Map<A, B> mapToJavaMap(Map<A, B> map) {
        return ADAMContext$.MODULE$.mapToJavaMap(map);
    }

    public static List<Object> charSequenceToList(CharSequence charSequence) {
        return ADAMContext$.MODULE$.charSequenceToList(charSequence);
    }

    public static String charSequenceToString(CharSequence charSequence) {
        return ADAMContext$.MODULE$.charSequenceToString(charSequence);
    }

    public static java.util.List<Integer> intListToJavaIntegerList(List<Object> list) {
        return ADAMContext$.MODULE$.intListToJavaIntegerList(list);
    }

    public static <A> scala.collection.immutable.Set<A> javaSetToSet(java.util.Set<A> set) {
        return ADAMContext$.MODULE$.javaSetToSet(set);
    }

    public static <A> List<A> javaListToList(java.util.List<A> list) {
        return ADAMContext$.MODULE$.javaListToList(list);
    }

    public static <A> java.util.List<A> listToJavaList(List<A> list) {
        return ADAMContext$.MODULE$.listToJavaList(list);
    }

    public static RichADAMRecord recordToRichRecord(ADAMRecord aDAMRecord) {
        return ADAMContext$.MODULE$.recordToRichRecord(aDAMRecord);
    }

    public static ADAMNucleotideContigFragmentRDDFunctions rddToADAMRDD(RDD<ADAMNucleotideContigFragment> rDD) {
        return ADAMContext$.MODULE$.rddToADAMRDD(rDD);
    }

    public static <T> ADAMRDDFunctions<T> rddToADAMRDD(RDD<T> rDD, Function1<T, SpecificRecord> function1, Manifest<T> manifest) {
        return ADAMContext$.MODULE$.rddToADAMRDD(rDD, function1, manifest);
    }

    public static ADAMRodRDDFunctions rddToADAMRodRDD(RDD<ADAMRod> rDD) {
        return ADAMContext$.MODULE$.rddToADAMRodRDD(rDD);
    }

    public static ADAMPileupRDDFunctions rddToADAMPileupRDD(RDD<ADAMPileup> rDD) {
        return ADAMContext$.MODULE$.rddToADAMPileupRDD(rDD);
    }

    public static ADAMRecordRDDFunctions rddToADAMRecordRDD(RDD<ADAMRecord> rDD) {
        return ADAMContext$.MODULE$.rddToADAMRecordRDD(rDD);
    }

    public static ADAMContext sparkContextToADAMContext(SparkContext sparkContext) {
        return ADAMContext$.MODULE$.sparkContextToADAMContext(sparkContext);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private SequenceDictionary adamBamDictionaryLoad(String filePath) {
        SAMFileHeader samHeader = SAMHeaderReader.readSAMHeaderFrom((Path)new Path(filePath), (Configuration)this.org$bdgenomics$adam$rdd$ADAMContext$$sc.hadoopConfiguration());
        return this.adamBamDictionaryLoad(samHeader);
    }

    private SequenceDictionary adamBamDictionaryLoad(SAMFileHeader samHeader) {
        return SequenceDictionary$.MODULE$.fromSAMHeader(samHeader);
    }

    private RecordGroupDictionary adamBamLoadReadGroups(SAMFileHeader samHeader) {
        return RecordGroupDictionary$.MODULE$.fromSAMHeader(samHeader);
    }

    private RDD<ADAMRecord> adamBamLoad(String filePath) {
        Predef$ predef$ = Predef$.MODULE$;
        this.log().info(new StringOps("Reading legacy BAM file format %s to create RDD").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        SAMFileHeader samHeader = SAMHeaderReader.readSAMHeaderFrom((Path)new Path(filePath), (Configuration)this.org$bdgenomics$adam$rdd$ADAMContext$$sc.hadoopConfiguration());
        SequenceDictionary seqDict = this.adamBamDictionaryLoad(samHeader);
        RecordGroupDictionary readGroups = this.adamBamLoadReadGroups(samHeader);
        Job job = new Job(this.org$bdgenomics$adam$rdd$ADAMContext$$sc.hadoopConfiguration());
        RDD records = this.org$bdgenomics$adam$rdd$ADAMContext$$sc.newAPIHadoopFile(filePath, AnySAMInputFormat.class, LongWritable.class, SAMRecordWritable.class, ContextUtil.getConfiguration((JobContext)job));
        SAMRecordConverter samRecordConverter = new SAMRecordConverter();
        return records.map((Function1)new Serializable(this, seqDict, readGroups, samRecordConverter){
            public static final long serialVersionUID = 0L;
            private final SequenceDictionary seqDict$1;
            private final RecordGroupDictionary readGroups$1;
            private final SAMRecordConverter samRecordConverter$1;

            public final ADAMRecord apply(Tuple2<LongWritable, SAMRecordWritable> p) {
                return this.samRecordConverter$1.convert(((SAMRecordWritable)p._2()).get(), this.seqDict$1, this.readGroups$1);
            }
            {
                this.seqDict$1 = seqDict$1;
                this.readGroups$1 = readGroups$1;
                this.samRecordConverter$1 = samRecordConverter$1;
            }
        }, ClassTag$.MODULE$.apply(ADAMRecord.class));
    }

    private <T, U extends UnboundRecordFilter> RDD<T> adamParquetLoad(String filePath, Option<Class<U>> predicate, Option<Schema> projection, Function1<T, SpecificRecord> evidence$3, Manifest<T> evidence$4) {
        Predef$ predef$ = Predef$.MODULE$;
        this.log().info(new StringOps("Reading the ADAM file at %s to create RDD").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        Job job = new Job(this.org$bdgenomics$adam$rdd$ADAMContext$$sc.hadoopConfiguration());
        ParquetInputFormat.setReadSupportClass((Job)job, AvroReadSupport.class);
        if (predicate.isDefined()) {
            this.log().info("Using the specified push-down predicate");
            ParquetInputFormat.setUnboundRecordFilter((Job)job, (Class)((Class)predicate.get()));
        }
        if (projection.isDefined()) {
            this.log().info("Using the specified projection schema");
            AvroParquetInputFormat.setRequestedProjection((Job)job, (Schema)((Schema)projection.get()));
        }
        RDD records = this.org$bdgenomics$adam$rdd$ADAMContext$$sc.newAPIHadoopFile(filePath, ParquetInputFormat.class, Void.class, Predef$.MODULE$.manifest(evidence$4).erasure(), ContextUtil.getConfiguration((JobContext)job)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final T apply(Tuple2<Void, T> p) {
                return (T)p._2();
            }
        }, evidence$4);
        return predicate.isDefined() ? records.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(T p) {
                return p != null;
            }
        }) : records;
    }

    private <T, U extends UnboundRecordFilter> None$ adamParquetLoad$default$2() {
        return None$.MODULE$;
    }

    private <T, U extends UnboundRecordFilter> Option<Schema> adamParquetLoad$default$3() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> SequenceDictionary adamDictionaryLoad(String filePath, Function1<T, SpecificRecord> evidence$5, Manifest<T> evidence$6) {
        SequenceDictionary sequenceDictionary;
        Schema projection;
        boolean isADAMRecord = ADAMRecord.class.isAssignableFrom(Predef$.MODULE$.manifest(evidence$6).erasure());
        boolean isADAMContig = ADAMNucleotideContigFragment.class.isAssignableFrom(Predef$.MODULE$.manifest(evidence$6).erasure());
        Schema schema = isADAMRecord ? Projection$.MODULE$.apply((Seq<FieldValue>)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{ADAMRecordField$.MODULE$.referenceId(), ADAMRecordField$.MODULE$.referenceName(), ADAMRecordField$.MODULE$.referenceLength(), ADAMRecordField$.MODULE$.referenceUrl(), ADAMRecordField$.MODULE$.mateReferenceId(), ADAMRecordField$.MODULE$.mateReference(), ADAMRecordField$.MODULE$.mateReferenceLength(), ADAMRecordField$.MODULE$.mateReferenceUrl(), ADAMRecordField$.MODULE$.readPaired(), ADAMRecordField$.MODULE$.firstOfPair(), ADAMRecordField$.MODULE$.readMapped(), ADAMRecordField$.MODULE$.mateMapped()})) : (projection = isADAMContig ? Projection$.MODULE$.apply((Seq<FieldValue>)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{ADAMNucleotideContigFragmentField$.MODULE$.contigName(), ADAMNucleotideContigFragmentField$.MODULE$.contigId(), ADAMNucleotideContigFragmentField$.MODULE$.contigLength(), ADAMNucleotideContigFragmentField$.MODULE$.url()})) : Projection$.MODULE$.apply((Seq<FieldValue>)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{ADAMRecordField$.MODULE$.referenceId(), ADAMRecordField$.MODULE$.referenceName(), ADAMRecordField$.MODULE$.referenceLength(), ADAMRecordField$.MODULE$.referenceUrl()})));
        if (filePath.endsWith(".bam") || filePath.endsWith(".sam")) {
            if (!isADAMRecord) throw new IllegalArgumentException("If you're reading a BAM/SAM file, the record type must be ADAMRecord");
            sequenceDictionary = this.adamBamDictionaryLoad(filePath);
            return sequenceDictionary;
        } else {
            SequenceDictionary dict;
            RDD<T> projected = this.adamParquetLoad(filePath, (Option)None$.MODULE$, (Option<Schema>)new Some((Object)projection), evidence$5, evidence$6);
            RDD recs = isADAMRecord ? projected.distinct().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Set<SequenceRecord> apply(ADAMRecord rec) {
                    return SequenceRecord$.MODULE$.fromADAMRecord(rec);
                }
            }, ClassTag$.MODULE$.apply(SequenceRecord.class)) : (isADAMContig ? projected.distinct().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceRecord apply(ADAMNucleotideContigFragment ctg) {
                    return SequenceRecord$.MODULE$.fromADAMContigFragment(ctg);
                }
            }, ClassTag$.MODULE$.apply(SequenceRecord.class)) : projected.distinct().map((Function1)new Serializable(this, evidence$5){
                public static final long serialVersionUID = 0L;
                private final Function1 evidence$5$1;

                public final SequenceRecord apply(T x$1) {
                    return SequenceRecord$.MODULE$.fromSpecificRecord((SpecificRecord)this.evidence$5$1.apply(x$1));
                }
                {
                    this.evidence$5$1 = evidence$5$1;
                }
            }, ClassTag$.MODULE$.apply(SequenceRecord.class)));
            sequenceDictionary = dict = (SequenceDictionary)recs.aggregate((Object)SequenceDictionary$.MODULE$.apply((Seq<SequenceRecord>)Nil$.MODULE$), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceDictionary apply(SequenceDictionary dict, SequenceRecord rec) {
                    return dict.$plus(rec);
                }
            }, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceDictionary apply(SequenceDictionary dict1, SequenceDictionary dict2) {
                    return dict1.$plus$plus(dict2);
                }
            }, ClassTag$.MODULE$.apply(SequenceDictionary.class));
        }
        return sequenceDictionary;
    }

    public <T, U extends UnboundRecordFilter> RDD<T> adamLoad(String filePath, Option<Class<U>> predicate, Option<Schema> projection, Function1<T, SpecificRecord> evidence$7, Manifest<T> evidence$8) {
        Object object;
        if (filePath.endsWith(".bam") || filePath.endsWith(".sam") && ADAMRecord.class.isAssignableFrom(Predef$.MODULE$.manifest(evidence$8).erasure())) {
            if (predicate.isDefined()) {
                this.log().warn("Predicate is ignored when loading a BAM file");
            }
            if (projection.isDefined()) {
                this.log().warn("Projection is ignored when loading a BAM file");
            }
            object = this.adamBamLoad(filePath);
        } else {
            object = this.adamParquetLoad(filePath, predicate, projection, evidence$7, evidence$8);
        }
        return object;
    }

    public <T, U extends UnboundRecordFilter> None$ adamLoad$default$2() {
        return None$.MODULE$;
    }

    public <T, U extends UnboundRecordFilter> Option<Schema> adamLoad$default$3() {
        return None$.MODULE$;
    }

    public Seq<Path> findFiles(Path path, String regex) {
        Tuple2 tuple2;
        block4: {
            Seq seq;
            block3: {
                block2: {
                    if (regex != null) break block2;
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{path}));
                    break block3;
                }
                FileStatus[] statuses = FileSystem.get((Configuration)this.org$bdgenomics$adam$rdd$ADAMContext$$sc.hadoopConfiguration()).listStatus(path);
                Pattern r = Pattern.compile(regex);
                tuple2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])statuses).filter((Function1)new $anonfun$8(this))).map((Function1)new $anonfun$9(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))).partition((Function1)new $anonfun$10(this, r));
                if (tuple2 == null) break block4;
                Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
                Path[] matches = (Path[])tuple22._1();
                Path[] recurse = (Path[])tuple22._2();
                seq = (Seq)Predef$.MODULE$.refArrayOps((Object[])matches).toSeq().$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])recurse).flatMap((Function1)new Serializable(this, regex){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ADAMContext $outer;
                    private final String regex$1;

                    public final Seq<Path> apply(Path p) {
                        return this.$outer.findFiles(p, this.regex$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.regex$1 = regex$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))), Seq$.MODULE$.canBuildFrom());
            }
            return seq;
        }
        throw new MatchError((Object)tuple2);
    }

    public RDD<ADAMRecord> loadADAMFromPaths(Seq<Path> paths) {
        return this.org$bdgenomics$adam$rdd$ADAMContext$$sc.union(this.remap$1((Seq)paths.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMContext $outer;

            public final Tuple2<SequenceDictionary, RDD<ADAMRecord>> apply(Path path) {
                return this.$outer.org$bdgenomics$adam$rdd$ADAMContext$$loadADAMs$1(path);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())), ClassTag$.MODULE$.apply(ADAMRecord.class));
    }

    public final Tuple2 org$bdgenomics$adam$rdd$ADAMContext$$loadADAMs$1(Path path) {
        SequenceDictionary dict = this.adamDictionaryLoad(path.toString(), (Function1)Predef$.MODULE$.conforms(), (Manifest)ManifestFactory$.MODULE$.classType(ADAMRecord.class));
        RDD rdd = this.adamLoad(path.toString(), (Option)this.adamLoad$default$2(), this.adamLoad$default$3(), (Function1)Predef$.MODULE$.conforms(), (Manifest)ManifestFactory$.MODULE$.classType(ADAMRecord.class));
        return new Tuple2((Object)dict, rdd);
    }

    private final Seq remap$1(Seq adams) {
        Option option;
        block4: {
            Seq seq;
            block3: {
                block2: {
                    option = adams.headOption();
                    None$ none$ = None$.MODULE$;
                    if (none$ != null ? !none$.equals(option) : option != null) break block2;
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                RDD rDD = (RDD)((Tuple2)some.x())._2();
                seq = (Seq)((SeqLike)((TraversableLike)adams.tail()).map((Function1)new Serializable(this, some){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ADAMContext $outer;
                    private final Some x2$1;

                    public final RDD<ADAMRecord> apply(Tuple2<SequenceDictionary, RDD<ADAMRecord>> v) {
                        return ((SequenceDictionary)v._1()).equals(((Tuple2)this.x2$1.x())._1()) ? (RDD<ADAMRecord>)v._2() : RichRDDReferenceRecords$.MODULE$.adamRDDToRichADAMRDD((RDD<ADAMRecord>)((RDD)v._2())).remapReferenceId((scala.collection.immutable.Map<Object, Object>)((SequenceDictionary)v._1()).mapTo((SequenceDictionary)((Tuple2)this.x2$1.x())._1()).toMap(Predef$.MODULE$.conforms()), this.$outer.org$bdgenomics$adam$rdd$ADAMContext$$sc);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.x2$1 = x2$1;
                    }
                }, Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)rDD, Seq$.MODULE$.canBuildFrom());
            }
            return seq;
        }
        throw new MatchError((Object)option);
    }

    public ADAMContext(SparkContext sc) {
        this.org$bdgenomics$adam$rdd$ADAMContext$$sc = sc;
        Logging.class.$init$((Logging)this);
    }
}

