/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.models;

import org.bdgenomics.adam.avro.ADAMContig;
import org.bdgenomics.adam.avro.ADAMGenotype;
import org.bdgenomics.adam.avro.ADAMPileup;
import org.bdgenomics.adam.avro.ADAMRecord;
import org.bdgenomics.adam.avro.ADAMVariant;
import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferencePosition$;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]1A!\u0001\u0002\u0001\u0017\t1\"+\u001a4fe\u0016t7-\u001a)pg&$\u0018n\u001c8Tk&$XM\u0003\u0002\u0004\t\u00051Qn\u001c3fYNT!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti\u0001#D\u0001\u000f\u0015\ty\u0001\"A\u0005tG\u0006d\u0017\r^3ti&\u0011\u0011C\u0004\u0002\t\rVt7+^5uK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001")
public class ReferencePositionSuite
extends FunSuite {
    public ReferencePositionSuite() {
        this.test("create reference position from mapped read", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMRecord read = ADAMRecord.newBuilder().setStart(Predef$.MODULE$.long2Long(1L)).setReferenceId(Predef$.MODULE$.int2Integer(1)).setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).build();
                Option refPosOpt = ReferencePosition$.MODULE$.apply(read);
                this.$outer.assert(refPosOpt.isDefined());
                ReferencePosition refPos = (ReferencePosition)refPosOpt.get();
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)refPos.refId())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)refPos.pos())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)1L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create reference position from unmapped read", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMRecord read = ADAMRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(false)).build();
                Option refPosOpt = ReferencePosition$.MODULE$.apply(read);
                this.$outer.assert(refPosOpt.isEmpty());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create reference position from pileup", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMPileup pileup = ADAMPileup.newBuilder().setPosition(Predef$.MODULE$.long2Long(2L)).setReferenceId(Predef$.MODULE$.int2Integer(2)).build();
                ReferencePosition refPos = ReferencePosition$.MODULE$.apply(pileup);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)refPos.refId())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)2)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)refPos.pos())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)2L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create reference position from variant", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMContig contig = ADAMContig.newBuilder().setContigId(Predef$.MODULE$.int2Integer(10)).setContigName((CharSequence)"chr10").build();
                ADAMVariant variant = ADAMVariant.newBuilder().setContig(contig).setReferenceAllele((CharSequence)"A").setVariantAllele((CharSequence)"T").setPosition(Predef$.MODULE$.long2Long(10L)).build();
                ReferencePosition refPos = ReferencePosition$.MODULE$.apply(variant);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)refPos.refId())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)refPos.pos())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)10L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create reference position from genotype", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferencePositionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMContig contig = ADAMContig.newBuilder().setContigId(Predef$.MODULE$.int2Integer(10)).setContigName((CharSequence)"chr10").build();
                ADAMVariant variant = ADAMVariant.newBuilder().setPosition(Predef$.MODULE$.long2Long(100L)).setContig(contig).setReferenceAllele((CharSequence)"A").setVariantAllele((CharSequence)"T").build();
                ADAMGenotype genotype = ADAMGenotype.newBuilder().setVariant(variant).build();
                ReferencePosition refPos = ReferencePosition$.MODULE$.apply(genotype);
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)refPos.refId())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)10)));
                this.$outer.assert(this.$outer.convertToEqualizer(BoxesRunTime.boxToLong((long)refPos.pos())).$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)100L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

