/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.models;

import org.bdgenomics.adam.avro.ADAMRecord;
import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.models.ReferenceRegion$;
import org.bdgenomics.adam.models.ReferenceRegionSuite$;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U2A!\u0001\u0002\u0001\u0017\t!\"+\u001a4fe\u0016t7-\u001a*fO&|gnU;ji\u0016T!a\u0001\u0003\u0002\r5|G-\u001a7t\u0015\t)a!\u0001\u0003bI\u0006l'BA\u0004\t\u0003)\u0011GmZ3o_6L7m\u001d\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0003\u001f!\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005Eq!\u0001\u0003$v]N+\u0018\u000e^3\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001\"\u0002\r\u0001\t\u0003I\u0012A\u0002:fO&|g\u000e\u0006\u0003\u001b;\u0015R\u0003C\u0001\f\u001c\u0013\ta\"AA\bSK\u001a,'/\u001a8dKJ+w-[8o\u0011\u0015qr\u00031\u0001 \u0003\u0015\u0011XMZ%e!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\rIe\u000e\u001e\u0005\u0006M]\u0001\raJ\u0001\u0006gR\f'\u000f\u001e\t\u0003A!J!!K\u0011\u0003\t1{gn\u001a\u0005\u0006W]\u0001\raJ\u0001\u0004K:$\u0007\"B\u0017\u0001\t\u0003q\u0013!\u00029pS:$HcA\u00183gA\u0011a\u0003M\u0005\u0003c\t\u0011\u0011CU3gKJ,gnY3Q_NLG/[8o\u0011\u0015qB\u00061\u0001 \u0011\u0015!D\u00061\u0001(\u0003\r\u0001xn\u001d")
public class ReferenceRegionSuite
extends FunSuite {
    public ReferenceRegion region(int refId, long start, long end) {
        return new ReferenceRegion(refId, start, end);
    }

    public ReferencePosition point(int refId, long pos) {
        return new ReferencePosition(refId, pos);
    }

    public ReferenceRegionSuite() {
        this.test("contains(: ReferenceRegion)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.region(0, 10L, 100L).contains(this.$outer.region(0, 50L, 70L)));
                this.$outer.assert(this.$outer.region(0, 10L, 100L).contains(this.$outer.region(0, 10L, 100L)));
                this.$outer.assert(!this.$outer.region(0, 10L, 100L).contains(this.$outer.region(1, 50L, 70L)));
                this.$outer.assert(this.$outer.region(0, 10L, 100L).contains(this.$outer.region(0, 50L, 100L)));
                this.$outer.assert(!this.$outer.region(0, 10L, 100L).contains(this.$outer.region(0, 50L, 101L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("contains(: ReferencePosition)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.region(0, 10L, 100L).contains(this.$outer.point(0, 50L)));
                this.$outer.assert(this.$outer.region(0, 10L, 100L).contains(this.$outer.point(0, 10L)));
                this.$outer.assert(this.$outer.region(0, 10L, 100L).contains(this.$outer.point(0, 99L)));
                this.$outer.assert(!this.$outer.region(0, 10L, 100L).contains(this.$outer.point(0, 100L)));
                this.$outer.assert(!this.$outer.region(0, 10L, 100L).contains(this.$outer.point(1, 50L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("merge", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final ReferenceRegion apply() {
                        return this.$outer.$outer.region(0, 10L, 100L).merge(this.$outer.$outer.region(1, 10L, 100L));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(AssertionError.class));
                ReferenceRegion r1 = this.$outer.region(0, 10L, 100L);
                ReferenceRegion r2 = this.$outer.region(0, 0L, 15L);
                ReferenceRegion r3 = this.$outer.region(0, 50L, 150L);
                ReferenceRegion r12 = this.$outer.region(0, 0L, 100L);
                ReferenceRegion r13 = this.$outer.region(0, 10L, 150L);
                this.$outer.assert(this.$outer.convertToEqualizer(r1.merge(r1)).$eq$eq$eq((Object)r1));
                this.$outer.assert(this.$outer.convertToEqualizer(r1.merge(r2)).$eq$eq$eq((Object)r12));
                this.$outer.assert(this.$outer.convertToEqualizer(r1.merge(r3)).$eq$eq$eq((Object)r13));
            }

            public /* synthetic */ ReferenceRegionSuite org$bdgenomics$adam$models$ReferenceRegionSuite$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("overlaps", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.region(0, 10L, 100L).overlaps(this.$outer.region(0, 20L, 50L)));
                this.$outer.assert(this.$outer.region(0, 10L, 100L).overlaps(this.$outer.region(0, 50L, 250L)));
                this.$outer.assert(this.$outer.region(0, 10L, 100L).overlaps(this.$outer.region(0, 5L, 15L)));
                this.$outer.assert(this.$outer.region(0, 10L, 100L).overlaps(this.$outer.region(0, 5L, 11L)));
                this.$outer.assert(!this.$outer.region(0, 10L, 100L).overlaps(this.$outer.region(0, 5L, 10L)));
                this.$outer.assert(this.$outer.region(0, 10L, 100L).overlaps(this.$outer.region(0, 99L, 200L)));
                this.$outer.assert(!this.$outer.region(0, 10L, 100L).overlaps(this.$outer.region(0, 100L, 200L)));
                this.$outer.assert(!this.$outer.region(0, 10L, 100L).overlaps(this.$outer.region(1, 50L, 200L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("distance(: ReferenceRegion)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region(0, 10L, 100L).distance(this.$outer.region(0, 200L, 300L))).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToInteger((int)101))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region(0, 100L, 200L).distance(this.$outer.region(0, 10L, 50L))).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToInteger((int)51))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region(0, 100L, 200L).distance(this.$outer.region(1, 10L, 50L))).$eq$eq$eq((Object)None$.MODULE$));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region(0, 10L, 100L).distance(this.$outer.region(0, 100L, 200L))).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region(0, 10L, 100L).distance(this.$outer.region(0, 50L, 150L))).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region(0, 10L, 100L).distance(this.$outer.region(0, 0L, 10L))).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("distance(: ReferencePosition)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region(0, 10L, 100L).distance(this.$outer.point(0, 50L))).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region(0, 10L, 100L).distance(this.$outer.point(0, 10L))).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region(0, 10L, 100L).distance(this.$outer.point(0, 100L))).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region(0, 10L, 100L).distance(this.$outer.point(0, 150L))).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToInteger((int)51))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region(0, 100L, 200L).distance(this.$outer.point(0, 50L))).$eq$eq$eq((Object)new Some((Object)BoxesRunTime.boxToInteger((int)50))));
                this.$outer.assert(this.$outer.convertToEqualizer(this.$outer.region(0, 100L, 200L).distance(this.$outer.point(1, 50L))).$eq$eq$eq((Object)None$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create region from unmapped read fails", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMRecord read = ADAMRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(false)).build();
                this.$outer.assert(ReferenceRegion$.MODULE$.apply(read).isEmpty());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create region from mapped read contains read start and end", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ADAMRecord read = ADAMRecord.newBuilder().setReadMapped(Predef$.MODULE$.boolean2Boolean(true)).setSequence((CharSequence)"AAAAA").setStart(Predef$.MODULE$.long2Long(1L)).setCigar((CharSequence)"5M").setReferenceId(Predef$.MODULE$.int2Integer(1)).build();
                this.$outer.assert(ReferenceRegion$.MODULE$.apply(read).isDefined());
                this.$outer.assert(((ReferenceRegion)ReferenceRegion$.MODULE$.apply(read).get()).contains(this.$outer.point(1, 1L)));
                this.$outer.assert(((ReferenceRegion)ReferenceRegion$.MODULE$.apply(read).get()).contains(this.$outer.point(1, 5L)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("validate that adjacent regions can be merged", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ReferenceRegion r1 = this.$outer.region(1, 0L, 6L);
                ReferenceRegion r2 = this.$outer.region(1, 6L, 10L);
                this.$outer.assert(this.$outer.convertToEqualizer(r1.distance(r2).get()).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1)));
                this.$outer.assert(r1.isAdjacent(r2));
                ReferenceRegion referenceRegion = r1.merge(r2);
                ReferenceRegion referenceRegion2 = this.$outer.region(1, 0L, 10L);
                this.$outer.assert(!(referenceRegion != null ? !referenceRegion.equals(referenceRegion2) : referenceRegion2 != null));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("validate that non-adjacent regions cannot be merged", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ReferenceRegion r2;
                ReferenceRegion r1 = this.$outer.region(1, 0L, 5L);
                this.$outer.assert(!r1.isAdjacent(r2 = this.$outer.region(1, 7L, 10L)));
                this.$outer.intercept((Function0)new Serializable(this, r1, r2){
                    public static final long serialVersionUID = 0L;
                    private final ReferenceRegion r1$1;
                    private final ReferenceRegion r2$1;

                    public final ReferenceRegion apply() {
                        return this.r1$1.merge(this.r2$1);
                    }
                    {
                        this.r1$1 = r1$1;
                        this.r2$1 = r2$1;
                    }
                }, ManifestFactory$.MODULE$.classType(AssertionError.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("compute convex hull of two sets", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReferenceRegionSuite $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ReferenceRegion r2;
                ReferenceRegion r1 = this.$outer.region(1, 0L, 5L);
                this.$outer.assert(!r1.isAdjacent(r2 = this.$outer.region(1, 7L, 10L)));
                ReferenceRegion hull1 = r1.hull(r2);
                ReferenceRegion hull2 = r2.hull(r1);
                this.$outer.assert(this.$outer.convertToEqualizer(hull1).$eq$eq$eq((Object)hull2));
                this.$outer.assert(hull1.overlaps(r1));
                this.$outer.assert(hull1.overlaps(r2));
                this.$outer.assert(hull1.start() == 0L);
                this.$outer.assert(hull1.end() == 10L);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

