/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import org.apache.spark.Partitioner;
import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferencePosition$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.rdd.GenomicRegionPartitioner$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\u0001\u0003\u0001-\u0011\u0001dR3o_6L7MU3hS>t\u0007+\u0019:uSRLwN\\3s\u0015\t\u0019A!A\u0002sI\u0012T!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u00011C\u0001\u0001\r!\ti!#D\u0001\u000f\u0015\ty\u0001#A\u0003ta\u0006\u00148N\u0003\u0002\u0012\u0011\u00051\u0011\r]1dQ\u0016L!a\u0005\b\u0003\u0017A\u000b'\u000f^5uS>tWM\u001d\u0005\t+\u0001\u0011)\u0019!C\u0001-\u0005Aa.^7QCJ$8/F\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\rIe\u000e\u001e\u0005\t=\u0001\u0011\t\u0011)A\u0005/\u0005Ia.^7QCJ$8\u000f\t\u0005\tA\u0001\u0011)\u0019!C\u0001C\u0005Q1/Z9MK:<G\u000f[:\u0016\u0003\t\u0002Ba\t\u0014\u0018S9\u0011\u0001\u0004J\u0005\u0003Ke\ta\u0001\u0015:fI\u00164\u0017BA\u0014)\u0005\ri\u0015\r\u001d\u0006\u0003Ke\u0001\"\u0001\u0007\u0016\n\u0005-J\"\u0001\u0002'p]\u001eD\u0001\"\f\u0001\u0003\u0002\u0003\u0006IAI\u0001\fg\u0016\fH*\u001a8hi\"\u001c\b\u0005C\u00030\u0001\u0011\u0005\u0001'\u0001\u0004=S:LGO\u0010\u000b\u0004cM\"\u0004C\u0001\u001a\u0001\u001b\u0005\u0011\u0001\"B\u000b/\u0001\u00049\u0002\"\u0002\u0011/\u0001\u0004\u0011\u0003\"B\u0018\u0001\t\u00031DcA\u00198q!)Q#\u000ea\u0001/!)\u0011(\u000ea\u0001u\u000591/Z9ES\u000e$\bCA\u001e?\u001b\u0005a$BA\u001f\u0005\u0003\u0019iw\u000eZ3mg&\u0011q\b\u0010\u0002\u0013'\u0016\fX/\u001a8dK\u0012K7\r^5p]\u0006\u0014\u0018\u0010C\u0004B\u0001\t\u0007I\u0011\u0001\"\u0002\u0007%$7/F\u0001D!\r!Ej\u0006\b\u0003\u000b*s!AR%\u000e\u0003\u001dS!\u0001\u0013\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0012BA&\u001a\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0014(\u0003\u0007M+\u0017O\u0003\u0002L3!1\u0001\u000b\u0001Q\u0001\n\r\u000bA!\u001b3tA!9!\u000b\u0001b\u0001\n\u0003\u0019\u0016a\u00027f]\u001e$\bn]\u000b\u0002)B\u0019A\tT\u0015\t\rY\u0003\u0001\u0015!\u0003U\u0003!aWM\\4uQN\u0004\u0003b\u0002-\u0001\u0005\u0004%IaU\u0001\u0007GVlW\u000f\\:\t\ri\u0003\u0001\u0015!\u0003U\u0003\u001d\u0019W/\\;mg\u0002Bq\u0001\u0018\u0001C\u0002\u0013\u0005Q,A\u0006u_R\fG\u000eT3oORDW#A\u0015\t\r}\u0003\u0001\u0015!\u0003*\u00031!x\u000e^1m\u0019\u0016tw\r\u001e5!\u0011\u001d\t\u0007A1A\u0005\u0002\u0005\n\u0011cY;nk2\fG/\u001b<f\u0019\u0016tw\r\u001e5t\u0011\u0019\u0019\u0007\u0001)A\u0005E\u0005\u00112-^7vY\u0006$\u0018N^3MK:<G\u000f[:!\u0011\u001d)\u0007A1A\u0005\nY\tQ\u0001]1siNDaa\u001a\u0001!\u0002\u00139\u0012A\u00029beR\u001c\b\u0005C\u0003j\u0001\u0011\u0005c#A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0005\u0006W\u0002!\t\u0005\\\u0001\rO\u0016$\b+\u0019:uSRLwN\u001c\u000b\u0003/5DQA\u001c6A\u0002=\f1a[3z!\tA\u0002/\u0003\u0002r3\t\u0019\u0011I\\=\t\u000bM\u0004A\u0011\t;\u0002\r\u0015\fX/\u00197t)\t)\b\u0010\u0005\u0002\u0019m&\u0011q/\u0007\u0002\b\u0005>|G.Z1o\u0011\u0015I(\u000f1\u0001p\u0003\u0005A\b\"B>\u0001\t\u0003b\u0018\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003]9QA \u0002\t\u0002}\f\u0001dR3o_6L7MU3hS>t\u0007+\u0019:uSRLwN\\3s!\r\u0011\u0014\u0011\u0001\u0004\u0007\u0003\tA\t!a\u0001\u0014\r\u0005\u0005\u0011QAA\u0006!\rA\u0012qA\u0005\u0004\u0003\u0013I\"AB!osJ+g\rE\u0002\u0019\u0003\u001bI1!a\u0004\u001a\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001dy\u0013\u0011\u0001C\u0001\u0003'!\u0012a \u0005\t\u0003/\t\t\u0001\"\u0001\u0002\u001a\u0005)\u0011\r\u001d9msR)\u0011'a\u0007\u0002 !9\u0011QDA\u000b\u0001\u00049\u0012!\u0001(\t\rI\u000b)\u00021\u0001#\u0011!\t\u0019#!\u0001\u0005\u0002\u0005\u0015\u0012\u0001E3yiJ\f7\r\u001e'f]\u001e$\b.T1q)\r\u0011\u0013q\u0005\u0005\u0007s\u0005\u0005\u0002\u0019\u0001\u001e\t\u0015\u0005-\u0012\u0011AA\u0001\n\u0013\ti#A\u0006sK\u0006$'+Z:pYZ,GCAA\u0018!\u0011\t\t$a\u000f\u000e\u0005\u0005M\"\u0002BA\u001b\u0003o\tA\u0001\\1oO*\u0011\u0011\u0011H\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002>\u0005M\"AB(cU\u0016\u001cG\u000f")
public class GenomicRegionPartitioner
extends Partitioner {
    private final int numParts;
    private final Map<Object, Object> seqLengths;
    private final Seq<Object> ids;
    private final Seq<Object> lengths;
    private final Seq<Object> cumuls;
    private final long totalLength;
    private final Map<Object, Object> cumulativeLengths;
    private final int parts;

    public static Map<Object, Object> extractLengthMap(SequenceDictionary sequenceDictionary) {
        return GenomicRegionPartitioner$.MODULE$.extractLengthMap(sequenceDictionary);
    }

    public static GenomicRegionPartitioner apply(int n, Map<Object, Object> map) {
        return GenomicRegionPartitioner$.MODULE$.apply(n, map);
    }

    public int numParts() {
        return this.numParts;
    }

    public Map<Object, Object> seqLengths() {
        return this.seqLengths;
    }

    public Seq<Object> ids() {
        return this.ids;
    }

    public Seq<Object> lengths() {
        return this.lengths;
    }

    private Seq<Object> cumuls() {
        return this.cumuls;
    }

    public long totalLength() {
        return this.totalLength;
    }

    public Map<Object, Object> cumulativeLengths() {
        return this.cumulativeLengths;
    }

    private int parts() {
        return this.parts;
    }

    public int numPartitions() {
        return this.parts() + 1;
    }

    public int getPartition(Object key) {
        block4: {
            int n;
            block3: {
                block2: {
                    ReferencePosition referencePosition = ReferencePosition$.MODULE$.UNMAPPED();
                    if (referencePosition != null ? !((Object)referencePosition).equals(key) : key != null) break block2;
                    n = this.parts();
                    break block3;
                }
                if (!(key instanceof ReferencePosition)) break block4;
                ReferencePosition referencePosition = (ReferencePosition)key;
                n = this.getPart$1(referencePosition.refId(), referencePosition.pos());
            }
            return n;
        }
        throw new IllegalArgumentException("Only ReferencePosition values can be partitioned by GenomicRegionPartitioner");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x) {
        if (!(x instanceof GenomicRegionPartitioner)) return false;
        GenomicRegionPartitioner genomicRegionPartitioner = (GenomicRegionPartitioner)((Object)x);
        if (genomicRegionPartitioner.numPartitions() != this.numPartitions()) return false;
        Seq<Object> seq = this.ids();
        Seq<Object> seq2 = genomicRegionPartitioner.ids();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        Seq<Object> seq3 = this.lengths();
        Seq<Object> seq4 = genomicRegionPartitioner.lengths();
        if (seq3 == null) {
            if (seq4 == null) return true;
            return false;
        } else {
            if (!seq3.equals(seq4)) return false;
            return true;
        }
    }

    public int hashCode() {
        return 37 * (37 * this.parts() + this.ids().hashCode()) + this.lengths().hashCode();
    }

    private final int getPart$1(int refId, long pos) {
        long totalOffset = BoxesRunTime.unboxToLong((Object)this.cumulativeLengths().apply((Object)BoxesRunTime.boxToInteger((int)refId))) + pos;
        double totalFraction = (double)totalOffset / (double)this.totalLength();
        return (int)package$.MODULE$.floor(totalFraction * (double)this.parts());
    }

    public GenomicRegionPartitioner(int numParts, Map<Object, Object> seqLengths) {
        this.numParts = numParts;
        this.seqLengths = seqLengths;
        this.ids = (Seq)seqLengths.keys().toSeq().sortWith((Function2)new $anonfun$1(this));
        this.lengths = (Seq)this.ids().map((Function1)new $anonfun$2(this), Seq$.MODULE$.canBuildFrom());
        this.cumuls = (Seq)this.lengths().scan((Object)BoxesRunTime.boxToLong((long)0L), (Function2)new $anonfun$3(this), Seq$.MODULE$.canBuildFrom());
        this.totalLength = BoxesRunTime.unboxToLong((Object)this.lengths().reduce((Function2)new $anonfun$4(this)));
        this.cumulativeLengths = (Map)Predef$.MODULE$.Map().apply((Seq)this.ids().zip(this.cumuls(), Seq$.MODULE$.canBuildFrom()));
        this.parts = (int)package$.MODULE$.min((long)numParts, this.totalLength());
    }

    public GenomicRegionPartitioner(int numParts, SequenceDictionary seqDict) {
        this(numParts, GenomicRegionPartitioner$.MODULE$.extractLengthMap(seqDict));
    }
}

