/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.recalibration;

import org.bdgenomics.adam.rdd.recalibration.Observation$;
import org.bdgenomics.adam.util.QualityScore;
import org.bdgenomics.adam.util.QualityScore$;
import org.bdgenomics.adam.util.Util$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\u0001\u0003\u00015\u00111b\u00142tKJ4\u0018\r^5p]*\u00111\u0001B\u0001\u000ee\u0016\u001c\u0017\r\\5ce\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011a\u0001:eI*\u0011q\u0001C\u0001\u0005C\u0012\fWN\u0003\u0002\n\u0015\u0005Q!\rZ4f]>l\u0017nY:\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011q\"F\u0005\u0003-A\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\u0002\u0007\u0001\u0003\u0006\u0004%\t!G\u0001\u0006i>$\u0018\r\\\u000b\u00025A\u0011qbG\u0005\u00039A\u0011A\u0001T8oO\"Aa\u0004\u0001B\u0001B\u0003%!$\u0001\u0004u_R\fG\u000e\t\u0005\tA\u0001\u0011)\u0019!C\u00013\u0005QQ.[:nCR\u001c\u0007.Z:\t\u0011\t\u0002!\u0011!Q\u0001\ni\t1\"\\5t[\u0006$8\r[3tA!)A\u0005\u0001C\u0001K\u00051A(\u001b8jiz\"2A\n\u0015*!\t9\u0003!D\u0001\u0003\u0011\u0015A2\u00051\u0001\u001b\u0011\u0015\u00013\u00051\u0001\u001b\u0011\u001dY\u0003A1A\u0005\u00021\n1\"Z7vY\u0006$XmR!U\u0017V\tQ\u0006\u0005\u0002\u0010]%\u0011q\u0006\u0005\u0002\b\u0005>|G.Z1o\u0011\u0019\t\u0004\u0001)A\u0005[\u0005aQ-\\;mCR,w)\u0011+LA!)A\u0005\u0001C\u0001gQ\u0011a\u0005\u000e\u0005\u0006kI\u0002\rAJ\u0001\u0005i\"\fG\u000fC\u00038\u0001\u0011\u0005\u0001(A\u0003%a2,8\u000f\u0006\u0002's!)QG\u000ea\u0001M!)1\b\u0001C\u0001y\u0005IR-\u001c9je&\u001c\u0017\r\\#se>\u0014\bK]8cC\nLG.\u001b;z+\u0005i\u0004CA\b?\u0013\ty\u0004C\u0001\u0004E_V\u0014G.\u001a\u0005\u0006\u0003\u0002!\tAQ\u0001\u0011K6\u0004\u0018N]5dC2\fV/\u00197jif,\u0012a\u0011\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\r\u001a\tA!\u001e;jY&\u0011\u0001*\u0012\u0002\r#V\fG.\u001b;z'\u000e|'/\u001a\u0005\u0006\u0015\u0002!\t\u0001P\u0001\u0019E\u0006LXm]5b]\u0016\u0013(o\u001c:Qe>\u0014\u0017MY5mSRL\b\"\u0002&\u0001\t\u0003aEcA\u001fN\u001f\")aj\u0013a\u0001{\u0005\t\u0011\rC\u0003Q\u0017\u0002\u0007Q(A\u0001c\u0011\u0015\u0011\u0006\u0001\"\u0001=\u0003Q9\u0017\r^6FeJ|'\u000f\u0015:pE\u0006\u0014\u0017\u000e\\5us\")!\u000b\u0001C\u0001)R\u0011Q(\u0016\u0005\u0006-N\u0003\r!P\u0001\ng6|w\u000e\u001e5j]\u001eDQ\u0001\u0017\u0001\u0005\u0002e\u000bQ\u0001^8D'Z+\u0012A\u0017\t\u00047\u000e4gB\u0001/b\u001d\ti\u0006-D\u0001_\u0015\tyF\"\u0001\u0004=e>|GOP\u0005\u0002#%\u0011!\rE\u0001\ba\u0006\u001c7.Y4f\u0013\t!WMA\u0002TKFT!A\u0019\t\u0011\u0005\u001dTgBA\bi\u0013\tI\u0007#\u0001\u0004Qe\u0016$WMZ\u0005\u0003W2\u0014aa\u0015;sS:<'BA5\u0011\u0011\u0015q\u0007\u0001\"\u0001C\u0003Y)W\u000e]5sS\u000e\fG.U;bY&$\u0018PR8s\u0007N3\u0006\"\u00029\u0001\t\u0003\n\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\u0019DQa\u001d\u0001\u0005BQ\fa!Z9vC2\u001cHCA\u0017v\u0011\u00151(\u000f1\u0001x\u0003\u0015yG\u000f[3s!\ty\u00010\u0003\u0002z!\t\u0019\u0011I\\=\t\u000bm\u0004A\u0011\t?\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012! \t\u0003\u001fyL!a \t\u0003\u0007%sGoB\u0004\u0002\u0004\tA\t!!\u0002\u0002\u0017=\u00137/\u001a:wCRLwN\u001c\t\u0004O\u0005\u001daAB\u0001\u0003\u0011\u0003\tIa\u0005\u0003\u0002\b9!\u0002b\u0002\u0013\u0002\b\u0011\u0005\u0011Q\u0002\u000b\u0003\u0003\u000bA!\"!\u0005\u0002\b\t\u0007I\u0011AA\n\u0003\u0015)W\u000e\u001d;z+\u00051\u0003\u0002CA\f\u0003\u000f\u0001\u000b\u0011\u0002\u0014\u0002\r\u0015l\u0007\u000f^=!\u0011!\tY\"a\u0002\u0005\u0002\u0005u\u0011!B1qa2LHc\u0001\u0014\u0002 !9\u0011\u0011EA\r\u0001\u0004i\u0013AC5t\u001b&\u001cX.\u0019;dQ\"Q\u0011QEA\u0004\u0003\u0003%I!a\n\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003S\u0001B!a\u000b\u000265\u0011\u0011Q\u0006\u0006\u0005\u0003_\t\t$\u0001\u0003mC:<'BAA\u001a\u0003\u0011Q\u0017M^1\n\t\u0005]\u0012Q\u0006\u0002\u0007\u001f\nTWm\u0019;")
public class Observation
implements Serializable {
    private final long total;
    private final long mismatches;
    private final boolean emulateGATK;

    public static Observation apply(boolean bl) {
        return Observation$.MODULE$.apply(bl);
    }

    public static Observation empty() {
        return Observation$.MODULE$.empty();
    }

    public long total() {
        return this.total;
    }

    public long mismatches() {
        return this.mismatches;
    }

    public boolean emulateGATK() {
        return this.emulateGATK;
    }

    public Observation $plus(Observation that) {
        return new Observation(this.total() + that.total(), this.mismatches() + that.mismatches());
    }

    public double empiricalErrorProbability() {
        return this.emulateGATK() ? this.gatkErrorProbability() : this.bayesianErrorProbability();
    }

    public QualityScore empiricalQuality() {
        return QualityScore$.MODULE$.fromErrorProbability(this.empiricalErrorProbability());
    }

    public double bayesianErrorProbability() {
        return this.bayesianErrorProbability(1.0, 1.0);
    }

    public double bayesianErrorProbability(double a, double b) {
        return (a + (double)this.mismatches()) / (a + b + (double)this.total());
    }

    public double gatkErrorProbability() {
        return this.gatkErrorProbability(1.0);
    }

    public double gatkErrorProbability(double smoothing) {
        double errProb = ((double)this.mismatches() + smoothing) / ((double)this.total() + smoothing);
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{QualityScore$.MODULE$.apply(50).errorProbability(), errProb + 1.0E-4}))).max((Ordering)Ordering.Double$.MODULE$));
    }

    public Seq<String> toCSV() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{((Object)BoxesRunTime.boxToLong((long)this.total())).toString(), ((Object)BoxesRunTime.boxToLong((long)this.mismatches())).toString(), ((Object)BoxesRunTime.boxToInteger((int)this.empiricalQualityForCSV().phred())).toString()}));
    }

    public QualityScore empiricalQualityForCSV() {
        return this.emulateGATK() ? QualityScore$.MODULE$.fromErrorProbability(this.gatkErrorProbability(0.0)) : this.empiricalQuality();
    }

    public String toString() {
        Predef$ predef$ = Predef$.MODULE$;
        return new StringOps("%s / %s (%s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.mismatches()), BoxesRunTime.boxToLong((long)this.total()), this.empiricalQuality()}));
    }

    public boolean equals(Object other) {
        boolean bl;
        if (other instanceof Observation) {
            Observation observation = (Observation)other;
            bl = this.total() == observation.total() && this.mismatches() == observation.mismatches();
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return Util$.MODULE$.hashCombine((Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{1666035417, ((Object)BoxesRunTime.boxToLong((long)this.total())).hashCode(), ((Object)BoxesRunTime.boxToLong((long)this.mismatches())).hashCode()}));
    }

    public Observation(long total2, long mismatches2) {
        this.total = total2;
        this.mismatches = mismatches2;
        Predef$.MODULE$.require(mismatches2 >= 0L && mismatches2 <= total2);
        this.emulateGATK = true;
    }

    public Observation(Observation that) {
        this(that.total(), that.mismatches());
    }
}

