/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.cli;

import org.apache.hadoop.mapreduce.Job;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGeneratorFromKnowns;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGeneratorFromReads;
import org.bdgenomics.adam.cli.ADAMSparkCommand;
import org.bdgenomics.adam.cli.ADAMSparkCommand$class;
import org.bdgenomics.adam.cli.Transform$;
import org.bdgenomics.adam.cli.TransformArgs;
import org.bdgenomics.adam.instrumentation.ADAMMetricsListener;
import org.bdgenomics.adam.models.SnpTable;
import org.bdgenomics.adam.models.SnpTable$;
import org.bdgenomics.adam.models.VariantContext;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMSaveAnyArgs;
import org.bdgenomics.adam.rdd.read.AlignmentRecordContext$;
import org.bdgenomics.adam.rdd.variation.VariationContext;
import org.bdgenomics.adam.rdd.variation.VariationContext$;
import org.bdgenomics.adam.rich.RichVariant;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dq!B\u0001\u0003\u0011\u0003Y\u0011!\u0003+sC:\u001chm\u001c:n\u0015\t\u0019A!A\u0002dY&T!!\u0002\u0004\u0002\t\u0005$\u0017-\u001c\u0006\u0003\u000f!\t!B\u00193hK:|W.[2t\u0015\u0005I\u0011aA8sO\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!!\u0003+sC:\u001chm\u001c:n'\ri\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u000519\u0012B\u0001\r\u0003\u0005Q\tE)Q'D_6l\u0017M\u001c3D_6\u0004\u0018M\\5p]\")!$\u0004C\u00017\u00051A(\u001b8jiz\"\u0012a\u0003\u0005\b;5\u0011\r\u0011\"\u0001\u001f\u0003-\u0019w.\\7b]\u0012t\u0015-\\3\u0016\u0003}\u0001\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\t1\fgn\u001a\u0006\u0002I\u0005!!.\u0019<b\u0013\t1\u0013E\u0001\u0004TiJLgn\u001a\u0005\u0007Q5\u0001\u000b\u0011B\u0010\u0002\u0019\r|W.\\1oI:\u000bW.\u001a\u0011\t\u000f)j!\u0019!C\u0001=\u0005\u00112m\\7nC:$G)Z:de&\u0004H/[8o\u0011\u0019aS\u0002)A\u0005?\u0005\u00192m\\7nC:$G)Z:de&\u0004H/[8oA!)a&\u0004C\u0001_\u0005)\u0011\r\u001d9msR\u0011\u0001\u0007\u001f\t\u0003\u0019E2AA\u0004\u0002\u0001eM!\u0011g\r\u001c=!\t\u0001C'\u0003\u00026C\t1qJ\u00196fGR\u00042\u0001D\u001c:\u0013\tA$A\u0001\tB\t\u0006k5\u000b]1sW\u000e{W.\\1oIB\u0011ABO\u0005\u0003w\t\u0011Q\u0002\u0016:b]N4wN]7Be\u001e\u001c\bCA\u001fC\u001b\u0005q$BA A\u0003\u0015\u0019\b/\u0019:l\u0015\t\t\u0005\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003\u0007z\u0012q\u0001T8hO&tw\r\u0003\u0005Fc\t\u0015\r\u0011\"\u0005G\u0003\u0011\t'oZ:\u0016\u0003eB\u0001\u0002S\u0019\u0003\u0002\u0003\u0006I!O\u0001\u0006CJ<7\u000f\t\u0005\u00065E\"\tA\u0013\u000b\u0003a-CQ!R%A\u0002eBq!T\u0019C\u0002\u0013\u0005a*A\u0005d_6\u0004\u0018M\\5p]V\tqJ\u0004\u0002\r\u0001!1\u0011+\rQ\u0001\n=\u000b!bY8na\u0006t\u0017n\u001c8!\u0011\u0015q\u0013\u0007\"\u0001T)\t!&\rE\u0002V1jk\u0011A\u0016\u0006\u0003/z\n1A\u001d3e\u0013\tIfKA\u0002S\t\u0012\u0003\"a\u00171\u000e\u0003qS!!\u00180\u0002\t\u00054(o\u001c\u0006\u0003?\u001a\tqAZ8s[\u0006$8/\u0003\u0002b9\ny\u0011\t\\5h]6,g\u000e\u001e*fG>\u0014H\rC\u0003X%\u0002\u0007A\u000bC\u0003ec\u0011\u0005Q-A\u0002sk:$2AZ5o!\t\tr-\u0003\u0002i%\t!QK\\5u\u0011\u0015Q7\r1\u0001l\u0003\t\u00198\r\u0005\u0002>Y&\u0011QN\u0010\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\u0006_\u000e\u0004\r\u0001]\u0001\u0004U>\u0014\u0007CA9w\u001b\u0005\u0011(BA:u\u0003%i\u0017\r\u001d:fIV\u001cWM\u0003\u0002v\u0001\u00061\u0001.\u00193p_BL!a\u001e:\u0003\u0007){'\rC\u0003z[\u0001\u0007!0A\u0004d[\u0012d\u0015N\\3\u0011\u0007EYX0\u0003\u0002}%\t)\u0011I\u001d:bsB\u0019a0a\u0001\u000f\u0005Ey\u0018bAA\u0001%\u00051\u0001K]3eK\u001aL1AJA\u0003\u0015\r\t\tA\u0005")
public class Transform
implements ADAMSparkCommand<TransformArgs>,
Logging {
    private final TransformArgs args;
    private final Transform$ companion;
    private transient Logger org$apache$spark$Logging$$log_;

    public static void main(String[] stringArray) {
        Transform$.MODULE$.main(stringArray);
    }

    public static String commandDescription() {
        return Transform$.MODULE$.commandDescription();
    }

    public static String commandName() {
        return Transform$.MODULE$.commandName();
    }

    @Override
    public void run() {
        ADAMSparkCommand$class.run(this);
    }

    @Override
    public void printMetrics(long totalTime, Option<ADAMMetricsListener> metricsListener) {
        ADAMSparkCommand$class.printMetrics(this, totalTime, metricsListener);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    @Override
    public TransformArgs args() {
        return this.args;
    }

    @Override
    public Transform$ companion() {
        return this.companion;
    }

    /*
     * WARNING - void declaration
     */
    public RDD<AlignmentRecord> apply(RDD<AlignmentRecord> rdd) {
        void var2_2;
        RDD adamRecords = rdd;
        SparkContext sc = rdd.context();
        if (this.args().repartition() != -1) {
            this.log().info(new StringOps(Predef$.MODULE$.augmentString("Repartitioning reads to to '%d' partitions")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.args().repartition())})));
            RDD qual$1 = adamRecords;
            int x$3 = this.args().repartition();
            Ordering x$4 = qual$1.repartition$default$2(x$3);
            adamRecords = qual$1.repartition(x$3, x$4);
        }
        if (this.args().trimReads()) {
            this.log().info("Trimming reads.");
            adamRecords = AlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(adamRecords).adamTrimReads(this.args().trimStart(), this.args().trimEnd(), this.args().trimReadGroup());
        }
        if (this.args().qualityBasedTrim() && this.args().trimBeforeBQSR()) {
            this.log().info("Applying quality based trim.");
            adamRecords = AlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(adamRecords).adamTrimLowQualityReadGroups(this.args().qualityThreshold());
        }
        if (this.args().markDuplicates()) {
            this.log().info("Marking duplicates");
            adamRecords = AlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(adamRecords).adamMarkDuplicates();
        }
        if (this.args().locallyRealign()) {
            this.log().info("Locally realigning indels.");
            ConsensusGenerator consensusGenerator = (ConsensusGenerator)Option$.MODULE$.apply((Object)this.args().knownIndelsFile()).fold((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ConsensusGenerator apply() {
                    return new ConsensusGeneratorFromReads();
                }
            }, (Function1)new Serializable(this, sc){
                public static final long serialVersionUID = 0L;
                private final SparkContext sc$1;

                public final ConsensusGenerator apply(String x$1) {
                    return new ConsensusGeneratorFromKnowns(x$1, this.sc$1);
                }
                {
                    this.sc$1 = sc$1;
                }
            });
            adamRecords = AlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(adamRecords).adamRealignIndels(consensusGenerator, false, this.args().maxIndelSize(), this.args().maxConsensusNumber(), this.args().lodThreshold(), this.args().maxTargetSize());
        }
        if (this.args().recalibrateBaseQualities()) {
            this.log().info("Recalibrating base qualities");
            VariationContext qual$2 = VariationContext$.MODULE$.sparkContextToVariationContext(sc);
            String x$5 = this.args().knownSnpsFile();
            Option x$6 = qual$2.adamVCFLoad$default$2();
            RDD variants = qual$2.adamVCFLoad(x$5, x$6).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final RichVariant apply(VariantContext x$2) {
                    return x$2.variant();
                }
            }, ClassTag$.MODULE$.apply(RichVariant.class));
            SnpTable knownSnps = SnpTable$.MODULE$.apply(variants);
            adamRecords = AlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(adamRecords).adamBQSR(sc.broadcast((Object)knownSnps, ClassTag$.MODULE$.apply(SnpTable.class)), Option$.MODULE$.apply((Object)this.args().observationsPath()));
        }
        if (this.args().qualityBasedTrim() && !this.args().trimBeforeBQSR()) {
            this.log().info("Applying quality based trim.");
            adamRecords = AlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(adamRecords).adamTrimLowQualityReadGroups(this.args().qualityThreshold());
        }
        if (this.args().coalesce() != -1) {
            this.log().info(new StringOps(Predef$.MODULE$.augmentString("Coalescing the number of partitions to '%d'")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.args().coalesce())})));
            RDD qual$3 = adamRecords;
            int x$7 = this.args().coalesce();
            boolean x$8 = true;
            Ordering x$9 = qual$3.coalesce$default$3(x$7, x$8);
            adamRecords = qual$3.coalesce(x$7, x$8, x$9);
        }
        if (this.args().sortReads()) {
            this.log().info("Sorting reads");
            adamRecords = AlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(adamRecords).adamSortReadsByReferencePosition();
        }
        return var2_2;
    }

    @Override
    public void run(SparkContext sc, Job job) {
        ADAMContext qual$4 = ADAMContext$.MODULE$.sparkContextToADAMContext(sc);
        String x$10 = this.args().inputPath();
        None$ x$11 = qual$4.loadAlignments$default$2();
        Option x$12 = qual$4.loadAlignments$default$3();
        AlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(this.apply((RDD<AlignmentRecord>)qual$4.loadAlignments(x$10, (Option)x$11, x$12))).adamSave((ADAMSaveAnyArgs)this.args());
    }

    public Transform(TransformArgs args) {
        this.args = args;
        Logging.class.$init$((Logging)this);
        ADAMSparkCommand$class.$init$(this);
        this.companion = Transform$.MODULE$;
    }
}

