/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.instrumentation;

import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;

public final class DurationFormatting$ {
    public static final DurationFormatting$ MODULE$;
    private final DecimalFormat TwoDigitNumberFormatter;

    static {
        new DurationFormatting$();
    }

    private DecimalFormat TwoDigitNumberFormatter() {
        return this.TwoDigitNumberFormatter;
    }

    public String formatMillisecondDuration(Number number) {
        Serializable conversion = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(long x$1) {
                return this.apply$mcJJ$sp(x$1);
            }

            public long apply$mcJJ$sp(long x$1) {
                return TimeUnit.MILLISECONDS.toNanos(x$1);
            }
        };
        return this.formatNumber(number, (Function1<Object, Object>)conversion);
    }

    public String formatNanosecondDuration(Number number) {
        Serializable conversion = new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(long x$1) {
                return this.apply$mcJJ$sp(x$1);
            }

            public long apply$mcJJ$sp(long x$1) {
                return TimeUnit.NANOSECONDS.toNanos(x$1);
            }
        };
        return this.formatNumber(number, (Function1<Object, Object>)conversion);
    }

    public String formatDuration(Duration duration) {
        StringBuilder stringBuilder;
        BoxedUnit boxedUnit;
        long nanoDuration = duration.toNanos();
        if (nanoDuration < 0L) {
            throw new IllegalArgumentException("Duration must be greater or equal to zero!");
        }
        long hours = TimeUnit.NANOSECONDS.toHours(nanoDuration);
        long minutes = TimeUnit.NANOSECONDS.toMinutes(nanoDuration -= TimeUnit.HOURS.toNanos(hours));
        long seconds = TimeUnit.NANOSECONDS.toSeconds(nanoDuration -= TimeUnit.MINUTES.toNanos(minutes));
        long millis = TimeUnit.NANOSECONDS.toMillis(nanoDuration -= TimeUnit.SECONDS.toNanos(seconds));
        long micros = TimeUnit.NANOSECONDS.toMicros(nanoDuration -= TimeUnit.MILLISECONDS.toNanos(millis));
        long nanos = nanoDuration -= TimeUnit.MICROSECONDS.toNanos(micros);
        StringBuilder builder = new StringBuilder();
        if (hours > 0L) {
            builder.append(hours);
            boxedUnit = builder.append(" hour").append(hours != 1L ? "s" : "");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (minutes > 0L || hours > 0L) {
            Object object = hours > 0L ? builder.append(" ") : BoxedUnit.UNIT;
            builder.append(minutes);
            builder.append(" min").append(minutes != 1L ? "s" : "");
            builder.append(" ");
            builder.append(seconds);
            stringBuilder = builder.append(" sec").append(seconds != 1L ? "s" : "");
        } else if (seconds > 0L) {
            this.formatValue(seconds, millis, builder);
            stringBuilder = builder.append(" secs");
        } else if (millis > 0L) {
            this.formatValue(millis, micros, builder);
            stringBuilder = builder.append(" ms");
        } else if (micros > 0L) {
            this.formatValue(micros, nanos, builder);
            stringBuilder = builder.append(" \u00b5s");
        } else if (nanos > 0L) {
            builder.append(nanos);
            stringBuilder = builder.append(" ns");
        } else {
            stringBuilder = builder.append("0");
        }
        return builder.toString();
    }

    private void formatValue(long largeValue, long smallValue, StringBuilder builder) {
        double totalValue = (double)largeValue + (double)smallValue / 1000.0;
        String stringValue2 = this.TwoDigitNumberFormatter().format(totalValue);
        if (stringValue2.endsWith(".0")) {
            builder.append(stringValue2.substring(0, stringValue2.length() - ".0".length()));
        } else {
            builder.append(stringValue2);
        }
    }

    private String formatNumber(Number number, Function1<Object, Object> conversionFunction) {
        return this.formatDuration((Duration)Duration$.MODULE$.fromNanos(conversionFunction.apply$mcJJ$sp(number.longValue())));
    }

    private DurationFormatting$() {
        MODULE$ = this;
        this.TwoDigitNumberFormatter = new DecimalFormat(".0#");
    }
}

