/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.models;

import org.bdgenomics.adam.models.Interval;
import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferenceRegion$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.formats.avro.Feature;
import org.bdgenomics.formats.avro.NucleotideContigFragment;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.math.Ordered;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t\rq!B\u0001\u0003\u0011\u0003Y\u0011a\u0004*fM\u0016\u0014XM\\2f%\u0016<\u0017n\u001c8\u000b\u0005\r!\u0011AB7pI\u0016d7O\u0003\u0002\u0006\r\u0005!\u0011\rZ1n\u0015\t9\u0001\"\u0001\u0006cI\u001e,gn\\7jGNT\u0011!C\u0001\u0004_J<7\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\u0010%\u00164WM]3oG\u0016\u0014VmZ5p]N\u0019Q\u0002\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t\tr#\u0003\u0002\u0019%\ta1+\u001a:jC2L'0\u00192mK\")!$\u0004C\u00017\u00051A(\u001b8jiz\"\u0012a\u0003\u0005\u0006;5!\tAH\u0001\u0006CB\u0004H.\u001f\u000b\u0004?\u0005\r\u0006cA\t!E%\u0011\u0011E\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00051\u0019c\u0001\u0002\b\u0003\u0001\u0012\u001aba\t\t&cQ2\u0002c\u0001\u0014/E9\u0011q\u0005\f\b\u0003Q-j\u0011!\u000b\u0006\u0003U)\ta\u0001\u0010:p_Rt\u0014\"A\n\n\u00055\u0012\u0012a\u00029bG.\fw-Z\u0005\u0003_A\u0012qa\u0014:eKJ,GM\u0003\u0002.%A\u0011ABM\u0005\u0003g\t\u0011\u0001\"\u00138uKJ4\u0018\r\u001c\t\u0003#UJ!A\u000e\n\u0003\u000fA\u0013x\u000eZ;di\"A\u0001h\tBK\u0002\u0013\u0005\u0011(A\u0007sK\u001a,'/\u001a8dK:\u000bW.Z\u000b\u0002uA\u00111H\u0010\b\u0003#qJ!!\u0010\n\u0002\rA\u0013X\rZ3g\u0013\ty\u0004I\u0001\u0004TiJLgn\u001a\u0006\u0003{IA\u0001BQ\u0012\u0003\u0012\u0003\u0006IAO\u0001\u000fe\u00164WM]3oG\u0016t\u0015-\\3!\u0011!!5E!f\u0001\n\u0003)\u0015!B:uCJ$X#\u0001$\u0011\u0005E9\u0015B\u0001%\u0013\u0005\u0011auN\\4\t\u0011)\u001b#\u0011#Q\u0001\n\u0019\u000baa\u001d;beR\u0004\u0003\u0002\u0003'$\u0005+\u0007I\u0011A#\u0002\u0007\u0015tG\r\u0003\u0005OG\tE\t\u0015!\u0003G\u0003\u0011)g\u000e\u001a\u0011\t\u000bi\u0019C\u0011\u0001)\u0015\t\t\n&k\u0015\u0005\u0006q=\u0003\rA\u000f\u0005\u0006\t>\u0003\rA\u0012\u0005\u0006\u0019>\u0003\rA\u0012\u0005\u0006+\u000e\"\t!R\u0001\u0006o&$G\u000f\u001b\u0005\u0006/\u000e\"\t\u0001W\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0003EeCQA\u0017,A\u0002\t\naA]3hS>t\u0007\"\u0002/$\t\u0003i\u0016\u0001D5oi\u0016\u00148/Z2uS>tGC\u0001\u0012_\u0011\u0015Q6\f1\u0001#\u0011\u0015\u00017\u0005\"\u0001b\u0003\u0011AW\u000f\u001c7\u0015\u0005\t\u0012\u0007\"\u0002.`\u0001\u0004\u0011\u0003\"\u00023$\t\u0003)\u0017AC5t\u0003\u0012T\u0017mY3oiR\u0011a-\u001b\t\u0003#\u001dL!\u0001\u001b\n\u0003\u000f\t{w\u000e\\3b]\")!l\u0019a\u0001E!)1n\tC\u0001Y\u0006AA-[:uC:\u001cW\r\u0006\u0002n]B\u0019\u0011\u0003\t$\t\u000b=T\u0007\u0019\u00019\u0002\u000b=$\b.\u001a:\u0011\u00051\t\u0018B\u0001:\u0003\u0005E\u0011VMZ3sK:\u001cW\rU8tSRLwN\u001c\u0005\u0006W\u000e\"\t\u0001\u001e\u000b\u0003[VDQa\\:A\u0002\tBQa^\u0012\u0005\u0002a\f\u0001bY8oi\u0006Lgn\u001d\u000b\u0003MfDQa\u001c<A\u0002ADQa^\u0012\u0005\u0002m$\"A\u001a?\t\u000b=T\b\u0019\u0001\u0012\t\u000by\u001cC\u0011A@\u0002\u0011=4XM\u001d7baN$2AZA\u0001\u0011\u0015yW\u00101\u0001#\u0011\u001d\t)a\tC\u0001\u0003\u000f\tqaY8na\u0006\u0014X\r\u0006\u0003\u0002\n\u0005=\u0001cA\t\u0002\f%\u0019\u0011Q\u0002\n\u0003\u0007%sG\u000fC\u0004\u0002\u0012\u0005\r\u0001\u0019\u0001\u0012\u0002\tQD\u0017\r\u001e\u0005\b\u0003+\u0019C\u0011AA\f\u0003\u0019aWM\\4uQR\ta\tC\u0005\u0002\u001c\r\n\t\u0011\"\u0001\u0002\u001e\u0005!1m\u001c9z)\u001d\u0011\u0013qDA\u0011\u0003GA\u0001\u0002OA\r!\u0003\u0005\rA\u000f\u0005\t\t\u0006e\u0001\u0013!a\u0001\r\"AA*!\u0007\u0011\u0002\u0003\u0007a\tC\u0005\u0002(\r\n\n\u0011\"\u0001\u0002*\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0016U\rQ\u0014QF\u0016\u0003\u0003_\u0001B!!\r\u0002<5\u0011\u00111\u0007\u0006\u0005\u0003k\t9$A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\b\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002>\u0005M\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011\u0011I\u0012\u0012\u0002\u0013\u0005\u00111I\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\t)EK\u0002G\u0003[A\u0011\"!\u0013$#\u0003%\t!a\u0011\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g!I\u0011QJ\u0012\u0002\u0002\u0013\u0005\u0013qJ\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005E\u0003\u0003BA*\u0003;j!!!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\u0005Y\u0006twM\u0003\u0002\u0002\\\u0005!!.\u0019<b\u0013\ry\u0014Q\u000b\u0005\n\u0003C\u001a\u0013\u0011!C\u0001\u0003G\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0003\t\u0013\u0005\u001d4%!A\u0005\u0002\u0005%\u0014A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003W\n\t\bE\u0002\u0012\u0003[J1!a\u001c\u0013\u0005\r\te.\u001f\u0005\u000b\u0003g\n)'!AA\u0002\u0005%\u0011a\u0001=%c!I\u0011qO\u0012\u0002\u0002\u0013\u0005\u0013\u0011P\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u0010\t\u0007\u0003{\n\u0019)a\u001b\u000e\u0005\u0005}$bAAA%\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\u0015\u0015q\u0010\u0002\t\u0013R,'/\u0019;pe\"I\u0011\u0011R\u0012\u0002\u0002\u0013\u0005\u00111R\u0001\tG\u0006tW)];bYR\u0019a-!$\t\u0015\u0005M\u0014qQA\u0001\u0002\u0004\tY\u0007C\u0005\u0002\u0012\u000e\n\t\u0011\"\u0011\u0002\u0014\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\n!I\u0011qS\u0012\u0002\u0002\u0013\u0005\u0013\u0011T\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011\u000b\u0005\n\u0003;\u001b\u0013\u0011!C!\u0003?\u000ba!Z9vC2\u001cHc\u00014\u0002\"\"Q\u00111OAN\u0003\u0003\u0005\r!a\u001b\t\u000f\u0005\u0015F\u00041\u0001\u0002(\u00061!/Z2pe\u0012\u0004B!!+\u000246\u0011\u00111\u0016\u0006\u0005\u0003[\u000by+\u0001\u0003bmJ|'bAAY\r\u00059am\u001c:nCR\u001c\u0018\u0002BA[\u0003W\u0013q\"\u00117jO:lWM\u001c;SK\u000e|'\u000f\u001a\u0005\u0007;5!\t!!/\u0015\u0007\t\nY\fC\u0004\u0002>\u0006]\u0006\u0019\u00019\u0002\u0007A|7\u000f\u0003\u0004\u001e\u001b\u0011\u0005\u0011\u0011\u0019\u000b\u0004?\u0005\r\u0007\u0002CAc\u0003\u007f\u0003\r!a2\u0002\u0011\u0019\u0014\u0018mZ7f]R\u0004B!!+\u0002J&!\u00111ZAV\u0005aqUo\u00197f_RLG-Z\"p]RLwM\u0012:bO6,g\u000e\u001e\u0005\u0007;5!\t!a4\u0015\u0007\t\n\t\u000e\u0003\u0005\u0002T\u00065\u0007\u0019AAk\u0003\u001d1W-\u0019;ve\u0016\u0004B!!+\u0002X&!\u0011\u0011\\AV\u0005\u001d1U-\u0019;ve\u0016D\u0001\"H\u0007\u0002\u0002\u0013\u0005\u0015Q\u001c\u000b\bE\u0005}\u0017\u0011]Ar\u0011\u0019A\u00141\u001ca\u0001u!1A)a7A\u0002\u0019Ca\u0001TAn\u0001\u00041\u0005\"CAt\u001b\u0005\u0005I\u0011QAu\u0003\u001d)h.\u00199qYf$B!a;\u0002tB!\u0011\u0003IAw!\u0019\t\u0012q\u001e\u001eG\r&\u0019\u0011\u0011\u001f\n\u0003\rQ+\b\u000f\\34\u0011%\t)0!:\u0002\u0002\u0003\u0007!%A\u0002yIAB\u0011\"!?\u000e\u0003\u0003%I!a?\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003{\u0004B!a\u0015\u0002\u0000&!!\u0011AA+\u0005\u0019y%M[3di\u0002")
public class ReferenceRegion
implements Ordered<ReferenceRegion>,
Interval,
Product,
Serializable {
    private final String referenceName;
    private final long start;
    private final long end;

    public static ReferenceRegion apply(Feature feature) {
        return ReferenceRegion$.MODULE$.apply(feature);
    }

    public static Option<ReferenceRegion> apply(NucleotideContigFragment nucleotideContigFragment) {
        return ReferenceRegion$.MODULE$.apply(nucleotideContigFragment);
    }

    public static ReferenceRegion apply(ReferencePosition referencePosition2) {
        return ReferenceRegion$.MODULE$.apply(referencePosition2);
    }

    public static Option<ReferenceRegion> apply(AlignmentRecord alignmentRecord) {
        return ReferenceRegion$.MODULE$.apply(alignmentRecord);
    }

    public boolean $less(Object that) {
        return Ordered.class.$less((Ordered)this, (Object)that);
    }

    public boolean $greater(Object that) {
        return Ordered.class.$greater((Ordered)this, (Object)that);
    }

    public boolean $less$eq(Object that) {
        return Ordered.class.$less$eq((Ordered)this, (Object)that);
    }

    public boolean $greater$eq(Object that) {
        return Ordered.class.$greater$eq((Ordered)this, (Object)that);
    }

    public int compareTo(Object that) {
        return Ordered.class.compareTo((Ordered)this, (Object)that);
    }

    public String referenceName() {
        return this.referenceName;
    }

    public long start() {
        return this.start;
    }

    public long end() {
        return this.end;
    }

    @Override
    public long width() {
        return this.end() - this.start();
    }

    public ReferenceRegion merge(ReferenceRegion region2) {
        Predef$.MODULE$.assert(this.overlaps(region2) || this.isAdjacent(region2), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cannot merge two regions that do not overlap or are not adjacent";
            }
        });
        return this.hull(region2);
    }

    public ReferenceRegion intersection(ReferenceRegion region2) {
        Predef$.MODULE$.assert(this.overlaps(region2), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cannot calculate the intersection of non-overlapping regions.";
            }
        });
        return new ReferenceRegion(this.referenceName(), package$.MODULE$.max(this.start(), region2.start()), package$.MODULE$.min(this.end(), region2.end()));
    }

    public ReferenceRegion hull(ReferenceRegion region2) {
        String string = this.referenceName();
        String string2 = region2.referenceName();
        Predef$.MODULE$.assert(!(string != null ? !string.equals(string2) : string2 != null), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Cannot compute convex hull of regions on different references.";
            }
        });
        return new ReferenceRegion(this.referenceName(), package$.MODULE$.min(this.start(), region2.start()), package$.MODULE$.max(this.end(), region2.end()));
    }

    public boolean isAdjacent(ReferenceRegion region2) {
        Option<Object> option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = this.distance(region2);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    long d = BoxesRunTime.unboxToLong((Object)some.x());
                    bl = d == 1L;
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                bl = false;
            }
            return bl;
        }
        throw new MatchError(option);
    }

    public Option<Object> distance(ReferencePosition other) {
        String string = this.referenceName();
        String string2 = other.referenceName();
        return !(string != null ? !string.equals(string2) : string2 != null) ? (other.pos() < this.start() ? new Some((Object)BoxesRunTime.boxToLong((long)(this.start() - other.pos()))) : (other.pos() >= this.end() ? new Some((Object)BoxesRunTime.boxToLong((long)(other.pos() - this.end() + 1L))) : new Some((Object)BoxesRunTime.boxToLong((long)0L)))) : None$.MODULE$;
    }

    public Option<Object> distance(ReferenceRegion other) {
        String string = this.referenceName();
        String string2 = other.referenceName();
        return !(string != null ? !string.equals(string2) : string2 != null) ? (this.overlaps(other) ? new Some((Object)BoxesRunTime.boxToLong((long)0L)) : (other.start() >= this.end() ? new Some((Object)BoxesRunTime.boxToLong((long)(other.start() - this.end() + 1L))) : new Some((Object)BoxesRunTime.boxToLong((long)(this.start() - other.end() + 1L))))) : None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(ReferencePosition other) {
        String string = this.referenceName();
        String string2 = other.referenceName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.start() > other.pos()) return false;
        if (this.end() <= other.pos()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(ReferenceRegion other) {
        String string = this.referenceName();
        String string2 = other.referenceName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.start() > other.start()) return false;
        if (this.end() < other.end()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean overlaps(ReferenceRegion other) {
        String string = this.referenceName();
        String string2 = other.referenceName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.end() <= other.start()) return false;
        if (this.start() >= other.end()) return false;
        return true;
    }

    public int compare(ReferenceRegion that) {
        String string = this.referenceName();
        String string2 = that.referenceName();
        return !(string != null ? !string.equals(string2) : string2 != null) ? (this.start() != that.start() ? Predef$.MODULE$.long2Long(this.start()).compareTo(Predef$.MODULE$.long2Long(that.start())) : Predef$.MODULE$.long2Long(this.end()).compareTo(Predef$.MODULE$.long2Long(that.end()))) : this.referenceName().compareTo(that.referenceName());
    }

    public long length() {
        return this.end() - this.start();
    }

    public ReferenceRegion copy(String referenceName, long start, long end2) {
        return new ReferenceRegion(referenceName, start, end2);
    }

    public String copy$default$1() {
        return this.referenceName();
    }

    public long copy$default$2() {
        return this.start();
    }

    public long copy$default$3() {
        return this.end();
    }

    public String productPrefix() {
        return "ReferenceRegion";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = BoxesRunTime.boxToLong((long)this.end());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToLong((long)this.start());
                break;
            }
            case 0: {
                object = this.referenceName();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ReferenceRegion;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.referenceName()));
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.start()));
        n = Statics.mix((int)n, (int)Statics.longHash((long)this.end()));
        return Statics.finalizeHash((int)n, (int)3);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ReferenceRegion)) return false;
        boolean bl = true;
        if (!bl) return false;
        ReferenceRegion referenceRegion = (ReferenceRegion)x$1;
        String string = this.referenceName();
        String string2 = referenceRegion.referenceName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.start() != referenceRegion.start()) return false;
        if (this.end() != referenceRegion.end()) return false;
        if (!referenceRegion.canEqual(this)) return false;
        return true;
    }

    public ReferenceRegion(String referenceName, long start, long end2) {
        this.referenceName = referenceName;
        this.start = start;
        this.end = end2;
        Ordered.class.$init$((Ordered)this);
        Product.class.$init$((Product)this);
        Predef$.MODULE$.assert(start >= 0L);
        Predef$.MODULE$.assert(end2 > start);
    }
}

