/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd;

import htsjdk.samtools.SAMFileHeader;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.converters.SAMRecordConverter;
import org.bdgenomics.adam.models.RecordGroupDictionary;
import org.bdgenomics.adam.models.RecordGroupDictionary$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceDictionary$;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.predicates.ADAMPredicate;
import org.bdgenomics.adam.projections.AlignmentRecordField$;
import org.bdgenomics.adam.projections.FieldValue;
import org.bdgenomics.adam.projections.NucleotideContigFragmentField$;
import org.bdgenomics.adam.projections.Projection$;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMRDDFunctions;
import org.bdgenomics.adam.rdd.read.AlignmentRecordContext$;
import org.bdgenomics.adam.rich.RichAlignmentRecord;
import org.bdgenomics.adam.util.HadoopUtil$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.formats.avro.NucleotideContigFragment;
import org.seqdoop.hadoop_bam.AnySAMInputFormat;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.util.SAMHeaderReader;
import org.slf4j.Logger;
import parquet.avro.AvroParquetInputFormat;
import parquet.avro.AvroReadSupport;
import parquet.filter.UnboundRecordFilter;
import parquet.hadoop.ParquetInputFormat;
import parquet.hadoop.util.ContextUtil;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\r5v!B\u0001\u0003\u0011\u0003Y\u0011aC!E\u00036\u001buN\u001c;fqRT!a\u0001\u0003\u0002\u0007I$GM\u0003\u0002\u0006\r\u0005!\u0011\rZ1n\u0015\t9\u0001\"\u0001\u0006cI\u001e,gn\\7jGNT\u0011!C\u0001\u0004_J<7\u0001\u0001\t\u0003\u00195i\u0011A\u0001\u0004\u0006\u001d\tA\ta\u0004\u0002\f\u0003\u0012\u000bUjQ8oi\u0016DHoE\u0002\u000e!Y\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\t\u0018\u0013\tA\"C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u001b\u001b\u0011\u00051$\u0001\u0004=S:LGO\u0010\u000b\u0002\u0017!)Q$\u0004C\u0002=\u0005I2\u000f]1sW\u000e{g\u000e^3yiR{\u0017\tR!N\u0007>tG/\u001a=u)\ry\"1\u0012\t\u0003\u0019\u00012AA\u0004\u0002\u0001CM!\u0001\u0005\u0005\f#!\t\u0019\u0003&D\u0001%\u0015\t)c%A\u0003ta\u0006\u00148N\u0003\u0002(\u0011\u00051\u0011\r]1dQ\u0016L!!\u000b\u0013\u0003\u000f1{wmZ5oO\"A1\u0006\tBC\u0002\u0013\u0005A&\u0001\u0002tGV\tQ\u0006\u0005\u0002$]%\u0011q\u0006\n\u0002\r'B\f'o[\"p]R,\u0007\u0010\u001e\u0005\tc\u0001\u0012\t\u0011)A\u0005[\u0005\u00191o\u0019\u0011\t\u000bi\u0001C\u0011A\u001a\u0015\u0005}!\u0004\"B\u00163\u0001\u0004i\u0003B\u0002\u001c!\t\u0003\u0011q'A\u000bbI\u0006l')Y7ES\u000e$\u0018n\u001c8befdu.\u00193\u0015\u0005ar\u0004CA\u001d=\u001b\u0005Q$BA\u001e\u0005\u0003\u0019iw\u000eZ3mg&\u0011QH\u000f\u0002\u0013'\u0016\fX/\u001a8dK\u0012K7\r^5p]\u0006\u0014\u0018\u0010C\u0003@k\u0001\u0007\u0001)\u0001\u0005gS2,\u0007+\u0019;i!\t\tEI\u0004\u0002\u0012\u0005&\u00111IE\u0001\u0007!J,G-\u001a4\n\u0005\u00153%AB*ue&twM\u0003\u0002D%!1a\u0007\tC\u0001\u0005!#\"\u0001O%\t\u000b);\u0005\u0019A&\u0002\u0013M\fW\u000eS3bI\u0016\u0014\bC\u0001'R\u001b\u0005i%B\u0001(P\u0003!\u0019\u0018-\u001c;p_2\u001c(\"\u0001)\u0002\r!$8O\u001b3l\u0013\t\u0011VJA\u0007T\u000363\u0015\u000e\\3IK\u0006$WM\u001d\u0005\u0007)\u0002\"\tAA+\u0002+\u0005$\u0017-\u001c\"b[2{\u0017\r\u001a*fC\u0012<%o\\;qgR\u0011a+\u0017\t\u0003s]K!\u0001\u0017\u001e\u0003+I+7m\u001c:e\u000fJ|W\u000f\u001d#jGRLwN\\1ss\")!j\u0015a\u0001\u0017\")1\f\tC\u00019\u0006A\u0011\rZ1n\u0019>\fG-\u0006\u0003^M\u0006]Ac\u00020\u0002\u0004\u0005\u0015\u0011Q\u0006\u000b\u0004?>d\bc\u00011cI6\t\u0011M\u0003\u0002\u0004I%\u00111-\u0019\u0002\u0004%\u0012#\u0005CA3g\u0019\u0001!Qa\u001a.C\u0002!\u0014\u0011\u0001V\t\u0003S2\u0004\"!\u00056\n\u0005-\u0014\"a\u0002(pi\"Lgn\u001a\t\u0003#5L!A\u001c\n\u0003\u0007\u0005s\u0017\u0010C\u0004q5\u0006\u0005\t9A9\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007\u0005\u0003\u0012e\u0012$\u0018BA:\u0013\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002vu6\taO\u0003\u0002xq\u0006A1\u000f]3dS\u001aL7M\u0003\u0002zM\u0005!\u0011M\u001e:p\u0013\tYhO\u0001\bTa\u0016\u001c\u0017NZ5d%\u0016\u001cwN\u001d3\t\u000fuT\u0016\u0011!a\u0002}\u0006QQM^5eK:\u001cW\r\n\u001b\u0011\u0007\u0005{H-C\u0002\u0002\u0002\u0019\u0013\u0001\"T1oS\u001a,7\u000f\u001e\u0005\u0006\u007fi\u0003\r\u0001\u0011\u0005\n\u0003\u000fQ\u0006\u0013!a\u0001\u0003\u0013\t\u0011\u0002\u001d:fI&\u001c\u0017\r^3\u0011\u000bE\tY!a\u0004\n\u0007\u00055!C\u0001\u0004PaRLwN\u001c\t\u0006\u0003\u0006E\u0011QC\u0005\u0004\u0003'1%!B\"mCN\u001c\bcA3\u0002\u0018\u00119\u0011\u0011\u0004.C\u0002\u0005m!!A+\u0012\u0007%\fi\u0002\u0005\u0003\u0002 \u0005%RBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\r\u0019LG\u000e^3s\u0015\t\t9#A\u0004qCJ\fX/\u001a;\n\t\u0005-\u0012\u0011\u0005\u0002\u0014+:\u0014w.\u001e8e%\u0016\u001cwN\u001d3GS2$XM\u001d\u0005\n\u0003_Q\u0006\u0013!a\u0001\u0003c\t!\u0002\u001d:pU\u0016\u001cG/[8o!\u0015\t\u00121BA\u001a!\u0011\t)$a\u000e\u000e\u0003aL1!!\u000fy\u0005\u0019\u00196\r[3nC\"9\u0011Q\b\u0011\u0005\u0002\u0005}\u0012AE1eC6$\u0015n\u0019;j_:\f'/\u001f'pC\u0012,B!!\u0011\u0002NQ!\u00111IA+)\u0015A\u0014QIA(\u0011)\t9%a\u000f\u0002\u0002\u0003\u000f\u0011\u0011J\u0001\u000bKZLG-\u001a8dK\u0012*\u0004#B\ts\u0003\u0017\"\bcA3\u0002N\u00111q-a\u000fC\u0002!D!\"!\u0015\u0002<\u0005\u0005\t9AA*\u0003))g/\u001b3f]\u000e,GE\u000e\t\u0005\u0003~\fY\u0005\u0003\u0004@\u0003w\u0001\r\u0001\u0011\u0005\b\u00033\u0002C\u0011AA.\u00039\t\u0007\u000f\u001d7z!J,G-[2bi\u0016,b!!\u0018\u0002f\u0005\u0005ECBA0\u0003g\n9\b\u0006\u0004\u0002b\u0005\u001d\u0014Q\u000e\t\u0005A\n\f\u0019\u0007E\u0002f\u0003K\"aaZA,\u0005\u0004A\u0007BCA5\u0003/\n\t\u0011q\u0001\u0002l\u0005QQM^5eK:\u001cW\rJ\u001c\u0011\u000bE\u0011\u00181\r;\t\u0015\u0005=\u0014qKA\u0001\u0002\b\t\t(\u0001\u0006fm&$WM\\2fIa\u0002B!Q@\u0002d!A\u0011QOA,\u0001\u0004\t\t'A\u0003sK\u0006$7\u000f\u0003\u0005\u0002z\u0005]\u0003\u0019AA>\u00031\u0001(/\u001a3jG\u0006$Xm\u00149u!\u0015\t\u00121BA?!\u0015\t\u0015\u0011CA@!\r)\u0017\u0011\u0011\u0003\t\u00033\t9F1\u0001\u0002\u0004F\u0019\u0011.!\"\u0011\r\u0005\u001d\u0015QRA2\u001b\t\tIIC\u0002\u0002\f\u0012\t!\u0002\u001d:fI&\u001c\u0017\r^3t\u0013\u0011\ty)!#\u0003\u001b\u0005#\u0015)\u0014)sK\u0012L7-\u0019;f\u0011!\t\u0019\n\tC\u0001\u0005\u0005U\u0015aC1eC6\u0014\u0015-\u001c'pC\u0012$B!a&\u0002(B!\u0001MYAM!\u0011\tY*a)\u000e\u0005\u0005u%bA=\u0002 *\u0019\u0011\u0011\u0015\u0004\u0002\u000f\u0019|'/\\1ug&!\u0011QUAO\u0005=\tE.[4o[\u0016tGOU3d_J$\u0007BB \u0002\u0012\u0002\u0007\u0001\tC\u0004\u0002,\u0002\"\t!!,\u0002\u00195\f\u0017PY3M_\u0006$')Y7\u0016\t\u0005=\u0016Q\u0018\u000b\t\u0003c\u000b\u0019,!.\u0002DB)\u0011#a\u0003\u0002\u0018\"1q(!+A\u0002\u0001C!\"a\u0002\u0002*B\u0005\t\u0019AA\\!\u0015\t\u00121BA]!\u0015\t\u0015\u0011CA^!\r)\u0017Q\u0018\u0003\t\u00033\tIK1\u0001\u0002@F\u0019\u0011.!1\u0011\r\u0005\u001d\u0015QRAM\u0011)\ty#!+\u0011\u0002\u0003\u0007\u0011\u0011\u0007\u0005\b\u0003\u000f\u0004C\u0011AAe\u00039i\u0017-\u001f2f\u0019>\fGMR1tiF,B!a3\u0002XRA\u0011\u0011WAg\u0003\u001f\fI\u000e\u0003\u0004@\u0003\u000b\u0004\r\u0001\u0011\u0005\u000b\u0003\u000f\t)\r%AA\u0002\u0005E\u0007#B\t\u0002\f\u0005M\u0007#B!\u0002\u0012\u0005U\u0007cA3\u0002X\u0012A\u0011\u0011DAc\u0005\u0004\ty\f\u0003\u0006\u00020\u0005\u0015\u0007\u0013!a\u0001\u0003cAq!!8!\t\u0003\ty.\u0001\bm_\u0006$\u0017\t\\5h]6,g\u000e^:\u0016\t\u0005\u0005\u0018Q\u001e\u000b\t\u0003/\u000b\u0019/!:\u0002p\"1q(a7A\u0002\u0001C!\"a\u0002\u0002\\B\u0005\t\u0019AAt!\u0015\t\u00121BAu!\u0015\t\u0015\u0011CAv!\r)\u0017Q\u001e\u0003\t\u00033\tYN1\u0001\u0002@\"Q\u0011qFAn!\u0003\u0005\r!!\r\t\u000f\u0005M\b\u0005\"\u0001\u0002v\u0006Ia-\u001b8e\r&dWm\u001d\u000b\u0007\u0003o\u0014yBa\t\u0011\r\u0005e(\u0011\u0002B\b\u001d\u0011\tYP!\u0002\u000f\t\u0005u(1A\u0007\u0003\u0003\u007fT1A!\u0001\u000b\u0003\u0019a$o\\8u}%\t1#C\u0002\u0003\bI\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003\f\t5!aA*fc*\u0019!q\u0001\n\u0011\t\tE!1D\u0007\u0003\u0005'QAA!\u0006\u0003\u0018\u0005\u0011am\u001d\u0006\u0004\u000531\u0013A\u00025bI>|\u0007/\u0003\u0003\u0003\u001e\tM!\u0001\u0002)bi\"D\u0001B!\t\u0002r\u0002\u0007!qB\u0001\u0005a\u0006$\b\u000eC\u0004\u0003&\u0005E\b\u0019\u0001!\u0002\u000bI,w-\u001a=\t\u0013\t%\u0002%%A\u0005\u0002\t-\u0012AE1eC6du.\u00193%I\u00164\u0017-\u001e7uII*bA!\f\u0003J\t-SC\u0001B\u0018U\u0011\u0011\tDa\u000e\u000f\u0007E\u0011\u0019$C\u0002\u00036I\tAAT8oK.\u0012!\u0011\b\t\u0005\u0005w\u0011)%\u0004\u0002\u0003>)!!q\bB!\u0003%)hn\u00195fG.,GMC\u0002\u0003DI\t!\"\u00198o_R\fG/[8o\u0013\u0011\u00119E!\u0010\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0002\u0004h\u0005O\u0011\r\u0001\u001b\u0003\t\u00033\u00119C1\u0001\u0002\u001c!I!q\n\u0011\u0012\u0002\u0013\u0005!\u0011K\u0001\u0013C\u0012\fW\u000eT8bI\u0012\"WMZ1vYR$3'\u0006\u0004\u0003T\t]#\u0011L\u000b\u0003\u0005+RC!!\r\u00038\u00111qM!\u0014C\u0002!$\u0001\"!\u0007\u0003N\t\u0007\u00111\u0004\u0005\n\u0005;\u0002\u0013\u0013!C\u0001\u0005?\na#\\1zE\u0016du.\u00193CC6$C-\u001a4bk2$HEM\u000b\u0005\u0005[\u0011\t\u0007\u0002\u0005\u0002\u001a\tm#\u0019AA`\u0011%\u0011)\u0007II\u0001\n\u0003\u00119'\u0001\fnCf\u0014W\rT8bI\n\u000bW\u000e\n3fM\u0006,H\u000e\u001e\u00134+\u0011\u0011\u0019F!\u001b\u0005\u0011\u0005e!1\rb\u0001\u0003\u007fC\u0011B!\u001c!#\u0003%\tAa\u001c\u000215\f\u0017PY3M_\u0006$g)Y:uc\u0012\"WMZ1vYR$#'\u0006\u0003\u0003.\tED\u0001CA\r\u0005W\u0012\r!a0\t\u0013\tU\u0004%%A\u0005\u0002\t]\u0014\u0001G7bs\n,Gj\\1e\r\u0006\u001cH/\u001d\u0013eK\u001a\fW\u000f\u001c;%gU!!1\u000bB=\t!\tIBa\u001dC\u0002\u0005}\u0006\"\u0003B?AE\u0005I\u0011\u0001B@\u0003aaw.\u00193BY&<g.\\3oiN$C-\u001a4bk2$HEM\u000b\u0005\u0005[\u0011\t\t\u0002\u0005\u0002\u001a\tm$\u0019AA`\u0011%\u0011)\tII\u0001\n\u0003\u00119)\u0001\rm_\u0006$\u0017\t\\5h]6,g\u000e^:%I\u00164\u0017-\u001e7uIM*BAa\u0015\u0003\n\u0012A\u0011\u0011\u0004BB\u0005\u0004\ty\fC\u0003,9\u0001\u0007Q\u0006C\u0004\u0003\u00106!\u0019A!%\u0002\u0019I$G\rV8B\t\u0006k%\u000b\u0012#\u0016\t\tM%q\u0014\u000b\u0005\u0005+\u0013i\u000b\u0006\u0004\u0003\u0018\n\u0005&q\u0015\t\u0006\u0019\te%QT\u0005\u0004\u00057\u0013!\u0001E!E\u00036\u0013F\t\u0012$v]\u000e$\u0018n\u001c8t!\r)'q\u0014\u0003\u0007O\n5%\u0019\u00015\t\u0015\t\r&QRA\u0001\u0002\b\u0011)+\u0001\u0006fm&$WM\\2fIE\u0002R!\u0005:\u0003\u001eRD!B!+\u0003\u000e\u0006\u0005\t9\u0001BV\u0003))g/\u001b3f]\u000e,GE\r\t\u0005\u0003~\u0014i\nC\u0004\u0004\u0005\u001b\u0003\rAa,\u0011\t\u0001\u0014'Q\u0014\u0005\b\u0005gkA1\u0001B[\u0003I\u0011XmY8sIR{'+[2i%\u0016\u001cwN\u001d3\u0015\t\t]&1\u0019\t\u0005\u0005s\u0013y,\u0004\u0002\u0003<*\u0019!Q\u0018\u0003\u0002\tIL7\r[\u0005\u0005\u0005\u0003\u0014YLA\nSS\u000eD\u0017\t\\5h]6,g\u000e\u001e*fG>\u0014H\r\u0003\u0005\u0003F\nE\u0006\u0019AAM\u0003\u0019\u0011XmY8sI\"9!\u0011Z\u0007\u0005\u0004\t-\u0017A\u00047jgR$vNS1wC2K7\u000f^\u000b\u0005\u0005\u001b\u0014\t\u000f\u0006\u0003\u0003P\n\u0015\bC\u0002Bi\u00057\u0014y.\u0004\u0002\u0003T*!!Q\u001bBl\u0003\u0011)H/\u001b7\u000b\u0005\te\u0017\u0001\u00026bm\u0006LAA!8\u0003T\n!A*[:u!\r)'\u0011\u001d\u0003\b\u0005G\u00149M1\u0001i\u0005\u0005\t\u0005\u0002\u0003Bt\u0005\u000f\u0004\rA!;\u0002\t1L7\u000f\u001e\t\u0007\u0003s\u0014YOa8\n\t\tu'Q\u0002\u0005\b\u0005_lA1\u0001By\u00039Q\u0017M^1MSN$Hk\u001c'jgR,BAa=\u0003zR!!Q\u001fB~!\u0019\tIPa;\u0003xB\u0019QM!?\u0005\u000f\t\r(Q\u001eb\u0001Q\"A!q\u001dBw\u0001\u0004\u0011i\u0010\u0005\u0004\u0003R\nm'q\u001f\u0005\b\u0007\u0003iA1AB\u0002\u00031Q\u0017M^1TKR$vnU3u+\u0011\u0019)aa\u0004\u0015\t\r\u001d1\u0011\u0003\t\u0006\u0003\u000e%1QB\u0005\u0004\u0007\u00171%aA*fiB\u0019Qma\u0004\u0005\u000f\t\r(q b\u0001Q\"A11\u0003B\u0000\u0001\u0004\u0019)\"A\u0002tKR\u0004bA!5\u0004\u0018\r5\u0011\u0002BB\u0006\u0005'Dqaa\u0007\u000e\t\u0007\u0019i\"\u0001\rj]Rd\u0015n\u001d;U_*\u000bg/Y%oi\u0016<WM\u001d'jgR$Baa\b\u0004.A1!\u0011\u001bBn\u0007C\u0001Baa\t\u0004*5\u00111Q\u0005\u0006\u0005\u0007O\u00119.\u0001\u0003mC:<\u0017\u0002BB\u0016\u0007K\u0011q!\u00138uK\u001e,'\u000f\u0003\u0005\u0003h\u000ee\u0001\u0019AB\u0018!\u0019\tIPa;\u00042A\u0019\u0011ca\r\n\u0007\rU\"CA\u0002J]RDqa!\u000f\u000e\t\u0007\u0019Y$\u0001\u0007nCB$vNS1wC6\u000b\u0007/\u0006\u0004\u0004>\r\u001d31\n\u000b\u0005\u0007\u007f\u0019y\u0005\u0005\u0005\u0003R\u000e\u00053QIB%\u0013\u0011\u0019\u0019Ea5\u0003\u00075\u000b\u0007\u000fE\u0002f\u0007\u000f\"qAa9\u00048\t\u0007\u0001\u000eE\u0002f\u0007\u0017\"qa!\u0014\u00048\t\u0007\u0001NA\u0001C\u0011!\u0019\tfa\u000eA\u0002\rM\u0013aA7baBA1QKB.\u0007\u000b\u001aI%\u0004\u0002\u0004X)\u00191\u0011\f\n\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004D\r]\u0003bBB0\u001b\u0011\r1\u0011M\u0001\rU\u00064\u0018-T1q)>l\u0015\r]\u000b\u0007\u0007G\u001aIg!\u001c\u0015\t\r\u00154q\u000e\t\t\u0007+\u001aYfa\u001a\u0004lA\u0019Qm!\u001b\u0005\u000f\t\r8Q\fb\u0001QB\u0019Qm!\u001c\u0005\u000f\r53Q\fb\u0001Q\"A1\u0011KB/\u0001\u0004\u0019\t\b\u0005\u0005\u0003R\u000e\u00053qMB6\u0011\u001d\u0019)(\u0004C\u0002\u0007o\n\u0001$\u001b;fe\u0006\u0014G.\u001a+p\u0015\u00064\u0018mQ8mY\u0016\u001cG/[8o+\u0011\u0019Iha!\u0015\t\rm4Q\u0011\t\u0007\u0005#\u001cih!!\n\t\r}$1\u001b\u0002\u000b\u0007>dG.Z2uS>t\u0007cA3\u0004\u0004\u00129!1]B:\u0005\u0004A\u0007\u0002CBD\u0007g\u0002\ra!#\u0002\u0003%\u0004b!!?\u0004\f\u000e\u0005\u0015\u0002BBG\u0005\u001b\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0005\b\u0007#kA1ABJ\u00031\u0019X\r\u001e+p\u0015\u00064\u0018mU3u+\u0011\u0019)ja'\u0015\t\r]5Q\u0014\t\u0007\u0005#\u001c9b!'\u0011\u0007\u0015\u001cY\nB\u0004\u0003d\u000e=%\u0019\u00015\t\u0011\rM1q\u0012a\u0001\u0007?\u0003R!QB\u0005\u00073C\u0011ba)\u000e\u0003\u0003%Ia!*\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0007O\u0003Baa\t\u0004*&!11VB\u0013\u0005\u0019y%M[3di\u0002")
public class ADAMContext
implements Serializable,
Logging {
    private final SparkContext sc;
    private transient Logger org$apache$spark$Logging$$log_;

    public static <A> java.util.Set<A> setToJavaSet(scala.collection.immutable.Set<A> set) {
        return ADAMContext$.MODULE$.setToJavaSet(set);
    }

    public static <A> Collection<A> iterableToJavaCollection(Iterable<A> iterable) {
        return ADAMContext$.MODULE$.iterableToJavaCollection(iterable);
    }

    public static <A, B> Map<A, B> javaMapToMap(java.util.Map<A, B> map) {
        return ADAMContext$.MODULE$.javaMapToMap(map);
    }

    public static <A, B> java.util.Map<A, B> mapToJavaMap(Map<A, B> map) {
        return ADAMContext$.MODULE$.mapToJavaMap(map);
    }

    public static java.util.List<Integer> intListToJavaIntegerList(List<Object> list) {
        return ADAMContext$.MODULE$.intListToJavaIntegerList(list);
    }

    public static <A> scala.collection.immutable.Set<A> javaSetToSet(java.util.Set<A> set) {
        return ADAMContext$.MODULE$.javaSetToSet(set);
    }

    public static <A> List<A> javaListToList(java.util.List<A> list) {
        return ADAMContext$.MODULE$.javaListToList(list);
    }

    public static <A> java.util.List<A> listToJavaList(List<A> list) {
        return ADAMContext$.MODULE$.listToJavaList(list);
    }

    public static RichAlignmentRecord recordToRichRecord(AlignmentRecord alignmentRecord) {
        return ADAMContext$.MODULE$.recordToRichRecord(alignmentRecord);
    }

    public static <T> ADAMRDDFunctions<T> rddToADAMRDD(RDD<T> rDD, Function1<T, SpecificRecord> function1, Manifest<T> manifest) {
        return ADAMContext$.MODULE$.rddToADAMRDD(rDD, function1, manifest);
    }

    public static ADAMContext sparkContextToADAMContext(SparkContext sparkContext) {
        return ADAMContext$.MODULE$.sparkContextToADAMContext(sparkContext);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public SparkContext sc() {
        return this.sc;
    }

    public SequenceDictionary adamBamDictionaryLoad(String filePath) {
        SAMFileHeader samHeader = SAMHeaderReader.readSAMHeaderFrom((Path)new Path(filePath), (Configuration)this.sc().hadoopConfiguration());
        return this.adamBamDictionaryLoad(samHeader);
    }

    public SequenceDictionary adamBamDictionaryLoad(SAMFileHeader samHeader) {
        return SequenceDictionary$.MODULE$.apply(samHeader);
    }

    public RecordGroupDictionary adamBamLoadReadGroups(SAMFileHeader samHeader) {
        return RecordGroupDictionary$.MODULE$.fromSAMHeader(samHeader);
    }

    public <T, U extends UnboundRecordFilter> RDD<T> adamLoad(String filePath, Option<Class<U>> predicate, Option<Schema> projection, Function1<T, SpecificRecord> evidence$3, Manifest<T> evidence$4) {
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Reading the ADAM file at %s to create RDD")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        Job job = HadoopUtil$.MODULE$.newJob(this.sc());
        ParquetInputFormat.setReadSupportClass((Job)job, AvroReadSupport.class);
        if (predicate.isDefined()) {
            this.log().info("Using the specified push-down predicate");
            ParquetInputFormat.setUnboundRecordFilter((Job)job, (Class)((Class)predicate.get()));
        }
        if (projection.isDefined()) {
            this.log().info("Using the specified projection schema");
            AvroParquetInputFormat.setRequestedProjection((Job)job, (Schema)((Schema)projection.get()));
        }
        RDD records = this.sc().newAPIHadoopFile(filePath, ParquetInputFormat.class, Void.class, Predef$.MODULE$.manifest(evidence$4).runtimeClass(), ContextUtil.getConfiguration((JobContext)job)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final T apply(Tuple2<Void, T> p) {
                return (T)p._2();
            }
        }, evidence$4);
        return predicate.isDefined() ? records.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(T p) {
                return p != null;
            }
        }) : records;
    }

    public <T, U extends UnboundRecordFilter> None$ adamLoad$default$2() {
        return None$.MODULE$;
    }

    public <T, U extends UnboundRecordFilter> Option<Schema> adamLoad$default$3() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> SequenceDictionary adamDictionaryLoad(String filePath, Function1<T, SpecificRecord> evidence$5, Manifest<T> evidence$6) {
        SequenceDictionary sequenceDictionary;
        Schema projection;
        boolean isADAMRecord = AlignmentRecord.class.isAssignableFrom(Predef$.MODULE$.manifest(evidence$6).runtimeClass());
        boolean isADAMContig = NucleotideContigFragment.class.isAssignableFrom(Predef$.MODULE$.manifest(evidence$6).runtimeClass());
        Schema schema = isADAMRecord ? Projection$.MODULE$.apply((Seq<FieldValue>)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{AlignmentRecordField$.MODULE$.contig(), AlignmentRecordField$.MODULE$.mateContig(), AlignmentRecordField$.MODULE$.readPaired(), AlignmentRecordField$.MODULE$.firstOfPair(), AlignmentRecordField$.MODULE$.readMapped(), AlignmentRecordField$.MODULE$.mateMapped()})) : (projection = isADAMContig ? Projection$.MODULE$.apply((Seq<FieldValue>)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{NucleotideContigFragmentField$.MODULE$.contig()})) : Projection$.MODULE$.apply((Seq<FieldValue>)Predef$.MODULE$.wrapRefArray((Object[])new FieldValue[]{AlignmentRecordField$.MODULE$.contig()})));
        if (filePath.endsWith(".bam") || filePath.endsWith(".sam")) {
            if (!isADAMRecord) throw new IllegalArgumentException("If you're reading a BAM/SAM file, the record type must be Read");
            sequenceDictionary = this.adamBamDictionaryLoad(filePath);
            return sequenceDictionary;
        } else {
            SequenceDictionary dict;
            RDD<T> projected = this.adamLoad(filePath, (Option)None$.MODULE$, (Option<Schema>)new Some((Object)projection), evidence$5, evidence$6);
            RDD recs = isADAMRecord ? projected.distinct().flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Set<SequenceRecord> apply(AlignmentRecord rec) {
                    return SequenceRecord$.MODULE$.fromADAMRecord(rec);
                }
            }, ClassTag$.MODULE$.apply(SequenceRecord.class)) : (isADAMContig ? projected.distinct().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceRecord apply(NucleotideContigFragment ctg) {
                    return SequenceRecord$.MODULE$.fromADAMContigFragment(ctg);
                }
            }, ClassTag$.MODULE$.apply(SequenceRecord.class)) : projected.distinct().map((Function1)new Serializable(this, evidence$5){
                public static final long serialVersionUID = 0L;
                private final Function1 evidence$5$1;

                public final SequenceRecord apply(T x$1) {
                    return SequenceRecord$.MODULE$.fromSpecificRecord((SpecificRecord)this.evidence$5$1.apply(x$1));
                }
                {
                    this.evidence$5$1 = evidence$5$1;
                }
            }, ClassTag$.MODULE$.apply(SequenceRecord.class)));
            sequenceDictionary = dict = (SequenceDictionary)recs.aggregate((Object)SequenceDictionary$.MODULE$.apply(), (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceDictionary apply(SequenceDictionary dict, SequenceRecord rec) {
                    return dict.$plus(rec);
                }
            }, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final SequenceDictionary apply(SequenceDictionary dict1, SequenceDictionary dict2) {
                    return dict1.$plus$plus(dict2);
                }
            }, ClassTag$.MODULE$.apply(SequenceDictionary.class));
        }
        return sequenceDictionary;
    }

    public <T, U extends ADAMPredicate<T>> RDD<T> applyPredicate(RDD<T> reads, Option<Class<U>> predicateOpt, Function1<T, SpecificRecord> evidence$7, Manifest<T> evidence$8) {
        return (RDD)predicateOpt.map((Function1)new Serializable(this, reads){
            public static final long serialVersionUID = 0L;
            private final RDD reads$1;

            public final RDD<T> apply(Class<U> x$2) {
                return ((ADAMPredicate)x$2.newInstance()).apply(this.reads$1);
            }
            {
                this.reads$1 = reads$1;
            }
        }).getOrElse((Function0)new Serializable(this, reads){
            public static final long serialVersionUID = 0L;
            private final RDD reads$1;

            public final RDD<T> apply() {
                return this.reads$1;
            }
            {
                this.reads$1 = reads$1;
            }
        });
    }

    public RDD<AlignmentRecord> adamBamLoad(String filePath) {
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Reading legacy BAM file format %s to create RDD")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        SAMFileHeader samHeader = SAMHeaderReader.readSAMHeaderFrom((Path)new Path(filePath), (Configuration)this.sc().hadoopConfiguration());
        SequenceDictionary seqDict = this.adamBamDictionaryLoad(samHeader);
        RecordGroupDictionary readGroups = this.adamBamLoadReadGroups(samHeader);
        Job job = HadoopUtil$.MODULE$.newJob(this.sc());
        RDD records = this.sc().newAPIHadoopFile(filePath, AnySAMInputFormat.class, LongWritable.class, SAMRecordWritable.class, ContextUtil.getConfiguration((JobContext)job));
        SAMRecordConverter samRecordConverter = new SAMRecordConverter();
        return records.map((Function1)new Serializable(this, seqDict, readGroups, samRecordConverter){
            public static final long serialVersionUID = 0L;
            private final SequenceDictionary seqDict$1;
            private final RecordGroupDictionary readGroups$1;
            private final SAMRecordConverter samRecordConverter$1;

            public final AlignmentRecord apply(Tuple2<LongWritable, SAMRecordWritable> p) {
                return this.samRecordConverter$1.convert(((SAMRecordWritable)p._2()).get(), this.seqDict$1, this.readGroups$1);
            }
            {
                this.seqDict$1 = seqDict$1;
                this.readGroups$1 = readGroups$1;
                this.samRecordConverter$1 = samRecordConverter$1;
            }
        }, ClassTag$.MODULE$.apply(AlignmentRecord.class));
    }

    public <U extends ADAMPredicate<AlignmentRecord>> Option<RDD<AlignmentRecord>> maybeLoadBam(String filePath, Option<Class<U>> predicate, Option<Schema> projection) {
        None$ none$;
        if (filePath.endsWith(".bam") || filePath.endsWith(".sam")) {
            if (projection.isDefined()) {
                this.log().warn("Projection is ignored when loading a BAM file");
            }
            RDD<AlignmentRecord> reads = this.adamBamLoad(filePath);
            none$ = new Some(this.applyPredicate((RDD)reads, predicate, (Function1)Predef$.MODULE$.conforms(), (Manifest)ManifestFactory$.MODULE$.classType(AlignmentRecord.class)));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public <U extends ADAMPredicate<AlignmentRecord>> None$ maybeLoadBam$default$2() {
        return None$.MODULE$;
    }

    public <U extends ADAMPredicate<AlignmentRecord>> Option<Schema> maybeLoadBam$default$3() {
        return None$.MODULE$;
    }

    public <U extends ADAMPredicate<AlignmentRecord>> Option<RDD<AlignmentRecord>> maybeLoadFastq(String filePath, Option<Class<U>> predicate, Option<Schema> projection) {
        None$ none$;
        if (filePath.endsWith(".ifq")) {
            if (projection.isDefined()) {
                this.log().warn("Projection is ignored when loading an interleaved FASTQ file");
            }
            RDD<AlignmentRecord> reads = AlignmentRecordContext$.MODULE$.adamInterleavedFastqLoad(this.sc(), filePath);
            none$ = new Some(this.applyPredicate((RDD)reads, predicate, (Function1)Predef$.MODULE$.conforms(), (Manifest)ManifestFactory$.MODULE$.classType(AlignmentRecord.class)));
        } else if (filePath.endsWith(".fastq") || filePath.endsWith(".fq")) {
            if (projection.isDefined()) {
                this.log().warn("Projection is ignored when loading a FASTQ file");
            }
            RDD<AlignmentRecord> reads = AlignmentRecordContext$.MODULE$.adamUnpairedFastqLoad(this.sc(), filePath);
            none$ = new Some(this.applyPredicate((RDD)reads, predicate, (Function1)Predef$.MODULE$.conforms(), (Manifest)ManifestFactory$.MODULE$.classType(AlignmentRecord.class)));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public <U extends ADAMPredicate<AlignmentRecord>> None$ maybeLoadFastq$default$2() {
        return None$.MODULE$;
    }

    public <U extends ADAMPredicate<AlignmentRecord>> Option<Schema> maybeLoadFastq$default$3() {
        return None$.MODULE$;
    }

    public <U extends ADAMPredicate<AlignmentRecord>> RDD<AlignmentRecord> loadAlignments(String filePath, Option<Class<U>> predicate, Option<Schema> projection) {
        return (RDD)this.maybeLoadBam(filePath, predicate, projection).orElse((Function0)new Serializable(this, filePath, predicate, projection){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMContext $outer;
            private final String filePath$1;
            private final Option predicate$1;
            private final Option projection$1;

            public final Option<RDD<AlignmentRecord>> apply() {
                return this.$outer.maybeLoadFastq(this.filePath$1, this.predicate$1, (Option<Schema>)this.projection$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.filePath$1 = filePath$1;
                this.predicate$1 = predicate$1;
                this.projection$1 = projection$1;
            }
        }).getOrElse((Function0)new Serializable(this, filePath, predicate, projection){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ADAMContext $outer;
            private final String filePath$1;
            private final Option predicate$1;
            private final Option projection$1;

            public final RDD<AlignmentRecord> apply() {
                return this.$outer.adamLoad(this.filePath$1, this.predicate$1, (Option<Schema>)this.projection$1, Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(AlignmentRecord.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.filePath$1 = filePath$1;
                this.predicate$1 = predicate$1;
                this.projection$1 = projection$1;
            }
        });
    }

    public <U extends ADAMPredicate<AlignmentRecord>> None$ loadAlignments$default$2() {
        return None$.MODULE$;
    }

    public <U extends ADAMPredicate<AlignmentRecord>> Option<Schema> loadAlignments$default$3() {
        return None$.MODULE$;
    }

    public Seq<Path> findFiles(Path path, String regex) {
        Tuple2 tuple2;
        block4: {
            Seq seq;
            block3: {
                Tuple2 tuple22;
                block2: {
                    if (regex != null) break block2;
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{path}));
                    break block3;
                }
                FileStatus[] statuses = FileSystem.get((Configuration)this.sc().hadoopConfiguration()).listStatus(path);
                Pattern r = Pattern.compile(regex);
                tuple2 = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])statuses).filter((Function1)new $anonfun$7(this))).map((Function1)new $anonfun$8(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))).partition((Function1)new $anonfun$9(this, r));
                if (tuple2 == null) break block4;
                Path[] matches = (Path[])tuple2._1();
                Path[] recurse = (Path[])tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)matches, (Object)recurse);
                Path[] matches2 = (Path[])tuple23._1();
                Path[] recurse2 = (Path[])tuple23._2();
                seq = (Seq)Predef$.MODULE$.refArrayOps((Object[])matches2).toSeq().$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])recurse2).flatMap((Function1)new Serializable(this, regex){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ADAMContext $outer;
                    private final String regex$1;

                    public final Seq<Path> apply(Path p) {
                        return this.$outer.findFiles(p, this.regex$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.regex$1 = regex$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))), Seq$.MODULE$.canBuildFrom());
            }
            return seq;
        }
        throw new MatchError((Object)tuple2);
    }

    public ADAMContext(SparkContext sc) {
        this.sc = sc;
        Logging.class.$init$((Logging)this);
    }
}

