/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.features;

import org.apache.spark.Logging;
import org.apache.spark.SparkContext$;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.models.CDS;
import org.bdgenomics.adam.models.Exon;
import org.bdgenomics.adam.models.Gene;
import org.bdgenomics.adam.models.Transcript;
import org.bdgenomics.adam.models.UTR;
import org.bdgenomics.adam.rdd.features.GeneFeatureRDD$;
import org.bdgenomics.adam.rich.ReferenceMappingContext$FeatureReferenceMapping$;
import org.bdgenomics.formats.avro.Feature;
import org.bdgenomics.formats.avro.Strand;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001};Q!\u0001\u0002\t\u00025\tabR3oK\u001a+\u0017\r^;sKJ#EI\u0003\u0002\u0004\t\u0005Aa-Z1ukJ,7O\u0003\u0002\u0006\r\u0005\u0019!\u000f\u001a3\u000b\u0005\u001dA\u0011\u0001B1eC6T!!\u0003\u0006\u0002\u0015\t$w-\u001a8p[&\u001c7OC\u0001\f\u0003\ry'oZ\u0002\u0001!\tqq\"D\u0001\u0003\r\u0015\u0001\"\u0001#\u0001\u0012\u000599UM\\3GK\u0006$XO]3S\t\u0012\u001b2a\u0004\n\u0019!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fMB\u00111#G\u0005\u00035Q\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQ\u0001H\b\u0005\u0002u\ta\u0001P5oSRtD#A\u0007\t\u000b}yA1\u0001\u0011\u0002K\r|gN^3si\n\u000b7/\u001a$fCR,(/\u001a*E\tR{w)\u001a8f\r\u0016\fG/\u001e:f%\u0012#ECA\u0011I!\tq!E\u0002\u0003\u0011\u0005\u0001\u00193\u0003\u0002\u0012\u00131\u0011\u0002\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\u000bM\u0004\u0018M]6\u000b\u0005%R\u0011AB1qC\u000eDW-\u0003\u0002,M\t9Aj\\4hS:<\u0007\u0002C\u0017#\u0005\u0003\u0005\u000b\u0011\u0002\u0018\u0002\u0015\u0019,\u0017\r^;sKJ#E\tE\u00020cMj\u0011\u0001\r\u0006\u0003\u000b\u0019J!A\r\u0019\u0003\u0007I#E\t\u0005\u00025s5\tQG\u0003\u00027o\u0005!\u0011M\u001e:p\u0015\tA\u0004\"A\u0004g_Jl\u0017\r^:\n\u0005i*$a\u0002$fCR,(/\u001a\u0005\u00069\t\"\t\u0001\u0010\u000b\u0003CuBQ!L\u001eA\u00029BQa\u0010\u0012\u0005\u0002\u0001\u000bq!Y:HK:,7\u000fF\u0001B!\ry\u0013G\u0011\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b\u001a\ta!\\8eK2\u001c\u0018BA$E\u0005\u00119UM\\3\t\u000b\u0015q\u0002\u0019\u0001\u0018\t\u000b){A\u0011A&\u0002\rM$(/\u00198e)\tau\n\u0005\u0002\u0014\u001b&\u0011a\n\u0006\u0002\b\u0005>|G.Z1o\u0011\u0015\u0001\u0016\n1\u0001R\u0003\r\u0019HO\u001d\t\u0003iIK!aU\u001b\u0003\rM#(/\u00198e\u0011\u001d)v\"!A\u0005\nY\u000b1B]3bIJ+7o\u001c7wKR\tq\u000b\u0005\u0002Y;6\t\u0011L\u0003\u0002[7\u0006!A.\u00198h\u0015\u0005a\u0016\u0001\u00026bm\u0006L!AX-\u0003\r=\u0013'.Z2u\u0001")
public class GeneFeatureRDD
implements Serializable,
Logging {
    private final RDD<Feature> featureRDD;
    private transient Logger org$apache$spark$Logging$$log_;

    public static boolean strand(Strand strand) {
        return GeneFeatureRDD$.MODULE$.strand(strand);
    }

    public static GeneFeatureRDD convertBaseFeatureRDDToGeneFeatureRDD(RDD<Feature> rDD) {
        return GeneFeatureRDD$.MODULE$.convertBaseFeatureRDDToGeneFeatureRDD(rDD);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public RDD<Gene> asGenes() {
        RDD typePartitioned = this.featureRDD.keyBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Feature x$1) {
                return x$1.getFeatureType().toString();
            }
        }).cache();
        RDD exonsByTranscript = SparkContext$.MODULE$.rddToPairRDDFunctions(typePartitioned.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Feature> x$2) {
                Object object = x$2._1();
                String string = "exon";
                return !(object != null ? !object.equals(string) : string != null);
            }
        }).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Tuple2<String, Exon>> apply(Tuple2<String, Feature> x0$1) {
                Tuple2<String, Feature> tuple2 = x0$1;
                if (tuple2 != null) {
                    String string = (String)tuple2._1();
                    Feature ftr = (Feature)tuple2._2();
                    String string2 = string;
                    if (!("exon" != null ? !"exon".equals(string2) : string2 != null) && ftr != null) {
                        Feature feature = ftr;
                        Seq ids = (Seq)JavaConversions$.MODULE$.asScalaBuffer(feature.getParentIds()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String x$3) {
                                return x$3.toString();
                            }
                        }, Buffer$.MODULE$.canBuildFrom());
                        Seq seq = (Seq)ids.map((Function1)new Serializable(this, feature){
                            public static final long serialVersionUID = 0L;
                            private final Feature x4$1;

                            public final Tuple2<String, Exon> apply(String transcriptId) {
                                return new Tuple2((Object)transcriptId, (Object)new Exon(this.x4$1.getFeatureId().toString(), transcriptId, GeneFeatureRDD$.MODULE$.strand(this.x4$1.getStrand()), ReferenceMappingContext$FeatureReferenceMapping$.MODULE$.getReferenceRegion(this.x4$1)));
                            }
                            {
                                this.x4$1 = x4$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        return seq;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Exon.class), (Ordering)Ordering.String$.MODULE$).groupByKey();
        RDD cdsByTranscript = SparkContext$.MODULE$.rddToPairRDDFunctions(typePartitioned.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Feature> x$4) {
                Object object = x$4._1();
                String string = "CDS";
                return !(object != null ? !object.equals(string) : string != null);
            }
        }).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Tuple2<String, CDS>> apply(Tuple2<String, Feature> x0$2) {
                Tuple2<String, Feature> tuple2 = x0$2;
                if (tuple2 != null) {
                    String string = (String)tuple2._1();
                    Feature ftr = (Feature)tuple2._2();
                    String string2 = string;
                    if (!("CDS" != null ? !"CDS".equals(string2) : string2 != null) && ftr != null) {
                        Feature feature = ftr;
                        Seq ids = (Seq)JavaConversions$.MODULE$.asScalaBuffer(feature.getParentIds()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String x$5) {
                                return x$5.toString();
                            }
                        }, Buffer$.MODULE$.canBuildFrom());
                        Seq seq = (Seq)ids.map((Function1)new Serializable(this, feature){
                            public static final long serialVersionUID = 0L;
                            private final Feature x4$2;

                            public final Tuple2<String, CDS> apply(String transcriptId) {
                                return new Tuple2((Object)transcriptId, (Object)new CDS(transcriptId, GeneFeatureRDD$.MODULE$.strand(this.x4$2.getStrand()), ReferenceMappingContext$FeatureReferenceMapping$.MODULE$.getReferenceRegion(this.x4$2)));
                            }
                            {
                                this.x4$2 = x4$2;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        return seq;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(CDS.class), (Ordering)Ordering.String$.MODULE$).groupByKey();
        RDD utrsByTranscript = SparkContext$.MODULE$.rddToPairRDDFunctions(typePartitioned.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Feature> x$6) {
                Object object = x$6._1();
                String string = "UTR";
                return !(object != null ? !object.equals(string) : string != null);
            }
        }).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Tuple2<String, UTR>> apply(Tuple2<String, Feature> x0$3) {
                Tuple2<String, Feature> tuple2 = x0$3;
                if (tuple2 != null) {
                    String string = (String)tuple2._1();
                    Feature ftr = (Feature)tuple2._2();
                    String string2 = string;
                    if (!("UTR" != null ? !"UTR".equals(string2) : string2 != null) && ftr != null) {
                        Feature feature = ftr;
                        Seq ids = (Seq)JavaConversions$.MODULE$.asScalaBuffer(feature.getParentIds()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(String x$7) {
                                return x$7.toString();
                            }
                        }, Buffer$.MODULE$.canBuildFrom());
                        Seq seq = (Seq)ids.map((Function1)new Serializable(this, feature){
                            public static final long serialVersionUID = 0L;
                            private final Feature x4$3;

                            public final Tuple2<String, UTR> apply(String transcriptId) {
                                return new Tuple2((Object)transcriptId, (Object)new UTR(transcriptId, GeneFeatureRDD$.MODULE$.strand(this.x4$3.getStrand()), ReferenceMappingContext$FeatureReferenceMapping$.MODULE$.getReferenceRegion(this.x4$3)));
                            }
                            {
                                this.x4$3 = x4$3;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        return seq;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(UTR.class), (Ordering)Ordering.String$.MODULE$).groupByKey();
        RDD transcriptsByGene = SparkContext$.MODULE$.rddToPairRDDFunctions(SparkContext$.MODULE$.rddToPairRDDFunctions(SparkContext$.MODULE$.rddToPairRDDFunctions(SparkContext$.MODULE$.rddToPairRDDFunctions(typePartitioned.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Feature> x$8) {
                Object object = x$8._1();
                String string = "transcript";
                return !(object != null ? !object.equals(string) : string != null);
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Feature> apply(Tuple2<String, Feature> x0$4) {
                Tuple2<String, Feature> tuple2 = x0$4;
                if (tuple2 != null) {
                    String string = (String)tuple2._1();
                    Feature ftr = (Feature)tuple2._2();
                    String string2 = string;
                    if (!("transcript" != null ? !"transcript".equals(string2) : string2 != null) && ftr != null) {
                        Feature feature = ftr;
                        Tuple2 tuple22 = new Tuple2((Object)feature.getFeatureId().toString(), (Object)feature);
                        return tuple22;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Feature.class), (Ordering)Ordering.String$.MODULE$).join(exonsByTranscript), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.String$.MODULE$).leftOuterJoin(utrsByTranscript), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.String$.MODULE$).leftOuterJoin(cdsByTranscript).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Tuple2<String, Transcript>> apply(Tuple2<String, Tuple2<Tuple2<Tuple2<Feature, Iterable<Exon>>, Option<Iterable<UTR>>>, Option<Iterable<CDS>>>> x0$5) {
                Tuple2<String, Tuple2<Tuple2<Tuple2<Feature, Iterable<Exon>>, Option<Iterable<UTR>>>, Option<Iterable<CDS>>>> tuple2 = x0$5;
                if (tuple2 != null) {
                    String transcriptId = (String)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (transcriptId != null) {
                        String string = transcriptId;
                        if (tuple22 != null) {
                            Tuple2 tuple23 = (Tuple2)tuple22._1();
                            Option cds = (Option)tuple22._2();
                            if (tuple23 != null) {
                                Tuple2 tuple24 = (Tuple2)tuple23._1();
                                Option utrs = (Option)tuple23._2();
                                if (tuple24 != null) {
                                    Feature tgtf = (Feature)tuple24._1();
                                    Iterable exons = (Iterable)tuple24._2();
                                    if (tgtf != null) {
                                        Feature feature = tgtf;
                                        if (exons != null) {
                                            Iterable iterable = exons;
                                            if (utrs != null) {
                                                Option option = utrs;
                                                if (cds != null) {
                                                    Option option2 = cds;
                                                    Seq geneIds = (Seq)JavaConversions$.MODULE$.asScalaBuffer(feature.getParentIds()).map((Function1)new Serializable(this){
                                                        public static final long serialVersionUID = 0L;

                                                        public final String apply(String x$9) {
                                                            return x$9.toString();
                                                        }
                                                    }, Buffer$.MODULE$.canBuildFrom());
                                                    Seq seq = (Seq)geneIds.map((Function1)new Serializable(this, string, feature, iterable, option, option2){
                                                        public static final long serialVersionUID = 0L;
                                                        private final String x5$1;
                                                        private final Feature x6$1;
                                                        private final Iterable x7$1;
                                                        private final Option x8$1;
                                                        private final Option x9$1;

                                                        public final Tuple2<String, Transcript> apply(String geneId) {
                                                            return new Tuple2((Object)geneId, (Object)new Transcript(this.x5$1, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.x5$1}))), geneId, GeneFeatureRDD$.MODULE$.strand(this.x6$1.getStrand()), (Iterable<Exon>)this.x7$1, (Iterable<CDS>)((Iterable)this.x9$1.getOrElse((Function0)new Serializable(this){
                                                                public static final long serialVersionUID = 0L;

                                                                public final Seq<Nothing$> apply() {
                                                                    return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                                                                }
                                                            })), (Iterable<UTR>)((Iterable)this.x8$1.getOrElse((Function0)new Serializable(this){
                                                                public static final long serialVersionUID = 0L;

                                                                public final Seq<Nothing$> apply() {
                                                                    return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                                                                }
                                                            }))));
                                                        }
                                                        {
                                                            this.x5$1 = x5$1;
                                                            this.x6$1 = x6$1;
                                                            this.x7$1 = x7$1;
                                                            this.x8$1 = x8$1;
                                                            this.x9$1 = x9$1;
                                                        }
                                                    }, Seq$.MODULE$.canBuildFrom());
                                                    return seq;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Transcript.class), (Ordering)Ordering.String$.MODULE$).groupByKey();
        RDD genes = SparkContext$.MODULE$.rddToPairRDDFunctions(typePartitioned.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Feature> x$10) {
                Object object = x$10._1();
                String string = "gene";
                return !(object != null ? !object.equals(string) : string != null);
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Feature> apply(Tuple2<String, Feature> x0$6) {
                Tuple2<String, Feature> tuple2 = x0$6;
                if (tuple2 != null) {
                    String string = (String)tuple2._1();
                    Feature ftr = (Feature)tuple2._2();
                    String string2 = string;
                    if (!("gene" != null ? !"gene".equals(string2) : string2 != null) && ftr != null) {
                        Feature feature = ftr;
                        Tuple2 tuple22 = new Tuple2((Object)feature.getFeatureId().toString(), (Object)feature);
                        return tuple22;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Feature.class), (Ordering)Ordering.String$.MODULE$).leftOuterJoin(transcriptsByGene).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Gene apply(Tuple2<String, Tuple2<Feature, Option<Iterable<Transcript>>>> x0$7) {
                Tuple2<String, Tuple2<Feature, Option<Iterable<Transcript>>>> tuple2 = x0$7;
                if (tuple2 != null) {
                    String geneId = (String)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (geneId != null) {
                        String string = geneId;
                        if (tuple22 != null) {
                            Feature ggtf = (Feature)tuple22._1();
                            Option transcripts = (Option)tuple22._2();
                            if (ggtf != null) {
                                Feature feature = ggtf;
                                if (transcripts != null) {
                                    Option option = transcripts;
                                    Gene gene = new Gene(string, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{string}))), GeneFeatureRDD$.MODULE$.strand(feature.getStrand()), (Iterable<Transcript>)((Iterable)option.getOrElse((Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Seq<Nothing$> apply() {
                                            return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                                        }
                                    })));
                                    return gene;
                                }
                            }
                        }
                    }
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Gene.class));
        return genes;
    }

    public GeneFeatureRDD(RDD<Feature> featureRDD) {
        this.featureRDD = featureRDD;
        Logging.class.$init$((Logging)this);
    }
}

