/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.read;

import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.bdgenomics.adam.converters.FastqRecordConverter;
import org.bdgenomics.adam.io.InterleavedFastqInputFormat;
import org.bdgenomics.adam.io.SingleFastqInputFormat;
import org.bdgenomics.adam.rdd.ADAMContext;
import org.bdgenomics.adam.rdd.read.AlignmentRecordContext;
import org.bdgenomics.adam.rdd.read.AlignmentRecordRDDFunctions;
import org.bdgenomics.adam.util.HadoopUtil$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.slf4j.Logger;
import parquet.hadoop.util.ContextUtil;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;

public final class AlignmentRecordContext$
implements Serializable,
Logging {
    public static final AlignmentRecordContext$ MODULE$;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new AlignmentRecordContext$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public AlignmentRecordContext adamContextToADAMContext(ADAMContext ac) {
        return new AlignmentRecordContext(ac.sc());
    }

    public AlignmentRecordRDDFunctions rddToADAMRecordRDD(RDD<AlignmentRecord> rdd) {
        return new AlignmentRecordRDDFunctions(rdd);
    }

    public RDD<AlignmentRecord> adamInterleavedFastqLoad(SparkContext sc, String filePath) {
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Reading interleaved FASTQ file format %s to create RDD")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        Job job = HadoopUtil$.MODULE$.newJob(sc);
        RDD records = sc.newAPIHadoopFile(filePath, InterleavedFastqInputFormat.class, Void.class, Text.class, ContextUtil.getConfiguration((JobContext)job));
        FastqRecordConverter fastqRecordConverter = new FastqRecordConverter();
        return records.flatMap((Function1)new Serializable(fastqRecordConverter){
            public static final long serialVersionUID = 0L;
            private final FastqRecordConverter fastqRecordConverter$1;

            public final Iterable<AlignmentRecord> apply(Tuple2<Void, Text> element) {
                return this.fastqRecordConverter$1.convertPair(element);
            }
            {
                this.fastqRecordConverter$1 = fastqRecordConverter$1;
            }
        }, ClassTag$.MODULE$.apply(AlignmentRecord.class));
    }

    public RDD<AlignmentRecord> adamUnpairedFastqLoad(SparkContext sc, String filePath) {
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("Reading unpaired FASTQ file format %s to create RDD")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filePath})));
        Job job = HadoopUtil$.MODULE$.newJob(sc);
        RDD records = sc.newAPIHadoopFile(filePath, SingleFastqInputFormat.class, Void.class, Text.class, ContextUtil.getConfiguration((JobContext)job));
        FastqRecordConverter fastqRecordConverter = new FastqRecordConverter();
        return records.map((Function1)new Serializable(fastqRecordConverter){
            public static final long serialVersionUID = 0L;
            private final FastqRecordConverter fastqRecordConverter$2;

            public final AlignmentRecord apply(Tuple2<Void, Text> element) {
                return this.fastqRecordConverter$2.convertRead(element);
            }
            {
                this.fastqRecordConverter$2 = fastqRecordConverter$2;
            }
        }, ClassTag$.MODULE$.apply(AlignmentRecord.class));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private AlignmentRecordContext$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

