/*
 * Decompiled with CFR 0.152.
 */
package org.bdgenomics.adam.rdd.read;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.SAMTextWriter;
import htsjdk.samtools.ValidationStringency;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.spark.SparkContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGenerator;
import org.bdgenomics.adam.algorithms.consensus.ConsensusGeneratorFromReads;
import org.bdgenomics.adam.converters.AlignmentRecordConverter;
import org.bdgenomics.adam.converters.AlignmentRecordConverter$;
import org.bdgenomics.adam.models.Attribute;
import org.bdgenomics.adam.models.RecordGroup;
import org.bdgenomics.adam.models.RecordGroup$;
import org.bdgenomics.adam.models.RecordGroupDictionary;
import org.bdgenomics.adam.models.ReferencePosition;
import org.bdgenomics.adam.models.ReferencePosition$;
import org.bdgenomics.adam.models.ReferenceRegion;
import org.bdgenomics.adam.models.Rod;
import org.bdgenomics.adam.models.SAMFileHeaderWritable;
import org.bdgenomics.adam.models.SAMFileHeaderWritable$;
import org.bdgenomics.adam.models.SequenceDictionary;
import org.bdgenomics.adam.models.SequenceRecord;
import org.bdgenomics.adam.models.SequenceRecord$;
import org.bdgenomics.adam.models.SingleReadBucket;
import org.bdgenomics.adam.models.SingleReadBucket$;
import org.bdgenomics.adam.models.SnpTable;
import org.bdgenomics.adam.rdd.ADAMContext$;
import org.bdgenomics.adam.rdd.ADAMSaveAnyArgs;
import org.bdgenomics.adam.rdd.ADAMSaveArgs;
import org.bdgenomics.adam.rdd.ADAMSequenceDictionaryRDDAggregator;
import org.bdgenomics.adam.rdd.read.ADAMBAMOutputFormat;
import org.bdgenomics.adam.rdd.read.ADAMBAMOutputFormat$;
import org.bdgenomics.adam.rdd.read.ADAMSAMOutputFormat;
import org.bdgenomics.adam.rdd.read.ADAMSAMOutputFormat$;
import org.bdgenomics.adam.rdd.read.AlignmentRecordContext$;
import org.bdgenomics.adam.rdd.read.AlignmentRecordRDDFunctions$;
import org.bdgenomics.adam.rdd.read.FlagStat$;
import org.bdgenomics.adam.rdd.read.FlagStatMetrics;
import org.bdgenomics.adam.rdd.read.MarkDuplicates$;
import org.bdgenomics.adam.rdd.read.Reads2PileupProcessor;
import org.bdgenomics.adam.rdd.read.correction.ErrorCorrection$;
import org.bdgenomics.adam.rdd.read.correction.TrimReads$;
import org.bdgenomics.adam.rdd.read.realignment.RealignIndels$;
import org.bdgenomics.adam.rdd.read.recalibration.BaseQualityRecalibration$;
import org.bdgenomics.adam.rich.RichAlignmentRecord$;
import org.bdgenomics.adam.util.MapTools$;
import org.bdgenomics.formats.avro.AlignmentRecord;
import org.bdgenomics.formats.avro.Pileup;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\tEh\u0001B\u0001\u0003\u00015\u00111$\u00117jO:lWM\u001c;SK\u000e|'\u000f\u001a*E\t\u001a+hn\u0019;j_:\u001c(BA\u0002\u0005\u0003\u0011\u0011X-\u00193\u000b\u0005\u00151\u0011a\u0001:eI*\u0011q\u0001C\u0001\u0005C\u0012\fWN\u0003\u0002\n\u0015\u0005Q!\rZ4f]>l\u0017nY:\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0007=\u0001\"#D\u0001\u0005\u0013\t\tBAA\u0012B\t\u0006k5+Z9vK:\u001cW\rR5di&|g.\u0019:z%\u0012#\u0015iZ4sK\u001e\fGo\u001c:\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012\u0001B1we>T!a\u0006\u0005\u0002\u000f\u0019|'/\\1ug&\u0011\u0011\u0004\u0006\u0002\u0010\u00032LwM\\7f]R\u0014VmY8sI\"AQ\u0001\u0001B\u0001B\u0003%1\u0004E\u0002\u001dEIi\u0011!\b\u0006\u0003\u000byQ!a\b\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0005R\u0011AB1qC\u000eDW-\u0003\u0002$;\t\u0019!\u000b\u0012#\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\t9\u0013\u0006\u0005\u0002)\u00015\t!\u0001C\u0003\u0006I\u0001\u00071\u0004C\u0003,\u0001\u0011\u0005A&A\rgS2$XM\u001d\"z\u001fZ,'\u000f\\1qa&twMU3hS>tGCA\u000e.\u0011\u0015q#\u00061\u00010\u0003\u0015\tX/\u001a:z!\t\u00014'D\u00012\u0015\t\u0011d!\u0001\u0004n_\u0012,Gn]\u0005\u0003iE\u0012qBU3gKJ,gnY3SK\u001eLwN\u001c\u0005\u0006m\u0001!\taN\u0001\r[\u0006L(-Z*bm\u0016\u0014\u0015-\u001c\u000b\u0003qy\u0002\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012qAQ8pY\u0016\fg\u000eC\u0003@k\u0001\u0007\u0001)\u0001\u0003be\u001e\u001c\bCA\bB\u0013\t\u0011EA\u0001\u0007B\t\u0006k5+\u0019<f\u0003J<7\u000fC\u0003E\u0001\u0011\u0005Q)\u0001\bnCf\u0014WmU1wK\u001a\u000b7\u000f^9\u0015\u0005a2\u0005\"B D\u0001\u00049\u0005CA\bI\u0013\tIEAA\bB\t\u0006k5+\u0019<f\u0003:L\u0018I]4t\u0011\u0015Y\u0005\u0001\"\u0001M\u0003U\tG-Y7BY&<g.\u001a3SK\u000e|'\u000fZ*bm\u0016$\"\u0001O'\t\u000b}R\u0005\u0019\u0001!\t\u000b=\u0003A\u0011\u0001)\u0002\u0011\u0005$\u0017-\\*bm\u0016$\"\u0001O)\t\u000b}r\u0005\u0019A$\t\u000bM\u0003A\u0011\u0001+\u0002\u001b\u0005$\u0017-\\*B\u001bN#(/\u001b8h+\u0005)\u0006C\u0001,Z\u001d\tIt+\u0003\u0002Yu\u00051\u0001K]3eK\u001aL!AW.\u0003\rM#(/\u001b8h\u0015\tA&\bC\u0003^\u0001\u0011\u0005a,A\u0006bI\u0006l7+Q'TCZ,GcA0cIB\u0011\u0011\bY\u0005\u0003Cj\u0012A!\u00168ji\")1\r\u0018a\u0001+\u0006Aa-\u001b7f!\u0006$\b\u000eC\u0004f9B\u0005\t\u0019\u0001\u001d\u0002\u000b\u0005\u001c8+Y7\t\u000b\u001d\u0004A\u0011\u00015\u0002;\u001d,GoU3rk\u0016t7-\u001a*fG>\u0014Hm\u001d$s_6,E.Z7f]R$\"!\u001b:\u0011\u0007)lw.D\u0001l\u0015\ta'(\u0001\u0006d_2dWm\u0019;j_:L!A\\6\u0003\u0007M+G\u000f\u0005\u00021a&\u0011\u0011/\r\u0002\u000f'\u0016\fX/\u001a8dKJ+7m\u001c:e\u0011\u0015\u0019h\r1\u0001\u0013\u0003\u0011)G.Z7\t\u000bU\u0004A\u0011\u0001<\u00025\u0005$\u0017-\\$fiJ+\u0017\rZ$s_V\u0004H)[2uS>t\u0017M]=\u0015\u0003]\u0004\"\u0001\r=\n\u0005e\f$!\u0006*fG>\u0014Hm\u0012:pkB$\u0015n\u0019;j_:\f'/\u001f\u0005\u0006w\u0002!\t\u0001`\u0001\u0011C\u0012\fWnQ8om\u0016\u0014H\u000fV8T\u00036#\u0012! \t\u0007sy\f\t!a\u0005\n\u0005}T$A\u0002+va2,'\u0007\u0005\u0003\u001dE\u0005\r\u0001\u0003BA\u0003\u0003\u001fi!!a\u0002\u000b\t\u0005%\u00111B\u0001\u000bQ\u0006$wn\u001c9`E\u0006l'bAA\u0007\u0015\u000591/Z9e_>\u0004\u0018\u0002BA\t\u0003\u000f\u0011\u0011cU!N%\u0016\u001cwN\u001d3Xe&$\u0018M\u00197f!\u0011\t)\"a\b\u000e\u0005\u0005]!\u0002BA\r\u00037\t\u0001b]1ni>|Gn\u001d\u0006\u0003\u0003;\ta\u0001\u001b;tU\u0012\\\u0017\u0002BA\u0011\u0003/\u0011QbU!N\r&dW\rS3bI\u0016\u0014\bbBA\u0013\u0001\u0011\u0005\u0011qE\u0001\u000fC\u0012\fWnQ8v]R\\U.\u001a:t)\u0011\tI#a\r\u0011\tq\u0011\u00131\u0006\t\u0006sy,\u0016Q\u0006\t\u0004s\u0005=\u0012bAA\u0019u\t!Aj\u001c8h\u0011!\t)$a\tA\u0002\u0005]\u0012AC6nKJdUM\\4uQB\u0019\u0011(!\u000f\n\u0007\u0005m\"HA\u0002J]RDq!a\u0010\u0001\t\u0003\t\t%\u0001\bbI\u0006l7i\\;oiFkWM]:\u0015\t\u0005\r\u0013Q\n\t\u00059\t\n)\u0005E\u0003:}V\u000b9\u0005E\u0002:\u0003\u0013J1!a\u0013;\u0005\u0019!u.\u001e2mK\"A\u0011qJA\u001f\u0001\u0004\t9$\u0001\u0006r[\u0016\u0014H*\u001a8hi\"Dq!a\u0015\u0001\t\u0003\t)&\u0001\u0011bI\u0006l7k\u001c:u%\u0016\fGm\u001d\"z%\u00164WM]3oG\u0016\u0004vn]5uS>tG#A\u000e\t\u000f\u0005e\u0003\u0001\"\u0001\u0002V\u0005\u0011\u0012\rZ1n\u001b\u0006\u00148\u000eR;qY&\u001c\u0017\r^3t\u0011\u001d\ti\u0006\u0001C\u0001\u0003?\n\u0001\"\u00193b[\n\u000b6K\u0015\u000b\u00067\u0005\u0005\u0014q\u000f\u0005\t\u0003G\nY\u00061\u0001\u0002f\u0005I1N\\8x]Ns\u0007o\u001d\t\u0007\u0003O\ni'!\u001d\u000e\u0005\u0005%$bAA6=\u0005I!M]8bI\u000e\f7\u000f^\u0005\u0005\u0003_\nIGA\u0005Ce>\fGmY1tiB\u0019\u0001'a\u001d\n\u0007\u0005U\u0014G\u0001\u0005T]B$\u0016M\u00197f\u0011)\tI(a\u0017\u0011\u0002\u0003\u0007\u00111P\u0001\u0014_\n\u001cXM\u001d<bi&|g\u000eR;na\u001aKG.\u001a\t\u0005s\u0005uT+C\u0002\u0002\u0000i\u0012aa\u00149uS>t\u0007bBAB\u0001\u0011\u0005\u0011QQ\u0001\u0012C\u0012\fWNU3bY&<g.\u00138eK2\u001cH#D\u000e\u0002\b\u0006m\u0015qTAR\u0003O\u000bY\u000b\u0003\u0006\u0002\n\u0006\u0005\u0005\u0013!a\u0001\u0003\u0017\u000babY8og\u0016t7/^:N_\u0012,G\u000e\u0005\u0003\u0002\u000e\u0006]UBAAH\u0015\u0011\t\t*a%\u0002\u0013\r|gn]3ogV\u001c(bAAK\r\u0005Q\u0011\r\\4pe&$\b.\\:\n\t\u0005e\u0015q\u0012\u0002\u0013\u0007>t7/\u001a8tkN<UM\\3sCR|'\u000fC\u0005\u0002\u001e\u0006\u0005\u0005\u0013!a\u0001q\u0005A\u0011n]*peR,G\r\u0003\u0006\u0002\"\u0006\u0005\u0005\u0013!a\u0001\u0003o\tA\"\\1y\u0013:$W\r\\*ju\u0016D!\"!*\u0002\u0002B\u0005\t\u0019AA\u001c\u0003Ii\u0017\r_\"p]N,gn];t\u001dVl'-\u001a:\t\u0015\u0005%\u0016\u0011\u0011I\u0001\u0002\u0004\t9%\u0001\u0007m_\u0012$\u0006N]3tQ>dG\r\u0003\u0006\u0002.\u0006\u0005\u0005\u0013!a\u0001\u0003o\tQ\"\\1y)\u0006\u0014x-\u001a;TSj,\u0007bBAY\u0001\u0011\u0005\u00111W\u0001\rC\u0012\fWN\u00127bON#\u0018\r\u001e\u000b\u0003\u0003k\u0003b!\u000f@\u00028\u0006]\u0006c\u0001\u0015\u0002:&\u0019\u00111\u0018\u0002\u0003\u001f\u0019c\u0017mZ*uCRlU\r\u001e:jGNDq!a0\u0001\t\u0003\t\t-A\u000bbI\u0006l7+\u001b8hY\u0016\u0014V-\u00193Ck\u000e\\W\r^:\u0015\u0005\u0005\r\u0007\u0003\u0002\u000f#\u0003\u000b\u00042\u0001MAd\u0013\r\tI-\r\u0002\u0011'&tw\r\\3SK\u0006$')^2lKRDq!!4\u0001\t\u0003\ty-\u0001\nbI\u0006l'+Z2pe\u0012\u001c(\u0007U5mKV\u0004H\u0003BAi\u00033\u0004B\u0001\b\u0012\u0002TB\u00191#!6\n\u0007\u0005]GC\u0001\u0004QS2,W\u000f\u001d\u0005\n\u00037\fY\r%AA\u0002a\n1c]3d_:$\u0017M]=BY&<g.\\3oiNDq!a8\u0001\t\u0003\t\t/\u0001\tbI\u0006l'+Z2pe\u0012\u001c(GU8egR1\u00111]Av\u0003_\u0004B\u0001\b\u0012\u0002fB\u0019\u0001'a:\n\u0007\u0005%\u0018GA\u0002S_\u0012D!\"!<\u0002^B\u0005\t\u0019AA\u001c\u0003)\u0011WoY6fiNK'0\u001a\u0005\n\u00037\fi\u000e%AA\u0002aBq!a=\u0001\t\u0003\t)0\u0001\u000bbI\u0006l7\t[1sC\u000e$XM]5{KR\u000bwm\u001d\u000b\u0003\u0003SAq!!?\u0001\t\u0003\tY0A\rbI\u0006l7\t[1sC\u000e$XM]5{KR\u000bwMV1mk\u0016\u001cH\u0003BA\u007f\u0005\u0013\u0001rAVA\u0000\u0005\u0007\ti#C\u0002\u0003\u0002m\u00131!T1q!\rI$QA\u0005\u0004\u0005\u000fQ$aA!os\"9!1BA|\u0001\u0004)\u0016a\u0001;bO\"9!q\u0002\u0001\u0005\u0002\tE\u0011\u0001G1eC64\u0015\u000e\u001c;feJ+7m\u001c:eg^KG\u000f\u001b+bOR\u00191Da\u0005\t\u000f\tU!Q\u0002a\u0001+\u00069A/Y4OC6,\u0007b\u0002B\r\u0001\u0011\u0005!1D\u0001\u000eC\u0012\fW\u000e\u0016:j[J+\u0017\rZ:\u0015\u000fm\u0011iB!\t\u0003&!A!q\u0004B\f\u0001\u0004\t9$A\u0005ue&l7\u000b^1si\"A!1\u0005B\f\u0001\u0004\t9$A\u0004ue&lWI\u001c3\t\u0013\t\u001d\"q\u0003I\u0001\u0002\u0004)\u0016!\u0003:fC\u0012<%o\\;q\u0011\u001d\u0011Y\u0003\u0001C\u0001\u0005[\tA$\u00193b[R\u0013\u0018.\u001c'poF+\u0018\r\\5usJ+\u0017\rZ$s_V\u00048\u000fF\u0002\u001c\u0005_A!B!\r\u0003*A\u0005\t\u0019AA\u001c\u00039\u0001\bN]3e)\"\u0014Xm\u001d5pY\u0012DqA!\u000e\u0001\t\u0003\u00119$A\u000bbI\u0006l7+\u0019<f\u0003N\u0004\u0016-\u001b:fI\u001a\u000b7\u000f^9\u0015\u0013}\u0013ID!\u0010\u0003B\t-\u0003b\u0002B\u001e\u0005g\u0001\r!V\u0001\nM&dWMT1nKFBqAa\u0010\u00034\u0001\u0007Q+A\u0005gS2,g*Y7fe!Q!1\tB\u001a!\u0003\u0005\rA!\u0012\u0002)Y\fG.\u001b3bi&|gn\u0015;sS:<WM\\2z!\u0011\t)Ba\u0012\n\t\t%\u0013q\u0003\u0002\u0015-\u0006d\u0017\u000eZ1uS>t7\u000b\u001e:j]\u001e,gnY=\t\u0015\t5#1\u0007I\u0001\u0002\u0004\u0011y%\u0001\u0007qKJ\u001c\u0018n\u001d;MKZ,G\u000eE\u0003:\u0003{\u0012\t\u0006\u0005\u0003\u0003T\teSB\u0001B+\u0015\r\u00119FH\u0001\bgR|'/Y4f\u0013\u0011\u0011YF!\u0016\u0003\u0019M#xN]1hK2+g/\u001a7\t\u000f\t}\u0003\u0001\"\u0001\u0003b\u0005y\u0011\rZ1n'\u00064X-Q:GCN$\u0018\u000fF\u0006`\u0005G\u00129Ga\u001b\u0003p\tE\u0004b\u0002B3\u0005;\u0002\r!V\u0001\tM&dWMT1nK\"Q!\u0011\u000eB/!\u0003\u0005\r!a\u001f\u0002\u0019\u0019LG.\u001a(b[\u0016\u0014t\n\u001d;\t\u0013\t5$Q\fI\u0001\u0002\u0004A\u0014\u0001B:peRD!Ba\u0011\u0003^A\u0005\t\u0019\u0001B#\u0011)\u0011iE!\u0018\u0011\u0002\u0003\u0007!q\n\u0005\n\u0005k\u0002\u0011\u0013!C\u0001\u0005o\nQ#\u00193b[N\u000bUjU1wK\u0012\"WMZ1vYR$#'\u0006\u0002\u0003z)\u001a\u0001Ha\u001f,\u0005\tu\u0004\u0003\u0002B@\u0005\u0013k!A!!\u000b\t\t\r%QQ\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\";\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0017\u0013\tIA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011Ba$\u0001#\u0003%\tA!%\u00023\u0005$\u0017-\\*bm\u0016\f5OR1tiF$C-\u001a4bk2$HEM\u000b\u0003\u0005'SC!a\u001f\u0003|!I!q\u0013\u0001\u0012\u0002\u0013\u0005!qO\u0001\u001aC\u0012\fWnU1wK\u0006\u001bh)Y:uc\u0012\"WMZ1vYR$3\u0007C\u0005\u0003\u001c\u0002\t\n\u0011\"\u0001\u0003\u001e\u0006I\u0012\rZ1n'\u00064X-Q:GCN$\u0018\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011yJ\u000b\u0003\u0003F\tm\u0004\"\u0003BR\u0001E\u0005I\u0011\u0001BS\u0003e\tG-Y7TCZ,\u0017i\u001d$bgR\fH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t\u001d&\u0006\u0002B(\u0005wB\u0011Ba+\u0001#\u0003%\tA!%\u0002%\u0005$\u0017-\u001c\"R'J#C-\u001a4bk2$HE\r\u0005\n\u0005_\u0003\u0011\u0013!C\u0001\u0005c\u000b1$\u00193b[J+\u0017\r\\5h]&sG-\u001a7tI\u0011,g-Y;mi\u0012\nTC\u0001BZU\u0011\tYIa\u001f\t\u0013\t]\u0006!%A\u0005\u0002\t]\u0014aG1eC6\u0014V-\u00197jO:Le\u000eZ3mg\u0012\"WMZ1vYR$#\u0007C\u0005\u0003<\u0002\t\n\u0011\"\u0001\u0003>\u0006Y\u0012\rZ1n%\u0016\fG.[4o\u0013:$W\r\\:%I\u00164\u0017-\u001e7uIM*\"Aa0+\t\u0005]\"1\u0010\u0005\n\u0005\u0007\u0004\u0011\u0013!C\u0001\u0005{\u000b1$\u00193b[J+\u0017\r\\5h]&sG-\u001a7tI\u0011,g-Y;mi\u0012\"\u0004\"\u0003Bd\u0001E\u0005I\u0011\u0001Be\u0003m\tG-Y7SK\u0006d\u0017n\u001a8J]\u0012,Gn\u001d\u0013eK\u001a\fW\u000f\u001c;%kU\u0011!1\u001a\u0016\u0005\u0003\u000f\u0012Y\bC\u0005\u0003P\u0002\t\n\u0011\"\u0001\u0003>\u0006Y\u0012\rZ1n%\u0016\fG.[4o\u0013:$W\r\\:%I\u00164\u0017-\u001e7uIYB\u0011Ba5\u0001#\u0003%\tAa\u001e\u00029\u0005$\u0017-\u001c*fG>\u0014Hm\u001d\u001aQS2,W\u000f\u001d\u0013eK\u001a\fW\u000f\u001c;%c!I!q\u001b\u0001\u0012\u0002\u0013\u0005!QX\u0001\u001bC\u0012\fWNU3d_J$7O\r*pIN$C-\u001a4bk2$H%\r\u0005\n\u00057\u0004\u0011\u0013!C\u0001\u0005o\n!$\u00193b[J+7m\u001c:egJ\u0012v\u000eZ:%I\u00164\u0017-\u001e7uIIB\u0011Ba8\u0001#\u0003%\tA!9\u0002/\u0005$\u0017-\u001c+sS6\u0014V-\u00193tI\u0011,g-Y;mi\u0012\u001aTC\u0001BrU\r)&1\u0010\u0005\n\u0005O\u0004\u0011\u0013!C\u0001\u0005{\u000ba%\u00193b[R\u0013\u0018.\u001c'poF+\u0018\r\\5usJ+\u0017\rZ$s_V\u00048\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0011%\u0011Y\u000fAI\u0001\n\u0003\u0011i*A\u0010bI\u0006l7+\u0019<f\u0003N\u0004\u0016-\u001b:fI\u001a\u000b7\u000f^9%I\u00164\u0017-\u001e7uIMB\u0011Ba<\u0001#\u0003%\tA!*\u0002?\u0005$\u0017-\\*bm\u0016\f5\u000fU1je\u0016$g)Y:uc\u0012\"WMZ1vYR$C\u0007")
public class AlignmentRecordRDDFunctions
extends ADAMSequenceDictionaryRDDAggregator<AlignmentRecord> {
    private final RDD<AlignmentRecord> rdd;

    public RDD<AlignmentRecord> filterByOverlappingRegion(ReferenceRegion query) {
        return this.rdd.filter((Function1)new Serializable(this, query){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AlignmentRecordRDDFunctions $outer;
            private final ReferenceRegion query$1;

            public final boolean apply(AlignmentRecord rec) {
                return this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$overlapsQuery$1(rec, this.query$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.query$1 = query$1;
            }
        });
    }

    public boolean maybeSaveBam(ADAMSaveArgs args) {
        boolean bl;
        if (args.outputPath().endsWith(".sam")) {
            this.log().info("Saving data in SAM format");
            AlignmentRecordRDDFunctions qual$1 = AlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(this.rdd);
            String x$26 = args.outputPath();
            boolean x$27 = qual$1.adamSAMSave$default$2();
            qual$1.adamSAMSave(x$26, x$27);
            bl = true;
        } else if (args.outputPath().endsWith(".bam")) {
            this.log().info("Saving data in BAM format");
            AlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(this.rdd).adamSAMSave(args.outputPath(), false);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean maybeSaveFastq(ADAMSaveAnyArgs args) {
        boolean bl;
        if (args.outputPath().endsWith(".fq") || args.outputPath().endsWith(".fastq") || args.outputPath().endsWith(".ifq")) {
            AlignmentRecordRDDFunctions qual$2 = AlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(this.rdd);
            String x$28 = args.outputPath();
            boolean x$29 = args.sortFastqOutput();
            Option<String> x$30 = qual$2.adamSaveAsFastq$default$2();
            ValidationStringency x$31 = qual$2.adamSaveAsFastq$default$4();
            Option<StorageLevel> x$32 = qual$2.adamSaveAsFastq$default$5();
            qual$2.adamSaveAsFastq(x$28, x$30, x$29, x$31, x$32);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean adamAlignedRecordSave(ADAMSaveArgs args) {
        if (this.maybeSaveBam(args)) return true;
        ADAMContext$.MODULE$.rddToADAMRDD(this.rdd, Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(AlignmentRecord.class)).adamParquetSave(args);
        if (!true) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean adamSave(ADAMSaveAnyArgs args) {
        if (this.maybeSaveBam(args)) return true;
        if (this.maybeSaveFastq(args)) return true;
        ADAMContext$.MODULE$.rddToADAMRDD(this.rdd, Predef$.MODULE$.conforms(), ManifestFactory$.MODULE$.classType(AlignmentRecord.class)).adamParquetSave(args);
        if (!true) return false;
        return true;
    }

    public String adamSAMString() {
        Tuple2<RDD<SAMRecordWritable>, SAMFileHeader> tuple2 = AlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(this.rdd).adamConvertToSAM();
        if (tuple2 != null) {
            RDD convertRecords = (RDD)tuple2._1();
            SAMFileHeader header2 = (SAMFileHeader)tuple2._2();
            if (convertRecords != null) {
                RDD rDD = convertRecords;
                if (header2 != null) {
                    Tuple2 tuple22;
                    SAMFileHeader sAMFileHeader = header2;
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)rDD, (Object)sAMFileHeader);
                    RDD convertRecords2 = (RDD)tuple23._1();
                    SAMFileHeader header3 = (SAMFileHeader)tuple23._2();
                    int x$33 = 1;
                    boolean x$34 = true;
                    Ordering x$35 = convertRecords2.coalesce$default$3(x$33, x$34);
                    SAMRecordWritable[] records = (SAMRecordWritable[])convertRecords2.coalesce(x$33, x$34, x$35).collect();
                    SAMTextHeaderCodec samHeaderCodec = new SAMTextHeaderCodec();
                    samHeaderCodec.setValidationStringency(ValidationStringency.SILENT);
                    StringWriter samStringWriter = new StringWriter();
                    samHeaderCodec.encode((Writer)samStringWriter, header3);
                    SAMTextWriter samWriter = new SAMTextWriter((Writer)samStringWriter);
                    Predef$.MODULE$.refArrayOps((Object[])records).foreach((Function1)new Serializable(this, samWriter){
                        public static final long serialVersionUID = 0L;
                        private final SAMTextWriter samWriter$1;

                        public final void apply(SAMRecordWritable record) {
                            this.samWriter$1.writeAlignment(record.get());
                        }
                        {
                            this.samWriter$1 = samWriter$1;
                        }
                    });
                    return samStringWriter.toString();
                }
            }
        }
        throw new MatchError(tuple2);
    }

    public void adamSAMSave(String filePath, boolean asSam) {
        Tuple2<RDD<SAMRecordWritable>, SAMFileHeader> tuple2;
        block2: {
            boolean bl;
            block5: {
                boolean bl2;
                block8: {
                    block7: {
                        Configuration conf;
                        RDD withKey;
                        block6: {
                            block4: {
                                SAMFileHeader header2;
                                block3: {
                                    Tuple2 tuple22;
                                    tuple2 = AlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(this.rdd).adamConvertToSAM();
                                    if (tuple2 == null) break block2;
                                    RDD convertRecords = (RDD)tuple2._1();
                                    SAMFileHeader header3 = (SAMFileHeader)tuple2._2();
                                    if (convertRecords == null) break block2;
                                    RDD rDD = convertRecords;
                                    if (header3 == null) break block2;
                                    SAMFileHeader sAMFileHeader = header3;
                                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)rDD, (Object)sAMFileHeader);
                                    RDD convertRecords2 = (RDD)tuple23._1();
                                    header2 = (SAMFileHeader)tuple23._2();
                                    withKey = convertRecords2.keyBy((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final LongWritable apply(SAMRecordWritable v) {
                                            return new LongWritable((long)v.get().getAlignmentStart());
                                        }
                                    });
                                    bl = asSam;
                                    if (!bl) break block3;
                                    ADAMSAMOutputFormat$.MODULE$.addHeader(header2);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block4;
                                }
                                if (bl) break block5;
                                ADAMBAMOutputFormat$.MODULE$.addHeader(header2);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            conf = this.rdd.context().hadoopConfiguration();
                            bl2 = asSam;
                            if (!bl2) break block6;
                            SparkContext$.MODULE$.rddToPairRDDFunctions(withKey, ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(SAMRecordWritable.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms())).saveAsNewAPIHadoopFile(filePath, LongWritable.class, SAMRecordWritable.class, ADAMSAMOutputFormat.class, conf);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            break block7;
                        }
                        if (bl2) break block8;
                        SparkContext$.MODULE$.rddToPairRDDFunctions(withKey, ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(SAMRecordWritable.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms())).saveAsNewAPIHadoopFile(filePath, LongWritable.class, SAMRecordWritable.class, ADAMBAMOutputFormat.class, conf);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl2));
            }
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        throw new MatchError(tuple2);
    }

    public boolean adamSAMSave$default$2() {
        return true;
    }

    @Override
    public Set<SequenceRecord> getSequenceRecordsFromElement(AlignmentRecord elem) {
        return SequenceRecord$.MODULE$.fromADAMRecord(elem);
    }

    public RecordGroupDictionary adamGetReadGroupDictionary() {
        Seq rgNames = Predef$.MODULE$.refArrayOps((Object[])this.rdd.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<RecordGroup> apply(AlignmentRecord x$3) {
                return Option$.MODULE$.option2Iterable(RecordGroup$.MODULE$.apply(x$3));
            }
        }, ClassTag$.MODULE$.apply(RecordGroup.class)).distinct().collect()).toSeq();
        return new RecordGroupDictionary((Seq<RecordGroup>)rgNames);
    }

    public Tuple2<RDD<SAMRecordWritable>, SAMFileHeader> adamConvertToSAM() {
        SequenceDictionary sd = AlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(this.rdd).adamGetSequenceDictionary();
        RecordGroupDictionary rgd = AlignmentRecordContext$.MODULE$.rddToADAMRecordRDD(this.rdd).adamGetReadGroupDictionary();
        AlignmentRecordConverter adamRecordConverter = new AlignmentRecordConverter();
        SAMFileHeader header2 = adamRecordConverter.createSAMHeader(sd, rgd);
        Broadcast hdrBcast = this.rdd.context().broadcast((Object)SAMFileHeaderWritable$.MODULE$.apply(header2), ClassTag$.MODULE$.apply(SAMFileHeaderWritable.class));
        RDD convertedRDD = this.rdd.map((Function1)new Serializable(this, adamRecordConverter, hdrBcast){
            public static final long serialVersionUID = 0L;
            private final AlignmentRecordConverter adamRecordConverter$1;
            private final Broadcast hdrBcast$1;

            /*
             * WARNING - void declaration
             */
            public final SAMRecordWritable apply(AlignmentRecord r) {
                void var2_2;
                SAMRecordWritable srw = new SAMRecordWritable();
                srw.set(this.adamRecordConverter$1.convert(r, (SAMFileHeaderWritable)this.hdrBcast$1.value()));
                return var2_2;
            }
            {
                this.adamRecordConverter$1 = adamRecordConverter$1;
                this.hdrBcast$1 = hdrBcast$1;
            }
        }, ClassTag$.MODULE$.apply(SAMRecordWritable.class));
        return new Tuple2((Object)convertedRDD, (Object)header2);
    }

    public RDD<Tuple2<String, Object>> adamCountKmers(int kmerLength) {
        return SparkContext$.MODULE$.rddToPairRDDFunctions(this.rdd.flatMap((Function1)new Serializable(this, kmerLength){
            public static final long serialVersionUID = 0L;
            private final int kmerLength$1;

            public final Iterator<Tuple2<String, Object>> apply(AlignmentRecord r) {
                return new StringOps(Predef$.MODULE$.augmentString(r.getSequence().toString())).sliding(this.kmerLength$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, Object> apply(String k) {
                        return new Tuple2((Object)k, (Object)BoxesRunTime.boxToLong((long)1L));
                    }
                });
            }
            {
                this.kmerLength$1 = kmerLength$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Long(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(long k1, long k2) {
                return this.apply$mcJJJ$sp(k1, k2);
            }

            public long apply$mcJJJ$sp(long k1, long k2) {
                return k1 + k2;
            }
        });
    }

    public RDD<Tuple2<String, Object>> adamCountQmers(int qmerLength) {
        return ErrorCorrection$.MODULE$.countQmers(this.rdd, qmerLength);
    }

    public RDD<AlignmentRecord> adamSortReadsByReferencePosition() {
        this.log().info("Sorting reads by reference position");
        Iterator<String> unmappedReferenceNames = new Iterator<String>(this){
            private int currentOffsetFromEnd;

            public Iterator<String> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<String> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<String> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<String> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<String, B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<String, GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<String> filter(Function1<String, Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<String, B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<String> withFilter(Function1<String, Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<String> filterNot(Function1<String, Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<String, B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, String, B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<String, B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<String> takeWhile(Function1<String, Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<String>, Iterator<String>> partition(Function1<String, Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<String>, Iterator<String>> span(Function1<String, Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<String> dropWhile(Function1<String, Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<String, B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<String, Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<String, U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<String, Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<String, Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<String> find(Function1<String, Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<String, Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<String> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size2) {
                return Iterator.class.grouped((Iterator)this, (int)size2);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size2, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size2, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<String>, Iterator<String>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<String> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<String> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<String> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<String> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<String, Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<String, B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, String, B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<String, B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, String, B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<String, B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, String, B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<String, B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, String, B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<String, B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(B z, Function2<B, String, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public <B> String min(Ordering<B> cmp) {
                return TraversableOnce.class.min((TraversableOnce)this, cmp);
            }

            public <B> String max(Ordering<B> cmp) {
                return TraversableOnce.class.max((TraversableOnce)this, cmp);
            }

            public <B> String maxBy(Function1<String, B> f, Ordering<B> cmp) {
                return TraversableOnce.class.maxBy((TraversableOnce)this, f, cmp);
            }

            public <B> String minBy(Function1<String, B> f, Ordering<B> cmp) {
                return TraversableOnce.class.minBy((TraversableOnce)this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<String> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<String> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<String> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<String> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> scala.collection.immutable.Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<String> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, String, Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<String, Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end2) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end2);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end2) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end2);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            public <A1> A1 $div$colon$bslash(A1 z, Function2<A1, A1, A1> op) {
                return (A1)GenTraversableOnce.class.$div$colon$bslash((GenTraversableOnce)this, z, op);
            }

            public int currentOffsetFromEnd() {
                return this.currentOffsetFromEnd;
            }

            public void currentOffsetFromEnd_$eq(int x$1) {
                this.currentOffsetFromEnd = x$1;
            }

            public boolean hasNext() {
                return true;
            }

            public String next() {
                this.currentOffsetFromEnd_$eq(this.currentOffsetFromEnd() + 1);
                if (this.currentOffsetFromEnd() > 10000) {
                    this.currentOffsetFromEnd_$eq(0);
                }
                return new StringBuilder().append((Object)"unmapped").append((Object)((Object)BoxesRunTime.boxToInteger((int)(Integer.MAX_VALUE - this.currentOffsetFromEnd()))).toString()).toString();
            }
            {
                GenTraversableOnce.class.$init$((GenTraversableOnce)this);
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
                this.currentOffsetFromEnd = 0;
            }
        };
        OrderedRDDFunctions qual$3 = SparkContext$.MODULE$.rddToOrderedRDDFunctions(this.rdd.map((Function1)new Serializable(this, (Iterator)unmappedReferenceNames){
            public static final long serialVersionUID = 0L;
            private final Iterator unmappedReferenceNames$1;

            public final Tuple2<ReferencePosition, AlignmentRecord> apply(AlignmentRecord p) {
                Option<ReferencePosition> option;
                block4: {
                    ReferencePosition referencePosition2;
                    block3: {
                        ReferencePosition pos;
                        block2: {
                            option = ReferencePosition$.MODULE$.apply(p);
                            None$ none$ = None$.MODULE$;
                            Option<ReferencePosition> option2 = option;
                            if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                            referencePosition2 = new ReferencePosition((String)this.unmappedReferenceNames$1.next(), Long.MAX_VALUE);
                            break block3;
                        }
                        if (!(option instanceof Some)) break block4;
                        Some some = (Some)option;
                        referencePosition2 = pos = (ReferencePosition)some.x();
                    }
                    ReferencePosition referencePos = referencePosition2;
                    return new Tuple2((Object)referencePos, (Object)p);
                }
                throw new MatchError(option);
            }
            {
                this.unmappedReferenceNames$1 = unmappedReferenceNames$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms()), ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(AlignmentRecord.class));
        boolean x$36 = qual$3.sortByKey$default$1();
        int x$37 = qual$3.sortByKey$default$2();
        return qual$3.sortByKey(x$36, x$37).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final AlignmentRecord apply(Tuple2<ReferencePosition, AlignmentRecord> p) {
                return (AlignmentRecord)p._2();
            }
        }, ClassTag$.MODULE$.apply(AlignmentRecord.class));
    }

    public RDD<AlignmentRecord> adamMarkDuplicates() {
        return MarkDuplicates$.MODULE$.apply(this.rdd);
    }

    public RDD<AlignmentRecord> adamBQSR(Broadcast<SnpTable> knownSnps, Option<String> observationDumpFile) {
        return BaseQualityRecalibration$.MODULE$.apply(this.rdd, knownSnps, observationDumpFile);
    }

    public Option<String> adamBQSR$default$2() {
        return None$.MODULE$;
    }

    public RDD<AlignmentRecord> adamRealignIndels(ConsensusGenerator consensusModel, boolean isSorted, int maxIndelSize, int maxConsensusNumber, double lodThreshold, int maxTargetSize) {
        return RealignIndels$.MODULE$.apply(this.rdd, consensusModel, isSorted, maxIndelSize, maxConsensusNumber, lodThreshold, RealignIndels$.MODULE$.apply$default$7());
    }

    public ConsensusGenerator adamRealignIndels$default$1() {
        return new ConsensusGeneratorFromReads();
    }

    public boolean adamRealignIndels$default$2() {
        return false;
    }

    public int adamRealignIndels$default$3() {
        return 500;
    }

    public int adamRealignIndels$default$4() {
        return 30;
    }

    public double adamRealignIndels$default$5() {
        return 5.0;
    }

    public int adamRealignIndels$default$6() {
        return 3000;
    }

    public Tuple2<FlagStatMetrics, FlagStatMetrics> adamFlagStat() {
        return FlagStat$.MODULE$.apply(this.rdd);
    }

    public RDD<SingleReadBucket> adamSingleReadBuckets() {
        return SingleReadBucket$.MODULE$.apply(this.rdd);
    }

    public RDD<Pileup> adamRecords2Pileup(boolean secondaryAlignments) {
        Reads2PileupProcessor helper = new Reads2PileupProcessor(secondaryAlignments);
        return helper.process(this.rdd);
    }

    public boolean adamRecords2Pileup$default$1() {
        return false;
    }

    public RDD<Rod> adamRecords2Rods(int bucketSize, boolean secondaryAlignments) {
        RDD bucketedReads = SparkContext$.MODULE$.rddToPairRDDFunctions(this.rdd.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AlignmentRecord x$4) {
                return x$4.getStart() != null;
            }
        }).flatMap((Function1)new Serializable(this, bucketSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AlignmentRecordRDDFunctions $outer;
            private final int bucketSize$1;

            public final List<Tuple2<ReferencePosition, AlignmentRecord>> apply(AlignmentRecord r) {
                return this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$mapToBucket$1(r, this.bucketSize$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.bucketSize$1 = bucketSize$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(ReferencePosition.class), ClassTag$.MODULE$.apply(AlignmentRecord.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.conforms())).groupByKey();
        Reads2PileupProcessor pp = new Reads2PileupProcessor(secondaryAlignments);
        return bucketedReads.flatMap((Function1)new Serializable(this, pp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AlignmentRecordRDDFunctions $outer;
            private final Reads2PileupProcessor pp$1;

            public final Iterable<Rod> apply(Tuple2<ReferencePosition, Iterable<AlignmentRecord>> bucket) {
                return this.$outer.org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$bucketedReadsToRods$1(bucket, this.pp$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.pp$1 = pp$1;
            }
        }, ClassTag$.MODULE$.apply(Rod.class));
    }

    public int adamRecords2Rods$default$1() {
        return 1000;
    }

    public boolean adamRecords2Rods$default$2() {
        return false;
    }

    public RDD<Tuple2<String, Object>> adamCharacterizeTags() {
        return SparkContext$.MODULE$.rddToPairRDDFunctions(this.rdd.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Tuple2<String, Object>> apply(AlignmentRecord x$6) {
                return (Seq)RichAlignmentRecord$.MODULE$.apply(x$6).tags().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, Object> apply(Attribute attr) {
                        return new Tuple2((Object)attr.tag(), (Object)BoxesRunTime.boxToLong((long)1L));
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Long(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(long x$7, long x$8) {
                return this.apply$mcJJJ$sp(x$7, x$8);
            }

            public long apply$mcJJJ$sp(long x$7, long x$8) {
                return x$7 + x$8;
            }
        });
    }

    public scala.collection.immutable.Map<Object, Object> adamCharacterizeTagValues(String tag) {
        return (scala.collection.immutable.Map)this.adamFilterRecordsWithTag(tag).flatMap((Function1)new Serializable(this, tag){
            public static final long serialVersionUID = 0L;
            public final String tag$1;

            public final Iterable<Attribute> apply(AlignmentRecord x$9) {
                return Option$.MODULE$.option2Iterable(RichAlignmentRecord$.MODULE$.apply(x$9).tags().find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$adamCharacterizeTagValues$1 $outer;

                    public final boolean apply(Attribute x$10) {
                        String string = x$10.tag();
                        String string2 = this.$outer.tag$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.tag$1 = tag$1;
            }
        }, ClassTag$.MODULE$.apply(Attribute.class)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<Object, Object> apply(Attribute attr) {
                return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(attr.value()), (Object)BoxesRunTime.boxToLong((long)1L))}));
            }
        }, ClassTag$.MODULE$.apply(scala.collection.immutable.Map.class)).reduce((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Map<Object, Object> apply(scala.collection.immutable.Map<Object, Object> map1, scala.collection.immutable.Map<Object, Object> map2) {
                return MapTools$.MODULE$.add(map1, map2, Numeric.LongIsIntegral$.MODULE$);
            }
        });
    }

    public RDD<AlignmentRecord> adamFilterRecordsWithTag(String tagName) {
        Predef$.MODULE$.assert(tagName.length() == 2, (Function0)new Serializable(this, tagName){
            public static final long serialVersionUID = 0L;
            private final String tagName$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("withAttribute takes a tagName argument of length 2; tagName=\"%s\"")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tagName$1}));
            }
            {
                this.tagName$1 = tagName$1;
            }
        });
        return this.rdd.filter((Function1)new Serializable(this, tagName){
            public static final long serialVersionUID = 0L;
            public final String tagName$1;

            public final boolean apply(AlignmentRecord x$11) {
                return RichAlignmentRecord$.MODULE$.apply(x$11).tags().exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$adamFilterRecordsWithTag$2 $outer;

                    public final boolean apply(Attribute x$12) {
                        String string = x$12.tag();
                        String string2 = this.$outer.tagName$1;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.tagName$1 = tagName$1;
            }
        });
    }

    public RDD<AlignmentRecord> adamTrimReads(int trimStart, int trimEnd, String readGroup) {
        return TrimReads$.MODULE$.apply(this.rdd, trimStart, trimEnd, readGroup);
    }

    public String adamTrimReads$default$3() {
        return null;
    }

    public RDD<AlignmentRecord> adamTrimLowQualityReadGroups(int phredThreshold) {
        return TrimReads$.MODULE$.apply(this.rdd, phredThreshold);
    }

    public int adamTrimLowQualityReadGroups$default$1() {
        return 20;
    }

    public void adamSaveAsPairedFastq(String fileName1, String fileName2, ValidationStringency validationStringency, Option<StorageLevel> persistLevel) {
        this.maybePersist$1(this.rdd, persistLevel);
        long numRecords = this.rdd.count();
        RDD readsByID = this.rdd.groupBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(AlignmentRecord record) {
                return AlignmentRecordConverter$.MODULE$.readNameHasPairedSuffix(record) ? (String)new StringOps(Predef$.MODULE$.augmentString(record.getReadName().toString())).dropRight(2) : record.getReadName().toString();
            }
        }, ClassTag$.MODULE$.apply(String.class));
        ValidationStringency validationStringency2 = validationStringency;
        ValidationStringency validationStringency3 = ValidationStringency.STRICT;
        if (!(validationStringency2 != null ? !validationStringency2.equals(validationStringency3) : validationStringency3 != null)) {
            RDD readIDsWithCounts = SparkContext$.MODULE$.rddToPairRDDFunctions(readsByID, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Iterable.class), (Ordering)Ordering.String$.MODULE$).mapValues((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Iterable<AlignmentRecord> x$15) {
                    return x$15.size();
                }
            });
            RDD unpairedReadIDsWithCounts = readIDsWithCounts.filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, Object> x$16) {
                    return x$16._2$mcI$sp() != 2;
                }
            });
            this.maybePersist$1(unpairedReadIDsWithCounts, persistLevel);
            long numUnpairedReadIDsWithCounts = unpairedReadIDsWithCounts.count();
            if (numUnpairedReadIDsWithCounts != 0L) {
                Map readNameOccurrencesMap = unpairedReadIDsWithCounts.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple2<String, Object> x$17) {
                        return x$17._2$mcI$sp();
                    }
                }, ClassTag$.MODULE$.Int()).countByValue((Ordering)Ordering.Int$.MODULE$);
                throw new Exception(new StringOps(Predef$.MODULE$.augmentString("Found %d read names that don't occur exactly twice:\n%s\n\nSamples:\n%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numUnpairedReadIDsWithCounts), ((TraversableOnce)readNameOccurrencesMap.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<Object, Object> p) {
                        return new StringOps(Predef$.MODULE$.augmentString("%dx:\t%d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)p._1$mcI$sp()), BoxesRunTime.boxToLong((long)p._2$mcJ$sp())}));
                    }
                }, Iterable$.MODULE$.canBuildFrom())).mkString("\t", "\n\t", ""), Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])unpairedReadIDsWithCounts.take(100)).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<String, Object> x$18) {
                        return (String)x$18._1();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("\t", "\n\t", "")})));
            }
        }
        RDD pairedRecords = readsByID.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Iterable<AlignmentRecord>> x$19) {
                return ((TraversableOnce)x$19._2()).size() == 2;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<AlignmentRecord> apply(Tuple2<String, Iterable<AlignmentRecord>> x$20) {
                return (Iterable)x$20._2();
            }
        }, ClassTag$.MODULE$.apply(Iterable.class)).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<AlignmentRecord> apply(Iterable<AlignmentRecord> x) {
                return x;
            }
        }, ClassTag$.MODULE$.apply(AlignmentRecord.class));
        this.maybePersist$1(pairedRecords, persistLevel);
        long numPairedRecords = pairedRecords.count();
        this.maybeUnpersist$1(this.rdd.unpersist(this.rdd.unpersist$default$1()), persistLevel);
        RDD firstInPairRecords = pairedRecords.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AlignmentRecord x$21) {
                return Predef$.MODULE$.Boolean2boolean(x$21.getFirstOfPair());
            }
        });
        this.maybePersist$1(firstInPairRecords, persistLevel);
        long numFirstInPairRecords = firstInPairRecords.count();
        RDD secondInPairRecords = pairedRecords.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(AlignmentRecord x$22) {
                return Predef$.MODULE$.Boolean2boolean(x$22.getSecondOfPair());
            }
        });
        this.maybePersist$1(secondInPairRecords, persistLevel);
        long numSecondInPairRecords = secondInPairRecords.count();
        this.maybeUnpersist$1(pairedRecords, persistLevel);
        this.log().info(new StringOps(Predef$.MODULE$.augmentString("%d/%d records are properly paired: %d firsts, %d seconds")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numPairedRecords), BoxesRunTime.boxToLong((long)numRecords), BoxesRunTime.boxToLong((long)numFirstInPairRecords), BoxesRunTime.boxToLong((long)numSecondInPairRecords)})));
        ValidationStringency validationStringency4 = validationStringency;
        ValidationStringency validationStringency5 = ValidationStringency.STRICT;
        if (!(validationStringency4 != null ? !validationStringency4.equals(validationStringency5) : validationStringency5 != null)) {
            firstInPairRecords.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(AlignmentRecord read) {
                    if (Predef$.MODULE$.Boolean2boolean(read.getSecondOfPair())) {
                        throw new Exception(new StringOps(Predef$.MODULE$.augmentString("Read %s found with first- and second-of-pair set")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{read.getReadName()})));
                    }
                }
            });
            secondInPairRecords.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(AlignmentRecord read) {
                    if (Predef$.MODULE$.Boolean2boolean(read.getFirstOfPair())) {
                        throw new Exception(new StringOps(Predef$.MODULE$.augmentString("Read %s found with first- and second-of-pair set")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{read.getReadName()})));
                    }
                }
            });
        }
        Predef$.MODULE$.assert(numFirstInPairRecords == numSecondInPairRecords, (Function0)new Serializable(this, numFirstInPairRecords, numSecondInPairRecords){
            public static final long serialVersionUID = 0L;
            private final long numFirstInPairRecords$1;
            private final long numSecondInPairRecords$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Different numbers of first- and second-reads: %d vs. %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.numFirstInPairRecords$1), BoxesRunTime.boxToLong((long)this.numSecondInPairRecords$1)}));
            }
            {
                this.numFirstInPairRecords$1 = numFirstInPairRecords$1;
                this.numSecondInPairRecords$1 = numSecondInPairRecords$1;
            }
        });
        AlignmentRecordConverter arc = new AlignmentRecordConverter();
        firstInPairRecords.sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(AlignmentRecord x$23) {
                return x$23.getReadName().toString();
            }
        }, firstInPairRecords.sortBy$default$2(), firstInPairRecords.sortBy$default$3(), (Ordering)Ordering.String$.MODULE$, ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(this, arc){
            public static final long serialVersionUID = 0L;
            private final AlignmentRecordConverter arc$1;

            public final String apply(AlignmentRecord record) {
                return this.arc$1.convertToFastq(record, true);
            }
            {
                this.arc$1 = arc$1;
            }
        }, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(fileName1);
        secondInPairRecords.sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(AlignmentRecord x$24) {
                return x$24.getReadName().toString();
            }
        }, secondInPairRecords.sortBy$default$2(), secondInPairRecords.sortBy$default$3(), (Ordering)Ordering.String$.MODULE$, ClassTag$.MODULE$.apply(String.class)).map((Function1)new Serializable(this, arc){
            public static final long serialVersionUID = 0L;
            private final AlignmentRecordConverter arc$1;

            public final String apply(AlignmentRecord record) {
                return this.arc$1.convertToFastq(record, true);
            }
            {
                this.arc$1 = arc$1;
            }
        }, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(fileName2);
        this.maybeUnpersist$1(firstInPairRecords, persistLevel);
        this.maybeUnpersist$1(secondInPairRecords, persistLevel);
    }

    public ValidationStringency adamSaveAsPairedFastq$default$3() {
        return ValidationStringency.LENIENT;
    }

    public Option<StorageLevel> adamSaveAsPairedFastq$default$4() {
        return None$.MODULE$;
    }

    public void adamSaveAsFastq(String fileName, Option<String> fileName2Opt, boolean sort, ValidationStringency validationStringency, Option<StorageLevel> persistLevel) {
        this.log().info("Saving data in FASTQ format.");
        Option<String> option = fileName2Opt;
        if (option instanceof Some) {
            Some some = (Some)option;
            String fileName2 = (String)some.x();
            this.adamSaveAsPairedFastq(fileName, fileName2, validationStringency, persistLevel);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            AlignmentRecordConverter arc = new AlignmentRecordConverter();
            RDD outputRdd = sort || fileName2Opt.isDefined() ? this.rdd.sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(AlignmentRecord x$25) {
                    return x$25.getReadName().toString();
                }
            }, this.rdd.sortBy$default$2(), this.rdd.sortBy$default$3(), (Ordering)Ordering.String$.MODULE$, ClassTag$.MODULE$.apply(String.class)) : this.rdd;
            outputRdd.map((Function1)new Serializable(this, arc){
                public static final long serialVersionUID = 0L;
                private final AlignmentRecordConverter arc$2;

                public final String apply(AlignmentRecord record) {
                    return this.arc$2.convertToFastq(record, this.arc$2.convertToFastq$default$2());
                }
                {
                    this.arc$2 = arc$2;
                }
            }, ClassTag$.MODULE$.apply(String.class)).saveAsTextFile(fileName);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Option<String> adamSaveAsFastq$default$2() {
        return None$.MODULE$;
    }

    public boolean adamSaveAsFastq$default$3() {
        return false;
    }

    public ValidationStringency adamSaveAsFastq$default$4() {
        return ValidationStringency.LENIENT;
    }

    public Option<StorageLevel> adamSaveAsFastq$default$5() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$overlapsQuery$1(AlignmentRecord rec, ReferenceRegion query$1) {
        if (!Predef$.MODULE$.Boolean2boolean(rec.getReadMapped())) return false;
        String string = rec.getContig().getContigName().toString();
        String string2 = query$1.referenceName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (Predef$.MODULE$.Long2long(rec.getStart()) >= query$1.end()) return false;
        if (Predef$.MODULE$.Long2long(rec.getEnd()) <= query$1.start()) return false;
        return true;
    }

    public final List org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$mapToBucket$1(AlignmentRecord r, int bucketSize$1) {
        long s = Predef$.MODULE$.Long2long(r.getStart()) / (long)bucketSize$1;
        long e = Predef$.MODULE$.Long2long(r.getEnd()) / (long)bucketSize$1;
        String name2 = r.getContig().getContigName();
        return s == e ? List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new ReferencePosition(name2, s), (Object)r)})) : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new ReferencePosition(name2, s), (Object)r), new Tuple2((Object)new ReferencePosition(name2, e), (Object)r)}));
    }

    public final Iterable org$bdgenomics$adam$rdd$read$AlignmentRecordRDDFunctions$$bucketedReadsToRods$1(Tuple2 bucket, Reads2PileupProcessor pp$1) {
        Tuple2 tuple2 = bucket;
        if (tuple2 != null) {
            Iterable bucketReads;
            Iterable iterable;
            Iterable bucketReads2 = iterable = (bucketReads = (Iterable)tuple2._2());
            return ((scala.collection.immutable.Seq)((TraversableLike)bucketReads2.flatMap((Function1)new Serializable(this, pp$1){
                public static final long serialVersionUID = 0L;
                private final Reads2PileupProcessor pp$1;

                public final List<Pileup> apply(AlignmentRecord record) {
                    return this.pp$1.readToPileups(record);
                }
                {
                    this.pp$1 = pp$1;
                }
            }, Iterable$.MODULE$.canBuildFrom())).groupBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final ReferencePosition apply(Pileup x$5) {
                    return ReferencePosition$.MODULE$.apply(x$5);
                }
            }).toList().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Rod apply(Tuple2<ReferencePosition, Iterable<Pileup>> g) {
                    return new Rod((ReferencePosition)g._1(), (List<Pileup>)((TraversableOnce)g._2()).toList());
                }
            }, List$.MODULE$.canBuildFrom())).toSeq();
        }
        throw new MatchError((Object)tuple2);
    }

    private final void maybePersist$1(RDD r, Option persistLevel$1) {
        persistLevel$1.foreach((Function1)new Serializable(this, r){
            public static final long serialVersionUID = 0L;
            private final RDD r$1;

            public final RDD<T> apply(StorageLevel x$13) {
                return this.r$1.persist(x$13);
            }
            {
                this.r$1 = r$1;
            }
        });
    }

    private final void maybeUnpersist$1(RDD r, Option persistLevel$1) {
        persistLevel$1.foreach((Function1)new Serializable(this, r){
            public static final long serialVersionUID = 0L;
            private final RDD r$2;

            public final RDD<T> apply(StorageLevel x$14) {
                return this.r$2.unpersist(this.r$2.unpersist$default$1());
            }
            {
                this.r$2 = r$2;
            }
        });
    }

    public AlignmentRecordRDDFunctions(RDD<AlignmentRecord> rdd) {
        this.rdd = rdd;
        super(rdd);
    }
}

